/*
 * Decompiled with CFR 0.152.
 */
package carpet.settings;

import carpet.settings.Rule;
import carpet.settings.SettingsManager;
import carpet.settings.Validator;
import carpet.utils.Messenger;
import carpet.utils.Translations;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.minecraft.class_2168;

public final class ParsedRule<T>
implements Comparable<ParsedRule> {
    public final Field field;
    public final String name;
    public final String description;
    public final String scarpetApp;
    public final ImmutableList<String> extraInfo;
    public final ImmutableList<String> categories;
    public final ImmutableList<String> options;
    public boolean isStrict;
    public boolean isClient;
    public final Class<T> type;
    public final List<Validator<T>> validators;
    public final T defaultValue;
    public final String defaultAsString;
    public final SettingsManager settingsManager;
    private static final Set<Class<?>> NUMBER_CLASSES = Sets.newHashSet((Object[])new Class[]{Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE});

    ParsedRule(Field field, Rule rule, SettingsManager settingsManager) {
        this.field = field;
        this.name = rule.name().isEmpty() ? field.getName() : rule.name();
        this.type = field.getType();
        this.description = rule.desc();
        this.isStrict = rule.strict();
        this.extraInfo = ImmutableList.copyOf((Object[])rule.extra());
        this.categories = ImmutableList.copyOf((Object[])rule.category());
        this.scarpetApp = rule.appSource();
        this.settingsManager = settingsManager;
        this.validators = new ArrayList<Validator<T>>();
        for (Class<? extends Validator> v : rule.validate()) {
            this.validators.add(this.callConstructor(v));
        }
        if (this.categories.contains((Object)"command")) {
            this.validators.add(this.callConstructor(Validator._COMMAND.class));
            if (this.type == String.class) {
                this.isStrict = false;
                this.validators.add(this.callConstructor(Validator._COMMAND_LEVEL_VALIDATOR.class));
            }
        }
        if (!this.scarpetApp.isEmpty()) {
            this.validators.add(this.callConstructor(Validator._SCARPET.class));
        }
        this.isClient = this.categories.contains((Object)"client");
        if (this.isClient) {
            this.validators.add(this.callConstructor(Validator._CLIENT.class));
        }
        this.defaultValue = this.get();
        this.defaultAsString = ParsedRule.convertToString(this.defaultValue);
        this.options = rule.options().length > 0 ? ImmutableList.copyOf((Object[])rule.options()) : (this.type == Boolean.TYPE ? ImmutableList.of((Object)"true", (Object)"false") : (this.type == String.class && this.categories.contains((Object)"command") ? ImmutableList.of((Object)"true", (Object)"false", (Object)"ops") : (this.type.isEnum() ? (ImmutableList)Arrays.stream(this.type.getEnumConstants()).map(e -> ((Enum)e).name().toLowerCase(Locale.ROOT)).collect(ImmutableList.toImmutableList()) : ImmutableList.of())));
        if (this.isStrict && !this.options.isEmpty()) {
            if (this.type == Boolean.TYPE || this.type == Integer.TYPE || this.type == Double.TYPE || this.type == Float.TYPE) {
                this.validators.add(this.callConstructor(Validator._STRICT_IGNORECASE.class));
            } else {
                this.validators.add(this.callConstructor(Validator._STRICT.class));
            }
        }
    }

    private <T> T callConstructor(Class<T> cls) {
        try {
            Constructor<T> constr = cls.getDeclaredConstructor(new Class[0]);
            constr.setAccessible(true);
            return constr.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public ParsedRule<T> set(class_2168 source, String value) {
        if (this.settingsManager != null && this.settingsManager.locked) {
            return null;
        }
        if (this.type == String.class) {
            return this.set(source, value, value);
        }
        if (this.type == Boolean.TYPE) {
            return this.set(source, Boolean.parseBoolean(value), value);
        }
        if (this.type == Integer.TYPE) {
            return this.set(source, Integer.parseInt(value), value);
        }
        if (this.type == Double.TYPE) {
            return this.set(source, Double.parseDouble(value), value);
        }
        if (this.type.isEnum()) {
            String ucValue = value.toUpperCase(Locale.ROOT);
            return this.set(source, Enum.valueOf(this.type, ucValue), value);
        }
        Messenger.m(source, "r Unknown type " + this.type.getSimpleName());
        return null;
    }

    ParsedRule<T> set(class_2168 source, T value, String stringValue) {
        try {
            for (Validator<T> validator : this.validators) {
                value = validator.validate(source, this, value, stringValue);
                if (value != null) continue;
                if (source != null) {
                    Messenger.m(source, "r Wrong value for " + this.name + ": " + stringValue);
                    if (validator.description() != null) {
                        Messenger.m(source, "r " + validator.description());
                    }
                }
                return null;
            }
            if (!value.equals(this.get()) || source == null) {
                this.field.set(null, value);
                if (source != null) {
                    this.settingsManager.notifyRuleChanged(source, this, stringValue);
                }
            }
        }
        catch (IllegalAccessException e) {
            Messenger.m(source, "r Unable to access setting for  " + this.name);
            return null;
        }
        return this;
    }

    public T get() {
        try {
            return (T)this.field.get(null);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    public String getAsString() {
        return ParsedRule.convertToString(this.get());
    }

    public boolean getBoolValue() {
        if (this.type == Boolean.TYPE) {
            return (Boolean)this.get();
        }
        if (NUMBER_CLASSES.contains(this.type)) {
            return ((Number)this.get()).doubleValue() > 0.0;
        }
        return false;
    }

    public boolean isDefault() {
        return this.defaultValue.equals(this.get());
    }

    public void resetToDefault(class_2168 source) {
        this.set(source, this.defaultValue, this.defaultAsString);
    }

    private static String convertToString(Object value) {
        if (value instanceof Enum) {
            return ((Enum)value).name().toLowerCase(Locale.ROOT);
        }
        return value.toString();
    }

    public boolean equals(Object obj) {
        return obj.getClass() == ParsedRule.class && ((ParsedRule)obj).name.equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public int compareTo(ParsedRule o) {
        return this.name.compareTo(o.name);
    }

    public String toString() {
        return this.name + ": " + this.getAsString();
    }

    private String translationKey() {
        return String.format("rule.%s.name", this.name);
    }

    public String translatedName() {
        String key = this.translationKey();
        return Translations.hasTranslation(key) ? Translations.tr(key) + String.format(" (%s)", this.name) : this.name;
    }

    public String translatedDescription() {
        return Translations.tr(String.format("rule.%s.desc", this.name), this.description);
    }

    public List<String> translatedExtras() {
        if (!Translations.hasTranslations()) {
            return this.extraInfo;
        }
        String keyBase = String.format("rule.%s.extra.", this.name);
        ArrayList<String> extras = new ArrayList<String>();
        int i = 0;
        while (Translations.hasTranslation(keyBase + i)) {
            extras.add(Translations.tr(keyBase + i));
            ++i;
        }
        return extras.isEmpty() ? this.extraInfo : extras;
    }
}

