/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.language;

import carpet.script.Context;
import carpet.script.Expression;
import carpet.script.LazyValue;
import carpet.script.ScriptHost;
import carpet.script.exception.InternalExpressionException;
import carpet.script.utils.PerlinNoiseSampler;
import carpet.script.utils.SimplexNoiseSampler;
import carpet.script.value.FunctionValue;
import carpet.script.value.ListValue;
import carpet.script.value.NullValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.text.WordUtils;

public class Sys {
    public static final Random randomizer = new Random();
    private static final Pattern formatPattern = Pattern.compile("%(\\d+\\$)?([-#+ 0,(<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])");

    public static void apply(Expression expression) {
        expression.addUnaryFunction("hash_code", v -> new NumericValue(v.hashCode()));
        expression.addUnaryFunction("copy", Value::deepcopy);
        expression.addLazyFunction("bool", 1, (c, t, lv) -> {
            String str;
            Value v = ((LazyValue)lv.get(0)).evalValue((Context)c, 2);
            if (v instanceof StringValue && ("false".equalsIgnoreCase(str = v.getString()) || "null".equalsIgnoreCase(str))) {
                return (cc, tt) -> Value.FALSE;
            }
            NumericValue retval = new NumericValue(v.getBoolean());
            return (cc, tt) -> retval;
        });
        expression.addUnaryFunction("number", v -> {
            if (v instanceof NumericValue) {
                return v;
            }
            try {
                return new NumericValue(v.getString());
            }
            catch (NumberFormatException format) {
                return Value.NULL;
            }
        });
        expression.addFunction("str", lv -> {
            if (lv.size() == 0) {
                throw new InternalExpressionException("'str' requires at least one argument");
            }
            String format = ((Value)lv.get(0)).getString();
            if (lv.size() == 1) {
                return new StringValue(format);
            }
            int argIndex = 1;
            if (lv.get(1) instanceof ListValue && lv.size() == 2) {
                lv = ((ListValue)lv.get(1)).getItems();
                argIndex = 0;
            }
            ArrayList<Object> args = new ArrayList<Object>();
            Matcher m = formatPattern.matcher(format);
            int i = 0;
            int len = format.length();
            while (i < len && m.find(i)) {
                char fmt = m.group(6).toLowerCase().charAt(0);
                if (fmt == 's') {
                    if (argIndex >= lv.size()) {
                        throw new InternalExpressionException("Not enough arguments for " + m.group(0));
                    }
                    args.add(lv.get(argIndex).getString());
                    ++argIndex;
                } else if (fmt == 'd' || fmt == 'o' || fmt == 'x') {
                    if (argIndex >= lv.size()) {
                        throw new InternalExpressionException("Not enough arguments for " + m.group(0));
                    }
                    args.add(lv.get(argIndex).readInteger());
                    ++argIndex;
                } else if (fmt == 'a' || fmt == 'e' || fmt == 'f' || fmt == 'g') {
                    if (argIndex >= lv.size()) {
                        throw new InternalExpressionException("Not enough arguments for " + m.group(0));
                    }
                    args.add(lv.get(argIndex).readDoubleNumber());
                    ++argIndex;
                } else if (fmt == 'b') {
                    if (argIndex >= lv.size()) {
                        throw new InternalExpressionException("Not enough arguments for " + m.group(0));
                    }
                    args.add(lv.get(argIndex).getBoolean());
                    ++argIndex;
                } else if (fmt != '%') {
                    throw new InternalExpressionException("Format not supported: " + m.group(6));
                }
                i = m.end();
            }
            try {
                return new StringValue(String.format(Locale.ROOT, format, args.toArray()));
            }
            catch (IllegalFormatException ife) {
                throw new InternalExpressionException("Illegal string format: " + ife.getMessage());
            }
        });
        expression.addUnaryFunction("lower", v -> new StringValue(v.getString().toLowerCase(Locale.ROOT)));
        expression.addUnaryFunction("upper", v -> new StringValue(v.getString().toUpperCase(Locale.ROOT)));
        expression.addUnaryFunction("title", v -> new StringValue(WordUtils.capitalizeFully((String)v.getString())));
        expression.addFunction("replace", lv -> {
            if (lv.size() != 3 && lv.size() != 2) {
                throw new InternalExpressionException("'replace' expects string to read, pattern regex, and optional replacement string");
            }
            String data = ((Value)lv.get(0)).getString();
            String regex = ((Value)lv.get(1)).getString();
            String replacement = "";
            if (lv.size() == 3) {
                replacement = ((Value)lv.get(2)).getString();
            }
            try {
                return new StringValue(data.replaceAll(regex, replacement));
            }
            catch (PatternSyntaxException pse) {
                throw new InternalExpressionException("Incorrect pattern for 'replace': " + pse.getMessage());
            }
        });
        expression.addFunction("replace_first", lv -> {
            if (lv.size() != 3 && lv.size() != 2) {
                throw new InternalExpressionException("'replace_first' expects string to read, pattern regex, and optional replacement string");
            }
            String data = ((Value)lv.get(0)).getString();
            String regex = ((Value)lv.get(1)).getString();
            String replacement = "";
            if (lv.size() == 3) {
                replacement = ((Value)lv.get(2)).getString();
            }
            return new StringValue(data.replaceFirst(regex, replacement));
        });
        expression.addUnaryFunction("type", v -> new StringValue(v.getTypeString()));
        expression.addUnaryFunction("length", v -> new NumericValue(v.length()));
        expression.addLazyFunction("rand", -1, (c, t, lv) -> {
            Value argument;
            int argsize = lv.size();
            Random randomizer = randomizer;
            if (argsize != 1 && argsize != 2) {
                throw new InternalExpressionException("'rand' takes one (range) or two arguments (range and seed)");
            }
            if (argsize == 2) {
                randomizer = c.host.getRandom(NumericValue.asNumber(((LazyValue)lv.get(1)).evalValue((Context)c)).getLong());
            }
            if ((argument = ((LazyValue)lv.get(0)).evalValue((Context)c)) instanceof ListValue) {
                List<Value> list = ((ListValue)argument).getItems();
                Value retval = list.get(randomizer.nextInt(list.size()));
                return (cc, tt) -> retval;
            }
            if (t == 2) {
                double rv = NumericValue.asNumber(argument).getDouble() * (double)randomizer.nextFloat();
                Value retval = rv < 1.0 ? Value.FALSE : Value.TRUE;
                return (cc, tt) -> retval;
            }
            NumericValue retval = new NumericValue(NumericValue.asNumber(argument).getDouble() * randomizer.nextDouble());
            return (cc, tt) -> retval;
        });
        expression.addLazyFunction("perlin", -1, (c, t, lv) -> {
            PerlinNoiseSampler sampler;
            Value z;
            Value y;
            Value x;
            if (lv.size() >= 4) {
                x = ((LazyValue)lv.get(0)).evalValue((Context)c);
                y = ((LazyValue)lv.get(1)).evalValue((Context)c);
                z = ((LazyValue)lv.get(2)).evalValue((Context)c);
                sampler = PerlinNoiseSampler.getPerlin(NumericValue.asNumber(((LazyValue)lv.get(3)).evalValue((Context)c)).getLong());
            } else {
                sampler = PerlinNoiseSampler.instance;
                y = Value.NULL;
                z = Value.NULL;
                if (lv.size() == 0) {
                    throw new InternalExpressionException("'perlin' requires at least one dimension to sample from");
                }
                x = NumericValue.asNumber(((LazyValue)lv.get(0)).evalValue((Context)c));
                if (lv.size() > 1) {
                    y = NumericValue.asNumber(((LazyValue)lv.get(1)).evalValue((Context)c));
                    if (lv.size() > 2) {
                        z = NumericValue.asNumber(((LazyValue)lv.get(2)).evalValue((Context)c));
                    }
                }
            }
            double result = z instanceof NullValue ? (y instanceof NullValue ? sampler.sample1d(NumericValue.asNumber(x).getDouble()) : sampler.sample2d(NumericValue.asNumber(x).getDouble(), NumericValue.asNumber(y).getDouble())) : sampler.sample3d(NumericValue.asNumber(x).getDouble(), NumericValue.asNumber(y).getDouble(), NumericValue.asNumber(z).getDouble());
            NumericValue ret = new NumericValue(result);
            return (cc, tt) -> ret;
        });
        expression.addLazyFunction("simplex", -1, (c, t, lv) -> {
            SimplexNoiseSampler sampler;
            Value z;
            Value y;
            Value x;
            if (lv.size() >= 4) {
                x = ((LazyValue)lv.get(0)).evalValue((Context)c);
                y = ((LazyValue)lv.get(1)).evalValue((Context)c);
                z = ((LazyValue)lv.get(2)).evalValue((Context)c);
                sampler = SimplexNoiseSampler.getSimplex(NumericValue.asNumber(((LazyValue)lv.get(3)).evalValue((Context)c)).getLong());
            } else {
                sampler = SimplexNoiseSampler.instance;
                z = Value.NULL;
                if (lv.size() < 2) {
                    throw new InternalExpressionException("'simplex' requires at least two dimensions to sample from");
                }
                x = NumericValue.asNumber(((LazyValue)lv.get(0)).evalValue((Context)c));
                y = NumericValue.asNumber(((LazyValue)lv.get(1)).evalValue((Context)c));
                if (lv.size() > 2) {
                    z = NumericValue.asNumber(((LazyValue)lv.get(2)).evalValue((Context)c));
                }
            }
            double result = z instanceof NullValue ? sampler.sample2d(NumericValue.asNumber(x).getDouble(), NumericValue.asNumber(y).getDouble()) : sampler.sample3d(NumericValue.asNumber(x).getDouble(), NumericValue.asNumber(y).getDouble(), NumericValue.asNumber(z).getDouble());
            NumericValue ret = new NumericValue(result);
            return (cc, tt) -> ret;
        });
        expression.addUnaryFunction("print", v -> {
            System.out.println(v.getString());
            return v;
        });
        expression.addLazyFunction("time", 0, (c, t, lv) -> {
            NumericValue time = new NumericValue((double)(System.nanoTime() / 1000L) / 1000.0);
            return (cc, tt) -> time;
        });
        expression.addLazyFunction("unix_time", 0, (c, t, lv) -> {
            NumericValue time = new NumericValue(System.currentTimeMillis());
            return (cc, tt) -> time;
        });
        expression.addFunction("convert_date", lv -> {
            int argsize = lv.size();
            if (lv.size() == 0) {
                throw new InternalExpressionException("'convert_date' requires at least one parameter");
            }
            Value value = (Value)lv.get(0);
            if (argsize == 1 && !(value instanceof ListValue)) {
                GregorianCalendar cal = new GregorianCalendar(Locale.ROOT);
                cal.setTimeInMillis(NumericValue.asNumber(value, "timestamp").getLong());
                int weekday = cal.get(7) - 1;
                if (weekday == 0) {
                    weekday = 7;
                }
                ListValue retVal = ListValue.ofNums(cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), weekday, cal.get(6), cal.get(3));
                return retVal;
            }
            if (value instanceof ListValue) {
                lv = ((ListValue)value).getItems();
                argsize = lv.size();
            }
            GregorianCalendar cal = new GregorianCalendar(0, 0, 0, 0, 0, 0);
            if (argsize == 3) {
                cal.set(NumericValue.asNumber(lv.get(0)).getInt(), NumericValue.asNumber(lv.get(1)).getInt() - 1, NumericValue.asNumber(lv.get(2)).getInt());
            } else if (argsize == 6) {
                cal.set(NumericValue.asNumber(lv.get(0)).getInt(), NumericValue.asNumber(lv.get(1)).getInt() - 1, NumericValue.asNumber(lv.get(2)).getInt(), NumericValue.asNumber(lv.get(3)).getInt(), NumericValue.asNumber(lv.get(4)).getInt(), NumericValue.asNumber(lv.get(5)).getInt());
            } else {
                throw new InternalExpressionException("Date conversion requires 3 arguments for Dates or 6 arguments, for time");
            }
            return new NumericValue(cal.getTimeInMillis());
        });
        expression.addLazyFunction("profile_expr", 1, (c, t, lv) -> {
            LazyValue lazy = (LazyValue)lv.get(0);
            long end = System.nanoTime() + 50000000L;
            long it = 0L;
            while (System.nanoTime() < end) {
                lazy.evalValue((Context)c);
                ++it;
            }
            NumericValue res = new NumericValue(it);
            return (cc, tt) -> res;
        });
        expression.addLazyFunction("var", 1, (c, t, lv) -> {
            String varname = ((LazyValue)lv.get(0)).evalValue((Context)c).getString();
            return expression.getOrSetAnyVariable((Context)c, varname);
        });
        expression.addLazyFunction("undef", 1, (c, t, lv) -> {
            Value remove = ((LazyValue)lv.get(0)).evalValue((Context)c);
            if (remove instanceof FunctionValue) {
                c.host.delFunction(expression.module, remove.getString());
                return (cc, tt) -> Value.NULL;
            }
            String varname = remove.getString();
            boolean isPrefix = varname.endsWith("*");
            if (isPrefix) {
                varname = varname.replaceAll("\\*+$", "");
            }
            if (isPrefix) {
                c.host.delFunctionWithPrefix(expression.module, varname);
                if (varname.startsWith("global_")) {
                    c.host.delGlobalVariableWithPrefix(expression.module, varname);
                } else if (!varname.startsWith("_")) {
                    c.removeVariablesMatching(varname);
                }
            } else {
                c.host.delFunction(expression.module, varname);
                if (varname.startsWith("global_")) {
                    c.host.delGlobalVariable(expression.module, varname);
                } else if (!varname.startsWith("_")) {
                    c.delVariable(varname);
                }
            }
            return (cc, tt) -> Value.NULL;
        });
        expression.addLazyFunction("vars", 1, (c, t, lv) -> {
            String prefix = ((LazyValue)lv.get(0)).evalValue((Context)c).getString();
            ArrayList<Value> values = new ArrayList<Value>();
            if (prefix.startsWith("global")) {
                c.host.globaVariableNames(expression.module, s -> s.startsWith(prefix)).forEach(s -> values.add(new StringValue((String)s)));
            } else {
                c.getAllVariableNames().stream().filter(s -> s.startsWith(prefix)).forEach(s -> values.add(new StringValue((String)s)));
            }
            ListValue retval = ListValue.wrap(values);
            return (cc, tt) -> retval;
        });
        expression.addLazyFunction("system_variable_get", -1, (c, t, lv) -> {
            Value res;
            if (lv.size() == 0) {
                throw new InternalExpressionException("'system_variable_get' expects at least a key to be fetched");
            }
            Value key = ((LazyValue)lv.get(0)).evalValue((Context)c);
            if (lv.size() > 1) {
                ScriptHost.systemGlobals.computeIfAbsent(key, k -> ((LazyValue)lv.get(1)).evalValue((Context)c));
            }
            if ((res = ScriptHost.systemGlobals.get(key)) != null) {
                return (cc, tt) -> res;
            }
            return (cc, tt) -> Value.NULL;
        });
        expression.addLazyFunction("system_variable_set", 2, (c, t, lv) -> {
            Value value;
            Value key = ((LazyValue)lv.get(0)).evalValue((Context)c);
            Value res = ScriptHost.systemGlobals.put(key, value = ((LazyValue)lv.get(1)).evalValue((Context)c));
            if (res != null) {
                return (cc, tt) -> res;
            }
            return (cc, tt) -> Value.NULL;
        });
    }
}

