/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.language;

import carpet.script.Context;
import carpet.script.Expression;
import carpet.script.LazyValue;
import carpet.script.exception.InternalExpressionException;
import carpet.script.language.Operators;
import carpet.script.value.ContainerValueInterface;
import carpet.script.value.LContainerValue;
import carpet.script.value.LazyListValue;
import carpet.script.value.ListValue;
import carpet.script.value.MapValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;

public class DataStructures {
    public static void apply(Expression expression) {
        expression.addFunction("l", lv -> {
            if (lv.size() == 1 && lv.get(0) instanceof LazyListValue) {
                return ListValue.wrap(((LazyListValue)lv.get(0)).unroll());
            }
            return new ListValue.ListConstructorValue((Collection<? extends Value>)lv);
        });
        expression.addFunction("join", lv -> {
            if (lv.size() < 2) {
                throw new InternalExpressionException("'join' takes at least 2 arguments");
            }
            String delimiter = ((Value)lv.get(0)).getString();
            List<Object> toJoin = lv.size() == 2 && lv.get(1) instanceof LazyListValue ? ((LazyListValue)lv.get(1)).unroll() : (lv.size() == 2 && lv.get(1) instanceof ListValue ? new ArrayList<Value>(((ListValue)lv.get(1)).getItems()) : lv.subList(1, lv.size()));
            return new StringValue(toJoin.stream().map(Value::getString).collect(Collectors.joining(delimiter)));
        });
        expression.addFunction("split", lv -> {
            String delimiter;
            String hwat;
            if (lv.size() == 1) {
                hwat = ((Value)lv.get(0)).getString();
                delimiter = "";
            } else if (lv.size() == 2) {
                delimiter = ((Value)lv.get(0)).getString();
                hwat = ((Value)lv.get(1)).getString();
            } else {
                throw new InternalExpressionException("'split' takes 1 or 2 arguments");
            }
            try {
                return ListValue.wrap(Arrays.stream(hwat.split(delimiter)).map(StringValue::new).collect(Collectors.toList()));
            }
            catch (PatternSyntaxException pse) {
                throw new InternalExpressionException("Incorrect pattern for 'split': " + pse.getMessage());
            }
        });
        expression.addFunction("slice", lv -> {
            if (lv.size() != 2 && lv.size() != 3) {
                throw new InternalExpressionException("'slice' takes 2 or 3 arguments");
            }
            Value hwat = (Value)lv.get(0);
            long from = NumericValue.asNumber((Value)lv.get(1)).getLong();
            long to = -1L;
            if (lv.size() == 3) {
                to = NumericValue.asNumber((Value)lv.get(2)).getLong();
            }
            return hwat.slice(from, to);
        });
        expression.addFunction("sort", lv -> {
            ArrayList<Value> toSort = lv;
            if (lv.size() == 1 && lv.get(0) instanceof ListValue) {
                toSort = new ArrayList<Value>(((ListValue)lv.get(0)).getItems());
            }
            Collections.sort(toSort);
            return ListValue.wrap((List<Value>)toSort);
        });
        expression.addLazyFunction("sort_key", -1, (c, t, lv) -> {
            if (lv.size() == 0) {
                throw new InternalExpressionException("First argument for 'sort_key' should be a List");
            }
            Value v = ((LazyValue)lv.get(0)).evalValue((Context)c);
            if (!(v instanceof ListValue)) {
                throw new InternalExpressionException("First argument for 'sort_key' should be a List");
            }
            ArrayList<Value> toSort = new ArrayList<Value>(((ListValue)v).getItems());
            if (lv.size() == 1) {
                Collections.shuffle(toSort);
                ListValue ret = ListValue.wrap(toSort);
                return (_c, _t) -> ret;
            }
            LazyValue sortKey = (LazyValue)lv.get(1);
            LazyValue __ = c.getVariable("_");
            Collections.sort(toSort, (v1, v2) -> {
                c.setVariable("_", (cc, tt) -> v1);
                Value ev1 = sortKey.evalValue((Context)c);
                c.setVariable("_", (cc, tt) -> v2);
                Value ev2 = sortKey.evalValue((Context)c);
                return ev1.compareTo(ev2);
            });
            c.setVariable("_", __);
            return (cc, tt) -> ListValue.wrap(toSort);
        });
        expression.addFunction("range", lv -> {
            long from = 0L;
            long to = 0L;
            long step = 1L;
            int argsize = lv.size();
            if (argsize == 0 || argsize > 3) {
                throw new InternalExpressionException("'range' accepts from 1 to 3 arguments, not " + argsize);
            }
            to = NumericValue.asNumber((Value)lv.get(0)).getLong();
            if (lv.size() > 1) {
                from = to;
                to = NumericValue.asNumber((Value)lv.get(1)).getLong();
                if (lv.size() > 2) {
                    step = NumericValue.asNumber((Value)lv.get(2)).getLong();
                }
            }
            return LazyListValue.range(from, to, step);
        });
        expression.addLazyFunction("m", -1, (c, t, llv) -> {
            ArrayList<Value> lv = new ArrayList<Value>();
            for (LazyValue lazyParam : llv) {
                lv.add(lazyParam.evalValue((Context)c, 10));
            }
            MapValue ret = lv.size() == 1 && lv.get(0) instanceof LazyListValue ? new MapValue(((LazyListValue)lv.get(0)).unroll()) : new MapValue(lv);
            return (cc, tt) -> ret;
        });
        expression.addUnaryFunction("keys", v -> {
            if (v instanceof MapValue) {
                return new ListValue(((MapValue)v).getMap().keySet());
            }
            return Value.NULL;
        });
        expression.addUnaryFunction("values", v -> {
            if (v instanceof MapValue) {
                return new ListValue(((MapValue)v).getMap().values());
            }
            return Value.NULL;
        });
        expression.addUnaryFunction("pairs", v -> {
            if (v instanceof MapValue) {
                return ListValue.wrap(((MapValue)v).getMap().entrySet().stream().map(p -> ListValue.of((Value)p.getKey(), (Value)p.getValue())).collect(Collectors.toList()));
            }
            return Value.NULL;
        });
        expression.addLazyBinaryOperator(":", Operators.precedence.get("attribute~:"), true, (c, t, container_lv, key_lv) -> {
            Value container = container_lv.evalValue((Context)c);
            if (container instanceof LContainerValue) {
                ContainerValueInterface outerContainer = ((LContainerValue)container).getContainer();
                if (outerContainer == null) {
                    LContainerValue innerLValue = new LContainerValue(null, null);
                    return (cc, tt) -> innerLValue;
                }
                Value innerContainer = outerContainer.get(((LContainerValue)container).getAddress());
                if (!(innerContainer instanceof ContainerValueInterface)) {
                    LContainerValue innerLValue = new LContainerValue(null, null);
                    return (cc, tt) -> innerLValue;
                }
                LContainerValue innerLValue = new LContainerValue((ContainerValueInterface)((Object)innerContainer), key_lv.evalValue((Context)c));
                return (cc, tt) -> innerLValue;
            }
            if (!(container instanceof ContainerValueInterface)) {
                if (t == 9) {
                    return (cc, tt) -> new LContainerValue(null, null);
                }
                return (cc, tt) -> Value.NULL;
            }
            Value address = key_lv.evalValue((Context)c);
            if (t != 9) {
                Value retVal = ((ContainerValueInterface)((Object)container)).get(address);
                return (cc, ct) -> retVal;
            }
            LContainerValue retVal = new LContainerValue((ContainerValueInterface)((Object)container), address);
            return (cc, ct) -> retVal;
        });
        expression.addLazyFunction("get", -1, (c, t, lv) -> {
            if (lv.size() == 0) {
                throw new InternalExpressionException("'get' requires parameters");
            }
            if (lv.size() == 1) {
                Value v = ((LazyValue)lv.get(0)).evalValue((Context)c, 9);
                if (!(v instanceof LContainerValue)) {
                    return (cc, tt) -> Value.NULL;
                }
                ContainerValueInterface container = ((LContainerValue)v).getContainer();
                if (container == null) {
                    return (cc, tt) -> Value.NULL;
                }
                Value ret = container.get(((LContainerValue)v).getAddress());
                return (cc, tt) -> ret;
            }
            Value container = ((LazyValue)lv.get(0)).evalValue((Context)c);
            for (int i = 1; i < lv.size(); ++i) {
                if (!(container instanceof ContainerValueInterface)) {
                    return (cc, tt) -> Value.NULL;
                }
                container = ((ContainerValueInterface)((Object)container)).get(((LazyValue)lv.get(i)).evalValue((Context)c));
            }
            if (container == null) {
                return (cc, tt) -> Value.NULL;
            }
            Value finalContainer = container;
            return (cc, tt) -> finalContainer;
        });
        expression.addLazyFunction("has", -1, (c, t, lv) -> {
            if (lv.size() == 0) {
                throw new InternalExpressionException("'has' requires parameters");
            }
            if (lv.size() == 1) {
                Value v = ((LazyValue)lv.get(0)).evalValue((Context)c, 9);
                if (!(v instanceof LContainerValue)) {
                    return (cc, tt) -> Value.NULL;
                }
                ContainerValueInterface container = ((LContainerValue)v).getContainer();
                if (container == null) {
                    return (cc, tt) -> Value.NULL;
                }
                NumericValue ret = new NumericValue(container.has(((LContainerValue)v).getAddress()));
                return (cc, tt) -> ret;
            }
            Value container = ((LazyValue)lv.get(0)).evalValue((Context)c);
            for (int i = 1; i < lv.size() - 1; ++i) {
                if (!(container instanceof ContainerValueInterface)) {
                    return (cc, tt) -> Value.NULL;
                }
                container = ((ContainerValueInterface)((Object)container)).get(((LazyValue)lv.get(i)).evalValue((Context)c));
            }
            if (!(container instanceof ContainerValueInterface)) {
                return (cc, tt) -> Value.NULL;
            }
            NumericValue ret = new NumericValue(((ContainerValueInterface)((Object)container)).has(((LazyValue)lv.get(lv.size() - 1)).evalValue((Context)c)));
            return (cc, tt) -> ret;
        });
        expression.addLazyFunction("put", -1, (c, t, lv) -> {
            if (lv.size() < 2) {
                throw new InternalExpressionException("'put' takes at least three arguments, a container, address, and values to insert at that index");
            }
            Value container = ((LazyValue)lv.get(0)).evalValue((Context)c, 9);
            if (container instanceof LContainerValue) {
                ContainerValueInterface internalContainer = ((LContainerValue)container).getContainer();
                if (internalContainer == null) {
                    return (cc, tt) -> Value.NULL;
                }
                Value address = ((LContainerValue)container).getAddress();
                Value what = ((LazyValue)lv.get(1)).evalValue((Context)c);
                NumericValue retVal = new NumericValue(lv.size() > 2 ? internalContainer.put(address, what, ((LazyValue)lv.get(2)).evalValue((Context)c)) : internalContainer.put(address, what));
                return (cc, tt) -> retVal;
            }
            if (lv.size() < 3) {
                throw new InternalExpressionException("'put' takes at least three arguments, a container, address, and values to insert at that index");
            }
            if (!(container instanceof ContainerValueInterface)) {
                return (cc, tt) -> Value.NULL;
            }
            Value where = ((LazyValue)lv.get(1)).evalValue((Context)c);
            Value what = ((LazyValue)lv.get(2)).evalValue((Context)c);
            NumericValue retVal = new NumericValue(lv.size() > 3 ? ((ContainerValueInterface)((Object)container)).put(where, what, ((LazyValue)lv.get(3)).evalValue((Context)c)) : ((ContainerValueInterface)((Object)container)).put(where, what));
            return (cc, tt) -> retVal;
        });
        expression.addLazyFunction("delete", -1, (c, t, lv) -> {
            if (lv.size() == 0) {
                throw new InternalExpressionException("'delete' requires parameters");
            }
            if (lv.size() == 1) {
                Value v = ((LazyValue)lv.get(0)).evalValue((Context)c, 9);
                if (!(v instanceof LContainerValue)) {
                    return (cc, tt) -> Value.NULL;
                }
                ContainerValueInterface container = ((LContainerValue)v).getContainer();
                if (container == null) {
                    return (cc, tt) -> Value.NULL;
                }
                NumericValue ret = new NumericValue(container.delete(((LContainerValue)v).getAddress()));
                return (cc, tt) -> ret;
            }
            Value container = ((LazyValue)lv.get(0)).evalValue((Context)c);
            for (int i = 1; i < lv.size() - 1; ++i) {
                if (!(container instanceof ContainerValueInterface)) {
                    return (cc, tt) -> Value.NULL;
                }
                container = ((ContainerValueInterface)((Object)container)).get(((LazyValue)lv.get(i)).evalValue((Context)c));
            }
            if (!(container instanceof ContainerValueInterface)) {
                return (cc, tt) -> Value.NULL;
            }
            NumericValue ret = new NumericValue(((ContainerValueInterface)((Object)container)).delete(((LazyValue)lv.get(lv.size() - 1)).evalValue((Context)c)));
            return (cc, tt) -> ret;
        });
    }
}

