/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.argument;

import carpet.script.Context;
import carpet.script.LazyValue;
import carpet.script.argument.Argument;
import carpet.script.bundled.Module;
import carpet.script.exception.InternalExpressionException;
import carpet.script.value.FunctionValue;
import carpet.script.value.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FunctionArgument
extends Argument {
    public FunctionValue function;
    public List<LazyValue> args;

    private FunctionArgument(FunctionValue function, int offset, List<LazyValue> args) {
        super(offset);
        this.function = function;
        this.args = args;
    }

    public static FunctionArgument findIn(Context c, Module module, List<LazyValue> params, int offset, boolean prematureEvaluation, boolean allowNone, boolean checkArgs) {
        Value functionValue = params.get(offset).evalValue(c);
        if (functionValue.isNull()) {
            if (allowNone) {
                return new FunctionArgument(null, offset + 1, Collections.emptyList());
            }
            throw new InternalExpressionException("function argument cannot be null");
        }
        if (!(functionValue instanceof FunctionValue)) {
            String name = functionValue.getString();
            functionValue = c.host.getAssertFunction(module, name);
        }
        FunctionValue fun = (FunctionValue)functionValue;
        int argsize = fun.getArguments().size();
        if (checkArgs) {
            int extraargs = params.size() - argsize - offset - 1;
            if (extraargs < 0) {
                throw new InternalExpressionException("Function " + fun.getPrettyString() + " requires at least " + fun.getArguments().size() + " arguments");
            }
            if (extraargs > 0 && fun.getVarArgs() == null) {
                throw new InternalExpressionException("Function " + fun.getPrettyString() + " requires " + fun.getArguments().size() + " arguments");
            }
        }
        ArrayList<LazyValue> lvargs = new ArrayList<LazyValue>();
        if (prematureEvaluation) {
            int mx = params.size();
            for (int i = offset + 1; i < mx; ++i) {
                Value arg = params.get(i).evalValue(c);
                lvargs.add((cc, tt) -> arg);
            }
        } else {
            int mx = params.size();
            for (int i = offset + 1; i < mx; ++i) {
                lvargs.add(params.get(i));
            }
        }
        return new FunctionArgument(fun, offset + 1 + argsize, lvargs);
    }

    public List<Value> resolveArgs(Context context, Integer type) {
        ArrayList<Value> res = new ArrayList<Value>(this.args.size());
        for (LazyValue arg : this.args) {
            res.add(arg.evalValue(context, type));
        }
        return res;
    }
}

