/*
 * Decompiled with CFR 0.152.
 */
package carpet.script;

import carpet.script.LazyValue;
import carpet.script.ScriptHost;
import carpet.script.value.Value;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Context {
    public static final int NONE = 0;
    public static final int VOID = 1;
    public static final int BOOLEAN = 2;
    public static final int NUMBER = 3;
    public static final int STRING = 4;
    public static final int LIST = 5;
    public static final int ITERATOR = 6;
    public static final int SIGNATURE = 7;
    public static final int LOCALIZATION = 8;
    public static final int LVALUE = 9;
    public static final int MAPDEF = 10;
    public Map<String, LazyValue> variables = new HashMap<String, LazyValue>();
    public final ScriptHost host;

    public Context(ScriptHost host) {
        this.host = host;
    }

    public LazyValue getVariable(String name) {
        return this.variables.get(name);
    }

    public void setVariable(String name, LazyValue lv) {
        this.variables.put(name, lv);
    }

    public void delVariable(String variable) {
        this.variables.remove(variable);
    }

    public void removeVariablesMatching(String varname) {
        this.variables.entrySet().removeIf(e -> ((String)e.getKey()).startsWith(varname));
    }

    public Context with(String variable, LazyValue lv) {
        this.variables.put(variable, lv);
        return this;
    }

    public Set<String> getAllVariableNames() {
        return this.variables.keySet();
    }

    public Context recreate() {
        Context ctx = this.duplicate();
        ctx.initialize();
        return ctx;
    }

    protected void initialize() {
        this.variables.put("_", (c, t) -> Value.ZERO);
        this.variables.put("_i", (c, t) -> Value.ZERO);
        this.variables.put("_a", (c, t) -> Value.ZERO);
    }

    public Context duplicate() {
        return new Context(this.host);
    }
}

