/*
 * Decompiled with CFR 0.152.
 */
package carpet.mixins;

import carpet.CarpetSettings;
import carpet.fakes.ItemEntityInterface;
import carpet.helpers.InventoryHelper;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2480;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1542.class})
public abstract class ItemEntityMixin
extends class_1297
implements ItemEntityInterface {
    private static final int SHULKERBOX_MAX_STACK_AMOUNT = 64;
    @Shadow
    private int field_7204;
    @Shadow
    private int field_7202;

    public ItemEntityMixin(class_1299<?> entityType_1, class_1937 world_1) {
        super(entityType_1, world_1);
    }

    @Override
    public int getAgeCM() {
        return this.field_7204;
    }

    @Override
    public int getPickupDelayCM() {
        return this.field_7202;
    }

    @Inject(method={"<init>(Lnet/minecraft/world/World;DDDLnet/minecraft/item/ItemStack;)V"}, at={@At(value="RETURN")})
    private void removeEmptyShulkerBoxTags(class_1937 worldIn, double x, double y, double z, class_1799 stack, CallbackInfo ci) {
        if (CarpetSettings.stackableShulkerBoxes && stack.method_7909() instanceof class_1747 && ((class_1747)stack.method_7909()).method_7711() instanceof class_2480 && InventoryHelper.cleanUpShulkerBoxTag(stack)) {
            ((class_1542)this).method_6979(stack);
        }
    }

    @Redirect(method={"canMerge()Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;getMaxCount()I"))
    private int getItemStackMaxAmount(class_1799 stack) {
        if (CarpetSettings.stackableShulkerBoxes && stack.method_7909() instanceof class_1747 && ((class_1747)stack.method_7909()).method_7711() instanceof class_2480) {
            return 64;
        }
        return stack.method_7914();
    }

    @Inject(method={"tryMerge(Lnet/minecraft/entity/ItemEntity;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void tryStackShulkerBoxes(class_1542 other, CallbackInfo ci) {
        class_1542 self = (class_1542)this;
        class_1799 selfStack = self.method_6983();
        if (!(CarpetSettings.stackableShulkerBoxes && selfStack.method_7909() instanceof class_1747 && ((class_1747)selfStack.method_7909()).method_7711() instanceof class_2480)) {
            return;
        }
        class_1799 otherStack = other.method_6983();
        if (selfStack.method_7909() == otherStack.method_7909() && !InventoryHelper.shulkerBoxHasItems(selfStack) && !InventoryHelper.shulkerBoxHasItems(otherStack) && selfStack.method_7985() == otherStack.method_7985() && selfStack.method_7947() + otherStack.method_7947() <= 64) {
            int amount = Math.min(otherStack.method_7947(), 64 - selfStack.method_7947());
            selfStack.method_7933(amount);
            self.method_6979(selfStack);
            this.field_7202 = Math.max(((ItemEntityInterface)other).getPickupDelayCM(), this.field_7202);
            this.field_7204 = Math.min(((ItemEntityInterface)other).getAgeCM(), this.field_7204);
            otherStack.method_7934(amount);
            if (otherStack.method_7960()) {
                other.method_5650();
            } else {
                other.method_6979(otherStack);
            }
            ci.cancel();
        }
    }
}

