/*
 * Decompiled with CFR 0.152.
 */
package carpet.commands;

import carpet.CarpetSettings;
import carpet.helpers.HopperCounter;
import carpet.utils.Messenger;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.class_1767;
import net.minecraft.class_2164;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2554;
import net.minecraft.class_2561;

public class CounterCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder literalargumentbuilder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"counter").executes(context -> CounterCommand.listAllCounters((class_2168)context.getSource(), false))).requires(player -> CarpetSettings.hopperCounters);
        literalargumentbuilder.then(class_2170.method_9247((String)"reset").executes(p_198489_1_ -> CounterCommand.resetCounter((class_2168)p_198489_1_.getSource(), null)));
        for (class_1767 enumDyeColor : class_1767.values()) {
            String color = enumDyeColor.toString();
            literalargumentbuilder.then(class_2170.method_9247((String)color).executes(p_198489_1_ -> CounterCommand.displayCounter((class_2168)p_198489_1_.getSource(), color, false)));
            literalargumentbuilder.then(class_2170.method_9247((String)color).then(class_2170.method_9247((String)"reset").executes(context -> CounterCommand.resetCounter((class_2168)context.getSource(), color))));
            literalargumentbuilder.then(class_2170.method_9247((String)color).then(class_2170.method_9247((String)"realtime").executes(context -> CounterCommand.displayCounter((class_2168)context.getSource(), color, true))));
        }
        dispatcher.register(literalargumentbuilder);
    }

    private static int displayCounter(class_2168 source, String color, boolean realtime) {
        HopperCounter counter = HopperCounter.getCounter(color);
        if (counter == null) {
            throw new class_2164((class_2561)Messenger.s("Unknown wool color: " + color));
        }
        for (class_2554 message : counter.format(source.method_9211(), realtime, false)) {
            source.method_9226((class_2561)message, false);
        }
        return 1;
    }

    private static int resetCounter(class_2168 source, String color) {
        if (color == null) {
            HopperCounter.resetAll(source.method_9211());
            Messenger.m(source, "w Restarted all counters");
        } else {
            HopperCounter counter = HopperCounter.getCounter(color);
            if (counter == null) {
                throw new class_2164((class_2561)Messenger.s("Unknown wool color"));
            }
            counter.reset(source.method_9211());
            Messenger.m(source, "w Restarted " + color + " counter");
        }
        return 1;
    }

    private static int listAllCounters(class_2168 source, boolean realtime) {
        for (class_2554 message : HopperCounter.formatAll(source.method_9211(), realtime)) {
            source.method_9226((class_2561)message, false);
        }
        return 1;
    }
}

