/*
 * Decompiled with CFR 0.152.
 */
package carpet;

import carpet.CarpetServer;
import carpet.settings.ParsedRule;
import carpet.settings.Rule;
import carpet.settings.SettingsManager;
import carpet.settings.Validator;
import carpet.utils.Messenger;
import carpet.utils.SpawnChunks;
import carpet.utils.Translations;
import java.util.Locale;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2994;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CarpetSettings {
    public static final String carpetVersion = "1.4.16+v201105";
    public static final Logger LOG = LogManager.getLogger((String)"carpet");
    public static boolean skipGenerationChecks = false;
    public static boolean impendingFillSkipUpdates = false;
    public static class_238 currentTelepotingEntityBox = null;
    public static class_243 fixedPosition = null;
    public static int runPermissionLevel = 2;
    public static boolean doChainStone = false;
    public static boolean chainStoneStickToAll = false;
    @Rule(desc="sets the language for carpet", category={"feature"}, options={"none", "zh_cn", "zh_tw"}, strict=false, validate={LanguageValidator.class})
    public static String language = "none";
    @Rule(desc="Gbhs sgnf sadsgras fhskdpri!", category={"experimental"})
    public static boolean superSecretSetting = false;
    @Rule(desc="Amount of delay ticks to use a nether portal in creative", options={"1", "40", "80", "72000"}, category={"creative"}, strict=false, validate={OneHourMaxDelayLimit.class})
    public static int portalCreativeDelay = 1;
    @Rule(desc="Amount of delay ticks to use a nether portal in survival", options={"1", "40", "80", "72000"}, category={"survival"}, strict=false, validate={OneHourMaxDelayLimit.class})
    public static int portalSurvivalDelay = 80;
    @Rule(desc="Dropping entire stacks works also from on the crafting UI result slot", category={"bugfix", "survival"})
    public static boolean ctrlQCraftingFix = false;
    @Rule(desc="Parrots don't get of your shoulders until you receive proper damage", category={"survival", "feature"})
    public static boolean persistentParrots = false;
    @Rule(desc="Players absorb XP instantly, without delay", category={"creative"})
    public static boolean xpNoCooldown = false;
    @Rule(desc="XP orbs combine with other into bigger orbs", category={"feature"})
    public static boolean combineXPOrbs = false;
    @Rule(desc="Empty shulker boxes can stack to 64 when dropped on the ground", extra={"To move them around between inventories, use shift click to move entire stacks"}, category={"survival", "feature"})
    public static boolean stackableShulkerBoxes = false;
    @Rule(desc="Explosions won't destroy blocks", category={"creative", "tnt"})
    public static boolean explosionNoBlockDamage = false;
    @Rule(desc="Removes random TNT momentum when primed", category={"creative", "tnt"})
    public static boolean tntPrimerMomentumRemoved = false;
    @Rule(desc="TNT causes less lag when exploding in the same spot and in liquids", category={"tnt"})
    public static boolean optimizedTNT = false;
    @Rule(desc="Sets the tnt random explosion range to a fixed value", category={"tnt"}, options={"-1"}, strict=false, validate={CheckOptimizedTntEnabledValidator.class, TNTRandomRangeValidator.class}, extra={"Set to -1 for default behavior"})
    public static double tntRandomRange = -1.0;
    @Rule(desc="Sets the horizontal random angle on TNT for debugging of TNT contraptions", category={"tnt"}, options={"-1"}, strict=false, validate={TNTAngleValidator.class}, extra={"Set to -1 for default behavior"})
    public static double hardcodeTNTangle = -1.0;
    @Rule(desc="Merges stationary primed TNT entities", category={"tnt"})
    public static boolean mergeTNT = false;
    @Rule(desc="Lag optimizations for redstone dust", extra={"by Theosib", ".. also fixes some locational behaviours or vanilla redstone MC-11193", "so behaviour of locational vanilla contraptions is not guaranteed"}, category={"experimental", "optimization"})
    public static boolean fastRedstoneDust = false;
    @Rule(desc="Only husks spawn in desert temples", category={"feature"})
    public static boolean huskSpawningInTemples = false;
    @Rule(desc="Shulkers will respawn in end cities", category={"feature"})
    public static boolean shulkerSpawningInEndCities = false;
    @Rule(desc="Piglins will respawn in bastion remnants", extra={"Includes piglins, brutes, and a few hoglins"}, category={"feature"})
    public static boolean piglinsSpawningInBastions = false;
    @Rule(desc="TNT doesn't update when placed against a power source", category={"creative", "tnt"})
    public static boolean tntDoNotUpdate = false;
    @Rule(desc="Prevents players from rubberbanding when moving too fast", extra={"... or being kicked out for 'flying'", "Puts more trust in clients positioning", "Increases player allowed mining distance to 32 blocks"}, category={"creative", "survival"})
    public static boolean antiCheatDisabled = false;
    @Rule(desc="Pistons, droppers and dispensers react if block above them is powered", category={"creative"})
    public static boolean quasiConnectivity = true;
    @Rule(desc="Players can flip and rotate blocks when holding cactus", extra={"Doesn't cause block updates when rotated/flipped", "Applies to pistons, observers, droppers, repeaters, stairs, glazed terracotta etc..."}, category={"creative", "survival", "feature"})
    public static boolean flippinCactus = false;
    @Rule(desc="hoppers pointing to wool will count items passing through them", extra={"Enables /counter command, and actions while placing red and green carpets on wool blocks", "Use /counter <color?> reset to reset the counter, and /counter <color?> to query", "In survival, place green carpet on same color wool to query, red to reset the counters", "Counters are global and shared between players, 16 channels available", "Items counted are destroyed, count up to one stack per tick per hopper"}, category={"command", "creative", "feature"})
    public static boolean hopperCounters = false;
    @Rule(desc="Guardians turn into Elder Guardian when struck by lightning", category={"feature"})
    public static boolean renewableSponges = false;
    @Rule(desc="Pistons can push block entities, like hoppers, chests etc.", category={"experimental", "feature"})
    public static boolean movableBlockEntities = false;
    @Rule(desc="Chains will stick to each other on the long ends", extra={"and will stick to other blocks that connect to them directly.", "With stick_to_all: it will stick even if not visually connected"}, category={"experimental", "feature"}, options={"true", "false", "stick_to_all"}, validate={ChainStoneSetting.class})
    public static String chainStone = "false";
    @Rule(desc="Saplings turn into dead shrubs in hot climates and no water access", category={"feature"})
    public static boolean desertShrubs = false;
    @Rule(desc="Silverfish drop a gravel item when breaking out of a block", category={"feature"})
    public static boolean silverFishDropGravel = false;
    @Rule(desc="summoning a lightning bolt has all the side effects of natural lightning", category={"creative"})
    public static boolean summonNaturalLightning = false;
    @Rule(desc="Enables /spawn command for spawn tracking", category={"command"})
    public static String commandSpawn = "true";
    @Rule(desc="Enables /tick command to control game clocks", category={"command"})
    public static String commandTick = "true";
    @Rule(desc="Enables /profile command to monitor game performance", extra={"subset of /tick command capabilities"}, category={"command"})
    public static String commandProfile = "true";
    @Rule(desc="Enables /log command to monitor events via chat and overlays", category={"command"})
    public static String commandLog = "true";
    @Rule(desc="sets these loggers in their default configurations for all new players", extra={"use csv, like 'tps,mobcaps' for multiple loggers, none for nothing"}, category={"creative", "survival"}, options={"none", "tps", "mobcaps,tps"}, strict=false)
    public static String defaultLoggers = "none";
    @Rule(desc="Enables /distance command to measure in game distance between points", extra={"Also enables brown carpet placement action if 'carpets' rule is turned on as well"}, category={"command"})
    public static String commandDistance = "true";
    @Rule(desc="Enables /info command for blocks", extra={"Also enables gray carpet placement action", "if 'carpets' rule is turned on as well"}, category={"command"})
    public static String commandInfo = "true";
    @Rule(desc="Enables /perimeterinfo command", extra={"... that scans the area around the block for potential spawnable spots"}, category={"command"})
    public static String commandPerimeterInfo = "true";
    @Rule(desc="Enables /draw commands", extra={"... allows for drawing simple shapes or", "other shapes which are sorta difficult to do normally"}, category={"command"})
    public static String commandDraw = "true";
    @Rule(desc="Enables /script command", extra={"An in-game scripting API for Scarpet programming language"}, category={"command", "scarpet"})
    public static String commandScript = "true";
    @Rule(desc="Enables restrictions for arbitrary code execution with scarpet", extra={"Users that don't have this permission level", "won't be able to load apps or /script run"}, category={"command", "scarpet"}, validate={ModulePermissionLevel.class})
    public static String commandScriptACE = "ops";
    @Rule(desc="Scarpet script from world files will autoload on server/world start ", extra={"if /script is enabled"}, category={"scarpet"})
    public static boolean scriptsAutoload = false;
    @Rule(desc="Enables /player command to control/spawn players", category={"command"})
    public static String commandPlayer = "true";
    @Rule(desc="Allows to track mobs AI via /track command", category={"command"})
    public static String commandTrackAI = "true";
    @Rule(desc="Placing carpets may issue carpet commands for non-op players", category={"survival"})
    public static boolean carpets = false;
    @Rule(desc="Glass can be broken faster with pickaxes", category={"survival"})
    public static boolean missingTools = false;
    @Rule(desc="fill/clone/setblock and structure blocks cause block updates", category={"creative"})
    public static boolean fillUpdates = true;
    @Rule(desc="placing blocks cause block updates", category={"creative"})
    public static boolean interactionUpdates = true;
    @Rule(desc="smooth client animations with low tps settings", extra={"works only in SP, and will slow down players"}, category={"creative", "survival", "client"})
    public static boolean smoothClientAnimations;
    @Rule(desc="Customizable piston push limit", options={"10", "12", "14", "100"}, category={"creative"}, strict=false, validate={PushLimitLimits.class})
    public static int pushLimit;
    @Rule(desc="Customizable powered rail power range", options={"9", "15", "30"}, category={"creative"}, strict=false, validate={PushLimitLimits.class})
    public static int railPowerLimit;
    @Rule(desc="Customizable fill/clone volume limit", options={"32768", "250000", "1000000"}, category={"creative"}, strict=false, validate={FillLimitLimits.class})
    public static int fillLimit;
    @Rule(desc="Customizable forceload chunk limit", options={"256"}, category={"creative"}, strict=false, validate={FillLimitLimits.class})
    public static int forceloadLimit;
    @Rule(desc="Customizable maximal entity collision limits, 0 for no limits", options={"0", "1", "20"}, category={"optimization"}, strict=false, validate={Validator.NONNEGATIVE_NUMBER.class})
    public static int maxEntityCollisions;
    @Rule(desc="One player is required on the server to cause night to pass", category={"survival"})
    public static boolean onePlayerSleeping;
    @Rule(desc="Sets a different motd message on client trying to connect to the server", extra={"use '_' to use the startup setting from server.properties"}, options={"_"}, strict=false, category={"creative"})
    public static String customMOTD;
    @Rule(desc="Cactus in dispensers rotates blocks.", extra={"Rotates block anti-clockwise if possible"}, category={"feature", "dispenser"})
    public static boolean rotatorBlock;
    @Rule(desc="Changes the view distance of the server.", extra={"Set to 0 to not override the value in server settings."}, options={"0", "12", "16", "32"}, category={"creative"}, strict=false, validate={ViewDistanceValidator.class})
    public static int viewDistance;
    @Rule(desc="Changes size of spawn chunks", extra={"Defines new radius", "setting it to 0 - disables spawn chunks"}, category={"creative"}, strict=false, options={"0", "11"}, validate={ChangeSpawnChunksValidator.class})
    public static int spawnChunksSize;
    @Rule(desc="Coral structures will grow with bonemeal from coral plants", category={"feature"})
    public static boolean renewableCoral;
    @Rule(desc="Nether basalt generator without soul sand below ", extra={"  .. will convert into blackstone instead"}, category={"feature"})
    public static boolean renewableBlackstone;
    @Rule(desc="fixes block placement rotation issue when player rotates quickly while placing blocks", category={"bugfix"})
    public static boolean placementRotationFix;
    @Rule(desc="Fixes leads breaking/becoming invisible in unloaded chunks", extra={"You may still get visibly broken leash links on the client side, but server side the link is still there."}, category={"bugfix"})
    public static boolean leadFix;
    @Rule(desc="Spawning requires much less CPU and Memory", category={"optimization"})
    public static boolean lagFreeSpawning;
    @Rule(desc="Allows structure mobs to spawn in flat worlds", category={"experimental", "creative"})
    public static boolean flatWorldStructureSpawning;
    @Rule(desc="Edge cases are as frequent as common cases, for testing only!!", extra={"Velocities of items from dispensers, blaze projectiles, fireworks ", "Directions of fireballs, wither skulls, fishing bobbers, ", "items dropped from blocks and inventories, llamas spit, triggered trap horses", "Damage dealt with projectiles", "Blaze aggro sensitivity", "Mobs spawned follow range"}, category={"creative"})
    public static boolean extremeBehaviours;
    @Rule(desc="Removes fog from client in the nether and the end", extra={"Improves visibility, but looks weird"}, category={"client"})
    public static boolean fogOff;
    @Rule(desc="Creative No Clip", extra={"On servers it needs to be set on both ", "client and server to function properly.", "Has no effect when set on the server only", "Can allow to phase through walls", "if only set on the carpet client side", "but requires some trapdoor magic to", "allow the player to enter blocks"}, category={"creative", "client"})
    public static boolean creativeNoClip;
    @Rule(desc="Creative flying speed multiplier", extra={"Purely client side setting, meaning that", "having it set on the decicated server has no effect", "but this also means it will work on vanilla servers as well"}, category={"creative", "client"}, validate={Validator.NONNEGATIVE_NUMBER.class})
    public static double creativeFlySpeed;
    @Rule(desc="Creative air drag", extra={"Increased drag will slow down your flight", "So need to adjust speed accordingly", "With 1.0 drag, using speed of 11 seems to matching vanilla speeds.", "Purely client side setting, meaning that", "having it set on the decicated server has no effect", "but this also means it will work on vanilla servers as well"}, category={"creative", "client"}, validate={Validator.PROBABILITY.class})
    public static double creativeFlyDrag;
    @Rule(desc="Removes abnoxious messages from the logs", extra={"Doesn't display 'Maximum sound pool size 247 reached'", "Which is normal with decent farms and contraptions"}, category={"survival", "client"})
    public static boolean cleanLogs;

    static {
        pushLimit = 12;
        railPowerLimit = 9;
        fillLimit = 32768;
        forceloadLimit = 256;
        maxEntityCollisions = 0;
        onePlayerSleeping = false;
        customMOTD = "_";
        rotatorBlock = false;
        viewDistance = 0;
        spawnChunksSize = 11;
        renewableCoral = false;
        renewableBlackstone = false;
        placementRotationFix = false;
        leadFix = false;
        lagFreeSpawning = false;
        flatWorldStructureSpawning = false;
        extremeBehaviours = false;
        fogOff = false;
        creativeNoClip = false;
        creativeFlySpeed = 1.0;
        creativeFlyDrag = 0.09;
        cleanLogs = false;
    }

    public static class ChangeSpawnChunksValidator
    extends Validator<Integer> {
        public static void changeSpawnSize(int size) {
            class_3218 overworld = CarpetServer.minecraft_server.method_3847(class_1937.field_25179);
            if (overworld != null) {
                class_1923 centerChunk = new class_1923(new class_2338(overworld.method_8401().method_215(), overworld.method_8401().method_144(), overworld.method_8401().method_166()));
                SpawnChunks.changeSpawnChunks(overworld.method_14178(), centerChunk, size);
            }
        }

        @Override
        public Integer validate(class_2168 source, ParsedRule<Integer> currentRule, Integer newValue, String string) {
            if (source == null) {
                return newValue;
            }
            if (newValue < 0 || newValue > 32) {
                Messenger.m(source, "r spawn chunk size has to be between 0 and 32");
                return null;
            }
            if (currentRule.get().intValue() == newValue.intValue()) {
                return newValue;
            }
            if (CarpetServer.minecraft_server == null) {
                return newValue;
            }
            class_3218 currentOverworld = CarpetServer.minecraft_server.method_3847(class_1937.field_25179);
            if (currentOverworld != null) {
                ChangeSpawnChunksValidator.changeSpawnSize(newValue);
            }
            return newValue;
        }
    }

    private static class ViewDistanceValidator
    extends Validator<Integer> {
        private ViewDistanceValidator() {
        }

        @Override
        public Integer validate(class_2168 source, ParsedRule<Integer> currentRule, Integer newValue, String string) {
            if (currentRule.get().equals(newValue) || source == null) {
                return newValue;
            }
            if (newValue < 0 || newValue > 32) {
                Messenger.m(source, "r view distance has to be between 0 and 32");
                return null;
            }
            MinecraftServer server = source.method_9211();
            if (server.method_3816()) {
                int vd;
                int n = vd = newValue >= 2 ? newValue : ((class_2994)server).method_16705().field_16844;
                if (vd != server.method_3760().method_14568()) {
                    server.method_3760().method_14608(vd);
                }
                return newValue;
            }
            Messenger.m(source, "r view distance can only be changed on a server");
            return 0;
        }

        @Override
        public String description() {
            return "You must choose a value from 0 (use server settings) to 32";
        }
    }

    private static class FillLimitLimits
    extends Validator<Integer> {
        private FillLimitLimits() {
        }

        @Override
        public Integer validate(class_2168 source, ParsedRule<Integer> currentRule, Integer newValue, String string) {
            return newValue > 0 && newValue <= 20000000 ? newValue : null;
        }

        @Override
        public String description() {
            return "You must choose a value from 1 to 20M";
        }
    }

    private static class PushLimitLimits
    extends Validator<Integer> {
        private PushLimitLimits() {
        }

        @Override
        public Integer validate(class_2168 source, ParsedRule<Integer> currentRule, Integer newValue, String string) {
            return newValue > 0 && newValue <= 1024 ? newValue : null;
        }

        @Override
        public String description() {
            return "You must choose a value from 1 to 1024";
        }
    }

    private static class ModulePermissionLevel
    extends Validator<String> {
        private ModulePermissionLevel() {
        }

        @Override
        public String validate(class_2168 source, ParsedRule<String> currentRule, String newValue, String string) {
            runPermissionLevel = SettingsManager.getCommandLevel(newValue);
            return newValue;
        }

        @Override
        public String description() {
            return "Also controls permission level of commands executed via `run()`";
        }
    }

    private static class ChainStoneSetting
    extends Validator<String> {
        private ChainStoneSetting() {
        }

        @Override
        public String validate(class_2168 source, ParsedRule<String> currentRule, String newValue, String string) {
            doChainStone = !newValue.toLowerCase(Locale.ROOT).equals("false");
            chainStoneStickToAll = newValue.toLowerCase(Locale.ROOT).equals("stick_to_all");
            return newValue;
        }
    }

    private static class TNTAngleValidator
    extends Validator<Double> {
        private TNTAngleValidator() {
        }

        @Override
        public Double validate(class_2168 source, ParsedRule<Double> currentRule, Double newValue, String string) {
            return newValue >= 0.0 && newValue < Math.PI * 2 || newValue == -1.0 ? newValue : null;
        }

        @Override
        public String description() {
            return "Must be between 0 and 2pi, or -1";
        }
    }

    private static class TNTRandomRangeValidator
    extends Validator<Double> {
        private TNTRandomRangeValidator() {
        }

        @Override
        public Double validate(class_2168 source, ParsedRule<Double> currentRule, Double newValue, String string) {
            return newValue == -1.0 || newValue >= 0.0 ? newValue : null;
        }

        @Override
        public String description() {
            return "Cannot be negative, except for -1";
        }
    }

    private static class CheckOptimizedTntEnabledValidator<T>
    extends Validator<T> {
        private CheckOptimizedTntEnabledValidator() {
        }

        @Override
        public T validate(class_2168 source, ParsedRule<T> currentRule, T newValue, String string) {
            return (T)(optimizedTNT || currentRule.defaultValue.equals(newValue) ? newValue : null);
        }

        @Override
        public String description() {
            return "optimizedTNT must be enabled";
        }
    }

    private static class OneHourMaxDelayLimit
    extends Validator<Integer> {
        private OneHourMaxDelayLimit() {
        }

        @Override
        public Integer validate(class_2168 source, ParsedRule<Integer> currentRule, Integer newValue, String string) {
            return newValue > 0 && newValue <= 72000 ? newValue : null;
        }

        @Override
        public String description() {
            return "You must choose a value from 1 to 72000";
        }
    }

    private static class LanguageValidator
    extends Validator<String> {
        private LanguageValidator() {
        }

        @Override
        public String validate(class_2168 source, ParsedRule<String> currentRule, String newValue, String string) {
            if (currentRule.get().equals(newValue) || source == null) {
                return newValue;
            }
            if (!Translations.isValidLanguage(newValue)) {
                Messenger.m(source, "r " + newValue + " is not a valid language");
                return null;
            }
            language = newValue;
            Translations.updateLanguage(source);
            return newValue;
        }
    }
}

