"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EventBridgePutEvents = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const sfn = require("@aws-cdk/aws-stepfunctions");
const cdk = require("@aws-cdk/core");
const task_utils_1 = require("../private/task-utils");
/**
 * A StepFunctions Task to send events to an EventBridge event bus
 */
class EventBridgePutEvents extends sfn.TaskStateBase {
    constructor(scope, id, props) {
        var _b;
        super(scope, id, props);
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_tasks_EventBridgePutEventsProps(props);
        this.integrationPattern = (_b = props.integrationPattern) !== null && _b !== void 0 ? _b : sfn.IntegrationPattern.REQUEST_RESPONSE;
        task_utils_1.validatePatternSupported(this.integrationPattern, EventBridgePutEvents.SUPPORTED_INTEGRATION_PATTERNS);
        if (this.integrationPattern === sfn.IntegrationPattern.WAIT_FOR_TASK_TOKEN) {
            if (!sfn.FieldUtils.containsTaskToken(props.entries.map(entry => entry.detail))) {
                throw new Error('Task Token is required in `entries`. Use JsonPath.taskToken to set the token.');
            }
        }
        this.validateEntries();
        this.taskPolicies = [
            new iam.PolicyStatement({
                actions: ['events:PutEvents'],
                resources: this.eventBusArns,
            }),
        ];
    }
    /**
     * Returns an array of EventBusArn strings based on this.props.entries
     */
    get eventBusArns() {
        return this.props.entries
            .map(entry => {
            if (entry.eventBus) {
                // If an eventBus is provided, use the corresponding ARN
                return entry.eventBus.eventBusArn;
            }
            else {
                // If neither an eventBus nor eventBusName is provided,
                // format the ARN for the default event bus in the account.
                return cdk.Stack.of(this).formatArn({
                    resource: 'event-bus',
                    resourceName: 'default',
                    arnFormat: cdk.ArnFormat.SLASH_RESOURCE_NAME,
                    service: 'events',
                });
            }
        });
    }
    /**
     * Provides the EventBridge put events service integration task configuration
     * @internal
     */
    _renderTask() {
        return {
            Resource: task_utils_1.integrationResourceArn('events', 'putEvents', this.integrationPattern),
            Parameters: sfn.FieldUtils.renderObject({
                Entries: this.renderEntries(),
            }),
        };
    }
    renderEntries() {
        return this.props.entries.map(entry => {
            var _b, _c, _d;
            if ((_b = entry.source) === null || _b === void 0 ? void 0 : _b.startsWith('aws')) {
                throw new Error('Event source cannot start with "aws."');
            }
            else {
                return {
                    Detail: (_c = entry.detail) === null || _c === void 0 ? void 0 : _c.value,
                    DetailType: entry.detailType,
                    EventBusName: (_d = entry.eventBus) === null || _d === void 0 ? void 0 : _d.eventBusArn,
                    Source: entry.source,
                };
            }
        });
    }
    validateEntries() {
        if (this.props.entries.length <= 0) {
            throw new Error('Value for property `entries` must be a non-empty array.');
        }
    }
}
exports.EventBridgePutEvents = EventBridgePutEvents;
_a = JSII_RTTI_SYMBOL_1;
EventBridgePutEvents[_a] = { fqn: "@aws-cdk/aws-stepfunctions-tasks.EventBridgePutEvents", version: "1.150.0" };
EventBridgePutEvents.SUPPORTED_INTEGRATION_PATTERNS = [
    sfn.IntegrationPattern.REQUEST_RESPONSE,
    sfn.IntegrationPattern.WAIT_FOR_TASK_TOKEN,
];
//# sourceMappingURL=data:application/json;base64,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