"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DynamoGetItem = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const sfn = require("@aws-cdk/aws-stepfunctions");
const core_1 = require("@aws-cdk/core");
const utils_1 = require("./private/utils");
/**
 * A StepFunctions task to call DynamoGetItem
 */
class DynamoGetItem extends sfn.TaskStateBase {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_tasks_DynamoGetItemProps(props);
        this.taskPolicies = [
            new iam.PolicyStatement({
                resources: [
                    core_1.Stack.of(this).formatArn({
                        service: 'dynamodb',
                        resource: 'table',
                        resourceName: props.table.tableName,
                    }),
                ],
                actions: [`dynamodb:${utils_1.DynamoMethod.GET}Item`],
            }),
        ];
    }
    /**
     * @internal
     */
    _renderTask() {
        var _b;
        return {
            Resource: utils_1.getDynamoResourceArn(utils_1.DynamoMethod.GET),
            Parameters: sfn.FieldUtils.renderObject({
                Key: utils_1.transformAttributeValueMap(this.props.key),
                TableName: this.props.table.tableName,
                ConsistentRead: (_b = this.props.consistentRead) !== null && _b !== void 0 ? _b : false,
                ExpressionAttributeNames: this.props.expressionAttributeNames,
                ProjectionExpression: this.configureProjectionExpression(this.props.projectionExpression),
                ReturnConsumedCapacity: this.props.returnConsumedCapacity,
            }),
        };
    }
    configureProjectionExpression(expressions) {
        return expressions ? expressions.map((expression) => expression.toString()).join(',') : undefined;
    }
}
exports.DynamoGetItem = DynamoGetItem;
_a = JSII_RTTI_SYMBOL_1;
DynamoGetItem[_a] = { fqn: "@aws-cdk/aws-stepfunctions-tasks.DynamoGetItem", version: "1.150.0" };
//# sourceMappingURL=data:application/json;base64,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