# Generated by Django 3.2.12 on 2022-06-24 12:00

from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='SpiderStats',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('host', models.CharField(max_length=50)),
                ('project', models.CharField(max_length=255)),
                ('spider', models.CharField(max_length=255)),
                ('job_id', models.CharField(db_index=True, max_length=50)),
                ('run_type', models.CharField(max_length=50, verbose_name='interval or crontab')),
                ('last_run', models.DateTimeField()),
                ('trigger', models.CharField(max_length=50)),
                ('record_time', models.DateTimeField(auto_now=True, verbose_name='当前时间')),
                ('log_debug_count', models.BigIntegerField(default=0)),
                ('log_info_count', models.BigIntegerField(default=0)),
                ('log_warn_count', models.IntegerField(default=0)),
                ('log_error_count', models.IntegerField(default=0)),
                ('log_critical_count', models.IntegerField(default=0)),
                ('log_hourly_error_rate', models.FloatField(verbose_name='1小时日志错误率')),
                ('memory_use', models.FloatField(null=True, verbose_name='占用最大的内存')),
                ('start_time', models.DateTimeField()),
                ('finish_time', models.DateTimeField(default=None, null=True)),
                ('finish_reason', models.CharField(default='', max_length=255, null=True, verbose_name='爬虫关闭原因')),
                ('elapsed_time', models.CharField(default='', max_length=255, null=True)),
                ('stats', models.TextField(verbose_name='统计数据')),
                ('state', models.SmallIntegerField(verbose_name='1：正在运行， 0：已完成')),
                ('create_time', models.DateTimeField(auto_now=True)),
                ('update_time', models.DateTimeField(auto_now_add=True)),
            ],
        ),
    ]
