# Generated by Django 2.0.7 on 2018-07-23 17:53

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("plans", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="Payment",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("variant", models.CharField(max_length=255)),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("waiting", "Waiting for confirmation"),
                            ("preauth", "Pre-authorized"),
                            ("confirmed", "Confirmed"),
                            ("rejected", "Rejected"),
                            ("refunded", "Refunded"),
                            ("error", "Error"),
                            ("input", "Input"),
                        ],
                        default="waiting",
                        max_length=10,
                    ),
                ),
                (
                    "fraud_status",
                    models.CharField(
                        choices=[
                            ("unknown", "Unknown"),
                            ("accept", "Passed"),
                            ("reject", "Rejected"),
                            ("review", "Review"),
                        ],
                        default="unknown",
                        max_length=10,
                        verbose_name="fraud check",
                    ),
                ),
                ("fraud_message", models.TextField(blank=True, default="")),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("modified", models.DateTimeField(auto_now=True)),
                ("transaction_id", models.CharField(blank=True, max_length=255)),
                ("currency", models.CharField(max_length=10)),
                (
                    "total",
                    models.DecimalField(decimal_places=2, default="0.0", max_digits=9),
                ),
                (
                    "delivery",
                    models.DecimalField(decimal_places=2, default="0.0", max_digits=9),
                ),
                (
                    "tax",
                    models.DecimalField(decimal_places=2, default="0.0", max_digits=9),
                ),
                ("description", models.TextField(blank=True, default="")),
                ("billing_first_name", models.CharField(blank=True, max_length=256)),
                ("billing_last_name", models.CharField(blank=True, max_length=256)),
                ("billing_address_1", models.CharField(blank=True, max_length=256)),
                ("billing_address_2", models.CharField(blank=True, max_length=256)),
                ("billing_city", models.CharField(blank=True, max_length=256)),
                ("billing_postcode", models.CharField(blank=True, max_length=256)),
                ("billing_country_code", models.CharField(blank=True, max_length=2)),
                ("billing_country_area", models.CharField(blank=True, max_length=256)),
                ("billing_email", models.EmailField(blank=True, max_length=254)),
                (
                    "customer_ip_address",
                    models.GenericIPAddressField(blank=True, null=True),
                ),
                ("extra_data", models.TextField(blank=True, default="")),
                ("message", models.TextField(blank=True, default="")),
                ("token", models.CharField(blank=True, default="", max_length=36)),
                (
                    "captured_amount",
                    models.DecimalField(decimal_places=2, default="0.0", max_digits=9),
                ),
                (
                    "order",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="plans.Order",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
    ]
