# coding: utf-8

"""
    IONOS DBaaS REST API

    An enterprise-grade Database is provided as a Service (DBaaS) solution that can be managed through a browser-based \"Data Center Designer\" (DCD) tool or via an easy to use API.  The API allows you to create additional database clusters or modify existing ones. It is designed to allow users to leverage the same power and flexibility found within the DCD visual tool. Both tools are consistent with their concepts and lend well to making the experience smooth and intuitive.   # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ionoscloud_dbaas_postgres.configuration import Configuration


class ClusterBackup(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {

        'id': 'str',

        'cluster_id': 'str',

        'version': 'str',

        'is_active': 'bool',

        'earliest_recovery_target_time': 'datetime',
    }

    attribute_map = {

        'id': 'id',

        'cluster_id': 'clusterId',

        'version': 'version',

        'is_active': 'isActive',

        'earliest_recovery_target_time': 'earliestRecoveryTargetTime',
    }

    def __init__(self, id=None, cluster_id=None, version=None, is_active=None, earliest_recovery_target_time=None, local_vars_configuration=None):  # noqa: E501
        """ClusterBackup - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._cluster_id = None
        self._version = None
        self._is_active = None
        self._earliest_recovery_target_time = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if cluster_id is not None:
            self.cluster_id = cluster_id
        if version is not None:
            self.version = version
        if is_active is not None:
            self.is_active = is_active
        if earliest_recovery_target_time is not None:
            self.earliest_recovery_target_time = earliest_recovery_target_time


    @property
    def id(self):
        """Gets the id of this ClusterBackup.  # noqa: E501

        The unique ID of the resource.  # noqa: E501

        :return: The id of this ClusterBackup.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ClusterBackup.

        The unique ID of the resource.  # noqa: E501

        :param id: The id of this ClusterBackup.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def cluster_id(self):
        """Gets the cluster_id of this ClusterBackup.  # noqa: E501

        The unique ID of the cluster.  # noqa: E501

        :return: The cluster_id of this ClusterBackup.  # noqa: E501
        :rtype: str
        """
        return self._cluster_id

    @cluster_id.setter
    def cluster_id(self, cluster_id):
        """Sets the cluster_id of this ClusterBackup.

        The unique ID of the cluster.  # noqa: E501

        :param cluster_id: The cluster_id of this ClusterBackup.  # noqa: E501
        :type cluster_id: str
        """

        self._cluster_id = cluster_id

    @property
    def version(self):
        """Gets the version of this ClusterBackup.  # noqa: E501

        The PostgreSQL version this backup was created from.  # noqa: E501

        :return: The version of this ClusterBackup.  # noqa: E501
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this ClusterBackup.

        The PostgreSQL version this backup was created from.  # noqa: E501

        :param version: The version of this ClusterBackup.  # noqa: E501
        :type version: str
        """

        self._version = version

    @property
    def is_active(self):
        """Gets the is_active of this ClusterBackup.  # noqa: E501

        Whether a cluster currently backs up data to this backup.  # noqa: E501

        :return: The is_active of this ClusterBackup.  # noqa: E501
        :rtype: bool
        """
        return self._is_active

    @is_active.setter
    def is_active(self, is_active):
        """Sets the is_active of this ClusterBackup.

        Whether a cluster currently backs up data to this backup.  # noqa: E501

        :param is_active: The is_active of this ClusterBackup.  # noqa: E501
        :type is_active: bool
        """

        self._is_active = is_active

    @property
    def earliest_recovery_target_time(self):
        """Gets the earliest_recovery_target_time of this ClusterBackup.  # noqa: E501

        The oldest available timestamp to which you can restore.  # noqa: E501

        :return: The earliest_recovery_target_time of this ClusterBackup.  # noqa: E501
        :rtype: datetime
        """
        return self._earliest_recovery_target_time

    @earliest_recovery_target_time.setter
    def earliest_recovery_target_time(self, earliest_recovery_target_time):
        """Sets the earliest_recovery_target_time of this ClusterBackup.

        The oldest available timestamp to which you can restore.  # noqa: E501

        :param earliest_recovery_target_time: The earliest_recovery_target_time of this ClusterBackup.  # noqa: E501
        :type earliest_recovery_target_time: datetime
        """

        self._earliest_recovery_target_time = earliest_recovery_target_time
    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ClusterBackup):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ClusterBackup):
            return True

        return self.to_dict() != other.to_dict()
