# Generated by Django 4.2.7 on 2023-11-19 13:54

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django_enumfield.db.fields
import mailinglist.enum


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="MailingList",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=128)),
                ("slug", models.SlugField(unique=True)),
                ("email", models.EmailField(help_text="Sender e-mail", max_length=254)),
                ("sender", models.CharField(help_text="Sender name", max_length=200)),
                ("visible", models.BooleanField(db_index=True, default=True)),
                (
                    "send_html",
                    models.BooleanField(
                        default=True,
                        help_text="Whether or not to send HTML versions of e-mails.",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Message",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("title", models.CharField(max_length=128)),
                ("slug", models.SlugField()),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("modified", models.DateTimeField(auto_now=True)),
                (
                    "mailing_list",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="messages",
                        to="mailinglist.mailinglist",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Sending",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("sent", models.DateTimeField(auto_now_add=True)),
            ],
        ),
        migrations.CreateModel(
            name="Subscription",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("token", models.CharField(max_length=45)),
                (
                    "status",
                    django_enumfield.db.fields.EnumField(
                        default=0, enum=mailinglist.enum.SubscriptionStatusEnum
                    ),
                ),
                (
                    "mailing_list",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="subscriptions",
                        to="mailinglist.mailinglist",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="subscriptions",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="SubscriptionChange",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "from_status",
                    django_enumfield.db.fields.EnumField(
                        blank=True,
                        default=0,
                        enum=mailinglist.enum.SubscriptionStatusEnum,
                        null=True,
                    ),
                ),
                (
                    "to_status",
                    django_enumfield.db.fields.EnumField(
                        default=0, enum=mailinglist.enum.SubscriptionStatusEnum
                    ),
                ),
                ("changed", models.DateTimeField(auto_now_add=True)),
                (
                    "subscription",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="mailinglist.subscription",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Submission",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("published", models.DateTimeField(blank=True, null=True)),
                (
                    "status",
                    django_enumfield.db.fields.EnumField(
                        default=0, enum=mailinglist.enum.SubmissionStatusEnum
                    ),
                ),
                (
                    "exclude",
                    models.ManyToManyField(
                        blank=True,
                        help_text="Subscriptions to exclude from mailing, all other subscribers will receive message",
                        to="mailinglist.subscription",
                    ),
                ),
                (
                    "message",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="submission",
                        to="mailinglist.message",
                    ),
                ),
                (
                    "sendings",
                    models.ManyToManyField(
                        related_name="sendings",
                        through="mailinglist.Sending",
                        to="mailinglist.subscription",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="sending",
            name="submission",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT, to="mailinglist.submission"
            ),
        ),
        migrations.AddField(
            model_name="sending",
            name="subscription",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT,
                to="mailinglist.subscription",
            ),
        ),
        migrations.CreateModel(
            name="MessagePart",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("heading", models.CharField(max_length=128)),
                ("order", models.PositiveSmallIntegerField()),
                ("text", models.TextField()),
                (
                    "message",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="message_parts",
                        to="mailinglist.message",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="GlobalDeny",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                (
                    "user",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="mailinglist_deny",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.AddConstraint(
            model_name="subscription",
            constraint=models.UniqueConstraint(
                fields=("user", "mailing_list"), name="unique_user_per_mailing_list"
            ),
        ),
        migrations.AddConstraint(
            model_name="messagepart",
            constraint=models.UniqueConstraint(
                fields=("message", "order"), name="unique_order_per_message"
            ),
        ),
        migrations.AddConstraint(
            model_name="message",
            constraint=models.UniqueConstraint(
                fields=("slug", "mailing_list"), name="unique_slug_per_mailing_list"
            ),
        ),
    ]
