# Generated by Django 3.2.15 on 2022-09-01 03:57

import uuid
from django.conf import settings
from django.db import migrations, models
import django.db.migrations.operations.special
import django.db.models.deletion
import django.utils.timezone
from django.contrib.auth.hashers import make_password
from ..utils import AnsibleModules
from ..models.base import (
    first_staff_user,
    ManyToManyFieldACLReverse,
    ManyToManyFieldACL,
    ForeignKeyACL
)


def create_admin_user(apps, schema_editor):
    User = apps.get_registered_model('auth', 'User')
    admin = User(
        username='admin',
        email='admin@domain.com',
        password=make_password('admin'),
        is_superuser=True,
        is_staff=True
    )
    admin.save()


def sync_modules(apps, schema_editor):
    Module = apps.get_registered_model('main', 'Module')
    modules = AnsibleModules(detailed=False)
    modules_list = modules.all()
    modules_list.sort()
    Module.objects.bulk_create([
        Module(path=module, project=None) for module in modules_list
    ])


class Migration(migrations.Migration):

    replaces = [
        ('main', '0001_v2'),
        ('main', '0002_modules_and_rename'),
        ('main', '0003_models_optimization'),
        ('main', '0004_projecttemplate'),
        ('main', '0005_history_on_delete'),
        ('main', '0006_migrate_django_22'),
        ('main', '0007_auto_20200615_0402'),
        ('main', '0008_auto_20200618_0818'),
        ('main', '0009_auto_20200622_0618'),
        ('main', '0010_templateoption'),
        ('main', '0011_auto_20220301_0735'),
        ('main', '0012_change_history_lines'),
        ('main', '0013_delete_usersettings'),
        ('main', '0014_auto_20220831_0237')
    ]

    initial = True

    dependencies = [
        ('auth', '0008_alter_user_username_max_length'),
        ('auth', '0006_require_contenttypes_0002'),
        ('contenttypes', '0002_remove_content_type_name'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.RunPython(
            code=create_admin_user,
            reverse_code=migrations.RunPython.noop
        ),
        migrations.CreateModel(
            name='ProjectTemplate',
            fields=[
                ('id', models.PositiveIntegerField(primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=1024)),
                ('description', models.TextField()),
                ('repository', models.CharField(max_length=2048)),
                ('type', models.CharField(choices=[('GIT', 'GIT'), ('TAR', 'TAR')], default='GIT', max_length=256)),
                ('repo_auth', models.CharField(choices=[('NONE', 'NONE'), ('KEY', 'KEY'), ('PASSWORD', 'PASSWORD')], default='NONE', max_length=256)),
                ('auth_data', models.TextField(blank=True, default=None, null=True)),
            ],
            options={
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='TemplateOption',
            fields=[
                ('id', models.SlugField(max_length=256, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=256)),
                ('data', models.JSONField(default=dict)),
            ],
            options={
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='ACLPermission',
            fields=[
                ('id', models.AutoField(max_length=20, primary_key=True, serialize=False)),
                ('hidden', models.BooleanField(default=False)),
                ('role', models.CharField(max_length=10)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Group',
            fields=[
                ('id', models.AutoField(max_length=20, primary_key=True, serialize=False)),
                ('hidden', models.BooleanField(default=False)),
                ('notes', models.TextField(default='')),
                ('name', models.CharField(default=uuid.uuid1, max_length=512)),
                ('children', models.BooleanField(default=False)),
                ('acl', models.ManyToManyField(blank=True, related_name='groups', to='main.ACLPermission')),
            ],
            options={
                'default_related_name': 'groups',
            },
        ),
        migrations.CreateModel(
            name='History',
            fields=[
                ('id', models.AutoField(max_length=20, primary_key=True, serialize=False)),
                ('hidden', models.BooleanField(default=False)),
                ('mode', models.CharField(max_length=256)),
                ('revision', models.CharField(blank=True, max_length=256, null=True)),
                ('kind', models.CharField(db_index=True, default='PLAYBOOK', max_length=50)),
                ('start_time', models.DateTimeField(default=django.utils.timezone.now)),
                ('stop_time', models.DateTimeField(blank=True, null=True)),
                ('raw_args', models.TextField(default='')),
                ('json_args', models.TextField(default='{}')),
                ('raw_inventory', models.TextField(default='')),
                ('status', models.CharField(db_index=True, max_length=50)),
                ('initiator', models.IntegerField(default=0)),
                ('initiator_type', models.CharField(default='project', max_length=50)),
                ('json_options', models.TextField(default='{}')),
                ('executor', models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='history', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ['-start_time'],
                'default_related_name': 'history',
            },
        ),
        migrations.CreateModel(
            name='Hook',
            fields=[
                ('id', models.AutoField(max_length=20, primary_key=True, serialize=False)),
                ('hidden', models.BooleanField(default=False)),
                ('name', models.CharField(default=uuid.uuid1, max_length=512)),
                ('type', models.CharField(db_index=True, max_length=32)),
                ('when', models.CharField(db_index=True, default=None, max_length=32, null=True)),
                ('enable', models.BooleanField(db_index=True, default=True)),
                ('recipients', models.TextField()),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Host',
            fields=[
                ('id', models.AutoField(max_length=20, primary_key=True, serialize=False)),
                ('hidden', models.BooleanField(default=False)),
                ('notes', models.TextField(default='')),
                ('name', models.CharField(default=uuid.uuid1, max_length=512)),
                ('type', models.CharField(default='HOST', max_length=5)),
                ('acl', models.ManyToManyField(blank=True, related_name='hosts', to='main.ACLPermission')),
            ],
            options={
                'default_related_name': 'hosts',
            },
        ),
        migrations.CreateModel(
            name='Inventory',
            fields=[
                ('id', models.AutoField(max_length=20, primary_key=True, serialize=False)),
                ('hidden', models.BooleanField(default=False)),
                ('notes', models.TextField(default='')),
                ('name', models.CharField(default=uuid.uuid1, max_length=512)),
                ('acl', models.ManyToManyField(blank=True, related_name='inventories', to='main.ACLPermission')),
                ('groups', ManyToManyFieldACL(related_name='inventories', to='main.Group')),
                ('hosts', ManyToManyFieldACL(related_name='inventories', to='main.Host')),
            ],
            options={
                'default_related_name': 'inventories',
            },
        ),
        migrations.CreateModel(
            name='Project',
            fields=[
                ('id', models.AutoField(max_length=20, primary_key=True, serialize=False)),
                ('hidden', models.BooleanField(default=False)),
                ('notes', models.TextField(default='')),
                ('name', models.CharField(default=uuid.uuid1, max_length=512)),
                ('repository', models.CharField(max_length=2048)),
                ('status', models.CharField(default='NEW', max_length=32)),
                ('acl', models.ManyToManyField(blank=True, related_name='projects', to='main.ACLPermission')),
                ('groups', ManyToManyFieldACL(blank=True, related_name='projects', to='main.Group')),
                ('hosts', ManyToManyFieldACL(blank=True, related_name='projects', to='main.Host')),
                ('inventories', ManyToManyFieldACL(blank=True, related_name='projects', to='main.Inventory')),
                ('owner', models.ForeignKey(default=first_staff_user, on_delete=django.db.models.deletion.SET_DEFAULT, related_name='polemarch_project_set', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'default_related_name': 'projects',
            },
        ),
        migrations.CreateModel(
            name='Variable',
            fields=[
                ('id', models.AutoField(max_length=20, primary_key=True, serialize=False)),
                ('hidden', models.BooleanField(default=False)),
                ('object_id', models.PositiveIntegerField()),
                ('key', models.CharField(max_length=512)),
                ('value', models.TextField(null=True)),
                ('content_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.contenttype')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='UserGroup',
            fields=[
                ('hidden', models.BooleanField(default=False)),
                ('notes', models.TextField(default='')),
                ('parent', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='auth.group')),
                ('acl', models.ManyToManyField(blank=True, to='main.ACLPermission')),
                ('owner', models.ForeignKey(default=first_staff_user, on_delete=django.db.models.deletion.SET_DEFAULT, related_name='polemarch_usergroup_set', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'abstract': False,
            },
            bases=('auth.group', models.Model),
        ),
        migrations.CreateModel(
            name='Template',
            fields=[
                ('id', models.AutoField(max_length=20, primary_key=True, serialize=False)),
                ('hidden', models.BooleanField(default=False)),
                ('notes', models.TextField(default='')),
                ('name', models.CharField(max_length=512)),
                ('kind', models.CharField(max_length=32)),
                ('template_data', models.TextField(default='{}')),
                ('options_data', models.TextField(default='{}')),
                ('inventory', models.CharField(blank=True, default=None, max_length=128, null=True)),
                ('acl', models.ManyToManyField(blank=True, related_name='template', to='main.ACLPermission')),
                ('owner', models.ForeignKey(default=first_staff_user, on_delete=django.db.models.deletion.SET_DEFAULT, related_name='polemarch_template_set', to=settings.AUTH_USER_MODEL)),
                ('project', ForeignKeyACL(blank=True, default=None, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='template', to='main.project')),
            ],
            options={
                'default_related_name': 'template',
            },
        ),
        migrations.CreateModel(
            name='Task',
            fields=[
                ('id', models.AutoField(max_length=20, primary_key=True, serialize=False)),
                ('hidden', models.BooleanField(default=False)),
                ('name', models.CharField(default=uuid.uuid1, max_length=251)),
                ('playbook', models.CharField(max_length=256)),
                ('project', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='playbook', related_query_name='playbook', to='main.project')),
            ],
            options={
                'default_related_name': 'playbook',
            },
        ),
        migrations.CreateModel(
            name='PeriodicTask',
            fields=[
                ('id', models.AutoField(max_length=20, primary_key=True, serialize=False)),
                ('hidden', models.BooleanField(default=False)),
                ('notes', models.TextField(default='')),
                ('name', models.CharField(default=uuid.uuid1, max_length=512)),
                ('mode', models.CharField(max_length=256)),
                ('kind', models.CharField(default='PLAYBOOK', max_length=50)),
                ('inventory_file', models.CharField(blank=True, max_length=2048, null=True)),
                ('schedule', models.CharField(max_length=768)),
                ('type', models.CharField(max_length=10)),
                ('save_result', models.BooleanField(default=True)),
                ('enabled', models.BooleanField(default=True)),
                ('template_opt', models.CharField(blank=True, max_length=256, null=True)),
                ('_inventory', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='periodic_task', related_query_name='periodic_task', to='main.inventory')),
                ('acl', models.ManyToManyField(blank=True, related_name='periodic_task', to='main.ACLPermission')),
                ('owner', models.ForeignKey(default=first_staff_user, on_delete=django.db.models.deletion.SET_DEFAULT, related_name='polemarch_periodictask_set', to=settings.AUTH_USER_MODEL)),
                ('project', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='periodic_task', related_query_name='periodic_task', to='main.project')),
                ('template', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='periodic_task', related_query_name='periodic_task', to='main.template')),
            ],
            options={
                'default_related_name': 'periodic_task',
            },
        ),
        migrations.CreateModel(
            name='Module',
            fields=[
                ('id', models.AutoField(max_length=20, primary_key=True, serialize=False)),
                ('hidden', models.BooleanField(default=False)),
                ('path', models.CharField(max_length=1024)),
                ('_data', models.CharField(default='{}', max_length=4096)),
                ('project', models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='modules', related_query_name='modules', to='main.project')),
            ],
            options={
                'default_related_name': 'modules',
            },
        ),
        migrations.AddField(
            model_name='inventory',
            name='master_project',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='slave_inventory', to='main.project'),
        ),
        migrations.AddField(
            model_name='inventory',
            name='owner',
            field=models.ForeignKey(default=first_staff_user, on_delete=django.db.models.deletion.SET_DEFAULT, related_name='polemarch_inventory_set', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='host',
            name='master_project',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='slave_host', to='main.project'),
        ),
        migrations.AddField(
            model_name='host',
            name='owner',
            field=models.ForeignKey(default=first_staff_user, on_delete=django.db.models.deletion.SET_DEFAULT, related_name='polemarch_host_set', to=settings.AUTH_USER_MODEL),
        ),
        migrations.CreateModel(
            name='HistoryLines',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('line', models.TextField(default='')),
                ('line_number', models.IntegerField(default=0)),
                ('line_gnumber', models.IntegerField(default=0)),
                ('history', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='raw_history_line', related_query_name='raw_history_line', to='main.history')),
            ],
            options={
                'ordering': ['-line_gnumber', '-line_number'],
                'default_related_name': 'raw_history_line',
            },
        ),
        migrations.AddField(
            model_name='history',
            name='inventory',
            field=models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='history', related_query_name='history', to='main.inventory'),
        ),
        migrations.AddField(
            model_name='history',
            name='project',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='history', related_query_name='history', to='main.project'),
        ),
        migrations.AddField(
            model_name='group',
            name='hosts',
            field=ManyToManyFieldACL(related_name='groups', related_query_name='groups', to='main.Host'),
        ),
        migrations.AddField(
            model_name='group',
            name='master_project',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='slave_group', to='main.project'),
        ),
        migrations.AddField(
            model_name='group',
            name='owner',
            field=models.ForeignKey(default=first_staff_user, on_delete=django.db.models.deletion.SET_DEFAULT, related_name='polemarch_group_set', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='group',
            name='parents',
            field=ManyToManyFieldACLReverse(blank=True, related_name='groups', related_query_name='childrens', to='main.Group'),
        ),
        migrations.AddField(
            model_name='aclpermission',
            name='uagroup',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='main.usergroup'),
        ),
        migrations.AddField(
            model_name='aclpermission',
            name='user',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddIndex(
            model_name='group',
            index=models.Index(fields=['children'], name='main_group_childre_ec8fc8_idx'),
        ),
        migrations.AddIndex(
            model_name='group',
            index=models.Index(fields=['children', 'id'], name='main_group_childre_f8a3bd_idx'),
        ),
        migrations.RunPython(
            code=sync_modules,
            reverse_code=migrations.RunPython.noop
        ),
    ]
