import * as cdk from 'aws-cdk-lib';
/**
 * Deployment environment for an AWS Service Catalog product stack.
 *
 * Interoperates with the StackSynthesizer of the parent stack.
 */
export declare class ProductStackSynthesizer extends cdk.StackSynthesizer {
    private stack?;
    bind(stack: cdk.Stack): void;
    addFileAsset(_asset: cdk.FileAssetSource): cdk.FileAssetLocation;
    addDockerImageAsset(_asset: cdk.DockerImageAssetSource): cdk.DockerImageAssetLocation;
    synthesize(session: cdk.ISynthesisSession): void;
}
