"""All current generation AWS instance types and zones.

Sources:
https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html
https://stelligent.com/2014/05/02/list-all-the-availability-zones/
"""
import boto3


ZONES = {
    "eu-north-1a",
    "eu-north-1b",
    "eu-north-1c",
    "ap-south-1a",
    "ap-south-1b",
    "ap-south-1c",
    "eu-west-3a",
    "eu-west-3b",
    "eu-west-3c",
    "eu-west-2a",
    "eu-west-2b",
    "eu-west-2c",
    "eu-west-1a",
    "eu-west-1b",
    "eu-west-1c",
    "ap-northeast-3a",
    "ap-northeast-3b",
    "ap-northeast-3c",
    "ap-northeast-2a",
    "ap-northeast-2b",
    "ap-northeast-2c",
    "ap-northeast-2d",
    "ap-northeast-1a",
    "ap-northeast-1c",
    "ap-northeast-1d",
    "sa-east-1a",
    "sa-east-1b",
    "sa-east-1c",
    "ca-central-1a",
    "ca-central-1b",
    "ca-central-1d",
    "ap-southeast-1a",
    "ap-southeast-1b",
    "ap-southeast-1c",
    "ap-southeast-2a",
    "ap-southeast-2b",
    "ap-southeast-2c",
    "eu-central-1a",
    "eu-central-1b",
    "eu-central-1c",
    "us-east-1a",
    "us-east-1b",
    "us-east-1c",
    "us-east-1d",
    "us-east-1e",
    "us-east-1f",
    "us-east-2a",
    "us-east-2b",
    "us-east-2c",
    "us-west-1b",
    "us-west-1c",
    "us-west-2a",
    "us-west-2b",
    "us-west-2c",
    "us-west-2d",
}


def print_all_zones() -> None:
    """Print all AWS availability zones.

    Prerequisits: Install and configure AWS CLI: http://aws.amazon.com/cli/

    Source: https://stelligent.com/2014/05/02/list-all-the-availability-zones/"""
    ec2 = boto3.client("ec2")
    # Retrieves all regions/endpoints that work with EC2
    aws_regions = ec2.describe_regions()
    # Get a list of regions and then instantiate a new ec2 client for
    # each region in order to get list of AZs for the region
    for region in aws_regions["Regions"]:
        my_region_name = region["RegionName"]
        ec2_region = boto3.client("ec2", region_name=my_region_name)
        my_region = [{"Name": "region-name", "Values": [my_region_name]}]
        # print ("Current Region is %s" % my_region_name)
        aws_azs = ec2_region.describe_availability_zones(Filters=my_region)
        for az in aws_azs["AvailabilityZones"]:
            zone = az["ZoneName"]
            print(zone)


INSTANCE_TYPES = {
    "c4.large",
    "c4.xlarge",
    "c4.2xlarge",
    "c4.4xlarge",
    "c4.8xlarge",
    "c5.large",
    "c5.xlarge",
    "c5.2xlarge",
    "c5.4xlarge",
    "c5.9xlarge",
    "c5.12xlarge",
    "c5.18xlarge",
    "c5.24xlarge",
    "c5.metal",
    # Compute optimized
    "c5a.large",
    "c5a.xlarge",
    "c5a.2xlarge",
    "c5a.4xlarge",
    "c5a.8xlarge",
    "c5a.12xlarge",
    "c5a.16xlarge",
    "c5a.24xlarge",
    # Compute optimized
    "c5ad.large",
    "c5ad.xlarge",
    "c5ad.2xlarge",
    "c5ad.4xlarge",
    "c5ad.8xlarge",
    "c5ad.12xlarge",
    "c5ad.16xlarge",
    "c5ad.24xlarge",
    # Compute Optimized
    "c5d.large",
    "c5d.xlarge",
    "c5d.2xlarge",
    "c5d.4xlarge",
    "c5d.9xlarge",
    "c5d.12xlarge",
    "c5d.18xlarge",
    "c5d.24xlarge",
    "c5d.metal",
    # Compute Optimized
    "c5n.large",
    "c5n.xlarge",
    "c5n.2xlarge",
    "c5n.4xlarge",
    "c5n.9xlarge",
    "c5n.18xlarge",
    "c5n.metal",
    # Compute Optimized
    "c6g.medium",
    "c6g.large",
    "c6g.xlarge",
    "c6g.2xlarge",
    "c6g.4xlarge",
    "c6g.8xlarge",
    "c6g.12xlarge",
    "c6g.16xlarge",
    "c6g.metal",
    # Compute Optimized
    "c6gd.medium",
    "c6gd.large",
    "c6gd.xlarge",
    "c6gd.2xlarge",
    "c6gd.4xlarge",
    "c6gd.8xlarge",
    "c6gd.12xlarge",
    "c6gd.16xlarge",
    "c6gd.metal",
    # Compute Optimized
    "c6gn.medium",
    "c6gn.large",
    "c6gn.xlarge",
    "c6gn.2xlarge",
    "c6gn.4xlarge",
    "c6gn.8xlarge",
    "c6gn.12xlarge",
    "c6gn.16xlarge",
    # Compute Optimized
    "c6i.large",
    "c6i.xlarge",
    "c6i.2xlarge",
    "c6i.4xlarge",
    "c6i.8xlarge",
    "c6i.12xlarge",
    "c6i.16xlarge",
    "c6i.24xlarge",
    "c6i.32xlarge",
    "c6i.metal",
    # Compute Optimized
    "d2.xlarge",
    "d2.2xlarge",
    "d2.4xlarge",
    "d2.8xlarge",
    # Storage Optimized
    "d3.xlarge",
    "d3.2xlarge",
    "d3.4xlarge",
    "d3.8xlarge",
    # Storage Optimized
    "d3en.large",
    "d3en.xlarge",
    "d3en.2xlarge",
    "d3en.4xlarge",
    "d3en.6xlarge",
    "d3en.8xlarge",
    "d3en.12xlarge",
    # Storage Optimized
    "dl1.24xlarge",
    # Accelerated Computing
    "f1.2xlarge",
    "f1.4xlarge",
    "f1.16xlarge",
    # Accelerated Computing
    "g3s.xlarge",
    "g3.4xlarge",
    "g3.8xlarge",
    "g3.16xlarge",
    # Accelerated Computing
    "g4ad.xlarge",
    "g4ad.2xlarge",
    "g4ad.4xlarge",
    "g4ad.8xlarge",
    "g4ad.16xlarge",
    # Accelerated Computing
    "g4dn.xlarge",
    "g4dn.2xlarge",
    "g4dn.4xlarge",
    "g4dn.8xlarge",
    "g4dn.12xlarge",
    "g4dn.16xlarge",
    "g4dn.metal",
    # Accelerated Computing
    "g5.xlarge",
    "g5.2xlarge",
    "g5.4xlarge",
    "g5.8xlarge",
    "g5.12xlarge",
    "g5.16xlarge",
    "g5.24xlarge",
    "g5.48xlarge",
    # Accelerated Computing
    "g5g.xlarge",
    "g5g.2xlarge",
    "g5g.4xlarge",
    "g5g.8xlarge",
    "g5g.16xlarge",
    # Accelerated Computing
    "h1.2xlarge",
    "h1.4xlarge",
    "h1.8xlarge",
    "h1.16xlarge",
    # Storage Optimized
    "hpc6a.48xlarge",
    # Compute Optimized
    "i3.large",
    "i3.xlarge",
    "i3.2xlarge",
    "i3.4xlarge",
    "i3.8xlarge",
    "i3.16xlarge",
    "i3.metal",
    # Storage Optimized
    "i3en.large",
    "i3en.xlarge",
    "i3en.2xlarge",
    "i3en.3xlarge",
    "i3en.6xlarge",
    "i3en.12xlarge",
    "i3en.24xlarge",
    "i3en.metal",
    # Storage Optimized
    "im4gn.large",
    "im4gn.xlarge",
    "im4gn.2xlarge",
    "im4gn.4xlarge",
    "im4gn.8xlarge",
    "im4gn.16xlarge",
    # Storage Optimized
    "inf1.xlarge",
    "inf1.2xlarge",
    "inf1.6xlarge",
    "inf1.24xlarge",
    # Accelerated Computing
    "is4gen.medium",
    "is4gen.large",
    "is4gen.xlarge",
    "is4gen.2xlarge",
    "is4gen.4xlarge",
    "is4gen.8xlarge",
    # Storage Optimized
    "m4.large",
    "m4.xlarge",
    "m4.2xlarge",
    "m4.4xlarge",
    "m4.10xlarge",
    "m4.16xlarge",
    # General Purpose
    "m5.large",
    "m5.xlarge",
    "m5.2xlarge",
    "m5.4xlarge",
    "m5.8xlarge",
    "m5.12xlarge",
    "m5.16xlarge",
    "m5.24xlarge",
    "m5.metal",
    # General Purpose
    "m5a.large",
    "m5a.xlarge",
    "m5a.2xlarge",
    "m5a.4xlarge",
    "m5a.8xlarge",
    "m5a.12xlarge",
    "m5a.16xlarge",
    "m5a.24xlarge",
    # General Purpose
    "m5ad.large",
    "m5ad.xlarge",
    "m5ad.2xlarge",
    "m5ad.4xlarge",
    "m5ad.8xlarge",
    "m5ad.12xlarge",
    "m5ad.16xlarge",
    "m5ad.24xlarge",
    # General Purpose
    "m5d.large",
    "m5d.xlarge",
    "m5d.2xlarge",
    "m5d.4xlarge",
    "m5d.8xlarge",
    "m5d.12xlarge",
    "m5d.16xlarge",
    "m5d.24xlarge",
    "m5d.metal",
    # General Purpose
    "m5dn.large",
    "m5dn.xlarge",
    "m5dn.2xlarge",
    "m5dn.4xlarge",
    "m5dn.8xlarge",
    "m5dn.12xlarge",
    "m5dn.16xlarge",
    "m5dn.24xlarge",
    "m5dn.metal",
    # General Purpose
    "m5n.large",
    "m5n.xlarge",
    "m5n.2xlarge",
    "m5n.4xlarge",
    "m5n.8xlarge",
    "m5n.12xlarge",
    "m5n.16xlarge",
    "m5n.24xlarge",
    "m5n.metal",
    # General Purpose
    "m5zn.large",
    "m5zn.xlarge",
    "m5zn.2xlarge",
    "m5zn.3xlarge",
    "m5zn.6xlarge",
    "m5zn.12xlarge",
    "m5zn.metal",
    # General Purpose
    "m6a.large",
    "m6a.xlarge",
    "m6a.2xlarge",
    "m6a.4xlarge",
    "m6a.8xlarge",
    "m6a.12xlarge",
    "m6a.16xlarge",
    "m6a.24xlarge",
    "m6a.32xlarge",
    "m6a.48xlarge",
    # General Purpose
    "m6g.medium",
    "m6g.large",
    "m6g.xlarge",
    "m6g.2xlarge",
    "m6g.4xlarge",
    "m6g.8xlarge",
    "m6g.12xlarge",
    "m6g.16xlarge",
    "m6g.metal",
    # General Purpose
    "m6gd.medium",
    "m6gd.large",
    "m6gd.xlarge",
    "m6gd.2xlarge",
    "m6gd.4xlarge",
    "m6gd.8xlarge",
    "m6gd.12xlarge",
    "m6gd.16xlarge",
    "m6gd.metal",
    # General Purpose
    "m6i.large",
    "m6i.xlarge",
    "m6i.2xlarge",
    "m6i.4xlarge",
    "m6i.8xlarge",
    "m6i.12xlarge",
    "m6i.16xlarge",
    "m6i.24xlarge",
    "m6i.32xlarge",
    "m6i.metal",
    # General Purpose
    "mac1.metal",
    # General Purpose
    "p2.xlarge",
    "p2.8xlarge",
    "p2.16xlarge",
    # Accelerated Computing
    "p3.2xlarge",
    "p3.8xlarge",
    "p3.16xlarge",
    # Accelerated Computing
    "p3dn.24xlarge",
    # Accelerated Computing
    "p4d.24xlarge",
    # Accelerated Computing
    "r4.large",
    "r4.xlarge",
    "r4.2xlarge",
    "r4.4xlarge",
    "r4.8xlarge",
    "r4.16xlarge",
    # Memory Optimized
    "r5.large",
    "r5.xlarge",
    "r5.2xlarge",
    "r5.4xlarge",
    "r5.8xlarge",
    "r5.12xlarge",
    "r5.16xlarge",
    "r5.24xlarge",
    "r5.metal",
    # Memory Optimized
    "r5a.large",
    "r5a.xlarge",
    "r5a.2xlarge",
    "r5a.4xlarge",
    "r5a.8xlarge",
    "r5a.12xlarge",
    "r5a.16xlarge",
    "r5a.24xlarge",
    # Memory Optimized
    "r5ad.large",
    "r5ad.xlarge",
    "r5ad.2xlarge",
    "r5ad.4xlarge",
    "r5ad.8xlarge",
    "r5ad.12xlarge",
    "r5ad.16xlarge",
    "r5ad.24xlarge",
    # Memory Optimized
    "r5b.large",
    "r5b.xlarge",
    "r5b.2xlarge",
    "r5b.4xlarge",
    "r5b.8xlarge",
    "r5b.12xlarge",
    "r5b.16xlarge",
    "r5b.24xlarge",
    "r5b.metal",
    # Memory Optimized
    "r5d.large",
    "r5d.xlarge",
    "r5d.2xlarge",
    "r5d.4xlarge",
    "r5d.8xlarge",
    "r5d.12xlarge",
    "r5d.16xlarge",
    "r5d.24xlarge",
    "r5d.metal",
    # Memory Optimized
    "r5dn.large",
    "r5dn.xlarge",
    "r5dn.2xlarge",
    "r5dn.4xlarge",
    "r5dn.8xlarge",
    "r5dn.12xlarge",
    "r5dn.16xlarge",
    "r5dn.24xlarge",
    "r5dn.metal",
    # Memory Optimized
    "r5n.large",
    "r5n.xlarge",
    "r5n.2xlarge",
    "r5n.4xlarge",
    "r5n.8xlarge",
    "r5n.12xlarge",
    "r5n.16xlarge",
    "r5n.24xlarge",
    "r5n.metal",
    # Memory Optimized
    "r6g.medium",
    "r6g.large",
    "r6g.xlarge",
    "r6g.2xlarge",
    "r6g.4xlarge",
    "r6g.8xlarge",
    "r6g.12xlarge",
    "r6g.16xlarge",
    "r6g.metal",
    # Memory Optimized
    "r6gd.medium",
    "r6gd.large",
    "r6gd.xlarge",
    "r6gd.2xlarge",
    "r6gd.4xlarge",
    "r6gd.8xlarge",
    "r6gd.12xlarge",
    "r6gd.16xlarge",
    "r6gd.metal",
    # Memory Optimized
    "r6i.large",
    "r6i.xlarge",
    "r6i.2xlarge",
    "r6i.4xlarge",
    "r6i.8xlarge",
    "r6i.12xlarge",
    "r6i.16xlarge",
    "r6i.24xlarge",
    "r6i.32xlarge",
    "r6i.metal",
    # Memory Optimized
    "t2.nano",
    "t2.micro",
    "t2.small",
    "t2.medium",
    "t2.large",
    "t2.xlarge",
    "t2.2xlarge",
    # General Purpose
    "t3.nano",
    "t3.micro",
    "t3.small",
    "t3.medium",
    "t3.large",
    "t3.xlarge",
    "t3.2xlarge",
    # General Purpose
    "t3a.nano",
    "t3a.micro",
    "t3a.small",
    "t3a.medium",
    "t3a.large",
    "t3a.xlarge",
    "t3a.2xlarge",
    # General Purpose
    "t4g.nano",
    "t4g.micro",
    "t4g.small",
    "t4g.medium",
    "t4g.large",
    "t4g.xlarge",
    "t4g.2xlarge",
    # General Purpose
    "u-6tb1.56xlarge",
    "u-6tb1.112xlarge",
    "u-6tb1.metal",
    "u-9tb1.112xlarge",
    "u-9tb1.metal",
    "u-12tb1.112xlarge",
    "u-12tb1.metal",
    "u-18tb1.metal",
    "u-24tb1.metal",
    # Memory Optimized
    "vt1.3xlarge",
    "vt1.6xlarge",
    "vt1.24xlarge",
    # Accelerated Computing
    "x1.16xlarge",
    "x1.32xlarge",
    # Memory Optimized
    "x1e.xlarge",
    "x1e.2xlarge",
    "x1e.4xlarge",
    "x1e.8xlarge",
    "x1e.16xlarge",
    "x1e.32xlarge",
    # Memory Optimized
    "x2gd.medium",
    "x2gd.large",
    "x2gd.xlarge",
    "x2gd.2xlarge",
    "x2gd.4xlarge",
    "x2gd.8xlarge",
    "x2gd.12xlarge",
    "x2gd.16xlarge",
    "x2gd.metal",
    # Memory Optimized
    "x2iezn.2xlarge",
    "x2iezn.4xlarge",
    "x2iezn.6xlarge",
    "x2iezn.8xlarge",
    "x2iezn.12xlarge",
    "x2iezn.metal",
    # Memory Optimized
    "z1d.large",
    "z1d.xlarge",
    "z1d.2xlarge",
    "z1d.3xlarge",
    "z1d.6xlarge",
    "z1d.12xlarge",
    "z1d.metal",
}


if __name__ == "__main__":
    print_all_zones()
