# TellorX Query Catalog

## Legacy ETH/USD spot price

| Parameter | Value |
| --- | --- |
| Tag | `eth-usd-legacy` |
| Active | `True` |
| Type | `LegacyRequest` |
| Descriptor | `{"type":"LegacyRequest","legacy_id":1}` |
| Encoding ABI | `[{"name": "legacy_id", "type": "uint256"}]` |
| Query ID | `0x0000000000000000000000000000000000000000000000000000000000000001` |
| Query data | `0x00000000000000000000000000000000000000000000000000000000000000400000000000000000000000000000000000000000000000000000000000000080000000000000000000000000000000000000000000000000000000000000000d4c6567616379526571756573740000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000200000000000000000000000000000000000000000000000000000000000000001` |

## Legacy BTC/USD spot price

| Parameter | Value |
| --- | --- |
| Tag | `btc-usd-legacy` |
| Active | `True` |
| Type | `LegacyRequest` |
| Descriptor | `{"type":"LegacyRequest","legacy_id":2}` |
| Encoding ABI | `[{"name": "legacy_id", "type": "uint256"}]` |
| Query ID | `0x0000000000000000000000000000000000000000000000000000000000000002` |
| Query data | `0x00000000000000000000000000000000000000000000000000000000000000400000000000000000000000000000000000000000000000000000000000000080000000000000000000000000000000000000000000000000000000000000000d4c6567616379526571756573740000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000200000000000000000000000000000000000000000000000000000000000000002` |

## Legacy AMPL/USD custom price

| Parameter | Value |
| --- | --- |
| Tag | `ampl-legacy` |
| Active | `True` |
| Type | `LegacyRequest` |
| Descriptor | `{"type":"LegacyRequest","legacy_id":10}` |
| Encoding ABI | `[{"name": "legacy_id", "type": "uint256"}]` |
| Query ID | `0x000000000000000000000000000000000000000000000000000000000000000a` |
| Query data | `0x00000000000000000000000000000000000000000000000000000000000000400000000000000000000000000000000000000000000000000000000000000080000000000000000000000000000000000000000000000000000000000000000d4c656761637952657175657374000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000020000000000000000000000000000000000000000000000000000000000000000a` |

## Legacy USPCE value

| Parameter | Value |
| --- | --- |
| Tag | `uspce-legacy` |
| Active | `True` |
| Type | `LegacyRequest` |
| Descriptor | `{"type":"LegacyRequest","legacy_id":41}` |
| Encoding ABI | `[{"name": "legacy_id", "type": "uint256"}]` |
| Query ID | `0x0000000000000000000000000000000000000000000000000000000000000029` |
| Query data | `0x00000000000000000000000000000000000000000000000000000000000000400000000000000000000000000000000000000000000000000000000000000080000000000000000000000000000000000000000000000000000000000000000d4c6567616379526571756573740000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000200000000000000000000000000000000000000000000000000000000000000029` |

## Legacy TRB/USD spot price

| Parameter | Value |
| --- | --- |
| Tag | `trb-usd-legacy` |
| Active | `True` |
| Type | `LegacyRequest` |
| Descriptor | `{"type":"LegacyRequest","legacy_id":50}` |
| Encoding ABI | `[{"name": "legacy_id", "type": "uint256"}]` |
| Query ID | `0x0000000000000000000000000000000000000000000000000000000000000032` |
| Query data | `0x00000000000000000000000000000000000000000000000000000000000000400000000000000000000000000000000000000000000000000000000000000080000000000000000000000000000000000000000000000000000000000000000d4c6567616379526571756573740000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000200000000000000000000000000000000000000000000000000000000000000032` |

## Legacy ETH/JPY spot price

| Parameter | Value |
| --- | --- |
| Tag | `eth-jpy-legacy` |
| Active | `True` |
| Type | `LegacyRequest` |
| Descriptor | `{"type":"LegacyRequest","legacy_id":59}` |
| Encoding ABI | `[{"name": "legacy_id", "type": "uint256"}]` |
| Query ID | `0x000000000000000000000000000000000000000000000000000000000000003b` |
| Query data | `0x00000000000000000000000000000000000000000000000000000000000000400000000000000000000000000000000000000000000000000000000000000080000000000000000000000000000000000000000000000000000000000000000d4c656761637952657175657374000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000020000000000000000000000000000000000000000000000000000000000000003b` |

## OHM/ETH spot price

| Parameter | Value |
| --- | --- |
| Tag | `ohm-eth-spot` |
| Active | `True` |
| Type | `SpotPrice` |
| Descriptor | `{"type":"SpotPrice","asset":"ohm","currency":"eth"}` |
| Encoding ABI | `[{"name": "asset", "type": "string"}, {"name": "currency", "type": "string"}]` |
| Query ID | `0xee4fcdeed773931af0bcd16cfcea5b366682ffbd4994cf78b4f0a6a40b570340` |
| Query data | `0x00000000000000000000000000000000000000000000000000000000000000400000000000000000000000000000000000000000000000000000000000000080000000000000000000000000000000000000000000000000000000000000000953706f745072696365000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000c00000000000000000000000000000000000000000000000000000000000000040000000000000000000000000000000000000000000000000000000000000008000000000000000000000000000000000000000000000000000000000000000036f686d000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000036574680000000000000000000000000000000000000000000000000000000000` |

## VSQ/USD spot price

| Parameter | Value |
| --- | --- |
| Tag | `vsq-usd-spot` |
| Active | `True` |
| Type | `SpotPrice` |
| Descriptor | `{"type":"SpotPrice","asset":"vsq","currency":"usd"}` |
| Encoding ABI | `[{"name": "asset", "type": "string"}, {"name": "currency", "type": "string"}]` |
| Query ID | `0xa9b17c33422e2e576fb664d1d11d38c377b614d62f92653d006eca7bb2af1656` |
| Query data | `0x00000000000000000000000000000000000000000000000000000000000000400000000000000000000000000000000000000000000000000000000000000080000000000000000000000000000000000000000000000000000000000000000953706f745072696365000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000c0000000000000000000000000000000000000000000000000000000000000004000000000000000000000000000000000000000000000000000000000000000800000000000000000000000000000000000000000000000000000000000000003767371000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000037573640000000000000000000000000000000000000000000000000000000000` |

## AWS Spot Price

| Parameter | Value |
| --- | --- |
| Tag | `aws-spot-zone-us-east-1f-instance-i3.16xlarge` |
| Active | `True` |
| Type | `AwsSpotPrice` |
| Descriptor | `{"type":"AwsSpotPrice","zone":"us-east-1f","instance":"i3.16xlarge"}` |
| Encoding ABI | `[{"name": "zone", "type": "string"}, {"name": "instance", "type": "string"}]` |
| Query ID | `0x1129a7b6be140744637bf7f2910e8e97b4af103935ee3a885bf7611b94caa3cd` |
| Query data | `0x00000000000000000000000000000000000000000000000000000000000000400000000000000000000000000000000000000000000000000000000000000080000000000000000000000000000000000000000000000000000000000000000c41777353706f745072696365000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000c000000000000000000000000000000000000000000000000000000000000000400000000000000000000000000000000000000000000000000000000000000080000000000000000000000000000000000000000000000000000000000000000a75732d656173742d316600000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000b69332e3136786c61726765000000000000000000000000000000000000000000` |

## BCT/USD spot price

| Parameter | Value |
| --- | --- |
| Tag | `bct-usd-spot` |
| Active | `True` |
| Type | `SpotPrice` |
| Descriptor | `{"type":"SpotPrice","asset":"bct","currency":"usd"}` |
| Encoding ABI | `[{"name": "asset", "type": "string"}, {"name": "currency", "type": "string"}]` |
| Query ID | `0x35e083af947a4cf3bc053440c3b4f753433c76acab6c8b1911ee808104b72e85` |
| Query data | `0x00000000000000000000000000000000000000000000000000000000000000400000000000000000000000000000000000000000000000000000000000000080000000000000000000000000000000000000000000000000000000000000000953706f745072696365000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000c0000000000000000000000000000000000000000000000000000000000000004000000000000000000000000000000000000000000000000000000000000000800000000000000000000000000000000000000000000000000000000000000003626374000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000037573640000000000000000000000000000000000000000000000000000000000` |

## DAI/USD spot price

| Parameter | Value |
| --- | --- |
| Tag | `dai-usd-spot` |
| Active | `True` |
| Type | `SpotPrice` |
| Descriptor | `{"type":"SpotPrice","asset":"dai","currency":"usd"}` |
| Encoding ABI | `[{"name": "asset", "type": "string"}, {"name": "currency", "type": "string"}]` |
| Query ID | `0xd913406746edf7891a09ffb9b26a12553bbf4d25ecf8e530ec359969fe6a7a9c` |
| Query data | `0x00000000000000000000000000000000000000000000000000000000000000400000000000000000000000000000000000000000000000000000000000000080000000000000000000000000000000000000000000000000000000000000000953706f745072696365000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000c0000000000000000000000000000000000000000000000000000000000000004000000000000000000000000000000000000000000000000000000000000000800000000000000000000000000000000000000000000000000000000000000003646169000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000037573640000000000000000000000000000000000000000000000000000000000` |

## RIC/USD spot price

| Parameter | Value |
| --- | --- |
| Tag | `ric-usd-spot` |
| Active | `True` |
| Type | `SpotPrice` |
| Descriptor | `{"type":"SpotPrice","asset":"ric","currency":"usd"}` |
| Encoding ABI | `[{"name": "asset", "type": "string"}, {"name": "currency", "type": "string"}]` |
| Query ID | `0x6e5122118ce52cc9b97c359c1f174a3c21c71d810f7addce3484cc28e0be0f29` |
| Query data | `0x00000000000000000000000000000000000000000000000000000000000000400000000000000000000000000000000000000000000000000000000000000080000000000000000000000000000000000000000000000000000000000000000953706f745072696365000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000c0000000000000000000000000000000000000000000000000000000000000004000000000000000000000000000000000000000000000000000000000000000800000000000000000000000000000000000000000000000000000000000000003726963000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000037573640000000000000000000000000000000000000000000000000000000000` |

## IDLE/USD spot price

| Parameter | Value |
| --- | --- |
| Tag | `idle-usd-spot` |
| Active | `True` |
| Type | `SpotPrice` |
| Descriptor | `{"type":"SpotPrice","asset":"idle","currency":"usd"}` |
| Encoding ABI | `[{"name": "asset", "type": "string"}, {"name": "currency", "type": "string"}]` |
| Query ID | `0x7239909c0aa5d3e89efb2dce06c80811e93ab18413110b8c0435ee32c52cc4fb` |
| Query data | `0x00000000000000000000000000000000000000000000000000000000000000400000000000000000000000000000000000000000000000000000000000000080000000000000000000000000000000000000000000000000000000000000000953706f745072696365000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000c000000000000000000000000000000000000000000000000000000000000000400000000000000000000000000000000000000000000000000000000000000080000000000000000000000000000000000000000000000000000000000000000469646c650000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000037573640000000000000000000000000000000000000000000000000000000000` |

## MKR/USD spot price

| Parameter | Value |
| --- | --- |
| Tag | `mkr-usd-spot` |
| Active | `True` |
| Type | `SpotPrice` |
| Descriptor | `{"type":"SpotPrice","asset":"mkr","currency":"usd"}` |
| Encoding ABI | `[{"name": "asset", "type": "string"}, {"name": "currency", "type": "string"}]` |
| Query ID | `0xb9d5e25dabd5f0a48f45f5b6b524bac100df05eaf5311f3e5339ac7c3dd0a37e` |
| Query data | `0x00000000000000000000000000000000000000000000000000000000000000400000000000000000000000000000000000000000000000000000000000000080000000000000000000000000000000000000000000000000000000000000000953706f745072696365000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000c00000000000000000000000000000000000000000000000000000000000000040000000000000000000000000000000000000000000000000000000000000008000000000000000000000000000000000000000000000000000000000000000036d6b72000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000037573640000000000000000000000000000000000000000000000000000000000` |

## SUSHI/USD spot price

| Parameter | Value |
| --- | --- |
| Tag | `sushi-usd-spot` |
| Active | `True` |
| Type | `SpotPrice` |
| Descriptor | `{"type":"SpotPrice","asset":"sushi","currency":"usd"}` |
| Encoding ABI | `[{"name": "asset", "type": "string"}, {"name": "currency", "type": "string"}]` |
| Query ID | `0x3f640bf607feb4455c3eb10629385d823341cd18fef6f9f87b8bcfbeafc44eeb` |
| Query data | `0x00000000000000000000000000000000000000000000000000000000000000400000000000000000000000000000000000000000000000000000000000000080000000000000000000000000000000000000000000000000000000000000000953706f745072696365000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000c0000000000000000000000000000000000000000000000000000000000000004000000000000000000000000000000000000000000000000000000000000000800000000000000000000000000000000000000000000000000000000000000005737573686900000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000037573640000000000000000000000000000000000000000000000000000000000` |

## MATIC/USD spot price

| Parameter | Value |
| --- | --- |
| Tag | `matic-usd-spot` |
| Active | `True` |
| Type | `SpotPrice` |
| Descriptor | `{"type":"SpotPrice","asset":"matic","currency":"usd"}` |
| Encoding ABI | `[{"name": "asset", "type": "string"}, {"name": "currency", "type": "string"}]` |
| Query ID | `0x40aa71e5205fdc7bdb7d65f7ae41daca3820c5d3a8f62357a99eda3aa27244a3` |
| Query data | `0x00000000000000000000000000000000000000000000000000000000000000400000000000000000000000000000000000000000000000000000000000000080000000000000000000000000000000000000000000000000000000000000000953706f745072696365000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000c00000000000000000000000000000000000000000000000000000000000000040000000000000000000000000000000000000000000000000000000000000008000000000000000000000000000000000000000000000000000000000000000056d6174696300000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000037573640000000000000000000000000000000000000000000000000000000000` |

## USDC/USD spot price

| Parameter | Value |
| --- | --- |
| Tag | `usdc-usd-spot` |
| Active | `True` |
| Type | `SpotPrice` |
| Descriptor | `{"type":"SpotPrice","asset":"usdc","currency":"usd"}` |
| Encoding ABI | `[{"name": "asset", "type": "string"}, {"name": "currency", "type": "string"}]` |
| Query ID | `0x8ee44cd434ed5b0e007eee581fbe0855336f3f84484e8d9989a620a4a49aa0f7` |
| Query data | `0x00000000000000000000000000000000000000000000000000000000000000400000000000000000000000000000000000000000000000000000000000000080000000000000000000000000000000000000000000000000000000000000000953706f745072696365000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000c0000000000000000000000000000000000000000000000000000000000000004000000000000000000000000000000000000000000000000000000000000000800000000000000000000000000000000000000000000000000000000000000004757364630000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000037573640000000000000000000000000000000000000000000000000000000000` |
