"""init

Revision ID: c4f2219ccd01
Revises: 
Create Date: 2023-03-28 01:10:29.183776

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "c4f2219ccd01"
down_revision = None
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "projects",
        sa.Column("name", sa.String(length=30), nullable=False),
        sa.Column("backend", sa.String(length=30), nullable=False),
        sa.Column("config", sa.String(length=300), nullable=False),
        sa.Column("auth", sa.String(length=300), nullable=False),
        sa.PrimaryKeyConstraint("name"),
    )
    op.create_table(
        "roles",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("name", sa.String(length=30), nullable=False),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "scopes",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("pattern", sa.String(length=100), nullable=False),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "users",
        sa.Column("name", sa.String(length=30), nullable=False),
        sa.Column("token", sa.String(length=200), nullable=False),
        sa.Column("role_id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["role_id"],
            ["roles.id"],
        ),
        sa.PrimaryKeyConstraint("name"),
    )
    op.create_table(
        "members",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("project_name", sa.String(length=30), nullable=False),
        sa.Column("user_name", sa.String(length=30), nullable=False),
        sa.Column("role_id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["project_name"],
            ["projects.name"],
        ),
        sa.ForeignKeyConstraint(
            ["role_id"],
            ["roles.id"],
        ),
        sa.ForeignKeyConstraint(
            ["user_name"],
            ["users.name"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "user_project",
        sa.Column("users_name", sa.String(length=30), nullable=True),
        sa.Column("project_name", sa.String(length=30), nullable=True),
        sa.ForeignKeyConstraint(
            ["project_name"],
            ["projects.name"],
        ),
        sa.ForeignKeyConstraint(
            ["users_name"],
            ["users.name"],
        ),
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("user_project")
    op.drop_table("members")
    op.drop_table("users")
    op.drop_table("scopes")
    op.drop_table("roles")
    op.drop_table("projects")
    # ### end Alembic commands ###
