# This Python file uses the following encoding: utf-8
"""autogenerated by genpy from frame_msgs/PersonTrajectoryEntry.msg. Do not edit."""
import sys
python3 = True if sys.hexversion > 0x03000000 else False
import genpy
import struct

import geometry_msgs.msg
import genpy

class PersonTrajectoryEntry(genpy.Message):
  _md5sum = "116bbf92aab7b80413f5fd46c81faddc"
  _type = "frame_msgs/PersonTrajectoryEntry"
  _has_header = False #flag to mark the presence of a Header object
  _full_text = """# Message defining an entry of a person trajectory.
#

duration    age             # age of the track
bool        is_occluded     # if the track is currently not matched by a detection
uint64      detection_id    # id of the corresponding detection in the current cycle (undefined if occluded)

# The following fields are extracted from the Kalman state x and its covariance C

geometry_msgs/PoseWithCovariance    pose   # pose of the track (z value and orientation might not be set, check if corresponding variance on diagonal is > 99999)
geometry_msgs/TwistWithCovariance   twist  # velocity of the track (z value and rotational velocities might not be set, check if corresponding variance on diagonal is > 99999)

================================================================================
MSG: geometry_msgs/PoseWithCovariance
# This represents a pose in free space with uncertainty.

Pose pose

# Row-major representation of the 6x6 covariance matrix
# The orientation parameters use a fixed-axis representation.
# In order, the parameters are:
# (x, y, z, rotation about X axis, rotation about Y axis, rotation about Z axis)
float64[36] covariance

================================================================================
MSG: geometry_msgs/Pose
# A representation of pose in free space, composed of position and orientation. 
Point position
Quaternion orientation

================================================================================
MSG: geometry_msgs/Point
# This contains the position of a point in free space
float64 x
float64 y
float64 z

================================================================================
MSG: geometry_msgs/Quaternion
# This represents an orientation in free space in quaternion form.

float64 x
float64 y
float64 z
float64 w

================================================================================
MSG: geometry_msgs/TwistWithCovariance
# This expresses velocity in free space with uncertainty.

Twist twist

# Row-major representation of the 6x6 covariance matrix
# The orientation parameters use a fixed-axis representation.
# In order, the parameters are:
# (x, y, z, rotation about X axis, rotation about Y axis, rotation about Z axis)
float64[36] covariance

================================================================================
MSG: geometry_msgs/Twist
# This expresses velocity in free space broken into its linear and angular parts.
Vector3  linear
Vector3  angular

================================================================================
MSG: geometry_msgs/Vector3
# This represents a vector in free space. 
# It is only meant to represent a direction. Therefore, it does not
# make sense to apply a translation to it (e.g., when applying a 
# generic rigid transformation to a Vector3, tf2 will only apply the
# rotation). If you want your data to be translatable too, use the
# geometry_msgs/Point message instead.

float64 x
float64 y
float64 z"""
  __slots__ = ['age','is_occluded','detection_id','pose','twist']
  _slot_types = ['duration','bool','uint64','geometry_msgs/PoseWithCovariance','geometry_msgs/TwistWithCovariance']

  def __init__(self, *args, **kwds):
    """
    Constructor. Any message fields that are implicitly/explicitly
    set to None will be assigned a default value. The recommend
    use is keyword arguments as this is more robust to future message
    changes.  You cannot mix in-order arguments and keyword arguments.

    The available fields are:
       age,is_occluded,detection_id,pose,twist

    :param args: complete set of field values, in .msg order
    :param kwds: use keyword arguments corresponding to message field names
    to set specific fields.
    """
    if args or kwds:
      super(PersonTrajectoryEntry, self).__init__(*args, **kwds)
      #message fields cannot be None, assign default values for those that are
      if self.age is None:
        self.age = genpy.Duration()
      if self.is_occluded is None:
        self.is_occluded = False
      if self.detection_id is None:
        self.detection_id = 0
      if self.pose is None:
        self.pose = geometry_msgs.msg.PoseWithCovariance()
      if self.twist is None:
        self.twist = geometry_msgs.msg.TwistWithCovariance()
    else:
      self.age = genpy.Duration()
      self.is_occluded = False
      self.detection_id = 0
      self.pose = geometry_msgs.msg.PoseWithCovariance()
      self.twist = geometry_msgs.msg.TwistWithCovariance()

  def _get_types(self):
    """
    internal API method
    """
    return self._slot_types

  def serialize(self, buff):
    """
    serialize message into buffer
    :param buff: buffer, ``StringIO``
    """
    try:
      _x = self
      buff.write(_get_struct_2iBQ7d().pack(_x.age.secs, _x.age.nsecs, _x.is_occluded, _x.detection_id, _x.pose.pose.position.x, _x.pose.pose.position.y, _x.pose.pose.position.z, _x.pose.pose.orientation.x, _x.pose.pose.orientation.y, _x.pose.pose.orientation.z, _x.pose.pose.orientation.w))
      buff.write(_get_struct_36d().pack(*self.pose.covariance))
      _x = self
      buff.write(_get_struct_6d().pack(_x.twist.twist.linear.x, _x.twist.twist.linear.y, _x.twist.twist.linear.z, _x.twist.twist.angular.x, _x.twist.twist.angular.y, _x.twist.twist.angular.z))
      buff.write(_get_struct_36d().pack(*self.twist.covariance))
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize(self, str):
    """
    unpack serialized message in str into this message instance
    :param str: byte array of serialized message, ``str``
    """
    try:
      if self.age is None:
        self.age = genpy.Duration()
      if self.pose is None:
        self.pose = geometry_msgs.msg.PoseWithCovariance()
      if self.twist is None:
        self.twist = geometry_msgs.msg.TwistWithCovariance()
      end = 0
      _x = self
      start = end
      end += 73
      (_x.age.secs, _x.age.nsecs, _x.is_occluded, _x.detection_id, _x.pose.pose.position.x, _x.pose.pose.position.y, _x.pose.pose.position.z, _x.pose.pose.orientation.x, _x.pose.pose.orientation.y, _x.pose.pose.orientation.z, _x.pose.pose.orientation.w,) = _get_struct_2iBQ7d().unpack(str[start:end])
      self.is_occluded = bool(self.is_occluded)
      start = end
      end += 288
      self.pose.covariance = _get_struct_36d().unpack(str[start:end])
      _x = self
      start = end
      end += 48
      (_x.twist.twist.linear.x, _x.twist.twist.linear.y, _x.twist.twist.linear.z, _x.twist.twist.angular.x, _x.twist.twist.angular.y, _x.twist.twist.angular.z,) = _get_struct_6d().unpack(str[start:end])
      start = end
      end += 288
      self.twist.covariance = _get_struct_36d().unpack(str[start:end])
      self.age.canon()
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e) #most likely buffer underfill


  def serialize_numpy(self, buff, numpy):
    """
    serialize message with numpy array types into buffer
    :param buff: buffer, ``StringIO``
    :param numpy: numpy python module
    """
    try:
      _x = self
      buff.write(_get_struct_2iBQ7d().pack(_x.age.secs, _x.age.nsecs, _x.is_occluded, _x.detection_id, _x.pose.pose.position.x, _x.pose.pose.position.y, _x.pose.pose.position.z, _x.pose.pose.orientation.x, _x.pose.pose.orientation.y, _x.pose.pose.orientation.z, _x.pose.pose.orientation.w))
      buff.write(self.pose.covariance.tostring())
      _x = self
      buff.write(_get_struct_6d().pack(_x.twist.twist.linear.x, _x.twist.twist.linear.y, _x.twist.twist.linear.z, _x.twist.twist.angular.x, _x.twist.twist.angular.y, _x.twist.twist.angular.z))
      buff.write(self.twist.covariance.tostring())
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize_numpy(self, str, numpy):
    """
    unpack serialized message in str into this message instance using numpy for array types
    :param str: byte array of serialized message, ``str``
    :param numpy: numpy python module
    """
    try:
      if self.age is None:
        self.age = genpy.Duration()
      if self.pose is None:
        self.pose = geometry_msgs.msg.PoseWithCovariance()
      if self.twist is None:
        self.twist = geometry_msgs.msg.TwistWithCovariance()
      end = 0
      _x = self
      start = end
      end += 73
      (_x.age.secs, _x.age.nsecs, _x.is_occluded, _x.detection_id, _x.pose.pose.position.x, _x.pose.pose.position.y, _x.pose.pose.position.z, _x.pose.pose.orientation.x, _x.pose.pose.orientation.y, _x.pose.pose.orientation.z, _x.pose.pose.orientation.w,) = _get_struct_2iBQ7d().unpack(str[start:end])
      self.is_occluded = bool(self.is_occluded)
      start = end
      end += 288
      self.pose.covariance = numpy.frombuffer(str[start:end], dtype=numpy.float64, count=36)
      _x = self
      start = end
      end += 48
      (_x.twist.twist.linear.x, _x.twist.twist.linear.y, _x.twist.twist.linear.z, _x.twist.twist.angular.x, _x.twist.twist.angular.y, _x.twist.twist.angular.z,) = _get_struct_6d().unpack(str[start:end])
      start = end
      end += 288
      self.twist.covariance = numpy.frombuffer(str[start:end], dtype=numpy.float64, count=36)
      self.age.canon()
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e) #most likely buffer underfill

_struct_I = genpy.struct_I
def _get_struct_I():
    global _struct_I
    return _struct_I
_struct_36d = None
def _get_struct_36d():
    global _struct_36d
    if _struct_36d is None:
        _struct_36d = struct.Struct("<36d")
    return _struct_36d
_struct_2iBQ7d = None
def _get_struct_2iBQ7d():
    global _struct_2iBQ7d
    if _struct_2iBQ7d is None:
        _struct_2iBQ7d = struct.Struct("<2iBQ7d")
    return _struct_2iBQ7d
_struct_6d = None
def _get_struct_6d():
    global _struct_6d
    if _struct_6d is None:
        _struct_6d = struct.Struct("<6d")
    return _struct_6d
