from __future__ import print_function
from pkg_resources import resource_filename
# import
## batteries
import os
import sys
import argparse
import logging
## application
from DeepMAsED import Predict

# functions
def get_desc():
    desc = 'Predict values'
    return desc

def parse_args(test_args=None, subparsers=None):
    desc = get_desc()
    epi = """DESCRIPTION:
    Predicting misassemblies by used a model generated by `DeepMAsED train`
    or the pre-trained model that comes with the DeepMAsED package.
    
    #-- feature_file_table --#
    * See `DeepMAsED train` for a description 
    * Note that the 'assembler' and 'rep' columns are not actually used, 
      so placeholder values can used. Just make sure to include unique 
      `assembler` + `rep` combinations for each row in the table.
    """
    if subparsers:
        parser = subparsers.add_parser('predict', description=desc, epilog=epi,
                                       formatter_class=argparse.RawTextHelpFormatter)
    else:
        parser = argparse.ArgumentParser(description=desc, epilog=epi,
                                         formatter_class=argparse.RawTextHelpFormatter)
    #default trained model
    pkg_model = resource_filename('DeepMAsED','Model/deepmased_model.h5')
    pkg_mstd = resource_filename('DeepMAsED','Model/deepmased_mean_std.pkl')
    pkg_path, pkg_model = os.path.split(pkg_model)
    _, pkg_mstd  = os.path.split(pkg_mstd)
    # args
    parser.add_argument('feature_file_table',  metavar='feature_file_table', type=str, 
                        help='Table listing feature table files (see DESCRIPTION)')
    parser.add_argument('--model-path',  default=pkg_path, type=str, 
                        help='Directory containing the model (default: %(default)s)')
    parser.add_argument('--model-name', default=pkg_model, type=str, 
                        help='Model name in the model_path (default: %(default)s)')
    parser.add_argument('--mstd-name', default=pkg_mstd, type=str, 
                        help='Data mean and std name in the model_path (default: %(default)s)') 
    parser.add_argument('--save-path', default='.', type=str, 
                        help='Directory where to save output (default: %(default)s)')
    parser.add_argument('--save-name', default='deepmased', type=str, 
                        help='Prefix for name in the save_path (default: %(default)s)')        
    parser.add_argument('--cpu-only', action='store_true', default=False,
                        help='Only use CPUs, and no GPUs (default: %(default)s)')
    parser.add_argument('--pickle-only', action='store_true', default=False,
                        help='Only pickle files (default: %(default)s)')
    parser.add_argument('--force-overwrite', action='store_true', default=False,
                        help='Force re-creation of pickle files (default: %(default)s)')
    parser.add_argument('--seed', default=12, type=int, 
                        help='Seed used for numpy.random (default: %(default)s)')
    parser.add_argument('--n-procs', default=1, type=int, 
                        help='Number of parallel processes; just used for pickling (default: %(default)s)')
    # test args
    if test_args:
        args = parser.parse_args(test_args)
        return args

    return parser

def main(args=None):
    logging.basicConfig(format='%(asctime)s - %(message)s', level=logging.DEBUG)
    # Input
    if args is None:
        args = parse_args()
    # Main interface
    Predict.main(args)
    
# main
if __name__ == '__main__':
    pass


