"""
About:
------
The remove_latin command performs delete latin characters from the input text.

Usage:
------
Below is the usage information that can be generated by running remove_latin --help.

.. code-block:: none
    remove_latin --text=TEXT
    remove_latin --file "path/to/your/file.txt"

Examples:
---------
.. code-block:: none
    remove_latin --text "123test"    
    remove_latin --file "path/to/your/file.txt"
"""

import argparse
from sinatools.utils.parser import remove_latin


def main():
    parser = argparse.ArgumentParser(description='remove latin characters from the text')

    parser.add_argument('--text', type=str, required=True, help='The input text')
    args = parser.parse_args()
    result = remove_latin(args.text)
 
    print(result)
    if __name__ == '__main__':
        main()
