# coding: utf-8

"""
    Aliro Q.Network

    This is an api for the Aliro Q.Network  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: nick@aliroquantum.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from aliro_quantum_networking.configuration import Configuration


class Node(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'measurement_error_probability': 'float',
        'memories': 'list[MemoryInput]',
        'name': 'str',
        'operation_errors': 'dict(str, NodeOperationErrors)'
    }

    attribute_map = {
        'measurement_error_probability': 'measurementErrorProbability',
        'memories': 'memories',
        'name': 'name',
        'operation_errors': 'operationErrors'
    }

    def __init__(self, measurement_error_probability=0, memories=None, name=None, operation_errors=None, local_vars_configuration=None):  # noqa: E501
        """Node - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._measurement_error_probability = None
        self._memories = None
        self._name = None
        self._operation_errors = None
        self.discriminator = None

        if measurement_error_probability is not None:
            self.measurement_error_probability = measurement_error_probability
        self.memories = memories
        self.name = name
        if operation_errors is not None:
            self.operation_errors = operation_errors

    @property
    def measurement_error_probability(self):
        """Gets the measurement_error_probability of this Node.  # noqa: E501


        :return: The measurement_error_probability of this Node.  # noqa: E501
        :rtype: float
        """
        return self._measurement_error_probability

    @measurement_error_probability.setter
    def measurement_error_probability(self, measurement_error_probability):
        """Sets the measurement_error_probability of this Node.


        :param measurement_error_probability: The measurement_error_probability of this Node.  # noqa: E501
        :type: float
        """
        if (self.local_vars_configuration.client_side_validation and
                measurement_error_probability is not None and measurement_error_probability > 1):  # noqa: E501
            raise ValueError("Invalid value for `measurement_error_probability`, must be a value less than or equal to `1`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                measurement_error_probability is not None and measurement_error_probability < 0):  # noqa: E501
            raise ValueError("Invalid value for `measurement_error_probability`, must be a value greater than or equal to `0`")  # noqa: E501

        self._measurement_error_probability = measurement_error_probability

    @property
    def memories(self):
        """Gets the memories of this Node.  # noqa: E501


        :return: The memories of this Node.  # noqa: E501
        :rtype: list[MemoryInput]
        """
        return self._memories

    @memories.setter
    def memories(self, memories):
        """Sets the memories of this Node.


        :param memories: The memories of this Node.  # noqa: E501
        :type: list[MemoryInput]
        """
        if self.local_vars_configuration.client_side_validation and memories is None:  # noqa: E501
            raise ValueError("Invalid value for `memories`, must not be `None`")  # noqa: E501

        self._memories = memories

    @property
    def name(self):
        """Gets the name of this Node.  # noqa: E501


        :return: The name of this Node.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Node.


        :param name: The name of this Node.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def operation_errors(self):
        """Gets the operation_errors of this Node.  # noqa: E501

        Keys are gate names  # noqa: E501

        :return: The operation_errors of this Node.  # noqa: E501
        :rtype: dict(str, NodeOperationErrors)
        """
        return self._operation_errors

    @operation_errors.setter
    def operation_errors(self, operation_errors):
        """Sets the operation_errors of this Node.

        Keys are gate names  # noqa: E501

        :param operation_errors: The operation_errors of this Node.  # noqa: E501
        :type: dict(str, NodeOperationErrors)
        """

        self._operation_errors = operation_errors

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Node):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Node):
            return True

        return self.to_dict() != other.to_dict()
