import os

from django.conf import settings
from django.core.management.base import BaseCommand
from ...main import run_qa


class Command(BaseCommand):
    help = 'Checking the Django project for quality'

    def add_arguments(self, parser):
        parser.add_argument(
            '--verbose',
            action='store_true',
            help='Verbose mode',
        )

        parser.add_argument(
            '--all', '-a',
            action='store_true',
            help='Run all checks (includes Lighthouse CI)',
        )

        parser.add_argument(
            '--clear-reports',
            action='store_true',
            help='Remove report files generated by Lighthouse CI',
        )

    def handle(self, *args, **options):
        directory = os.path.abspath(os.path.join(settings.BASE_DIR))
        verbose = options['verbose']
        all = options['all']
        clear_reports = options['clear_reports']
        run_qa(directory, verbose, all, clear_reports)
