from typing import Any, Callable, Dict, Generic, Sequence, TypeVar, overload

from fastapi import Depends
from sqlalchemy.ext.asyncio import AsyncSession
from sqlalchemy.ext.declarative import DeclarativeMeta, declarative_base

from pytorm import AbstractRepository
from pytorm.session import get_session

Base: DeclarativeMeta = declarative_base()
Model = TypeVar('Model', bound=Base)


class Repository(AbstractRepository, Generic[Model]):

    def __init__(self, session: AsyncSession = Depends(get_session)) -> None: ...
    def create(self, **attrs) -> Model: ...
    def merge(self, instance: Model, **attrs) -> Model: ...
    def has_pk(self, instance: Model) -> bool: ...
    def get_pk(self, instance: Model) -> Dict[str, Any] | Any: ...
    async def count(self, *where, **attrs) -> int: ...
    async def delete(self, *where, **attrs) -> None: ...
    async def find(self, *where, **attrs) -> Sequence[Model]: ...
    async def find_one(self, *where, **attrs) -> Model | None: ...
    async def find_one_or_fail(self, *where, **attrs) -> Model: ...
    @overload
    async def remove(self, instance: Model) -> None: ...
    @overload
    async def remove(self, instances: Sequence[Model]) -> None: ...
    @overload
    async def pre_save(self, instance: Model) -> Model: ...
    @overload
    async def pre_save(self, instances: Sequence[Model]) -> Sequence[Model]: ...
    @overload
    async def save(self, instance: Model) -> Model: ...
    @overload
    async def save(self, instances: Sequence[Model]) -> Sequence[Model]: ...

def InjectRepository(model: Callable[..., Any], *, use_cache: bool = True) -> Any: ...
