from typing import Any, Dict, Generic, Sequence, Type, TypeVar, overload

from sqlalchemy.ext.declarative import DeclarativeMeta, declarative_base

Base: DeclarativeMeta = declarative_base()
Model = TypeVar('Model', bound=Base)


class AbstractRepository(Generic[Model]):

    model: Type[Model]

    def create(self, **attrs) -> Model: ...
    def merge(self, instance: Model, **attrs) -> Model: ...
    def has_pk(self, instance: Model) -> bool: ...
    def get_pk(self, instance: Model) -> Dict[str, Any] | Any: ...
    async def count(self, *where, **attrs) -> int: ...
    async def delete(self, *where, **attrs) -> None: ...
    async def find(self, *where, **attrs) -> Sequence[Model]: ...
    async def find_one(self, *where, **attrs) -> Model | None: ...
    async def find_one_or_fail(self, *where, **attrs) -> Model: ...
    @overload
    async def remove(self, instance: Model) -> None: ...
    @overload
    async def remove(self, instances: Sequence[Model]) -> None: ...
    @overload
    async def pre_save(self, instance: Model) -> Model: ...
    @overload
    async def pre_save(self, instances: Sequence[Model]) -> Sequence[Model]: ...
    @overload
    async def save(self, instance: Model) -> Model: ...
    @overload
    async def save(self, instances: Sequence[Model]) -> Sequence[Model]: ...
