# coding: utf-8

"""
    OpenBoxes API specification

    [OpenBoxes](https://openboxes.org) is an open-source LMIS application that increases stock visibility, reduces the risk of stock-outs and stock wastage, and offers tools to improve forecasting and traceability.  **Notice** The following API documentation is a work in progress.  ---   # noqa: E501

    OpenAPI spec version: 0.8.17
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from openboxes.api_client import ApiClient


class ProductApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def available_items(self, id, **kwargs):  # noqa: E501
        """retrieve bin locations and quantities for one or more products  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.available_items(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: database id of a product (required)
        :param str product_id: optionally specify additional product ids. This field may be specified more than once
        :param str location_id: optionally specify the id of a warehouse to query
        :return: ProductAvailableItemResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.available_items_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.available_items_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def available_items_with_http_info(self, id, **kwargs):  # noqa: E501
        """retrieve bin locations and quantities for one or more products  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.available_items_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: database id of a product (required)
        :param str product_id: optionally specify additional product ids. This field may be specified more than once
        :param str location_id: optionally specify the id of a warehouse to query
        :return: ProductAvailableItemResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'product_id', 'location_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method available_items" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `available_items`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'product_id' in params:
            query_params.append(('product.id', params['product_id']))  # noqa: E501
        if 'location_id' in params:
            query_params.append(('location.id', params['location_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['cookie']  # noqa: E501

        return self.api_client.call_api(
            '/api/products/{id}/availableItems', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProductAvailableItemResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def demand(self, id, **kwargs):  # noqa: E501
        """calculate demand for one product at the currently-selected warehouse  # noqa: E501

        This entry point reports daily, monthly, and yearly demand, as well as a calculation of how long current stock will last. It also provides detailed information on the the requested product and currently-selected warehouse.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.demand(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: database id of a product (required)
        :return: ProductDemandResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.demand_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.demand_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def demand_with_http_info(self, id, **kwargs):  # noqa: E501
        """calculate demand for one product at the currently-selected warehouse  # noqa: E501

        This entry point reports daily, monthly, and yearly demand, as well as a calculation of how long current stock will last. It also provides detailed information on the the requested product and currently-selected warehouse.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.demand_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: database id of a product (required)
        :return: ProductDemandResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method demand" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `demand`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['cookie']  # noqa: E501

        return self.api_client.call_api(
            '/api/products/{id}/demand', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProductDemandResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def demand_summary(self, id, **kwargs):  # noqa: E501
        """summarize demand history for one product at the currently-selected warehouse  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.demand_summary(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: database id of a product (required)
        :return: ProductDemandResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.demand_summary_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.demand_summary_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def demand_summary_with_http_info(self, id, **kwargs):  # noqa: E501
        """summarize demand history for one product at the currently-selected warehouse  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.demand_summary_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: database id of a product (required)
        :return: ProductDemandResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method demand_summary" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `demand_summary`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['cookie']  # noqa: E501

        return self.api_client.call_api(
            '/api/products/{id}/demandSummary', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProductDemandResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_products(self, **kwargs):  # noqa: E501
        """list products tracked in OpenBoxes  # noqa: E501

        ## Warning!  Do _not_ use Swagger UI's \"Try it out\" feature on this entry point!  OpenBoxes tracks a large number of products; the full list can [make this page unresponsive](https://github.com/swagger-api/swagger-ui/issues/3832).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_products(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: space or comma-separated list of names to filter by (OR)
        :return: ProductListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_products_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_products_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_products_with_http_info(self, **kwargs):  # noqa: E501
        """list products tracked in OpenBoxes  # noqa: E501

        ## Warning!  Do _not_ use Swagger UI's \"Try it out\" feature on this entry point!  OpenBoxes tracks a large number of products; the full list can [make this page unresponsive](https://github.com/swagger-api/swagger-ui/issues/3832).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_products_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: space or comma-separated list of names to filter by (OR)
        :return: ProductListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_products" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['cookie']  # noqa: E501

        return self.api_client.call_api(
            '/api/products', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProductListResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def product_availability(self, id, **kwargs):  # noqa: E501
        """get detailed availability for one product at the currently-selected warehouse  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.product_availability(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: database id of a product (required)
        :return: ProductAvailabilityResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.product_availability_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.product_availability_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def product_availability_with_http_info(self, id, **kwargs):  # noqa: E501
        """get detailed availability for one product at the currently-selected warehouse  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.product_availability_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: database id of a product (required)
        :return: ProductAvailabilityResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method product_availability" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `product_availability`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['cookie']  # noqa: E501

        return self.api_client.call_api(
            '/api/products/{id}/productAvailability', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProductAvailabilityResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def product_availability_and_demand(self, id, location_id, **kwargs):  # noqa: E501
        """get the monthly demand for, and current quantity of, one product at the currently-selected warehouse  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.product_availability_and_demand(id, location_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: database id of a product (required)
        :param str location_id: the id of a warehouse to query (required)
        :return: ProductAvailabilityAndDemand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.product_availability_and_demand_with_http_info(id, location_id, **kwargs)  # noqa: E501
        else:
            (data) = self.product_availability_and_demand_with_http_info(id, location_id, **kwargs)  # noqa: E501
            return data

    def product_availability_and_demand_with_http_info(self, id, location_id, **kwargs):  # noqa: E501
        """get the monthly demand for, and current quantity of, one product at the currently-selected warehouse  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.product_availability_and_demand_with_http_info(id, location_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: database id of a product (required)
        :param str location_id: the id of a warehouse to query (required)
        :return: ProductAvailabilityAndDemand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'location_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method product_availability_and_demand" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `product_availability_and_demand`")  # noqa: E501
        # verify the required parameter 'location_id' is set
        if ('location_id' not in params or
                params['location_id'] is None):
            raise ValueError("Missing the required parameter `location_id` when calling `product_availability_and_demand`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'location_id' in params:
            query_params.append(('locationId', params['location_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['cookie']  # noqa: E501

        return self.api_client.call_api(
            '/api/products/{id}/productAvailabilityAndDemand', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProductAvailabilityAndDemand',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def product_summary(self, id, **kwargs):  # noqa: E501
        """report the current quantity of one product at the currently-selected warehouse  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.product_summary(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: database id of a product (required)
        :return: ProductSummaryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.product_summary_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.product_summary_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def product_summary_with_http_info(self, id, **kwargs):  # noqa: E501
        """report the current quantity of one product at the currently-selected warehouse  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.product_summary_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: database id of a product (required)
        :return: ProductSummaryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method product_summary" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `product_summary`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['cookie']  # noqa: E501

        return self.api_client.call_api(
            '/api/products/{id}/productSummary', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProductSummaryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
