# coding: utf-8

"""
    OpenBoxes API specification

    [OpenBoxes](https://openboxes.org) is an open-source LMIS application that increases stock visibility, reduces the risk of stock-outs and stock wastage, and offers tools to improve forecasting and traceability.  **Notice** The following API documentation is a work in progress.  ---   # noqa: E501

    OpenAPI spec version: 0.8.17
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from openboxes.api_client import ApiClient


class LocationApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def list_locations(self, **kwargs):  # noqa: E501
        """get a list of locations  # noqa: E501

        ## Warning!  Do _not_ use Swagger UI's \"Try it out\" feature on this entry point without setting `locationTypeCode`!  OpenBoxes tracks a large number of locations; the full list can [make this page unresponsive](https://github.com/swagger-api/swagger-ui/issues/3832).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_locations(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: filter returned locations by name
        :param str location_type_code: optionally restrict the search to a particular type of location
        :return: LocationListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_locations_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_locations_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_locations_with_http_info(self, **kwargs):  # noqa: E501
        """get a list of locations  # noqa: E501

        ## Warning!  Do _not_ use Swagger UI's \"Try it out\" feature on this entry point without setting `locationTypeCode`!  OpenBoxes tracks a large number of locations; the full list can [make this page unresponsive](https://github.com/swagger-api/swagger-ui/issues/3832).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_locations_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: filter returned locations by name
        :param str location_type_code: optionally restrict the search to a particular type of location
        :return: LocationListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'location_type_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_locations" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'location_type_code' in params:
            query_params.append(('locationTypeCode', params['location_type_code']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['cookie']  # noqa: E501

        return self.api_client.call_api(
            '/api/locations', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LocationListResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
