# coding: utf-8

"""
    OpenBoxes API specification

    [OpenBoxes](https://openboxes.org) is an open-source LMIS application that increases stock visibility, reduces the risk of stock-outs and stock wastage, and offers tools to improve forecasting and traceability.  **Notice** The following API documentation is a work in progress.  ---   # noqa: E501

    OpenAPI spec version: 0.8.17
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from openboxes.api_client import ApiClient


class AuthenticationApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def login(self, body, **kwargs):  # noqa: E501
        """retrieve a cookie for authentication  # noqa: E501

        Supply a username and password in the usual way to authenticate (`application/x-www-form-urlencoded`, like `curl -d`). You may optionally supply the identifier of a warehouse via a `location` field; this is an implicit parameter to many subsequent queries. If no location is specified, OpenBoxes will use the last one the authenticating user selected via the web UI or /api/chooseLocation.  ---  Note that SwaggerHub's UI may not report the `JSESSIONID`, depending on browser settings (see [this document](https://swagger.io/docs/specification/authentication/cookie-authentication/) for more details). In that event, to authenticate this page and allow the \"Try it out\" button to work elsewhere, please try the following.  1. Press the \"Try it out\" button below and to the right of this text. 2. Press the blue \"Execute\" button that appears beneath the json editor, below. 3. Copy the `curl` code snippet, add the `-i` flag, then run it in a local terminal. 4. Press the green \"Authorize\" button near the top of this page. 5. Copy the `JSESSIONID` field from `curl` output into the field that appears.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.login(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LoginRequest body: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.login_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.login_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def login_with_http_info(self, body, **kwargs):  # noqa: E501
        """retrieve a cookie for authentication  # noqa: E501

        Supply a username and password in the usual way to authenticate (`application/x-www-form-urlencoded`, like `curl -d`). You may optionally supply the identifier of a warehouse via a `location` field; this is an implicit parameter to many subsequent queries. If no location is specified, OpenBoxes will use the last one the authenticating user selected via the web UI or /api/chooseLocation.  ---  Note that SwaggerHub's UI may not report the `JSESSIONID`, depending on browser settings (see [this document](https://swagger.io/docs/specification/authentication/cookie-authentication/) for more details). In that event, to authenticate this page and allow the \"Try it out\" button to work elsewhere, please try the following.  1. Press the \"Try it out\" button below and to the right of this text. 2. Press the blue \"Execute\" button that appears beneath the json editor, below. 3. Copy the `curl` code snippet, add the `-i` flag, then run it in a local terminal. 4. Press the green \"Authorize\" button near the top of this page. 5. Copy the `JSESSIONID` field from `curl` output into the field that appears.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.login_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LoginRequest body: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method login" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `login`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/login', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
