import pathlib
from setuptools import setup

# The directory containing this file
HERE = pathlib.Path(__file__).parent

# The text of the README file
README = (HERE / "README.md").read_text()

# This call to setup() does all the work
setup(
    name="thin_wrappers",
    version="0.4.3",
    description="Thin wrappers around common packages",
    long_description=README,
    long_description_content_type="text/markdown",
    url="https://github.com/larssl780/thin_wrappers",
    author="larssl780",
    author_email="slick.stash.0m@icloud.com",
    license="MIT",
    classifiers=[
        "License :: OSI Approved :: MIT License",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.7",
    ],
    packages=["thin_wrappers"],
    include_package_data=True,
    install_requires=["pandas", 'requests', 'SQLAlchemy', 'pickleshare'],
    # entry_points={
    #     "console_scripts": [
    #         "realpython=reader.__main__:main",
    #     ]
    # },
)