# -*- coding: utf-8 -*-

import cohesity_management_sdk.models_v2.archival_result_for_a_target

class SummaryInformationForArchivalRun(object):

    """Implementation of the 'Summary information for archival run.' model.

    Specifies summary information about archival run.

    Attributes:
        archival_target_results (list of ArchivalResultForATarget): Archival
            results for each archival target.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "archival_target_results":'archivalTargetResults'
    }

    def __init__(self,
                 archival_target_results=None):
        """Constructor for the SummaryInformationForArchivalRun class"""

        # Initialize members of the class
        self.archival_target_results = archival_target_results


    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object as
            obtained from the deserialization of the server's response. The keys
            MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary
        archival_target_results = None
        if dictionary.get('archivalTargetResults') != None:
            archival_target_results = list()
            for structure in dictionary.get('archivalTargetResults'):
                archival_target_results.append(cohesity_management_sdk.models_v2.archival_result_for_a_target.ArchivalResultForATarget.from_dictionary(structure))

        # Return an object of this model
        return cls(archival_target_results)


