"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpenIdConnectProvider = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
/**
 * IAM OIDC identity providers are entities in IAM that describe an external
 * identity provider (IdP) service that supports the OpenID Connect (OIDC)
 * standard, such as Google or Salesforce. You use an IAM OIDC identity provider
 * when you want to establish trust between an OIDC-compatible IdP and your AWS
 * account.
 *
 * This implementation has default values for thumbprints and clientIds props
 * that will be compatible with the eks cluster
 *
 * @see http://openid.net/connect
 * @see https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_oidc.html
 *
 * @resource AWS::CloudFormation::CustomResource
 */
class OpenIdConnectProvider extends iam.OpenIdConnectProvider {
    /**
     * Defines an OpenID Connect provider.
     * @param scope The definition scope
     * @param id Construct ID
     * @param props Initialization properties
     */
    constructor(scope, id, props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_eks_OpenIdConnectProviderProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, OpenIdConnectProvider);
            }
            throw error;
        }
        /**
         * For some reason EKS isn't validating the root certificate but a intermediate certificate
         * which is one level up in the tree. Because of the a constant thumbprint value has to be
         * stated with this OpenID Connect provider. The certificate thumbprint is the same for all the regions.
         */
        const thumbprints = ['9e99a48a9960b14926bb7f3b02e22da2b0ab7280'];
        const clientIds = ['sts.amazonaws.com'];
        super(scope, id, {
            url: props.url,
            thumbprints,
            clientIds,
        });
    }
}
exports.OpenIdConnectProvider = OpenIdConnectProvider;
_a = JSII_RTTI_SYMBOL_1;
OpenIdConnectProvider[_a] = { fqn: "@aws-cdk/aws-eks.OpenIdConnectProvider", version: "1.160.0" };
//# sourceMappingURL=data:application/json;base64,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