from datetime import datetime

from pydantic import (
    BaseModel,
    Field,
    field_validator,
    IPvAnyAddress,
    ConfigDict,
)

from mikrotikapi.schemes.fields import id_field


class ProfileScheme(BaseModel):
    id: str = id_field
    address_list: str = Field(alias="address-list")
    local_address: IPvAnyAddress = Field(default=None, alias="local-address")
    bridge_learning: str = Field(alias="bridge-learning")
    change_tcp_mss: str = Field(alias="change-tcp-mss")
    default: bool
    name: str
    on_down: str = Field(alias="on-down", frozen=True)
    on_up: str = Field(alias="on-up", frozen=True)
    only_one: str = Field(alias="only-one")
    use_compression: str = Field(alias="use-compression")
    use_encryption: str = Field(alias="use-encryption")
    use_ipv6: str = Field(alias="use-ipv6")
    use_mpls: str = Field(alias="use-mpls")
    use_upnp: str = Field(alias="use-upnp")

    @staticmethod
    def api_patch():
        return "/rest/ppp/profile"

    model_config = ConfigDict(populate_by_name=True)
