from pydantic import (
    BaseModel,
    Field,
    ConfigDict,
)

from mikrotikapi.schemes.components import Action, ToPorts, ToAddresses
from mikrotikapi.schemes.fields import (
    id_field,
    comment_field,
    routing_mark_field,
    bytes_field,
    log_prefix_field,
    field_gen,
)
from mikrotikapi.schemes.groups import (
    AddressMatchGroup,
    InterfaceGroup,
    InterfaceListGroup,
    MarkGroup,
)
from mikrotikapi.utils.api_path import api_path


class NatScheme(
    ToPorts,
    Action,
    AddressMatchGroup,
    ToAddresses,
    InterfaceGroup,
    InterfaceListGroup,
    MarkGroup,
    BaseModel,
):
    id: str = id_field
    bytes: int = bytes_field
    comment: str = comment_field
    disabled: bool = Field(False)
    dst_port: int = field_gen(None, name="dst_port")
    dynamic: bool = Field(None, frozen=True, exclude=True)
    invalid: bool = Field(None, frozen=True, exclude=True)
    log: bool = Field(False)
    log_prefix: str = log_prefix_field
    packets: int = Field(None, frozen=True, exclude=True)
    routing_mark: str = routing_mark_field

    @staticmethod
    def api_path(id_=None):
        return api_path("/rest/ip/firewall/nat", id_)

    model_config = ConfigDict(populate_by_name=True)
