from pydantic import BaseModel, Field, ConfigDict

from mikrotikapi.schemes.components import Action, ToPorts, ToAddresses
from mikrotikapi.schemes.fields import (
    comment_field,
    id_field,
    field_gen,
    bytes_field,
    log_prefix_field,
)
from mikrotikapi.schemes.groups import (
    AddressMatchGroup,
    InterfaceGroup,
    InterfaceListGroup,
    MarkGroup,
)
from mikrotikapi.utils.api_path import api_path


# chain change default value
class MangleScheme(
    ToPorts,
    Action,
    AddressMatchGroup,
    ToAddresses,
    InterfaceGroup,
    InterfaceListGroup,
    MarkGroup,
    BaseModel,
):
    id: str = id_field
    bytes: int = bytes_field
    disabled: bool = Field(False)
    dst_port: int = field_gen(None, name="dst_port")
    disable: bool = Field(None, exclude=True)
    dynamic: bool = Field(None, exclude=True)
    invalid: bool = Field(None, exclude=True)
    comment: str = comment_field
    packets: int = Field(None, frozen=True, exclude=True)

    log: bool = Field(False)
    log_prefix: str = log_prefix_field
    new_routing_mark: str = field_gen("", name="new_routing_mark")

    @property
    def tariff(self) -> str | None:
        try:
            return f"{self.comment.split(':')[0]}"
        except AttributeError:
            return None

    # @computed_field
    @property
    def profile_id_validate(self) -> int | None:
        try:
            return int(self.comment.split(":")[1])
        except (AttributeError, ValueError, IndexError):
            return None

    @property
    def comment_value_0(self) -> str | None:
        try:
            return self.comment.split(":")[0]
        except (AttributeError, IndexError):
            return None

    @property
    def comment_value_1(self) -> str | None:
        try:
            return self.comment.split(":")[1]
        except (AttributeError, IndexError):
            return None

    @property
    def comment_value_2(self) -> str | None:
        try:
            return self.comment.split(":")[2]
        except (AttributeError, IndexError):
            return None

    @staticmethod
    def api_path(id_=None):
        return api_path("/rest/ip/firewall/mangle", id_)

    model_config = ConfigDict(populate_by_name=True)
