# Pygame Widgets

A helper module for common widgets that may be required in developing applications with Pygame. It supports fully
customisable buttons, collections of buttons, textboxes and sliders. If there are any widgets that you would like to see
added, please create an issue!

## NEW FEATURES

* Dropdown: Select options from a list that appears when hovered over
* Progress Bar: Shows a percentage of completeness, great for loading screens and health bars
* Toggle: Allows switching between two values, great for settings
* Animations: Create an animation that changes a widgets attributes over some time, running on a separate thread

## Prerequisites

* [Python 3](https://www.python.org/downloads)
* [Pygame 2.0.0](https://www.pygame.org/wiki/GettingStarted)

## Installation

Ensure that Python 3 and pip are installed and added to your environment PATH.

```python -m pip install pygame-widgets```

Open a Python console and run the following command.

```import pygame_widgets```

If you receive no errors, the installation was successful.

## Usage

* [Common](docs/common.md)
* [Button](docs/button.md)
* [ButtonArray](docs/buttonarray.md)
* [TextBox](docs/textbox.md)
* [Slider](docs/slider.md)
* [Dropdown](docs/dropdown.md)
* [Animations](docs/animations.md)
