"""Logs address selector index

Revision ID: e02c90ea67bb
Revises: a4ef4f9031e4
Create Date: 2024-06-06 13:12:14.594600

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = "e02c90ea67bb"
down_revision: Union[str, None] = "a4ef4f9031e4"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_index(
        "idx_arbitrum_one_logs_address_selector",
        "arbitrum_one_logs",
        ["address", "selector"],
        unique=False,
    )
    op.create_index(
        "idx_arbitrum_sepolia_logs_address_selector",
        "arbitrum_sepolia_logs",
        ["address", "selector"],
        unique=False,
    )
    op.create_index(
        "idx_ethereum_logs_address_selector",
        "ethereum_logs",
        ["address", "selector"],
        unique=False,
    )
    op.create_index(
        "idx_game7_orbit_arbitrum_sepolia_logs_address_selector",
        "game7_orbit_arbitrum_sepolia_logs",
        ["address", "selector"],
        unique=False,
    )
    op.create_index(
        "idx_mantle_logs_address_selector",
        "mantle_logs",
        ["address", "selector"],
        unique=False,
    )
    op.create_index(
        "idx_mantle_sepolia_logs_address_selector",
        "mantle_sepolia_logs",
        ["address", "selector"],
        unique=False,
    )
    op.create_index(
        "idx_polygon_logs_address_selector",
        "polygon_logs",
        ["address", "selector"],
        unique=False,
    )
    op.create_index(
        "idx_xai_logs_address_selector",
        "xai_logs",
        ["address", "selector"],
        unique=False,
    )
    op.create_index(
        "idx_xai_sepolia_logs_address_selector",
        "xai_sepolia_logs",
        ["address", "selector"],
        unique=False,
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(
        "idx_xai_sepolia_logs_address_selector", table_name="xai_sepolia_logs"
    )
    op.drop_index("idx_xai_logs_address_selector", table_name="xai_logs")
    op.drop_index("idx_polygon_logs_address_selector", table_name="polygon_logs")
    op.drop_index(
        "idx_mantle_sepolia_logs_address_selector", table_name="mantle_sepolia_logs"
    )
    op.drop_index("idx_mantle_logs_address_selector", table_name="mantle_logs")
    op.drop_index(
        "idx_game7_orbit_arbitrum_sepolia_logs_address_selector",
        table_name="game7_orbit_arbitrum_sepolia_logs",
    )
    op.drop_index("idx_ethereum_logs_address_selector", table_name="ethereum_logs")
    op.drop_index(
        "idx_arbitrum_sepolia_logs_address_selector", table_name="arbitrum_sepolia_logs"
    )
    op.drop_index(
        "idx_arbitrum_one_logs_address_selector", table_name="arbitrum_one_logs"
    )
    # ### end Alembic commands ###
