"""Game7 Orbit, Arbitrum, Xai and Mantle blockchain indexes models

Revision ID: a4ef4f9031e4
Revises: 0ea24314c181
Create Date: 2024-05-29 13:19:42.833716

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = 'a4ef4f9031e4'
down_revision: Union[str, None] = '0ea24314c181'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('arbitrum_one_blocks',
    sa.Column('l1_block_number', sa.BigInteger(), nullable=False),
    sa.Column('block_number', sa.BigInteger(), nullable=False),
    sa.Column('block_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('block_timestamp', sa.BigInteger(), nullable=False),
    sa.Column('parent_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('row_id', sa.BigInteger(), nullable=False),
    sa.Column('path', sa.Text(), nullable=False),
    sa.Column('indexed_at', sa.DateTime(timezone=True), server_default=sa.text("TIMEZONE('utc', statement_timestamp())"), nullable=False),
    sa.PrimaryKeyConstraint('block_number', name=op.f('pk_arbitrum_one_blocks'))
    )
    op.create_index(op.f('ix_arbitrum_one_blocks_block_number'), 'arbitrum_one_blocks', ['block_number'], unique=False)
    op.create_index(op.f('ix_arbitrum_one_blocks_block_timestamp'), 'arbitrum_one_blocks', ['block_timestamp'], unique=False)
    op.create_table('arbitrum_one_reorgs',
    sa.Column('id', sa.UUID(), nullable=False),
    sa.Column('block_number', sa.BigInteger(), nullable=False),
    sa.Column('block_hash', sa.VARCHAR(length=256), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_arbitrum_one_reorgs'))
    )
    op.create_index(op.f('ix_arbitrum_one_reorgs_block_hash'), 'arbitrum_one_reorgs', ['block_hash'], unique=False)
    op.create_index(op.f('ix_arbitrum_one_reorgs_block_number'), 'arbitrum_one_reorgs', ['block_number'], unique=False)
    op.create_table('arbitrum_sepolia_blocks',
    sa.Column('l1_block_number', sa.BigInteger(), nullable=False),
    sa.Column('block_number', sa.BigInteger(), nullable=False),
    sa.Column('block_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('block_timestamp', sa.BigInteger(), nullable=False),
    sa.Column('parent_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('row_id', sa.BigInteger(), nullable=False),
    sa.Column('path', sa.Text(), nullable=False),
    sa.Column('indexed_at', sa.DateTime(timezone=True), server_default=sa.text("TIMEZONE('utc', statement_timestamp())"), nullable=False),
    sa.PrimaryKeyConstraint('block_number', name=op.f('pk_arbitrum_sepolia_blocks'))
    )
    op.create_index(op.f('ix_arbitrum_sepolia_blocks_block_number'), 'arbitrum_sepolia_blocks', ['block_number'], unique=False)
    op.create_index(op.f('ix_arbitrum_sepolia_blocks_block_timestamp'), 'arbitrum_sepolia_blocks', ['block_timestamp'], unique=False)
    op.create_table('arbitrum_sepolia_reorgs',
    sa.Column('id', sa.UUID(), nullable=False),
    sa.Column('block_number', sa.BigInteger(), nullable=False),
    sa.Column('block_hash', sa.VARCHAR(length=256), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_arbitrum_sepolia_reorgs'))
    )
    op.create_index(op.f('ix_arbitrum_sepolia_reorgs_block_hash'), 'arbitrum_sepolia_reorgs', ['block_hash'], unique=False)
    op.create_index(op.f('ix_arbitrum_sepolia_reorgs_block_number'), 'arbitrum_sepolia_reorgs', ['block_number'], unique=False)
    op.create_table('game7_orbit_arbitrum_sepolia_blocks',
    sa.Column('l1_block_number', sa.BigInteger(), nullable=False),
    sa.Column('block_number', sa.BigInteger(), nullable=False),
    sa.Column('block_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('block_timestamp', sa.BigInteger(), nullable=False),
    sa.Column('parent_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('row_id', sa.BigInteger(), nullable=False),
    sa.Column('path', sa.Text(), nullable=False),
    sa.Column('indexed_at', sa.DateTime(timezone=True), server_default=sa.text("TIMEZONE('utc', statement_timestamp())"), nullable=False),
    sa.PrimaryKeyConstraint('block_number', name=op.f('pk_game7_orbit_arbitrum_sepolia_blocks'))
    )
    op.create_index(op.f('ix_game7_orbit_arbitrum_sepolia_blocks_block_number'), 'game7_orbit_arbitrum_sepolia_blocks', ['block_number'], unique=False)
    op.create_index(op.f('ix_game7_orbit_arbitrum_sepolia_blocks_block_timestamp'), 'game7_orbit_arbitrum_sepolia_blocks', ['block_timestamp'], unique=False)
    op.create_table('game7_orbit_arbitrum_sepolia_reorgs',
    sa.Column('id', sa.UUID(), nullable=False),
    sa.Column('block_number', sa.BigInteger(), nullable=False),
    sa.Column('block_hash', sa.VARCHAR(length=256), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_game7_orbit_arbitrum_sepolia_reorgs'))
    )
    op.create_index(op.f('ix_game7_orbit_arbitrum_sepolia_reorgs_block_hash'), 'game7_orbit_arbitrum_sepolia_reorgs', ['block_hash'], unique=False)
    op.create_index(op.f('ix_game7_orbit_arbitrum_sepolia_reorgs_block_number'), 'game7_orbit_arbitrum_sepolia_reorgs', ['block_number'], unique=False)
    op.create_table('mantle_blocks',
    sa.Column('block_number', sa.BigInteger(), nullable=False),
    sa.Column('block_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('block_timestamp', sa.BigInteger(), nullable=False),
    sa.Column('parent_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('row_id', sa.BigInteger(), nullable=False),
    sa.Column('path', sa.Text(), nullable=False),
    sa.Column('indexed_at', sa.DateTime(timezone=True), server_default=sa.text("TIMEZONE('utc', statement_timestamp())"), nullable=False),
    sa.PrimaryKeyConstraint('block_number', name=op.f('pk_mantle_blocks'))
    )
    op.create_index(op.f('ix_mantle_blocks_block_number'), 'mantle_blocks', ['block_number'], unique=False)
    op.create_index(op.f('ix_mantle_blocks_block_timestamp'), 'mantle_blocks', ['block_timestamp'], unique=False)
    op.create_table('mantle_reorgs',
    sa.Column('id', sa.UUID(), nullable=False),
    sa.Column('block_number', sa.BigInteger(), nullable=False),
    sa.Column('block_hash', sa.VARCHAR(length=256), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_mantle_reorgs'))
    )
    op.create_index(op.f('ix_mantle_reorgs_block_hash'), 'mantle_reorgs', ['block_hash'], unique=False)
    op.create_index(op.f('ix_mantle_reorgs_block_number'), 'mantle_reorgs', ['block_number'], unique=False)
    op.create_table('mantle_sepolia_blocks',
    sa.Column('block_number', sa.BigInteger(), nullable=False),
    sa.Column('block_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('block_timestamp', sa.BigInteger(), nullable=False),
    sa.Column('parent_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('row_id', sa.BigInteger(), nullable=False),
    sa.Column('path', sa.Text(), nullable=False),
    sa.Column('indexed_at', sa.DateTime(timezone=True), server_default=sa.text("TIMEZONE('utc', statement_timestamp())"), nullable=False),
    sa.PrimaryKeyConstraint('block_number', name=op.f('pk_mantle_sepolia_blocks'))
    )
    op.create_index(op.f('ix_mantle_sepolia_blocks_block_number'), 'mantle_sepolia_blocks', ['block_number'], unique=False)
    op.create_index(op.f('ix_mantle_sepolia_blocks_block_timestamp'), 'mantle_sepolia_blocks', ['block_timestamp'], unique=False)
    op.create_table('mantle_sepolia_reorgs',
    sa.Column('id', sa.UUID(), nullable=False),
    sa.Column('block_number', sa.BigInteger(), nullable=False),
    sa.Column('block_hash', sa.VARCHAR(length=256), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_mantle_sepolia_reorgs'))
    )
    op.create_index(op.f('ix_mantle_sepolia_reorgs_block_hash'), 'mantle_sepolia_reorgs', ['block_hash'], unique=False)
    op.create_index(op.f('ix_mantle_sepolia_reorgs_block_number'), 'mantle_sepolia_reorgs', ['block_number'], unique=False)
    op.create_table('xai_blocks',
    sa.Column('l1_block_number', sa.BigInteger(), nullable=False),
    sa.Column('block_number', sa.BigInteger(), nullable=False),
    sa.Column('block_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('block_timestamp', sa.BigInteger(), nullable=False),
    sa.Column('parent_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('row_id', sa.BigInteger(), nullable=False),
    sa.Column('path', sa.Text(), nullable=False),
    sa.Column('indexed_at', sa.DateTime(timezone=True), server_default=sa.text("TIMEZONE('utc', statement_timestamp())"), nullable=False),
    sa.PrimaryKeyConstraint('block_number', name=op.f('pk_xai_blocks'))
    )
    op.create_index(op.f('ix_xai_blocks_block_number'), 'xai_blocks', ['block_number'], unique=False)
    op.create_index(op.f('ix_xai_blocks_block_timestamp'), 'xai_blocks', ['block_timestamp'], unique=False)
    op.create_table('xai_reorgs',
    sa.Column('id', sa.UUID(), nullable=False),
    sa.Column('block_number', sa.BigInteger(), nullable=False),
    sa.Column('block_hash', sa.VARCHAR(length=256), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_xai_reorgs'))
    )
    op.create_index(op.f('ix_xai_reorgs_block_hash'), 'xai_reorgs', ['block_hash'], unique=False)
    op.create_index(op.f('ix_xai_reorgs_block_number'), 'xai_reorgs', ['block_number'], unique=False)
    op.create_table('xai_sepolia_blocks',
    sa.Column('l1_block_number', sa.BigInteger(), nullable=False),
    sa.Column('block_number', sa.BigInteger(), nullable=False),
    sa.Column('block_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('block_timestamp', sa.BigInteger(), nullable=False),
    sa.Column('parent_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('row_id', sa.BigInteger(), nullable=False),
    sa.Column('path', sa.Text(), nullable=False),
    sa.Column('indexed_at', sa.DateTime(timezone=True), server_default=sa.text("TIMEZONE('utc', statement_timestamp())"), nullable=False),
    sa.PrimaryKeyConstraint('block_number', name=op.f('pk_xai_sepolia_blocks'))
    )
    op.create_index(op.f('ix_xai_sepolia_blocks_block_number'), 'xai_sepolia_blocks', ['block_number'], unique=False)
    op.create_index(op.f('ix_xai_sepolia_blocks_block_timestamp'), 'xai_sepolia_blocks', ['block_timestamp'], unique=False)
    op.create_table('xai_sepolia_reorgs',
    sa.Column('id', sa.UUID(), nullable=False),
    sa.Column('block_number', sa.BigInteger(), nullable=False),
    sa.Column('block_hash', sa.VARCHAR(length=256), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_xai_sepolia_reorgs'))
    )
    op.create_index(op.f('ix_xai_sepolia_reorgs_block_hash'), 'xai_sepolia_reorgs', ['block_hash'], unique=False)
    op.create_index(op.f('ix_xai_sepolia_reorgs_block_number'), 'xai_sepolia_reorgs', ['block_number'], unique=False)
    op.create_table('arbitrum_one_transactions',
    sa.Column('block_number', sa.BigInteger(), nullable=False),
    sa.Column('hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('from_address', sa.LargeBinary(length=20), nullable=False),
    sa.Column('to_address', sa.LargeBinary(length=20), nullable=False),
    sa.Column('selector', sa.VARCHAR(length=256), nullable=True),
    sa.Column('type', sa.Integer(), nullable=True),
    sa.Column('row_id', sa.BigInteger(), nullable=False),
    sa.Column('block_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('index', sa.BigInteger(), nullable=False),
    sa.Column('path', sa.Text(), nullable=False),
    sa.Column('indexed_at', sa.DateTime(timezone=True), server_default=sa.text("TIMEZONE('utc', statement_timestamp())"), nullable=False),
    sa.ForeignKeyConstraint(['block_number'], ['arbitrum_one_blocks.block_number'], name=op.f('fk_arbitrum_one_transactions_block_number_arbitrum_one_blocks'), ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('hash', name=op.f('pk_arbitrum_one_transactions'))
    )
    op.create_index(op.f('ix_arbitrum_one_transactions_block_hash'), 'arbitrum_one_transactions', ['block_hash'], unique=False)
    op.create_index(op.f('ix_arbitrum_one_transactions_block_number'), 'arbitrum_one_transactions', ['block_number'], unique=False)
    op.create_index(op.f('ix_arbitrum_one_transactions_from_address'), 'arbitrum_one_transactions', ['from_address'], unique=False)
    op.create_index(op.f('ix_arbitrum_one_transactions_hash'), 'arbitrum_one_transactions', ['hash'], unique=True)
    op.create_index(op.f('ix_arbitrum_one_transactions_index'), 'arbitrum_one_transactions', ['index'], unique=False)
    op.create_index(op.f('ix_arbitrum_one_transactions_selector'), 'arbitrum_one_transactions', ['selector'], unique=False)
    op.create_index(op.f('ix_arbitrum_one_transactions_to_address'), 'arbitrum_one_transactions', ['to_address'], unique=False)
    op.create_index(op.f('ix_arbitrum_one_transactions_type'), 'arbitrum_one_transactions', ['type'], unique=False)
    op.create_table('arbitrum_sepolia_transactions',
    sa.Column('block_number', sa.BigInteger(), nullable=False),
    sa.Column('hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('from_address', sa.LargeBinary(length=20), nullable=False),
    sa.Column('to_address', sa.LargeBinary(length=20), nullable=False),
    sa.Column('selector', sa.VARCHAR(length=256), nullable=True),
    sa.Column('type', sa.Integer(), nullable=True),
    sa.Column('row_id', sa.BigInteger(), nullable=False),
    sa.Column('block_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('index', sa.BigInteger(), nullable=False),
    sa.Column('path', sa.Text(), nullable=False),
    sa.Column('indexed_at', sa.DateTime(timezone=True), server_default=sa.text("TIMEZONE('utc', statement_timestamp())"), nullable=False),
    sa.ForeignKeyConstraint(['block_number'], ['arbitrum_sepolia_blocks.block_number'], name=op.f('fk_arbitrum_sepolia_transactions_block_number_arbitrum_sepolia_blocks'), ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('hash', name=op.f('pk_arbitrum_sepolia_transactions'))
    )
    op.create_index(op.f('ix_arbitrum_sepolia_transactions_block_hash'), 'arbitrum_sepolia_transactions', ['block_hash'], unique=False)
    op.create_index(op.f('ix_arbitrum_sepolia_transactions_block_number'), 'arbitrum_sepolia_transactions', ['block_number'], unique=False)
    op.create_index(op.f('ix_arbitrum_sepolia_transactions_from_address'), 'arbitrum_sepolia_transactions', ['from_address'], unique=False)
    op.create_index(op.f('ix_arbitrum_sepolia_transactions_hash'), 'arbitrum_sepolia_transactions', ['hash'], unique=True)
    op.create_index(op.f('ix_arbitrum_sepolia_transactions_index'), 'arbitrum_sepolia_transactions', ['index'], unique=False)
    op.create_index(op.f('ix_arbitrum_sepolia_transactions_selector'), 'arbitrum_sepolia_transactions', ['selector'], unique=False)
    op.create_index(op.f('ix_arbitrum_sepolia_transactions_to_address'), 'arbitrum_sepolia_transactions', ['to_address'], unique=False)
    op.create_index(op.f('ix_arbitrum_sepolia_transactions_type'), 'arbitrum_sepolia_transactions', ['type'], unique=False)
    op.create_table('game7_orbit_arbitrum_sepolia_transactions',
    sa.Column('block_number', sa.BigInteger(), nullable=False),
    sa.Column('hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('from_address', sa.LargeBinary(length=20), nullable=False),
    sa.Column('to_address', sa.LargeBinary(length=20), nullable=False),
    sa.Column('selector', sa.VARCHAR(length=256), nullable=True),
    sa.Column('type', sa.Integer(), nullable=True),
    sa.Column('row_id', sa.BigInteger(), nullable=False),
    sa.Column('block_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('index', sa.BigInteger(), nullable=False),
    sa.Column('path', sa.Text(), nullable=False),
    sa.Column('indexed_at', sa.DateTime(timezone=True), server_default=sa.text("TIMEZONE('utc', statement_timestamp())"), nullable=False),
    sa.ForeignKeyConstraint(['block_number'], ['game7_orbit_arbitrum_sepolia_blocks.block_number'], name=op.f('fk_game7_orbit_arbitrum_sepolia_transactions_block_number_game7_orbit_arbitrum_sepolia_blocks'), ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('hash', name=op.f('pk_game7_orbit_arbitrum_sepolia_transactions'))
    )
    op.create_index(op.f('ix_game7_orbit_arbitrum_sepolia_transactions_block_hash'), 'game7_orbit_arbitrum_sepolia_transactions', ['block_hash'], unique=False)
    op.create_index(op.f('ix_game7_orbit_arbitrum_sepolia_transactions_block_number'), 'game7_orbit_arbitrum_sepolia_transactions', ['block_number'], unique=False)
    op.create_index(op.f('ix_game7_orbit_arbitrum_sepolia_transactions_from_address'), 'game7_orbit_arbitrum_sepolia_transactions', ['from_address'], unique=False)
    op.create_index(op.f('ix_game7_orbit_arbitrum_sepolia_transactions_hash'), 'game7_orbit_arbitrum_sepolia_transactions', ['hash'], unique=True)
    op.create_index(op.f('ix_game7_orbit_arbitrum_sepolia_transactions_index'), 'game7_orbit_arbitrum_sepolia_transactions', ['index'], unique=False)
    op.create_index(op.f('ix_game7_orbit_arbitrum_sepolia_transactions_selector'), 'game7_orbit_arbitrum_sepolia_transactions', ['selector'], unique=False)
    op.create_index(op.f('ix_game7_orbit_arbitrum_sepolia_transactions_to_address'), 'game7_orbit_arbitrum_sepolia_transactions', ['to_address'], unique=False)
    op.create_index(op.f('ix_game7_orbit_arbitrum_sepolia_transactions_type'), 'game7_orbit_arbitrum_sepolia_transactions', ['type'], unique=False)
    op.create_table('mantle_sepolia_transactions',
    sa.Column('block_number', sa.BigInteger(), nullable=False),
    sa.Column('hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('from_address', sa.LargeBinary(length=20), nullable=False),
    sa.Column('to_address', sa.LargeBinary(length=20), nullable=False),
    sa.Column('selector', sa.VARCHAR(length=256), nullable=True),
    sa.Column('type', sa.Integer(), nullable=True),
    sa.Column('row_id', sa.BigInteger(), nullable=False),
    sa.Column('block_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('index', sa.BigInteger(), nullable=False),
    sa.Column('path', sa.Text(), nullable=False),
    sa.Column('indexed_at', sa.DateTime(timezone=True), server_default=sa.text("TIMEZONE('utc', statement_timestamp())"), nullable=False),
    sa.ForeignKeyConstraint(['block_number'], ['mantle_sepolia_blocks.block_number'], name=op.f('fk_mantle_sepolia_transactions_block_number_mantle_sepolia_blocks'), ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('hash', name=op.f('pk_mantle_sepolia_transactions'))
    )
    op.create_index(op.f('ix_mantle_sepolia_transactions_block_hash'), 'mantle_sepolia_transactions', ['block_hash'], unique=False)
    op.create_index(op.f('ix_mantle_sepolia_transactions_block_number'), 'mantle_sepolia_transactions', ['block_number'], unique=False)
    op.create_index(op.f('ix_mantle_sepolia_transactions_from_address'), 'mantle_sepolia_transactions', ['from_address'], unique=False)
    op.create_index(op.f('ix_mantle_sepolia_transactions_hash'), 'mantle_sepolia_transactions', ['hash'], unique=True)
    op.create_index(op.f('ix_mantle_sepolia_transactions_index'), 'mantle_sepolia_transactions', ['index'], unique=False)
    op.create_index(op.f('ix_mantle_sepolia_transactions_selector'), 'mantle_sepolia_transactions', ['selector'], unique=False)
    op.create_index(op.f('ix_mantle_sepolia_transactions_to_address'), 'mantle_sepolia_transactions', ['to_address'], unique=False)
    op.create_index(op.f('ix_mantle_sepolia_transactions_type'), 'mantle_sepolia_transactions', ['type'], unique=False)
    op.create_table('mantle_transactions',
    sa.Column('block_number', sa.BigInteger(), nullable=False),
    sa.Column('hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('from_address', sa.LargeBinary(length=20), nullable=False),
    sa.Column('to_address', sa.LargeBinary(length=20), nullable=False),
    sa.Column('selector', sa.VARCHAR(length=256), nullable=True),
    sa.Column('type', sa.Integer(), nullable=True),
    sa.Column('row_id', sa.BigInteger(), nullable=False),
    sa.Column('block_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('index', sa.BigInteger(), nullable=False),
    sa.Column('path', sa.Text(), nullable=False),
    sa.Column('indexed_at', sa.DateTime(timezone=True), server_default=sa.text("TIMEZONE('utc', statement_timestamp())"), nullable=False),
    sa.ForeignKeyConstraint(['block_number'], ['mantle_blocks.block_number'], name=op.f('fk_mantle_transactions_block_number_mantle_blocks'), ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('hash', name=op.f('pk_mantle_transactions'))
    )
    op.create_index(op.f('ix_mantle_transactions_block_hash'), 'mantle_transactions', ['block_hash'], unique=False)
    op.create_index(op.f('ix_mantle_transactions_block_number'), 'mantle_transactions', ['block_number'], unique=False)
    op.create_index(op.f('ix_mantle_transactions_from_address'), 'mantle_transactions', ['from_address'], unique=False)
    op.create_index(op.f('ix_mantle_transactions_hash'), 'mantle_transactions', ['hash'], unique=True)
    op.create_index(op.f('ix_mantle_transactions_index'), 'mantle_transactions', ['index'], unique=False)
    op.create_index(op.f('ix_mantle_transactions_selector'), 'mantle_transactions', ['selector'], unique=False)
    op.create_index(op.f('ix_mantle_transactions_to_address'), 'mantle_transactions', ['to_address'], unique=False)
    op.create_index(op.f('ix_mantle_transactions_type'), 'mantle_transactions', ['type'], unique=False)
    op.create_table('xai_sepolia_transactions',
    sa.Column('block_number', sa.BigInteger(), nullable=False),
    sa.Column('hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('from_address', sa.LargeBinary(length=20), nullable=False),
    sa.Column('to_address', sa.LargeBinary(length=20), nullable=False),
    sa.Column('selector', sa.VARCHAR(length=256), nullable=True),
    sa.Column('type', sa.Integer(), nullable=True),
    sa.Column('row_id', sa.BigInteger(), nullable=False),
    sa.Column('block_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('index', sa.BigInteger(), nullable=False),
    sa.Column('path', sa.Text(), nullable=False),
    sa.Column('indexed_at', sa.DateTime(timezone=True), server_default=sa.text("TIMEZONE('utc', statement_timestamp())"), nullable=False),
    sa.ForeignKeyConstraint(['block_number'], ['xai_sepolia_blocks.block_number'], name=op.f('fk_xai_sepolia_transactions_block_number_xai_sepolia_blocks'), ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('hash', name=op.f('pk_xai_sepolia_transactions'))
    )
    op.create_index(op.f('ix_xai_sepolia_transactions_block_hash'), 'xai_sepolia_transactions', ['block_hash'], unique=False)
    op.create_index(op.f('ix_xai_sepolia_transactions_block_number'), 'xai_sepolia_transactions', ['block_number'], unique=False)
    op.create_index(op.f('ix_xai_sepolia_transactions_from_address'), 'xai_sepolia_transactions', ['from_address'], unique=False)
    op.create_index(op.f('ix_xai_sepolia_transactions_hash'), 'xai_sepolia_transactions', ['hash'], unique=True)
    op.create_index(op.f('ix_xai_sepolia_transactions_index'), 'xai_sepolia_transactions', ['index'], unique=False)
    op.create_index(op.f('ix_xai_sepolia_transactions_selector'), 'xai_sepolia_transactions', ['selector'], unique=False)
    op.create_index(op.f('ix_xai_sepolia_transactions_to_address'), 'xai_sepolia_transactions', ['to_address'], unique=False)
    op.create_index(op.f('ix_xai_sepolia_transactions_type'), 'xai_sepolia_transactions', ['type'], unique=False)
    op.create_table('xai_transactions',
    sa.Column('block_number', sa.BigInteger(), nullable=False),
    sa.Column('hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('from_address', sa.LargeBinary(length=20), nullable=False),
    sa.Column('to_address', sa.LargeBinary(length=20), nullable=False),
    sa.Column('selector', sa.VARCHAR(length=256), nullable=True),
    sa.Column('type', sa.Integer(), nullable=True),
    sa.Column('row_id', sa.BigInteger(), nullable=False),
    sa.Column('block_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('index', sa.BigInteger(), nullable=False),
    sa.Column('path', sa.Text(), nullable=False),
    sa.Column('indexed_at', sa.DateTime(timezone=True), server_default=sa.text("TIMEZONE('utc', statement_timestamp())"), nullable=False),
    sa.ForeignKeyConstraint(['block_number'], ['xai_blocks.block_number'], name=op.f('fk_xai_transactions_block_number_xai_blocks'), ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('hash', name=op.f('pk_xai_transactions'))
    )
    op.create_index(op.f('ix_xai_transactions_block_hash'), 'xai_transactions', ['block_hash'], unique=False)
    op.create_index(op.f('ix_xai_transactions_block_number'), 'xai_transactions', ['block_number'], unique=False)
    op.create_index(op.f('ix_xai_transactions_from_address'), 'xai_transactions', ['from_address'], unique=False)
    op.create_index(op.f('ix_xai_transactions_hash'), 'xai_transactions', ['hash'], unique=True)
    op.create_index(op.f('ix_xai_transactions_index'), 'xai_transactions', ['index'], unique=False)
    op.create_index(op.f('ix_xai_transactions_selector'), 'xai_transactions', ['selector'], unique=False)
    op.create_index(op.f('ix_xai_transactions_to_address'), 'xai_transactions', ['to_address'], unique=False)
    op.create_index(op.f('ix_xai_transactions_type'), 'xai_transactions', ['type'], unique=False)
    op.create_table('arbitrum_one_logs',
    sa.Column('transaction_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('block_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('address', sa.LargeBinary(length=20), nullable=False),
    sa.Column('row_id', sa.BigInteger(), nullable=False),
    sa.Column('selector', sa.VARCHAR(length=256), nullable=True),
    sa.Column('topic1', sa.VARCHAR(length=256), nullable=True),
    sa.Column('topic2', sa.VARCHAR(length=256), nullable=True),
    sa.Column('log_index', sa.BigInteger(), nullable=False),
    sa.Column('path', sa.Text(), nullable=False),
    sa.Column('indexed_at', sa.DateTime(timezone=True), server_default=sa.text("TIMEZONE('utc', statement_timestamp())"), nullable=False),
    sa.ForeignKeyConstraint(['transaction_hash'], ['arbitrum_one_transactions.hash'], name=op.f('fk_arbitrum_one_logs_transaction_hash_arbitrum_one_transactions'), ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('transaction_hash', 'log_index', name='pk_arbitrum_one_log_index'),
    sa.UniqueConstraint('transaction_hash', 'log_index', name='uq_arbitrum_one_log_idx_tx_hash_log_idx')
    )
    op.create_index(op.f('ix_arbitrum_one_logs_address'), 'arbitrum_one_logs', ['address'], unique=False)
    op.create_index(op.f('ix_arbitrum_one_logs_block_hash'), 'arbitrum_one_logs', ['block_hash'], unique=False)
    op.create_index(op.f('ix_arbitrum_one_logs_transaction_hash'), 'arbitrum_one_logs', ['transaction_hash'], unique=False)
    op.create_table('arbitrum_sepolia_logs',
    sa.Column('transaction_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('block_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('address', sa.LargeBinary(length=20), nullable=False),
    sa.Column('row_id', sa.BigInteger(), nullable=False),
    sa.Column('selector', sa.VARCHAR(length=256), nullable=True),
    sa.Column('topic1', sa.VARCHAR(length=256), nullable=True),
    sa.Column('topic2', sa.VARCHAR(length=256), nullable=True),
    sa.Column('log_index', sa.BigInteger(), nullable=False),
    sa.Column('path', sa.Text(), nullable=False),
    sa.Column('indexed_at', sa.DateTime(timezone=True), server_default=sa.text("TIMEZONE('utc', statement_timestamp())"), nullable=False),
    sa.ForeignKeyConstraint(['transaction_hash'], ['arbitrum_sepolia_transactions.hash'], name=op.f('fk_arbitrum_sepolia_logs_transaction_hash_arbitrum_sepolia_transactions'), ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('transaction_hash', 'log_index', name='pk_arbitrum_sepolia_log_index'),
    sa.UniqueConstraint('transaction_hash', 'log_index', name='uq_arbitrum_sepolia_log_idx_tx_hash_log_idx')
    )
    op.create_index(op.f('ix_arbitrum_sepolia_logs_address'), 'arbitrum_sepolia_logs', ['address'], unique=False)
    op.create_index(op.f('ix_arbitrum_sepolia_logs_block_hash'), 'arbitrum_sepolia_logs', ['block_hash'], unique=False)
    op.create_index(op.f('ix_arbitrum_sepolia_logs_transaction_hash'), 'arbitrum_sepolia_logs', ['transaction_hash'], unique=False)
    op.create_table('game7_orbit_arbitrum_sepolia_logs',
    sa.Column('transaction_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('block_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('address', sa.LargeBinary(length=20), nullable=False),
    sa.Column('row_id', sa.BigInteger(), nullable=False),
    sa.Column('selector', sa.VARCHAR(length=256), nullable=True),
    sa.Column('topic1', sa.VARCHAR(length=256), nullable=True),
    sa.Column('topic2', sa.VARCHAR(length=256), nullable=True),
    sa.Column('log_index', sa.BigInteger(), nullable=False),
    sa.Column('path', sa.Text(), nullable=False),
    sa.Column('indexed_at', sa.DateTime(timezone=True), server_default=sa.text("TIMEZONE('utc', statement_timestamp())"), nullable=False),
    sa.ForeignKeyConstraint(['transaction_hash'], ['game7_orbit_arbitrum_sepolia_transactions.hash'], name=op.f('fk_game7_orbit_arbitrum_sepolia_logs_transaction_hash_game7_orbit_arbitrum_sepolia_transactions'), ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('transaction_hash', 'log_index', name='pk_game7_orbit_arbitrum_sepolia_log_index'),
    sa.UniqueConstraint('transaction_hash', 'log_index', name='uq_g7o_arbitrum_sepolia_log_idx_tx_hash_log_idx')
    )
    op.create_index(op.f('ix_game7_orbit_arbitrum_sepolia_logs_address'), 'game7_orbit_arbitrum_sepolia_logs', ['address'], unique=False)
    op.create_index(op.f('ix_game7_orbit_arbitrum_sepolia_logs_block_hash'), 'game7_orbit_arbitrum_sepolia_logs', ['block_hash'], unique=False)
    op.create_index(op.f('ix_game7_orbit_arbitrum_sepolia_logs_transaction_hash'), 'game7_orbit_arbitrum_sepolia_logs', ['transaction_hash'], unique=False)
    op.create_table('mantle_logs',
    sa.Column('transaction_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('block_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('address', sa.LargeBinary(length=20), nullable=False),
    sa.Column('row_id', sa.BigInteger(), nullable=False),
    sa.Column('selector', sa.VARCHAR(length=256), nullable=True),
    sa.Column('topic1', sa.VARCHAR(length=256), nullable=True),
    sa.Column('topic2', sa.VARCHAR(length=256), nullable=True),
    sa.Column('log_index', sa.BigInteger(), nullable=False),
    sa.Column('path', sa.Text(), nullable=False),
    sa.Column('indexed_at', sa.DateTime(timezone=True), server_default=sa.text("TIMEZONE('utc', statement_timestamp())"), nullable=False),
    sa.ForeignKeyConstraint(['transaction_hash'], ['mantle_transactions.hash'], name=op.f('fk_mantle_logs_transaction_hash_mantle_transactions'), ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('transaction_hash', 'log_index', name='pk_mantle_log_index'),
    sa.UniqueConstraint('transaction_hash', 'log_index', name='uq_mantle_log_index_transaction_hash_log_index')
    )
    op.create_index('idx_mantle_logs_block_hash_log_index', 'mantle_logs', ['block_hash', 'log_index'], unique=True)
    op.create_index(op.f('ix_mantle_logs_address'), 'mantle_logs', ['address'], unique=False)
    op.create_index(op.f('ix_mantle_logs_block_hash'), 'mantle_logs', ['block_hash'], unique=False)
    op.create_index(op.f('ix_mantle_logs_transaction_hash'), 'mantle_logs', ['transaction_hash'], unique=False)
    op.create_table('mantle_sepolia_logs',
    sa.Column('transaction_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('block_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('address', sa.LargeBinary(length=20), nullable=False),
    sa.Column('row_id', sa.BigInteger(), nullable=False),
    sa.Column('selector', sa.VARCHAR(length=256), nullable=True),
    sa.Column('topic1', sa.VARCHAR(length=256), nullable=True),
    sa.Column('topic2', sa.VARCHAR(length=256), nullable=True),
    sa.Column('log_index', sa.BigInteger(), nullable=False),
    sa.Column('path', sa.Text(), nullable=False),
    sa.Column('indexed_at', sa.DateTime(timezone=True), server_default=sa.text("TIMEZONE('utc', statement_timestamp())"), nullable=False),
    sa.ForeignKeyConstraint(['transaction_hash'], ['mantle_sepolia_transactions.hash'], name=op.f('fk_mantle_sepolia_logs_transaction_hash_mantle_sepolia_transactions'), ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('transaction_hash', 'log_index', name='pk_mantle_sepolia_log_index'),
    sa.UniqueConstraint('transaction_hash', 'log_index', name='uq_mantle_sepolia_log_index_transaction_hash_log_index')
    )
    op.create_index('idx_mantle_sepolia_logs_block_hash_log_index', 'mantle_sepolia_logs', ['block_hash', 'log_index'], unique=True)
    op.create_index(op.f('ix_mantle_sepolia_logs_address'), 'mantle_sepolia_logs', ['address'], unique=False)
    op.create_index(op.f('ix_mantle_sepolia_logs_block_hash'), 'mantle_sepolia_logs', ['block_hash'], unique=False)
    op.create_index(op.f('ix_mantle_sepolia_logs_transaction_hash'), 'mantle_sepolia_logs', ['transaction_hash'], unique=False)
    op.create_table('xai_logs',
    sa.Column('transaction_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('block_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('address', sa.LargeBinary(length=20), nullable=False),
    sa.Column('row_id', sa.BigInteger(), nullable=False),
    sa.Column('selector', sa.VARCHAR(length=256), nullable=True),
    sa.Column('topic1', sa.VARCHAR(length=256), nullable=True),
    sa.Column('topic2', sa.VARCHAR(length=256), nullable=True),
    sa.Column('log_index', sa.BigInteger(), nullable=False),
    sa.Column('path', sa.Text(), nullable=False),
    sa.Column('indexed_at', sa.DateTime(timezone=True), server_default=sa.text("TIMEZONE('utc', statement_timestamp())"), nullable=False),
    sa.ForeignKeyConstraint(['transaction_hash'], ['xai_transactions.hash'], name=op.f('fk_xai_logs_transaction_hash_xai_transactions'), ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('transaction_hash', 'log_index', name='pk_xai_log_index'),
    sa.UniqueConstraint('transaction_hash', 'log_index', name='uq_xai_log_idx_tx_hash_log_idx')
    )
    op.create_index(op.f('ix_xai_logs_address'), 'xai_logs', ['address'], unique=False)
    op.create_index(op.f('ix_xai_logs_block_hash'), 'xai_logs', ['block_hash'], unique=False)
    op.create_index(op.f('ix_xai_logs_transaction_hash'), 'xai_logs', ['transaction_hash'], unique=False)
    op.create_table('xai_sepolia_logs',
    sa.Column('transaction_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('block_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('address', sa.LargeBinary(length=20), nullable=False),
    sa.Column('row_id', sa.BigInteger(), nullable=False),
    sa.Column('selector', sa.VARCHAR(length=256), nullable=True),
    sa.Column('topic1', sa.VARCHAR(length=256), nullable=True),
    sa.Column('topic2', sa.VARCHAR(length=256), nullable=True),
    sa.Column('log_index', sa.BigInteger(), nullable=False),
    sa.Column('path', sa.Text(), nullable=False),
    sa.Column('indexed_at', sa.DateTime(timezone=True), server_default=sa.text("TIMEZONE('utc', statement_timestamp())"), nullable=False),
    sa.ForeignKeyConstraint(['transaction_hash'], ['xai_sepolia_transactions.hash'], name=op.f('fk_xai_sepolia_logs_transaction_hash_xai_sepolia_transactions'), ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('transaction_hash', 'log_index', name='pk_xai_sepolia_log_index'),
    sa.UniqueConstraint('transaction_hash', 'log_index', name='uq_xai_sepolia_log_idx_tx_hash_log_idx')
    )
    op.create_index(op.f('ix_xai_sepolia_logs_address'), 'xai_sepolia_logs', ['address'], unique=False)
    op.create_index(op.f('ix_xai_sepolia_logs_block_hash'), 'xai_sepolia_logs', ['block_hash'], unique=False)
    op.create_index(op.f('ix_xai_sepolia_logs_transaction_hash'), 'xai_sepolia_logs', ['transaction_hash'], unique=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_xai_sepolia_logs_transaction_hash'), table_name='xai_sepolia_logs')
    op.drop_index(op.f('ix_xai_sepolia_logs_block_hash'), table_name='xai_sepolia_logs')
    op.drop_index(op.f('ix_xai_sepolia_logs_address'), table_name='xai_sepolia_logs')
    op.drop_table('xai_sepolia_logs')
    op.drop_index(op.f('ix_xai_logs_transaction_hash'), table_name='xai_logs')
    op.drop_index(op.f('ix_xai_logs_block_hash'), table_name='xai_logs')
    op.drop_index(op.f('ix_xai_logs_address'), table_name='xai_logs')
    op.drop_table('xai_logs')
    op.drop_index(op.f('ix_mantle_sepolia_logs_transaction_hash'), table_name='mantle_sepolia_logs')
    op.drop_index(op.f('ix_mantle_sepolia_logs_block_hash'), table_name='mantle_sepolia_logs')
    op.drop_index(op.f('ix_mantle_sepolia_logs_address'), table_name='mantle_sepolia_logs')
    op.drop_index('idx_mantle_sepolia_logs_block_hash_log_index', table_name='mantle_sepolia_logs')
    op.drop_table('mantle_sepolia_logs')
    op.drop_index(op.f('ix_mantle_logs_transaction_hash'), table_name='mantle_logs')
    op.drop_index(op.f('ix_mantle_logs_block_hash'), table_name='mantle_logs')
    op.drop_index(op.f('ix_mantle_logs_address'), table_name='mantle_logs')
    op.drop_index('idx_mantle_logs_block_hash_log_index', table_name='mantle_logs')
    op.drop_table('mantle_logs')
    op.drop_index(op.f('ix_game7_orbit_arbitrum_sepolia_logs_transaction_hash'), table_name='game7_orbit_arbitrum_sepolia_logs')
    op.drop_index(op.f('ix_game7_orbit_arbitrum_sepolia_logs_block_hash'), table_name='game7_orbit_arbitrum_sepolia_logs')
    op.drop_index(op.f('ix_game7_orbit_arbitrum_sepolia_logs_address'), table_name='game7_orbit_arbitrum_sepolia_logs')
    op.drop_table('game7_orbit_arbitrum_sepolia_logs')
    op.drop_index(op.f('ix_arbitrum_sepolia_logs_transaction_hash'), table_name='arbitrum_sepolia_logs')
    op.drop_index(op.f('ix_arbitrum_sepolia_logs_block_hash'), table_name='arbitrum_sepolia_logs')
    op.drop_index(op.f('ix_arbitrum_sepolia_logs_address'), table_name='arbitrum_sepolia_logs')
    op.drop_table('arbitrum_sepolia_logs')
    op.drop_index(op.f('ix_arbitrum_one_logs_transaction_hash'), table_name='arbitrum_one_logs')
    op.drop_index(op.f('ix_arbitrum_one_logs_block_hash'), table_name='arbitrum_one_logs')
    op.drop_index(op.f('ix_arbitrum_one_logs_address'), table_name='arbitrum_one_logs')
    op.drop_table('arbitrum_one_logs')
    op.drop_index(op.f('ix_xai_transactions_type'), table_name='xai_transactions')
    op.drop_index(op.f('ix_xai_transactions_to_address'), table_name='xai_transactions')
    op.drop_index(op.f('ix_xai_transactions_selector'), table_name='xai_transactions')
    op.drop_index(op.f('ix_xai_transactions_index'), table_name='xai_transactions')
    op.drop_index(op.f('ix_xai_transactions_hash'), table_name='xai_transactions')
    op.drop_index(op.f('ix_xai_transactions_from_address'), table_name='xai_transactions')
    op.drop_index(op.f('ix_xai_transactions_block_number'), table_name='xai_transactions')
    op.drop_index(op.f('ix_xai_transactions_block_hash'), table_name='xai_transactions')
    op.drop_table('xai_transactions')
    op.drop_index(op.f('ix_xai_sepolia_transactions_type'), table_name='xai_sepolia_transactions')
    op.drop_index(op.f('ix_xai_sepolia_transactions_to_address'), table_name='xai_sepolia_transactions')
    op.drop_index(op.f('ix_xai_sepolia_transactions_selector'), table_name='xai_sepolia_transactions')
    op.drop_index(op.f('ix_xai_sepolia_transactions_index'), table_name='xai_sepolia_transactions')
    op.drop_index(op.f('ix_xai_sepolia_transactions_hash'), table_name='xai_sepolia_transactions')
    op.drop_index(op.f('ix_xai_sepolia_transactions_from_address'), table_name='xai_sepolia_transactions')
    op.drop_index(op.f('ix_xai_sepolia_transactions_block_number'), table_name='xai_sepolia_transactions')
    op.drop_index(op.f('ix_xai_sepolia_transactions_block_hash'), table_name='xai_sepolia_transactions')
    op.drop_table('xai_sepolia_transactions')
    op.drop_index(op.f('ix_mantle_transactions_type'), table_name='mantle_transactions')
    op.drop_index(op.f('ix_mantle_transactions_to_address'), table_name='mantle_transactions')
    op.drop_index(op.f('ix_mantle_transactions_selector'), table_name='mantle_transactions')
    op.drop_index(op.f('ix_mantle_transactions_index'), table_name='mantle_transactions')
    op.drop_index(op.f('ix_mantle_transactions_hash'), table_name='mantle_transactions')
    op.drop_index(op.f('ix_mantle_transactions_from_address'), table_name='mantle_transactions')
    op.drop_index(op.f('ix_mantle_transactions_block_number'), table_name='mantle_transactions')
    op.drop_index(op.f('ix_mantle_transactions_block_hash'), table_name='mantle_transactions')
    op.drop_table('mantle_transactions')
    op.drop_index(op.f('ix_mantle_sepolia_transactions_type'), table_name='mantle_sepolia_transactions')
    op.drop_index(op.f('ix_mantle_sepolia_transactions_to_address'), table_name='mantle_sepolia_transactions')
    op.drop_index(op.f('ix_mantle_sepolia_transactions_selector'), table_name='mantle_sepolia_transactions')
    op.drop_index(op.f('ix_mantle_sepolia_transactions_index'), table_name='mantle_sepolia_transactions')
    op.drop_index(op.f('ix_mantle_sepolia_transactions_hash'), table_name='mantle_sepolia_transactions')
    op.drop_index(op.f('ix_mantle_sepolia_transactions_from_address'), table_name='mantle_sepolia_transactions')
    op.drop_index(op.f('ix_mantle_sepolia_transactions_block_number'), table_name='mantle_sepolia_transactions')
    op.drop_index(op.f('ix_mantle_sepolia_transactions_block_hash'), table_name='mantle_sepolia_transactions')
    op.drop_table('mantle_sepolia_transactions')
    op.drop_index(op.f('ix_game7_orbit_arbitrum_sepolia_transactions_type'), table_name='game7_orbit_arbitrum_sepolia_transactions')
    op.drop_index(op.f('ix_game7_orbit_arbitrum_sepolia_transactions_to_address'), table_name='game7_orbit_arbitrum_sepolia_transactions')
    op.drop_index(op.f('ix_game7_orbit_arbitrum_sepolia_transactions_selector'), table_name='game7_orbit_arbitrum_sepolia_transactions')
    op.drop_index(op.f('ix_game7_orbit_arbitrum_sepolia_transactions_index'), table_name='game7_orbit_arbitrum_sepolia_transactions')
    op.drop_index(op.f('ix_game7_orbit_arbitrum_sepolia_transactions_hash'), table_name='game7_orbit_arbitrum_sepolia_transactions')
    op.drop_index(op.f('ix_game7_orbit_arbitrum_sepolia_transactions_from_address'), table_name='game7_orbit_arbitrum_sepolia_transactions')
    op.drop_index(op.f('ix_game7_orbit_arbitrum_sepolia_transactions_block_number'), table_name='game7_orbit_arbitrum_sepolia_transactions')
    op.drop_index(op.f('ix_game7_orbit_arbitrum_sepolia_transactions_block_hash'), table_name='game7_orbit_arbitrum_sepolia_transactions')
    op.drop_table('game7_orbit_arbitrum_sepolia_transactions')
    op.drop_index(op.f('ix_arbitrum_sepolia_transactions_type'), table_name='arbitrum_sepolia_transactions')
    op.drop_index(op.f('ix_arbitrum_sepolia_transactions_to_address'), table_name='arbitrum_sepolia_transactions')
    op.drop_index(op.f('ix_arbitrum_sepolia_transactions_selector'), table_name='arbitrum_sepolia_transactions')
    op.drop_index(op.f('ix_arbitrum_sepolia_transactions_index'), table_name='arbitrum_sepolia_transactions')
    op.drop_index(op.f('ix_arbitrum_sepolia_transactions_hash'), table_name='arbitrum_sepolia_transactions')
    op.drop_index(op.f('ix_arbitrum_sepolia_transactions_from_address'), table_name='arbitrum_sepolia_transactions')
    op.drop_index(op.f('ix_arbitrum_sepolia_transactions_block_number'), table_name='arbitrum_sepolia_transactions')
    op.drop_index(op.f('ix_arbitrum_sepolia_transactions_block_hash'), table_name='arbitrum_sepolia_transactions')
    op.drop_table('arbitrum_sepolia_transactions')
    op.drop_index(op.f('ix_arbitrum_one_transactions_type'), table_name='arbitrum_one_transactions')
    op.drop_index(op.f('ix_arbitrum_one_transactions_to_address'), table_name='arbitrum_one_transactions')
    op.drop_index(op.f('ix_arbitrum_one_transactions_selector'), table_name='arbitrum_one_transactions')
    op.drop_index(op.f('ix_arbitrum_one_transactions_index'), table_name='arbitrum_one_transactions')
    op.drop_index(op.f('ix_arbitrum_one_transactions_hash'), table_name='arbitrum_one_transactions')
    op.drop_index(op.f('ix_arbitrum_one_transactions_from_address'), table_name='arbitrum_one_transactions')
    op.drop_index(op.f('ix_arbitrum_one_transactions_block_number'), table_name='arbitrum_one_transactions')
    op.drop_index(op.f('ix_arbitrum_one_transactions_block_hash'), table_name='arbitrum_one_transactions')
    op.drop_table('arbitrum_one_transactions')
    op.drop_index(op.f('ix_xai_sepolia_reorgs_block_number'), table_name='xai_sepolia_reorgs')
    op.drop_index(op.f('ix_xai_sepolia_reorgs_block_hash'), table_name='xai_sepolia_reorgs')
    op.drop_table('xai_sepolia_reorgs')
    op.drop_index(op.f('ix_xai_sepolia_blocks_block_timestamp'), table_name='xai_sepolia_blocks')
    op.drop_index(op.f('ix_xai_sepolia_blocks_block_number'), table_name='xai_sepolia_blocks')
    op.drop_table('xai_sepolia_blocks')
    op.drop_index(op.f('ix_xai_reorgs_block_number'), table_name='xai_reorgs')
    op.drop_index(op.f('ix_xai_reorgs_block_hash'), table_name='xai_reorgs')
    op.drop_table('xai_reorgs')
    op.drop_index(op.f('ix_xai_blocks_block_timestamp'), table_name='xai_blocks')
    op.drop_index(op.f('ix_xai_blocks_block_number'), table_name='xai_blocks')
    op.drop_table('xai_blocks')
    op.drop_index(op.f('ix_mantle_sepolia_reorgs_block_number'), table_name='mantle_sepolia_reorgs')
    op.drop_index(op.f('ix_mantle_sepolia_reorgs_block_hash'), table_name='mantle_sepolia_reorgs')
    op.drop_table('mantle_sepolia_reorgs')
    op.drop_index(op.f('ix_mantle_sepolia_blocks_block_timestamp'), table_name='mantle_sepolia_blocks')
    op.drop_index(op.f('ix_mantle_sepolia_blocks_block_number'), table_name='mantle_sepolia_blocks')
    op.drop_table('mantle_sepolia_blocks')
    op.drop_index(op.f('ix_mantle_reorgs_block_number'), table_name='mantle_reorgs')
    op.drop_index(op.f('ix_mantle_reorgs_block_hash'), table_name='mantle_reorgs')
    op.drop_table('mantle_reorgs')
    op.drop_index(op.f('ix_mantle_blocks_block_timestamp'), table_name='mantle_blocks')
    op.drop_index(op.f('ix_mantle_blocks_block_number'), table_name='mantle_blocks')
    op.drop_table('mantle_blocks')
    op.drop_index(op.f('ix_game7_orbit_arbitrum_sepolia_reorgs_block_number'), table_name='game7_orbit_arbitrum_sepolia_reorgs')
    op.drop_index(op.f('ix_game7_orbit_arbitrum_sepolia_reorgs_block_hash'), table_name='game7_orbit_arbitrum_sepolia_reorgs')
    op.drop_table('game7_orbit_arbitrum_sepolia_reorgs')
    op.drop_index(op.f('ix_game7_orbit_arbitrum_sepolia_blocks_block_timestamp'), table_name='game7_orbit_arbitrum_sepolia_blocks')
    op.drop_index(op.f('ix_game7_orbit_arbitrum_sepolia_blocks_block_number'), table_name='game7_orbit_arbitrum_sepolia_blocks')
    op.drop_table('game7_orbit_arbitrum_sepolia_blocks')
    op.drop_index(op.f('ix_arbitrum_sepolia_reorgs_block_number'), table_name='arbitrum_sepolia_reorgs')
    op.drop_index(op.f('ix_arbitrum_sepolia_reorgs_block_hash'), table_name='arbitrum_sepolia_reorgs')
    op.drop_table('arbitrum_sepolia_reorgs')
    op.drop_index(op.f('ix_arbitrum_sepolia_blocks_block_timestamp'), table_name='arbitrum_sepolia_blocks')
    op.drop_index(op.f('ix_arbitrum_sepolia_blocks_block_number'), table_name='arbitrum_sepolia_blocks')
    op.drop_table('arbitrum_sepolia_blocks')
    op.drop_index(op.f('ix_arbitrum_one_reorgs_block_number'), table_name='arbitrum_one_reorgs')
    op.drop_index(op.f('ix_arbitrum_one_reorgs_block_hash'), table_name='arbitrum_one_reorgs')
    op.drop_table('arbitrum_one_reorgs')
    op.drop_index(op.f('ix_arbitrum_one_blocks_block_timestamp'), table_name='arbitrum_one_blocks')
    op.drop_index(op.f('ix_arbitrum_one_blocks_block_number'), table_name='arbitrum_one_blocks')
    op.drop_table('arbitrum_one_blocks')
    # ### end Alembic commands ###
