"""init v3 index

Revision ID: 0ea24314c181
Revises: 
Create Date: 2024-05-23 17:39:53.824404

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = '0ea24314c181'
down_revision: Union[str, None] = None
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('abi_jobs',
    sa.Column('id', sa.UUID(), nullable=False),
    sa.Column('address', sa.LargeBinary(), nullable=False),
    sa.Column('user_id', sa.UUID(), nullable=False),
    sa.Column('customer_id', sa.UUID(), nullable=True),
    sa.Column('abi_selector', sa.VARCHAR(length=256), nullable=False),
    sa.Column('chain', sa.VARCHAR(length=256), nullable=False),
    sa.Column('abi_name', sa.VARCHAR(length=256), nullable=False),
    sa.Column('status', sa.VARCHAR(length=256), nullable=False),
    sa.Column('historical_crawl_status', sa.VARCHAR(length=256), nullable=False),
    sa.Column('progress', sa.Integer(), nullable=False),
    sa.Column('moonworm_task_pickedup', sa.Boolean(), nullable=False),
    sa.Column('abi', sa.Text(), nullable=False),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text("TIMEZONE('utc', statement_timestamp())"), nullable=False),
    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text("TIMEZONE('utc', statement_timestamp())"), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_abi_jobs')),
    sa.UniqueConstraint('chain', 'address', 'abi_selector', 'customer_id', name='uq_abi_jobs')
    )
    op.create_index(op.f('ix_abi_jobs_abi_name'), 'abi_jobs', ['abi_name'], unique=False)
    op.create_index(op.f('ix_abi_jobs_abi_selector'), 'abi_jobs', ['abi_selector'], unique=False)
    op.create_index(op.f('ix_abi_jobs_address'), 'abi_jobs', ['address'], unique=False)
    op.create_index(op.f('ix_abi_jobs_chain'), 'abi_jobs', ['chain'], unique=False)
    op.create_index(op.f('ix_abi_jobs_customer_id'), 'abi_jobs', ['customer_id'], unique=False)
    op.create_index(op.f('ix_abi_jobs_historical_crawl_status'), 'abi_jobs', ['historical_crawl_status'], unique=False)
    op.create_index(op.f('ix_abi_jobs_status'), 'abi_jobs', ['status'], unique=False)
    op.create_index(op.f('ix_abi_jobs_user_id'), 'abi_jobs', ['user_id'], unique=False)
    op.create_table('ethereum_blocks',
    sa.Column('block_number', sa.BigInteger(), nullable=False),
    sa.Column('block_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('block_timestamp', sa.BigInteger(), nullable=False),
    sa.Column('parent_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('row_id', sa.BigInteger(), nullable=False),
    sa.Column('path', sa.Text(), nullable=False),
    sa.Column('indexed_at', sa.DateTime(timezone=True), server_default=sa.text("TIMEZONE('utc', statement_timestamp())"), nullable=False),
    sa.PrimaryKeyConstraint('block_number', name=op.f('pk_ethereum_blocks'))
    )
    op.create_index(op.f('ix_ethereum_blocks_block_number'), 'ethereum_blocks', ['block_number'], unique=False)
    op.create_index(op.f('ix_ethereum_blocks_block_timestamp'), 'ethereum_blocks', ['block_timestamp'], unique=False)
    op.create_table('ethereum_reorgs',
    sa.Column('id', sa.UUID(), nullable=False),
    sa.Column('block_number', sa.BigInteger(), nullable=False),
    sa.Column('block_hash', sa.VARCHAR(length=256), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_ethereum_reorgs'))
    )
    op.create_index(op.f('ix_ethereum_reorgs_block_hash'), 'ethereum_reorgs', ['block_hash'], unique=False)
    op.create_index(op.f('ix_ethereum_reorgs_block_number'), 'ethereum_reorgs', ['block_number'], unique=False)
    op.create_table('polygon_blocks',
    sa.Column('block_number', sa.BigInteger(), nullable=False),
    sa.Column('block_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('block_timestamp', sa.BigInteger(), nullable=False),
    sa.Column('parent_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('row_id', sa.BigInteger(), nullable=False),
    sa.Column('path', sa.Text(), nullable=False),
    sa.Column('indexed_at', sa.DateTime(timezone=True), server_default=sa.text("TIMEZONE('utc', statement_timestamp())"), nullable=False),
    sa.PrimaryKeyConstraint('block_number', name=op.f('pk_polygon_blocks'))
    )
    op.create_index(op.f('ix_polygon_blocks_block_number'), 'polygon_blocks', ['block_number'], unique=False)
    op.create_index(op.f('ix_polygon_blocks_block_timestamp'), 'polygon_blocks', ['block_timestamp'], unique=False)
    op.create_table('polygon_reorgs',
    sa.Column('id', sa.UUID(), nullable=False),
    sa.Column('block_number', sa.BigInteger(), nullable=False),
    sa.Column('block_hash', sa.VARCHAR(length=256), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_polygon_reorgs'))
    )
    op.create_index(op.f('ix_polygon_reorgs_block_hash'), 'polygon_reorgs', ['block_hash'], unique=False)
    op.create_index(op.f('ix_polygon_reorgs_block_number'), 'polygon_reorgs', ['block_number'], unique=False)
    op.create_table('ethereum_transactions',
    sa.Column('block_number', sa.BigInteger(), nullable=False),
    sa.Column('hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('from_address', sa.LargeBinary(length=20), nullable=False),
    sa.Column('to_address', sa.LargeBinary(length=20), nullable=False),
    sa.Column('selector', sa.VARCHAR(length=256), nullable=True),
    sa.Column('type', sa.Integer(), nullable=True),
    sa.Column('row_id', sa.BigInteger(), nullable=False),
    sa.Column('block_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('index', sa.BigInteger(), nullable=False),
    sa.Column('path', sa.Text(), nullable=False),
    sa.Column('indexed_at', sa.DateTime(timezone=True), server_default=sa.text("TIMEZONE('utc', statement_timestamp())"), nullable=False),
    sa.ForeignKeyConstraint(['block_number'], ['ethereum_blocks.block_number'], name=op.f('fk_ethereum_transactions_block_number_ethereum_blocks'), ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('hash', name=op.f('pk_ethereum_transactions'))
    )
    op.create_index(op.f('ix_ethereum_transactions_block_hash'), 'ethereum_transactions', ['block_hash'], unique=False)
    op.create_index(op.f('ix_ethereum_transactions_block_number'), 'ethereum_transactions', ['block_number'], unique=False)
    op.create_index(op.f('ix_ethereum_transactions_from_address'), 'ethereum_transactions', ['from_address'], unique=False)
    op.create_index(op.f('ix_ethereum_transactions_hash'), 'ethereum_transactions', ['hash'], unique=True)
    op.create_index(op.f('ix_ethereum_transactions_index'), 'ethereum_transactions', ['index'], unique=False)
    op.create_index(op.f('ix_ethereum_transactions_selector'), 'ethereum_transactions', ['selector'], unique=False)
    op.create_index(op.f('ix_ethereum_transactions_to_address'), 'ethereum_transactions', ['to_address'], unique=False)
    op.create_index(op.f('ix_ethereum_transactions_type'), 'ethereum_transactions', ['type'], unique=False)
    op.create_table('polygon_transactions',
    sa.Column('block_number', sa.BigInteger(), nullable=False),
    sa.Column('hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('from_address', sa.LargeBinary(length=20), nullable=False),
    sa.Column('to_address', sa.LargeBinary(length=20), nullable=False),
    sa.Column('selector', sa.VARCHAR(length=256), nullable=True),
    sa.Column('type', sa.Integer(), nullable=True),
    sa.Column('row_id', sa.BigInteger(), nullable=False),
    sa.Column('block_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('index', sa.BigInteger(), nullable=False),
    sa.Column('path', sa.Text(), nullable=False),
    sa.Column('indexed_at', sa.DateTime(timezone=True), server_default=sa.text("TIMEZONE('utc', statement_timestamp())"), nullable=False),
    sa.ForeignKeyConstraint(['block_number'], ['polygon_blocks.block_number'], name=op.f('fk_polygon_transactions_block_number_polygon_blocks'), ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('hash', name=op.f('pk_polygon_transactions'))
    )
    op.create_index(op.f('ix_polygon_transactions_block_hash'), 'polygon_transactions', ['block_hash'], unique=False)
    op.create_index(op.f('ix_polygon_transactions_block_number'), 'polygon_transactions', ['block_number'], unique=False)
    op.create_index(op.f('ix_polygon_transactions_from_address'), 'polygon_transactions', ['from_address'], unique=False)
    op.create_index(op.f('ix_polygon_transactions_hash'), 'polygon_transactions', ['hash'], unique=True)
    op.create_index(op.f('ix_polygon_transactions_index'), 'polygon_transactions', ['index'], unique=False)
    op.create_index(op.f('ix_polygon_transactions_selector'), 'polygon_transactions', ['selector'], unique=False)
    op.create_index(op.f('ix_polygon_transactions_to_address'), 'polygon_transactions', ['to_address'], unique=False)
    op.create_index(op.f('ix_polygon_transactions_type'), 'polygon_transactions', ['type'], unique=False)
    op.create_table('ethereum_logs',
    sa.Column('transaction_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('block_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('address', sa.LargeBinary(length=20), nullable=False),
    sa.Column('row_id', sa.BigInteger(), nullable=False),
    sa.Column('selector', sa.VARCHAR(length=256), nullable=True),
    sa.Column('topic1', sa.VARCHAR(length=256), nullable=True),
    sa.Column('topic2', sa.VARCHAR(length=256), nullable=True),
    sa.Column('log_index', sa.BigInteger(), nullable=False),
    sa.Column('path', sa.Text(), nullable=False),
    sa.Column('indexed_at', sa.DateTime(timezone=True), server_default=sa.text("TIMEZONE('utc', statement_timestamp())"), nullable=False),
    sa.ForeignKeyConstraint(['transaction_hash'], ['ethereum_transactions.hash'], name=op.f('fk_ethereum_logs_transaction_hash_ethereum_transactions'), ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('transaction_hash', 'log_index', name='pk_ethereum_log_index'),
    sa.UniqueConstraint('transaction_hash', 'log_index', name='uq_ethereum_log_index_transaction_hash_log_index')
    )
    op.create_index('idx_ethereum_logs_block_hash_log_index', 'ethereum_logs', ['block_hash', 'log_index'], unique=True)
    op.create_index(op.f('ix_ethereum_logs_address'), 'ethereum_logs', ['address'], unique=False)
    op.create_index(op.f('ix_ethereum_logs_block_hash'), 'ethereum_logs', ['block_hash'], unique=False)
    op.create_index(op.f('ix_ethereum_logs_transaction_hash'), 'ethereum_logs', ['transaction_hash'], unique=False)
    op.create_table('polygon_logs',
    sa.Column('transaction_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('block_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('address', sa.LargeBinary(length=20), nullable=False),
    sa.Column('row_id', sa.BigInteger(), nullable=False),
    sa.Column('selector', sa.VARCHAR(length=256), nullable=True),
    sa.Column('topic1', sa.VARCHAR(length=256), nullable=True),
    sa.Column('topic2', sa.VARCHAR(length=256), nullable=True),
    sa.Column('log_index', sa.BigInteger(), nullable=False),
    sa.Column('path', sa.Text(), nullable=False),
    sa.Column('indexed_at', sa.DateTime(timezone=True), server_default=sa.text("TIMEZONE('utc', statement_timestamp())"), nullable=False),
    sa.ForeignKeyConstraint(['transaction_hash'], ['polygon_transactions.hash'], name=op.f('fk_polygon_logs_transaction_hash_polygon_transactions'), ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('transaction_hash', 'log_index', name='pk_polygon_log_index'),
    sa.UniqueConstraint('transaction_hash', 'log_index', name='uq_polygon_log_index_transaction_hash_log_index')
    )
    op.create_index(op.f('ix_polygon_logs_address'), 'polygon_logs', ['address'], unique=False)
    op.create_index(op.f('ix_polygon_logs_block_hash'), 'polygon_logs', ['block_hash'], unique=False)
    op.create_index(op.f('ix_polygon_logs_transaction_hash'), 'polygon_logs', ['transaction_hash'], unique=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_polygon_logs_transaction_hash'), table_name='polygon_logs')
    op.drop_index(op.f('ix_polygon_logs_block_hash'), table_name='polygon_logs')
    op.drop_index(op.f('ix_polygon_logs_address'), table_name='polygon_logs')
    op.drop_table('polygon_logs')
    op.drop_index(op.f('ix_ethereum_logs_transaction_hash'), table_name='ethereum_logs')
    op.drop_index(op.f('ix_ethereum_logs_block_hash'), table_name='ethereum_logs')
    op.drop_index(op.f('ix_ethereum_logs_address'), table_name='ethereum_logs')
    op.drop_index('idx_ethereum_logs_block_hash_log_index', table_name='ethereum_logs')
    op.drop_table('ethereum_logs')
    op.drop_index(op.f('ix_polygon_transactions_type'), table_name='polygon_transactions')
    op.drop_index(op.f('ix_polygon_transactions_to_address'), table_name='polygon_transactions')
    op.drop_index(op.f('ix_polygon_transactions_selector'), table_name='polygon_transactions')
    op.drop_index(op.f('ix_polygon_transactions_index'), table_name='polygon_transactions')
    op.drop_index(op.f('ix_polygon_transactions_hash'), table_name='polygon_transactions')
    op.drop_index(op.f('ix_polygon_transactions_from_address'), table_name='polygon_transactions')
    op.drop_index(op.f('ix_polygon_transactions_block_number'), table_name='polygon_transactions')
    op.drop_index(op.f('ix_polygon_transactions_block_hash'), table_name='polygon_transactions')
    op.drop_table('polygon_transactions')
    op.drop_index(op.f('ix_ethereum_transactions_type'), table_name='ethereum_transactions')
    op.drop_index(op.f('ix_ethereum_transactions_to_address'), table_name='ethereum_transactions')
    op.drop_index(op.f('ix_ethereum_transactions_selector'), table_name='ethereum_transactions')
    op.drop_index(op.f('ix_ethereum_transactions_index'), table_name='ethereum_transactions')
    op.drop_index(op.f('ix_ethereum_transactions_hash'), table_name='ethereum_transactions')
    op.drop_index(op.f('ix_ethereum_transactions_from_address'), table_name='ethereum_transactions')
    op.drop_index(op.f('ix_ethereum_transactions_block_number'), table_name='ethereum_transactions')
    op.drop_index(op.f('ix_ethereum_transactions_block_hash'), table_name='ethereum_transactions')
    op.drop_table('ethereum_transactions')
    op.drop_index(op.f('ix_polygon_reorgs_block_number'), table_name='polygon_reorgs')
    op.drop_index(op.f('ix_polygon_reorgs_block_hash'), table_name='polygon_reorgs')
    op.drop_table('polygon_reorgs')
    op.drop_index(op.f('ix_polygon_blocks_block_timestamp'), table_name='polygon_blocks')
    op.drop_index(op.f('ix_polygon_blocks_block_number'), table_name='polygon_blocks')
    op.drop_table('polygon_blocks')
    op.drop_index(op.f('ix_ethereum_reorgs_block_number'), table_name='ethereum_reorgs')
    op.drop_index(op.f('ix_ethereum_reorgs_block_hash'), table_name='ethereum_reorgs')
    op.drop_table('ethereum_reorgs')
    op.drop_index(op.f('ix_ethereum_blocks_block_timestamp'), table_name='ethereum_blocks')
    op.drop_index(op.f('ix_ethereum_blocks_block_number'), table_name='ethereum_blocks')
    op.drop_table('ethereum_blocks')
    op.drop_index(op.f('ix_abi_jobs_user_id'), table_name='abi_jobs')
    op.drop_index(op.f('ix_abi_jobs_status'), table_name='abi_jobs')
    op.drop_index(op.f('ix_abi_jobs_historical_crawl_status'), table_name='abi_jobs')
    op.drop_index(op.f('ix_abi_jobs_customer_id'), table_name='abi_jobs')
    op.drop_index(op.f('ix_abi_jobs_chain'), table_name='abi_jobs')
    op.drop_index(op.f('ix_abi_jobs_address'), table_name='abi_jobs')
    op.drop_index(op.f('ix_abi_jobs_abi_selector'), table_name='abi_jobs')
    op.drop_index(op.f('ix_abi_jobs_abi_name'), table_name='abi_jobs')
    op.drop_table('abi_jobs')
    # ### end Alembic commands ###
