"""Amoy, Blast and Apex blockchains

Revision ID: e9e1b43f49e1
Revises: 994e614b5500
Create Date: 2024-04-22 09:35:56.509834

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision: str = 'e9e1b43f49e1'
down_revision: Union[str, None] = '994e614b5500'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('amoy_labels',
    sa.Column('id', sa.UUID(), nullable=False),
    sa.Column('label', sa.VARCHAR(length=256), nullable=False),
    sa.Column('transaction_hash', sa.VARCHAR(length=128), nullable=False),
    sa.Column('log_index', sa.Integer(), nullable=True),
    sa.Column('block_number', sa.BigInteger(), nullable=False),
    sa.Column('block_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('block_timestamp', sa.BigInteger(), nullable=False),
    sa.Column('caller_address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('origin_address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('label_name', sa.Text(), nullable=True),
    sa.Column('label_type', sa.VARCHAR(length=64), nullable=True),
    sa.Column('label_data', postgresql.JSONB(astext_type=sa.Text()), nullable=True),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text("TIMEZONE('utc', statement_timestamp())"), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_amoy_labels')),
    sa.UniqueConstraint('id', name=op.f('uq_amoy_labels_id'))
    )
    op.create_index('ix_amoy_labels_addr_block_num', 'amoy_labels', ['address', 'block_number'], unique=False)
    op.create_index('ix_amoy_labels_addr_block_ts', 'amoy_labels', ['address', 'block_timestamp'], unique=False)
    op.create_index(op.f('ix_amoy_labels_address'), 'amoy_labels', ['address'], unique=False)
    op.create_index(op.f('ix_amoy_labels_block_number'), 'amoy_labels', ['block_number'], unique=False)
    op.create_index(op.f('ix_amoy_labels_caller_address'), 'amoy_labels', ['caller_address'], unique=False)
    op.create_index(op.f('ix_amoy_labels_label'), 'amoy_labels', ['label'], unique=False)
    op.create_index(op.f('ix_amoy_labels_label_name'), 'amoy_labels', ['label_name'], unique=False)
    op.create_index(op.f('ix_amoy_labels_label_type'), 'amoy_labels', ['label_type'], unique=False)
    op.create_index(op.f('ix_amoy_labels_origin_address'), 'amoy_labels', ['origin_address'], unique=False)
    op.create_index(op.f('ix_amoy_labels_transaction_hash'), 'amoy_labels', ['transaction_hash'], unique=False)
    op.create_table('blast_labels',
    sa.Column('id', sa.UUID(), nullable=False),
    sa.Column('label', sa.VARCHAR(length=256), nullable=False),
    sa.Column('transaction_hash', sa.VARCHAR(length=128), nullable=False),
    sa.Column('log_index', sa.Integer(), nullable=True),
    sa.Column('block_number', sa.BigInteger(), nullable=False),
    sa.Column('block_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('block_timestamp', sa.BigInteger(), nullable=False),
    sa.Column('caller_address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('origin_address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('label_name', sa.Text(), nullable=True),
    sa.Column('label_type', sa.VARCHAR(length=64), nullable=True),
    sa.Column('label_data', postgresql.JSONB(astext_type=sa.Text()), nullable=True),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text("TIMEZONE('utc', statement_timestamp())"), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_blast_labels')),
    sa.UniqueConstraint('id', name=op.f('uq_blast_labels_id'))
    )
    op.create_index('ix_blast_labels_addr_block_num', 'blast_labels', ['address', 'block_number'], unique=False)
    op.create_index('ix_blast_labels_addr_block_ts', 'blast_labels', ['address', 'block_timestamp'], unique=False)
    op.create_index(op.f('ix_blast_labels_address'), 'blast_labels', ['address'], unique=False)
    op.create_index(op.f('ix_blast_labels_block_number'), 'blast_labels', ['block_number'], unique=False)
    op.create_index(op.f('ix_blast_labels_caller_address'), 'blast_labels', ['caller_address'], unique=False)
    op.create_index(op.f('ix_blast_labels_label'), 'blast_labels', ['label'], unique=False)
    op.create_index(op.f('ix_blast_labels_label_name'), 'blast_labels', ['label_name'], unique=False)
    op.create_index(op.f('ix_blast_labels_label_type'), 'blast_labels', ['label_type'], unique=False)
    op.create_index(op.f('ix_blast_labels_origin_address'), 'blast_labels', ['origin_address'], unique=False)
    op.create_index(op.f('ix_blast_labels_transaction_hash'), 'blast_labels', ['transaction_hash'], unique=False)
    op.create_table('blast_sepolia_labels',
    sa.Column('id', sa.UUID(), nullable=False),
    sa.Column('label', sa.VARCHAR(length=256), nullable=False),
    sa.Column('transaction_hash', sa.VARCHAR(length=128), nullable=False),
    sa.Column('log_index', sa.Integer(), nullable=True),
    sa.Column('block_number', sa.BigInteger(), nullable=False),
    sa.Column('block_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('block_timestamp', sa.BigInteger(), nullable=False),
    sa.Column('caller_address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('origin_address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('label_name', sa.Text(), nullable=True),
    sa.Column('label_type', sa.VARCHAR(length=64), nullable=True),
    sa.Column('label_data', postgresql.JSONB(astext_type=sa.Text()), nullable=True),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text("TIMEZONE('utc', statement_timestamp())"), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_blast_sepolia_labels')),
    sa.UniqueConstraint('id', name=op.f('uq_blast_sepolia_labels_id'))
    )
    op.create_index('ix_blast_sepolia_labels_addr_block_num', 'blast_sepolia_labels', ['address', 'block_number'], unique=False)
    op.create_index('ix_blast_sepolia_labels_addr_block_ts', 'blast_sepolia_labels', ['address', 'block_timestamp'], unique=False)
    op.create_index(op.f('ix_blast_sepolia_labels_address'), 'blast_sepolia_labels', ['address'], unique=False)
    op.create_index(op.f('ix_blast_sepolia_labels_block_number'), 'blast_sepolia_labels', ['block_number'], unique=False)
    op.create_index(op.f('ix_blast_sepolia_labels_caller_address'), 'blast_sepolia_labels', ['caller_address'], unique=False)
    op.create_index(op.f('ix_blast_sepolia_labels_label'), 'blast_sepolia_labels', ['label'], unique=False)
    op.create_index(op.f('ix_blast_sepolia_labels_label_name'), 'blast_sepolia_labels', ['label_name'], unique=False)
    op.create_index(op.f('ix_blast_sepolia_labels_label_type'), 'blast_sepolia_labels', ['label_type'], unique=False)
    op.create_index(op.f('ix_blast_sepolia_labels_origin_address'), 'blast_sepolia_labels', ['origin_address'], unique=False)
    op.create_index(op.f('ix_blast_sepolia_labels_transaction_hash'), 'blast_sepolia_labels', ['transaction_hash'], unique=False)
    op.create_table('proofofplay_apex_labels',
    sa.Column('id', sa.UUID(), nullable=False),
    sa.Column('label', sa.VARCHAR(length=256), nullable=False),
    sa.Column('transaction_hash', sa.VARCHAR(length=128), nullable=False),
    sa.Column('log_index', sa.Integer(), nullable=True),
    sa.Column('block_number', sa.BigInteger(), nullable=False),
    sa.Column('block_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('block_timestamp', sa.BigInteger(), nullable=False),
    sa.Column('caller_address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('origin_address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('label_name', sa.Text(), nullable=True),
    sa.Column('label_type', sa.VARCHAR(length=64), nullable=True),
    sa.Column('label_data', postgresql.JSONB(astext_type=sa.Text()), nullable=True),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text("TIMEZONE('utc', statement_timestamp())"), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_proofofplay_apex_labels')),
    sa.UniqueConstraint('id', name=op.f('uq_proofofplay_apex_labels_id'))
    )
    op.create_index('ix_proofofplay_apex_labels_addr_block_num', 'proofofplay_apex_labels', ['address', 'block_number'], unique=False)
    op.create_index('ix_proofofplay_apex_labels_addr_block_ts', 'proofofplay_apex_labels', ['address', 'block_timestamp'], unique=False)
    op.create_index(op.f('ix_proofofplay_apex_labels_address'), 'proofofplay_apex_labels', ['address'], unique=False)
    op.create_index(op.f('ix_proofofplay_apex_labels_block_number'), 'proofofplay_apex_labels', ['block_number'], unique=False)
    op.create_index(op.f('ix_proofofplay_apex_labels_caller_address'), 'proofofplay_apex_labels', ['caller_address'], unique=False)
    op.create_index(op.f('ix_proofofplay_apex_labels_label'), 'proofofplay_apex_labels', ['label'], unique=False)
    op.create_index(op.f('ix_proofofplay_apex_labels_label_name'), 'proofofplay_apex_labels', ['label_name'], unique=False)
    op.create_index(op.f('ix_proofofplay_apex_labels_label_type'), 'proofofplay_apex_labels', ['label_type'], unique=False)
    op.create_index(op.f('ix_proofofplay_apex_labels_origin_address'), 'proofofplay_apex_labels', ['origin_address'], unique=False)
    op.create_index(op.f('ix_proofofplay_apex_labels_transaction_hash'), 'proofofplay_apex_labels', ['transaction_hash'], unique=False)
    op.create_index('ix_arbitrum_nova_labels_addr_block_ts', 'arbitrum_nova_labels', ['address', 'block_timestamp'], unique=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###    
    op.drop_index(op.f('ix_proofofplay_apex_labels_transaction_hash'), table_name='proofofplay_apex_labels')
    op.drop_index(op.f('ix_proofofplay_apex_labels_origin_address'), table_name='proofofplay_apex_labels')
    op.drop_index(op.f('ix_proofofplay_apex_labels_label_type'), table_name='proofofplay_apex_labels')
    op.drop_index(op.f('ix_proofofplay_apex_labels_label_name'), table_name='proofofplay_apex_labels')
    op.drop_index(op.f('ix_proofofplay_apex_labels_label'), table_name='proofofplay_apex_labels')
    op.drop_index(op.f('ix_proofofplay_apex_labels_caller_address'), table_name='proofofplay_apex_labels')
    op.drop_index(op.f('ix_proofofplay_apex_labels_block_number'), table_name='proofofplay_apex_labels')
    op.drop_index(op.f('ix_proofofplay_apex_labels_address'), table_name='proofofplay_apex_labels')
    op.drop_index('ix_proofofplay_apex_labels_addr_block_ts', table_name='proofofplay_apex_labels')
    op.drop_index('ix_proofofplay_apex_labels_addr_block_num', table_name='proofofplay_apex_labels')
    op.drop_table('proofofplay_apex_labels')
    op.drop_index(op.f('ix_blast_sepolia_labels_transaction_hash'), table_name='blast_sepolia_labels')
    op.drop_index(op.f('ix_blast_sepolia_labels_origin_address'), table_name='blast_sepolia_labels')
    op.drop_index(op.f('ix_blast_sepolia_labels_label_type'), table_name='blast_sepolia_labels')
    op.drop_index(op.f('ix_blast_sepolia_labels_label_name'), table_name='blast_sepolia_labels')
    op.drop_index(op.f('ix_blast_sepolia_labels_label'), table_name='blast_sepolia_labels')
    op.drop_index(op.f('ix_blast_sepolia_labels_caller_address'), table_name='blast_sepolia_labels')
    op.drop_index(op.f('ix_blast_sepolia_labels_block_number'), table_name='blast_sepolia_labels')
    op.drop_index(op.f('ix_blast_sepolia_labels_address'), table_name='blast_sepolia_labels')
    op.drop_index('ix_blast_sepolia_labels_addr_block_ts', table_name='blast_sepolia_labels')
    op.drop_index('ix_blast_sepolia_labels_addr_block_num', table_name='blast_sepolia_labels')
    op.drop_table('blast_sepolia_labels')
    op.drop_index(op.f('ix_blast_labels_transaction_hash'), table_name='blast_labels')
    op.drop_index(op.f('ix_blast_labels_origin_address'), table_name='blast_labels')
    op.drop_index(op.f('ix_blast_labels_label_type'), table_name='blast_labels')
    op.drop_index(op.f('ix_blast_labels_label_name'), table_name='blast_labels')
    op.drop_index(op.f('ix_blast_labels_label'), table_name='blast_labels')
    op.drop_index(op.f('ix_blast_labels_caller_address'), table_name='blast_labels')
    op.drop_index(op.f('ix_blast_labels_block_number'), table_name='blast_labels')
    op.drop_index(op.f('ix_blast_labels_address'), table_name='blast_labels')
    op.drop_index('ix_blast_labels_addr_block_ts', table_name='blast_labels')
    op.drop_index('ix_blast_labels_addr_block_num', table_name='blast_labels')
    op.drop_table('blast_labels')
    op.drop_index(op.f('ix_amoy_labels_transaction_hash'), table_name='amoy_labels')
    op.drop_index(op.f('ix_amoy_labels_origin_address'), table_name='amoy_labels')
    op.drop_index(op.f('ix_amoy_labels_label_type'), table_name='amoy_labels')
    op.drop_index(op.f('ix_amoy_labels_label_name'), table_name='amoy_labels')
    op.drop_index(op.f('ix_amoy_labels_label'), table_name='amoy_labels')
    op.drop_index(op.f('ix_amoy_labels_caller_address'), table_name='amoy_labels')
    op.drop_index(op.f('ix_amoy_labels_block_number'), table_name='amoy_labels')
    op.drop_index(op.f('ix_amoy_labels_address'), table_name='amoy_labels')
    op.drop_index('ix_amoy_labels_addr_block_ts', table_name='amoy_labels')
    op.drop_index('ix_amoy_labels_addr_block_num', table_name='amoy_labels')
    op.drop_table('amoy_labels')
    # ### end Alembic commands ###
