"""Tables initial generation

Revision ID: 994e614b5500
Revises: 
Create Date: 2024-03-14 07:03:35.586195

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision: str = '994e614b5500'
down_revision: Union[str, None] = None
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('arbitrum_nova_labels',
    sa.Column('id', sa.UUID(), nullable=False),
    sa.Column('label', sa.VARCHAR(length=256), nullable=False),
    sa.Column('transaction_hash', sa.VARCHAR(length=128), nullable=False),
    sa.Column('log_index', sa.Integer(), nullable=True),
    sa.Column('block_number', sa.BigInteger(), nullable=False),
    sa.Column('block_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('block_timestamp', sa.BigInteger(), nullable=False),
    sa.Column('caller_address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('origin_address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('label_name', sa.Text(), nullable=True),
    sa.Column('label_type', sa.VARCHAR(length=64), nullable=True),
    sa.Column('label_data', postgresql.JSONB(astext_type=sa.Text()), nullable=True),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text("TIMEZONE('utc', statement_timestamp())"), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_arbitrum_nova_labels')),
    sa.UniqueConstraint('id', name=op.f('uq_arbitrum_nova_labels_id')),
    )
    op.create_index('ix_arbitrum_nova_labels_addr_block_num', 'arbitrum_nova_labels', ['address', 'block_number'], unique=False)
    op.create_index(op.f('ix_arbitrum_nova_labels_address'), 'arbitrum_nova_labels', ['address'], unique=False)
    op.create_index(op.f('ix_arbitrum_nova_labels_block_number'), 'arbitrum_nova_labels', ['block_number'], unique=False)
    op.create_index(op.f('ix_arbitrum_nova_labels_caller_address'), 'arbitrum_nova_labels', ['caller_address'], unique=False)
    op.create_index(op.f('ix_arbitrum_nova_labels_label'), 'arbitrum_nova_labels', ['label'], unique=False)
    op.create_index(op.f('ix_arbitrum_nova_labels_label_name'), 'arbitrum_nova_labels', ['label_name'], unique=False)
    op.create_index(op.f('ix_arbitrum_nova_labels_label_type'), 'arbitrum_nova_labels', ['label_type'], unique=False)
    op.create_index(op.f('ix_arbitrum_nova_labels_origin_address'), 'arbitrum_nova_labels', ['origin_address'], unique=False)
    op.create_index(op.f('ix_arbitrum_nova_labels_transaction_hash'), 'arbitrum_nova_labels', ['transaction_hash'], unique=False)
    op.create_table('arbitrum_sepolia_labels',
    sa.Column('id', sa.UUID(), nullable=False),
    sa.Column('label', sa.VARCHAR(length=256), nullable=False),
    sa.Column('transaction_hash', sa.VARCHAR(length=128), nullable=False),
    sa.Column('log_index', sa.Integer(), nullable=True),
    sa.Column('block_number', sa.BigInteger(), nullable=False),
    sa.Column('block_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('block_timestamp', sa.BigInteger(), nullable=False),
    sa.Column('caller_address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('origin_address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('label_name', sa.Text(), nullable=True),
    sa.Column('label_type', sa.VARCHAR(length=64), nullable=True),
    sa.Column('label_data', postgresql.JSONB(astext_type=sa.Text()), nullable=True),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text("TIMEZONE('utc', statement_timestamp())"), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_arbitrum_sepolia_labels')),
    sa.UniqueConstraint('id', name=op.f('uq_arbitrum_sepolia_labels_id'))
    )
    op.create_index('ix_arbitrum_sepolia_labels_addr_block_num', 'arbitrum_sepolia_labels', ['address', 'block_number'], unique=False)
    op.create_index(op.f('ix_arbitrum_sepolia_labels_address'), 'arbitrum_sepolia_labels', ['address'], unique=False)
    op.create_index(op.f('ix_arbitrum_sepolia_labels_block_number'), 'arbitrum_sepolia_labels', ['block_number'], unique=False)
    op.create_index(op.f('ix_arbitrum_sepolia_labels_caller_address'), 'arbitrum_sepolia_labels', ['caller_address'], unique=False)
    op.create_index(op.f('ix_arbitrum_sepolia_labels_label'), 'arbitrum_sepolia_labels', ['label'], unique=False)
    op.create_index(op.f('ix_arbitrum_sepolia_labels_label_name'), 'arbitrum_sepolia_labels', ['label_name'], unique=False)
    op.create_index(op.f('ix_arbitrum_sepolia_labels_label_type'), 'arbitrum_sepolia_labels', ['label_type'], unique=False)
    op.create_index(op.f('ix_arbitrum_sepolia_labels_origin_address'), 'arbitrum_sepolia_labels', ['origin_address'], unique=False)
    op.create_index(op.f('ix_arbitrum_sepolia_labels_transaction_hash'), 'arbitrum_sepolia_labels', ['transaction_hash'], unique=False)
    op.create_table('base_labels',
    sa.Column('id', sa.UUID(), nullable=False),
    sa.Column('label', sa.VARCHAR(length=256), nullable=False),
    sa.Column('transaction_hash', sa.VARCHAR(length=128), nullable=False),
    sa.Column('log_index', sa.Integer(), nullable=True),
    sa.Column('block_number', sa.BigInteger(), nullable=False),
    sa.Column('block_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('block_timestamp', sa.BigInteger(), nullable=False),
    sa.Column('caller_address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('origin_address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('label_name', sa.Text(), nullable=True),
    sa.Column('label_type', sa.VARCHAR(length=64), nullable=True),
    sa.Column('label_data', postgresql.JSONB(astext_type=sa.Text()), nullable=True),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text("TIMEZONE('utc', statement_timestamp())"), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_base_labels')),
    sa.UniqueConstraint('id', name=op.f('uq_base_labels_id'))
    )
    op.create_index('ix_base_labels_addr_block_num', 'base_labels', ['address', 'block_number'], unique=False)
    op.create_index(op.f('ix_base_labels_address'), 'base_labels', ['address'], unique=False)
    op.create_index(op.f('ix_base_labels_block_number'), 'base_labels', ['block_number'], unique=False)
    op.create_index(op.f('ix_base_labels_caller_address'), 'base_labels', ['caller_address'], unique=False)
    op.create_index(op.f('ix_base_labels_label'), 'base_labels', ['label'], unique=False)
    op.create_index(op.f('ix_base_labels_label_name'), 'base_labels', ['label_name'], unique=False)
    op.create_index(op.f('ix_base_labels_label_type'), 'base_labels', ['label_type'], unique=False)
    op.create_index(op.f('ix_base_labels_origin_address'), 'base_labels', ['origin_address'], unique=False)
    op.create_index(op.f('ix_base_labels_transaction_hash'), 'base_labels', ['transaction_hash'], unique=False)
    op.create_table('ethereum_labels',
    sa.Column('id', sa.UUID(), nullable=False),
    sa.Column('label', sa.VARCHAR(length=256), nullable=False),
    sa.Column('transaction_hash', sa.VARCHAR(length=128), nullable=False),
    sa.Column('log_index', sa.Integer(), nullable=True),
    sa.Column('block_number', sa.BigInteger(), nullable=False),
    sa.Column('block_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('block_timestamp', sa.BigInteger(), nullable=False),
    sa.Column('caller_address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('origin_address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('label_name', sa.Text(), nullable=True),
    sa.Column('label_type', sa.VARCHAR(length=64), nullable=True),
    sa.Column('label_data', postgresql.JSONB(astext_type=sa.Text()), nullable=True),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text("TIMEZONE('utc', statement_timestamp())"), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_ethereum_labels')),
    sa.UniqueConstraint('id', name=op.f('uq_ethereum_labels_id'))
    )
    op.create_index('ix_ethereum_labels_addr_block_num', 'ethereum_labels', ['address', 'block_number'], unique=False)
    op.create_index(op.f('ix_ethereum_labels_address'), 'ethereum_labels', ['address'], unique=False)
    op.create_index(op.f('ix_ethereum_labels_block_number'), 'ethereum_labels', ['block_number'], unique=False)
    op.create_index(op.f('ix_ethereum_labels_caller_address'), 'ethereum_labels', ['caller_address'], unique=False)
    op.create_index(op.f('ix_ethereum_labels_label'), 'ethereum_labels', ['label'], unique=False)
    op.create_index(op.f('ix_ethereum_labels_label_name'), 'ethereum_labels', ['label_name'], unique=False)
    op.create_index(op.f('ix_ethereum_labels_label_type'), 'ethereum_labels', ['label_type'], unique=False)
    op.create_index(op.f('ix_ethereum_labels_origin_address'), 'ethereum_labels', ['origin_address'], unique=False)
    op.create_index(op.f('ix_ethereum_labels_transaction_hash'), 'ethereum_labels', ['transaction_hash'], unique=False)
    op.create_table('mumbai_labels',
    sa.Column('id', sa.UUID(), nullable=False),
    sa.Column('label', sa.VARCHAR(length=256), nullable=False),
    sa.Column('transaction_hash', sa.VARCHAR(length=128), nullable=False),
    sa.Column('log_index', sa.Integer(), nullable=True),
    sa.Column('block_number', sa.BigInteger(), nullable=False),
    sa.Column('block_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('block_timestamp', sa.BigInteger(), nullable=False),
    sa.Column('caller_address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('origin_address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('label_name', sa.Text(), nullable=True),
    sa.Column('label_type', sa.VARCHAR(length=64), nullable=True),
    sa.Column('label_data', postgresql.JSONB(astext_type=sa.Text()), nullable=True),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text("TIMEZONE('utc', statement_timestamp())"), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_mumbai_labels')),
    sa.UniqueConstraint('id', name=op.f('uq_mumbai_labels_id'))
    )
    op.create_index('ix_mumbai_labels_addr_block_num', 'mumbai_labels', ['address', 'block_number'], unique=False)
    op.create_index(op.f('ix_mumbai_labels_address'), 'mumbai_labels', ['address'], unique=False)
    op.create_index(op.f('ix_mumbai_labels_block_number'), 'mumbai_labels', ['block_number'], unique=False)
    op.create_index(op.f('ix_mumbai_labels_caller_address'), 'mumbai_labels', ['caller_address'], unique=False)
    op.create_index(op.f('ix_mumbai_labels_label'), 'mumbai_labels', ['label'], unique=False)
    op.create_index(op.f('ix_mumbai_labels_label_name'), 'mumbai_labels', ['label_name'], unique=False)
    op.create_index(op.f('ix_mumbai_labels_label_type'), 'mumbai_labels', ['label_type'], unique=False)
    op.create_index(op.f('ix_mumbai_labels_origin_address'), 'mumbai_labels', ['origin_address'], unique=False)
    op.create_index(op.f('ix_mumbai_labels_transaction_hash'), 'mumbai_labels', ['transaction_hash'], unique=False)
    op.create_table('polygon_labels',
    sa.Column('id', sa.UUID(), nullable=False),
    sa.Column('label', sa.VARCHAR(length=256), nullable=False),
    sa.Column('transaction_hash', sa.VARCHAR(length=128), nullable=False),
    sa.Column('log_index', sa.Integer(), nullable=True),
    sa.Column('block_number', sa.BigInteger(), nullable=False),
    sa.Column('block_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('block_timestamp', sa.BigInteger(), nullable=False),
    sa.Column('caller_address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('origin_address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('label_name', sa.Text(), nullable=True),
    sa.Column('label_type', sa.VARCHAR(length=64), nullable=True),
    sa.Column('label_data', postgresql.JSONB(astext_type=sa.Text()), nullable=True),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text("TIMEZONE('utc', statement_timestamp())"), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_polygon_labels')),
    sa.UniqueConstraint('id', name=op.f('uq_polygon_labels_id'))
    )
    op.create_index('ix_polygon_labels_addr_block_num', 'polygon_labels', ['address', 'block_number'], unique=False)
    op.create_index(op.f('ix_polygon_labels_address'), 'polygon_labels', ['address'], unique=False)
    op.create_index(op.f('ix_polygon_labels_block_number'), 'polygon_labels', ['block_number'], unique=False)
    op.create_index(op.f('ix_polygon_labels_caller_address'), 'polygon_labels', ['caller_address'], unique=False)
    op.create_index(op.f('ix_polygon_labels_label'), 'polygon_labels', ['label'], unique=False)
    op.create_index(op.f('ix_polygon_labels_label_name'), 'polygon_labels', ['label_name'], unique=False)
    op.create_index(op.f('ix_polygon_labels_label_type'), 'polygon_labels', ['label_type'], unique=False)
    op.create_index(op.f('ix_polygon_labels_origin_address'), 'polygon_labels', ['origin_address'], unique=False)
    op.create_index(op.f('ix_polygon_labels_transaction_hash'), 'polygon_labels', ['transaction_hash'], unique=False)
    op.create_table('sepolia_labels',
    sa.Column('id', sa.UUID(), nullable=False),
    sa.Column('label', sa.VARCHAR(length=256), nullable=False),
    sa.Column('transaction_hash', sa.VARCHAR(length=128), nullable=False),
    sa.Column('log_index', sa.Integer(), nullable=True),
    sa.Column('block_number', sa.BigInteger(), nullable=False),
    sa.Column('block_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('block_timestamp', sa.BigInteger(), nullable=False),
    sa.Column('caller_address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('origin_address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('label_name', sa.Text(), nullable=True),
    sa.Column('label_type', sa.VARCHAR(length=64), nullable=True),
    sa.Column('label_data', postgresql.JSONB(astext_type=sa.Text()), nullable=True),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text("TIMEZONE('utc', statement_timestamp())"), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_sepolia_labels')),
    sa.UniqueConstraint('id', name=op.f('uq_sepolia_labels_id'))
    )
    op.create_index('ix_sepolia_labels_addr_block_num', 'sepolia_labels', ['address', 'block_number'], unique=False)
    op.create_index(op.f('ix_sepolia_labels_address'), 'sepolia_labels', ['address'], unique=False)
    op.create_index(op.f('ix_sepolia_labels_block_number'), 'sepolia_labels', ['block_number'], unique=False)
    op.create_index(op.f('ix_sepolia_labels_caller_address'), 'sepolia_labels', ['caller_address'], unique=False)
    op.create_index(op.f('ix_sepolia_labels_label'), 'sepolia_labels', ['label'], unique=False)
    op.create_index(op.f('ix_sepolia_labels_label_name'), 'sepolia_labels', ['label_name'], unique=False)
    op.create_index(op.f('ix_sepolia_labels_label_type'), 'sepolia_labels', ['label_type'], unique=False)
    op.create_index(op.f('ix_sepolia_labels_origin_address'), 'sepolia_labels', ['origin_address'], unique=False)
    op.create_index(op.f('ix_sepolia_labels_transaction_hash'), 'sepolia_labels', ['transaction_hash'], unique=False)
    op.create_table('xai_labels',
    sa.Column('id', sa.UUID(), nullable=False),
    sa.Column('label', sa.VARCHAR(length=256), nullable=False),
    sa.Column('transaction_hash', sa.VARCHAR(length=128), nullable=False),
    sa.Column('log_index', sa.Integer(), nullable=True),
    sa.Column('block_number', sa.BigInteger(), nullable=False),
    sa.Column('block_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('block_timestamp', sa.BigInteger(), nullable=False),
    sa.Column('caller_address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('origin_address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('label_name', sa.Text(), nullable=True),
    sa.Column('label_type', sa.VARCHAR(length=64), nullable=True),
    sa.Column('label_data', postgresql.JSONB(astext_type=sa.Text()), nullable=True),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text("TIMEZONE('utc', statement_timestamp())"), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_xai_labels')),
    sa.UniqueConstraint('id', name=op.f('uq_xai_labels_id'))
    )
    op.create_index('ix_xai_labels_addr_block_num', 'xai_labels', ['address', 'block_number'], unique=False)
    op.create_index(op.f('ix_xai_labels_address'), 'xai_labels', ['address'], unique=False)
    op.create_index(op.f('ix_xai_labels_block_number'), 'xai_labels', ['block_number'], unique=False)
    op.create_index(op.f('ix_xai_labels_caller_address'), 'xai_labels', ['caller_address'], unique=False)
    op.create_index(op.f('ix_xai_labels_label'), 'xai_labels', ['label'], unique=False)
    op.create_index(op.f('ix_xai_labels_label_name'), 'xai_labels', ['label_name'], unique=False)
    op.create_index(op.f('ix_xai_labels_label_type'), 'xai_labels', ['label_type'], unique=False)
    op.create_index(op.f('ix_xai_labels_origin_address'), 'xai_labels', ['origin_address'], unique=False)
    op.create_index(op.f('ix_xai_labels_transaction_hash'), 'xai_labels', ['transaction_hash'], unique=False)
    op.create_table('xai_sepolia_labels',
    sa.Column('id', sa.UUID(), nullable=False),
    sa.Column('label', sa.VARCHAR(length=256), nullable=False),
    sa.Column('transaction_hash', sa.VARCHAR(length=128), nullable=False),
    sa.Column('log_index', sa.Integer(), nullable=True),
    sa.Column('block_number', sa.BigInteger(), nullable=False),
    sa.Column('block_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('block_timestamp', sa.BigInteger(), nullable=False),
    sa.Column('caller_address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('origin_address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('label_name', sa.Text(), nullable=True),
    sa.Column('label_type', sa.VARCHAR(length=64), nullable=True),
    sa.Column('label_data', postgresql.JSONB(astext_type=sa.Text()), nullable=True),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text("TIMEZONE('utc', statement_timestamp())"), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_xai_sepolia_labels')),
    sa.UniqueConstraint('id', name=op.f('uq_xai_sepolia_labels_id'))
    )
    op.create_index('ix_xai_sepolia_labels_addr_block_num', 'xai_sepolia_labels', ['address', 'block_number'], unique=False)
    op.create_index(op.f('ix_xai_sepolia_labels_address'), 'xai_sepolia_labels', ['address'], unique=False)
    op.create_index(op.f('ix_xai_sepolia_labels_block_number'), 'xai_sepolia_labels', ['block_number'], unique=False)
    op.create_index(op.f('ix_xai_sepolia_labels_caller_address'), 'xai_sepolia_labels', ['caller_address'], unique=False)
    op.create_index(op.f('ix_xai_sepolia_labels_label'), 'xai_sepolia_labels', ['label'], unique=False)
    op.create_index(op.f('ix_xai_sepolia_labels_label_name'), 'xai_sepolia_labels', ['label_name'], unique=False)
    op.create_index(op.f('ix_xai_sepolia_labels_label_type'), 'xai_sepolia_labels', ['label_type'], unique=False)
    op.create_index(op.f('ix_xai_sepolia_labels_origin_address'), 'xai_sepolia_labels', ['origin_address'], unique=False)
    op.create_index(op.f('ix_xai_sepolia_labels_transaction_hash'), 'xai_sepolia_labels', ['transaction_hash'], unique=False)
    op.create_table('xdai_labels',
    sa.Column('id', sa.UUID(), nullable=False),
    sa.Column('label', sa.VARCHAR(length=256), nullable=False),
    sa.Column('transaction_hash', sa.VARCHAR(length=128), nullable=False),
    sa.Column('log_index', sa.Integer(), nullable=True),
    sa.Column('block_number', sa.BigInteger(), nullable=False),
    sa.Column('block_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('block_timestamp', sa.BigInteger(), nullable=False),
    sa.Column('caller_address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('origin_address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('label_name', sa.Text(), nullable=True),
    sa.Column('label_type', sa.VARCHAR(length=64), nullable=True),
    sa.Column('label_data', postgresql.JSONB(astext_type=sa.Text()), nullable=True),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text("TIMEZONE('utc', statement_timestamp())"), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_xdai_labels')),
    sa.UniqueConstraint('id', name=op.f('uq_xdai_labels_id'))
    )
    op.create_index('ix_xdai_labels_addr_block_num', 'xdai_labels', ['address', 'block_number'], unique=False)
    op.create_index(op.f('ix_xdai_labels_address'), 'xdai_labels', ['address'], unique=False)
    op.create_index(op.f('ix_xdai_labels_block_number'), 'xdai_labels', ['block_number'], unique=False)
    op.create_index(op.f('ix_xdai_labels_caller_address'), 'xdai_labels', ['caller_address'], unique=False)
    op.create_index(op.f('ix_xdai_labels_label'), 'xdai_labels', ['label'], unique=False)
    op.create_index(op.f('ix_xdai_labels_label_name'), 'xdai_labels', ['label_name'], unique=False)
    op.create_index(op.f('ix_xdai_labels_label_type'), 'xdai_labels', ['label_type'], unique=False)
    op.create_index(op.f('ix_xdai_labels_origin_address'), 'xdai_labels', ['origin_address'], unique=False)
    op.create_index(op.f('ix_xdai_labels_transaction_hash'), 'xdai_labels', ['transaction_hash'], unique=False)
    op.create_table('zksync_era_labels',
    sa.Column('id', sa.UUID(), nullable=False),
    sa.Column('label', sa.VARCHAR(length=256), nullable=False),
    sa.Column('transaction_hash', sa.VARCHAR(length=128), nullable=False),
    sa.Column('log_index', sa.Integer(), nullable=True),
    sa.Column('block_number', sa.BigInteger(), nullable=False),
    sa.Column('block_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('block_timestamp', sa.BigInteger(), nullable=False),
    sa.Column('caller_address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('origin_address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('label_name', sa.Text(), nullable=True),
    sa.Column('label_type', sa.VARCHAR(length=64), nullable=True),
    sa.Column('label_data', postgresql.JSONB(astext_type=sa.Text()), nullable=True),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text("TIMEZONE('utc', statement_timestamp())"), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_zksync_era_labels')),
    sa.UniqueConstraint('id', name=op.f('uq_zksync_era_labels_id'))
    )
    op.create_index('ix_zksync_era_labels_addr_block_num', 'zksync_era_labels', ['address', 'block_number'], unique=False)
    op.create_index(op.f('ix_zksync_era_labels_address'), 'zksync_era_labels', ['address'], unique=False)
    op.create_index(op.f('ix_zksync_era_labels_block_number'), 'zksync_era_labels', ['block_number'], unique=False)
    op.create_index(op.f('ix_zksync_era_labels_caller_address'), 'zksync_era_labels', ['caller_address'], unique=False)
    op.create_index(op.f('ix_zksync_era_labels_label'), 'zksync_era_labels', ['label'], unique=False)
    op.create_index(op.f('ix_zksync_era_labels_label_name'), 'zksync_era_labels', ['label_name'], unique=False)
    op.create_index(op.f('ix_zksync_era_labels_label_type'), 'zksync_era_labels', ['label_type'], unique=False)
    op.create_index(op.f('ix_zksync_era_labels_origin_address'), 'zksync_era_labels', ['origin_address'], unique=False)
    op.create_index(op.f('ix_zksync_era_labels_transaction_hash'), 'zksync_era_labels', ['transaction_hash'], unique=False)
    op.create_table('zksync_era_sepolia_labels',
    sa.Column('id', sa.UUID(), nullable=False),
    sa.Column('label', sa.VARCHAR(length=256), nullable=False),
    sa.Column('transaction_hash', sa.VARCHAR(length=128), nullable=False),
    sa.Column('log_index', sa.Integer(), nullable=True),
    sa.Column('block_number', sa.BigInteger(), nullable=False),
    sa.Column('block_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('block_timestamp', sa.BigInteger(), nullable=False),
    sa.Column('caller_address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('origin_address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('label_name', sa.Text(), nullable=True),
    sa.Column('label_type', sa.VARCHAR(length=64), nullable=True),
    sa.Column('label_data', postgresql.JSONB(astext_type=sa.Text()), nullable=True),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text("TIMEZONE('utc', statement_timestamp())"), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_zksync_era_sepolia_labels')),
    sa.UniqueConstraint('id', name=op.f('uq_zksync_era_sepolia_labels_id'))
    )
    op.create_index('ix_zksync_era_sepolia_labels_addr_block_num', 'zksync_era_sepolia_labels', ['address', 'block_number'], unique=False)
    op.create_index(op.f('ix_zksync_era_sepolia_labels_address'), 'zksync_era_sepolia_labels', ['address'], unique=False)
    op.create_index(op.f('ix_zksync_era_sepolia_labels_block_number'), 'zksync_era_sepolia_labels', ['block_number'], unique=False)
    op.create_index(op.f('ix_zksync_era_sepolia_labels_caller_address'), 'zksync_era_sepolia_labels', ['caller_address'], unique=False)
    op.create_index(op.f('ix_zksync_era_sepolia_labels_label'), 'zksync_era_sepolia_labels', ['label'], unique=False)
    op.create_index(op.f('ix_zksync_era_sepolia_labels_label_name'), 'zksync_era_sepolia_labels', ['label_name'], unique=False)
    op.create_index(op.f('ix_zksync_era_sepolia_labels_label_type'), 'zksync_era_sepolia_labels', ['label_type'], unique=False)
    op.create_index(op.f('ix_zksync_era_sepolia_labels_origin_address'), 'zksync_era_sepolia_labels', ['origin_address'], unique=False)
    op.create_index(op.f('ix_zksync_era_sepolia_labels_transaction_hash'), 'zksync_era_sepolia_labels', ['transaction_hash'], unique=False)
    op.create_table('avalanche_labels',
    sa.Column('id', sa.UUID(), nullable=False),
    sa.Column('label', sa.VARCHAR(length=256), nullable=False),
    sa.Column('transaction_hash', sa.VARCHAR(length=128), nullable=False),
    sa.Column('log_index', sa.Integer(), nullable=True),
    sa.Column('block_number', sa.BigInteger(), nullable=False),
    sa.Column('block_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('block_timestamp', sa.BigInteger(), nullable=False),
    sa.Column('caller_address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('origin_address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('label_name', sa.Text(), nullable=True),
    sa.Column('label_type', sa.VARCHAR(length=64), nullable=True),
    sa.Column('label_data', postgresql.JSONB(astext_type=sa.Text()), nullable=True),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text("TIMEZONE('utc', statement_timestamp())"), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_avalanche_labels')),
    sa.UniqueConstraint('id', name=op.f('uq_avalanche_labels_id'))
    )
    op.create_index('ix_avalanche_labels_addr_block_num', 'avalanche_labels', ['address', 'block_number'], unique=False)
    op.create_index(op.f('ix_avalanche_labels_address'), 'avalanche_labels', ['address'], unique=False)
    op.create_index(op.f('ix_avalanche_labels_block_number'), 'avalanche_labels', ['block_number'], unique=False)
    op.create_index(op.f('ix_avalanche_labels_caller_address'), 'avalanche_labels', ['caller_address'], unique=False)
    op.create_index(op.f('ix_avalanche_labels_label'), 'avalanche_labels', ['label'], unique=False)
    op.create_index(op.f('ix_avalanche_labels_label_name'), 'avalanche_labels', ['label_name'], unique=False)
    op.create_index(op.f('ix_avalanche_labels_label_type'), 'avalanche_labels', ['label_type'], unique=False)
    op.create_index(op.f('ix_avalanche_labels_origin_address'), 'avalanche_labels', ['origin_address'], unique=False)
    op.create_index(op.f('ix_avalanche_labels_transaction_hash'), 'avalanche_labels', ['transaction_hash'], unique=False)
    op.create_table('avalanche_fuji_labels',
    sa.Column('id', sa.UUID(), nullable=False),
    sa.Column('label', sa.VARCHAR(length=256), nullable=False),
    sa.Column('transaction_hash', sa.VARCHAR(length=128), nullable=False),
    sa.Column('log_index', sa.Integer(), nullable=True),
    sa.Column('block_number', sa.BigInteger(), nullable=False),
    sa.Column('block_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('block_timestamp', sa.BigInteger(), nullable=False),
    sa.Column('caller_address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('origin_address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('label_name', sa.Text(), nullable=True),
    sa.Column('label_type', sa.VARCHAR(length=64), nullable=True),
    sa.Column('label_data', postgresql.JSONB(astext_type=sa.Text()), nullable=True),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text("TIMEZONE('utc', statement_timestamp())"), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_avalanche_fuji_labels')),
    sa.UniqueConstraint('id', name=op.f('uq_avalanche_fuji_labels_id'))
    )
    op.create_index('ix_avalanche_fuji_labels_addr_block_num', 'avalanche_fuji_labels', ['address', 'block_number'], unique=False)
    op.create_index(op.f('ix_avalanche_fuji_labels_address'), 'avalanche_fuji_labels', ['address'], unique=False)
    op.create_index(op.f('ix_avalanche_fuji_labels_block_number'), 'avalanche_fuji_labels', ['block_number'], unique=False)
    op.create_index(op.f('ix_avalanche_fuji_labels_caller_address'), 'avalanche_fuji_labels', ['caller_address'], unique=False)
    op.create_index(op.f('ix_avalanche_fuji_labels_label'), 'avalanche_fuji_labels', ['label'], unique=False)
    op.create_index(op.f('ix_avalanche_fuji_labels_label_name'), 'avalanche_fuji_labels', ['label_name'], unique=False)
    op.create_index(op.f('ix_avalanche_fuji_labels_label_type'), 'avalanche_fuji_labels', ['label_type'], unique=False)
    op.create_index(op.f('ix_avalanche_fuji_labels_origin_address'), 'avalanche_fuji_labels', ['origin_address'], unique=False)
    op.create_index(op.f('ix_avalanche_fuji_labels_transaction_hash'), 'avalanche_fuji_labels', ['transaction_hash'], unique=False)
    op.create_table('starknet_labels',
    sa.Column('id', sa.UUID(), nullable=False),
    sa.Column('label', sa.VARCHAR(length=256), nullable=False),
    sa.Column('transaction_hash', sa.VARCHAR(length=128), nullable=False),
    sa.Column('log_index', sa.Integer(), nullable=True),
    sa.Column('block_number', sa.BigInteger(), nullable=False),
    sa.Column('block_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('block_timestamp', sa.BigInteger(), nullable=False),
    sa.Column('caller_address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('origin_address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('label_name', sa.Text(), nullable=True),
    sa.Column('label_type', sa.VARCHAR(length=64), nullable=True),
    sa.Column('label_data', postgresql.JSONB(astext_type=sa.Text()), nullable=True),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text("TIMEZONE('utc', statement_timestamp())"), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_starknet_labels')),
    sa.UniqueConstraint('id', name=op.f('uq_starknet_labels_id'))
    )
    op.create_index('ix_starknet_labels_addr_block_num', 'starknet_labels', ['address', 'block_number'], unique=False)
    op.create_index(op.f('ix_starknet_labels_address'), 'starknet_labels', ['address'], unique=False)
    op.create_index(op.f('ix_starknet_labels_block_number'), 'starknet_labels', ['block_number'], unique=False)
    op.create_index(op.f('ix_starknet_labels_caller_address'), 'starknet_labels', ['caller_address'], unique=False)
    op.create_index(op.f('ix_starknet_labels_label'), 'starknet_labels', ['label'], unique=False)
    op.create_index(op.f('ix_starknet_labels_label_name'), 'starknet_labels', ['label_name'], unique=False)
    op.create_index(op.f('ix_starknet_labels_label_type'), 'starknet_labels', ['label_type'], unique=False)
    op.create_index(op.f('ix_starknet_labels_origin_address'), 'starknet_labels', ['origin_address'], unique=False)
    op.create_index(op.f('ix_starknet_labels_transaction_hash'), 'starknet_labels', ['transaction_hash'], unique=False)
    op.create_table('starknet_sepolia_labels',
    sa.Column('id', sa.UUID(), nullable=False),
    sa.Column('label', sa.VARCHAR(length=256), nullable=False),
    sa.Column('transaction_hash', sa.VARCHAR(length=128), nullable=False),
    sa.Column('log_index', sa.Integer(), nullable=True),
    sa.Column('block_number', sa.BigInteger(), nullable=False),
    sa.Column('block_hash', sa.VARCHAR(length=256), nullable=False),
    sa.Column('block_timestamp', sa.BigInteger(), nullable=False),
    sa.Column('caller_address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('origin_address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('address', sa.VARCHAR(length=64), nullable=True),
    sa.Column('label_name', sa.Text(), nullable=True),
    sa.Column('label_type', sa.VARCHAR(length=64), nullable=True),
    sa.Column('label_data', postgresql.JSONB(astext_type=sa.Text()), nullable=True),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text("TIMEZONE('utc', statement_timestamp())"), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_starknet_sepolia_labels')),
    sa.UniqueConstraint('id', name=op.f('uq_starknet_sepolia_labels_id'))
    )
    op.create_index('ix_starknet_sepolia_labels_addr_block_num', 'starknet_sepolia_labels', ['address', 'block_number'], unique=False)
    op.create_index(op.f('ix_starknet_sepolia_labels_address'), 'starknet_sepolia_labels', ['address'], unique=False)
    op.create_index(op.f('ix_starknet_sepolia_labels_block_number'), 'starknet_sepolia_labels', ['block_number'], unique=False)
    op.create_index(op.f('ix_starknet_sepolia_labels_caller_address'), 'starknet_sepolia_labels', ['caller_address'], unique=False)
    op.create_index(op.f('ix_starknet_sepolia_labels_label'), 'starknet_sepolia_labels', ['label'], unique=False)
    op.create_index(op.f('ix_starknet_sepolia_labels_label_name'), 'starknet_sepolia_labels', ['label_name'], unique=False)
    op.create_index(op.f('ix_starknet_sepolia_labels_label_type'), 'starknet_sepolia_labels', ['label_type'], unique=False)
    op.create_index(op.f('ix_starknet_sepolia_labels_origin_address'), 'starknet_sepolia_labels', ['origin_address'], unique=False)
    op.create_index(op.f('ix_starknet_sepolia_labels_transaction_hash'), 'starknet_sepolia_labels', ['transaction_hash'], unique=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_zksync_era_sepolia_labels_transaction_hash'), table_name='zksync_era_sepolia_labels')
    op.drop_index(op.f('ix_zksync_era_sepolia_labels_origin_address'), table_name='zksync_era_sepolia_labels')
    op.drop_index(op.f('ix_zksync_era_sepolia_labels_label_type'), table_name='zksync_era_sepolia_labels')
    op.drop_index(op.f('ix_zksync_era_sepolia_labels_label_name'), table_name='zksync_era_sepolia_labels')
    op.drop_index(op.f('ix_zksync_era_sepolia_labels_label'), table_name='zksync_era_sepolia_labels')
    op.drop_index(op.f('ix_zksync_era_sepolia_labels_caller_address'), table_name='zksync_era_sepolia_labels')
    op.drop_index(op.f('ix_zksync_era_sepolia_labels_block_number'), table_name='zksync_era_sepolia_labels')
    op.drop_index(op.f('ix_zksync_era_sepolia_labels_address'), table_name='zksync_era_sepolia_labels')
    op.drop_index('ix_zksync_era_sepolia_labels_addr_block_num', table_name='zksync_era_sepolia_labels')
    op.drop_table('zksync_era_sepolia_labels')
    op.drop_index(op.f('ix_zksync_era_labels_transaction_hash'), table_name='zksync_era_labels')
    op.drop_index(op.f('ix_zksync_era_labels_origin_address'), table_name='zksync_era_labels')
    op.drop_index(op.f('ix_zksync_era_labels_label_type'), table_name='zksync_era_labels')
    op.drop_index(op.f('ix_zksync_era_labels_label_name'), table_name='zksync_era_labels')
    op.drop_index(op.f('ix_zksync_era_labels_label'), table_name='zksync_era_labels')
    op.drop_index(op.f('ix_zksync_era_labels_caller_address'), table_name='zksync_era_labels')
    op.drop_index(op.f('ix_zksync_era_labels_block_number'), table_name='zksync_era_labels')
    op.drop_index(op.f('ix_zksync_era_labels_address'), table_name='zksync_era_labels')
    op.drop_index('ix_zksync_era_labels_addr_block_num', table_name='zksync_era_labels')
    op.drop_table('zksync_era_labels')
    op.drop_index(op.f('ix_xdai_labels_transaction_hash'), table_name='xdai_labels')
    op.drop_index(op.f('ix_xdai_labels_origin_address'), table_name='xdai_labels')
    op.drop_index(op.f('ix_xdai_labels_label_type'), table_name='xdai_labels')
    op.drop_index(op.f('ix_xdai_labels_label_name'), table_name='xdai_labels')
    op.drop_index(op.f('ix_xdai_labels_label'), table_name='xdai_labels')
    op.drop_index(op.f('ix_xdai_labels_caller_address'), table_name='xdai_labels')
    op.drop_index(op.f('ix_xdai_labels_block_number'), table_name='xdai_labels')
    op.drop_index(op.f('ix_xdai_labels_address'), table_name='xdai_labels')
    op.drop_index('ix_xdai_labels_addr_block_num', table_name='xdai_labels')
    op.drop_table('xdai_labels')
    op.drop_index(op.f('ix_xai_sepolia_labels_transaction_hash'), table_name='xai_sepolia_labels')
    op.drop_index(op.f('ix_xai_sepolia_labels_origin_address'), table_name='xai_sepolia_labels')
    op.drop_index(op.f('ix_xai_sepolia_labels_label_type'), table_name='xai_sepolia_labels')
    op.drop_index(op.f('ix_xai_sepolia_labels_label_name'), table_name='xai_sepolia_labels')
    op.drop_index(op.f('ix_xai_sepolia_labels_label'), table_name='xai_sepolia_labels')
    op.drop_index(op.f('ix_xai_sepolia_labels_caller_address'), table_name='xai_sepolia_labels')
    op.drop_index(op.f('ix_xai_sepolia_labels_block_number'), table_name='xai_sepolia_labels')
    op.drop_index(op.f('ix_xai_sepolia_labels_address'), table_name='xai_sepolia_labels')
    op.drop_index('ix_xai_sepolia_labels_addr_block_num', table_name='xai_sepolia_labels')
    op.drop_table('xai_sepolia_labels')
    op.drop_index(op.f('ix_xai_labels_transaction_hash'), table_name='xai_labels')
    op.drop_index(op.f('ix_xai_labels_origin_address'), table_name='xai_labels')
    op.drop_index(op.f('ix_xai_labels_label_type'), table_name='xai_labels')
    op.drop_index(op.f('ix_xai_labels_label_name'), table_name='xai_labels')
    op.drop_index(op.f('ix_xai_labels_label'), table_name='xai_labels')
    op.drop_index(op.f('ix_xai_labels_caller_address'), table_name='xai_labels')
    op.drop_index(op.f('ix_xai_labels_block_number'), table_name='xai_labels')
    op.drop_index(op.f('ix_xai_labels_address'), table_name='xai_labels')
    op.drop_index('ix_xai_labels_addr_block_num', table_name='xai_labels')
    op.drop_table('xai_labels')
    op.drop_index(op.f('ix_sepolia_labels_transaction_hash'), table_name='sepolia_labels')
    op.drop_index(op.f('ix_sepolia_labels_origin_address'), table_name='sepolia_labels')
    op.drop_index(op.f('ix_sepolia_labels_label_type'), table_name='sepolia_labels')
    op.drop_index(op.f('ix_sepolia_labels_label_name'), table_name='sepolia_labels')
    op.drop_index(op.f('ix_sepolia_labels_label'), table_name='sepolia_labels')
    op.drop_index(op.f('ix_sepolia_labels_caller_address'), table_name='sepolia_labels')
    op.drop_index(op.f('ix_sepolia_labels_block_number'), table_name='sepolia_labels')
    op.drop_index(op.f('ix_sepolia_labels_address'), table_name='sepolia_labels')
    op.drop_index('ix_sepolia_labels_addr_block_num', table_name='sepolia_labels')
    op.drop_table('sepolia_labels')
    op.drop_index(op.f('ix_polygon_labels_transaction_hash'), table_name='polygon_labels')
    op.drop_index(op.f('ix_polygon_labels_origin_address'), table_name='polygon_labels')
    op.drop_index(op.f('ix_polygon_labels_label_type'), table_name='polygon_labels')
    op.drop_index(op.f('ix_polygon_labels_label_name'), table_name='polygon_labels')
    op.drop_index(op.f('ix_polygon_labels_label'), table_name='polygon_labels')
    op.drop_index(op.f('ix_polygon_labels_caller_address'), table_name='polygon_labels')
    op.drop_index(op.f('ix_polygon_labels_block_number'), table_name='polygon_labels')
    op.drop_index(op.f('ix_polygon_labels_address'), table_name='polygon_labels')
    op.drop_index('ix_polygon_labels_addr_block_num', table_name='polygon_labels')
    op.drop_table('polygon_labels')
    op.drop_index(op.f('ix_mumbai_labels_transaction_hash'), table_name='mumbai_labels')
    op.drop_index(op.f('ix_mumbai_labels_origin_address'), table_name='mumbai_labels')
    op.drop_index(op.f('ix_mumbai_labels_label_type'), table_name='mumbai_labels')
    op.drop_index(op.f('ix_mumbai_labels_label_name'), table_name='mumbai_labels')
    op.drop_index(op.f('ix_mumbai_labels_label'), table_name='mumbai_labels')
    op.drop_index(op.f('ix_mumbai_labels_caller_address'), table_name='mumbai_labels')
    op.drop_index(op.f('ix_mumbai_labels_block_number'), table_name='mumbai_labels')
    op.drop_index(op.f('ix_mumbai_labels_address'), table_name='mumbai_labels')
    op.drop_index('ix_mumbai_labels_addr_block_num', table_name='mumbai_labels')
    op.drop_table('mumbai_labels')
    op.drop_index(op.f('ix_ethereum_labels_transaction_hash'), table_name='ethereum_labels')
    op.drop_index(op.f('ix_ethereum_labels_origin_address'), table_name='ethereum_labels')
    op.drop_index(op.f('ix_ethereum_labels_label_type'), table_name='ethereum_labels')
    op.drop_index(op.f('ix_ethereum_labels_label_name'), table_name='ethereum_labels')
    op.drop_index(op.f('ix_ethereum_labels_label'), table_name='ethereum_labels')
    op.drop_index(op.f('ix_ethereum_labels_caller_address'), table_name='ethereum_labels')
    op.drop_index(op.f('ix_ethereum_labels_block_number'), table_name='ethereum_labels')
    op.drop_index(op.f('ix_ethereum_labels_address'), table_name='ethereum_labels')
    op.drop_index('ix_ethereum_labels_addr_block_num', table_name='ethereum_labels')
    op.drop_table('ethereum_labels')
    op.drop_index(op.f('ix_base_labels_transaction_hash'), table_name='base_labels')
    op.drop_index(op.f('ix_base_labels_origin_address'), table_name='base_labels')
    op.drop_index(op.f('ix_base_labels_label_type'), table_name='base_labels')
    op.drop_index(op.f('ix_base_labels_label_name'), table_name='base_labels')
    op.drop_index(op.f('ix_base_labels_label'), table_name='base_labels')
    op.drop_index(op.f('ix_base_labels_caller_address'), table_name='base_labels')
    op.drop_index(op.f('ix_base_labels_block_number'), table_name='base_labels')
    op.drop_index(op.f('ix_base_labels_address'), table_name='base_labels')
    op.drop_index('ix_base_labels_addr_block_num', table_name='base_labels')
    op.drop_table('base_labels')
    op.drop_index(op.f('ix_arbitrum_sepolia_labels_transaction_hash'), table_name='arbitrum_sepolia_labels')
    op.drop_index(op.f('ix_arbitrum_sepolia_labels_origin_address'), table_name='arbitrum_sepolia_labels')
    op.drop_index(op.f('ix_arbitrum_sepolia_labels_label_type'), table_name='arbitrum_sepolia_labels')
    op.drop_index(op.f('ix_arbitrum_sepolia_labels_label_name'), table_name='arbitrum_sepolia_labels')
    op.drop_index(op.f('ix_arbitrum_sepolia_labels_label'), table_name='arbitrum_sepolia_labels')
    op.drop_index(op.f('ix_arbitrum_sepolia_labels_caller_address'), table_name='arbitrum_sepolia_labels')
    op.drop_index(op.f('ix_arbitrum_sepolia_labels_block_number'), table_name='arbitrum_sepolia_labels')
    op.drop_index(op.f('ix_arbitrum_sepolia_labels_address'), table_name='arbitrum_sepolia_labels')
    op.drop_index('ix_arbitrum_sepolia_labels_addr_block_num', table_name='arbitrum_sepolia_labels')
    op.drop_table('arbitrum_sepolia_labels')
    op.drop_index(op.f('ix_arbitrum_nova_labels_transaction_hash'), table_name='arbitrum_nova_labels')
    op.drop_index(op.f('ix_arbitrum_nova_labels_origin_address'), table_name='arbitrum_nova_labels')
    op.drop_index(op.f('ix_arbitrum_nova_labels_label_type'), table_name='arbitrum_nova_labels')
    op.drop_index(op.f('ix_arbitrum_nova_labels_label_name'), table_name='arbitrum_nova_labels')
    op.drop_index(op.f('ix_arbitrum_nova_labels_label'), table_name='arbitrum_nova_labels')
    op.drop_index(op.f('ix_arbitrum_nova_labels_caller_address'), table_name='arbitrum_nova_labels')
    op.drop_index(op.f('ix_arbitrum_nova_labels_block_number'), table_name='arbitrum_nova_labels')
    op.drop_index(op.f('ix_arbitrum_nova_labels_address'), table_name='arbitrum_nova_labels')
    op.drop_index('ix_arbitrum_nova_labels_addr_block_num', table_name='arbitrum_nova_labels')
    op.drop_table('arbitrum_nova_labels')
    op.drop_index(op.f('ix_avalanche_labels_transaction_hash'), table_name='avalanche_labels')
    op.drop_index(op.f('ix_avalanche_labels_origin_address'), table_name='avalanche_labels')
    op.drop_index(op.f('ix_avalanche_labels_label_type'), table_name='avalanche_labels')
    op.drop_index(op.f('ix_avalanche_labels_label_name'), table_name='avalanche_labels')
    op.drop_index(op.f('ix_avalanche_labels_label'), table_name='avalanche_labels')
    op.drop_index(op.f('ix_avalanche_labels_caller_address'), table_name='avalanche_labels')
    op.drop_index(op.f('ix_avalanche_labels_block_number'), table_name='avalanche_labels')
    op.drop_index(op.f('ix_avalanche_labels_address'), table_name='avalanche_labels')
    op.drop_index('ix_avalanche_labels_addr_block_num', table_name='avalanche_labels')
    op.drop_table('avalanche_labels')
    op.drop_index(op.f('ix_avalanche_fuji_labels_transaction_hash'), table_name='avalanche_fuji_labels')
    op.drop_index(op.f('ix_avalanche_fuji_labels_origin_address'), table_name='avalanche_fuji_labels')
    op.drop_index(op.f('ix_avalanche_fuji_labels_label_type'), table_name='avalanche_fuji_labels')
    op.drop_index(op.f('ix_avalanche_fuji_labels_label_name'), table_name='avalanche_fuji_labels')
    op.drop_index(op.f('ix_avalanche_fuji_labels_label'), table_name='avalanche_fuji_labels')
    op.drop_index(op.f('ix_avalanche_fuji_labels_caller_address'), table_name='avalanche_fuji_labels')
    op.drop_index(op.f('ix_avalanche_fuji_labels_block_number'), table_name='avalanche_fuji_labels')
    op.drop_index(op.f('ix_avalanche_fuji_labels_address'), table_name='avalanche_fuji_labels')
    op.drop_index('ix_avalanche_fuji_labels_addr_block_num', table_name='avalanche_fuji_labels')
    op.drop_table('avalanche_fuji_labels')
    op.drop_index(op.f('ix_starknet_labels_transaction_hash'), table_name='starknet_labels')
    op.drop_index(op.f('ix_starknet_labels_origin_address'), table_name='starknet_labels')
    op.drop_index(op.f('ix_starknet_labels_label_type'), table_name='starknet_labels')
    op.drop_index(op.f('ix_starknet_labels_label_name'), table_name='starknet_labels')
    op.drop_index(op.f('ix_starknet_labels_label'), table_name='starknet_labels')
    op.drop_index(op.f('ix_starknet_labels_caller_address'), table_name='starknet_labels')
    op.drop_index(op.f('ix_starknet_labels_block_number'), table_name='starknet_labels')
    op.drop_index(op.f('ix_starknet_labels_address'), table_name='starknet_labels')
    op.drop_index('ix_starknet_labels_addr_block_num', table_name='starknet_labels')
    op.drop_table('starknet_labels')
    op.drop_index(op.f('ix_starknet_sepolia_labels_transaction_hash'), table_name='starknet_sepolia_labels')
    op.drop_index(op.f('ix_starknet_sepolia_labels_origin_address'), table_name='starknet_sepolia_labels')
    op.drop_index(op.f('ix_starknet_sepolia_labels_label_type'), table_name='starknet_sepolia_labels')
    op.drop_index(op.f('ix_starknet_sepolia_labels_label_name'), table_name='starknet_sepolia_labels')
    op.drop_index(op.f('ix_starknet_sepolia_labels_label'), table_name='starknet_sepolia_labels')
    op.drop_index(op.f('ix_starknet_sepolia_labels_caller_address'), table_name='starknet_sepolia_labels')
    op.drop_index(op.f('ix_starknet_sepolia_labels_block_number'), table_name='starknet_sepolia_labels')
    op.drop_index(op.f('ix_starknet_sepolia_labels_address'), table_name='starknet_sepolia_labels')
    op.drop_index('ix_starknet_sepolia_labels_addr_block_num', table_name='starknet_sepolia_labels')
    op.drop_table('starknet_sepolia_labels')
    # ### end Alembic commands ###
