--
-- PostgreSQL database dump
--

-- Dumped from database version 12.0
-- Dumped by pg_dump version 12.0

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: create_role_if_not_exists(name); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.create_role_if_not_exists(rolename name) RETURNS text
    LANGUAGE plpgsql
    AS $$
BEGIN
    IF NOT EXISTS (SELECT * FROM pg_roles WHERE rolname = rolename) THEN
        EXECUTE format('CREATE ROLE %I', rolename);
        RETURN 'CREATE ROLE';
    ELSE
        RETURN format('ROLE ''%I'' ALREADY EXISTS', rolename);
    END IF;
END;
$$;


ALTER FUNCTION public.create_role_if_not_exists(rolename name) OWNER TO postgres;

--
-- Name: cuenta_saldo(integer, date); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.cuenta_saldo(p_id_cuentas integer, p_fechaparametro date) RETURNS numeric
    LANGUAGE plpgsql
    AS $$
DECLARE
    recCuentas RECORD;
    resultado numeric(100,2);
BEGIN
    resultado := 0;
    FOR recCuentas IN SELECT * FROM opercuentas where id_cuentas=p_id_cuentas and datetime::date <= p_fechaparametro LOOP
resultado := resultado + recCuentas.importe;
    END LOOP;
    RETURN resultado;
END;
$$;


ALTER FUNCTION public.cuenta_saldo(p_id_cuentas integer, p_fechaparametro date) OWNER TO postgres;

--
-- Name: cuentas_saldo(date); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.cuentas_saldo(fechaparametro date) RETURNS numeric
    LANGUAGE plpgsql
    AS $$
DECLARE
    recCuentas RECORD;
    resultado numeric(100,2);
BEGIN
    resultado := 0;
    FOR recCuentas IN SELECT * FROM cuentas  LOOP
resultado := resultado + cuenta_saldo(recCuentas.id_cuentas, fechaparametro);
    END LOOP;
    RETURN resultado;
END;
$$;


ALTER FUNCTION public.cuentas_saldo(fechaparametro date) OWNER TO postgres;

--
-- Name: investment_operations_current(integer, timestamp with time zone); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.investment_operations_current(p_investment_id integer, p_at_datetime timestamp with time zone) RETURNS TABLE(investment_id integer, datetime timestamp with time zone, shares numeric, operationtype_id integer, taxes numeric, commissions numeric, currency_conversion numeric)
    LANGUAGE plpgsql
    AS $$
DECLARE 
    o record;
BEGIN
    FOR o IN(SELECT * from operinversiones where id_inversiones= p_investment_id order by datetime)  
    LOOP
        investment_id:= o.id_inversiones;
        datetime:=o.datetime;
        shares:=o.acciones;
        operationtype_id:=o.id_tiposoperaciones;
        taxes:=o.impuestos;
        commissions:=o.comision;
        currency_conversion:=o.currency_conversion;
        RETURN NEXT;
    END LOOP;
END;
$$;


ALTER FUNCTION public.investment_operations_current(p_investment_id integer, p_at_datetime timestamp with time zone) OWNER TO postgres;

--
-- Name: is_price_variation_in_time(integer, double precision, timestamp with time zone); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.is_price_variation_in_time(p_id_products integer, p_percentage double precision, p_datetime timestamp with time zone) RETURNS boolean
    LANGUAGE plpgsql
    AS $$DECLARE
    result boolean;
    initial numeric(18,6);
    final numeric(18,6);
        variation numeric(18,6);
BEGIN
    result := False;
    SELECT quotes.quote  INTO final FROM quotes where quotes.id= p_id_products and quotes.datetime <= now() order by quotes.datetime desc limit 1;
    SELECT quotes.quote  INTO initial FROM quotes where quotes.id= p_id_products and quotes.datetime <= p_datetime order by quotes.datetime desc limit 1;
    IF initial=0 THEN
            return False;
        END IF;
        
        variation:=100*(final-initial)/initial;
        --Raise Notice 'hello world % %: % (%)', initial, final, variation, p_percentage;
    -- PERCENTAGE POSITIVE
    IF p_percentage>0 AND variation > p_percentage THEN
        return True;
    END IF;
    -- PERCENTAGE NEGATIVE
    IF p_percentage<0 AND variation < p_percentage THEN
        return True;
    END IF;
    RETURN result;
END;
$$;


ALTER FUNCTION public.is_price_variation_in_time(p_id_products integer, p_percentage double precision, p_datetime timestamp with time zone) OWNER TO postgres;

--
-- Name: FUNCTION is_price_variation_in_time(p_id_products integer, p_percentage double precision, p_datetime timestamp with time zone); Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON FUNCTION public.is_price_variation_in_time(p_id_products integer, p_percentage double precision, p_datetime timestamp with time zone) IS 'Returns True, if percentage is negative and variation between timestamp price and current product price is less than percentage
Returns True, if percentage is positive and variation between timestamp price and current product price is bigger than percentage
Return False, in other cases';


--
-- Name: last_penultimate_lastyear(integer, timestamp with time zone); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.last_penultimate_lastyear(INOUT id integer, at_datetime timestamp with time zone, OUT last_datetime timestamp with time zone, OUT last numeric, OUT penultimate_datetime timestamp with time zone, OUT penultimate numeric, OUT lastyear_datetime timestamp with time zone, OUT lastyear numeric) RETURNS record
    LANGUAGE plpgsql
    AS $$
DECLARE
    ly timestamptz;
BEGIN
    SELECT quotes.quote, quotes.datetime  INTO last_penultimate_lastyear.last, last_penultimate_lastyear.last_datetime FROM quote(id, at_datetime) quotes;
    SELECT quotes.quote, quotes.datetime  INTO last_penultimate_lastyear.penultimate, last_penultimate_lastyear.penultimate_datetime FROM penultimate(id, at_datetime::date) quotes;
    ly:=make_timestamptz((EXTRACT(YEAR FROM  at_datetime)-1)::integer, 12, 31, 23, 59, 59.999999::double precision) ;
    SELECT quotes.quote, quotes.datetime  INTO last_penultimate_lastyear.lastyear, last_penultimate_lastyear.lastyear_datetime FROM quote(id,ly) quotes;
END;
$$;


ALTER FUNCTION public.last_penultimate_lastyear(INOUT id integer, at_datetime timestamp with time zone, OUT last_datetime timestamp with time zone, OUT last numeric, OUT penultimate_datetime timestamp with time zone, OUT penultimate numeric, OUT lastyear_datetime timestamp with time zone, OUT lastyear numeric) OWNER TO postgres;

--
-- Name: penultimate(integer, date); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.penultimate(INOUT id integer, date date, OUT quote numeric, OUT datetime timestamp with time zone, OUT searched timestamp with time zone) RETURNS record
    LANGUAGE plpgsql
    AS $$
DECLARE
    last_datetime timestamptz;
    minus date;
BEGIN
    searched:=make_timestamptz(EXTRACT(YEAR FROM penultimate.date)::integer,EXTRACT(MONTH FROM penultimate.date)::integer, EXTRACT(DAY FROM penultimate.date)::integer, 23, 59, 59.999999::double precision) ;
    select quotes.datetime INTO last_datetime from quote(penultimate.id, searched) quotes;
    minus:=last_datetime::date - integer '1';
    searched:=make_timestamptz(EXTRACT(YEAR FROM minus)::integer,EXTRACT(MONTH FROM minus)::integer, EXTRACT(DAY FROM minus)::integer, 23, 59, 59.999999::double precision) ;
    SELECT quotes.quote, quotes.datetime  INTO penultimate.quote, penultimate.datetime FROM quotes where quotes.id= penultimate.id and quotes.datetime <= searched order by quotes.datetime desc limit 1;
END;
$$;


ALTER FUNCTION public.penultimate(INOUT id integer, date date, OUT quote numeric, OUT datetime timestamp with time zone, OUT searched timestamp with time zone) OWNER TO postgres;

--
-- Name: quote(integer, timestamp with time zone); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.quote(INOUT id integer, INOUT datetime timestamp with time zone, OUT quote numeric, OUT searched timestamp with time zone) RETURNS record
    LANGUAGE plpgsql
    AS $$
BEGIN
    searched := quote.datetime;
    SELECT quotes.quote, quotes.datetime  INTO quote.quote, quote.datetime FROM quotes where quotes.id= quote.id and quotes.datetime <= quote.datetime order by quotes.datetime desc limit 1;
END;
$$;


ALTER FUNCTION public.quote(INOUT id integer, INOUT datetime timestamp with time zone, OUT quote numeric, OUT searched timestamp with time zone) OWNER TO postgres;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: annualtargets; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.annualtargets (
    year integer NOT NULL,
    percentage numeric(6,2)
);


ALTER TABLE public.annualtargets OWNER TO postgres;

--
-- Name: conceptos; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.conceptos (
    id_conceptos integer DEFAULT nextval(('"seq_conceptos"'::text)::regclass) NOT NULL,
    concepto text,
    id_tiposoperaciones integer,
    editable boolean DEFAULT true NOT NULL
);


ALTER TABLE public.conceptos OWNER TO postgres;

--
-- Name: cuentas; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.cuentas (
    id_cuentas integer DEFAULT nextval(('"seq_cuentas"'::text)::regclass) NOT NULL,
    cuenta text,
    id_entidadesbancarias integer,
    active boolean,
    numerocuenta character varying(24),
    currency text DEFAULT 'EUR'::text NOT NULL
);


ALTER TABLE public.cuentas OWNER TO postgres;

--
-- Name: dividendosestimaciones_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.dividendosestimaciones_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.dividendosestimaciones_seq OWNER TO postgres;

--
-- Name: dps_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.dps_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.dps_seq OWNER TO postgres;

--
-- Name: dps; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.dps (
    id_dps integer DEFAULT nextval('public.dps_seq'::regclass) NOT NULL,
    date date,
    gross numeric(18,6),
    id bigint
);


ALTER TABLE public.dps OWNER TO postgres;

--
-- Name: TABLE dps; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.dps IS 'Dividends per share paid';


--
-- Name: COLUMN dps.gross; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.dps.gross IS 'Bruto';


--
-- Name: COLUMN dps.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.dps.id IS 'id of investment';


--
-- Name: dividendospagos_id_dividendospagos_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.dividendospagos_id_dividendospagos_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.dividendospagos_id_dividendospagos_seq OWNER TO postgres;

--
-- Name: dividendospagos_id_dividendospagos_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.dividendospagos_id_dividendospagos_seq OWNED BY public.dps.id_dps;


--
-- Name: dividends; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.dividends (
    id_dividends integer DEFAULT nextval(('"seq_dividendos"'::text)::regclass) NOT NULL,
    id_inversiones integer NOT NULL,
    bruto numeric(100,2) NOT NULL,
    retencion numeric(100,2) NOT NULL,
    neto numeric(100,2),
    valorxaccion numeric(100,6),
    fecha timestamp with time zone,
    id_opercuentas integer,
    comision numeric(100,2),
    id_conceptos integer DEFAULT 39 NOT NULL,
    currency_conversion numeric(10,6) DEFAULT 1 NOT NULL
);


ALTER TABLE public.dividends OWNER TO postgres;

--
-- Name: COLUMN dividends.currency_conversion; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.dividends.currency_conversion IS 'Conversión de divisa del dividendo a la de la cuenta. Bruto, retención, neto y valorxaccion van en la divisa de la inversión. La comisión va en la divisa de la cuenta y no necesita conversión. Para convertir a la divisa de la cuenta gross*currency_conversion';


--
-- Name: entidadesbancarias; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.entidadesbancarias (
    id_entidadesbancarias integer DEFAULT nextval(('"seq_entidadesbancarias"'::text)::regclass) NOT NULL,
    entidadbancaria text NOT NULL,
    active boolean NOT NULL
);


ALTER TABLE public.entidadesbancarias OWNER TO postgres;

--
-- Name: estimations_dps; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.estimations_dps (
    year integer NOT NULL,
    estimation numeric(18,6) NOT NULL,
    date_estimation date,
    source text,
    manual boolean,
    id integer NOT NULL
);


ALTER TABLE public.estimations_dps OWNER TO postgres;

--
-- Name: TABLE estimations_dps; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.estimations_dps IS 'Dividends per share';


--
-- Name: estimations_eps; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.estimations_eps (
    year integer NOT NULL,
    estimation numeric(18,6) NOT NULL,
    date_estimation date,
    source text,
    manual boolean,
    id integer NOT NULL
);


ALTER TABLE public.estimations_eps OWNER TO postgres;

--
-- Name: TABLE estimations_eps; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.estimations_eps IS 'Earnings per share';


--
-- Name: globals; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.globals (
    id integer NOT NULL,
    global text,
    value text
);


ALTER TABLE public.globals OWNER TO postgres;

--
-- Name: high_low_contract_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.high_low_contract_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.high_low_contract_seq OWNER TO postgres;

--
-- Name: high_low_contract; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.high_low_contract (
    id integer DEFAULT nextval('public.high_low_contract_seq'::regclass) NOT NULL,
    investments_id integer NOT NULL,
    datetime timestamp with time zone NOT NULL,
    guarantee numeric(100,2) NOT NULL,
    adjustment numeric(100,2) NOT NULL,
    commission numeric(100,2) NOT NULL,
    interest numeric(100,2) NOT NULL,
    guarantee_ao integer,
    adjustment_ao integer,
    commission_ao integer,
    interest_ao integer,
    currency_conversion numeric(10,6) DEFAULT 1 NOT NULL
);


ALTER TABLE public.high_low_contract OWNER TO postgres;

--
-- Name: inversiones; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.inversiones (
    id_inversiones integer DEFAULT nextval(('"seq_inversiones"'::text)::regclass) NOT NULL,
    inversion text NOT NULL,
    active boolean DEFAULT true NOT NULL,
    id_cuentas integer NOT NULL,
    venta numeric(100,6) DEFAULT 0 NOT NULL,
    products_id integer,
    selling_expiration date DEFAULT now()
);


ALTER TABLE public.inversiones OWNER TO postgres;

--
-- Name: investments_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.investments_seq
    START WITH 4
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.investments_seq OWNER TO postgres;

--
-- Name: opercuentas; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.opercuentas (
    id_opercuentas integer DEFAULT nextval(('"seq_opercuentas"'::text)::regclass) NOT NULL,
    id_conceptos integer NOT NULL,
    id_tiposoperaciones integer NOT NULL,
    importe numeric(100,2) NOT NULL,
    comentario text,
    id_cuentas integer NOT NULL,
    datetime timestamp with time zone
);


ALTER TABLE public.opercuentas OWNER TO postgres;

--
-- Name: opercuentasdeoperinversiones; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.opercuentasdeoperinversiones (
    id_operinversiones integer NOT NULL,
    id_inversiones integer NOT NULL
)
INHERITS (public.opercuentas);


ALTER TABLE public.opercuentasdeoperinversiones OWNER TO postgres;

--
-- Name: operinversiones; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.operinversiones (
    id_operinversiones integer DEFAULT nextval(('"seq_operinversiones"'::text)::regclass) NOT NULL,
    id_tiposoperaciones integer,
    id_inversiones integer,
    acciones numeric(100,6),
    impuestos numeric(100,2),
    comision numeric(100,2),
    valor_accion numeric(100,6),
    divisa numeric(10,6) DEFAULT NULL::numeric,
    datetime timestamp with time zone,
    comentario text,
    show_in_ranges boolean DEFAULT true,
    currency_conversion numeric(30,10) DEFAULT 1 NOT NULL
);


ALTER TABLE public.operinversiones OWNER TO postgres;

--
-- Name: COLUMN operinversiones.divisa; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.operinversiones.divisa IS 'Campo que calcula el cociente entre la divisa de la divisa de la cuenta bancaria asociada entre la divisa de la inversión es decir EUR/USD. Si eur es la cuenta bancariaa y usd la divisa de la inversión';


--
-- Name: COLUMN operinversiones.currency_conversion; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.operinversiones.currency_conversion IS 'Conversión de divisa de la inversión a la de la cuenta. Multiplicando acciones*valor_accion*currency_conversion obtenemos el precio en la divisa de la cuenta de inversion->cuenta. Todos los campos de operinversiones van en la divisa del producto de la inversión';


--
-- Name: opertarjetas; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.opertarjetas (
    id_opertarjetas integer DEFAULT nextval(('"seq_opertarjetas"'::text)::regclass) NOT NULL,
    id_conceptos integer NOT NULL,
    id_tiposoperaciones integer NOT NULL,
    importe numeric(100,2) NOT NULL,
    comentario text,
    id_tarjetas integer NOT NULL,
    pagado boolean NOT NULL,
    fechapago timestamp with time zone,
    id_opercuentas bigint,
    datetime timestamp with time zone
);


ALTER TABLE public.opertarjetas OWNER TO postgres;

--
-- Name: opportunities_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.opportunities_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.opportunities_seq OWNER TO postgres;

--
-- Name: opportunities; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.opportunities (
    id integer DEFAULT nextval('public.opportunities_seq'::regclass) NOT NULL,
    date date NOT NULL,
    removed date,
    executed date,
    entry numeric(100,2) NOT NULL,
    products_id integer NOT NULL,
    target numeric(100,2),
    stoploss numeric(100,2),
    short boolean DEFAULT false NOT NULL
);


ALTER TABLE public.opportunities OWNER TO postgres;

--
-- Name: COLUMN opportunities.short; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.opportunities.short IS 'If true is a short investment strategy. If false is a long one';


--
-- Name: orders_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.orders_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.orders_seq OWNER TO postgres;

--
-- Name: orders; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.orders (
    id integer DEFAULT nextval('public.orders_seq'::regclass) NOT NULL,
    date date NOT NULL,
    expiration date NOT NULL,
    shares numeric(100,6),
    price numeric(100,2),
    investments_id integer NOT NULL,
    executed timestamp with time zone
);


ALTER TABLE public.orders OWNER TO postgres;

--
-- Name: products; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.products (
    name text,
    isin text,
    currency text,
    type integer,
    agrupations text,
    id integer DEFAULT nextval(('"investments_seq"'::text)::regclass) NOT NULL,
    web text,
    address text,
    phone text,
    mail text,
    percentage integer DEFAULT 100 NOT NULL,
    pci character(1) DEFAULT 'c'::bpchar NOT NULL,
    leveraged integer DEFAULT 0 NOT NULL,
    stockmarkets_id integer NOT NULL,
    comment text,
    obsolete boolean DEFAULT false NOT NULL,
    tickers text[],
    high_low boolean,
    decimals integer DEFAULT 2
);


ALTER TABLE public.products OWNER TO postgres;

--
-- Name: COLUMN products.obsolete; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.products.obsolete IS 'Comprueba si esta obsoleta la inversión';


--
-- Name: quotes; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.quotes (
    datetime timestamp with time zone,
    quote numeric(18,6),
    id_quotes integer DEFAULT nextval(('"quotes_seq"'::text)::regclass) NOT NULL,
    id integer
);


ALTER TABLE public.quotes OWNER TO postgres;

--
-- Name: quotes_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.quotes_seq
    START WITH 9110967
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.quotes_seq OWNER TO postgres;

--
-- Name: seq_conceptos; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.seq_conceptos
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.seq_conceptos OWNER TO postgres;

--
-- Name: seq_cuentas; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.seq_cuentas
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    MAXVALUE 1000000
    CACHE 1;


ALTER TABLE public.seq_cuentas OWNER TO postgres;

--
-- Name: seq_dividendos; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.seq_dividendos
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.seq_dividendos OWNER TO postgres;

--
-- Name: seq_entidadesbancarias; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.seq_entidadesbancarias
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    MAXVALUE 100000000
    CACHE 1;


ALTER TABLE public.seq_entidadesbancarias OWNER TO postgres;

--
-- Name: seq_inversiones; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.seq_inversiones
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.seq_inversiones OWNER TO postgres;

--
-- Name: seq_opercuentas; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.seq_opercuentas
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.seq_opercuentas OWNER TO postgres;

--
-- Name: seq_operinversiones; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.seq_operinversiones
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.seq_operinversiones OWNER TO postgres;

--
-- Name: seq_operinversioneshistoricas; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.seq_operinversioneshistoricas
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.seq_operinversioneshistoricas OWNER TO postgres;

--
-- Name: seq_opertarjetas; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.seq_opertarjetas
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.seq_opertarjetas OWNER TO postgres;

--
-- Name: seq_tarjetas; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.seq_tarjetas
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.seq_tarjetas OWNER TO postgres;

--
-- Name: simulations_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.simulations_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.simulations_seq OWNER TO postgres;

--
-- Name: simulations; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.simulations (
    database text,
    id integer DEFAULT nextval('public.simulations_seq'::regclass) NOT NULL,
    starting timestamp with time zone,
    ending timestamp with time zone,
    type integer,
    creation timestamp with time zone
);


ALTER TABLE public.simulations OWNER TO postgres;

--
-- Name: splits_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.splits_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.splits_id_seq OWNER TO postgres;

--
-- Name: splits; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.splits (
    id integer DEFAULT nextval('public.splits_id_seq'::regclass) NOT NULL,
    datetime timestamp with time zone NOT NULL,
    products_id integer NOT NULL,
    before integer NOT NULL,
    after integer NOT NULL,
    comment text
);


ALTER TABLE public.splits OWNER TO postgres;

--
-- Name: TABLE splits; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.splits IS 'Split and contrasplit product operations';


--
-- Name: tarjetas; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tarjetas (
    id_tarjetas integer DEFAULT nextval(('"seq_tarjetas"'::text)::regclass) NOT NULL,
    tarjeta text,
    id_cuentas integer,
    pagodiferido boolean,
    saldomaximo numeric(100,2),
    active boolean,
    numero text
);


ALTER TABLE public.tarjetas OWNER TO postgres;

--
-- Name: opercuentasdeoperinversiones id_opercuentas; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.opercuentasdeoperinversiones ALTER COLUMN id_opercuentas SET DEFAULT nextval(('"seq_opercuentas"'::text)::regclass);


--
-- Name: annualtargets annualtargets_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.annualtargets
    ADD CONSTRAINT annualtargets_pk PRIMARY KEY (year);


--
-- Name: conceptos conceptos_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.conceptos
    ADD CONSTRAINT conceptos_pk PRIMARY KEY (id_conceptos);


--
-- Name: cuentas cuentas_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.cuentas
    ADD CONSTRAINT cuentas_pk PRIMARY KEY (id_cuentas);


--
-- Name: dividends dividendos_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.dividends
    ADD CONSTRAINT dividendos_pkey PRIMARY KEY (id_dividends);


--
-- Name: dps dps_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.dps
    ADD CONSTRAINT dps_pk PRIMARY KEY (id_dps);


--
-- Name: entidadesbancarias entidadesbancarias_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.entidadesbancarias
    ADD CONSTRAINT entidadesbancarias_pk PRIMARY KEY (id_entidadesbancarias);


--
-- Name: estimations_eps estimacion_eps_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.estimations_eps
    ADD CONSTRAINT estimacion_eps_pk PRIMARY KEY (year, id);


--
-- Name: estimations_dps estimations_dps_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.estimations_dps
    ADD CONSTRAINT estimations_dps_pk PRIMARY KEY (year, id);


--
-- Name: high_low_contract high_low_contract_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.high_low_contract
    ADD CONSTRAINT high_low_contract_pk PRIMARY KEY (id);


--
-- Name: products investments_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.products
    ADD CONSTRAINT investments_pk PRIMARY KEY (id);


--
-- Name: opercuentasdeoperinversiones opercuentasdeoperinversiones_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.opercuentasdeoperinversiones
    ADD CONSTRAINT opercuentasdeoperinversiones_pk PRIMARY KEY (id_opercuentas);


--
-- Name: opertarjetas opertarjetas_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.opertarjetas
    ADD CONSTRAINT opertarjetas_pkey PRIMARY KEY (id_opertarjetas);


--
-- Name: opportunities opportunities_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.opportunities
    ADD CONSTRAINT opportunities_pk PRIMARY KEY (id);


--
-- Name: orders orders_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.orders
    ADD CONSTRAINT orders_pk PRIMARY KEY (id);


--
-- Name: globals pk_globals; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.globals
    ADD CONSTRAINT pk_globals PRIMARY KEY (id);


--
-- Name: inversiones pk_inversiones; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.inversiones
    ADD CONSTRAINT pk_inversiones PRIMARY KEY (id_inversiones);


--
-- Name: opercuentas pk_opercuentas; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.opercuentas
    ADD CONSTRAINT pk_opercuentas PRIMARY KEY (id_opercuentas);


--
-- Name: operinversiones pk_operinversiones; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.operinversiones
    ADD CONSTRAINT pk_operinversiones PRIMARY KEY (id_operinversiones);


--
-- Name: quotes quotes_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.quotes
    ADD CONSTRAINT quotes_pk PRIMARY KEY (id_quotes);


--
-- Name: simulations simulations_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.simulations
    ADD CONSTRAINT simulations_pk PRIMARY KEY (id);


--
-- Name: splits splits_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.splits
    ADD CONSTRAINT splits_pk PRIMARY KEY (id);


--
-- Name: tarjetas tarjetas_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tarjetas
    ADD CONSTRAINT tarjetas_pkey PRIMARY KEY (id_tarjetas);


--
-- Name: dividendos-id_inversiones-index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX "dividendos-id_inversiones-index" ON public.dividends USING btree (id_inversiones);


--
-- Name: inversiones-id_cuentas-index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX "inversiones-id_cuentas-index" ON public.inversiones USING btree (id_cuentas);


--
-- Name: opercuentas-id_cuentas-index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX "opercuentas-id_cuentas-index" ON public.opercuentas USING btree (id_cuentas);


--
-- Name: operinversiones-id_inversiones-index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX "operinversiones-id_inversiones-index" ON public.operinversiones USING btree (id_inversiones);


--
-- Name: opertarjetas-id_tarjetas-index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX "opertarjetas-id_tarjetas-index" ON public.opertarjetas USING btree (id_tarjetas);


--
-- Name: quotes_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX quotes_id ON public.quotes USING btree (id);


--
-- Name: quotes_id_datetime; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX quotes_id_datetime ON public.quotes USING btree (id, datetime);


--
-- Name: splits_index_products_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX splits_index_products_id ON public.splits USING btree (products_id);


--
-- Name: tmpinversionesheredada-id_cuentas-index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX "tmpinversionesheredada-id_cuentas-index" ON public.opercuentasdeoperinversiones USING btree (id_cuentas);


--
-- Name: cuentas cuentas_fk_id_entidadesbancarias; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.cuentas
    ADD CONSTRAINT cuentas_fk_id_entidadesbancarias FOREIGN KEY (id_entidadesbancarias) REFERENCES public.entidadesbancarias(id_entidadesbancarias) ON DELETE RESTRICT;


--
-- Name: dividends dividendos_fk_id_conceptos; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.dividends
    ADD CONSTRAINT dividendos_fk_id_conceptos FOREIGN KEY (id_conceptos) REFERENCES public.conceptos(id_conceptos) ON DELETE RESTRICT;


--
-- Name: dividends dividendos_fk_id_inversiones; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.dividends
    ADD CONSTRAINT dividendos_fk_id_inversiones FOREIGN KEY (id_inversiones) REFERENCES public.inversiones(id_inversiones) ON DELETE RESTRICT;


--
-- Name: dps dps_fk_id; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.dps
    ADD CONSTRAINT dps_fk_id FOREIGN KEY (id) REFERENCES public.products(id) ON DELETE RESTRICT;


--
-- Name: estimations_dps estimations_dps_fk_id; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.estimations_dps
    ADD CONSTRAINT estimations_dps_fk_id FOREIGN KEY (id) REFERENCES public.products(id) ON DELETE RESTRICT;


--
-- Name: estimations_eps estimations_eps_fk_id; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.estimations_eps
    ADD CONSTRAINT estimations_eps_fk_id FOREIGN KEY (id) REFERENCES public.products(id) ON DELETE RESTRICT;


--
-- Name: high_low_contract high_low_contract_fk_adjustment_ao; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.high_low_contract
    ADD CONSTRAINT high_low_contract_fk_adjustment_ao FOREIGN KEY (adjustment_ao) REFERENCES public.opercuentas(id_opercuentas);


--
-- Name: high_low_contract high_low_contract_fk_comission_ao; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.high_low_contract
    ADD CONSTRAINT high_low_contract_fk_comission_ao FOREIGN KEY (commission_ao) REFERENCES public.opercuentas(id_opercuentas);


--
-- Name: high_low_contract high_low_contract_fk_guarantee_ao; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.high_low_contract
    ADD CONSTRAINT high_low_contract_fk_guarantee_ao FOREIGN KEY (guarantee_ao) REFERENCES public.opercuentas(id_opercuentas);


--
-- Name: high_low_contract high_low_contract_fk_interest_ao; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.high_low_contract
    ADD CONSTRAINT high_low_contract_fk_interest_ao FOREIGN KEY (interest_ao) REFERENCES public.opercuentas(id_opercuentas);


--
-- Name: high_low_contract high_low_contract_fk_investments_id; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.high_low_contract
    ADD CONSTRAINT high_low_contract_fk_investments_id FOREIGN KEY (investments_id) REFERENCES public.inversiones(id_inversiones) ON DELETE RESTRICT;


--
-- Name: inversiones inversiones_fk_id_cuentas; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.inversiones
    ADD CONSTRAINT inversiones_fk_id_cuentas FOREIGN KEY (id_cuentas) REFERENCES public.cuentas(id_cuentas) ON DELETE RESTRICT;


--
-- Name: inversiones inversiones_fk_products_id; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.inversiones
    ADD CONSTRAINT inversiones_fk_products_id FOREIGN KEY (products_id) REFERENCES public.products(id) ON DELETE RESTRICT;


--
-- Name: opercuentas opercuentas_fk_id_conceptos; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.opercuentas
    ADD CONSTRAINT opercuentas_fk_id_conceptos FOREIGN KEY (id_conceptos) REFERENCES public.conceptos(id_conceptos) ON DELETE RESTRICT;


--
-- Name: opercuentas opercuentas_fk_id_cuentas; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.opercuentas
    ADD CONSTRAINT opercuentas_fk_id_cuentas FOREIGN KEY (id_cuentas) REFERENCES public.cuentas(id_cuentas) ON DELETE RESTRICT;


--
-- Name: operinversiones operinversiones_fk_id_inversiones; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.operinversiones
    ADD CONSTRAINT operinversiones_fk_id_inversiones FOREIGN KEY (id_inversiones) REFERENCES public.inversiones(id_inversiones) ON DELETE RESTRICT;


--
-- Name: opertarjetas opertarjetas_fk_id_conceptos; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.opertarjetas
    ADD CONSTRAINT opertarjetas_fk_id_conceptos FOREIGN KEY (id_conceptos) REFERENCES public.conceptos(id_conceptos) ON DELETE RESTRICT;


--
-- Name: opertarjetas opertarjetas_fk_id_tarjetas; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.opertarjetas
    ADD CONSTRAINT opertarjetas_fk_id_tarjetas FOREIGN KEY (id_tarjetas) REFERENCES public.tarjetas(id_tarjetas) ON DELETE RESTRICT;


--
-- Name: opportunities opportunities_products_id_fk_products_id; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.opportunities
    ADD CONSTRAINT opportunities_products_id_fk_products_id FOREIGN KEY (products_id) REFERENCES public.products(id) ON DELETE RESTRICT;


--
-- Name: orders orders_investments_id_fk_inversiones_id_inversiones; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.orders
    ADD CONSTRAINT orders_investments_id_fk_inversiones_id_inversiones FOREIGN KEY (investments_id) REFERENCES public.inversiones(id_inversiones) ON DELETE RESTRICT;


--
-- Name: quotes quotes_fk_id; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.quotes
    ADD CONSTRAINT quotes_fk_id FOREIGN KEY (id) REFERENCES public.products(id) ON DELETE RESTRICT;


--
-- Name: splits splits_fk_products_id; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.splits
    ADD CONSTRAINT splits_fk_products_id FOREIGN KEY (products_id) REFERENCES public.products(id);


--
-- Name: tarjetas tarjetas_fk_id_cuentas; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tarjetas
    ADD CONSTRAINT tarjetas_fk_id_cuentas FOREIGN KEY (id_cuentas) REFERENCES public.cuentas(id_cuentas) ON DELETE RESTRICT;


--
-- PostgreSQL database dump complete
--

INSERT INTO public.products VALUES (' RIB SOFTWARE AG', 'DE000A0Z2XN6', 'EUR', 1, '|DEUTSCHEBOERSE|', 77992, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE000A0Z2XN6||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('118000 AG', 'DE0006911902', 'EUR', 1, '|DEUTSCHEBOERSE|', 78360, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0006911902||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('30-70 EURO INVERSION', 'ES0184833038', 'EUR', 2, '|f_es_BMF|', 78089, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0184833038||es||False', false, '{NULL,F0GBR04JLT,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('3D SYSTEMS CORPORATION', 'US88554D2053', 'USD', 1, '', 78596, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DDD||us||False', false, '{DDD,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('3M CO.', 'US88579Y1010', 'USD', 1, '|SP500|', 77347, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#MMM||us||False', false, '{MMM,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('3U HOLDING AG', 'DE0005167902', 'EUR', 1, '|DEUTSCHEBOERSE|', 78361, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005167902||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('3W POWER', 'GG00B39QCR01', 'EUR', 1, '|EURONEXT|', 78088, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#GG00B39QCR01||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('3W POWER S.A.', 'GG00B39QCR01', 'EUR', 1, '|DEUTSCHEBOERSE|', 80470, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#GG00B39QCR01||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('4ENERGY INV (D)', 'BE0003888089', 'EUR', 1, '|EURONEXT|', 79017, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003888089||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('4ENERGY STR (D)', 'BE0005625968', 'EUR', 1, '|EURONEXT|', 76459, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0005625968||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('4SC AG', 'DE0005753818', 'EUR', 1, '|DEUTSCHEBOERSE|', 80471, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005753818||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('7 DAYS GROUP HOLDINGS LTD.', NULL, 'USD', 1, '', 79807, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#SVN||us||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('99 CENTS ONLY STORES', NULL, 'USD', 1, '', 79128, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#NDN||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('A & G MULTISELECTION FUND', 'ES0105012035', 'EUR', 2, '|f_es_BMF|', 77389, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0105012035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('A. H. BELO CORP. SERIES A', NULL, 'USD', 1, '', 81014, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AHC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('A. LATAM TOP', 'ES0105304002', 'EUR', 4, '', 78264, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0105304002||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AALBERTS INDUSTR', 'NL0000852564', 'EUR', 1, '|EURONEXT|', 77286, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0000852564||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AAMIGOO', 'CWN001011006', 'EUR', 1, '|EURONEXT|', 79091, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#CWN001011006||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AAP IMPLANTATE AG', 'DE0005066609', 'EUR', 1, '|DEUTSCHEBOERSE|', 80472, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005066609||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AAR CORP.', NULL, 'USD', 1, '', 78283, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AIR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AARDVARK INVEST', 'LU0111311071', 'EUR', 1, '|EURONEXT|', 76460, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#LU0111311071||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AAREAL BANK AG', 'DE0005408116', 'EUR', 1, '|DEUTSCHEBOERSE|', 78684, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005408116||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AAREAL BKCAP FD TR', 'XS0138973010', 'EUR', 1, '|EURONEXT|', 76640, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#XS0138973010||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AARON''S INC.', NULL, 'USD', 1, '', 81598, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AAN||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AB INBEV STR VVPR', 'BE0005582532', 'EUR', 1, '|EURONEXT|', 78104, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0005582532||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AB SCIENCE', 'FR0010557264', 'EUR', 1, '|EURONEXT|', 76642, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010557264||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ABANDO EQUITIES', 'ES0109656001', 'EUR', 2, '|f_es_BMF|', 74751, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0109656001||es||False', false, '{NULL,F000001W2L,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ABANTE ASESORES GLOBAL', 'ES0109652034', 'EUR', 2, '|f_es_BMF|', 78173, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0109652034||es||False', false, '{NULL,F0GBR04MZH,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ABANTE BOLSA ABSOLUTA CLASE I', 'ES0109655003', 'EUR', 2, '|f_es_BMF|', 78139, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0109655003||es||False', false, '{NULL,F0000040M3,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ABANTE BOLSA ABSOLUTA', 'ES0109655037', 'EUR', 2, '|f_es_BMF|', 78181, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0109655037||es||False', false, '{NULL,F0GBR05WNU,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ABANTE BOLSA', 'ES0105011037', 'EUR', 2, '|f_es_BMF|', 75162, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0105011037||es||False', false, '{NULL,F0GBR04MZD,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ABANTE PATRIMONIO GLOBAL CLASE I', 'ES0105013009', 'EUR', 2, '|f_es_BMF|', 78141, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0105013009||es||False', false, '{NULL,F0000040M2,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ABANTE PATRIMONIO GLOBAL', 'ES0105013033', 'EUR', 2, '|f_es_BMF|', 75812, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0105013033||es||False', false, '{NULL,F0GBR04H3S,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ABANTE RENTA', 'ES0162947032', 'EUR', 2, '|f_es_BMF|', 75001, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0162947032||es||False', false, '{NULL,F0GBR05WOC,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ABANTE RENTAB.ABSOLUTA CLASE I', 'ES0184837005', 'EUR', 2, '|f_es_BMF|', 78143, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0184837005||es||False', false, '{NULL,F000005ODZ,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ABANTE RENTABILIDAD ABSOLUTA', 'ES0184837039', 'EUR', 2, '|f_es_BMF|', 78144, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0184837039||es||False', false, '{NULL,F0GBR04GCF,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ABANTE SELECCION', 'ES0162946034', 'EUR', 2, '|f_es_BMF|', 78184, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0162946034||es||False', false, '{NULL,F0GBR04MZJ,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ABANTE TESORERIA', 'ES0190051039', 'EUR', 2, '|f_es_BMF|', 78188, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0190051039||es||False', false, '{NULL,F0GBR04MZB,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ABANTE VALOR', 'ES0190052037', 'EUR', 2, '|f_es_BMF|', 78189, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0190052037||es||False', false, '{NULL,F0GBR04OMT,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ABB LTD.', 'CH0012221716', 'USD', 1, '', 78545, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ABB||us||False', false, '{ABB,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ABBOTT LABORATORIES', 'US0028241000', 'USD', 1, '|SP500|', 76790, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ABT||us||False', false, '{ABT,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ABC ARBITRAGE', 'FR0004040608', 'EUR', 1, '|EURONEXT|', 77334, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0004040608||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ABENGOA B', 'ES0105200002', 'EUR', 1, '|MERCADOCONTINUO|', 81701, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, NULL, false, '{ABG-P.MC,NULL,BME:ABG-P,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ABENGOA', 'ES0105200416', 'EUR', 1, '|MERCADOCONTINUO|', 81093, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0105200416||es||False', false, '{ABG.MC,NULL,BME:ABG,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ABERCROMBIE & FITCH CO.', NULL, 'USD', 1, '|SP500|', 75638, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ANF||us||False', false, '{ANF,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ABERTIS INFRAESTRUCTURAS S.A.', 'ES0111845014', 'EUR', 1, '|MERCADOCONTINUO|', 78269, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0111845014||es||False', false, '{ABE.MC,NULL,BME:ABE,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ABITIBIBOWATER INC.', NULL, 'USD', 1, '', 76585, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ABH||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ABLYNX (D)', 'BE0003877942', 'EUR', 1, '|EURONEXT|', 76644, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003877942||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ABLYNX STR VVPR(D)', 'BE0005620910', 'EUR', 1, '|EURONEXT|', 78164, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0005620910||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ABM INDUSTRIES INC.', NULL, 'USD', 1, '', 77178, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ABM||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ABOVENET INC.', NULL, 'USD', 1, '', 81606, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ABVT||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AC ALPHA MULTIESTRATEGIA', 'ES0107292007', 'EUR', 2, '|f_es_BMF|', 74949, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0107292007||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AC CAPITAL 9 FI', 'ES0152281038', 'EUR', 2, '|f_es_BMF|', 74743, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0152281038||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('A.C. DINAMICO', 'ES0107383038', 'EUR', 2, '|f_es_BMF|', 78092, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0107383038||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AC EUROSTOXX GARANTIZADO 100', 'ES0107396006', 'EUR', 2, '|f_es_BMF|', 78190, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0107396006||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AC FONDEPOSITO PLUS', 'ES0114941034', 'EUR', 2, '|f_es_BMF|', 77467, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114941034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AC INVERSION FI', 'ES0107367007', 'EUR', 2, '|f_es_BMF|', 74762, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0107367007||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('A.C. RENTA FIJA EURO', 'ES0107516033', 'EUR', 2, '|f_es_BMF|', 74784, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0107516033||es||False', false, '{NULL,F0GBR04DUC,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ACACIA BONOMIX', 'ES0105243002', 'EUR', 2, '|f_es_BMF|', 78191, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0105243002||es||False', false, '{NULL,F00000M9L3,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ACACIA PREMIUM', 'ES0105263000', 'EUR', 2, '|f_es_BMF|', 78195, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0105263000||es||False', false, '{NULL,F00000M9L5,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ACACIA REINVERPLUS EUROPA', 'ES0157934003', 'EUR', 2, '|f_es_BMF|', 78210, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0157934003||es||False', false, '{NULL,F00000M9L4,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ACADIA REALTY TRUST', 'US0042391096', 'USD', 1, '', 78401, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AKR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ACANTHE DEV.', 'FR0000064602', 'EUR', 1, '|EURONEXT|', 76409, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000064602||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ACANTHEDEVBSAOCT11', 'FR0000346975', 'EUR', 1, '|EURONEXT|', 78221, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000346975||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ACAPITAL ESTRATEGIA GLOBAL', 'ES0105234001', 'EUR', 2, '|f_es_BMF|', 78229, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0105234001||es||False', false, '{NULL,F000000RI9,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ACAPITAL MIXTO', 'ES0105312005', 'EUR', 2, '|f_es_BMF|', 78235, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0105312005||es||False', false, '{NULL,F000000GQ1,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ACAPITAL TESORERIA DINAMICA', 'ES0105297008', 'EUR', 2, '|f_es_BMF|', 78237, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0105297008||es||False', false, '{NULL,F000000GQ0,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ACC IBEX INV', 'ES0105305009', 'EUR', 4, '', 78272, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0105305009||es||False', false, '{IBEXI.MC,NULL,BME:IBEXI,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ACC IBEX TOP', 'ES0105337002', 'EUR', 4, '', 78276, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0105337002||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ACC LBRA ETF', 'ES0105322004', 'EUR', 4, '', 81438, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0105322004||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ACCELL GROUP', 'NL0000350106', 'EUR', 1, '|EURONEXT|', 76126, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0000350106||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ACCELL GROUP', 'NL0009767532', 'EUR', 1, '|EURONEXT|', 79058, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0009767532||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ACCENTIS', 'BE0003696102', 'EUR', 1, '|EURONEXT|', 76410, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003696102||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ACCENTIS STRIP (D)', 'BE0005641155', 'EUR', 1, '|EURONEXT|', 78165, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0005641155||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ACCENTURE PLC CL A', 'BMG1150G1116', 'USD', 1, '|SP500|', 79256, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ACN||us||False', false, '{ACN,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ACC.ESTX.ETF', 'ES0105321030', 'EUR', 4, '', 81439, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0105321030||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ACC.IBEX ETF', 'ES0105336038', 'EUR', 4, '', 81440, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0105336038||es||False', false, '{BBVAI.MC,NULL,BME:BBVAI,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ACCIONA', 'ES0125220311', 'EUR', 1, '|IBEX|MERCADOCONTINUO|', 78281, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0125220311||es||False', false, '{ANA.MC,NULL,BME:ANA,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ACCO BRANDS CORP.', NULL, 'USD', 1, '', 80907, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ABD||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ACCOR', 'FR0000120404', 'EUR', 1, '|CAC|EURONEXT|', 77335, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000120404||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ACCOR NV', 'FR0010979682', 'EUR', 1, '|EURONEXT|', 76606, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010979682||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ACCRETIVE HEALTH INC.', 'US00438V1035', 'USD', 1, '', 79287, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AH||us||False', false, '{AH,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ACCSYS', 'GB00B0LMC530', 'EUR', 1, '|EURONEXT|', 77339, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#GB00B0LMC530||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ACCURIDE CORP.', 'US00439T2069', 'USD', 1, '', 79854, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ACW||us||False', false, '{ACW,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ACE LTD.', NULL, 'USD', 1, '|SP500|', 79262, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ACE||us||False', false, '{ACE,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ACERINOX', 'ES0132105018', 'EUR', 1, '|IBEX|MERCADOCONTINUO|', 78325, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0132105018||es||False', false, '{ACX.MC,NULL,BME:ACX,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ACKERMANS STRIP', 'BE0005562336', 'EUR', 1, '|EURONEXT|', 78168, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0005562336||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ACKERMANS V.HAAREN', 'BE0003764785', 'EUR', 1, '|EURONEXT|', 77340, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003764785||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ACORN INTERNATIONAL INC.', 'US0048541058', 'USD', 1, '', 80158, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ATV||us||False', false, '{ATV,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('A.C.RENTA FIJA EURO 1', 'ES0126524034', 'EUR', 2, '|f_es_BMF|', 74786, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0126524034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ACS', 'ES0167050915', 'EUR', 1, '|IBEX|MERCADOCONTINUO|', 78327, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0167050915||es||False', false, '{ACS.MC,NULL,BME:ACS,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ACTEOS', 'FR0000076861', 'EUR', 1, '|EURONEXT|', 79060, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000076861||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ACTIA GROUP', 'FR0000076655', 'EUR', 1, '|EURONEXT|', 76412, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000076655||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ACTIVE NETWORK INC.', NULL, 'USD', 1, '', 79947, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ACTV||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ACTIVISION BLIZZARD INC.', 'US00507V1098', 'USD', 1, '|NASDAQ100|', 77500, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'ATVI||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ACTUANT CORP. CL A', NULL, 'USD', 1, '', 79024, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ATU||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ACUITY BRANDS INC.', NULL, 'USD', 1, '', 80887, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AYI||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AD PEPPER MEDIA INTERNATIONAL N.V.', 'NL0000238145', 'EUR', 1, '|DEUTSCHEBOERSE|', 80473, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#NL0000238145||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ADC AFRICAN DEVELOPMENT CORP. GMBH & CO. KGAA', 'DE000A1E8NW9', 'EUR', 1, '|DEUTSCHEBOERSE|', 78364, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE000A1E8NW9||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ADC SIIC', 'FR0000065401', 'EUR', 1, '|EURONEXT|', 75487, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000065401||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ADCSIIC122014', 'FR0010561985', 'EUR', 1, '|EURONEXT|', 79835, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010561985||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ADECOAGRO S.A.', NULL, 'USD', 1, '', 79443, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AGRO||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ADIDAS AG', 'DE000A1EWWW0', 'EUR', 1, '|DEUTSCHEBOERSE|EUROSTOXX|', 80475, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE000A1EWWW0||de||False', false, '{ADS.DE,NULL,ETR:ADS,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ADL PARTNER', 'FR0000062978', 'EUR', 1, '|EURONEXT|', 77341, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000062978||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ADLER MODEMÄRKTE AG', 'DE000A1H8MU2', 'EUR', 1, '|DEUTSCHEBOERSE|', 80478, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE000A1H8MU2||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ADOBE SYSTEMS INCORPORATED', 'US00724F1012', 'USD', 1, '|NASDAQ100|SP500|', 77582, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'ADBE||us||False', false, '{ADBE,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ADOLFO DOMÍNGUEZ', 'ES0106000013', 'EUR', 1, '|MERCADOCONTINUO|', 81441, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0106000013||es||True', false, '{ADZ.MC,NULL,BME:ADZ,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ADP', 'FR0010340141', 'EUR', 1, '|EURONEXT|', 75328, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010340141||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ADT S.I.I.C.', 'FR0000064594', 'EUR', 1, '|EURONEXT|', 78791, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000064594||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ADVA AG OPTICAL NETWORKING', 'DE0005103006', 'EUR', 1, '|DEUTSCHEBOERSE|', 80480, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005103006||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ADVANCE AMERICA CASH ADVANCE CENTERS INC.', NULL, 'USD', 1, '', 77182, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AEA||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ADVANCE AUTO PARTS INC.', NULL, 'USD', 1, '', 76669, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AAP||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ADVANCED MICRO DEVICES INC.', 'US0079031078', 'USD', 1, '|SP500|', 75709, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AMD||us||False', false, '{AMD,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ADVANCED SEMICONDUCTOR ENGINEERING INC.', NULL, 'USD', 1, '', 76115, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ASX||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ADVANCED VISION TECHNOLOGY LTD.', 'IL0010837248', 'EUR', 1, '|DEUTSCHEBOERSE|', 80481, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#IL0010837248||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ADVANTAGE OIL & GAS LTD.', NULL, 'USD', 1, '', 78246, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AAV||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ADVANTEST CORP.', NULL, 'USD', 1, '', 75769, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ATE||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ADVEO GROUP INTERNATIONAL', 'ES0182045312', 'EUR', 1, '|MERCADOCONTINUO|', 81700, NULL, NULL, NULL, NULL, 100, 'c', 2, 1, NULL, false, '{ADV.MC,NULL,BME:ADV,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ADVINI', 'FR0000053043', 'EUR', 1, '|EURONEXT|', 78796, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000053043||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AECOM TECHNOLOGY CORP.', NULL, 'USD', 1, '', 76480, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ACM||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AEDIAN', 'FR0004005924', 'EUR', 1, '|EURONEXT|', 75330, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0004005924||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AEDIFICA', 'BE0003851681', 'EUR', 1, '|EURONEXT|', 75337, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003851681||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AEGEAN MARINE PETROLEUM NETWORK INC.', NULL, 'USD', 1, '', 80999, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ANW||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AEGON INVERSION MF', 'ES0147614038', 'EUR', 2, '|f_es_BMF|', 78316, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147614038||es||False', false, '{NULL,F0GBR04QAW,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AEGON INVERSION MV', 'ES0147616033', 'EUR', 2, '|f_es_BMF|', 78317, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147616033||es||False', false, '{NULL,F0GBR04PU1,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AEGON', 'NL0000303709', 'EUR', 1, '', 75341, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'AGN.AS||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AEGON N.V.', NULL, 'USD', 1, '', 77902, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AEG||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AENA S.A.', 'ES0105046009 ', 'EUR', 1, '|IBEX|MERCADOCONTINUO|', 81704, 'http://www.aena.es', NULL, NULL, NULL, 100, 'c', 1, 1, NULL, false, '{AENA.MC,NULL,BME:AENA,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AERCAP HOLDINGS N.V.', NULL, 'USD', 1, '', 75604, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AER||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AEROFLEX HOLDING CORP.', NULL, 'USD', 1, '', 80960, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ARX||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AEROPOSTALE INC.', NULL, 'USD', 1, '', 81613, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ARO||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AES CHEMUNEX', 'FR0010158642', 'EUR', 1, '|EURONEXT|', 79086, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010158642||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AES CORP.', NULL, 'USD', 1, '|SP500|', 77384, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AES||us||False', false, '{AES,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AETNA INC.', 'US00817Y1082', 'USD', 1, '|SP500|', 76739, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AET||us||False', false, '{AET,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AFFILIATED MANAGERS GROUP INC.', NULL, 'USD', 1, '', 79222, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AMG||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AFFINE', 'FR0000036105', 'EUR', 1, '|EURONEXT|', 75340, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000036105||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AFFIPARIS DS', 'FR0011132992', 'EUR', 1, '|EURONEXT|', 75250, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0011132992||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AFFIPARIS', 'FR0010148510', 'EUR', 1, '|EURONEXT|', 78797, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010148510||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AFI BONS ETF', 'ES0106061007', 'EUR', 4, '', 81442, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0106061007||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AFI MONE ETF', 'ES0106078001', 'EUR', 4, '', 81443, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0106078001||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AFLAC INC.', 'US0010551028', 'USD', 1, '|SP500|', 75829, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AFL||us||False', false, '{AFL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AFONE', 'FR0000044612', 'EUR', 1, '|EURONEXT|', 77727, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000044612||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('A.F.P. PROVIDA S.A.', NULL, 'USD', 1, '', 78340, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#PVD||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AG DIP WORLD EQUITIES FUND', 'ES0109657009', 'EUR', 2, '|f_es_BMF|', 75878, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0109657009||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AG MORTGAGE INVESTMENT TRUST INC.', NULL, 'USD', 1, '', 80969, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#MITT||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('A&G TESORERIA', 'ES0156873004', 'EUR', 2, '|f_es_BMF|', 78091, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0156873004||es||False', false, '{NULL,F000001GJA,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AGCO CORP.', NULL, 'USD', 1, '', 76328, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AGCO||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AGEAS (EX-FORTIS)', 'BE0003801181', 'EUR', 1, '|EURONEXT|', 74759, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003801181||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AGEAS STRIP VVPR', 'BE0005591624', 'EUR', 1, '|EURONEXT|', 76413, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0005591624||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AGENNIX AG', 'DE000A1A6XX4', 'EUR', 1, '|DEUTSCHEBOERSE|', 80482, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE000A1A6XX4||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AGFA STRIP VVPR(D)', 'BE0005638128', 'EUR', 1, '|EURONEXT|', 76416, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0005638128||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AGFA-GEVAERT', 'BE0003755692', 'EUR', 1, '|EURONEXT|', 76645, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003755692||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AGILENT TECHNOLOGIES INC.', 'US00846U1016', 'USD', 1, '|SP500|', 79703, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#A||us||False', false, '{A,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AGL RESOURCES INC.', NULL, 'USD', 1, '|SP500|', 75559, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GAS||us||False', false, '{GAS,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AGNICO-EAGLE MINES LTD.', NULL, 'USD', 1, '', 78819, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AEM||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AGREE REALTY CORP.', NULL, 'USD', 1, '', 79832, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ADC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AGRIA CORP.', NULL, 'USD', 1, '', 80596, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GRO||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AGRICOLE CRAU', 'FR0000062176', 'EUR', 1, '|EURONEXT|', 79837, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000062176||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AGRIUM INC.', NULL, 'USD', 1, '', 78174, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AGU||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AGTA RECORD', 'CH0008853209', 'EUR', 1, '|EURONEXT|', 77472, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#CH0008853209||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AHLERS AG ST', 'DE0005009708', 'EUR', 1, '|DEUTSCHEBOERSE|', 75513, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005009708||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AHLERS AG VZ', 'DE0005009732', 'EUR', 1, '|DEUTSCHEBOERSE|', 75674, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005009732||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AHOLD KON', 'NL0006033250', 'EUR', 1, '|EUROSTOXX|', 74791, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'AH.AS||None||False', false, '{AH.AS,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AHORRO CORP. ACCIONES', 'ES0107472039', 'EUR', 2, '|f_es_BMF|', 78318, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0107472039||es||False', false, '{NULL,F0GBR04DTU,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AHORRO CORP. AUSTRALASIA', 'ES0107491039', 'EUR', 2, '|f_es_BMF|', 76884, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0107491039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AHORRO CORP. CAPITAL 1', 'ES0106941034', 'EUR', 2, '|f_es_BMF|', 78351, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0106941034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AHORRO CORP. CAPITAL 6', 'ES0107432033', 'EUR', 2, '|f_es_BMF|', 78403, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0107432033||es||False', false, '{NULL,F0GBR04DU6,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AHORRO CORP. CUENTA FONDT.C.P.', 'ES0107519037', 'EUR', 2, '|f_es_BMF|', 78405, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0107519037||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AHORRO CORP. DEUDA FONDT. L.P.', 'ES0107521033', 'EUR', 2, '|f_es_BMF|', 77493, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0107521033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AHORRO CORP. EUROACCIONES', 'ES0106943030', 'EUR', 2, '|f_es_BMF|', 75496, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0106943030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AHORRO CORP. EUROMIX', 'ES0106925037', 'EUR', 2, '|f_es_BMF|', 78406, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0106925037||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AHORRO CORP. EUROPA', 'ES0107492037', 'EUR', 2, '|f_es_BMF|', 78418, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0107492037||es||False', false, '{NULL,F0GBR04DUL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AHORRO CORP. EUROSTOXX 50 INDICE', 'ES0107365035', 'EUR', 2, '|f_es_BMF|', 78419, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0107365035||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AHORRO CORP. FONDANDALUCIA MIXTO', 'ES0107384036', 'EUR', 2, '|f_es_BMF|', 78442, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0107384036||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AHORRO CORP. FONDTESORO PLUS', 'ES0107481030', 'EUR', 2, '|f_es_BMF|', 77478, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0107481030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AHORRO CORP. FONDT.LARGO PLAZO', 'ES0107531032', 'EUR', 2, '|f_es_BMF|', 78450, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0107531032||es||False', false, '{NULL,F0GBR04DUZ,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AHORRO CORP. IBEROAMERICA', 'ES0107474035', 'EUR', 2, '|f_es_BMF|', 78452, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0107474035||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AHORRO CORP. IBEX-35 INDICE', 'ES0107262034', 'EUR', 2, '|f_es_BMF|', 78453, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0107262034||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AHORRO CORP. RESPONSABLE 30', 'ES0107387039', 'EUR', 2, '|f_es_BMF|', 78456, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0107387039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AHORRO CORP.EURIBOR MAS 50 GAR.2', 'ES0107534036', 'EUR', 2, '|f_es_BMF|', 78458, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0107534036||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AHORRO CORP.INVERSION SELEC.MODE', 'ES0106928031', 'EUR', 2, '|f_es_BMF|', 78484, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0106928031||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AHORRO CORP.INVERSION SELECTIVA', 'ES0106949037', 'EUR', 2, '|f_es_BMF|', 78485, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0106949037||es||False', false, '{NULL,F0GBR0557F,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AHORRO CORPORACION BONOS FINANCI', 'ES0107369003', 'EUR', 2, '|f_es_BMF|', 75184, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0107369003||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AHORRO CORPORACION CONSERV.VAR 3', 'ES0106951033', 'EUR', 2, '|f_es_BMF|', 78463, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0106951033||es||False', false, '{NULL,F0000001UH,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AHORRO CORPORACION DOLAR', 'ES0107436034', 'EUR', 2, '|f_es_BMF|', 78462, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0107436034||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AHORRO CORPORACION EURIBOR+50 G', 'ES0107368005', 'EUR', 2, '|f_es_BMF|', 78529, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0107368005||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AHORRO CORPORACION EURO IBEX GAR', 'ES0107366033', 'EUR', 2, '|f_es_BMF|', 75314, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0107366033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AHORRO CORPORACION FONDEPOSITO', 'ES0106933031', 'EUR', 2, '|f_es_BMF|', 78530, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0106933031||es||False', false, '{NULL,F0GBR06U3E,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AHORRO CORPORACION IBEX AÑO 1', 'ES0114815030', 'EUR', 2, '|f_es_BMF|', 74814, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114815030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AHORRO CORPORACION MODER.VAR 7', 'ES0107393037', 'EUR', 2, '|f_es_BMF|', 78519, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0107393037||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AHORRO CORPORACION MONETARIO', 'ES0107437008', 'EUR', 2, '|f_es_BMF|', 78534, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0107437008||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AHORRO CORPORACION PATRIMONIO IN', 'ES0106929039', 'EUR', 2, '|f_es_BMF|', 76677, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0106929039||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AHORRO CORPORACION PLAZO RENT. 3', 'ES0106931035', 'EUR', 2, '|f_es_BMF|', 78535, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0106931035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AHORRO CORPORACION RF EURO 2', 'ES0155841036', 'EUR', 2, '|f_es_BMF|', 78536, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0155841036||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AHORRO CORP.PLAZO GARANTIZADO', 'ES0107397004', 'EUR', 2, '|f_es_BMF|', 78497, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0107397004||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AHORRO CORP.STAND.&POOR''S 500 IN', 'ES0106927033', 'EUR', 2, '|f_es_BMF|', 78501, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0106927033||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AHORROFONDO 20', 'ES0107475032', 'EUR', 2, '|f_es_BMF|', 75449, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0107475032||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AHORROFONDO', 'ES0107512032', 'EUR', 2, '|f_es_BMF|', 75443, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0107512032||es||False', false, '{NULL,F0GBR04DVB,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AIR BERLIN PLC', 'GB00B128C026', 'EUR', 1, '|DEUTSCHEBOERSE|', 78367, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#GB00B128C026||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AIR FRANCE -KLM', 'FR0000031122', 'EUR', 1, '|EURONEXT|', 76649, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000031122||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AIR LEASE CORP.', NULL, 'USD', 1, '', 79003, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AL||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AIR LIQUIDE', 'FR0000120073', 'EUR', 1, '|CAC|EURONEXT|EUROSTOXX|', 76651, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000120073||fr||False', false, '{AI.PA,NULL,EPA:AI,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AIR PRODUCTS & CHEMICALS INC.', NULL, 'USD', 1, '|SP500|', 76897, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#APD||us||False', false, '{APD,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AIRBUS GROUP', 'NL0000235190', 'EUR', 1, '|CAC|EUROSTOXX|', 81702, 'https://www.airbus.com/', NULL, NULL, NULL, 100, 'c', 1, 3, NULL, false, '{AIR.PA,NULL,EPA:AIR,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AIRBUS GROUP', 'NL0000235190', 'EUR', 1, '|MERCADOCONTINUO|', 81699, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, NULL, false, '{AIR.MC,NULL,BME:AIR,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AIRCASTLE LTD.', NULL, 'USD', 1, '', 79545, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AYR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AIRE GMBH & CO. KGAA', 'DE0006344211', 'EUR', 1, '|DEUTSCHEBOERSE|', 78424, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0006344211||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AIRGAS INC.', 'US0093631028', 'USD', 1, '|SP500|', 77134, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ARG||us||False', false, '{ARG,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AIRTRAN HOLDINGS INC.', NULL, 'USD', 1, '', 75526, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AAI||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AISA', 'ES0106585013', 'EUR', 1, '|MERCADOCONTINUO|', 78328, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0106585013||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AIXTRON SE', 'DE000A0WMPJ6', 'EUR', 1, '|DEUTSCHEBOERSE|', 78445, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE000A0WMPJ6||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AJAX', 'NL0000018034', 'EUR', 1, '|EURONEXT|', 77484, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0000018034||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AK STEEL HOLDING CORP.', NULL, 'USD', 1, '', 78151, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AKS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AKKA TECH. BSAAR', 'FR0010575563', 'EUR', 1, '|EURONEXT|', 79838, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010575563||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AKKA TECHNOLOGIES', 'FR0004180537', 'EUR', 1, '|EURONEXT|', 77681, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0004180537||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AKZO NOBEL', 'NL0000009132', 'EUR', 1, '|EURONEXT|', 77682, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0000009132||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALAMO GROUP INC.', NULL, 'USD', 1, '', 80353, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ALG||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALANHERI', 'NL0000440022', 'EUR', 1, '|EURONEXT|', 77599, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0000440022||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALASKA AIR GROUP INC.', NULL, 'USD', 1, '', 78919, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ALK||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALBANY INTERNATIONAL CORP. CL A', NULL, 'USD', 1, '', 79448, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AIN||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALBEMARLE CORP.', NULL, 'USD', 1, '', 77688, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ALB||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALBERTO-CULVER CO.', NULL, 'USD', 1, '', 77381, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ACV||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALCALA AHORRO', 'ES0107696033', 'EUR', 2, '|f_es_BMF|', 75460, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0107696033||es||False', false, '{NULL,F0GBR04J02,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALCALA BOLSA', 'ES0107692032', 'EUR', 2, '|f_es_BMF|', 75431, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0107692032||es||False', false, '{NULL,F0GBR04J04,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALCALA GLOBAL', 'ES0107693030', 'EUR', 2, '|f_es_BMF|', 75433, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0107693030||es||False', false, '{NULL,F0GBR04J06,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALCALA-UNO', 'ES0107703037', 'EUR', 2, '|f_es_BMF|', 78595, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0107703037||es||False', false, '{NULL,F0GBR04J01,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALCATEL LUCENT', 'FR0000130007', 'EUR', 1, '|CAC|', 74895, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'ALU.PA||fr||False', false, '{ALU.PA,NULL,EPA:ALU,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALCATEL LUCENT NV', 'FR0010985861', 'EUR', 1, '|EURONEXT|', 77598, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010985861||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALCATEL-LUCENT', NULL, 'USD', 1, '', 77831, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ALU||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALCOA INC.', 'US0138171014', 'USD', 1, '|SP500|', 79310, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AA||us||False', false, '{AA,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALDETA', 'FR0000036634', 'EUR', 1, '|EURONEXT|', 75505, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000036634||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALDIDE S.A.', NULL, 'EUR', 1, '', -32, '', '', '', '', 100, 'c', 1, 1, 'ALDIDE||es||True', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALEO SOLAR AKTIENGESELLSCHAFT', 'DE000A0JM634', 'EUR', 1, '|DEUTSCHEBOERSE|', 78601, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE000A0JM634||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALERE INC.', NULL, 'USD', 1, '', 77128, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ALR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALEXANDER & BALDWIN INC.', NULL, 'USD', 1, '', 78726, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ALEX||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALEXANDER''S INC.', NULL, 'USD', 1, '', 78013, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ALX||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALEXANDRIA REAL ESTATE EQUITIES INC.', NULL, 'USD', 1, '', 75124, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ARE||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALFA OMEGA', 'ES0107934038', 'EUR', 2, '|f_es_BMF|', 77099, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0107934038||es||False', false, '{NULL,F0GBR05V3B,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALFA, S.A.B. DE C.V.', 'MXP000511016', 'EUR', 1, '|LATIBEX|', 81444, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#MXP000511016||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALFACAM GROUP', 'BE0003868859', 'EUR', 1, '|EURONEXT|', 79095, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003868859||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALFIL CAPITAL GLOBAL', 'ES0115066039', 'EUR', 2, '|f_es_BMF|', 77100, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115066039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALFIL CAPITAL RENTABILIDAD ABSOL', 'ES0107954036', 'EUR', 2, '|f_es_BMF|', 77105, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0107954036||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALFIL FONTOTAL', 'ES0107955009', 'EUR', 2, '|f_es_BMF|', 77304, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0107955009||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALHAMBRA', 'ES0108207038', 'EUR', 2, '|f_es_BMF|', 77329, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0108207038||es||False', false, '{NULL,F0GBR04DIV,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALL FOR ONE MIDMARKET AG', 'DE0005110001', 'EUR', 1, '|DEUTSCHEBOERSE|', 80514, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005110001||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALLEGHANY CORP.', NULL, 'USD', 1, '', 77874, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#Y||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALLEGHENY TECHNOLOGIES INC.', NULL, 'USD', 1, '|SP500|', 76981, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ATI||us||False', false, '{ATI,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALLERGAN INC.', NULL, 'USD', 1, '|SP500|', 75971, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AGN||us||False', false, '{AGN,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALLETE INC.', NULL, 'USD', 1, '', 81612, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ALE||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALLIANCE DATA SYSTEMS CORP.', NULL, 'USD', 1, '', 76673, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ADS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALLIANCE HEALTHCARE SERVICES INC.', NULL, 'USD', 1, '', 81066, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AIQ||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALLIANCE ONE INTERNATIONAL INC.', NULL, 'USD', 1, '', 79811, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AOI||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALLIANT ENERGY CORP.', NULL, 'USD', 1, '', 77121, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#LNT||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALLIANT TECHSYSTEMS INC.', NULL, 'USD', 1, '', 78981, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ATK||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALLIANZ BOLSA', 'ES0108372030', 'EUR', 2, '|f_es_BMF|', 77371, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0108372030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALLIANZ MIXTO', 'ES0108280035', 'EUR', 2, '|f_es_BMF|', 77372, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0108280035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALLIANZ RENTA FIJA AHORRO', 'ES0108371032', 'EUR', 2, '|f_es_BMF|', 77378, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0108371032||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALLIANZ RF CORTO EUROLAND', 'ES0108251036', 'EUR', 2, '|f_es_BMF|', 77388, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0108251036||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALLIANZ SE', 'DE0008404005', 'EUR', 1, '|DAX|DEUTSCHEBOERSE|EUROSTOXX|', 80515, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0008404005||de||False', false, '{ALV.DE,NULL,ETR:ALV,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALLIANZ SELECCION CONSERVADOR', 'ES0108341035', 'EUR', 2, '|f_es_BMF|', 77402, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0108341035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALLIANZ SELECCION EMPRENDEDOR', 'ES0108291032', 'EUR', 2, '|f_es_BMF|', 74854, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0108291032||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALLIANZ SELECCION MODERADO', 'ES0108276033', 'EUR', 2, '|f_es_BMF|', 74812, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0108276033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALLIED IRISH BANKS PLC', NULL, 'USD', 1, '', 75894, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AIB||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALLIED WORLD ASSURANCE CO. HOLDINGS LTD.', NULL, 'USD', 1, '', 78949, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AWH||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALLSTATE CORP.', NULL, 'USD', 1, '|SP500|', 76264, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ALL||us||False', false, '{ALL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALMIRALL', 'ES0157097017', 'EUR', 1, '|MERCADOCONTINUO|', 78333, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0157097017||es||False', false, '{ALM.MC,NULL,BME:ALM,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALON HOLDINGS-BLUE SQUARE-ISRAEL LTD.', NULL, 'USD', 1, '', 80492, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BSI||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALON USA ENERGY INC.', NULL, 'USD', 1, '', 81013, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ALJ||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALPES (COMPAGNIE)', 'FR0000053324', 'EUR', 1, '|EURONEXT|', 79464, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000053324||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALPHA M.O.S. BS', 'FR0011073915', 'EUR', 1, '|EURONEXT|', 75440, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0011073915||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALPHA M.O.S. DS', 'FR0011073907', 'EUR', 1, '|EURONEXT|', 78194, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0011073907||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALPHA MOS', 'FR0000062804', 'EUR', 1, '|EURONEXT|', 79096, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000062804||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALPHA NATURAL RESOURCES INC.', NULL, 'USD', 1, '', 76135, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ANR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALPHA PLUS DIVERSIFICACION CLASE B, FI', 'ES0108701014', 'EUR', 2, '|f_es_BMF|', 74958, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0108701014||es||False', false, '{NULL,F00000J75P,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALPHA PLUS DIVERSIFICACION', 'ES0108701006', 'EUR', 2, '|f_es_BMF|', 74819, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0108701006||es||False', false, '{NULL,F000002JPP,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALPHA PLUS RENTA FIJA EURO CORTO PLAZO B', 'ES0108686017', 'EUR', 2, '|f_es_BMF|', 78611, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0108686017||es||False', false, '{NULL,F00000GZW2,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALPHA PLUS RENTABILIDAD ABSO. CLASE B', 'ES0108702012', 'EUR', 2, '|f_es_BMF|', 78615, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0108702012||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALPHA PLUS RENTABILIDAD ABSOLUTA', 'ES0108702004', 'EUR', 2, '|f_es_BMF|', 78616, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0108702004||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALPHAFORM AG', 'DE0005487953', 'EUR', 1, '|DEUTSCHEBOERSE|', 80516, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005487953||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALPHAVILLE', 'ES0108703002', 'EUR', 2, '|f_es_BMF|', 74997, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0108703002||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALSTOM', 'FR0010220475', 'EUR', 1, '|CAC|EURONEXT|', 78172, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010220475||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALSTOM NV', 'FR0010978791', 'EUR', 1, '|EURONEXT|', 75901, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010978791||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALSTRIA OFFICE REIT-AG', 'DE000A0LD2U1', 'EUR', 1, '|DEUTSCHEBOERSE|', 80517, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE000A0LD2U1||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALTADIS', NULL, 'EUR', 1, '', 74945, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ALTADIS||es||True', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALTAE BOLSA ACTIVA', 'ES0177041037', 'EUR', 2, '|f_es_BMF|', 76609, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0177041037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALTAE BOLSA', 'ES0108846033', 'EUR', 2, '|f_es_BMF|', 76596, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0108846033||es||False', false, '{NULL,F0GBR04K0I,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALTAE BRICC', 'ES0113308037', 'EUR', 2, '|f_es_BMF|', 76611, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113308037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALTAE CESTA ASIÁTICA FI', 'ES0108848039', 'EUR', 2, '|f_es_BMF|', 74768, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0108848039||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALTAE CESTA ESPAÑOLA', 'ES0108847031', 'EUR', 2, '|f_es_BMF|', 75814, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0108847031||es||False', true, '{NULL,F0GBR04KJ8,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALTAE DEUDA SOBERANA CP', 'ES0108740004', 'EUR', 2, '|f_es_BMF|', 75776, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0108740004||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALTAE DINERO', 'ES0108901036', 'EUR', 2, '|f_es_BMF|', 75797, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0108901036||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALTAE DOBLE GARANTIA', 'ES0108849037', 'EUR', 2, '|f_es_BMF|', 75800, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0108849037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALTAE EURIBOR MAS GARANTIZADO', 'ES0108834005', 'EUR', 2, '|f_es_BMF|', 75283, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0108834005||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALTAE INDICE S&P 500', 'ES0108851033', 'EUR', 2, '|f_es_BMF|', 75288, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0108851033||es||False', false, '{NULL,F0GBR04K0E,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALTAE INSTITUCIONES', 'ES0108903032', 'EUR', 2, '|f_es_BMF|', 75291, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0108903032||es||False', false, '{NULL,F0GBR04OOF,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALTAE PLUS', 'ES0177042035', 'EUR', 2, '|f_es_BMF|', 77425, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0177042035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALTAE PRIVATE EQUITY INDEX FI', 'ES0163027008', 'EUR', 2, '|f_es_BMF|', 74773, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0163027008||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALTAMIR AMBOISE', 'FR0000053837', 'EUR', 1, '|EURONEXT|', 79466, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000053837||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALTAREA', 'FR0000033219', 'EUR', 1, '|EURONEXT|', 76420, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000033219||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALTAREIT', 'FR0000039216', 'EUR', 1, '|EURONEXT|', 79467, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000039216||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALTEN', 'FR0000071946', 'EUR', 1, '|EURONEXT|', 78180, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000071946||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALTERA CORPORATION', 'US0214411003', 'USD', 1, '|NASDAQ100|SP500|', 77552, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'ALTR||us||False', false, '{ALTR,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALTRAN TECHN.', 'FR0000034639', 'EUR', 1, '|EURONEXT|', 78910, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000034639||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALTRAN TECHNOLOGIES', NULL, 'EUR', 1, '', 74892, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'ATC.DE||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALTRI SGPS', 'PTALT0AE0002', 'EUR', 1, '|EURONEXT|', 78182, NULL, NULL, NULL, NULL, 100, 'c', 1, 9, 'EURONEXT#PTALT0AE0002||pt||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALTRIA GROUP INC.', NULL, 'USD', 1, '|SP500|', 77344, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#MO||us||False', false, '{MO,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALUMINA LTD.', NULL, 'USD', 1, '', 78517, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AWC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ALUMINUM CORP. OF CHINA LTD.', NULL, 'USD', 1, '', 77594, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ACH||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('A.M. CASTLE & CO.', NULL, 'USD', 1, '', 81652, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CAS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AMADEUS', 'ES0109067019', 'EUR', 1, '|EUROSTOXX|IBEX|MERCADOCONTINUO|', 78334, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0109067019||es||False', false, '{AMS.MC,NULL,BME:AMS,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AMADEUS FIRE AG', 'DE0005093108', 'EUR', 1, '|DEUTSCHEBOERSE|', 78603, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005093108||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AMAZON.COM INC.', 'US0231351067', 'USD', 1, '|NASDAQ100|SP500|', 76081, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'AMZN||us||False', false, '{AMZN,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AMB PROPERTY CORP.', NULL, 'USD', 1, '', 76042, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AMB||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AMBOW EDUCATION HOLDING LTD.', NULL, 'USD', 1, '', 80152, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AMBO||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AMCOL INTERNATIONAL CORP.', NULL, 'USD', 1, '', 77327, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ACO||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AMDOCS LTD.', NULL, 'USD', 1, '', 76296, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DOX||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AMEREN CORP.', NULL, 'USD', 1, '|SP500|', 75462, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AEE||us||False', false, '{AEE,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AMERESCO INC. CL A', NULL, 'USD', 1, '', 80957, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AMRC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AMERICA M. L', 'MXP001691213', 'EUR', 1, '|LATIBEX|', 78381, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#MXP001691213||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AMERICA MOVIL S.A.B. DE C.V.', NULL, 'USD', 1, '', 77349, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AMX||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AMERICAN ASSETS TRUST INC.', NULL, 'USD', 1, '', 77893, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AAT||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AMERICAN AXLE & MANUFACTURING HOLDINGS INC.', NULL, 'USD', 1, '', 78598, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AXL||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AMERICAN CAMPUS COMMUNITIES INC.', NULL, 'USD', 1, '', 75271, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ACC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AMERICAN EAGLE OUTFITTERS INC.', NULL, 'USD', 1, '', 77390, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AEO||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AMERICAN ELECTRIC POWER CO. INC.', NULL, 'USD', 1, '|SP500|', 75973, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AEP||us||False', false, '{AEP,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AMERICAN EQUITY INVESTMENT LIFE HOLDING CO.', NULL, 'USD', 1, '', 79441, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AEL||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AMERICAN EXPRESS CO.', NULL, 'USD', 1, '|SP500|', 78083, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AXP||us||False', false, '{AXP,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AMERICAN FINANCIAL GROUP INC.', NULL, 'USD', 1, '', 76566, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AFG||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AMERICAN GREETINGS CORP. CL A', NULL, 'USD', 1, '', 79620, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AM||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AMERICAN INTERNATIONAL GROUP INC.', NULL, 'USD', 1, '|SP500|', 77376, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AIG||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AMERICAN ORIENTAL BIOENGINEERING INC.', NULL, 'USD', 1, '', 80533, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AOB||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AMERICAN REALTY INVESTORS INC.', NULL, 'USD', 1, '', 78162, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ARL||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AMERICAN REPROGRAPHICS CO.', NULL, 'USD', 1, '', 79889, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ARC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AMERICAN SAFETY INSURANCE HOLDINGS LTD.', NULL, 'USD', 1, '', 80962, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ASI||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AMERICAN STATES WATER CO.', NULL, 'USD', 1, '', 80895, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AWR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AMERICAN TOWER REIT', NULL, 'USD', 1, '|SP500|', 79213, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AMT||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AMERICAN VANGUARD CORP.', NULL, 'USD', 1, '', 79777, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AVD||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AMERICAN WATER WORKS CO.', NULL, 'USD', 1, '', 76295, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AWK||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AMERIGROUP CORP.', NULL, 'USD', 1, '', 76771, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AGP||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AMERIPRISE FINANCIAL INC.', NULL, 'USD', 1, '|SP500|', 79214, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AMP||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AMERISOURCEBERGEN CORP.', NULL, 'USD', 1, '|SP500|', 75325, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ABC||us||False', false, '{ABC,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AMERON INTERNATIONAL CORP.', NULL, 'USD', 1, '', 78275, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AMN||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AMETEK INC.', NULL, 'USD', 1, '', 78837, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AME||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AMG', 'NL0000888691', 'EUR', 1, '|EURONEXT|', 77292, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0000888691||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AMGEN INC.', 'US0311621009', 'USD', 1, '|NASDAQ100|SP500|', 77440, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'AMGN||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AMISTRA GLOBAL, FI', 'ES0109213001', 'EUR', 2, '|f_es_BMF|', 77427, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0109213001||es||False', false, '{NULL,F00000J3T4,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AMISTRA PATRIMONIAL', 'ES0109214009', 'EUR', 2, '|f_es_BMF|', 75190, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0109214009||es||False', false, '{NULL,F00000LL48,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AMN HEALTHCARE SERVICES INC.', NULL, 'USD', 1, '', 80963, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AHS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AMPCO-PITTSBURGH CORP.', NULL, 'USD', 1, '', 80047, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AP||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AMPER', 'ES0109260531', 'EUR', 1, '|MERCADOCONTINUO|', 78383, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0109260531||es||False', false, '{AMP.MC,NULL,BME:AMP,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AMPHENOL CORP. CL A', NULL, 'USD', 1, '|SP500|', 76603, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#APH||us||False', false, '{APH,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AMR CORP.', NULL, 'USD', 1, '', 80433, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AMR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AMREP CORP.', NULL, 'USD', 1, '', 78899, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AXR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AMSTERDAM COMMOD.', 'NL0000313286', 'EUR', 1, '|EURONEXT|', 76423, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0000313286||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AMT HOLDING', 'NL0000886968', 'EUR', 1, '|EURONEXT|', 75403, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0000886968||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AMUNDI CASH CORPORATE IC', 'FR0010251660', 'EUR', 2, '|f_cat_money|', 81717, NULL, NULL, NULL, NULL, 0, 'c', 1, 3, NULL, false, '{NULL,F0GBR06QIE,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AMUNDI CORTO PLAZO, CLASE I', 'ES0126542036', 'EUR', 2, '|f_es_BMF|', 78654, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0126542036||es||False', false, '{NULL,F0GBR04Q4H,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AMUNDI FDS II MULTI-STRAT GR A EUR ND', 'LU0363629790', 'EUR', 2, '', 81726, NULL, NULL, NULL, NULL, 0, 'c', 1, 18, NULL, false, '{NULL,F0000022V6,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AMUNDI MULTIESTRATEGIA ALT.', 'ES0118556002', 'EUR', 2, '|f_es_BMF|', 74863, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0118556002||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ANADARKO PETROLEUM CORP.', NULL, 'USD', 1, '|SP500|', 76738, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#APC||us||False', false, '{APC,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ANALOG DEVICES INC.', NULL, 'USD', 1, '|SP500|', 79379, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ADI||us||False', false, '{ADI,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ANALYTIK JENA AG', 'DE0005213508', 'EUR', 1, '|DEUTSCHEBOERSE|', 78597, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005213508||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AND INTERNATIONAL', 'NL0000430106', 'EUR', 1, '|EURONEXT|', 75404, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0000430106||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ANF IMMOBILIER', 'FR0000063091', 'EUR', 1, '|EURONEXT|', 75378, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000063091||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ANGLOGOLD ASH CERT', 'BE0088072930', 'EUR', 1, '|EURONEXT|', 79093, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0088072930||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ANGLOGOLD ASHANTI LTD.', NULL, 'USD', 1, '', 79339, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AU||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ANGLOGOLD ASHANTI', 'ZAE000043485', 'EUR', 1, '|EURONEXT|', 79089, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#ZAE000043485||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ANHEUS.-BUSCH INBEV', 'BE0003793107', 'EUR', 1, '|EUROSTOXX|', 77627, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'ABI.BR||be||False', false, '{ABI.BR,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ANHEUSER-BUSCH INBEV N.V.', NULL, 'USD', 1, '', 76821, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BUD||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ANIXTER INTERNATIONAL INC.', NULL, 'USD', 1, '', 78979, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AXE||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ANN INC.', NULL, 'USD', 1, '', 76919, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ANN||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ANNALY CAPITAL MANAGEMENT INC.', NULL, 'USD', 1, '', 76896, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#NLY||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ANNUALCYCLES STRATEGIES', 'ES0109298002', 'EUR', 2, '|f_es_BMF|', 78656, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0109298002||es||False', false, '{NULL,F00000JYM0,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ANOVO', 'FR0010698217', 'EUR', 1, '|EURONEXT|', 76435, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010698217||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ANTONOV', 'GB00B3SHND79', 'EUR', 1, '|EURONEXT|', 75826, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#GB00B3SHND79||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ANWORTH MORTGAGE ASSET CORP.', NULL, 'USD', 1, '', 78444, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ANH||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('A.O. SMITH CORP.', NULL, 'USD', 1, '', 78805, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AOS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AOL INC.', NULL, 'USD', 1, '', 79108, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AOL||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AON CORPORATION', NULL, 'USD', 1, '|SP500|', 75872, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AON||us||False', false, '{AON,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AP ALTERNAT ASSETS', 'GB00B15Y0C52', 'EUR', 1, '|EURONEXT|', 75749, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#GB00B15Y0C52||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('APACHE CORPORATION', NULL, 'USD', 1, '|SP500|', 77211, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#APA||us||False', false, '{APA,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('APARTMENT INVESTMENT & MANAGEMENT CO.', NULL, 'USD', 1, '|SP500|', 77301, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AIV||us||False', false, '{AIV,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('APERAM', 'LU0569974404', 'EUR', 1, '|EURONEXT|', 78912, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#LU0569974404||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('APERAM', 'LU0569974404', 'EUR', 1, '|MERCADOCONTINUO|', 78346, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#LU0569974404||es||False', false, '{APAM.MC,NULL,BME:APAM,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('APOLLO COMMERCIAL REAL ESTATE FINANCE INC.', NULL, 'USD', 1, '', 79981, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ARI||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('APOLLO GROUP INC.', 'US0376041051', 'USD', 1, '|NASDAQ100|SP500|', 76217, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'APOL||us||False', false, '{APOL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('APOLLO RESIDENTIAL MORTGAGE INC.', NULL, 'USD', 1, '', 80428, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AMTG||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('APPLE INC.', 'US0378331005', 'USD', 1, '|NASDAQ100|SP500|', 77578, NULL, NULL, NULL, NULL, 100, 'c', 1, 17, 'AAPL||us||False', false, '{AAPL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('APPLIED INDUSTRIAL TECHNOLOGIES INC.', NULL, 'USD', 1, '', 76822, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AIT||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('APPLIED MATERIALS INC.', 'US0382221051', 'USD', 1, '|NASDAQ100|SP500|', 75748, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'AMAT||us||False', false, '{AMAT,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('APPLUS SERVICES S.A.', 'ES0105022000', 'EUR', 1, '|MERCADOCONTINUO|', 81690, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, NULL, false, '{APPS.MC,NULL,BME:APPS,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('APRIL', 'FR0004037125', 'EUR', 1, '|EURONEXT|', 75827, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0004037125||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('APRR', 'FR0006807004', 'EUR', 1, '|EURONEXT|', 79509, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0006807004||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('APTARGROUP INC.', NULL, 'USD', 1, '', 76555, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ATR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AQUA AMERICA INC.', NULL, 'USD', 1, '', 78528, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#WTR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ARBITRON INC.', NULL, 'USD', 1, '', 78157, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ARB||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ARBOR REALTY TRUST INC.', NULL, 'USD', 1, '', 80214, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ABR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ARCADIS', 'NL0006237562', 'EUR', 1, '|EURONEXT|', 77696, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0006237562||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ARCALIA BOLSA', 'ES0142552035', 'EUR', 2, '|f_es_BMF|', 78657, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0142552035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ARCALIA COYUNTURA', 'ES0110085034', 'EUR', 2, '|f_es_BMF|', 78659, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0110085034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ARCALIA GARANTIZADO RENTA FIJA', 'ES0156732002', 'EUR', 2, '|f_es_BMF|', 78196, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0156732002||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ARCALIA GLOBAL', 'ES0110086032', 'EUR', 2, '|f_es_BMF|', 78660, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0110086032||es||False', false, '{NULL,F0GBR04PY3,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ARCALIA INTERES', 'ES0138913035', 'EUR', 2, '|f_es_BMF|', 75825, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138913035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ARCALIA SELECCION', 'ES0142343039', 'EUR', 2, '|f_es_BMF|', 78661, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0142343039||es||False', false, '{NULL,F0GBR04J5K,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ARCANO EUROPEAN INC.CL D1', 'ES0109924029', 'EUR', 2, '|f_es_BMF|', 74811, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0109924029||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ARCANO EUROPEAN INCOME F. FIL A1 ', 'ES0109924003', 'EUR', 2, '|f_es_BMF|', 74810, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0109924003||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ARCELORMITTAL', 'LU0323134006', 'EUR', 1, '|CAC|', 78915, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#LU0323134006||nl||False', false, '{MT.AS,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ARCELORMITTAL', 'LU1598757687', 'EUR', 1, '|IBEX|MERCADOCONTINUO|', 81101, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#LU0323134006||es||False', false, '{MTS.MC,NULL,BME:MTS,NULL,MTS}', false, 2);
INSERT INTO public.products VALUES ('ARCELORMITTAL', NULL, 'USD', 1, '', 74767, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#MT||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ARCH CHEMICALS INC.', NULL, 'USD', 1, '', 79501, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ARJ||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ARCH COAL INC.', NULL, 'USD', 1, '', 76390, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ACI||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ARCHER DANIELS MIDLAND CO.', NULL, 'USD', 1, '|SP500|', 78110, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ADM||us||False', false, '{ADM,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ARCHOS DS', 'FR0011037357', 'EUR', 1, '|EURONEXT|', 75159, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0011037357||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ARCHOS', 'FR0000182479', 'EUR', 1, '|EURONEXT|', 80354, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000182479||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ARCOS DORADOS HOLDINGS INC. CL A', NULL, 'USD', 1, '', 78554, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ARCO||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AREVA ADPCI', 'FR0010986190', 'EUR', 1, '|EURONEXT|', 74753, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010986190||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AREVA CI', 'FR0004275832', 'EUR', 1, '|EURONEXT|', 77433, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0004275832||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AREVA CI', 'FR0011035195', 'EUR', 1, '|EURONEXT|', 74963, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0011035195||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AREVA', 'FR0011027143', 'EUR', 1, '|EURONEXT|', 79510, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0011027143||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ARGAN', 'FR0010481960', 'EUR', 1, '|EURONEXT|', 78185, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010481960||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ARKEMA', 'FR0010313833', 'EUR', 1, '|EURONEXT|', 77731, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010313833||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ARKEMA NV', 'FR0010979476', 'EUR', 1, '|EURONEXT|', 77258, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010979476||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ARKEMA NV', 'FR0011169804', 'EUR', 1, '|EURONEXT|', 77293, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0011169804||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ARLINGTON ASSET INVESTMENT CORP. CL A', NULL, 'USD', 1, '', 81001, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AI||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ARMOUR RESIDENTIAL REIT INC.', NULL, 'USD', 1, '', 80896, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ARR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ARMSTRONG WORLD INDUSTRIES INC.', NULL, 'USD', 1, '', 79327, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AWI||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ARROW ELECTRONICS INC.', NULL, 'USD', 1, '', 76349, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ARW||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ARSEUS (D)', 'BE0003874915', 'EUR', 1, '|EURONEXT|', 79512, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003874915||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ARSEUS ST VVPR (D)', 'BE0005617882', 'EUR', 1, '|EURONEXT|', 75489, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0005617882||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ARSEUS TEMP.(D)', 'BE0380320805', 'EUR', 1, '|EURONEXT|', 77738, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0380320805||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ARTE FINANCIERO', 'ES0110276039', 'EUR', 2, '|f_es_BMF|', 75437, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0110276039||es||False', false, '{NULL,F0GBR04JK5,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ARTHUR', 'FR0004166155', 'EUR', 1, '|EURONEXT|', 76466, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#FR0004166155||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ARTHUR J. GALLAGHER & CO.', NULL, 'USD', 1, '', 76183, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AJG||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ARTIO GLOBAL INVESTORS INC. CL A', NULL, 'USD', 1, '', 80119, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ART||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ARTNET AG', 'DE0006909500', 'EUR', 1, '|DEUTSCHEBOERSE|', 78961, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0006909500||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ARTNET AG', 'DE000A1K0375', 'EUR', 1, '|DEUTSCHEBOERSE|', 78604, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE000A1K0375||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ARTOIS NOM.', 'FR0000076952', 'EUR', 1, '|EURONEXT|', 74820, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000076952||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ARTPRICE COM', 'FR0000074783', 'EUR', 1, '|EURONEXT|', 77735, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000074783||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('A.S. CRÉATION TAPETEN AG', 'DE0005079909', 'EUR', 1, '|DEUTSCHEBOERSE|', 78363, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005079909||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ASBURY AUTOMOTIVE GROUP INC.', NULL, 'USD', 1, '', 77744, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ABG||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('A.S.C. GLOBAL', 'ES0114223037', 'EUR', 2, '|f_es_BMF|', 78093, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114223037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ASCENCIO (D)', 'BE0003856730', 'EUR', 1, '|EURONEXT|', 78994, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003856730||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ASHFORD HOSPITALITY TRUST INC.', NULL, 'USD', 1, '', 76881, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AHT||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ASHLAND INC.', NULL, 'USD', 1, '', 76144, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ASH||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ASIAN BAMBOO AG', 'DE000A0M6M79', 'EUR', 1, '|DEUTSCHEBOERSE|', 78610, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE000A0M6M79||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ASM INTERNATIONAL', 'NL0000334118', 'EUR', 1, '|EURONEXT|', 75154, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0000334118||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ASML HOLDING', 'NL0006034001', 'EUR', 1, '|EURONEXT|EUROSTOXX|', 74785, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0006034001||nl||False', false, '{ASML.AS,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ASPEN INSURANCE HOLDINGS LTD.', NULL, 'USD', 1, '', 78987, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AHL||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ASSISTED LIVING CONCEPTS INC. CL A', NULL, 'USD', 1, '', 79855, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ALC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ASSOCIATED ESTATES REALTY CORP.', NULL, 'USD', 1, '', 79548, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AEC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ASSURANT INC.', NULL, 'USD', 1, '|SP500|', 77739, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AIZ||us||False', false, '{AIZ,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ASSURED GUARANTY LTD.', NULL, 'USD', 1, '', 78934, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AGO||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ASSYSTEM BSAR 0713', 'FR0010356535', 'EUR', 1, '|EURONEXT|', 78999, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010356535||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ASSYSTEM', 'FR0000074148', 'EUR', 1, '|EURONEXT|', 79920, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000074148||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ASSYSTEMBSAARJUL15', 'FR0010630590', 'EUR', 1, '|EURONEXT|', 80051, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010630590||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ASSYSTEMBSAR2012', 'FR0010166371', 'EUR', 1, '|EURONEXT|', 79061, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010166371||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('A.S.T. GROUPE', 'FR0000076887', 'EUR', 1, '|EURONEXT|', 79053, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000076887||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ASTORIA FINANCIAL CORP.', NULL, 'USD', 1, '', 79498, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AF||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ASTRAZENECA PLC', NULL, 'USD', 1, '', 78630, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AZN||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ASTURFONDO AHORRO', 'ES0111037034', 'EUR', 2, '|f_es_BMF|', 75498, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0111037034||es||False', false, '{NULL,F0GBR04ITP,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ASTURFONDO DINERO', 'ES0111046035', 'EUR', 2, '|f_es_BMF|', 75499, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0111046035||es||False', false, '{NULL,F0GBR04ITL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ASTURFONDO DINERO PLATINUM', 'ES0110929033', 'EUR', 2, '|f_es_BMF|', 75801, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0110929033||es||False', false, '{NULL,F0GBR0601D,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ASTURFONDO EUROBOLSA GARANTIZADO', 'ES0111023034', 'EUR', 2, '|f_es_BMF|', 75832, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0111023034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ASTURFONDO GLOBAL', 'ES0110952035', 'EUR', 2, '|f_es_BMF|', 78692, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0110952035||es||False', false, '{NULL,F0GBR04IUB,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ASTURFONDO MIX-RENTA FIJA', 'ES0111028033', 'EUR', 2, '|f_es_BMF|', 78694, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0111028033||es||False', false, '{NULL,F0GBR04ITR,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ASTURFONDO MIX-RENTA VARIABLE', 'ES0111029031', 'EUR', 2, '|f_es_BMF|', 78695, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0111029031||es||False', false, '{NULL,F0GBR04IU9,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ASTURFONDO PLAZO II', 'ES0111013035', 'EUR', 2, '|f_es_BMF|', 78696, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0111013035||es||False', false, '{NULL,F0GBR04IUF,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ASTURFONDO RENTA VARIABLE ESPAÑA', 'ES0111038032', 'EUR', 2, '|f_es_BMF|', 76641, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0111038032||es||False', false, '{NULL,F0GBR04ITX,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ASTURFONDO RENTA VARIABLE EURO', 'ES0111011039', 'EUR', 2, '|f_es_BMF|', 76654, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0111011039||es||False', false, '{NULL,F0GBR04ITZ,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ASTURFONDO RENTAS', 'ES0111049039', 'EUR', 2, '|f_es_BMF|', 76655, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0111049039||es||False', false, '{NULL,F0GBR04ITN,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ATARI BSA 31/12/12', 'FR0010690099', 'EUR', 1, '|EURONEXT|', 77295, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010690099||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ATARI', 'FR0010478248', 'EUR', 1, '|EURONEXT|', 79923, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010478248||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ATENOR GROUP (D)', 'BE0003837540', 'EUR', 1, '|EURONEXT|', 79542, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003837540||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ATENOR STRIP (D)', 'BE0005602736', 'EUR', 1, '|EURONEXT|', 75545, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0005602736||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ATLANTIC POWER CORP.', NULL, 'USD', 1, '', 79344, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AT||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ATLAS CAP.CARTERA DINAMICA CLASE A', 'ES0111127009', 'EUR', 2, '|f_es_BMF|', 74908, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0111127009||es||False', false, '{NULL,F000000PWZ,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ATLAS CAPITAL BEST MANAGERS', 'ES0111171031', 'EUR', 2, '|f_es_BMF|', 75624, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0111171031||es||False', false, '{NULL,F0GBR0614W,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ATLAS CAPITAL BOLSA', 'ES0111151009', 'EUR', 2, '|f_es_BMF|', 75835, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0111151009||es||False', false, '{NULL,F000000PX0,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ATLAS CAPITAL CARTERA DINAMICA, CLASE I', 'ES0111127017', 'EUR', 2, '|f_es_BMF|', 75844, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0111127017||es||False', false, '{NULL,F00000MAA1,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ATLAS CAPITAL CRECIMIENTO', 'ES0111118032', 'EUR', 2, '|f_es_BMF|', 75846, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0111118032||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ATLAS CAPITAL LIQUIDEZ ACTIVA', 'ES0111166031', 'EUR', 2, '|f_es_BMF|', 75853, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0111166031||es||False', false, '{NULL,F0GBR06155,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ATLAS CAPITAL PATRIMONIO', 'ES0111167005', 'EUR', 2, '|f_es_BMF|', 74827, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0111167005||es||False', false, '{NULL,F000000PX1,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ATLAS CAPITAL RENTA FIJA', 'ES0111168003', 'EUR', 2, '|f_es_BMF|', 76656, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0111168003||es||False', false, '{NULL,F000002L68,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ATLAS RENTA DE INVERSIONES', 'ES0111200038', 'EUR', 2, '|f_es_BMF|', 75859, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0111200038||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ATMEL CORP.', 'US0495131049', 'EUR', 1, '|EURONEXT|', 76498, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#US0495131049||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ATMOS ENERGY CORP.', NULL, 'USD', 1, '', 77305, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ATO||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ATOS', 'FR0000051732', 'EUR', 1, '|EURONEXT|', 79925, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000051732||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ATOS ORIGIN NV', 'FR0010979658', 'EUR', 1, '|EURONEXT|', 75194, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010979658||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ATOSS SOFTWARE AG', 'DE0005104400', 'EUR', 1, '|DEUTSCHEBOERSE|', 78619, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005104400||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ATRESMEDIA CORP. DE MEDIOS DE COM. S.A.', 'ES0109427734', 'EUR', 1, '|MERCADOCONTINUO|', 78384, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0109427734||es||False', false, '{A3M.MC,NULL,BME:A3M,NULL,A3M.MC}', false, 2);
INSERT INTO public.products VALUES ('ATRIUM EUR REALEST', 'JE00B3DCF752', 'EUR', 1, '|EURONEXT|', 77698, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#JE00B3DCF752||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AT&T INC.', NULL, 'USD', 1, '|SP500|', 79502, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#T||us||False', false, '{T,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ATTIJARIWAFA BANK', 'MA0000011827', 'EUR', 1, '|EURONEXT|', 76500, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#MA0000011827||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ATWOOD OCEANICS INC.', NULL, 'USD', 1, '', 76438, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ATW||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AU OPTRONICS CORP.', NULL, 'USD', 1, '', 77159, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AUO||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AUBAY', 'FR0000063737', 'EUR', 1, '|EURONEXT|', 76045, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000063737||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AUDIKA GROUPE', 'FR0000063752', 'EUR', 1, '|EURONEXT|', 79934, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000063752||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AUFEMININ.COM', 'FR0004042083', 'EUR', 1, '|EURONEXT|', 79936, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0004042083||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AUGROS COSMETICS', 'FR0000061780', 'EUR', 1, '|EURONEXT|', 76511, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000061780||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AUGUSTA TECHNOLOGIE AG', 'DE000A0D6612', 'EUR', 1, '|DEUTSCHEBOERSE|', 78635, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE000A0D6612||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AUREA', 'FR0000039232', 'EUR', 1, '|EURONEXT|', 75379, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000039232||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AURES TECHNOLOGIES', 'FR0000073827', 'EUR', 1, '|EURONEXT|', 77699, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000073827||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AURICO GOLD INC.', NULL, 'USD', 1, '', 77424, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AUQ||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AURUBIS AG', 'DE0006766504', 'EUR', 1, '|DEUTSCHEBOERSE|', 78637, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0006766504||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AUSY', 'FR0000072621', 'EUR', 1, '|EURONEXT|', 79962, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000072621||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AUSYBSA15OCT15', 'FR0010505941', 'EUR', 1, '|EURONEXT|', 77703, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010505941||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AUSYBSAAR20OCT16', 'FR0010805366', 'EUR', 1, '|EURONEXT|', 80166, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010805366||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AUTODESK, INC.', 'US0527691069', 'USD', 1, '|NASDAQ100|SP500|', 76082, NULL, NULL, NULL, NULL, 100, 'c', 1, 17, 'ADSK||us||False', false, '{ADSK,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AUTOLIV INC.', NULL, 'USD', 1, '', 78054, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ALV||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AUTOMATIC DATA PROCESSING, INC.', 'US0530151036', 'USD', 1, '|NASDAQ100|SP500|', 77430, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'ADP||us||False', false, '{ADP,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AUTONATION INC.', NULL, 'USD', 1, '|SP500|', 76920, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AN||us||False', false, '{AN,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AUTOSTRADA', 'IT0000084027', 'EUR', 1, '', 74893, NULL, NULL, NULL, NULL, 100, 'c', 1, 6, 'AT.MI||None||False', false, '{AT.MI,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AUTOZONE INC.', NULL, 'USD', 1, '|SP500|', 78646, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AZO||us||False', false, '{AZO,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AUX.FERROCAR', 'ES0121975017', 'EUR', 1, '|MERCADOCONTINUO|', 81102, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0121975017||es||False', false, '{CAF.MC,NULL,BME:CAF,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AVALONBAY COMMUNITIES INC.', NULL, 'USD', 1, '|SP500|', 74873, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AVB||us||False', false, '{AVB,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AVANCE GLOBAL', 'ES0112340031', 'EUR', 2, '|f_es_BMF|', 76657, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0112340031||es||False', false, '{NULL,F0GBR04CAH,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AVANQUEST SOFTWARE', 'FR0004026714', 'EUR', 1, '|EURONEXT|', 78216, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0004026714||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AVENIR FINANCE', 'FR0004152874', 'EUR', 1, '|EURONEXT|', 80168, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0004152874||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AVENIR TELECOM', 'FR0000066052', 'EUR', 1, '|EURONEXT|', 78223, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000066052||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AVERY DENNISON CORP.', NULL, 'USD', 1, '|SP500|', 77274, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AVY||us||False', false, '{AVY,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AVIAT LATECOERE BS', 'FR0010910562', 'EUR', 1, '|EURONEXT|', 77296, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010910562||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AVIATION LATECOERE', 'FR0000032278', 'EUR', 1, '|EURONEXT|', 78228, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000032278||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AVILA GARANTIA UNO', 'ES0112297033', 'EUR', 2, '|f_es_BMF|', 75334, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0112297033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AVISTA CORP.', NULL, 'USD', 1, '', 75770, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AVA||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AVIVA CORTO PLAZO  CLASE A', 'ES0170156006', 'EUR', 2, '|f_es_BMF|', 74855, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0170156006||es||False', false, '{NULL,F00000H0P4,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AVIVA CORTO PLAZO', 'ES0170156030', 'EUR', 2, '|f_es_BMF|', 75558, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0170156030||es||False', false, '{NULL,F0GBR04JYA,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AVIVA ESPABOLSA 2', 'ES0112357035', 'EUR', 2, '|f_es_BMF|', 76707, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0112357035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AVIVA ESPABOLSA', 'ES0170147039', 'EUR', 2, '|f_es_BMF|', 76704, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0170147039||es||False', false, '{NULL,F0GBR04JYE,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AVIVA EUROBOLSA 2', 'ES0112351038', 'EUR', 2, '|f_es_BMF|', 76745, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0112351038||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AVIVA EUROBOLSA', 'ES0170141032', 'EUR', 2, '|f_es_BMF|', 76888, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0170141032||es||False', false, '{NULL,F0GBR04JYK,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AVIVA FONVALOR EURO  CLASE A', 'ES0170136008', 'EUR', 2, '|f_es_BMF|', 76746, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0170136008||es||False', false, '{NULL,F00000H0P5,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AVIVA GESTION GLOBAL', 'ES0170136032', 'EUR', 2, '|f_es_BMF|', 76787, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0170136032||es||False', false, '{NULL,F0GBR04JYG,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AVIVA INVESTORS STERLING LIQUIDITY FUND 1 GBP INC', 'IE0031619269', 'GBP', 2, '|f_cat_money|', 81716, NULL, NULL, NULL, NULL, 0, 'c', 1, 4, NULL, true, '{NULL,F0GBR06KUK,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AVIVA PLC', NULL, 'USD', 1, '', 78507, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AV||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AVIVA RENTA FIJA  CLASE A', 'ES0170138004', 'EUR', 2, '|f_es_BMF|', 76793, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0170138004||es||False', false, '{NULL,F00000H0P6,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AVIVA RENTA FIJA', 'ES0170138038', 'EUR', 2, '|f_es_BMF|', 76789, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0170138038||es||False', false, '{NULL,F0GBR04JYI,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AVNET INC.', NULL, 'USD', 1, '', 77030, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AVT||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AVON PRODUCTS INC.', 'US0543031027', 'USD', 1, '|SP500|', 75944, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AVP||us||False', false, '{AVP,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AVX CORP.', NULL, 'USD', 1, '', 76008, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AVX||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AXA', 'FR0000120628', 'EUR', 1, '|CAC|EURONEXT|EUROSTOXX|', 78231, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000120628||fr||False', false, '{CS.PA,NULL,EPA:CS,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AXEL SPRINGER AG', 'DE0005501357', 'EUR', 1, '|DEUTSCHEBOERSE|', 78641, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005501357||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AXIS CAPITAL HOLDINGS LTD.', NULL, 'USD', 1, '', 76408, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AXS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AXWAY SOFTWARE DS', 'FR0011070135', 'EUR', 1, '|EURONEXT|', 78101, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0011070135||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AXWAY SOFTWARE', 'FR0011040500', 'EUR', 1, '|EURONEXT|', 76263, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0011040500||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AYG SYZ LOW VOLATILITY IICIICIL', 'ES0112191004', 'EUR', 2, '|f_es_BMF|', 74774, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0112191004||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AYG SYZ MULTISTRATEGY', 'ES0184954008', 'EUR', 2, '|f_es_BMF|', 74986, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0184954008||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AZKOYEN', 'ES0112458312', 'EUR', 1, '|MERCADOCONTINUO|', 78398, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0112458312||es||False', false, '{AZK.MC,NULL,BME:AZK,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('AZZ INC.', NULL, 'USD', 1, '', 77979, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AZZ||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('B Y P EUROPA', 'ES0118537002', 'EUR', 2, '|f_es_BMF|', 76795, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0118537002||es||False', false, '{NULL,F00000HLG8,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BA. BRADESCO', 'BRBBDCACNPR8', 'EUR', 1, '|LATIBEX|', 78399, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#BRBBDCACNPR8||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BAAN', 'NL0000336352', 'EUR', 1, '|EURONEXT|', 78211, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0000336352||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BABCOCK & WILCOX CO.', NULL, 'USD', 1, '', 76702, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BWC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BAC MAJESTIC', 'FR0010973487', 'EUR', 1, '|EURONEXT|', 79105, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010973487||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BACCARAT', 'FR0000064123', 'EUR', 1, '|EURONEXT|', 79964, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000064123||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BADGER METER INC.', NULL, 'USD', 1, '', 79643, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BMI||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BAIDU INC.', 'US0567521085', 'USD', 1, '|NASDAQ100|', 77602, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'BIDU||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BAINS MER MONACO', 'MC0000031187', 'EUR', 1, '|EURONEXT|', 79966, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#MC0000031187||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BAKER HUGHES INC.', 'US0572241075', 'USD', 1, '|SP500|', 76650, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BHI||us||False', false, '{BHI,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BALDA AG', 'DE0005215107', 'EUR', 1, '|DEUTSCHEBOERSE|', 78648, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005215107||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BALL CORP.', 'US0584981064', 'USD', 1, '|SP500|', 78830, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BLL||us||False', false, '{BLL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BALLAST NEDAM', 'NL0000336543', 'EUR', 1, '|EURONEXT|', 79967, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0000336543||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BALLY TECHNOLOGIES INC.', NULL, 'USD', 1, '', 75373, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BYI||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BALTIC TRADING LTD.', NULL, 'USD', 1, '', 80217, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BALT||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BAM CONV.PREF', 'NL0000337335', 'EUR', 1, '|EURONEXT|', 78214, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0000337335||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BAM GROEP KON', 'NL0000337319', 'EUR', 1, '|EURONEXT|', 79968, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0000337319||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BAM NON CONV PREF', 'NL0000337327', 'EUR', 1, '|EURONEXT|', 78213, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0000337327||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BAN RSWARR 10JUN15', 'BE0974254832', 'EUR', 1, '|EURONEXT|', 79107, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0974254832||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCA CIVICA  ACCIONES', 'ES0165537038', 'EUR', 2, '|f_es_BMF|', 74925, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0165537038||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCA CIVICA AHORRO 1', 'ES0165530033', 'EUR', 2, '|f_es_BMF|', 74929, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0165530033||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCA CIVICA AHORRO 31', 'ES0165526031', 'EUR', 2, '|f_es_BMF|', 75126, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0165526031||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCA CIVICA AVANZA', 'ES0165545031', 'EUR', 2, '|f_es_BMF|', 75860, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0165545031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCA CIVICA CONFIANZA', 'ES0173438039', 'EUR', 2, '|f_es_BMF|', 78699, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0173438039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCA CIVICA CONSERVADOR VAR 3', 'ES0115651004', 'EUR', 2, '|f_es_BMF|', 74936, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115651004||es||False', false, '{NULL,F00000JO2S,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCA CIVICA', 'ES0148873005', 'EUR', 1, '', 81110, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0148873005||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCA CIVICA EUROPA', 'ES0133572034', 'EUR', 2, '|f_es_BMF|', 75676, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133572034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCA CIVICA FLOTANTE GARANTIZADO I', 'ES0165528003', 'EUR', 2, '|f_es_BMF|', 74938, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0165528003||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCA CIVICA FLOTANTE GARANTIZADO II', 'ES0165546039', 'EUR', 2, '|f_es_BMF|', 74937, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0165546039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCA CIVICA GARANTIZADO ACCIONES I', 'ES0115660005', 'EUR', 2, '|f_es_BMF|', 76815, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115660005||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCA CIVICA GARANTIZADO EUROSTOXX II', 'ES0115732002', 'EUR', 2, '|f_es_BMF|', 75084, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115732002||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCA CIVICA GESTION 15', 'ES0165547037', 'EUR', 2, '|f_es_BMF|', 76786, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0165547037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCA CIVICA GESTION 30', 'ES0165533037', 'EUR', 2, '|f_es_BMF|', 76791, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0165533037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCA CIVICA GESTION 50', 'ES0138853033', 'EUR', 2, '|f_es_BMF|', 75523, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138853033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCA CIVICA IMPULSO', 'ES0165541030', 'EUR', 2, '|f_es_BMF|', 78857, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0165541030||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCA CIVICA INDEX', 'ES0148213038', 'EUR', 2, '|f_es_BMF|', 78872, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0148213038||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCA CIVICA MONETARIO', 'ES0165549009', 'EUR', 2, '|f_es_BMF|', 78877, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0165549009||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCA CIVICA PREMIUM', 'ES0115690036', 'EUR', 2, '|f_es_BMF|', 78913, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115690036||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCA CIVICA PREMIUM RENDIMIENTO CLASE A', 'ES0115716005', 'EUR', 2, '|f_es_BMF|', 75525, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115716005||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCA CIVICA PREMIUM RENDIMIENTO CLASE B', 'ES0115716013', 'EUR', 2, '|f_es_BMF|', 75881, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115716013||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCA CIVICA PREMIUM RENDIMIENTO II CL.A', 'ES0115709000', 'EUR', 2, '|f_es_BMF|', 75883, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115709000||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCA CIVICA PREMIUM REVALORIZACION', 'ES0115715007', 'EUR', 2, '|f_es_BMF|', 75889, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115715007||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCA CIVICA PRIMIUM RENDIMIENT.CL.B', 'ES0115709018', 'EUR', 2, '|f_es_BMF|', 75892, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115709018||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCA CIVICA PROGRESO', 'ES0126530031', 'EUR', 2, '|f_es_BMF|', 75893, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0126530031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCA CIVICA SOLIDO GARANTIZADO IV', 'ES0115717003', 'EUR', 2, '|f_es_BMF|', 76844, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115717003||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCA CIVICA TIPO GARANTIZADO I', 'ES0115710008', 'EUR', 2, '|f_es_BMF|', 75886, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115710008||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCAJA BRIC NUEVOS DESAFIOS', 'ES0112889037', 'EUR', 2, '|f_es_BMF|', 75919, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0112889037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCAJA CONSTRUCCION', 'ES0127794032', 'EUR', 2, '|f_es_BMF|', 78704, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0127794032||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCAJA DIVIDENDOS', 'ES0112952033', 'EUR', 2, '|f_es_BMF|', 78732, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0112952033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCAJA ENERGIA Y COMUNICACIONES', 'ES0130026034', 'EUR', 2, '|f_es_BMF|', 78778, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0130026034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCAJA EUROPA FINANCIERO', 'ES0112942034', 'EUR', 2, '|f_es_BMF|', 74960, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0112942034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCAJA FONDO DE FONDOS EMERGENT', 'ES0130352034', 'EUR', 2, '|f_es_BMF|', 77807, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0130352034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCAJA GARANT.10', 'ES0112972031', 'EUR', 2, '|f_es_BMF|', 77808, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0112972031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCAJA GARANTIZA. GLOBAL TITANS', 'ES0130353032', 'EUR', 2, '|f_es_BMF|', 78470, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0130353032||es||False', false, '{NULL,F0GBR054EX,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCAJA GARANTIZADO 12', 'ES0112964038', 'EUR', 2, '|f_es_BMF|', 77812, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0112964038||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCAJA GARANTIZADO 13', 'ES0112965001', 'EUR', 2, '|f_es_BMF|', 78488, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0112965001||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCAJA GARANTIZADO 14', 'ES0112894037', 'EUR', 2, '|f_es_BMF|', 78785, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0112894037||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCAJA GARANTIZADO 15', 'ES0112966009', 'EUR', 2, '|f_es_BMF|', 78787, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0112966009||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCAJA GARANTIZADO 16', 'ES0140999030', 'EUR', 2, '|f_es_BMF|', 78789, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0140999030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCAJA GARANTIZADO 18', 'ES0112895034', 'EUR', 2, '|f_es_BMF|', 78790, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0112895034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCAJA GARANTIZADO 19', 'ES0112967007', 'EUR', 2, '|f_es_BMF|', 76845, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0112967007||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCAJA GARANTIZADO II', 'ES0112963030', 'EUR', 2, '|f_es_BMF|', 76846, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0112963030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCAJA GARANTIZADO R.VARIABLE 8', 'ES0112897030', 'EUR', 2, '|f_es_BMF|', 76847, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0112897030||es||False', false, '{NULL,F0GBR06U7J,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCAJA GARANT.RENTA VARIABLE 7', 'ES0112896032', 'EUR', 2, '|f_es_BMF|', 77811, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0112896032||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCAJA GESTION ACTIVA 30', 'ES0112902038', 'EUR', 2, '|f_es_BMF|', 78774, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0112902038||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCAJA GESTION ACTIVA 60', 'ES0112962032', 'EUR', 2, '|f_es_BMF|', 78780, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0112962032||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCAJA GESTION ACTIVA 90', 'ES0112893039', 'EUR', 2, '|f_es_BMF|', 78783, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0112893039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCAJA GESTION DIRECCIONAL 100', 'ES0137572030', 'EUR', 2, '|f_es_BMF|', 76858, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137572030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCAJA GESTION DIRECCIONAL 30', 'ES0137501039', 'EUR', 2, '|f_es_BMF|', 75017, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137501039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCAJA GESTION DIRECCIONAL 60', 'ES0138001039', 'EUR', 2, '|f_es_BMF|', 75062, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138001039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCAJA INTERES I', 'ES0116973035', 'EUR', 2, '|f_es_BMF|', 75044, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0116973035||es||False', false, '{NULL,F0GBR04Q3Z,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCAJA INTERES II', 'ES0116974033', 'EUR', 2, '|f_es_BMF|', 75091, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0116974033||es||False', false, '{NULL,F0GBR04E18,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCAJA INTERES III', 'ES0113044038', 'EUR', 2, '|f_es_BMF|', 75530, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113044038||es||False', false, '{NULL,F0GBR04FMA,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCAJA INTERES PRINCIPAL', 'ES0141173031', 'EUR', 2, '|f_es_BMF|', 75532, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0141173031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCAJA LIQUIDEZ DEUDA PUBLICA', 'ES0112899002', 'EUR', 2, '|f_es_BMF|', 75542, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0112899002||es||False', false, '{NULL,F00000201H,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCAJA RENTA FIJA CORTO PLAZO', 'ES0112954039', 'EUR', 2, '|f_es_BMF|', 76837, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0112954039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCAJA RENTA FIJA DOLAR', 'ES0138894037', 'EUR', 2, '|f_es_BMF|', 75924, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138894037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCAJA RENTA FIJA', 'ES0138844032', 'EUR', 2, '|f_es_BMF|', 76835, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138844032||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCAJA RENTA FIJA MIXTA', 'ES0112977030', 'EUR', 2, '|f_es_BMF|', 75938, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0112977030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCAJA RENTA VARIABLE EE.UU.', 'ES0112978038', 'EUR', 2, '|f_es_BMF|', 76848, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0112978038||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCAJA RENTA VARIABLE', 'ES0113002036', 'EUR', 2, '|f_es_BMF|', 75939, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113002036||es||False', false, '{NULL,F0GBR04E16,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCAJA RENTA VARIABLE EURO', 'ES0112961034', 'EUR', 2, '|f_es_BMF|', 76915, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0112961034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCAJA RENTA VARIABLE MIXTA', 'ES0116980030', 'EUR', 2, '|f_es_BMF|', 76945, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0116980030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCAJA SMALL&MID CAPS', 'ES0112979036', 'EUR', 2, '|f_es_BMF|', 75940, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0112979036||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCO BILBAO VIZCAYA ARGENTARIA S.A.', NULL, 'USD', 1, '', 79038, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BBVA||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCO BPI', 'PTBPI0AM0004', 'EUR', 1, '|EURONEXT|', 79971, NULL, NULL, NULL, NULL, 100, 'c', 1, 9, 'EURONEXT#PTBPI0AM0004||pt||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCO CHILE', 'CLP0939W1081', 'EUR', 1, '', 78407, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#CLP0939W1081||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCO DE CHILE', NULL, 'USD', 1, '', 75834, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BCH||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCO DE SABADELL', 'ES0113860A34', 'EUR', 1, '|IBEX|MERCADOCONTINUO|', 81104, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0113860A34||es||False', false, '{SAB.MC,NULL,BME:SAB,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCO LATINOAMERICANO DE COMERCIO EXTERIOR S.A. CL E', NULL, 'USD', 1, '', 78200, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BLX||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCO MACRO S.A.', NULL, 'USD', 1, '', 78409, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BMA||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCO POP.ESPANOL', 'ES0113790531', 'EUR', 1, '|EURONEXT|', 79164, NULL, NULL, NULL, NULL, 100, 'c', 1, 9, 'EURONEXT#ES0113790531||pt||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCO POPULAR', 'ES0113790531', 'EUR', 1, '|MERCADOCONTINUO|', 81103, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0113790531||es||False', true, '{POP.MC,NULL,BME:POP,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCO SANTANDER', 'ES0113900J37', 'EUR', 1, '|EURONEXT|', 77900, NULL, NULL, NULL, NULL, 100, 'c', 1, 9, 'EURONEXT#ES0113900J37||pt||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCO SANTANDER', 'ES0113900J37', 'EUR', 1, '|EUROSTOXX|IBEX|MERCADOCONTINUO|', 81105, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0113900J37||es||False', false, '{SAN.MC,NULL,BME:SAN,NULL,SAN}', false, 2);
INSERT INTO public.products VALUES ('BANCO SANTANDER S.A.', NULL, 'USD', 1, '', 77537, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#STD||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCO SANTANDER-CHILE', NULL, 'USD', 1, '', 75176, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#SAN||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCOFAR FUTURO', 'ES0181693039', 'EUR', 2, '|f_es_BMF|', 75941, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0181693039||es||False', false, '{NULL,F0GBR04K0C,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANCORPSOUTH INC.', NULL, 'USD', 1, '', 79400, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BXS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANESDEUDA FONDTESORO LARGO PLAZ', 'ES0114047030', 'EUR', 2, '|f_es_BMF|', 75500, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114047030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANESDEUDA FONDVALENCIA', 'ES0114048038', 'EUR', 2, '|f_es_BMF|', 75599, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114048038||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANESTO 100%CAPITAL MEJOR OPCION', 'ES0113916037', 'EUR', 2, '|f_es_BMF|', 77394, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113916037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANESTO 95 BOLSA TOP', 'ES0113758009', 'EUR', 2, '|f_es_BMF|', 76947, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113758009||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANESTO 95% CAPITAL MEJOR OPCION', 'ES0113746038', 'EUR', 2, '|f_es_BMF|', 77488, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113746038||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANESTO 95 IBEX 60', 'ES0113462008', 'EUR', 2, '|f_es_BMF|', 76948, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113462008||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANESTO 95 SELECCION MUNDIAL', 'ES0113602009', 'EUR', 2, '|f_es_BMF|', 76952, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113602009||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANESTO AHORRO ACTIVO', 'ES0113476032', 'EUR', 2, '|f_es_BMF|', 78816, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113476032||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANESTO AHORRO', 'ES0138802030', 'EUR', 2, '|f_es_BMF|', 76953, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138802030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANESTO BOLSA 30 2', 'ES0113543039', 'EUR', 2, '|f_es_BMF|', 76957, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113543039||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANESTO BOLSA 30 3', 'ES0113962031', 'EUR', 2, '|f_es_BMF|', 76958, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113962031||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANESTO BOLSA 30', 'ES0113659033', 'EUR', 2, '|f_es_BMF|', 77486, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113659033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANESTO BOLSA INTERNACIONAL', 'ES0138917036', 'EUR', 2, '|f_es_BMF|', 76962, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138917036||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANESTO BOLSA TOP', 'ES0113436002', 'EUR', 2, '|f_es_BMF|', 76967, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113436002||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANESTO BOLSAS EUROPEAS', 'ES0113657037', 'EUR', 2, '|f_es_BMF|', 77003, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113657037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANESTO DECIDIDO ACTIVO', 'ES0113791034', 'EUR', 2, '|f_es_BMF|', 75192, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113791034||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANESTO DIVIDENDO EUROPA', 'ES0113109039', 'EUR', 2, '|f_es_BMF|', 75206, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113109039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANESTO DOLAR 95 II', 'ES0113581005', 'EUR', 2, '|f_es_BMF|', 76288, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113581005||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANESTO', 'ES0113440038', 'EUR', 1, '', 78410, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0113440038||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANESTO ESPECIAL AHORRO', 'ES0114013032', 'EUR', 2, '|f_es_BMF|', 76558, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114013032||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANESTO ESPECIAL EMPRESAS', 'ES0113108031', 'EUR', 2, '|f_es_BMF|', 76069, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113108031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANESTO ESPECIAL RENTA FIJA', 'ES0113796033', 'EUR', 2, '|f_es_BMF|', 76291, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113796033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANESTO EXTRA AHORRO', 'ES0134675034', 'EUR', 2, '|f_es_BMF|', 77579, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0134675034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANESTO FONBANESTO', NULL, 'EUR', 2, '', 74959, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'BANESTO FONBANESTO||es||True', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANESTO FONDEPOSITOS', 'ES0113474037', 'EUR', 2, '|f_es_BMF|', 77007, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113474037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANESTO GARAN.OPORTUNIDAD EUROPA', 'ES0113712030', 'EUR', 2, '|f_es_BMF|', 75262, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113712030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANESTO GARAN.RENTAS CONSTANTES 2015', 'ES0181696032', 'EUR', 2, '|f_es_BMF|', 75263, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0181696032||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANESTO GARANT.IBEX TOP 2', 'ES0113526034', 'EUR', 2, '|f_es_BMF|', 75333, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113526034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANESTO GARANTIZADO 2001A', NULL, 'EUR', 2, '', 74966, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'BANESTO GARANTIZADO 2001A||es||True', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANESTO GARANTIZADO BOLSA TOP 2', 'ES0113267035', 'EUR', 2, '|f_es_BMF|', 75342, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113267035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANESTO GARANTIZADO OCASION 2', 'ES0113792032', 'EUR', 2, '|f_es_BMF|', 75452, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113792032||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANESTO GARANTIZADO OCASION 2008', 'ES0114044037', 'EUR', 2, '|f_es_BMF|', 75010, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114044037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANESTO GARANTIZADO OCASION', 'ES0113658035', 'EUR', 2, '|f_es_BMF|', 75343, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113658035||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANESTO GARANTIZADO OCASION PLUS', 'ES0113475034', 'EUR', 2, '|f_es_BMF|', 76298, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113475034||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANESTO GARANTIZADO SELECCION EUROPA 2', 'ES0113948030', 'EUR', 2, '|f_es_BMF|', 75261, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113948030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANESTO GARANTIZADO SELECCION EUROPA', 'ES0165202039', 'EUR', 2, '|f_es_BMF|', 75238, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0165202039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANESTO GARANTIZADO SELECCION IBEX 2', 'ES0113532032', 'EUR', 2, '|f_es_BMF|', 75329, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113532032||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANESTO GARANTIZADO SELECCION IBEX', 'ES0113656039', 'EUR', 2, '|f_es_BMF|', 76299, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113656039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANESTO GARANTIZADO TRIPLE RENDI', 'ES0113531034', 'EUR', 2, '|f_es_BMF|', 76168, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113531034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANESTO IBEX TOP', 'ES0113947032', 'EUR', 2, '|f_es_BMF|', 76300, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113947032||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANESTO IBEX TOTAL', 'ES0113946034', 'EUR', 2, '|f_es_BMF|', 75946, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113946034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANESTO LIQUIDEZ DEUDA PUBLICA A', 'ES0113747010', 'EUR', 2, '|f_es_BMF|', 75947, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113747010||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANESTO LIQUIDEZ DEUDA PUBLICA B', 'ES0113747002', 'EUR', 2, '|f_es_BMF|', 77038, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113747002||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANESTO MIXTO RENTA FIJA 72/25', 'ES0114016035', 'EUR', 2, '|f_es_BMF|', 75407, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114016035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANESTO MIXTO RENTA FIJA 90/10', 'ES0114017033', 'EUR', 2, '|f_es_BMF|', 75411, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114017033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANESTO MIXTO RENTA VARIAB.50/50', 'ES0114038039', 'EUR', 2, '|f_es_BMF|', 75412, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114038039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANESTO MODERADO ACTIVO', 'ES0113781035', 'EUR', 2, '|f_es_BMF|', 75382, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113781035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANESTO PROTECCION BOLSA 2', 'ES0113527032', 'EUR', 2, '|f_es_BMF|', 75383, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113527032||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANESTO RENTA FIJA BONOS', 'ES0138877032', 'EUR', 2, '|f_es_BMF|', 78537, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138877032||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANESTO RENTA VARIABLE ESPAÑOLA', 'ES0114039037', 'EUR', 2, '|f_es_BMF|', 78538, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114039037||es||False', true, '{NULL,F0GBR04PZJ,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANESTO SELECCION CONSERVADOR', 'ES0181698038', 'EUR', 2, '|f_es_BMF|', 76301, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0181698038||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANIF 2011', 'ES0115216030', 'EUR', 2, '|f_es_BMF|', 78505, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115216030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANIF ACCIONES ESPAÑOLAS GARANTI', 'ES0169067032', 'EUR', 2, '|f_es_BMF|', 75954, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0169067032||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANIF BOLSA GARANTIZADO', 'ES0164649032', 'EUR', 2, '|f_es_BMF|', 75990, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0164649032||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANIF CARTERA DINAMICA', 'ES0166333031', 'EUR', 2, '|f_es_BMF|', 78878, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0166333031||es||False', false, '{NULL,F0GBR04IT1,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANIF CARTERA EMERGENTES', 'ES0114081039', 'EUR', 2, '|f_es_BMF|', 78879, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114081039||es||False', false, '{NULL,F0GBR04IT3,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANIF CARTERA MODERADA', 'ES0115242036', 'EUR', 2, '|f_es_BMF|', 78884, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115242036||es||False', false, '{NULL,F0GBR04JWM,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANIF CORTO PLAZO B', 'ES0115237036', 'EUR', 2, '|f_es_BMF|', 78887, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115237036||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANIF CORTO PLAZO E', 'ES0115237002', 'EUR', 2, '|f_es_BMF|', 77047, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115237002||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANIF DIVIDENDO', 'ES0113544037', 'EUR', 2, '|f_es_BMF|', 77049, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113544037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANIF DIVIDENDO EUROPA', 'ES0109360034', 'EUR', 2, '|f_es_BMF|', 77050, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0109360034||es||False', false, '{NULL,F0GBR04JSF,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANIF ENERGIAS RENOV.ESTRUCTURAD', 'ES0113269031', 'EUR', 2, '|f_es_BMF|', 77051, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113269031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANIF ESTRUCTURADO', 'ES0113660031', 'EUR', 2, '|f_es_BMF|', 77053, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113660031||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANIF ESTRUTURADO BANCA EUROPEA', 'ES0113603007', 'EUR', 2, '|f_es_BMF|', 78904, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113603007||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANIF EUROPA GARANTIZADO', 'ES0115203038', 'EUR', 2, '|f_es_BMF|', 77054, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115203038||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANIF FONDEPOSITOS', 'ES0122071030', 'EUR', 2, '|f_es_BMF|', 77055, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0122071030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANIF GLOBAL 3-98', 'ES0138600038', 'EUR', 2, '|f_es_BMF|', 77060, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138600038||es||False', false, '{NULL,F0GBR04IT9,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANIF GLOBAL UNIVERSAL', 'ES0113545034', 'EUR', 2, '|f_es_BMF|', 77061, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113545034||es||False', false, '{NULL,F0GBR053VD,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANIF MONETARIO', 'ES0113749008', 'EUR', 2, '|f_es_BMF|', 78916, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113749008||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANIF RF CORTO PLAZO', 'ES0112793031', 'EUR', 2, '|f_es_BMF|', 77102, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0112793031||es||False', false, '{NULL,F0GBR04PYP,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANIF RV ESPAÑA', 'ES0112795036', 'EUR', 2, '|f_es_BMF|', 77103, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0112795036||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANIF SELECCION 1', 'ES0112796034', 'EUR', 2, '|f_es_BMF|', 77107, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0112796034||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANIF TESORERIA FONDTESORO CP', 'ES0112791035', 'EUR', 2, '|f_es_BMF|', 77115, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0112791035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANIF-SGPS', 'PTBNF0AM0005', 'EUR', 1, '|EURONEXT|', 77903, NULL, NULL, NULL, NULL, 100, 'c', 1, 9, 'EURONEXT#PTBNF0AM0005||pt||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANIMMO A (D)', 'BE0003870871', 'EUR', 1, '|EURONEXT|', 77944, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003870871||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANIMMO STRIP (D)', 'BE0005614855', 'EUR', 1, '|EURONEXT|', 79113, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0005614855||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANK OF AMERICA CORP.', 'US0605051046', 'USD', 1, '|SP500|', 77328, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BAC||us||False', false, '{BAC,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANK OF HAWAII CORP.', NULL, 'USD', 1, '', 76631, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BOH||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANK OF MONTREAL', NULL, 'USD', 1, '', 77422, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BMO||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANK OF NEW YORK MELLON CORP.', 'US0640581007', 'USD', 1, '|SP500|', 75806, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BK||us||False', false, '{BK,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANK OF NOVA SCOTIA', NULL, 'USD', 1, '', 78169, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BNS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKATLANTIC BANCORP INC. CL A', NULL, 'USD', 1, '', 80249, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BBX||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKIA', 'ES0113307039', 'EUR', 1, '|IBEX|MERCADOCONTINUO|', 81111, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0113307039||es||False', false, '{BKIA.MC,NULL,BME:BKIA,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKINTER ACUERDO GES.CONS.EMPRE', 'ES0134612037', 'EUR', 2, '|f_es_BMF|', 79295, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0134612037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKINTER BOLSA GLOBAL', 'ES0127188037', 'EUR', 2, '|f_es_BMF|', 77116, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0127188037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKINTER BONOS LARGO PLAZO', 'ES0114837034', 'EUR', 2, '|f_es_BMF|', 77118, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114837034||es||False', false, '{NULL,F0GBR04Q8J,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKINTER BRAMEX GARANTIZADO', 'ES0162940037', 'EUR', 2, '|f_es_BMF|', 77186, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0162940037||es||False', false, '{NULL,F0GBR04Q99,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKINTER BRIC PLUS 2 GARANTIZAD', 'ES0114838032', 'EUR', 2, '|f_es_BMF|', 79488, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114838032||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKINTER BRIC PLUS GARANTIZADO', 'ES0114874037', 'EUR', 2, '|f_es_BMF|', 80638, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114874037||es||False', false, '{NULL,F0GBR04Q8B,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKINTER CORPORATIVO', 'ES0161362035', 'EUR', 2, '|f_es_BMF|', 77191, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0161362035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKINTER DEUDA PUBLICA', 'ES0114786033', 'EUR', 2, '|f_es_BMF|', 78922, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114786033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKINTER DEUDA PUBLICA II', 'ES0114858030', 'EUR', 2, '|f_es_BMF|', 78930, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114858030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKINTER DINERO 1', 'ES0113921037', 'EUR', 2, '|f_es_BMF|', 77195, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113921037||es||False', false, '{NULL,F0GBR05RJH,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKINTER DINERO 2', 'ES0114801030', 'EUR', 2, '|f_es_BMF|', 76851, NULL, NULL, NULL, NULL, 0, 'c', 1, 1, 'ES0114801030||es||False', false, '{NULL,F0GBR04Q8F,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKINTER DINERO 3', 'ES0115155030', 'EUR', 2, '|f_es_BMF|', 77199, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115155030||es||False', false, '{NULL,F0GBR04F91,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKINTER DINERO 4', 'ES0127186031', 'EUR', 2, '|f_es_BMF|', 75580, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0127186031||es||False', false, '{NULL,F0GBR04Q98,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKINTER DIVIDENDO EUROPA', 'ES0114802038', 'EUR', 2, '|f_es_BMF|', 77203, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114802038||es||False', false, '{NULL,F0GBR04Q8W,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKINTER EEUU GARANTIZADO', 'ES0114873039', 'EUR', 2, '|f_es_BMF|', 75581, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114873039||es||False', false, '{NULL,F0GBR04Q8C,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKINTER EMERGENTES', 'ES0113923033', 'EUR', 2, '|f_es_BMF|', 76852, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113923033||es||False', false, '{NULL,F0GBR05UYB,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKINTER ENERGIAS RENOVABLES', 'ES0114871033', 'EUR', 2, '|f_es_BMF|', 75590, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114871033||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKINTER', 'ES0113679I37', 'EUR', 1, '|IBEX|MERCADOCONTINUO|', 78412, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0113679I37||es||False', false, '{BKT.MC,NULL,BME:BKT,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKINTER ESPANA GARANTIZADO', 'ES0114832035', 'EUR', 2, '|f_es_BMF|', 75630, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114832035||es||False', false, '{NULL,F0GBR04D4J,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKINTER FONDT.40% LARGO PLAZO', 'ES0147624037', 'EUR', 2, '|f_es_BMF|', 75636, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147624037||es||False', false, '{NULL,F0GBR04Q6Z,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKINTER FONDTESORO LARGO P.', 'ES0114831037', 'EUR', 2, '|f_es_BMF|', 75648, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114831037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKINTER GARANTIZADO SUPERACION', 'ES0133595035', 'EUR', 2, '|f_es_BMF|', 78744, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133595035||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKINTER GAR.SUPERACION 2', 'ES0114876032', 'EUR', 2, '|f_es_BMF|', 78747, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114876032||es||False', false, '{NULL,F0GBR04Q9D,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKINTER GESTION ABIERTA', 'ES0114867031', 'EUR', 2, '|f_es_BMF|', 75993, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114867031||es||False', false, '{NULL,F0GBR04Q7L,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKINTER GESTION AMBIENTAL', 'ES0125622037', 'EUR', 2, '|f_es_BMF|', 75994, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0125622037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKINTER HORIZONTE 2019', 'ES0164527006', 'EUR', 2, '|f_es_BMF|', 75995, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0164527006||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKINTER HORIZONTE 2029', 'ES0164585004', 'EUR', 2, '|f_es_BMF|', 77856, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0164585004||es||False', false, '{NULL,F000002942,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKINTER IBEX DEFENSA GARANTIZA', 'ES0114783030', 'EUR', 2, '|f_es_BMF|', 80881, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114783030||es||False', false, '{NULL,F0GBR04C9Z,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKINTER IBEX TOP DIVIDENDO GAR', 'ES0133594038', 'EUR', 2, '|f_es_BMF|', 79495, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133594038||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKINTER INDICE AMERICA', 'ES0114763032', 'EUR', 2, '|f_es_BMF|', 76916, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114763032||es||False', false, '{NULL,F0GBR04Q9K,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKINTER INDICE JAPON', 'ES0114104039', 'EUR', 2, '|f_es_BMF|', 76917, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114104039||es||False', false, '{NULL,F0GBR04Q9G,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKINTER INFLACION NACIONAL GAR', 'ES0113584009', 'EUR', 2, '|f_es_BMF|', 77882, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113584009||es||False', false, '{NULL,F00000259E,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKINTER INFLACION PLUS', 'ES0161361037', 'EUR', 2, '|f_es_BMF|', 75996, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0161361037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKINTER LONG SHORT', 'ES0115156038', 'EUR', 2, '|f_es_BMF|', 76313, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115156038||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKINTER PRIVATE EQUITY INDEX', 'ES0137722007', 'EUR', 2, '|f_es_BMF|', 77240, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137722007||es||False', false, '{NULL,F000000H7G,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKINTER QUANT', 'ES0114755038', 'EUR', 2, '|f_es_BMF|', 76414, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114755038||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKINTER RENTA DINAMICA', 'ES0114860036', 'EUR', 2, '|f_es_BMF|', 75677, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114860036||es||False', false, '{NULL,F0GBR04Q6X,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKINTER RF 2015 II GARANTIZADO FI', 'ES0114024005', 'EUR', 2, '|f_es_BMF|', 74765, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114024005||None||False', false, '{NULL,F00000NO7O,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKINTER SMALL-CAPS MID', 'ES0114784038', 'EUR', 2, '|f_es_BMF|', 76024, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114784038||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKINTER SOLIDARIDAD', 'ES0115157036', 'EUR', 2, '|f_es_BMF|', 76049, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115157036||es||False', false, '{NULL,F0GBR04H3Q,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKINTER TRIPLE INDICE GARANTIZ', 'ES0170276036', 'EUR', 2, '|f_es_BMF|', 80230, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0170276036||es||False', false, '{NULL,F0GBR04Q9C,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKOA 5 ESTRELLAS GARANTIZADO, FI', 'ES0113966032', 'EUR', 2, '|f_es_BMF|', 75703, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113966032||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKOA AHORRO FONDO', 'ES0113691036', 'EUR', 2, '|f_es_BMF|', 76456, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113691036||es||False', false, '{NULL,F0GBR04CEW,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKOA BOLSA', 'ES0113418034', 'EUR', 2, '|f_es_BMF|', 76289, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113418034||es||False', false, '{NULL,F0GBR04CEY,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKOA DEUDA PUBLICA', 'ES0113690038', 'EUR', 2, '|f_es_BMF|', 77294, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113690038||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKOA GESTION GLOBAL', 'ES0164593032', 'EUR', 2, '|f_es_BMF|', 76892, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0164593032||es||False', false, '{NULL,F0GBR04Q9V,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKOA IBEX 106 GARANTIZADO 2', 'ES0180655039', 'EUR', 2, '|f_es_BMF|', 77285, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0180655039||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKOA IBEX GARANTIZADO', 'ES0163028006', 'EUR', 2, '|f_es_BMF|', 74775, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0163028006||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKOA RENDIMIENTO 2 GARANTIZADO, FI', 'ES0114084033', 'EUR', 2, '|f_es_BMF|', 76173, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114084033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKOA STOXX 50 GARANTIZADO, FI', 'ES0180654032', 'EUR', 2, '|f_es_BMF|', 76176, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0180654032||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKOA TESORERIA', 'ES0113692034', 'EUR', 2, '|f_es_BMF|', 76317, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113692034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKOA TOP 3 GARANTIZADO', 'ES0182793036', 'EUR', 2, '|f_es_BMF|', 76419, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0182793036||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKPIME PARTICIPACIONES PREFERENTES', 'ES0113439006', 'EUR', 2, '|f_es_BMF|', 75742, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113439006||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKPYME BROKERFOND', 'ES0115201032', 'EUR', 2, '|f_es_BMF|', 78959, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115201032||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKPYME COMUNICACIONES', 'ES0113693032', 'EUR', 2, '|f_es_BMF|', 78969, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113693032||es||False', false, '{NULL,F0GBR04Q9Y,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKPYME EUROPE INVEST', 'ES0113750006', 'EUR', 2, '|f_es_BMF|', 78970, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113750006||es||False', false, '{NULL,F000001WP9,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKPYME EUROVALOR', 'ES0170451035', 'EUR', 2, '|f_es_BMF|', 78974, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0170451035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKPYME FONDOLAR', 'ES0113481008', 'EUR', 2, '|f_es_BMF|', 75753, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113481008||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKPYME GEST.DE CART. MODERADA', 'ES0113801031', 'EUR', 2, '|f_es_BMF|', 75759, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113801031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKPYME IBERBOLSA', 'ES0114065032', 'EUR', 2, '|f_es_BMF|', 75729, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114065032||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKPYME MULTI TOP FUNDS', 'ES0110056035', 'EUR', 2, '|f_es_BMF|', 75997, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0110056035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKPYME MULTIDINERO', 'ES0165101033', 'EUR', 2, '|f_es_BMF|', 75998, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0165101033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKPYME MULTIFIX 25 R.V.', 'ES0165099039', 'EUR', 2, '|f_es_BMF|', 76455, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0165099039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKPYME MULTISALUD', 'ES0110057033', 'EUR', 2, '|f_es_BMF|', 76457, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0110057033||es||False', false, '{NULL,F0GBR04QAD,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKPYME RF PRIVADA DICIEMBRE 2012', 'ES0113403002', 'EUR', 2, '|f_es_BMF|', 76089, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113403002||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKPYME RF PRIVADA JUNIO 2011', 'ES0125623001', 'EUR', 2, '|f_es_BMF|', 76091, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0125623001||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKPYME SWISS', 'ES0177031038', 'EUR', 2, '|f_es_BMF|', 76094, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0177031038||es||False', true, '{NULL,F0GBR04QAF,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKPYME TOP CLASS 75 R.V.', 'ES0114091038', 'EUR', 2, '|f_es_BMF|', 76059, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114091038||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKRATE INC.', NULL, 'USD', 1, '', 79417, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#RATE||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANKUNITED INC.', NULL, 'USD', 1, '', 77936, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BKU||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANORTE', 'MXP370711014', 'EUR', 1, '|LATIBEX|', 81446, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#MXP370711014||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANQUE TARNEAUD', 'FR0000065526', 'EUR', 1, '|EURONEXT|', 79114, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000065526||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BANSABADELL BS GAR.EXTRA 11', 'ES0111094001', 'EUR', 2, '|f_es_BMF|', 76061, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0111094001||es||False', false, '{NULL,F000005HCT,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BA.PASTOR', 'ES0113770434', 'EUR', 1, '', 78402, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0113770434||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BARBARA BUI', 'FR0000062788', 'EUR', 1, '|EURONEXT|', 79165, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000062788||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BARCLAYS BOLSA ESPAÑA', 'ES0138847035', 'EUR', 2, '|f_es_BMF|', 75057, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138847035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BARCLAYS BOLSA ESPAÑA SELECCION', 'ES0114180039', 'EUR', 2, '|f_es_BMF|', 76133, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114180039||es||False', false, '{NULL,F0GBR04QAX,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BARCLAYS BOLSA EUROPA', 'ES0138596038', 'EUR', 2, '|f_es_BMF|', 78733, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138596038||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BARCLAYS BOLSA USA', 'ES0124662034', 'EUR', 2, '|f_es_BMF|', 76458, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0124662034||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BARCLAYS BONOS CONSERVADOR', 'ES0138943032', 'EUR', 2, '|f_es_BMF|', 76463, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138943032||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BARCLAYS BONOS CORPORATIVOS', 'ES0114166038', 'EUR', 2, '|f_es_BMF|', 76134, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114166038||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BARCLAYS BONOS LARGO', 'ES0138602034', 'EUR', 2, '|f_es_BMF|', 76152, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138602034||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BARCLAYS DEUDA PUBLICA', 'ES0113803037', 'EUR', 2, '|f_es_BMF|', 76469, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113803037||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BARCLAYS FONDO GLOBAL SELECCION', 'ES0115252035', 'EUR', 2, '|f_es_BMF|', 76417, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115252035||es||False', false, '{NULL,F0GBR04PTM,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BARCLAYS GARANT. GIGANTES MUNDIALES', 'ES0138295037', 'EUR', 2, '|f_es_BMF|', 76153, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138295037||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BARCLAYS GARANTIZADO 1', 'ES0133551038', 'EUR', 2, '|f_es_BMF|', 76250, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133551038||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BARCLAYS GARANTIZADO 10', 'ES0133801037', 'EUR', 2, '|f_es_BMF|', 77395, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133801037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BARCLAYS GARANTIZADO 14', 'ES0184844035', 'EUR', 2, '|f_es_BMF|', 77282, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0184844035||es||False', true, '{NULL,F0GBR04PTH,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BARCLAYS GARANTIZADO 16', 'ES0155814033', 'EUR', 2, '|f_es_BMF|', 76362, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0155814033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BARCLAYS GARANTIZADO 17', 'ES0184846030', 'EUR', 2, '|f_es_BMF|', 76415, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0184846030||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BARCLAYS GARANTIZADO 19', 'ES0133756033', 'EUR', 2, '|f_es_BMF|', 76143, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133756033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BARCLAYS GARANTIZADO 2012', 'ES0125624009', 'EUR', 2, '|f_es_BMF|', 76154, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0125624009||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BARCLAYS GARANTIZADO 2013', 'ES0138971033', 'EUR', 2, '|f_es_BMF|', 76247, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138971033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BARCLAYS GARANTIZADO 8', 'ES0158322034', 'EUR', 2, '|f_es_BMF|', 76248, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0158322034||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BARCLAYS GARANTIZADO ACC. ESPAÑA', 'ES0138520038', 'EUR', 2, '|f_es_BMF|', 76249, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138520038||es||False', false, '{NULL,F0GBR04QAT,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BARCLAYS GARANTIZADO PROTECCION', 'ES0184824037', 'EUR', 2, '|f_es_BMF|', 76302, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0184824037||es||False', true, '{NULL,F0GBR04EJ4,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BARCLAYS GARANT.PROTECCION 2', 'ES0141220030', 'EUR', 2, '|f_es_BMF|', 77056, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0141220030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BARCLAYS GESTION 25', 'ES0113422036', 'EUR', 2, '|f_es_BMF|', 76305, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113422036||es||False', false, '{NULL,F0GBR04OMI,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BARCLAYS GESTION 50', 'ES0110058031', 'EUR', 2, '|f_es_BMF|', 77287, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0110058031||es||False', false, '{NULL,F0GBR04OMO,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BARCLAYS GESTION DINAMICA 150', 'ES0184928036', 'EUR', 2, '|f_es_BMF|', 77289, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0184928036||es||False', false, '{NULL,F0GBR04J3X,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BARCLAYS GESTION DINAMICA 300', 'ES0184919035', 'EUR', 2, '|f_es_BMF|', 76306, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0184919035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BARCLAYS GESTION', 'ES0113802039', 'EUR', 2, '|f_es_BMF|', 76304, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113802039||es||False', false, '{NULL,F0GBR04OMM,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BARCLAYS GESTION TOTAL', 'ES0114165030', 'EUR', 2, '|f_es_BMF|', 76314, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114165030||es||False', false, '{NULL,F0GBR04QB5,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BARCLAYS INT. GARANTIZADO 1', 'ES0138216033', 'EUR', 2, '|f_es_BMF|', 76316, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138216033||es||False', false, '{NULL,F0GBR04JQB,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BARCLAYS LIQUIDEZ', 'ES0113717005', 'EUR', 2, '|f_es_BMF|', 76318, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113717005||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BARCLAYS MIXTO 25', 'ES0138846037', 'EUR', 2, '|f_es_BMF|', 75161, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138846037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BARCLAYS MULTIALFA', 'ES0184930032', 'EUR', 2, '|f_es_BMF|', 75265, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0184930032||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BARCLAYS MULTIFONDO ALTERNATIVO', 'ES0184927038', 'EUR', 2, '|f_es_BMF|', 75267, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0184927038||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BARCLAYS MULTIMANAGER PLUS', 'ES0184825034', 'EUR', 2, '|f_es_BMF|', 77434, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0184825034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BARCLAYS PLAN INVERSION 4', NULL, 'EUR', 2, '', 74967, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'BARCLAYS PLAN INVERSION 4||es||True', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BARCLAYS PLAN INVERSION 5', NULL, 'EUR', 2, '', 75140, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'BARCLAYS PLAN INVERSION 5||es||True', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BARCLAYS PLC', NULL, 'USD', 1, '', 78466, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BCS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BARCLAYS RENDIMIENTO EFECTIVO', 'ES0170456034', 'EUR', 2, '|f_es_BMF|', 77297, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0170456034||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BARCLAYS TESORERIA', 'ES0113986030', 'EUR', 2, '|f_es_BMF|', 76365, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113986030||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BARCO', 'BE0003790079', 'EUR', 1, '|EURONEXT|', 78232, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003790079||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BARCO STRIP (D)', 'BE0005583548', 'EUR', 1, '|EURONEXT|', 79166, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0005583548||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BARNES & NOBLE INC.', NULL, 'USD', 1, '', 80915, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BKS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BARNES GROUP INC.', NULL, 'USD', 1, '', 75374, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#B||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BARON DE LEY', 'ES0114297015', 'EUR', 1, '|MERCADOCONTINUO|', 81447, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0114297015||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BARRICK GOLD CORP.', NULL, 'USD', 1, '', 76818, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ABX||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BA.SANT.RIO', 'ARBRIO010194', 'EUR', 1, '', 81445, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ARBRIO010194||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BASF SE', 'DE000BASF111', 'EUR', 1, '|DEUTSCHEBOERSE|EUROSTOXX|', 78649, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE000BASF111||de||False', false, '{BAS.DE,NULL,ETR:BAS,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BASIC ENERGY SERVICES INC.', NULL, 'USD', 1, '', 79621, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BAS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BASKEPLUS', 'ES0114299037', 'EUR', 2, '|f_es_BMF|', 76366, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114299037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BASLER AG', 'DE0005102008', 'EUR', 1, '|DEUTSCHEBOERSE|', 78652, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005102008||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BASTIDE LE CONFORT', 'FR0000035370', 'EUR', 1, '|EURONEXT|', 77945, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000035370||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BATENBURG TECHNIEK', 'NL0006292906', 'EUR', 1, '|EURONEXT|', 79365, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0006292906||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BAUER AKTIENGESELLSCHAFT', 'DE0005168108', 'EUR', 1, '|DEUTSCHEBOERSE|', 78685, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005168108||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BA.VALENCIA', 'ES0113980F34', 'EUR', 1, '', 81106, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0113980F34||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BAWAG CAP  7,125PL', 'DE0008600966', 'EUR', 1, '|EURONEXT|', 79975, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#DE0008600966||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BAXTER INTERNATIONAL INC.', 'US0718131099', 'USD', 1, '|SP500|', 75786, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BAX||us||False', false, '{BAX,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BAYER AG', 'DE000BAY0017', 'EUR', 1, '|DAX|DEUTSCHEBOERSE|EUROSTOXX|', 78687, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE000BAY0017||de||False', false, '{BAYN.DE,NULL,ETR:BAYN,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BAYER', 'DE000BAY0017', 'EUR', 1, '|MERCADOCONTINUO|', 80820, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#DE000BAY0017||es||False', false, '{bay.mc,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BAYTEX ENERGY CORP.', NULL, 'USD', 1, '', 75367, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BTE||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BAYWA AG NA', 'DE0005194005', 'EUR', 1, '|DEUTSCHEBOERSE|', 78689, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005194005||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BAYWA AG VNA', 'DE0005194062', 'EUR', 1, '|DEUTSCHEBOERSE|', 78729, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005194062||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BB BIOTECH AG', 'CH0038389992', 'EUR', 1, '|DEUTSCHEBOERSE|', 80554, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#CH0038389992||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBK  OPVS', 'ES0113275004', 'EUR', 2, '|f_es_BMF|', 77243, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113275004||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBK 0/100 CARTERAS', 'ES0113053005', 'EUR', 2, '|f_es_BMF|', 77244, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113053005||es||False', false, '{NULL,F00000GX37,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBK BOLSA EEUU', 'ES0113191037', 'EUR', 2, '|f_es_BMF|', 77260, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113191037||es||False', false, '{NULL,F0GBR04PS2,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBK BOLSA EEUU NUEVA ECONOMIA', 'ES0114222039', 'EUR', 2, '|f_es_BMF|', 77330, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114222039||es||False', false, '{NULL,F0GBR04PRY,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBK BOLSA', 'ES0114388038', 'EUR', 2, '|f_es_BMF|', 77245, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114388038||es||False', false, '{NULL,F0GBR04PS4,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBK BOLSA EURO', 'ES0114221031', 'EUR', 2, '|f_es_BMF|', 77298, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114221031||es||False', false, '{NULL,F0GBR04PS0,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBK BOLSA JAPON', 'ES0114232038', 'EUR', 2, '|f_es_BMF|', 77308, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114232038||es||False', false, '{NULL,F0GBR04PS1,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBK BOLSAS EMERGENTES', 'ES0114233036', 'EUR', 2, '|f_es_BMF|', 77309, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114233036||es||False', false, '{NULL,F0GBR04PRZ,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBK BONO', 'ES0114276035', 'EUR', 2, '|f_es_BMF|', 77310, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114276035||es||False', false, '{NULL,F0GBR04PSE,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBK CAPITAL PARTNERS', 'ES0114237037', 'EUR', 2, '|f_es_BMF|', 77460, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114237037||es||False', false, '{NULL,F0GBR04J4T,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBK CRECIMIENTO DINAMICO', 'ES0114381033', 'EUR', 2, '|f_es_BMF|', 75999, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114381033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBK DINAMICO', 'ES0114202031', 'EUR', 2, '|f_es_BMF|', 77311, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114202031||es||False', false, '{NULL,F0GBR04VUC,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBK DIVIDENDO', 'ES0133759037', 'EUR', 2, '|f_es_BMF|', 77331, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133759037||es||False', false, '{NULL,F0GBR05XPV,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBK EMPRESAS DINAMICO', 'ES0137724003', 'EUR', 2, '|f_es_BMF|', 77332, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137724003||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBK FONDINERO', 'ES0114262035', 'EUR', 2, '|f_es_BMF|', 77333, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114262035||es||False', false, '{NULL,F0GBR04PSD,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBK FONDO INTERNACIONAL', 'ES0113987038', 'EUR', 2, '|f_es_BMF|', 77336, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113987038||es||False', false, '{NULL,F0GBR04PS3,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBK GARANTIZADO 3 ACCIONES', 'ES0113551032', 'EUR', 2, '|f_es_BMF|', 78676, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113551032||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBK GARANTIZADO 7', 'ES0113452033', 'EUR', 2, '|f_es_BMF|', 77312, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113452033||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBK GARANTIZADO BOLSA 2', 'ES0113453031', 'EUR', 2, '|f_es_BMF|', 77345, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113453031||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBK GARANTIZADO BOLSA 3', 'ES0125625006', 'EUR', 2, '|f_es_BMF|', 77346, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0125625006||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBK GARANTIZADO BOLSA 4', 'ES0113404000', 'EUR', 2, '|f_es_BMF|', 76470, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113404000||es||False', false, '{NULL,F000003Z6F,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBK GARANTIZADO BOLSA 5', 'ES0110059039', 'EUR', 2, '|f_es_BMF|', 76471, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0110059039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBK GARANTIZADO BOLSA', 'ES0114234034', 'EUR', 2, '|f_es_BMF|', 77337, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114234034||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBK GARANTIZADO BOLSA EUROPA 2', 'ES0114235031', 'EUR', 2, '|f_es_BMF|', 77404, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114235031||es||False', false, '{NULL,F0GBR04JPK,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBK GARANTIZADO BOLSA EUROPA', 'ES0114201033', 'EUR', 2, '|f_es_BMF|', 76064, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114201033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBK GARANTIZADO FINANZAS', 'ES0113274007', 'EUR', 2, '|f_es_BMF|', 76505, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113274007||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBK GARANTIZADO INDICE EUROPA', 'ES0114238035', 'EUR', 2, '|f_es_BMF|', 76506, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114238035||es||False', false, '{NULL,F0GBR04LS8,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBK GARANTIZADO RENTA FIJA 10/14', 'ES0114585005', 'EUR', 2, '|f_es_BMF|', 78683, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114585005||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBK GARANTIZADO RENTA FIJA 2012 (2)', 'ES0113534004', 'EUR', 2, '|f_es_BMF|', 78698, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113534004||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBK GARANTIZADO RENTA FIJA 2012', 'ES0114185038', 'EUR', 2, '|f_es_BMF|', 75344, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114185038||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBK GARANTIZADO RENTA FIJA 2012,', 'ES0125626004', 'EUR', 2, '|f_es_BMF|', 76543, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0125626004||es||False', true, '{NULL,F000003VX7,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBK GESTION ACTIVA INVERSION', 'ES0113192035', 'EUR', 2, '|f_es_BMF|', 76544, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113192035||es||False', false, '{NULL,F0GBR04OMU,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBK GESTION ACTIVA PATRIMONIO', 'ES0114836036', 'EUR', 2, '|f_es_BMF|', 77406, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114836036||es||False', false, '{NULL,F0GBR04PRX,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBK GESTION ACTIVA RENDIMIENTO', 'ES0114390034', 'EUR', 2, '|f_es_BMF|', 77441, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114390034||es||False', false, '{NULL,F0GBR04PS7,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBK MIXTO', 'ES0114258033', 'EUR', 2, '|f_es_BMF|', 76546, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114258033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBK REAL ESTATE MUNDIAL', 'ES0114236039', 'EUR', 2, '|f_es_BMF|', 77445, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114236039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBK RENTA FIJA 2014', 'ES0113423034', 'EUR', 2, '|f_es_BMF|', 77446, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113423034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBK RENTA FIJA 3 MESES', 'ES0114256037', 'EUR', 2, '|f_es_BMF|', 77458, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114256037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBK RENTA GLOBAL', 'ES0114387030', 'EUR', 2, '|f_es_BMF|', 77459, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114387030||es||False', false, '{NULL,F0GBR04PS6,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBK R.F. OPORTUNIDAD CARTERAS', 'ES0125627002', 'EUR', 2, '|f_es_BMF|', 77443, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0125627002||es||False', false, '{NULL,F00000GX38,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBK SOLIDARIA', 'ES0114186036', 'EUR', 2, '|f_es_BMF|', 77469, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114186036||es||False', false, '{NULL,F0GBR05XPU,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BB&T CORPORATION', 'US0549371070', 'USD', 1, '|SP500|', 74824, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BBT||us||False', false, '{BBT,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBV CARTERA SIMCAV', NULL, 'EUR', 2, '', 75280, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'BBV CARTERA SIMCAV||es||True', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBV RENTA FIM', NULL, 'EUR', 2, '', 75284, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'BBV RENTA FIM||es||True', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA & PARTNERS RETORNO ABSOLUTO', 'ES0115159032', 'EUR', 2, '|f_es_BMF|', 77480, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115159032||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA 100 IBEX POSITIVO FI', 'ES0114169032', 'EUR', 2, '|f_es_BMF|', 74776, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114169032||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA 100 IBEX POSITIVO II FI', 'ES0114282033', 'EUR', 2, '|f_es_BMF|', 74777, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114282033||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA 100 IBEX POSITIVO III', 'ES0133760035', 'EUR', 2, '|f_es_BMF|', 77449, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133760035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA 105 IBEX II FI', 'ES0184931030', 'EUR', 2, '|f_es_BMF|', 74778, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0184931030||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA 110 IBEX', 'ES0113953030', 'EUR', 2, '|f_es_BMF|', 77471, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113953030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA 110 IBEX II', 'ES0113855037', 'EUR', 2, '|f_es_BMF|', 77473, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113855037||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA 4 X 3', 'ES0113535001', 'EUR', 2, '|f_es_BMF|', 77523, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113535001||es||False', true, '{NULL,F00000GX39,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA 4 X 3 II', 'ES0113455036', 'EUR', 2, '|f_es_BMF|', 77526, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113455036||es||False', false, '{NULL,F0GBR05TU6,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA 4-100 IBEX FI', 'ES0114203039', 'EUR', 2, '|f_es_BMF|', 74779, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114203039||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA 4-100 IBEX II FI', 'ES0113454039', 'EUR', 2, '|f_es_BMF|', 74780, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113454039||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA 5X5 INDICES', 'ES0113817003', 'EUR', 2, '|f_es_BMF|', 77539, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113817003||es||False', false, '{NULL,F000000H7H,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA ACCION EUROPA, FI', 'ES0114168034', 'EUR', 2, '|f_es_BMF|', 77573, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114168034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA ACCION EUROPA II, FI', 'ES0110187038', 'EUR', 2, '|f_es_BMF|', 77542, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0110187038||es||False', false, '{NULL,F0GBR04GSO,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA ACTIVOS FONDTESORO', 'ES0113200036', 'EUR', 2, '|f_es_BMF|', 77575, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113200036||es||False', false, '{NULL,F0GBR04D50,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA AHORRO CORTO PLAZO II', 'ES0110131036', 'EUR', 2, '|f_es_BMF|', 77592, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0110131036||es||False', false, '{NULL,F0GBR04D6K,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA AHORRO CORTO PLAZO III', 'ES0145926038', 'EUR', 2, '|f_es_BMF|', 77601, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0145926038||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA AHORRO EMPRESAS', 'ES0114129036', 'EUR', 2, '|f_es_BMF|', 76050, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114129036||es||False', false, '{NULL,F0GBR04G3T,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA AHORRO', 'ES0110108034', 'EUR', 2, '|f_es_BMF|', 77576, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0110108034||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA AHORRO II', 'ES0125628000', 'EUR', 2, '|f_es_BMF|', 77045, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0125628000||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA BANCO FRANCES S.A.', NULL, 'USD', 1, '', 80386, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BFR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA B.FRAN.', 'ARP125991090', 'EUR', 1, '|LATIBEX|', 81424, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ARP125991090||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA BOLSA ASIA MF', 'ES0108929037', 'EUR', 2, '|f_es_BMF|', 76021, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0108929037||es||False', false, '{NULL,F0GBR05T5Q,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA BOLSA BIOFARMA FI', 'ES0145923035', 'EUR', 2, '|f_es_BMF|', 74781, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0145923035||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA BOLSA CHINA', 'ES0113818001', 'EUR', 2, '|f_es_BMF|', 76023, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113818001||es||False', false, '{NULL,F000000JPZ,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA BOLSA DESARROLLO SOSTENIGLE', 'ES0125459034', 'EUR', 2, '|f_es_BMF|', 77630, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0125459034||es||False', false, '{NULL,F0GBR04ZL1,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA BOLSA EMERGENTES', 'ES0110116037', 'EUR', 2, '|f_es_BMF|', 77631, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0110116037||es||False', false, '{NULL,F0GBR04Q7H,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA BOLSA', 'ES0138861036', 'EUR', 2, '|f_es_BMF|', 76013, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138861036||es||False', false, '{NULL,F0GBR04Q7F,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA BOLSA EURO', 'ES0110101039', 'EUR', 2, '|f_es_BMF|', 77632, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0110101039||es||False', false, '{NULL,F0GBR04ZL6,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA BOLSA EURO QUANT', 'ES0114225032', 'EUR', 2, '|f_es_BMF|', 75840, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114225032||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA BOLSA EUROPA', 'ES0114371034', 'EUR', 2, '|f_es_BMF|', 77633, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114371034||es||False', false, '{NULL,F0GBR04CLX,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA BOLSA EUROPA FINANZAS', 'ES0180661003', 'EUR', 2, '|f_es_BMF|', 76373, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0180661003||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA BOLSA EUROPA FINANZAS I', 'ES0114277033', 'EUR', 2, '|f_es_BMF|', 77649, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114277033||es||False', false, '{NULL,F0GBR051Q4,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA BOLSA GARANTIZADO', 'ES0114128038', 'EUR', 2, '|f_es_BMF|', 76370, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114128038||es||False', false, '{NULL,F0GBR04G2L,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA BOLSA IBEX QUANT', 'ES0114206032', 'EUR', 2, '|f_es_BMF|', 75839, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114206032||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA BOLSA INDICE', 'ES0110182039', 'EUR', 2, '|f_es_BMF|', 76374, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0110182039||es||False', false, '{NULL,F0GBR04Q8M,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA BOLSA INDICE EURO', 'ES0110098037', 'EUR', 2, '|f_es_BMF|', 77656, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0110098037||es||False', false, '{NULL,F0GBR04Q83,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA BOLSA INDICE JAPON (CUBIERTO)', 'ES0115160030', 'EUR', 2, '|f_es_BMF|', 75209, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115160030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA BOLSA INDICE USA (CUBIERTO)', 'ES0113925038', 'EUR', 2, '|f_es_BMF|', 77658, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113925038||es||False', false, '{NULL,F000000374,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA BOLSA INTERNACIONAL MF CUBI', 'ES0141754038', 'EUR', 2, '|f_es_BMF|', 77663, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0141754038||es||False', false, '{NULL,F0GBR04LEY,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA BOLSA JAPON CUBIERTO', 'ES0110088038', 'EUR', 2, '|f_es_BMF|', 76026, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0110088038||es||False', false, '{NULL,F0GBR04Q85,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA BOLSA JAPON', 'ES0147634036', 'EUR', 2, '|f_es_BMF|', 77664, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147634036||es||False', false, '{NULL,F0GBR04Q76,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA BOLSA LATAM', 'ES0142332032', 'EUR', 2, '|f_es_BMF|', 76377, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0142332032||es||False', false, '{NULL,F0GBR04CU5,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA BOLSA PLAN DIVIDENDO', 'ES0113536009', 'EUR', 2, '|f_es_BMF|', 77677, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113536009||es||False', false, '{NULL,F00000H4VI,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA BOLSA PLUS', 'ES0142451030', 'EUR', 2, '|f_es_BMF|', 77678, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0142451030||es||False', false, '{NULL,F0GBR04Q8O,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA BOLSA TECNOLOG.Y TELECOM.', 'ES0147711032', 'EUR', 2, '|f_es_BMF|', 77683, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147711032||es||False', false, '{NULL,F0GBR04ZKV,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA BOLSA USA', 'ES0110122035', 'EUR', 2, '|f_es_BMF|', 77684, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0110122035||es||False', false, '{NULL,F0GBR04Q7A,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA BONO 2008 F', 'ES0113819009', 'EUR', 2, '|f_es_BMF|', 77686, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113819009||es||False', false, '{NULL,F000000JX1,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA BONO 2010 B FI', 'ES0113097036', 'EUR', 2, '|f_es_BMF|', 74782, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113097036||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA BONO 2010', 'ES0114389036', 'EUR', 2, '|f_es_BMF|', 77691, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114389036||es||False', false, '{NULL,F0GBR04CLV,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA BONO 2011', 'ES0114364039', 'EUR', 2, '|f_es_BMF|', 77693, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114364039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA BONO FON-PLAZO 2009 C', 'ES0113927000', 'EUR', 2, '|f_es_BMF|', 77701, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113927000||es||False', false, '{NULL,F000000AS3,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA BONOS 2014', 'ES0113277000', 'EUR', 2, '|f_es_BMF|', 77711, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113277000||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA BONOS AHORRO PLUS II', 'ES0114452032', 'EUR', 2, '|f_es_BMF|', 77724, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114452032||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA BONOS CASH', 'ES0113276002', 'EUR', 2, '|f_es_BMF|', 77740, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113276002||es||False', false, '{NULL,F000002L66,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA BONOS CASH PLUS', 'ES0110081033', 'EUR', 2, '|f_es_BMF|', 76541, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0110081033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA BONOS CORE BP', 'ES0114239033', 'EUR', 2, '|f_es_BMF|', 77770, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114239033||es||False', false, '{NULL,F0GBR04EQ3,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA BONOS CORP. LARGO PLAZO', 'ES0114205034', 'EUR', 2, '|f_es_BMF|', 77772, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114205034||es||False', false, '{NULL,F0GBR05SLE,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA BONOS CORPORATIVOS 2011', 'ES0113522009', 'EUR', 2, '|f_es_BMF|', 77773, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113522009||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA BONOS CORPORATIVOS FLOTANTES', 'ES0113278008', 'EUR', 2, '|f_es_BMF|', 77785, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113278008||es||False', false, '{NULL,F00000GUYC,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA BONOS CORTO PLAZO', 'ES0113101036', 'EUR', 2, '|f_es_BMF|', 77813, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113101036||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA BONOS CORTO PLAZO GOBIERNO', 'ES0113752002', 'EUR', 2, '|f_es_BMF|', 77814, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113752002||es||False', false, '{NULL,F0000026D1,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA BONOS CORTO PLUS EMPRESAS FI', 'ES0113193033', 'EUR', 2, '|f_es_BMF|', 74783, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113193033||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA BONOS DOLAR CORTO PLAZO', 'ES0114341037', 'EUR', 2, '|f_es_BMF|', 78888, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114341037||es||False', false, '{NULL,F0GBR051T6,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA BONOS DURACION', 'ES0114487038', 'EUR', 2, '|f_es_BMF|', 77815, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114487038||es||False', false, '{NULL,F0GBR04CP3,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA BONOS DURACION FLEXIBLE', 'ES0113203030', 'EUR', 2, '|f_es_BMF|', 77905, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113203030||es||False', false, '{NULL,F0GBR04D5E,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA BONOS INTERES FLOTANTE', 'ES0113196036', 'EUR', 2, '|f_es_BMF|', 76562, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113196036||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA BONOS INTERNACIONAL FLEXIBLE', 'ES0110174036', 'EUR', 2, '|f_es_BMF|', 77957, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0110174036||es||False', false, '{NULL,F0GBR04ZMK,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA BONOS LARGO PLAZO GOBIER.II', 'ES0162081030', 'EUR', 2, '|f_es_BMF|', 76612, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0162081030||es||False', false, '{NULL,F0GBR04MO2,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA BONOS LARGO PLAZO GOBIERNOS', 'ES0110001031', 'EUR', 2, '|f_es_BMF|', 76613, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0110001031||es||False', false, '{NULL,F0GBR05T5R,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA BONOS L.P.FLEXIBLES', 'ES0108926033', 'EUR', 2, '|f_es_BMF|', 76378, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0108926033||es||False', false, '{NULL,F0GBR04O1K,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA BONOS VALOR RELATIVO', 'ES0113857033', 'EUR', 2, '|f_es_BMF|', 76614, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113857033||es||False', false, '{NULL,F000000376,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA CESTA GLOBAL', 'ES0114300033', 'EUR', 2, '|f_es_BMF|', 77959, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114300033||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA CESTA GLOBAL II', 'ES0114372032', 'EUR', 2, '|f_es_BMF|', 77962, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114372032||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA CODESPA MICROFINANZAS', 'ES0113955035', 'EUR', 2, '|f_es_BMF|', 77259, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113955035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA CONSOLIDA GARANTIZADO 3', 'ES0125461030', 'EUR', 2, '|f_es_BMF|', 79030, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0125461030||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA CONSOLIDA GARANTIZADO II', 'ES0133762031', 'EUR', 2, '|f_es_BMF|', 77600, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133762031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA CONSOLIDADO GARANTIZADO', 'ES0110123033', 'EUR', 2, '|f_es_BMF|', 78060, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0110123033||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA DESTACADOS BP, FI', 'ES0113279006', 'EUR', 2, '|f_es_BMF|', 75215, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113279006||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA DINERO', 'ES0113202032', 'EUR', 2, '|f_es_BMF|', 75737, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113202032||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA DINERO PLUS', 'ES0170925038', 'EUR', 2, '|f_es_BMF|', 78071, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0170925038||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA DJ EUROSTOXX 50 4 PLUS A', 'ES0110079037', 'EUR', 2, '|f_es_BMF|', 78074, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0110079037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA DJ EUROSTOXX 50 4 PLUS B', 'ES0109997033', 'EUR', 2, '|f_es_BMF|', 78076, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0109997033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA DJ EUROSTOXX 50 4 PLUS C', 'ES0138513033', 'EUR', 2, '|f_es_BMF|', 78056, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138513033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA DJ EUROSTOXX 50 4 PLUS D', 'ES0110186030', 'EUR', 2, '|f_es_BMF|', 75743, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0110186030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA DJ EUROSTOXX 50 4 PLUS', 'ES0113957031', 'EUR', 2, '|f_es_BMF|', 78073, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113957031||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA DOBLE GARANTIA', 'ES0113753000', 'EUR', 2, '|f_es_BMF|', 75760, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113753000||es||False', false, '{NULL,F000002L64,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA DOBLE GARANTIA II', 'ES0113754008', 'EUR', 2, '|f_es_BMF|', 76615, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113754008||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA ELECCION OPTIMA GARANTIZADO', 'ES0114175039', 'EUR', 2, '|f_es_BMF|', 76027, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114175039||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA ELECCION OPTIMA GARANTIZADO II', 'ES0109995037', 'EUR', 2, '|f_es_BMF|', 76028, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0109995037||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA ELITE PROTEGIDO', 'ES0114788005', 'EUR', 2, '|f_es_BMF|', 75790, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114788005||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA', 'ES0113211835', 'EUR', 1, '|EUROSTOXX|IBEX|MERCADOCONTINUO|', 81112, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0113211835||es||True', false, '{BBVA.MC,NULL,BME:BBVA,NULL,BBVA}', false, 2);
INSERT INTO public.products VALUES ('BBVA ESTRUCTURADO ALIMENTACIÓN FI', 'ES0161364007', 'EUR', 2, '|f_es_BMF|', 74798, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0161364007||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA ESTRUCTURADO FINANZAS BP', 'ES0113821005', 'EUR', 2, '|f_es_BMF|', 77796, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113821005||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA ESTRUCTURADO TELECOM. II BP', 'ES0113822003', 'EUR', 2, '|f_es_BMF|', 77797, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113822003||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA EUROPA GARANIZADO II', 'ES0114094032', 'EUR', 2, '|f_es_BMF|', 77798, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114094032||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA EUROPA GARANTIZADO', 'ES0142443037', 'EUR', 2, '|f_es_BMF|', 77799, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0142443037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA EUROPA GARANTIZADO III', 'ES0114188032', 'EUR', 2, '|f_es_BMF|', 78097, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114188032||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA EUROPA MULTIPLE 6', 'ES0113858007', 'EUR', 2, '|f_es_BMF|', 76065, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113858007||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA EUROPA OBJETIVO 125', 'ES0115162002', 'EUR', 2, '|f_es_BMF|', 76067, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115162002||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA EUROPA OBJETIVO 125 II', 'ES0113859005', 'EUR', 2, '|f_es_BMF|', 76960, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113859005||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA EUROPA OPTIMO', 'ES0113458030', 'EUR', 2, '|f_es_BMF|', 78099, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113458030||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA EUSKOFONDO', 'ES0113994034', 'EUR', 2, '|f_es_BMF|', 75390, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113994034||es||False', false, '{NULL,F0GBR04Q9N,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA EVOLUCION V, 10', 'ES0113988036', 'EUR', 2, '|f_es_BMF|', 76664, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113988036||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA EVOLUCION V, 5', 'ES0113555009', 'EUR', 2, '|f_es_BMF|', 78105, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113555009||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA EXTRA 10', 'ES0113969036', 'EUR', 2, '|f_es_BMF|', 75293, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113969036||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA EXTRA 5 ACCIONES II', 'ES0113456034', 'EUR', 2, '|f_es_BMF|', 75554, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113456034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA EXTRA 5 GARANTIZADO', 'ES0145927036', 'EUR', 2, '|f_es_BMF|', 76068, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0145927036||es||False', false, '{NULL,F0GBR04EQB,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA EXTRA 5 II GARANTIZADO', 'ES0145928034', 'EUR', 2, '|f_es_BMF|', 78106, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0145928034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA EXTRA TESORERIA', 'ES0110091032', 'EUR', 2, '|f_es_BMF|', 76072, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0110091032||es||False', false, '{NULL,F0GBR04Q95,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA FONDPLAZO DOBLE-BEX', 'ES0110167030', 'EUR', 2, '|f_es_BMF|', 77869, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0110167030||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA FON-PLAZO 2009 D', 'ES0180662001', 'EUR', 2, '|f_es_BMF|', 76380, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0180662001||es||False', false, '{NULL,F0000021KT,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA FON-PLAZO 2011 B', 'ES0113954038', 'EUR', 2, '|f_es_BMF|', 77549, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113954038||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA FON-PLAZO 2011 C', 'ES0113856035', 'EUR', 2, '|f_es_BMF|', 75399, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113856035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA FON-PLAZO 2011', 'ES0114383039', 'EUR', 2, '|f_es_BMF|', 77448, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114383039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA FON-PLAZO 2012 B', 'ES0113959003', 'EUR', 2, '|f_es_BMF|', 76112, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113959003||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA FON-PLAZO 2012 C', 'ES0113926036', 'EUR', 2, '|f_es_BMF|', 79031, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113926036||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA FON-PLAZO 2012 D', 'ES0180664007', 'EUR', 2, '|f_es_BMF|', 76122, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0180664007||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA FON-PLAZO 2012', 'ES0113459038', 'EUR', 2, '|f_es_BMF|', 75401, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113459038||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA FON-PLAZO 2012 F', 'ES0113098034', 'EUR', 2, '|f_es_BMF|', 76124, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113098034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA FON-PLAZO 2012 G', 'ES0142444001', 'EUR', 2, '|f_es_BMF|', 76136, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0142444001||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA FON-PLAZO 2013 B', 'ES0115161004', 'EUR', 2, '|f_es_BMF|', 76137, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115161004||es||False', false, '{NULL,F000000H6R,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA FON-PLAZO 2013 D', 'ES0115163000', 'EUR', 2, '|f_es_BMF|', 76145, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115163000||es||False', false, '{NULL,F000005OJQ,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA FON-PLAZO 2013 F', 'ES0115164008', 'EUR', 2, '|f_es_BMF|', 74858, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115164008||es||False', false, '{NULL,F00000H6L5,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA FON-PLAZO 2014 B', 'ES0114099007', 'EUR', 2, '|f_es_BMF|', 76171, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114099007||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA FON-PLAZO 2014 C', 'ES0113823001', 'EUR', 2, '|f_es_BMF|', 77350, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113823001||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA FON-PLAZO 2014 D', 'ES0138704038', 'EUR', 2, '|f_es_BMF|', 77863, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138704038||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA FON-PLAZO 2014', 'ES0142445008', 'EUR', 2, '|f_es_BMF|', 78700, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0142445008||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA GARANTIZADO 5 X 5 II', 'ES0114189006', 'EUR', 2, '|f_es_BMF|', 76187, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114189006||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA GARANTIZADO 5X5', 'ES0113552030', 'EUR', 2, '|f_es_BMF|', 79032, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113552030||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA GARANTIZADO DOBLE 10', 'ES0114096037', 'EUR', 2, '|f_es_BMF|', 77873, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114096037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA GARAN.TOP DIVIDENDO 100', 'ES0145924033', 'EUR', 2, '|f_es_BMF|', 77871, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0145924033||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA GESTION CONSERVADORA', 'ES0110178037', 'EUR', 2, '|f_es_BMF|', 77872, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0110178037||es||False', false, '{NULL,F0GBR04ZLI,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA GESTION CORTO PLAZO', 'ES0114207030', 'EUR', 2, '|f_es_BMF|', 77351, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114207030||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA GESTION CORTO PLAZO II FI', 'ES0114228036', 'EUR', 2, '|f_es_BMF|', 74828, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114228036||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA GESTION DECIDIDA', 'ES0113996039', 'EUR', 2, '|f_es_BMF|', 78145, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113996039||es||False', false, '{NULL,F0GBR04LF0,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA GESTION MODERADA', 'ES0113993036', 'EUR', 2, '|f_es_BMF|', 76189, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113993036||es||False', false, '{NULL,F0GBR04Q8Y,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA GESTION PROTECCION', 'ES0114097035', 'EUR', 2, '|f_es_BMF|', 77357, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114097035||es||False', false, '{NULL,F0000001TD,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA GESTIÓN PROYECTO 2010 FI', 'ES0114208038', 'EUR', 2, '|f_es_BMF|', 74836, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114208038||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA GESTIÓN PROYECTO 2012 FI', 'ES0114144035', 'EUR', 2, '|f_es_BMF|', 74813, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114144035||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA GLOBAL AUTOCANCELABLE BP', 'ES0113825006', 'EUR', 2, '|f_es_BMF|', 76195, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113825006||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA INDICE USA PLUS', 'ES0134599036', 'EUR', 2, '|f_es_BMF|', 76198, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0134599036||es||False', false, '{NULL,F0GBR04Q9H,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA INDICES 120', 'ES0114098009', 'EUR', 2, '|f_es_BMF|', 75633, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114098009||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA INFLACION II', 'ES0113553004', 'EUR', 2, '|f_es_BMF|', 77358, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113553004||es||False', false, '{NULL,F0000024PW,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA INVERSION EUROPA', 'ES0113554002', 'EUR', 2, '|f_es_BMF|', 77359, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113554002||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA INVERSION EUROPA II', 'ES0113854030', 'EUR', 2, '|f_es_BMF|', 79033, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113854030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA MULTIFONDO DINÁMICO FI', 'ES0114373030', 'EUR', 2, '|f_es_BMF|', 74829, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114373030||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA OPCION 10X3 BP', 'ES0114229000', 'EUR', 2, '|f_es_BMF|', 78992, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114229000||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA OPORTUNIDAD EUROPA BP', 'ES0114210000', 'EUR', 2, '|f_es_BMF|', 78996, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114210000||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA OPORTUNIDAD GEOGRAFICA GARAN.II', 'ES0184826032', 'EUR', 2, '|f_es_BMF|', 77360, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0184826032||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA OPORTUNIDAD GEOGRAFICA GARANTIZADO', 'ES0114142039', 'EUR', 2, '|f_es_BMF|', 76199, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114142039||es||False', false, '{NULL,F0GBR04OMQ,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA PLAN RENTA', 'ES0113204038', 'EUR', 2, '|f_es_BMF|', 76200, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113204038||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA PLAN RENTAS 10 B', 'ES0142334038', 'EUR', 2, '|f_es_BMF|', 76201, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0142334038||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA PLAN RENTAS 2007 G', 'ES0114132030', 'EUR', 2, '|f_es_BMF|', 78198, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114132030||es||False', false, '{NULL,F0GBR05WLU,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA PLAN RENTAS 2008 B', 'ES0177865039', 'EUR', 2, '|f_es_BMF|', 76418, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0177865039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA PLAN RENTAS 2008 D', 'ES0147709036', 'EUR', 2, '|f_es_BMF|', 77907, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147709036||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA PLAN RENTAS 2009 C', 'ES0109998031', 'EUR', 2, '|f_es_BMF|', 77967, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0109998031||es||False', false, '{NULL,F0GBR055FL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA PLAN RENTAS 2009 D FI', 'ES0109999039', 'EUR', 2, '|f_es_BMF|', 74834, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0109999039||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA PLAN RENTAS 2009', 'ES0125465031', 'EUR', 2, '|f_es_BMF|', 77912, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0125465031||es||False', false, '{NULL,F0GBR054LI,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA PLAN RENTAS 2010 B', 'ES0116856032', 'EUR', 2, '|f_es_BMF|', 77971, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0116856032||es||False', false, '{NULL,F0GBR05SL1,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA PLAN RENTAS 2010 C', 'ES0108930035', 'EUR', 2, '|f_es_BMF|', 77972, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0108930035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA PLAN RENTAS 2010 D', 'ES0108931033', 'EUR', 2, '|f_es_BMF|', 77977, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0108931033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA PLAN RENTAS 2010 E', 'ES0108932031', 'EUR', 2, '|f_es_BMF|', 78146, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0108932031||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA PLAN RENTAS 2010', 'ES0110000033', 'EUR', 2, '|f_es_BMF|', 77968, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0110000033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA PLAN RENTAS 2010 F', 'ES0169986033', 'EUR', 2, '|f_es_BMF|', 78147, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0169986033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA PLAN RENTAS 2010 G', 'ES0169987031', 'EUR', 2, '|f_es_BMF|', 78201, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0169987031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA PLAN RENTAS 2010 I FI', 'ES0110082031', 'EUR', 2, '|f_es_BMF|', 74835, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0110082031||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA PLAN RENTAS 2010 J FI', 'ES0147632030', 'EUR', 2, '|f_es_BMF|', 74830, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147632030||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA PLAN RENTAS 2010 L FI', 'ES0114136031', 'EUR', 2, '|f_es_BMF|', 74831, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114136031||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA PLAN RENTAS 2011 B', 'ES0138490034', 'EUR', 2, '|f_es_BMF|', 78202, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138490034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA PLAN RENTAS 2011 C', 'ES0169988039', 'EUR', 2, '|f_es_BMF|', 78203, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0169988039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA PLAN RENTAS 2011 D', 'ES0147629036', 'EUR', 2, '|f_es_BMF|', 78204, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147629036||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA PLAN RENTAS 2011 E', 'ES0133764037', 'EUR', 2, '|f_es_BMF|', 78702, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133764037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA PLAN RENTAS 2011', 'ES0114417035', 'EUR', 2, '|f_es_BMF|', 77450, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114417035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA PLAN RENTAS 2011 F', 'ES0113425039', 'EUR', 2, '|f_es_BMF|', 76251, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113425039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA PLAN RENTAS 2011 G', 'ES0113426037', 'EUR', 2, '|f_es_BMF|', 76252, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113426037||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA PLAN RENTAS 2012 B', 'ES0169989037', 'EUR', 2, '|f_es_BMF|', 76254, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0169989037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA PLAN RENTAS 2012 C', 'ES0169990035', 'EUR', 2, '|f_es_BMF|', 76216, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0169990035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA PLAN RENTAS 2012 D', 'ES0113427035', 'EUR', 2, '|f_es_BMF|', 79001, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113427035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA PLAN RENTAS 2012 E', 'ES0116855034', 'EUR', 2, '|f_es_BMF|', 79002, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0116855034||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA PLAN RENTAS 2012', 'ES0114455035', 'EUR', 2, '|f_es_BMF|', 76253, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114455035||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA PLAN RENTAS 2012 F', 'ES0113428033', 'EUR', 2, '|f_es_BMF|', 79025, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113428033||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA PLAN RENTAS 2012 G', 'ES0113429007', 'EUR', 2, '|f_es_BMF|', 76237, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113429007||es||False', false, '{NULL,F0000006Q9,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA PROPIEDAD', 'ES0110179035', 'EUR', 2, '|f_es_BMF|', 76951, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0110179035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA RANKING PLUS FI', 'ES0116857030', 'EUR', 2, '|f_es_BMF|', 74837, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0116857030||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA RENTA FIJA CORTO PLUS', 'ES0176232033', 'EUR', 2, '|f_es_BMF|', 78707, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0176232033||es||False', false, '{NULL,F0GBR04CUP,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA RENTA FIJA LARGO 6', 'ES0138889037', 'EUR', 2, '|f_es_BMF|', 78242, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138889037||es||False', false, '{NULL,F0GBR04Q93,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA RENTABILIDAD 2012', 'ES0169992007', 'EUR', 2, '|f_es_BMF|', 78249, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0169992007||es||False', false, '{NULL,F00000LYYC,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA RENTAS 2009 B', 'ES0114146030', 'EUR', 2, '|f_es_BMF|', 78250, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114146030||es||False', false, '{NULL,F0GBR04VUU,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA SELECCION CONSUMO BP', 'ES0116860000', 'EUR', 2, '|f_es_BMF|', 78286, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0116860000||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA SELECCION EMPRESAS BP', 'ES0116859002', 'EUR', 2, '|f_es_BMF|', 78287, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0116859002||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA SOLIDARIDAD', 'ES0114279039', 'EUR', 2, '|f_es_BMF|', 78288, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114279039||es||False', false, '{NULL,F0GBR051Q9,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA SOLIDEZ BP', 'ES0110006006', 'EUR', 2, '|f_es_BMF|', 78293, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0110006006||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA SOLIDEZ II BP', 'ES0110007004', 'EUR', 2, '|f_es_BMF|', 78296, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0110007004||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA SOLIDEZ III BP', 'ES0110008002', 'EUR', 2, '|f_es_BMF|', 76320, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0110008002||es||False', false, '{NULL,F000003WYP,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA SOLIDEZ IX BP', 'ES0116861008', 'EUR', 2, '|f_es_BMF|', 76321, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0116861008||es||False', false, '{NULL,F00000LZ24,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA SOLIDEZ VI', 'ES0110009000', 'EUR', 2, '|f_es_BMF|', 76322, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0110009000||es||False', false, '{NULL,F00000GWPE,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA SOLIDEZ VII', 'ES0110010008', 'EUR', 2, '|f_es_BMF|', 76332, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0110010008||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA SOLIDEZ VIII BP', 'ES0110011006', 'EUR', 2, '|f_es_BMF|', 78735, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0110011006||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA TOP 14 GARANTIZADO', 'ES0114151006', 'EUR', 2, '|f_es_BMF|', 78300, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114151006||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA TOP 5 GARANTIZADO', 'ES0114152004', 'EUR', 2, '|f_es_BMF|', 75879, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114152004||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA TOP 5 GARANTIZADO II', 'ES0114321039', 'EUR', 2, '|f_es_BMF|', 75885, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114321039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA TOP 5 GARANTIZADO III', 'ES0113457032', 'EUR', 2, '|f_es_BMF|', 75896, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113457032||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA TOP 5 GARANTIZADO IV', 'ES0125468001', 'EUR', 2, '|f_es_BMF|', 76765, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0125468001||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVA TOP GARANTIZADO 4', 'ES0114226030', 'EUR', 2, '|f_es_BMF|', 76799, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114226030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BBVAIBOXXINV', 'ES0142446006', 'EUR', 4, '', 81425, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0142446006||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BCE INC.', NULL, 'USD', 1, '', 77642, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BCE||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BCI NAVIGATION', 'FR0000076192', 'EUR', 1, '|EURONEXT|', 77768, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000076192||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('B.COM.PORTUGUES', 'PTBCP0AM0007', 'EUR', 1, '|EURONEXT|', 77767, NULL, NULL, NULL, NULL, 100, 'c', 1, 9, 'EURONEXT#PTBCP0AM0007||pt||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BCPDI11(0.04399P1)', 'PTBCP0AMI015', 'EUR', 1, '|EURONEXT|', 77398, NULL, NULL, NULL, NULL, 100, 'c', 1, 9, 'EURONEXT#PTBCP0AMI015||pt||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BCPS (0.1113585P1)', 'PTBCP0AMS055', 'EUR', 1, '|EURONEXT|', 75002, NULL, NULL, NULL, NULL, 100, 'c', 1, 9, 'EURONEXT#PTBCP0AMS055||pt||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BDI - BIOENERGY INTERNATIONAL AG', 'AT0000A02177', 'EUR', 1, '|DEUTSCHEBOERSE|', 77948, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#AT0000A02177||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BE SEMICONDUCTOR', 'NL0000339760', 'EUR', 1, '|EURONEXT|', 79543, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0000339760||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BEAM INC.', 'US0737301038', 'USD', 1, '|SP500|', 77904, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BEAM||us||False', true, '{BEAM,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BEAM', 'US0737301038', 'EUR', 1, '|EURONEXT|', 75548, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#US0737301038||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BEATE UHSE AG', 'DE0007551400', 'EUR', 1, '|DEUTSCHEBOERSE|', 80555, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0007551400||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BEAZER HOMES USA INC.', NULL, 'USD', 1, '', 80958, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BZH||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BECHTLE AG', 'DE0005158703', 'EUR', 1, '|DEUTSCHEBOERSE|', 80556, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005158703||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BECKMAN COULTER INC.', NULL, 'USD', 1, '', 77382, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BEC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BECTON DICKINSON & CO.', NULL, 'USD', 1, '|SP500|', 77949, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BDX||us||False', false, '{BDX,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BED BATH & BEYOND INC', 'US0758961009', 'USD', 1, '|NASDAQ100|SP500|', 76701, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'BBBY||us||False', false, '{BBBY,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BEFESA', 'ES0114491014', 'EUR', 1, '|MERCADOCONTINUO|', 77343, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0114491014||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BEFIMMO-SICAFI', 'BE0003678894', 'EUR', 1, '|EURONEXT|', 75777, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003678894||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BEIERSDORF AKTIENGESELLSCHAFT', 'DE0005200000', 'EUR', 1, '|DAX|DEUTSCHEBOERSE|', 80557, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005200000||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BEKAERT (D)', 'BE0974258874', 'EUR', 1, '|EURONEXT|', 77774, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0974258874||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BEKAERT STRIP (D)', 'BE0005640140', 'EUR', 1, '|EURONEXT|', 79987, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0005640140||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BELDEN INC.', NULL, 'USD', 1, '', 78730, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BDC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BELGACOM', 'BE0003810273', 'EUR', 1, '|EURONEXT|', 77776, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003810273||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BELGRAVIA EPSILON', 'ES0114353032', 'EUR', 2, '|f_es_BMF|', 79406, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114353032||es||False', false, '{NULL,F0GBR0526F,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BELIER', 'FR0000072399', 'EUR', 1, '|EURONEXT|', 75780, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000072399||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BELO CORP. SERIES A', NULL, 'USD', 1, '', 79550, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BLC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BELRECA', 'BE0020575115', 'EUR', 1, '|EURONEXT|', 76940, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0020575115||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BELUGA', 'BE0003723377', 'EUR', 1, '|EURONEXT|', 75596, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003723377||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BELUGA STRIP', 'BE0005535068', 'EUR', 1, '|EURONEXT|', 75579, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0005535068||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BELVEDERE BSA 2004', 'FR0010134247', 'EUR', 1, '|EURONEXT|', 75583, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010134247||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BELVEDERE BSA 2006', 'FR0010304733', 'EUR', 1, '|EURONEXT|', 80005, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010304733||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BELVEDERE', 'FR0000060873', 'EUR', 1, '|EURONEXT|', 76736, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000060873||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BEMIS CO. INC.', NULL, 'USD', 1, '|SP500|', 76557, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BMS||us||False', false, '{BMS,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BENCHMARK ELECTRONICS INC.', NULL, 'USD', 1, '', 79324, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BHE||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BENETEAU', 'FR0000035164', 'EUR', 1, '|EURONEXT|', 80006, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000035164||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BENFICA', 'PTSLB0AM0010', 'EUR', 1, '|EURONEXT|', 80007, NULL, NULL, NULL, NULL, 100, 'c', 1, 9, 'EURONEXT#PTSLB0AM0010||pt||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BENI STABILI', 'IT0001389631', 'EUR', 1, '|EURONEXT|', 78233, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#IT0001389631||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BERNARD LOISEAU', 'FR0000066961', 'EUR', 1, '|EURONEXT|', 78218, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000066961||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BERRY PETROLEUM CO. CL A', NULL, 'USD', 1, '', 78950, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BRY||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BERTRANDT AG', 'DE0005232805', 'EUR', 1, '|DEUTSCHEBOERSE|', 80558, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005232805||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('B.ESPIRITO SANTO', 'PTBES0AM0007', 'EUR', 1, '|EURONEXT|', 79963, NULL, NULL, NULL, NULL, 100, 'c', 1, 9, 'EURONEXT#PTBES0AM0007||pt||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BEST BUY CO. INC.', NULL, 'USD', 1, '|SP500|', 78278, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BBY||us||False', false, '{BBY,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BEST CARMIGNAC', 'ES0114572003', 'EUR', 2, '|f_es_BMF|', 78740, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114572003||es||False', false, '{NULL,F00000MABH,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BEST JPMORGAN AM', 'ES0114524004', 'EUR', 2, '|f_es_BMF|', 78741, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114524004||es||False', false, '{NULL,F00000MABJ,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BEST MORGAN STANLEY', 'ES0145808004', 'EUR', 2, '|f_es_BMF|', 78263, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0145808004||es||False', false, '{NULL,F00000MABI,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BEST TIMING FUND', 'ES0114592035', 'EUR', 2, '|f_es_BMF|', 78319, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114592035||es||False', false, '{NULL,F0000001TO,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BEST TIMING FUND II', 'ES0114560008', 'EUR', 2, '|f_es_BMF|', 78322, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114560008||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BESTINFOND', 'ES0114673033', 'EUR', 2, '|f_es_BMF|', 78323, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114673033||es||False', false, '{NULL,F0GBR04PSV,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BESTINVER BOLSA', 'ES0147622031', 'EUR', 2, '|f_es_BMF|', 78324, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147622031||es||False', false, '{NULL,F0GBR04PSZ,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BESTINVER HEDGE VALUE FUND', 'ES0114578000', 'EUR', 2, '|f_es_BMF|', 77476, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114578000||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BESTINVER INTERNACIONAL', 'ES0114638036', 'EUR', 2, '|f_es_BMF|', 78330, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114638036||es||False', false, '{NULL,F0GBR04PSY,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BESTINVER MIXTO', 'ES0114664032', 'EUR', 2, '|f_es_BMF|', 78719, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114664032||es||False', false, '{NULL,F0GBR04PSX,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BESTINVER MIXTO INTERNACIONAL', 'ES0114618038', 'EUR', 2, '|f_es_BMF|', 77461, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114618038||es||False', false, '{NULL,F0GBR04ISV,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BESTINVER RENTA', 'ES0114675038', 'EUR', 2, '|f_es_BMF|', 78331, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114675038||es||False', false, '{NULL,F0GBR04PSW,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BETA ACCIONES', 'ES0114677034', 'EUR', 2, '|f_es_BMF|', 77492, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114677034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BETA ACTIVOS MONETARIO', 'ES0117010035', 'EUR', 2, '|f_es_BMF|', 76760, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0117010035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BETA ALPHA DINÁMICO FI', 'ES0114641030', 'EUR', 2, '|f_es_BMF|', 74838, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114641030||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BETA DEUDA  FONDT.LARGO PLAZO', 'ES0114671037', 'EUR', 2, '|f_es_BMF|', 76667, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114671037||es||False', false, '{NULL,F0GBR04CB7,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BETA RENTA FI', 'ES0114666037', 'EUR', 2, '|f_es_BMF|', 74839, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114666037||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BETA RENTA VARIABLE GLOBAL FI', 'ES0114668033', 'EUR', 2, '|f_es_BMF|', 74840, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114668033||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BETA SYSTEMS SOFTWARE AG', 'DE0005224406', 'EUR', 1, '|DEUTSCHEBOERSE|', 74998, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005224406||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BETA VALOR FI', 'ES0125931032', 'EUR', 2, '|f_es_BMF|', 74841, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0125931032||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BETER BED', 'NL0000339703', 'EUR', 1, '|EURONEXT|', 80008, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0000339703||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BEVER HOLDING', 'NL0000285278', 'EUR', 1, '|EURONEXT|', 76512, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0000285278||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BG BOLSA INTERNACIONAL', 'ES0134608035', 'EUR', 2, '|f_es_BMF|', 78205, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0134608035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BG BRIC GARANTIZADO', 'ES0114612031', 'EUR', 2, '|f_es_BMF|', 74752, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114612031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BG CAPITAL ASEGURADO', 'ES0144096031', 'EUR', 2, '|f_es_BMF|', 78353, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0144096031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BG DINERO', 'ES0114686035', 'EUR', 2, '|f_es_BMF|', 75058, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114686035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BG ENERGIA GARANTIZADA', 'ES0114613005', 'EUR', 2, '|f_es_BMF|', 78355, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114613005||es||False', false, '{NULL,F000000ASF,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BG EURO YIELD', 'ES0184976035', 'EUR', 2, '|f_es_BMF|', 78004, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0184976035||es||False', false, '{NULL,F0GBR04JVG,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BG EUROMARKET BOLSA', 'ES0144098037', 'EUR', 2, '|f_es_BMF|', 77950, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0144098037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BG EUSKOVALOR', 'ES0184977033', 'EUR', 2, '|f_es_BMF|', 78014, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0184977033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BG FONCARTERA 1', 'ES0114682034', 'EUR', 2, '|f_es_BMF|', 78357, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114682034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BG FOND EMPRESA', 'ES0134609033', 'EUR', 2, '|f_es_BMF|', 78008, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0134609033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('B&G FOODS INC.', NULL, 'USD', 1, '', 79285, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BGS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BG GESTION INMOB.GARANTIZADA 2', 'ES0114623038', 'EUR', 2, '|f_es_BMF|', 78365, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114623038||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BG GESTION INMOBILIARIA GARANT.3', 'ES0114624036', 'EUR', 2, '|f_es_BMF|', 77042, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114624036||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BG GESTION INMOBILIARIA GARANTIZADA', 'ES0125933038', 'EUR', 2, '|f_es_BMF|', 78010, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0125933038||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BG INDICE GARANTIZADO', 'ES0114625033', 'EUR', 2, '|f_es_BMF|', 76621, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114625033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BG IZARBE', 'ES0156332035', 'EUR', 2, '|f_es_BMF|', 78371, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0156332035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BG MIXTO 25', 'ES0144099035', 'EUR', 2, '|f_es_BMF|', 78378, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0144099035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BG MIXTO 50', 'ES0144100031', 'EUR', 2, '|f_es_BMF|', 78379, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0144100031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BHP BILLITON LTD.', NULL, 'USD', 1, '', 75090, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BHP||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BHP BILLITON PLC', NULL, 'USD', 1, '', 75129, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BBL||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BIC', 'FR0000120966', 'EUR', 1, '|EURONEXT|', 80355, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000120966||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BIENVENIDOS A POPULAR', 'ES0125935009', 'EUR', 2, '|f_es_BMF|', 78720, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0125935009||es||False', false, '{NULL,F00000JODJ,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BIG LOTS INC.', NULL, 'USD', 1, '|SP500|', 78936, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BIG||us||False', false, '{BIG,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BIGBEN INTERACTIVE', 'FR0000074072', 'EUR', 1, '|EURONEXT|', 76696, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000074072||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BIGLARI HOLDINGS INC.', NULL, 'USD', 1, '', 79644, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BH||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BILFINGER BERGER SE', 'DE0005909006', 'EUR', 1, '|DEUTSCHEBOERSE|', 78745, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005909006||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BILL BARRETT CORP.', NULL, 'USD', 1, '', 81623, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BBG||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BINCKBANK', 'NL0000335578', 'EUR', 1, '|EURONEXT|', 80383, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0000335578||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BIOALLIANCE DS', 'FR0011073493', 'EUR', 1, '|EURONEXT|', 78217, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0011073493||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BIOALLIANCE PHARMA', 'FR0010095596', 'EUR', 1, '|EURONEXT|', 75782, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010095596||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BIOGEN IDEC INC.', 'US09062X1037', 'USD', 1, '|NASDAQ100|SP500|', 77580, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'BIIB||us||False', false, '{BIIB,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BIOLITEC AG', 'DE0005213409', 'EUR', 1, '|DEUTSCHEBOERSE|', 78746, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005213409||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BIOMED REALTY TRUST INC.', NULL, 'USD', 1, '', 78532, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BMR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BIOMERIEUX', 'FR0010096479', 'EUR', 1, '|EURONEXT|', 78966, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010096479||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BIO-RAD LABORATORIES INC. CL A', NULL, 'USD', 1, '', 77132, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BIO||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BIOSEARCH', 'ES0172233118', 'EUR', 1, '|MERCADOCONTINUO|', 80839, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0172233118||es||False', false, '{BIO.MC,NULL,BME:BIO,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BIOTECH (PRICAF)', 'BE0003795128', 'EUR', 1, '|EURONEXT|', 77771, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003795128||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BIOTEST AG ST', 'DE0005227201', 'EUR', 1, '|DEUTSCHEBOERSE|', 78749, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005227201||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BIOTEST AG VZ', 'DE0005227235', 'EUR', 1, '|DEUTSCHEBOERSE|', 80793, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005227235||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BISCUITS GARDEIL', 'FR0000065435', 'EUR', 1, '|EURONEXT|', 80015, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000065435||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BITAUTO HOLDINGS LTD.', NULL, 'USD', 1, '', 80487, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BITA||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BIZKAIFONDO', 'ES0114865035', 'EUR', 2, '|f_es_BMF|', 78420, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114865035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BIZKAIRENT FONDTESORO', 'ES0114870035', 'EUR', 2, '|f_es_BMF|', 78342, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114870035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BJ''S WHOLESALE CLUB INC.', NULL, 'USD', 1, '', 77555, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BJ||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BK 2012 GARANTIZADO', 'ES0114796032', 'EUR', 2, '|f_es_BMF|', 78459, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114796032||es||False', false, '{NULL,F0GBR04Q6N,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BK ACUERDO DE GESTION DIN.EMPRES', 'ES0134613035', 'EUR', 2, '|f_es_BMF|', 80865, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0134613035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BK ACUERDO GESTION MODERADO EMPR', 'ES0114696034', 'EUR', 2, '|f_es_BMF|', 80874, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114696034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BK BOLSA ESPAÑA 2', 'ES0125621039', 'EUR', 2, '|f_es_BMF|', 78493, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0125621039||es||False', false, '{NULL,F0GBR04Q6U,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BK BOLSA ESPAÑA', 'ES0125631038', 'EUR', 2, '|f_es_BMF|', 78498, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0125631038||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BK BOLSA EURIBEX', 'ES0138962032', 'EUR', 2, '|f_es_BMF|', 78268, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138962032||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BK BOLSA EUROPA', 'ES0114866033', 'EUR', 2, '|f_es_BMF|', 78271, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114866033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BK DINERO', 'ES0114863030', 'EUR', 2, '|f_es_BMF|', 78273, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114863030||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BK EURO DIVIDENDO GARANTIZADO', 'ES0114791033', 'EUR', 2, '|f_es_BMF|', 77880, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114791033||es||False', false, '{NULL,F0GBR04C9T,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BK FONDO MONETARIO', 'ES0114868039', 'EUR', 2, '|f_es_BMF|', 76421, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114868039||es||False', false, '{NULL,F0GBR04Q7I,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BK FONDVALENCIA MIXTO', 'ES0114803036', 'EUR', 2, '|f_es_BMF|', 75589, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114803036||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BK FUTURO IBEX', 'ES0114794037', 'EUR', 2, '|f_es_BMF|', 75063, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114794037||es||False', false, '{NULL,F0GBR04Q8S,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BK GRAN RESERVA 40 ANIVERSARIO', 'ES0114102033', 'EUR', 2, '|f_es_BMF|', 80877, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114102033||es||False', false, '{NULL,F0GBR04C9X,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BK GRAN RESERVA 40 ANIVERS.III', 'ES0114875034', 'EUR', 2, '|f_es_BMF|', 80878, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114875034||es||False', false, '{NULL,F0GBR04Q9A,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BK G.RESERVA 40 ANIVERSARIO IV G', 'ES0114830039', 'EUR', 2, '|f_es_BMF|', 75417, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114830039||es||False', false, '{NULL,F0GBR04Q9E,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BK INDICE EUROPEO 50', 'ES0114754031', 'EUR', 2, '|f_es_BMF|', 76623, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114754031||es||False', false, '{NULL,F0GBR04Q9I,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BK INDICE GANADOR 7', 'ES0138954039', 'EUR', 2, '|f_es_BMF|', 78380, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138954039||es||False', false, '{NULL,F0GBR04D6A,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BK KILIMANJARO', 'ES0113550034', 'EUR', 2, '|f_es_BMF|', 78721, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113550034||es||False', false, '{NULL,F0GBR05VCL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BK MEMORIA EUROPA GARANTIZADO', 'ES0138955036', 'EUR', 2, '|f_es_BMF|', 75818, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138955036||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BK MIXTO ESPAÑA 30', 'ES0114804034', 'EUR', 2, '|f_es_BMF|', 75595, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114804034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BK MIXTO ESPAÑA 50', 'ES0114872031', 'EUR', 2, '|f_es_BMF|', 75605, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114872031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BK MIXTO EUROPA 20', 'ES0114793039', 'EUR', 2, '|f_es_BMF|', 78742, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114793039||es||False', false, '{NULL,F0GBR04BYV,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BK MIXTO EUROPA 50', 'ES0114877030', 'EUR', 2, '|f_es_BMF|', 77477, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114877030||es||False', false, '{NULL,F0GBR04Q6L,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BK PEQUENAS COMPANIAS', 'ES0114764030', 'EUR', 2, '|f_es_BMF|', 77482, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114764030||es||False', false, '{NULL,F0GBR05WO1,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BK RENTA VARIABLE EUROPEA', 'ES0114879036', 'EUR', 2, '|f_es_BMF|', 78754, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114879036||es||False', false, '{NULL,F0GBR04Q6Q,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BK SECTOR ENERGIA', 'ES0114806039', 'EUR', 2, '|f_es_BMF|', 78577, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114806039||es||False', false, '{NULL,F0GBR04K3O,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BK SECTOR FINANZAS', 'ES0114805031', 'EUR', 2, '|f_es_BMF|', 75127, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114805031||es||False', false, '{NULL,F0GBR04Q90,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BK SECTOR TELECOMUNICACIONES', 'ES0114797030', 'EUR', 2, '|f_es_BMF|', 78579, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114797030||es||False', false, '{NULL,F0GBR04Q6O,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BK SELECCION BASICOS GARANTIZADO', 'ES0113585006', 'EUR', 2, '|f_es_BMF|', 76670, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113585006||es||False', false, '{NULL,F000003YGO,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BK SELECCION BONOS CORPORATIVOS', 'ES0114857032', 'EUR', 2, '|f_es_BMF|', 76674, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114857032||es||False', false, '{NULL,F0GBR04CA1,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BLACK HILLS CORP.', NULL, 'USD', 1, '', 75822, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BKH||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BLACKROCK INC.', NULL, 'USD', 1, '|SP500|', 78810, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BLK||us||False', false, '{BLK,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BLACKROCK STRATEGIC FUNDS BSF AMERICAS DIVERSIFIED EQUITY ABSOLUTE RETURN FUND A2 EUR HEDGED', 'LU0725892466', 'EUR', 2, '', 81727, NULL, NULL, NULL, NULL, 0, 'c', 1, 18, NULL, false, '{NULL,F00000NR69,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BLEECKER', 'FR0000062150', 'EUR', 1, '|EURONEXT|', 76547, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000062150||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BLOUNT INTERNATIONAL INC.', NULL, 'USD', 1, '', 81564, 'http://www.blount.com/', NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BLT||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BLUEGREEN CORP.', NULL, 'USD', 1, '', 80537, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BXG||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BLUELINX HOLDINGS INC.', NULL, 'USD', 1, '', 80493, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BXC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BLYTH INC.', NULL, 'USD', 1, '', 79784, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BTH||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BMC SOFTWARE INC.', 'US0559211000', 'USD', 1, '|NASDAQ100|SP500|', 75741, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'BMC||us||False', false, '{BMC,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BMP AG', 'DE0003304200', 'EUR', 1, '|DEUTSCHEBOERSE|', 78750, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0003304200||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BMW AG ST', 'DE0005190003', 'EUR', 1, '|DAX|DEUTSCHEBOERSE|EUROSTOXX|', 78751, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005190003||de||False', false, '{BMW.DE,NULL,ETR:BMW,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BMW AG VZ', 'DE0005190037', 'EUR', 1, '|DEUTSCHEBOERSE|', 78752, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005190037||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BNP PARIBAS ACT.A', 'FR0000131104', 'EUR', 1, '|CAC|EURONEXT|EUROSTOXX|', 78967, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000131104||fr||False', false, '{BNP.PA,NULL,EPA:BNP,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BNP PARIBAS ALTERNATIVO DVR IICIICIL ACC', 'ES0150039008', 'EUR', 2, '|f_es_BMF|', 74842, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0150039008||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BNP PARIBAS BOLSA ESPAÑOLA', 'ES0125471039', 'EUR', 2, '|f_es_BMF|', 79408, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0125471039||es||False', false, '{NULL,F0GBR04IVX,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BNP PARIBAS BONOS', 'ES0118496035', 'EUR', 2, '|f_es_BMF|', 76278, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0118496035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BNP PARIBAS CASH', 'ES0150037036', 'EUR', 2, '|f_es_BMF|', 79444, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0150037036||es||False', false, '{NULL,F0GBR04Q2M,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BNP PARIBAS CONSERVADOR', 'ES0171954037', 'EUR', 2, '|f_es_BMF|', 75128, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0171954037||es||False', false, '{NULL,F0GBR04CXN,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BNP PARIBAS DINAMICO', 'ES0171956032', 'EUR', 2, '|f_es_BMF|', 76675, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0171956032||es||False', false, '{NULL,F0GBR04Q2P,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BNP PARIBAS EQUILIBRADO', 'ES0171955034', 'EUR', 2, '|f_es_BMF|', 77556, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0171955034||es||False', false, '{NULL,F0GBR04Q2O,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BNP PARIBAS EURO', 'ES0125472037', 'EUR', 2, '|f_es_BMF|', 77557, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0125472037||es||False', false, '{NULL,F0GBR04IW1,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BNP PARIBAS FONDO SOLIDARIDAD', 'ES0145874030', 'EUR', 2, '|f_es_BMF|', 76549, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0145874030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BNP PARIBAS GESTION ACTIVA', 'ES0118532037', 'EUR', 2, '|f_es_BMF|', 79449, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0118532037||es||False', false, '{NULL,F0GBR04IW5,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BNP PARIBAS GLOBAL ASSET ALLOCAT', 'ES0118531039', 'EUR', 2, '|f_es_BMF|', 79420, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0118531039||es||False', false, '{NULL,F0GBR04IVV,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BNP PARIBAS GLOBAL CONSERVATIVE', 'ES0118552035', 'EUR', 2, '|f_es_BMF|', 77558, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0118552035||es||False', false, '{NULL,F0GBR04IWN,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BNP PARIBAS GLOBAL DINVER', 'ES0160615037', 'EUR', 2, '|f_es_BMF|', 76676, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0160615037||es||False', false, '{NULL,F0GBR04KWY,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BNP PARIBAS GLOBAL III', 'ES0160617033', 'EUR', 2, '|f_es_BMF|', 75131, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0160617033||es||False', false, '{NULL,F0GBR04IWB,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BNP PARIBAS GLOBAL INVESTMENT', 'ES0118502030', 'EUR', 2, '|f_es_BMF|', 76713, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0118502030||es||False', false, '{NULL,F0GBR04ONL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BNP PARIBAS INSTITUCIONES', 'ES0118581034', 'EUR', 2, '|f_es_BMF|', 76714, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0118581034||es||False', false, '{NULL,F0GBR04IWF,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BNP PARIBAS INVERSIÓN FI', 'ES0125473035', 'EUR', 2, '|f_es_BMF|', 74861, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0125473035||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BNP PARIBAS MANAGEMENT FUND', 'ES0118553033', 'EUR', 2, '|f_es_BMF|', 78546, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0118553033||es||False', false, '{NULL,F0GBR04IWP,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BNP PARIBAS PROTECTED PLUS FI', 'ES0118551037', 'EUR', 2, '|f_es_BMF|', 74862, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0118551037||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BNP PARIBAS SELECCION', 'ES0160620037', 'EUR', 2, '|f_es_BMF|', 76716, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0160620037||es||False', false, '{NULL,F0GBR04IWL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BNP PARIBAS SELECCIÓN HEDGE IICIICIL', 'ES0125474009', 'EUR', 2, '|f_es_BMF|', 74857, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0125474009||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BODEGAS RIOJANAS', 'ES0115002018', 'EUR', 1, '|MERCADOCONTINUO|', 81426, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0115002018||es||False', false, '{RIO.MC,NULL,BME:RIO,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BOEING CERT', 'BE0004608494', 'EUR', 1, '|EURONEXT|', 77185, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0004608494||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BOEING COMPANY', 'US0970231058', 'EUR', 1, '|EURONEXT|', 77197, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#US0970231058||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BOEING COMPANY', 'US0970231058', 'USD', 1, '|SP500|', 79465, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BA||us||False', false, '{BA,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BOIRON', 'FR0000061129', 'EUR', 1, '|EURONEXT|', 76882, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000061129||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BOISE INC.', NULL, 'USD', 1, '', 77453, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BZ||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BOLLORE', 'FR0000039299', 'EUR', 1, '|EURONEXT|', 75986, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000039299||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BOLSALIDER', 'ES0115068035', 'EUR', 2, '|f_es_BMF|', 76723, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115068035||es||False', false, '{NULL,F0GBR04DN6,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BOLSAS Y MERCADOS ESPAÑOLES', 'ES0115056139', 'EUR', 1, '|MERCADOCONTINUO|', 80840, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0115056139||es||False', false, '{BME.MC,NULL,BME:BME,NULL,BME}', false, 2);
INSERT INTO public.products VALUES ('BONA RENDA', 'ES0115091037', 'EUR', 2, '|f_es_BMF|', 76686, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115091037||es||False', false, '{NULL,F0GBR04DN8,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BONBSAAR2016', 'FR0010734509', 'EUR', 1, '|EURONEXT|', 77198, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010734509||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BOND MANAGERS FUND', 'ES0115039036', 'EUR', 2, '|f_es_BMF|', 77485, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115039036||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BONDUELLE BSAAR 14', 'FR0010490912', 'EUR', 1, '|EURONEXT|', 80016, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010490912||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BONDUELLE', 'FR0000063935', 'EUR', 1, '|EURONEXT|', 75828, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000063935||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BONGRAIN', 'FR0000120107', 'EUR', 1, '|EURONEXT|', 77999, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000120107||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BONO ALEMÁN A 10 AÑOS', NULL, 'u', 7, '', 74801, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'BUND_ALEMAN||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BONO BANCO POPULAR 8.00 20210729', 'ES0213790019', 'EUR', 9, '', 81688, NULL, NULL, NULL, NULL, 80, 'c', 1, 1, 'A3043056', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BONO CAIXABANK 4.00 20220209', 'ES0240609000', 'EUR', 9, '', 81689, NULL, NULL, NULL, NULL, 80, 'c', 1, 1, NULL, false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BONO ESPAÑOL A 10 AÑOS', NULL, 'u', 7, '', 74803, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'BUND_ESPAÑOL||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BONO ESTADO ESPAÑOL 1,4 30072028', 'ES0000012B88', 'EUR', 7, '', 81729, NULL, NULL, NULL, NULL, 0, 'c', 1, 1, NULL, false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BONO ESTADO ESPAÑOL 3,45 30072066', 'ES00000128E2', 'EUR', 7, '', 81728, NULL, NULL, NULL, NULL, 0, 'c', 1, 1, NULL, false, '{NULL,NULL,NULL,NULL,ES0000128E=RRPS}', false, 2);
INSERT INTO public.products VALUES ('BONO ESTADO ESPAÑOL 4,00  31102064', 'ES00000126D8', 'EUR', 7, '', 81682, NULL, NULL, NULL, NULL, 20, 'c', 1, 1, NULL, false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BONO ESTADO ESPAÑOL 4,20  31012037', 'ES0000012932', 'EUR', 7, '', 81680, NULL, NULL, NULL, NULL, 20, 'c', 1, 1, NULL, false, '{NULL,NULL,NULL,NULL,ES00001293=RRPS}', false, 2);
INSERT INTO public.products VALUES ('BONO ESTADO ESPAÑOL 4,70  30072041', 'ES00000121S7', 'EUR', 7, '', 81683, NULL, NULL, NULL, NULL, 20, 'c', 1, 1, NULL, false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BONO ESTADO ESPAÑOL 4,90  30072040', 'ES00000120N0', 'EUR', 7, '', 81684, NULL, NULL, NULL, NULL, 20, 'c', 1, 1, NULL, false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BONO ESTADO ESPAÑOL 5,15  31102044', 'ES00000124H4', 'EUR', 7, '', 81685, NULL, NULL, NULL, NULL, 20, 'c', 1, 1, NULL, false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BONO TELEFÓNICA 4.18 20221129', 'ES0278430998', 'EUR', 9, '', 81686, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, NULL, false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BOOZ ALLEN & HAMILTON INC.', NULL, 'USD', 1, '', 79808, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BAH||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BOREAS GLOBAL', 'ES0114902002', 'EUR', 2, '|f_es_BMF|', 77609, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114902002||es||False', false, '{NULL,F000000EBM,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BORGWARNER INC.', NULL, 'USD', 1, '|SP500|', 78270, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BWA||us||False', false, '{BWA,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BOSKALIS WESTMIN', 'NL0000852580', 'EUR', 1, '|EURONEXT|', 78000, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0000852580||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BOSTON BEER CO. CL A', NULL, 'USD', 1, '', 78032, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#SAM||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BOSTON PROPERTIES INC.', NULL, 'USD', 1, '|SP500|', 78306, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BXP||us||False', false, '{BXP,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BOSTON SCIENTIFIC CORP.', NULL, 'USD', 1, '|SP500|', 75488, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BSX||us||False', false, '{BSX,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BOURBON', 'FR0004548873', 'EUR', 1, '|EURONEXT|', 78002, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0004548873||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BOURBON NV', 'FR0010988816', 'EUR', 1, '|EURONEXT|', 76802, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010988816||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BOURSE DIRECT', 'FR0000074254', 'EUR', 1, '|EURONEXT|', 76737, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000074254||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BOURSORAMA', 'FR0000075228', 'EUR', 1, '|EURONEXT|', 76266, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000075228||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BOUSSARD GAVAUD C', 'GG00B1XFMJ13', 'EUR', 1, '|EURONEXT|', 76550, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#GG00B1XFMJ13||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BOUSSARD GAVAUDAN', 'GG00B1FQG453', 'EUR', 1, '|EURONEXT|', 75380, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#GG00B1FQG453||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BOUSSARD GHL GBP', 'GG00B39VMM07', 'EUR', 1, '|EURONEXT|', 79167, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#GG00B39VMM07||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BOUYGUES', 'FR0000120503', 'EUR', 1, '|CAC|', 75078, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EN.PA||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BOUYGUES', 'FR0011121888', 'EUR', 1, '|EURONEXT|', 76559, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0011121888||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BOUYGUES NV', 'FR0010971614', 'EUR', 1, '|EURONEXT|', 75578, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010971614||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BOX SHIPS INC.', NULL, 'USD', 1, '', 80216, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#TEU||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BOYD GAMING CORP.', NULL, 'USD', 1, '', 79639, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BYD||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BP PLC', NULL, 'USD', 1, '', 79462, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BP||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BPA FONDO IBERICO ACCIONES', 'ES0114903000', 'EUR', 2, '|f_es_BMF|', 76688, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114903000||es||False', false, '{NULL,F000000H75,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BPEDI11(78P1)', 'ES0613790916', 'EUR', 1, '|EURONEXT|', 75160, NULL, NULL, NULL, NULL, 100, 'c', 1, 9, 'EURONEXT#ES0613790916||pt||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BPERE FONDO IBERICO ADAGIO', 'ES0118503004', 'EUR', 2, '|f_es_BMF|', 75144, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0118503004||es||False', false, '{NULL,F000000H76,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BPIDI11(1P10)', 'PTBPI0AMI043', 'EUR', 1, '|EURONEXT|', 75787, NULL, NULL, NULL, NULL, 100, 'c', 1, 9, 'EURONEXT#PTBPI0AMI043||pt||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BPZ RESOURCES INC.', NULL, 'USD', 1, '', 79851, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BPZ||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BQUE DE LA REUNION', 'FR0000039612', 'EUR', 1, '|EURONEXT|', 79129, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000039612||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BQUE NAT. BELGIQUE', 'BE0003008019', 'EUR', 1, '|EURONEXT|', 78107, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003008019||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BRADESPAR OR', 'BRBRAPACNOR5', 'EUR', 1, '|LATIBEX|', 81427, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#BRBRAPACNOR5||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BRADESPAR PR', 'BRBRAPACNPR2', 'EUR', 1, '|LATIBEX|', 80844, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#BRBRAPACNPR2||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BRADY CORP. CL A', NULL, 'USD', 1, '', 79079, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BRC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BRANDYWINE REALTY TRUST', NULL, 'USD', 1, '', 76823, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BDN||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BRASKEM PR.A', 'BRBRKMACNPA4', 'EUR', 1, '|LATIBEX|', 80845, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#BRBRKMACNPA4||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BRAS.OUEST AFRIC.', 'SN0008626971', 'EUR', 1, '|EURONEXT|', 79131, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#SN0008626971||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BRASSERIE CAMEROUN', 'CM0000035113', 'EUR', 1, '|EURONEXT|', 78109, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#CM0000035113||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BRE PROPERTIES INC.', NULL, 'USD', 1, '', 78329, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BRE||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BREDERODE', 'BE0003792091', 'EUR', 1, '|EURONEXT|', 78111, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003792091||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BREDERODE STRIP', 'BE0005585568', 'EUR', 1, '|EURONEXT|', 79133, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0005585568||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BRENNTAG AG', 'DE000A1DAHH0', 'EUR', 1, '|DEUTSCHEBOERSE|', 78817, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE000A1DAHH0||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BRF-BRAZIL FOODS S/A', NULL, 'USD', 1, '', 78132, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BRFS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BRICODEAL', 'FR0000063919', 'EUR', 1, '|EURONEXT|', 79134, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000063919||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BRICORAMA', 'FR0000054421', 'EUR', 1, '|EURONEXT|', 78239, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000054421||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BRIDGEPOINT EDUCATION INC.', NULL, 'USD', 1, '', 77086, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BPI||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BRIGGS & STRATTON CORP.', NULL, 'USD', 1, '', 79480, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BGG||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BRILL KON', 'NL0000442523', 'EUR', 1, '|EURONEXT|', 78115, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0000442523||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BRINKER INTERNATIONAL INC.', NULL, 'USD', 1, '', 77567, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#EAT||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BRINK''S CO.', NULL, 'USD', 1, '', 81615, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BCO||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BRISA', 'PTBRI0AM0000', 'EUR', 1, '|EURONEXT|', 78077, NULL, NULL, NULL, NULL, 100, 'c', 1, 9, 'EURONEXT#PTBRI0AM0000||pt||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BRISTOL-MYERS SQUIBB CO.', NULL, 'USD', 1, '|SP500|', 78903, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BMY||us||False', false, '{BMY,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BRISTOW GROUP INC.', NULL, 'USD', 1, '', 79055, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BRS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BRITISH PETROLEUM BP', 'GB0007980591', 'GBP', 1, '', 75006, NULL, NULL, NULL, NULL, 100, 'c', 1, 4, 'BP.L||None||False', false, '{BP.L,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('British petroleum for early xulpymoney', NULL, 'EUR', 11, '', -26, '', '', '', '', 100, 'c', 1, 4, '', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BROADCOM CORPORATION', 'US1113201073', 'USD', 1, '|NASDAQ100|SP500|', 76527, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'BRCM||us||False', false, '{BRCM,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BROADRIDGE FINANCIAL SOLUTIONS INC.', NULL, 'USD', 1, '', 77303, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BROOKDALE SENIOR LIVING INC.', NULL, 'USD', 1, '', 75521, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BKD||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BROOKFIELD ASSET M', 'CA1125851040', 'EUR', 1, '|EURONEXT|', 74890, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#CA1125851040||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BROOKFIELD ASSET MANAGEMENT INC. CL A', NULL, 'USD', 1, '', 75870, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BAM||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BROOKFIELD CERT A', 'BE0004601424', 'EUR', 1, '|EURONEXT|', 75391, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0004601424||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BROOKFIELD OFFICE PROPERTIES INC.', NULL, 'USD', 1, '', 77126, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BPO||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BROOKFIELD RESIDENTIAL PROPERTIES INC.', NULL, 'USD', 1, '', 80318, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BRP||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BROWN & BROWN INC.', NULL, 'USD', 1, '', 75882, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BRO||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BROWN SHOE CO. INC.', NULL, 'USD', 1, '', 77183, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BWS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BRT REALTY TRUST', NULL, 'USD', 1, '', 81026, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BRT||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BRÜDER MANNESMANN AG', 'DE0005275507', 'EUR', 1, '|DEUTSCHEBOERSE|', 78821, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005275507||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BRUNEL INTERNAT', 'NL0000343432', 'EUR', 1, '|EURONEXT|', 75400, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0000343432||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BRUNSWICK CORP.', NULL, 'USD', 1, '', 78989, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BSN BANIF MULTIFONDOS PREMIER FIMF', NULL, 'EUR', 2, '', 75052, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'BSN BANIF MULTIFONDOS PREMIER FIMF||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BSN INVERSIONES', NULL, 'EUR', 2, '', 75053, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'BSN INVERSIONES||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BT GROUP PLC', NULL, 'USD', 1, '', 79503, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BT||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BUCKEYE TECHNOLOGIES INC.', NULL, 'USD', 1, '', 75668, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BKI||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BUCKLE INC.', NULL, 'USD', 1, '', 81624, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BKE||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BUILD-A-BEAR WORKSHOP INC.', NULL, 'USD', 1, '', 76190, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BBW||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BULL', 'FR0010266601', 'EUR', 1, '|EURONEXT|', 76364, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010266601||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BUNGE LTD.', NULL, 'USD', 1, '', 75393, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BG||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BUREAU VERITAS', 'FR0006174348', 'EUR', 1, '|EURONEXT|', 76885, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0006174348||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BUREAU VERITAS NV', 'FR0010979450', 'EUR', 1, '|EURONEXT|', 76315, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010979450||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BUREAU VERITAS NV', 'FR0011169820', 'EUR', 1, '|EURONEXT|', 78128, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0011169820||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BURELLE', 'FR0000061137', 'EUR', 1, '|EURONEXT|', 78187, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000061137||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('BUSINESS ET DECIS.', 'FR0000078958', 'EUR', 1, '|EURONEXT|', 78192, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000078958||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CA TECHNOLOGIES', 'US12673P1057', 'USD', 1, '|NASDAQ100|', 75422, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'CA||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CA TOULOUSE 31 CCI', 'FR0000045544', 'EUR', 1, '|EURONEXT|', 80248, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000045544||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAAM EURO REPO', 'ES0126541038', 'EUR', 2, '|f_es_BMF|', 77538, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0126541038||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAAM MULTIFONDO BAJO RIESGO', 'ES0164371033', 'EUR', 2, '|f_es_BMF|', 76692, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0164371033||es||False', false, '{NULL,F0GBR04EOT,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAAM MULTIFONDO GLOBAL', 'ES0126545039', 'EUR', 2, '|f_es_BMF|', 78547, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0126545039||es||False', false, '{NULL,F0GBR04Q4J,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAAM MULTIFONDO VAR 6 FI', 'ES0162943031', 'EUR', 2, '|f_es_BMF|', 74864, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0162943031||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CABELA''S INC.', NULL, 'USD', 1, '', 75850, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CAB||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CABK Equilibrio', NULL, 'EUR', 8, '', -34, '', '', '', '', 25, 'c', 1, 1, '', false, '{NULL,NULL,NULL,N1750,NULL}', false, 2);
INSERT INTO public.products VALUES ('CABLEVISION SYSTEMS CORP.', NULL, 'USD', 1, '|SP500|', 76258, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CVC||us||False', false, '{CVC,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CABOT CORP.', NULL, 'USD', 1, '|SP500|', 76720, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CBT||us||False', false, '{CBT,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CABOT OIL & GAS CORP.', NULL, 'USD', 1, '', 75368, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#COG||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAC 40', 'FR0003500008', 'EUR', 3, '', 79694, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, '^FCHI||fr||False', false, '{^FCHI,NULL,"INDEXEURO:PX1 ",NULL,FCHI}', false, 2);
INSERT INTO public.products VALUES ('CACI INTERNATIONAL INC. CL A', NULL, 'USD', 1, '', 81605, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CACI||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAE INC.', NULL, 'USD', 1, '', 76703, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CAE||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAFOM', 'FR0010151589', 'EUR', 1, '|EURONEXT|', 78548, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010151589||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAHISPA EMERGENTES MULTIFONDO', 'ES0115272033', 'EUR', 2, '|f_es_BMF|', 78617, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115272033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAHISPA EUROVARIABLE', 'ES0124541030', 'EUR', 2, '|f_es_BMF|', 78618, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0124541030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAHISPA MULTIFONDO', 'ES0112799038', 'EUR', 2, '|f_es_BMF|', 78591, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0112799038||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAHISPA RENTA', 'ES0115399034', 'EUR', 2, '|f_es_BMF|', 78621, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115399034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAHISPA SMALL CAPS', 'ES0115281034', 'EUR', 2, '|f_es_BMF|', 78622, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115281034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAI 100 GARANTIZADO II', 'ES0115104038', 'EUR', 2, '|f_es_BMF|', 78623, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115104038||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAI 100 GARANTIZADO IV FI', 'ES0115105035', 'EUR', 2, '|f_es_BMF|', 74877, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115105035||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAI AHORRO RENTA FIJA 2 FI', 'ES0115401038', 'EUR', 2, '|f_es_BMF|', 74878, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115401038||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAI AHORRO RENTA FIJA', 'ES0114844030', 'EUR', 2, '|f_es_BMF|', 78624, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114844030||es||False', false, '{NULL,F0GBR04DVJ,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAI BOLSA 10', 'ES0115351035', 'EUR', 2, '|f_es_BMF|', 78663, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115351035||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAI DEPOSITO', 'ES0114996038', 'EUR', 2, '|f_es_BMF|', 78665, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114996038||es||False', false, '{NULL,F0000003K6,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAI GARANTIZADO EUROSTOXX FI', 'ES0119481036', 'EUR', 2, '|f_es_BMF|', 74879, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0119481036||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAI GARANTIZADO SÚPER 7 II FI', 'ES0115079032', 'EUR', 2, '|f_es_BMF|', 74880, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115079032||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAI INTERNATIONAL INC.', NULL, 'USD', 1, '', 79900, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CAP||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAI RENDIMIENTO', 'ES0115106033', 'EUR', 2, '|f_es_BMF|', 74866, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115106033||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAI RENDIMIENTO II', 'ES0157081037', 'EUR', 2, '|f_es_BMF|', 76708, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0157081037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAI RENTA MIXTO 20', 'ES0101331033', 'EUR', 2, '|f_es_BMF|', 78766, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0101331033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAI RENTA MIXTO 40', 'ES0101332031', 'EUR', 2, '|f_es_BMF|', 76756, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0101332031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAI RENTA MIXTO', 'ES0115336036', 'EUR', 2, '|f_es_BMF|', 76710, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115336036||es||False', false, '{NULL,F0GBR04DVT,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXA CATALUNYA 1', 'ES0122699038', 'EUR', 2, '|f_es_BMF|', 76757, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0122699038||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXA CATALUNYA 1-A', 'ES0122700034', 'EUR', 2, '|f_es_BMF|', 75245, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0122700034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXA CATALUNYA 1-B', 'ES0122701032', 'EUR', 2, '|f_es_BMF|', 78792, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0122701032||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXA CATALUNYA 1-E', 'ES0115209035', 'EUR', 2, '|f_es_BMF|', 79062, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115209035||es||False', false, '{NULL,F0GBR04HLW,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXA CATALUNYA 2-A', 'ES0119482000', 'EUR', 2, '|f_es_BMF|', 79073, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0119482000||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXA CATALUNYA 2-B', 'ES0114924006', 'EUR', 2, '|f_es_BMF|', 76348, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114924006||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXA CATALUNYA BOLSA 11 FI', 'ES0115286033', 'EUR', 2, '|f_es_BMF|', 74882, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115286033||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXA CATALUNYA BORSA 12', 'ES0115287031', 'EUR', 2, '|f_es_BMF|', 79039, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115287031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXA CATALUNYA BORSA 13', 'ES0105573036', 'EUR', 2, '|f_es_BMF|', 78015, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0105573036||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXA CATALUNYA BORSA 14', 'ES0115107031', 'EUR', 2, '|f_es_BMF|', 79098, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115107031||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXA CATALUNYA BORSA 2 FI', 'ES0101334037', 'EUR', 2, '|f_es_BMF|', 74883, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0101334037||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXA CATALUNYA BORSA 4', 'ES0114403035', 'EUR', 2, '|f_es_BMF|', 74871, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114403035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXA CATALUNYA BORSA EMERGENT', 'ES0115344030', 'EUR', 2, '|f_es_BMF|', 78016, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115344030||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXA CATALUNYA BORSA EUROPEA', 'ES0115334031', 'EUR', 2, '|f_es_BMF|', 77541, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115334031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXA CATALUNYA CONVERTIBLES', 'ES0115337034', 'EUR', 2, '|f_es_BMF|', 77531, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115337034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXA CATALUNYA CREIXEMENT', 'ES0115405039', 'EUR', 2, '|f_es_BMF|', 77204, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115405039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXA CATALUNYA DINAMIC 2', 'ES0115210033', 'EUR', 2, '|f_es_BMF|', 75698, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115210033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXA CATALUNYA DINAMICO', 'ES0115323034', 'EUR', 2, '|f_es_BMF|', 75696, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115323034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXA CATALUNYA DOBLE', 'ES0115456032', 'EUR', 2, '|f_es_BMF|', 78007, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115456032||es||False', false, '{NULL,F0GBR051OD,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXA CATALUNYA EQUILIBRI 2', 'ES0115288039', 'EUR', 2, '|f_es_BMF|', 75692, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115288039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXA CATALUNYA EQUILIBRIO', 'ES0101337030', 'EUR', 2, '|f_es_BMF|', 75693, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0101337030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXA CATALUNYA EUROBORSA GARANTIT', 'ES0105574034', 'EUR', 2, '|f_es_BMF|', 78009, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0105574034||es||False', false, '{NULL,F0GBR04VY2,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXA CATALUNYA FONDTESORO', 'ES0114990031', 'EUR', 2, '|f_es_BMF|', 78011, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114990031||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXA CATALUNYA FONS INTERNAC.', 'ES0115417034', 'EUR', 2, '|f_es_BMF|', 78012, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115417034||es||False', false, '{NULL,F0GBR051OG,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXA CATALUNYA GARANTIT 3 B', 'ES0118505009', 'EUR', 2, '|f_es_BMF|', 78793, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0118505009||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXA CATALUNYA GARANTIT 3-C', 'ES0114408034', 'EUR', 2, '|f_es_BMF|', 78018, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114408034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXA CATALUNYA INDEX', 'ES0115457030', 'EUR', 2, '|f_es_BMF|', 75243, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115457030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXA CATALUNYA LIQUIDITAT', 'ES0122702030', 'EUR', 2, '|f_es_BMF|', 76758, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0122702030||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXA CATALUNYA MULTISEC.MUNDIAL', 'ES0101338038', 'EUR', 2, '|f_es_BMF|', 76397, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0101338038||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXA CATALUNYA PREVISIO', 'ES0138842036', 'EUR', 2, '|f_es_BMF|', 78795, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138842036||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXA CATALUNYA PROPIETAT', 'ES0113248035', 'EUR', 2, '|f_es_BMF|', 77088, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113248035||es||False', false, '{NULL,F0000002NG,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXA CATALUNYA SPREAD', 'ES0115285035', 'EUR', 2, '|f_es_BMF|', 78807, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115285035||es||False', false, '{NULL,F0GBR04GIO,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXA GALICIA 5 MAS', 'ES0117182032', 'EUR', 2, '|f_es_BMF|', 78808, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0117182032||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXA GALICIA EUROBOLSA', 'ES0115411037', 'EUR', 2, '|f_es_BMF|', 77262, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115411037||es||False', false, '{NULL,F0GBR04DW1,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXA GALICIA EUROIBOR GARANT.', 'ES0119483008', 'EUR', 2, '|f_es_BMF|', 78831, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0119483008||es||False', false, '{NULL,F000001GFB,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXA GALICIA GARANT.5 ESTRELLAS', 'ES0115136030', 'EUR', 2, '|f_es_BMF|', 78832, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115136030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXA GALICIA GARANTIA 2', 'ES0157082035', 'EUR', 2, '|f_es_BMF|', 78840, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0157082035||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXA GALICIA GARANTIA 3', 'ES0117183030', 'EUR', 2, '|f_es_BMF|', 78842, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0117183030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXA GALICIA GARANTIA CINCO', 'ES0115008031', 'EUR', 2, '|f_es_BMF|', 78847, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115008031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXA GALICIA GARANTIA CUATRO', 'ES0113250031', 'EUR', 2, '|f_es_BMF|', 78848, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113250031||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXA GALICIA GARANTIA', 'ES0115137038', 'EUR', 2, '|f_es_BMF|', 78838, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115137038||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXA GALICIA GESTION CONSERVADO', 'ES0147597035', 'EUR', 2, '|f_es_BMF|', 78843, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147597035||es||False', false, '{NULL,F0000001U0,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXA GALICIA IBEXPLUS', 'ES0115289037', 'EUR', 2, '|f_es_BMF|', 77264, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115289037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXA GALICIA INVERSIONES', 'ES0107470033', 'EUR', 2, '|f_es_BMF|', 77265, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0107470033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXA GALICIA MIX 25', 'ES0115356034', 'EUR', 2, '|f_es_BMF|', 77271, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115356034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXA GALICIA MIX', 'ES0115418032', 'EUR', 2, '|f_es_BMF|', 77266, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115418032||es||False', false, '{NULL,F0GBR04DW7,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXA GALICIA RENDIMIENTO GARANT', 'ES0114992037', 'EUR', 2, '|f_es_BMF|', 77272, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114992037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXA GALICIA RENDIMIENTO GTZDO. 2', 'ES0114998000', 'EUR', 2, '|f_es_BMF|', 77273, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114998000||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXA GALICIA RENTA CRECIENTE', 'ES0105575031', 'EUR', 2, '|f_es_BMF|', 76764, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0105575031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXA GALICIA RENTA FIJA 1', 'ES0142543034', 'EUR', 2, '|f_es_BMF|', 75631, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0142543034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXA GALICIA RENTA FIJA FI', 'ES0114985031', 'EUR', 2, '|f_es_BMF|', 74884, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114985031||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXA GALICIA RF 3 AÑO 2013', 'ES0122705033', 'EUR', 2, '|f_es_BMF|', 76766, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0122705033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXA GALICIA SELECCION GARANTIZ', 'ES0105576039', 'EUR', 2, '|f_es_BMF|', 76767, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0105576039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXA TARRAGONA RF CORTO PLAZO FI', 'ES0178001030', 'EUR', 2, '|f_es_BMF|', 74909, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0178001030||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXABANK', 'ES0140609019', 'EUR', 1, '|IBEX|MERCADOCONTINUO|', 81113, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0140609019||es||False', false, '{CABK.MC,NULL,BME:CABK,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXAGIRONA EMERGENT', 'ES0115461032', 'EUR', 2, '|f_es_BMF|', 76620, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115461032||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXAGIRONA ESTALVI', 'ES0138788031', 'EUR', 2, '|f_es_BMF|', 78108, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138788031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXAGIRONA EUROBORSA', 'ES0142470030', 'EUR', 2, '|f_es_BMF|', 76141, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0142470030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXAGIRONA EUROMIXT 20', 'ES0142491036', 'EUR', 2, '|f_es_BMF|', 75626, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0142491036||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXAGIRONA EUROMIXT 40', 'ES0170231031', 'EUR', 2, '|f_es_BMF|', 75316, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0170231031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXAGIRONA OPORTUNITATS', 'ES0115414031', 'EUR', 2, '|f_es_BMF|', 78078, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115414031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXAGIRONA PATRIMONI', 'ES0115347033', 'EUR', 2, '|f_es_BMF|', 78118, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115347033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXAGIRONA RENTA FIXA', 'ES0138825031', 'EUR', 2, '|f_es_BMF|', 75454, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138825031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXANOVA A AHORRO', 'ES0115082036', 'EUR', 2, '|f_es_BMF|', 78081, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115082036||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXANOVA GARANTIZADO GLOBAL', 'ES0115109037', 'EUR', 2, '|f_es_BMF|', 74867, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115109037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXANOVA GARANTIZADO GLOBAL II', 'ES0115080030', 'EUR', 2, '|f_es_BMF|', 78148, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115080030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXANOVA GARANTIZADO GLOBAL III', 'ES0115081038', 'EUR', 2, '|f_es_BMF|', 78122, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115081038||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXANOVA GARANTIZADO PRIVILEGE', 'ES0115329031', 'EUR', 2, '|f_es_BMF|', 78126, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115329031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXANOVA GARANTIZADO RENTA FIJA', 'ES0115018006', 'EUR', 2, '|f_es_BMF|', 78129, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115018006||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXANOVA GARANTIZADO RENTAS 2', 'ES0115349039', 'EUR', 2, '|f_es_BMF|', 78625, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115349039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXANOVA GARANTIZADO RENTAS 3', 'ES0105577037', 'EUR', 2, '|f_es_BMF|', 76751, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0105577037||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXANOVA GARANTIZADO RENTAS', 'ES0115212039', 'EUR', 2, '|f_es_BMF|', 78130, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115212039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXANOVA GESTION', 'ES0109220030', 'EUR', 2, '|f_es_BMF|', 75629, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0109220030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXANOVA RENTA FIJA', 'ES0115019004', 'EUR', 2, '|f_es_BMF|', 75218, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115019004||es||False', false, '{NULL,F000001BP2,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXASABADELL 2 - FIX', 'ES0118597030', 'EUR', 2, '|f_es_BMF|', 76772, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0118597030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXASABADELL 6 MIXT', 'ES0113695037', 'EUR', 2, '|f_es_BMF|', 75094, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113695037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXASABADELL 7 R.V.', 'ES0142545039', 'EUR', 2, '|f_es_BMF|', 75117, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0142545039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXASABADELL FONSDIPOSIT', 'ES0118595034', 'EUR', 2, '|f_es_BMF|', 76507, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0118595034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXASABADELL PROTECCIÓ II FI', 'ES0169076033', 'EUR', 2, '|f_es_BMF|', 74901, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0169076033||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXASABADELL PROTECCIÓ III FI', 'ES0169077031', 'EUR', 2, '|f_es_BMF|', 74885, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0169077031||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXASABADELL PROTECCIÓ IV FI', 'ES0169078039', 'EUR', 2, '|f_es_BMF|', 74897, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0169078039||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXASABADELL PROTECCIO V', 'ES0169079037', 'EUR', 2, '|f_es_BMF|', 75699, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0169079037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXATARRAGONA BOLSA 35 FI', 'ES0115067037', 'EUR', 2, '|f_es_BMF|', 74902, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115067037||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXATARRAGONA INVERSIÓ CURT TERMINI FI', 'ES0177951037', 'EUR', 2, '|f_es_BMF|', 74903, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0177951037||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXATARRAGONA MIXT EUROPA FI', 'ES0177996032', 'GBP', 2, '|f_es_BMF|', 74911, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0177996032||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAIXATARRAGONA MIXT IPC', 'ES0178002038', 'EUR', 2, '|f_es_BMF|', 74912, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0178002038||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA BADAJOZ INVERSION', 'ES0142546037', 'EUR', 2, '|f_es_BMF|', 79181, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0142546037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA BURGOS RENTA', 'ES0115491039', 'EUR', 2, '|f_es_BMF|', 75388, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115491039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA INGENIEROS 2012 2E GARANT.', 'ES0119486001', 'EUR', 2, '|f_es_BMF|', 75118, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0119486001||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA INGENIEROS 2012 GARANTIZADO', 'ES0164375000', 'EUR', 2, '|f_es_BMF|', 75119, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0164375000||es||False', false, '{NULL,F000002VED,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA INGENIEROS 2013 2E GARANTIZADO', 'ES0157327000', 'EUR', 2, '|f_es_BMF|', 74868, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0157327000||es||False', false, '{NULL,F000005J8O,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA INGENIEROS 2013 GARANTIZADO', 'ES0119487009', 'EUR', 2, '|f_es_BMF|', 74795, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0119487009||es||False', false, '{NULL,F0000044BL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA INGENIEROS A. GARANTIZADO', 'ES0115531032', 'EUR', 2, '|f_es_BMF|', 74796, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115531032||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA INGENIEROS BOLSA EURO PLUS', 'ES0115443030', 'EUR', 2, '|f_es_BMF|', 74961, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115443030||es||False', false, '{NULL,F0GBR04K16,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA INGENIEROS BOLSA USA', 'ES0115359038', 'EUR', 2, '|f_es_BMF|', 78889, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115359038||es||False', false, '{NULL,F0GBR055TB,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA INGENIEROS EMERGENTES', 'ES0109221038', 'EUR', 2, '|f_es_BMF|', 78890, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0109221038||es||False', false, '{NULL,F0GBR0563E,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA INGENIEROS EUROB.GARANTIZ', 'ES0115442032', 'EUR', 2, '|f_es_BMF|', 74965, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115442032||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA INGENIEROS EUROPA 25', 'ES0115451033', 'EUR', 2, '|f_es_BMF|', 77013, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115451033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA INGENIEROS FONDT.CORTO PLAZ', 'ES0114887039', 'EUR', 2, '|f_es_BMF|', 74969, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114887039||es||False', false, '{NULL,F0GBR04K1A,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA INGENIEROS GESTION ALTERNAT', 'ES0142547035', 'EUR', 2, '|f_es_BMF|', 78892, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0142547035||es||False', false, '{NULL,F0GBR04VUB,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA INGENIEROS GESTION DINAMICA', 'ES0119488007', 'EUR', 2, '|f_es_BMF|', 74987, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0119488007||es||False', false, '{NULL,F00000JZBB,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA INGENIEROS GLOBAL', 'ES0114988035', 'EUR', 2, '|f_es_BMF|', 76030, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114988035||es||False', false, '{NULL,F0GBR04K1G,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA INGENIEROS IBEX PLUS', 'ES0122708037', 'EUR', 2, '|f_es_BMF|', 74991, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0122708037||es||False', false, '{NULL,F0GBR0601C,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA INGENIEROS MULTICESTA GARAN', 'ES0115426035', 'EUR', 2, '|f_es_BMF|', 78253, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115426035||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA INGENIEROS MULTIFONDO', 'ES0115444038', 'EUR', 2, '|f_es_BMF|', 78893, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115444038||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA INGENIEROS PREMIER', 'ES0115532030', 'EUR', 2, '|f_es_BMF|', 78894, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115532030||es||False', false, '{NULL,F0GBR04GCH,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA INGENIEROS RENTA', 'ES0114986039', 'EUR', 2, '|f_es_BMF|', 78895, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114986039||es||False', false, '{NULL,F0GBR04K0O,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA INGENIEROS RF UNIVERSAL', 'ES0114811039', 'EUR', 2, '|f_es_BMF|', 74921, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114811039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA LABORAL AHORRO 2', 'ES0114984034', 'EUR', 2, '|f_es_BMF|', 74797, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114984034||es||False', false, '{NULL,F0GBR04Q6F,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA LABORAL AHORRO', 'ES0115466031', 'EUR', 2, '|f_es_BMF|', 74995, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115466031||es||False', false, '{NULL,F0GBR04CGL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA LABORAL BOLSA', 'ES0115467039', 'EUR', 2, '|f_es_BMF|', 74799, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115467039||es||False', false, '{NULL,F0GBR04CGN,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA LABORAL BOLSA GARANT. II', 'ES0114888037', 'EUR', 2, '|f_es_BMF|', 75064, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114888037||es||False', false, '{NULL,F0GBR04CGO,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA LABORAL BOLSA GARANT. IX', 'ES0115310031', 'EUR', 2, '|f_es_BMF|', 75191, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115310031||es||False', false, '{NULL,F0GBR04CGT,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA LABORAL BOLSA GARANT. V', 'ES0115476030', 'EUR', 2, '|f_es_BMF|', 75219, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115476030||es||False', false, '{NULL,F0GBR04CGV,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA LABORAL BOLSA GARANT. VI', 'ES0115477038', 'EUR', 2, '|f_es_BMF|', 75220, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115477038||es||False', false, '{NULL,F0GBR04CGX,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA LABORAL BOLSA GARANT. X', 'ES0115311039', 'EUR', 2, '|f_es_BMF|', 78666, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115311039||es||False', false, '{NULL,F0GBR04CH1,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA LABORAL BOLSA GARANT.VII', 'ES0115478036', 'EUR', 2, '|f_es_BMF|', 77008, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115478036||es||False', false, '{NULL,F0GBR04CGZ,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA LABORAL BOLSA GARANT.XIII', 'ES0164732036', 'EUR', 2, '|f_es_BMF|', 77009, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0164732036||es||False', false, '{NULL,F0GBR04CH8,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA LABORAL BOLSA JAPON', 'ES0115396030', 'EUR', 2, '|f_es_BMF|', 77014, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115396030||es||False', false, '{NULL,F0GBR04OND,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA LABORAL BOLSA UNIVERSAL', 'ES0164734032', 'EUR', 2, '|f_es_BMF|', 76997, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0164734032||es||False', false, '{NULL,F0GBR04Q73,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA LABORAL BOLSA USA', 'ES0115304034', 'EUR', 2, '|f_es_BMF|', 76508, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115304034||es||False', false, '{NULL,F0GBR04ONF,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA LABORAL BOLSAS EUROPEAS', 'ES0114812037', 'EUR', 2, '|f_es_BMF|', 76509, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114812037||es||False', false, '{NULL,F0GBR04Q72,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA LABORAL CONFIANZA', 'ES0164733034', 'EUR', 2, '|f_es_BMF|', 76510, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0164733034||es||False', false, '{NULL,F0GBR04CHC,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA LABORAL CRECIMIENTO', 'ES0115468037', 'EUR', 2, '|f_es_BMF|', 76517, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115468037||es||False', false, '{NULL,F0GBR04Q6K,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA LABORAL DINERO', 'ES0115489033', 'EUR', 2, '|f_es_BMF|', 76998, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115489033||es||False', false, '{NULL,F0GBR04Q6H,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA LABORAL GARANTIZADO III', 'ES0114889035', 'EUR', 2, '|f_es_BMF|', 77001, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114889035||es||False', false, '{NULL,F0GBR04CGQ,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA LABORAL MERCADOS EMERGENT', 'ES0114928031', 'EUR', 2, '|f_es_BMF|', 77017, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114928031||es||False', false, '{NULL,F0GBR04Q6G,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA LABORAL PATRIMONIO', 'ES0115469035', 'EUR', 2, '|f_es_BMF|', 77021, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115469035||es||False', false, '{NULL,F0GBR04Q6J,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA LABORAL RENDIMIENTO', 'ES0115463038', 'EUR', 2, '|f_es_BMF|', 77026, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115463038||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA LABORAL RENTA ASEGURADA I', 'ES0114891031', 'EUR', 2, '|f_es_BMF|', 77069, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114891031||es||False', false, '{NULL,F0GBR04Q75,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA LABORAL RENTA', 'ES0115487037', 'EUR', 2, '|f_es_BMF|', 79304, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115487037||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA LABORAL RENTA FIJA A LARGO', 'ES0115312037', 'EUR', 2, '|f_es_BMF|', 79317, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115312037||es||False', false, '{NULL,F0GBR04CH4,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA LABORAL RENTA FIJA EURO', 'ES0164735039', 'EUR', 2, '|f_es_BMF|', 78667, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0164735039||es||False', false, '{NULL,F0GBR04ONH,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA LABORAL RENTA FIJA GARANTIZADO III', 'ES0114890033', 'EUR', 2, '|f_es_BMF|', 77075, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114890033||es||False', false, '{NULL,F0GBR04CGS,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA LABORAL RENTA FIJA GARANTIZADO IV', 'ES0164731038', 'EUR', 2, '|f_es_BMF|', 75222, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0164731038||es||False', false, '{NULL,F0GBR04CH6,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA LABORAL RF GARANTIZADO 1', 'ES0114948039', 'EUR', 2, '|f_es_BMF|', 75120, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114948039||es||False', false, '{NULL,F0GBR04D4B,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA MADRID AVANZA.', 'ES0115084008', 'EUR', 2, '|f_es_BMF|', 75207, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115084008||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA MADRID AVANZA RENTAS I', 'ES0115020002', 'EUR', 2, '|f_es_BMF|', 75897, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115020002||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA MADRID AVANZA RENTAS II', 'ES0147599007', 'EUR', 2, '|f_es_BMF|', 75902, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147599007||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA MADRID BRICT', 'ES0115139034', 'EUR', 2, '|f_es_BMF|', 76551, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115139034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA MADRID EUROPA PLUS FI', 'ES0157086036', 'EUR', 2, '|f_es_BMF|', 74913, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0157086036||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA MADRID EVOLUCION VAR 10', 'ES0105578035', 'EUR', 2, '|f_es_BMF|', 76552, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0105578035||es||False', false, '{NULL,F0GBR06QXF,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA MADRID EVOLUCION VAR 15', 'ES0158948036', 'EUR', 2, '|f_es_BMF|', 75121, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0158948036||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA MADRID EVOLUCION VAR 20', 'ES0117184038', 'EUR', 2, '|f_es_BMF|', 79363, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0117184038||es||False', false, '{NULL,F0GBR06QXH,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA MADRID EXCELLENCE GAR. FI', 'ES0113253001', 'EUR', 2, '|f_es_BMF|', 74914, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113253001||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA MADRID GARANTÍA 1 AÑO FI', 'ES0113254009', 'EUR', 2, '|f_es_BMF|', 74915, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113254009||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA MADRID HORIZONTE', 'ES0169080035', 'EUR', 2, '|f_es_BMF|', 79366, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0169080035||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA MADRID PYMES', 'ES0115140032', 'EUR', 2, '|f_es_BMF|', 79369, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115140032||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA MADRID RENTA CREC.2009', 'ES0105579033', 'EUR', 2, '|f_es_BMF|', 79337, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0105579033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA MADRID SELECCION FINANCIERA', 'ES0105580031', 'EUR', 2, '|f_es_BMF|', 78668, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0105580031||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA MADRID TITANES', 'ES0158964033', 'EUR', 2, '|f_es_BMF|', 77122, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0158964033||es||False', false, '{NULL,F0GBR04JZW,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA MADRID TITANES II', 'ES0109222036', 'EUR', 2, '|f_es_BMF|', 77123, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0109222036||es||False', false, '{NULL,F0GBR056L1,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA MURCIA FONDEPOSITO PLUS', 'ES0158949034', 'EUR', 2, '|f_es_BMF|', 75300, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0158949034||es||False', false, '{NULL,F0GBR06XID,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA MURCIA GARANTIZADO', 'ES0115486039', 'EUR', 2, '|f_es_BMF|', 79410, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115486039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA MURCIA SELECCION DINAMICA', 'ES0159180001', 'EUR', 2, '|f_es_BMF|', 79412, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0159180001||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA SEGOVIA BOLSA GARANTI.2', 'ES0117185035', 'EUR', 2, '|f_es_BMF|', 79413, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0117185035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA SEGOVIA GARANT.EURIB.MAS 60', 'ES0105581005', 'EUR', 2, '|f_es_BMF|', 78669, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0105581005||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA SEGOVIA GARANTIZADO 2', 'ES0116942030', 'EUR', 2, '|f_es_BMF|', 75304, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0116942030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA SEGOVIA GARANTIZADO 3', 'ES0122709035', 'EUR', 2, '|f_es_BMF|', 75317, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0122709035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA SEGOVIA RENDIMIENTO GAR. 1', 'ES0115374037', 'EUR', 2, '|f_es_BMF|', 75318, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115374037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA SEGOVIA RENDIMIENTO GARAN.2', 'ES0122710033', 'EUR', 2, '|f_es_BMF|', 75778, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0122710033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJA SEGOVIA RENDIMIENTO GARANTIZADO 3', 'ES0169081033', 'EUR', 2, '|f_es_BMF|', 75346, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0169081033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJABURGOS BOLSA', 'ES0115508030', 'EUR', 2, '|f_es_BMF|', 75351, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115508030||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJABURGOS EURIBOR', 'ES0115454037', 'EUR', 2, '|f_es_BMF|', 74800, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115454037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJABURGOS EUROPA', 'ES0115452031', 'EUR', 2, '|f_es_BMF|', 74802, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115452031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJABURGOS F.DE F. MOD.VAR 6', 'ES0117186033', 'EUR', 2, '|f_es_BMF|', 78671, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0117186033||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJABURGOS F.DE F.COSERV.VAR 3', 'ES0158950032', 'EUR', 2, '|f_es_BMF|', 78672, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0158950032||es||False', false, '{NULL,FOGBR05KSA,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJABURGOS F.DE F.DINAMICO VAR 9', 'ES0169082031', 'EUR', 2, '|f_es_BMF|', 78673, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0169082031||es||False', false, '{NULL,FOGBR05KSB,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJABURGOS GARANTIZADO CAP 20', 'ES0115482038', 'EUR', 2, '|f_es_BMF|', 79461, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115482038||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJABURGOS GARANTIZADO IBEX', 'ES0115479034', 'EUR', 2, '|f_es_BMF|', 79473, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115479034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJABURGOS GARANTIZADO INT. FI', 'ES0122711031', 'EUR', 2, '|f_es_BMF|', 74916, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0122711031||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJABURGOS MIXTO I', 'ES0114949037', 'EUR', 2, '|f_es_BMF|', 77596, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114949037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJABURGOS RENTA 2', 'ES0126537036', 'EUR', 2, '|f_es_BMF|', 75856, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0126537036||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJABURGOS SOLUCION 2', 'ES0169084003', 'EUR', 2, '|f_es_BMF|', 77604, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0169084003||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJABURGOS SOLUCION 3', 'ES0158951006', 'EUR', 2, '|f_es_BMF|', 79478, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0158951006||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJABURGOS SOLUCION', 'ES0169083005', 'EUR', 2, '|f_es_BMF|', 79477, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0169083005||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJACANARIAS AHORRO A PLAZO I', 'ES0116943038', 'EUR', 2, '|f_es_BMF|', 79479, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0116943038||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJACANARIAS EURIBOR MAS 70 GARN', 'ES0109224032', 'EUR', 2, '|f_es_BMF|', 79481, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0109224032||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJACANARIAS EUROPA GARANTIZADO', 'ES0114602032', 'EUR', 2, '|f_es_BMF|', 79482, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114602032||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJACANARIAS GARANTIZADO', 'ES0142548033', 'EUR', 2, '|f_es_BMF|', 78709, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0142548033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJACANARIAS RENTA FIJA EURO', 'ES0124546039', 'EUR', 2, '|f_es_BMF|', 75352, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0124546039||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJAGRANADA FONDPLAZO GARANT.III', 'ES0114544036', 'EUR', 2, '|f_es_BMF|', 78921, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114544036||es||False', false, '{NULL,F0GBR0553Y,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJAGRANADA RENTA FIJA GARANT.II', 'ES0115428031', 'EUR', 2, '|f_es_BMF|', 75355, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115428031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJAGRANADA RENTAS GARANTIZADO', 'ES0114543038', 'EUR', 2, '|f_es_BMF|', 79601, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114543038||es||False', false, '{NULL,F0GBR04VTA,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJAGRANADA RF GARANTIZADO IV', 'ES0141226037', 'EUR', 2, '|f_es_BMF|', 75360, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0141226037||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJAMAR BOLSA', 'ES0115429039', 'EUR', 2, '|f_es_BMF|', 79144, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115429039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJAMAR FONDEPOSITO', 'ES0105582003', 'EUR', 2, '|f_es_BMF|', 78931, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0105582003||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJAMAR MONETARIO', 'ES0114546031', 'EUR', 2, '|f_es_BMF|', 78938, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114546031||es||False', false, '{NULL,F0GBR05WO0,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJAMAR MULTIGESTION MODERADO', 'ES0109226037', 'EUR', 2, '|f_es_BMF|', 77135, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0109226037||es||False', false, '{NULL,F0GBR064XT,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJAMAR MULTIGESTION PATRIMONIO', 'ES0114547039', 'EUR', 2, '|f_es_BMF|', 78710, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114547039||es||False', false, '{NULL,F0GBR064XP,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJAMAR RENDIMIENTO', 'ES0122712039', 'EUR', 2, '|f_es_BMF|', 78993, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0122712039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJARIOJA AHORRO GARANTIZADO 1', 'ES0169085000', 'EUR', 2, '|f_es_BMF|', 75925, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0169085000||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJARIOJA AHORRO GARANTIZADO 2', 'ES0169086008', 'EUR', 2, '|f_es_BMF|', 79604, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0169086008||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJARIOJA GARANTIZADO 1 FI', 'ES0114548037', 'EUR', 2, '|f_es_BMF|', 74917, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114548037||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJARIOJA GARANTIZADO 2', 'ES0114549035', 'EUR', 2, '|f_es_BMF|', 77749, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114549035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJARIOJA GARANTIZADO 3', 'ES0115378038', 'EUR', 2, '|f_es_BMF|', 76088, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115378038||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJARIOJA GARANTIZADO 4', 'ES0122713003', 'EUR', 2, '|f_es_BMF|', 77750, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0122713003||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJARIOJA RENTA FIJA FI', 'ES0114465034', 'EUR', 2, '|f_es_BMF|', 74918, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114465034||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJASOL AHORRO 11-2011', 'ES0140943038', 'EUR', 2, '|f_es_BMF|', 79607, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0140943038||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJASOL BOLSA I', 'ES0177860030', 'EUR', 2, '|f_es_BMF|', 79645, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0177860030||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJASOL FONDEPOSITO', 'ES0128452036', 'EUR', 2, '|f_es_BMF|', 79648, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0128452036||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJASOL FONDOSUR', 'ES0138942034', 'EUR', 2, '|f_es_BMF|', 75289, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138942034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJASOL IBEX CLIQUET III', 'ES0128468032', 'EUR', 2, '|f_es_BMF|', 79649, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0128468032||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJASOL RENTAS CRECIENTES', 'ES0174808032', 'EUR', 2, '|f_es_BMF|', 74919, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0174808032||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJASTUR BOLSA MUNDIAL', 'ES0110951037', 'EUR', 2, '|f_es_BMF|', 79650, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0110951037||es||False', false, '{NULL,F0GBR04IU7,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJASTUR CARTERA AGRESIVA', 'ES0109227035', 'EUR', 2, '|f_es_BMF|', 79651, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0109227035||es||False', false, '{NULL,F0GBR06U7O,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJASTUR CARTERA CONSERVADORA', 'ES0113701033', 'EUR', 2, '|f_es_BMF|', 74869, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113701033||es||False', false, '{NULL,F0GBR06U7E,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJASTUR CARTERA MODERADA', 'ES0115431035', 'EUR', 2, '|f_es_BMF|', 79652, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115431035||es||False', false, '{NULL,F0GBR06U7F,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJASTUR DOBLE OPTIMO', 'ES0114819032', 'EUR', 2, '|f_es_BMF|', 79653, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114819032||es||False', false, '{NULL,F0GBR05SJK,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJASTUR ESTRATEGIAS GARANTIZADO', 'ES0115432009', 'EUR', 2, '|f_es_BMF|', 79655, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115432009||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJASTUR INDICES II', 'ES0114604038', 'EUR', 2, '|f_es_BMF|', 79618, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114604038||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJASTUR MULTICESTA OPTIMA', 'ES0110961036', 'EUR', 2, '|f_es_BMF|', 79646, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0110961036||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJASTUR MULTICESTA OPTIMA II', 'ES0115319032', 'EUR', 2, '|f_es_BMF|', 75170, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115319032||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJASTUR RENTA FIJA', 'ES0111026037', 'EUR', 2, '|f_es_BMF|', 79665, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0111026037||es||False', false, '{NULL,F0GBR04ITV,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJASTUR RENTA FIJA II, FI', 'ES0115380000', 'EUR', 2, '|f_es_BMF|', 79666, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115380000||es||False', false, '{NULL,F00000J4AN,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJASTUR VALOR GARANTIZADO', 'ES0164737035', 'EUR', 2, '|f_es_BMF|', 79672, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0164737035||es||False', false, '{NULL,F0GBR04EJ6,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJASUR BOLSA EURO', 'ES0115512032', 'EUR', 2, '|f_es_BMF|', 79679, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115512032||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJASUR HISPANIA', 'ES0115447031', 'EUR', 2, '|f_es_BMF|', 74889, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115447031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJASUR MAXIMO GARANTIZADO', 'ES0164738033', 'EUR', 2, '|f_es_BMF|', 74920, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0164738033||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJASUR MIXTO', 'ES0114893037', 'EUR', 2, '|f_es_BMF|', 75171, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114893037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJASUR RENTA FIJA EURO', 'ES0115445035', 'EUR', 2, '|f_es_BMF|', 78756, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115445035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAJASUR SELECION MUNDIAL GARANTIZADO FI', 'ES0115381008', 'EUR', 2, '|f_es_BMF|', 79680, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115381008||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAL DIVE INTERNATIONAL INC.', NULL, 'USD', 1, '', 80340, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DVR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALGON CARBON CORP.', NULL, 'USD', 1, '', 79391, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CCC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALIFORNIA WATER SERVICE GROUP', NULL, 'USD', 1, '', 81565, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CWT||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALIX INC.', NULL, 'USD', 1, '', 80949, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CALX||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 10000 € | 15/06/12 | B9961', 'FR0011091503', 'EUR', 5, '|w_fr_SG|', 78861, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B9961||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 10000 € | 16/03/12 | B7609', 'FR0011058452', 'EUR', 5, '|w_fr_SG|', 75231, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B7609||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 10000 € | 16/09/11 | B4740', 'FR0010984583', 'EUR', 5, '|w_fr_SG|', 77248, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B4740||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 10000 € | 16/12/11 | B5141', 'FR0011002757', 'EUR', 5, '|w_fr_SG|', 76592, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B5141||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 10000 € | 17/06/11 | B1775', 'FR0010936096', 'EUR', 5, '|w_fr_SG|', 74984, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B1775||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 10000 € | 18/11/11 | B7219', 'FR0011039692', 'EUR', 5, '|w_fr_SG|', 76503, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B7219||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 10000 € | 21/09/12 | C3292', 'FR0011168327', 'EUR', 5, '|w_fr_SG|', 74850, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#C3292||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 10000 € | 21/12/12 | C1127', 'FR0011124320', 'EUR', 5, '|w_fr_SG|', 80364, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#C1127||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 10250 € | 17/02/12 | B9706', 'FR0011083856', 'EUR', 5, '|w_fr_SG|', 75984, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B9706||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 10250 € | 18/05/12 | C2137', 'FR0011145457', 'EUR', 5, '|w_fr_SG|', 75684, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#C2137||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 10250 € | 19/08/11 | B6048', 'FR0011017730', 'EUR', 5, '|w_fr_SG|', 75204, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B6048||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 10250 € | 20/01/12 | B9696', 'FR0011083757', 'EUR', 5, '|w_fr_SG|', 80705, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B9696||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 10250 € | 20/04/12 | C2132', 'FR0011145408', 'EUR', 5, '|w_fr_SG|', 80208, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#C2132||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 10250 € | 20/05/11 | B4725', 'FR0010984435', 'EUR', 5, '|w_fr_SG|', 75068, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B4725||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 10250 € | 21/10/11 | B7208', 'FR0011039585', 'EUR', 5, '|w_fr_SG|', 77432, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B7208||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 10500 € | 15/06/12 | B9962', 'FR0011091511', 'EUR', 5, '|w_fr_SG|', 78021, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B9962||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 10500 € | 16/03/12 | B7610', 'FR0011058460', 'EUR', 5, '|w_fr_SG|', 75475, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B7610||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 10500 € | 16/09/11 | B4741', 'FR0010984591', 'EUR', 5, '|w_fr_SG|', 77249, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B4741||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 10500 € | 16/12/11 | B5142', 'FR0011002765', 'EUR', 5, '|w_fr_SG|', 75114, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B5142||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 10500 € | 17/06/11 | B1776', 'FR0010936104', 'EUR', 5, '|w_fr_SG|', 75048, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B1776||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 10500 € | 18/11/11 | B7220', 'FR0011039700', 'EUR', 5, '|w_fr_SG|', 76501, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B7220||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 10500 € | 21/09/12 | C3293', 'FR0011168335', 'EUR', 5, '|w_fr_SG|', 76080, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#C3293||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 10750 € | 17/02/12 | B9707', 'FR0011083864', 'EUR', 5, '|w_fr_SG|', 76086, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B9707||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 10750 € | 18/05/12 | C2138', 'FR0011145465', 'EUR', 5, '|w_fr_SG|', 76031, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#C2138||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 10750 € | 19/08/11 | B6049', 'FR0011017748', 'EUR', 5, '|w_fr_SG|', 76671, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B6049||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 10750 € | 20/01/12 | B9697', 'FR0011083765', 'EUR', 5, '|w_fr_SG|', 80698, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B9697||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 10750 € | 20/04/12 | C2133', 'FR0011145416', 'EUR', 5, '|w_fr_SG|', 75535, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#C2133||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 10750 € | 20/05/11 | B4726', 'FR0010984443', 'EUR', 5, '|w_fr_SG|', 75100, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B4726||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 10750 € | 21/10/11 | B7209', 'FR0011039593', 'EUR', 5, '|w_fr_SG|', 77393, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B7209||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 11000 € | 15/06/12 | B9963', 'FR0011091529', 'EUR', 5, '|w_fr_SG|', 77989, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B9963||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 11000 € | 15/12/17 | E1292', 'DE000SGM1G35', 'EUR', 5, '', 81681, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, NULL, true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 11000 € | 16/03/12 | B7611', 'FR0011058478', 'EUR', 5, '|w_fr_SG|', 75477, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B7611||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 11000 € | 16/09/11 | B4742', 'FR0010984609', 'EUR', 5, '|w_fr_SG|', 75246, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B4742||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 11000 € | 16/12/11 | B5143', 'FR0011002773', 'EUR', 5, '|w_fr_SG|', 75142, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B5143||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 11000 € | 17/06/11 | B1777', 'FR0010936112', 'EUR', 5, '|w_fr_SG|', 75047, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B1777||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 11000 € | 18/11/11 | B7221', 'FR0011039718', 'EUR', 5, '|w_fr_SG|', 78820, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B7221||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 11000 € | 19/12/14 | B7869 ', NULL, 'EUR', 5, '', 78050, NULL, NULL, NULL, NULL, 100, 'c', -1, 1, 'SGW#B7869||es||True', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 11000 € | 20/12/13 | B7864', 'FR0011065671', 'EUR', 5, '|w_fr_SG|', 78045, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B7864||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 11000 € | 21/09/12 | C3294', 'FR0011168343', 'EUR', 5, '|w_fr_SG|', 78802, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#C3294||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 11250 € | 17/02/12 | B9708', 'FR0011083872', 'EUR', 5, '|w_fr_SG|', 77852, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B9708||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 11250 € | 19/08/11 | B6050', 'FR0011017755', 'EUR', 5, '|w_fr_SG|', 75256, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B6050||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 11250 € | 20/01/12 | B9698', 'FR0011083773', 'EUR', 5, '|w_fr_SG|', 80699, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B9698||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 11250 € | 20/05/11 | B4727', 'FR0010984450', 'EUR', 5, '|w_fr_SG|', 75099, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B4727||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 11250 € | 21/10/11 | B7210', 'FR0011039601', 'EUR', 5, '|w_fr_SG|', 77397, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B7210||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 11500 € | 15/06/12 | B9964', 'FR0011091537', 'EUR', 5, '|w_fr_SG|', 80818, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B9964||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 11500 € | 16/03/12 | B7612', 'FR0011058486', 'EUR', 5, '|w_fr_SG|', 75750, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B7612||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 11500 € | 16/09/11 | B4743', 'FR0010984617', 'EUR', 5, '|w_fr_SG|', 75639, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B4743||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 11500 € | 16/12/11 | B5144', 'FR0011002781', 'EUR', 5, '|w_fr_SG|', 75088, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B5144||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 11500 € | 17/06/11 | B1778', 'FR0010936120', 'EUR', 5, '|w_fr_SG|', 75045, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B1778||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 11500 € | 18/11/11 | B7222', 'FR0011039726', 'EUR', 5, '|w_fr_SG|', 78823, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B7222||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 11500 € | 21/12/12 | B7858', 'FR0011065614', 'EUR', 5, '|w_fr_SG|', 80366, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B7858||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 11750 € | 17/02/12 | B9709', 'FR0011083880', 'EUR', 5, '|w_fr_SG|', 77854, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B9709||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 11750 € | 19/08/11 | B6051', 'FR0011017763', 'EUR', 5, '|w_fr_SG|', 75804, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B6051||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 11750 € | 20/05/11 | B4728', 'FR0010984468', 'EUR', 5, '|w_fr_SG|', 75134, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B4728||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 11750 € | 21/10/11 | B7211', 'FR0011039619', 'EUR', 5, '|w_fr_SG|', 77451, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B7211||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 12000 € | 15/06/12 | B9965', 'FR0011091545', 'EUR', 5, '|w_fr_SG|', 80819, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B9965||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 12000 € | 16/03/12 | B7613', 'FR0011058494', 'EUR', 5, '|w_fr_SG|', 75031, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B7613||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 12000 € | 16/09/11 | B4744', 'FR0010984625', 'EUR', 5, '|w_fr_SG|', 75640, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B4744||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 12000 € | 16/12/11 | B5145', 'FR0011002799', 'EUR', 5, '|w_fr_SG|', 75148, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B5145||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 12000 € | 17/06/11 | B1779', 'FR0010936138', 'EUR', 5, '|w_fr_SG|', 75049, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B1779||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 12000 € | 18/11/11 | B7223', 'FR0011039734', 'EUR', 5, '|w_fr_SG|', 76041, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B7223||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 12250 € | 19/08/11 | B6052', 'FR0011017771', 'EUR', 5, '|w_fr_SG|', 75183, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B6052||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 12250 € | 21/10/11 | B7212', 'FR0011039627', 'EUR', 5, '|w_fr_SG|', 77452, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B7212||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 12500 € | 16/12/11 | B5146', 'FR0011002807', 'EUR', 5, '|w_fr_SG|', 76191, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B5146||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 13000 € | 16/12/11 | B5147', 'FR0011002815', 'EUR', 5, '|w_fr_SG|', 76175, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B5147||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 13000 € | 19/12/14 | B7870', 'FR0011065739', 'EUR', 5, '|w_fr_SG|', 76806, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B7870||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 13000 € | 20/12/13 | B7865', 'FR0011065689', 'EUR', 5, '|w_fr_SG|', 80347, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B7865||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 13000 € | 21/12/12 | B7859', 'FR0011065622', 'EUR', 5, '|w_fr_SG|', 80372, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B7859||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 14500 € | 21/12/12 | B7860', 'FR0011065630', 'EUR', 5, '|w_fr_SG|', 75301, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B7860||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 15000 € | 19/12/14 | B7871', 'FR0011065747', 'EUR', 5, '|w_fr_SG|', 76114, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B7871||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 15000 € | 20/12/13 | B7866', 'FR0011065697', 'EUR', 5, '|w_fr_SG|', 78803, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B7866||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 6500 € | 15/06/12 | C1126', 'FR0011124312', 'EUR', 5, '|w_fr_SG|', 79320, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#C1126||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 6500 € | 16/03/12 | C1099', 'FR0011124049', 'EUR', 5, '|w_fr_SG|', 77897, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#C1099||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 6500 € | 21/09/12 | C3285', 'FR0011168251', 'EUR', 5, '|w_fr_SG|', 78799, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#C3285||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 6750 € | 17/02/12 | C1096', 'FR0011124015', 'EUR', 5, '|w_fr_SG|', 75423, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#C1096||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 6750 € | 18/05/12 | C1114', 'FR0011124197', 'EUR', 5, '|w_fr_SG|', 78818, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#C1114||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 6750 € | 20/01/12 | C1094', 'FR0011123991', 'EUR', 5, '|w_fr_SG|', 80690, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#C1094||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 6750 € | 20/04/12 | C1102', 'FR0011124072', 'EUR', 5, '|w_fr_SG|', 75754, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#C1102||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 7000 € | 15/06/12 | B9955', 'FR0011091446', 'EUR', 5, '|w_fr_SG|', 80210, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B9955||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 7000 € | 16/03/12 | B9951', 'FR0011091404', 'EUR', 5, '|w_fr_SG|', 77898, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B9951||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 7000 € | 16/12/11 | B9939', 'FR0011091289', 'EUR', 5, '|w_fr_SG|', 76073, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B9939||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 7000 € | 18/11/11 | B9997', 'FR0011101781', 'EUR', 5, '|w_fr_SG|', 76274, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B9997||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 7000 € | 21/09/12 | C3286', 'FR0011168269', 'EUR', 5, '|w_fr_SG|', 76690, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#C3286||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 7250 € | 17/02/12 | C1097', 'FR0011124023', 'EUR', 5, '|w_fr_SG|', 75426, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#C1097||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 7250 € | 18/05/12 | C1115', 'FR0011124205', 'EUR', 5, '|w_fr_SG|', 78826, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#C1115||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 7250 € | 20/01/12 | C1095', 'FR0011124007', 'EUR', 5, '|w_fr_SG|', 75983, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#C1095||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 7250 € | 20/04/12 | C1103', 'FR0011124080', 'EUR', 5, '|w_fr_SG|', 78786, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#C1103||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 7250 € | 21/10/11 | B9996', 'FR0011101773', 'EUR', 5, '|w_fr_SG|', 78559, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B9996||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 7500 € | 15/06/12 | B9956', 'FR0011091453', 'EUR', 5, '|w_fr_SG|', 80211, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B9956||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 7500 € | 16/03/12 | B9952', 'FR0011091412', 'EUR', 5, '|w_fr_SG|', 77899, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B9952||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 7500 € | 16/12/11 | B9940', 'FR0011091297', 'EUR', 5, '|w_fr_SG|', 74946, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B9940||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 7500 € | 17/06/11 | B4061', 'FR0010972562', 'EUR', 5, '|w_fr_SG|', 75547, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B4061||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 7500 € | 18/11/11 | B9933', 'FR0011091222', 'EUR', 5, '|w_fr_SG|', 75137, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B9933||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 7500 € | 21/09/12 | C3287', 'FR0011168277', 'EUR', 5, '|w_fr_SG|', 76693, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#C3287||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 7750 € | 17/02/12 | C1098', 'FR0011124031', 'EUR', 5, '|w_fr_SG|', 75606, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#C1098||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 7750 € | 18/05/12 | C1116', 'FR0011124213', 'EUR', 5, '|w_fr_SG|', 78833, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#C1116||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 7750 € | 20/01/12 | B9943', 'FR0011091321', 'EUR', 5, '|w_fr_SG|', 80729, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B9943||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 7750 € | 20/04/12 | C1104', 'FR0011124098', 'EUR', 5, '|w_fr_SG|', 78794, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#C1104||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 7750 € | 21/10/11 | B9931', 'FR0011091206', 'EUR', 5, '|w_fr_SG|', 75645, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B9931||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 8000 € | 15/06/12 | B9957', 'FR0011091461', 'EUR', 5, '|w_fr_SG|', 78891, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B9957||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 8000 € | 16/03/12 | B9555', 'FR0011080845', 'EUR', 5, '|w_fr_SG|', 75472, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B9555||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 8000 € | 16/09/11 | B4736', 'FR0010984542', 'EUR', 5, '|w_fr_SG|', 77256, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B4736||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 8000 € | 16/12/11 | B9552', 'FR0011080811', 'EUR', 5, '|w_fr_SG|', 74956, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B9552||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 8000 € | 17/06/11 | B1771', 'FR0010936054', 'EUR', 5, '|w_fr_SG|', 74952, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B1771||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 8000 € | 18/11/11 | B9934', 'FR0011091230', 'EUR', 5, '|w_fr_SG|', 76715, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B9934||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 8000 € | 21/09/12 | C3288', 'FR0011168285', 'EUR', 5, '|w_fr_SG|', 78801, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#C3288||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 8000 € | 21/12/12 | C3303', 'FR0011168434', 'EUR', 5, '|w_fr_SG|', 80362, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#C3303||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 8250 € | 17/02/12 | B9947', 'FR0011091362', 'EUR', 5, '|w_fr_SG|', 75125, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B9947||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 8250 € | 18/05/12 | C1117', 'FR0011124221', 'EUR', 5, '|w_fr_SG|', 78835, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#C1117||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 8250 € | 20/01/12 | B9944', 'FR0011091339', 'EUR', 5, '|w_fr_SG|', 80730, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B9944||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 8250 € | 20/04/12 | C1105', 'FR0011124106', 'EUR', 5, '|w_fr_SG|', 78770, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#C1105||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 8250 € | 21/10/11 | B9932', 'FR0011091214', 'EUR', 5, '|w_fr_SG|', 75264, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B9932||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 8500 € | 15/06/12 | B9958', 'FR0011091479', 'EUR', 5, '|w_fr_SG|', 80816, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B9958||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 8500 € | 16/03/12 | B9556', 'FR0011080852', 'EUR', 5, '|w_fr_SG|', 75230, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B9556||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 8500 € | 16/09/11 | B4737', 'FR0010984559', 'EUR', 5, '|w_fr_SG|', 77257, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B4737||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 8500 € | 16/12/11 | B9553', 'FR0011080829', 'EUR', 5, '|w_fr_SG|', 76142, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B9553||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 8500 € | 17/06/11 | B1772', 'FR0010936062', 'EUR', 5, '|w_fr_SG|', 75146, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B1772||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 8500 € | 18/11/11 | B9935', 'FR0011091248', 'EUR', 5, '|w_fr_SG|', 74894, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B9935||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 8500 € | 21/09/12 | C3289', 'FR0011168293', 'EUR', 5, '|w_fr_SG|', 75350, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#C3289||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 8750 € | 17/02/12 | B9948', 'FR0011091370', 'EUR', 5, '|w_fr_SG|', 75132, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B9948||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 8750 € | 18/05/12 | C1118', 'FR0011124239', 'EUR', 5, '|w_fr_SG|', 76796, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#C1118||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 8750 € | 20/01/12 | B9693', 'FR0011083724', 'EUR', 5, '|w_fr_SG|', 80732, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B9693||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 8750 € | 20/04/12 | C1106', 'FR0011124114', 'EUR', 5, '|w_fr_SG|', 75733, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#C1106||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 8750 € | 20/05/11 | B4722', 'FR0010984401', 'EUR', 5, '|w_fr_SG|', 75133, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B4722||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 8750 € | 21/10/11 | B9548', 'FR0011080779', 'EUR', 5, '|w_fr_SG|', 75040, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B9548||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 9000 € | 15/06/12 | B9959', 'FR0011091487', 'EUR', 5, '|w_fr_SG|', 78860, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B9959||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 9000 € | 16/03/12 | B7614', 'FR0011058437', 'EUR', 5, '|w_fr_SG|', 75682, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B7614||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 9000 € | 16/09/11 | B4738', 'FR0010984567', 'EUR', 5, '|w_fr_SG|', 77247, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B4738||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 9000 € | 16/12/11 | B5139', 'FR0011002732', 'EUR', 5, '|w_fr_SG|', 74755, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B5139||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 9000 € | 17/06/11 | B1773', 'FR0010936070', 'EUR', 5, '|w_fr_SG|', 74953, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B1773||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 9000 € | 18/11/11 | B9550', 'FR0011080795', 'EUR', 5, '|w_fr_SG|', 74947, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B9550||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 9000 € | 19/12/14 | C3306', 'FR0011168467', 'EUR', 5, '|w_fr_SG|', 78048, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#C3306||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 9000 € | 20/12/13 | C3305', 'FR0011168459', 'EUR', 5, '|w_fr_SG|', 76798, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#C3305||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 9000 € | 21/09/12 | C3290', 'FR0011168301', 'EUR', 5, '|w_fr_SG|', 80803, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#C3290||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 9000 € | 21/12/12 | C3304', 'FR0011168442', 'EUR', 5, '|w_fr_SG|', 76841, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#C3304||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 9250 € | 17/02/12 | B9704', 'FR0011083831', 'EUR', 5, '|w_fr_SG|', 75574, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B9704||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 9250 € | 18/05/12 | C1119', 'FR0011124247', 'EUR', 5, '|w_fr_SG|', 76022, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#C1119||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 9250 € | 19/08/11 | B6046', 'FR0011017714', 'EUR', 5, '|w_fr_SG|', 75008, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B6046||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 9250 € | 20/01/12 | B9694', 'FR0011083732', 'EUR', 5, '|w_fr_SG|', 80733, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B9694||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 9250 € | 20/04/12 | C1107', 'FR0011124122', 'EUR', 5, '|w_fr_SG|', 75740, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#C1107||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 9250 € | 20/05/11 | B4723', 'FR0010984419', 'EUR', 5, '|w_fr_SG|', 75107, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B4723||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 9250 € | 21/10/11 | B7206', 'FR0011039569', 'EUR', 5, '|w_fr_SG|', 75713, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B7206||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 9500 € | 15/06/12 | B9960', 'FR0011091495', 'EUR', 5, '|w_fr_SG|', 80817, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B9960||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 9500 € | 16/03/12 | B7615', 'FR0011058445', 'EUR', 5, '|w_fr_SG|', 75281, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B7615||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 9500 € | 16/09/11 | B4739', 'FR0010984575', 'EUR', 5, '|w_fr_SG|', 77250, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B4739||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 9500 € | 16/12/11 | B5140', 'FR0011002740', 'EUR', 5, '|w_fr_SG|', 76591, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B5140||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 9500 € | 17/06/11 | B1774', 'FR0010936088', 'EUR', 5, '|w_fr_SG|', 75145, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B1774||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 9500 € | 18/11/11 | B7218', 'FR0011039684', 'EUR', 5, '|w_fr_SG|', 76063, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B7218||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 9500 € | 21/09/12 | C3291', 'FR0011168319', 'EUR', 5, '|w_fr_SG|', 74826, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#C3291||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 9750 € | 17/02/12 | B9705', 'FR0011083849', 'EUR', 5, '|w_fr_SG|', 75981, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B9705||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 9750 € | 18/05/12 | C1120', 'FR0011124254', 'EUR', 5, '|w_fr_SG|', 75789, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#C1120||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 9750 € | 19/08/11 | B6047', 'FR0011017722', 'EUR', 5, '|w_fr_SG|', 75338, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B6047||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 9750 € | 20/01/12 | B9695', 'FR0011083740', 'EUR', 5, '|w_fr_SG|', 80724, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B9695||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 9750 € | 20/04/12 | C1108', 'FR0011124130', 'EUR', 5, '|w_fr_SG|', 75876, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#C1108||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 9750 € | 20/05/11 | B4724', 'FR0010984427', 'EUR', 5, '|w_fr_SG|', 74859, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B4724||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 | 9750 € | 21/10/11 | B7207', 'FR0011039577', 'EUR', 5, '|w_fr_SG|', 76229, NULL, NULL, NULL, NULL, 100, 'c', -1, 3, 'SGW#B7207||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 INLINE | 6500 € | 14/12/11 | I0043', 'FR0011117605', 'EUR', 5, '|w_fr_SG|', 78876, NULL, NULL, NULL, NULL, 100, 'i', -1, 3, 'SGW#I0043||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 INLINE | 7000 € | 14/03/12 | I0048', 'FR0011117886', 'EUR', 5, '|w_fr_SG|', 74749, NULL, NULL, NULL, NULL, 100, 'i', -1, 3, 'SGW#I0048||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 INLINE | 7000 € | 14/03/12 | I0049', 'FR0011117902', 'EUR', 5, '|w_fr_SG|', 76344, NULL, NULL, NULL, NULL, 100, 'i', -1, 3, 'SGW#I0049||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 INLINE | 7000 € | 14/12/11 | I0044', 'FR0011117621', 'EUR', 5, '|w_fr_SG|', 78875, NULL, NULL, NULL, NULL, 100, 'i', -1, 3, 'SGW#I0044||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 INLINE | 7500 € | 14/03/12 | I0050', 'FR0011117993', 'EUR', 5, '|w_fr_SG|', 74815, NULL, NULL, NULL, NULL, 100, 'i', -1, 3, 'SGW#I0050||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 INLINE | 7500 € | 14/12/11 | I0036', 'FR0011081330', 'EUR', 5, '|w_fr_SG|', 76340, NULL, NULL, NULL, NULL, 100, 'i', -1, 3, 'SGW#I0036||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 INLINE | 7500 € | 14/12/11 | I0037', 'FR0011081355', 'EUR', 5, '|w_fr_SG|', 76341, NULL, NULL, NULL, NULL, 100, 'i', -1, 3, 'SGW#I0037||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 INLINE | 8000 € | 14/12/11 | I0038', 'FR0011081363', 'EUR', 5, '|w_fr_SG|', 74846, NULL, NULL, NULL, NULL, 100, 'i', -1, 3, 'SGW#I0038||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 INLINE | 8000 € | 14/12/11 | I0039', 'FR0011081371', 'EUR', 5, '|w_fr_SG|', 75836, NULL, NULL, NULL, NULL, 100, 'i', -1, 3, 'SGW#I0039||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 INLINE | 8000 € | 15/09/11 | I0026', 'FR0011038900', 'EUR', 5, '|w_fr_SG|', 75259, NULL, NULL, NULL, NULL, 100, 'i', -1, 3, 'SGW#I0026||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 INLINE | 8000 € | 15/09/11 | I0027', 'FR0011038918', 'EUR', 5, '|w_fr_SG|', 75205, NULL, NULL, NULL, NULL, 100, 'i', -1, 3, 'SGW#I0027||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 INLINE | 8000 € | 17/06/11 | I0025', 'FR0011002377', 'EUR', 5, '|w_fr_SG|', 76797, NULL, NULL, NULL, NULL, 100, 'i', -1, 3, 'SGW#I0025||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 INLINE | 8500 € | 14/12/11 | I0040', 'FR0011081389', 'EUR', 5, '|w_fr_SG|', 75824, NULL, NULL, NULL, NULL, 100, 'i', -1, 3, 'SGW#I0040||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 INLINE | 8500 € | 15/09/11 | I0028', 'FR0011038926', 'EUR', 5, '|w_fr_SG|', 75186, NULL, NULL, NULL, NULL, 100, 'i', -1, 3, 'SGW#I0028||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 INLINE | 8500 € | 17/06/11 | I0024', 'FR0011002369', 'EUR', 5, '|w_fr_SG|', 76215, NULL, NULL, NULL, NULL, 100, 'i', -1, 3, 'SGW#I0024||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 INLINE | 9000 € | 14/12/11 | I0041', 'FR0011081397', 'EUR', 5, '|w_fr_SG|', 75799, NULL, NULL, NULL, NULL, 100, 'i', -1, 3, 'SGW#I0041||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 INLINE | 9000 € | 14/12/11 | I0042', 'FR0011081405', 'EUR', 5, '|w_fr_SG|', 75803, NULL, NULL, NULL, NULL, 100, 'i', -1, 3, 'SGW#I0042||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 INLINE | 9000 € | 15/09/11 | I0029', 'FR0011038934', 'EUR', 5, '|w_fr_SG|', 75354, NULL, NULL, NULL, NULL, 100, 'i', -1, 3, 'SGW#I0029||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 INLINE | 9000 € | 15/09/11 | I0030', 'FR0011038942', 'EUR', 5, '|w_fr_SG|', 74898, NULL, NULL, NULL, NULL, 100, 'i', -1, 3, 'SGW#I0030||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 INLINE | 9000 € | 15/09/11 | I0031', 'FR0011038959', 'EUR', 5, '|w_fr_SG|', 75506, NULL, NULL, NULL, NULL, 100, 'i', -1, 3, 'SGW#I0031||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 INLINE | 9000 € | 17/06/11 | I0023', 'FR0011002351', 'EUR', 5, '|w_fr_SG|', 75972, NULL, NULL, NULL, NULL, 100, 'i', -1, 3, 'SGW#I0023||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALL IBEX 35 INLINE | 9500 € | 17/06/11 | I0022', 'FR0011002344', 'EUR', 5, '|w_fr_SG|', 78068, NULL, NULL, NULL, NULL, 100, 'i', -1, 3, 'SGW#I0022||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALLAWAY GOLF CO.', NULL, 'USD', 1, '', 79710, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ELY||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALLON PETROLEUM CO.', NULL, 'USD', 1, '', 79876, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CPE||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CALPINE CORP.', NULL, 'USD', 1, '', 77909, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CPN||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAM BOLSA INDICE', 'ES0139013033', 'EUR', 2, '|f_es_BMF|', 79714, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0139013033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAM DINERO 1', 'ES0126534033', 'EUR', 2, '|f_es_BMF|', 77913, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0126534033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAM DINERO AHORRO', 'ES0107482038', 'EUR', 2, '|f_es_BMF|', 77916, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0107482038||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAM DINERO PLATINUM', 'ES0124553035', 'EUR', 2, '|f_es_BMF|', 77917, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0124553035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAM DINERO PLUS', 'ES0170273033', 'EUR', 2, '|f_es_BMF|', 79715, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0170273033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAM DINERO PREMIER', 'ES0170668034', 'EUR', 2, '|f_es_BMF|', 77927, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0170668034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAM EMERGENTES', 'ES0105142030', 'EUR', 2, '|f_es_BMF|', 77920, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0105142030||es||False', false, '{NULL,F0GBR04PVB,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAM', 'ES0114400007', 'EUR', 1, '|MERCADOCONTINUO|', 81429, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0114400007||es||False', false, '{CAM.MC,NULL,BME:CAM,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAM FONDEMPRESAS', 'ES0105143038', 'EUR', 2, '|f_es_BMF|', 79768, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0105143038||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAM FONDO EMPRESA PLUS', 'ES0115448039', 'EUR', 2, '|f_es_BMF|', 79769, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115448039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAM FONMEDIC', 'ES0138910031', 'EUR', 2, '|f_es_BMF|', 79772, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138910031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAM FUTURO 10 GARANTIZADO', 'ES0140848039', 'EUR', 2, '|f_es_BMF|', 79773, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0140848039||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAM FUTURO 8 GARANTIZADO', 'ES0140983034', 'EUR', 2, '|f_es_BMF|', 77924, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0140983034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAM FUTURO 9 GARANTIZADO', 'ES0105171039', 'EUR', 2, '|f_es_BMF|', 77925, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0105171039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAM FUTURO SELECCION 7', 'ES0140982036', 'EUR', 2, '|f_es_BMF|', 77136, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0140982036||es||False', false, '{NULL,F0GBR04PW1,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAM FUTURO SELECCION', 'ES0175116039', 'EUR', 2, '|f_es_BMF|', 75888, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0175116039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAM GLOBAL', 'ES0115582035', 'EUR', 2, '|f_es_BMF|', 79752, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115582035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAM MIXTO 25', 'ES0115070031', 'EUR', 2, '|f_es_BMF|', 79754, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115070031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAM MIXTO 50', 'ES0175114034', 'EUR', 2, '|f_es_BMF|', 79235, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0175114034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAM MUNDIAL BONOS', 'ES0138933033', 'EUR', 2, '|f_es_BMF|', 75361, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138933033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAMAIEU', 'FR0004008209', 'EUR', 1, '|EURONEXT|', 75661, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0004008209||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAMBODGE NOM.', 'FR0000079659', 'EUR', 1, '|EURONEXT|', 76890, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000079659||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAMBREX CORP.', NULL, 'USD', 1, '', 80359, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CBM||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAMDEN PROPERTY TRUST', NULL, 'USD', 1, '', 76222, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CPT||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAMECO CORP.', NULL, 'USD', 1, '', 77687, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CCJ||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAMELEON SOFTWARE', 'FR0000074247', 'EUR', 1, '|EURONEXT|', 76891, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000074247||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAMELOT INFORMATION SYSTEMS INC.', NULL, 'USD', 1, '', 80212, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CIS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAMERON INTERNATIONAL CORP.', NULL, 'USD', 1, '|SP500|', 74872, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CAM||us||False', false, '{CAM,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAMESO BSAR17JUL14', 'FR0010772921', 'EUR', 1, '|EURONEXT|', 76901, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010772921||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAMINOS BOLSA EURO', 'ES0138168036', 'EUR', 2, '|f_es_BMF|', 79757, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138168036||es||False', false, '{NULL,F0GBR04J68,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAMINOS BOLSA OPORTUNIDADES', 'ES0138253036', 'EUR', 2, '|f_es_BMF|', 79791, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138253036||es||False', false, '{NULL,F0GBR04J5W,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAMPBELL SOUP CO.', NULL, 'USD', 1, '|SP500|', 78372, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CPB||us||False', false, '{CPB,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAMPINE', 'BE0003825420', 'EUR', 1, '|EURONEXT|', 76902, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003825420||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAMPOFRIO FOOD GROUP', 'ES0121501318', 'EUR', 1, '|MERCADOCONTINUO|', 78415, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0121501318||es||False', false, '{CFG.MC,NULL,BME:CFG,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAMPUS CREST COMMUNITIES INC.', NULL, 'USD', 1, '', 79883, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CCG||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAN EURIBOR GARANTIA', 'ES0115730030', 'EUR', 2, '|f_es_BMF|', 79804, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115730030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAN EURIBOR GARANTIA II', 'ES0165548035', 'EUR', 2, '|f_es_BMF|', 79805, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0165548035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAN PLUSMARCA ACTIVA', 'ES0115707038', 'EUR', 2, '|f_es_BMF|', 79813, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115707038||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CANADIAN IMPERIAL BANK OF COMMERCE', NULL, 'USD', 1, '', 75965, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CM||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CANADIAN NATIONAL RAILWAY CO.', NULL, 'USD', 1, '', 78917, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CNI||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CANADIAN NATURAL RESOURCES LTD.', NULL, 'USD', 1, '', 78634, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CNQ||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CANADIAN PACIFIC RAILWAY LTD.', NULL, 'USD', 1, '', 77816, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CP||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CANAL PLUS(STE ED)', 'FR0000125460', 'EUR', 1, '|EURONEXT|', 80019, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000125460||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CANCOM AG', 'DE0005419105', 'EUR', 1, '|DEUTSCHEBOERSE|', 78827, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005419105||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CANON INC.', NULL, 'USD', 1, '', 76819, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CAJ||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CANTABRIA ACCIONES', 'ES0115869036', 'EUR', 2, '|f_es_BMF|', 79817, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115869036||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CANTABRIA BOLSA EURO', 'ES0115904031', 'EUR', 2, '|f_es_BMF|', 79818, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115904031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CANTABRIA CRECIMIENTO GAR. FI', 'ES0115905038', 'EUR', 2, '|f_es_BMF|', 74970, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115905038||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CANTABRIA GESTION DINAMICA', 'ES0115872030', 'EUR', 2, '|f_es_BMF|', 79819, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115872030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CANTABRIA RENTA 20', 'ES0115868038', 'EUR', 2, '|f_es_BMF|', 79866, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115868038||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CANTABRIA RENTA FIJA EURO', 'ES0147161030', 'EUR', 2, '|f_es_BMF|', 79867, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147161030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CANTABRIA RF CORTO PLAZO', 'ES0182833030', 'EUR', 2, '|f_es_BMF|', 79868, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0182833030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CANTEL MEDICAL CORP', 'US1380981084', 'USD', 1, '', 74746, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'CMN||None||False', false, '{CMN,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAÑADA BLANCH', 'ES0115941033', 'EUR', 2, '|f_es_BMF|', 78757, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115941033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAPELLI', 'FR0010127530', 'EUR', 1, '|EURONEXT|', 80021, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010127530||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAPGEMINI', 'FR0000125338', 'EUR', 1, '|CAC|', 74881, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'CAP.PA||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAPITAL ONE FINANCIAL CORP.', NULL, 'USD', 1, '|SP500|', 78220, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#COF||us||False', false, '{COF,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAPITAL SENIOR LIVING CORP.', NULL, 'USD', 1, '', 79892, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CSU||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAPITAL TRUST INC. CL A', NULL, 'USD', 1, '', 81030, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CT||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAPITALSOURCE INC.', NULL, 'USD', 1, '', 81596, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CSE||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAPITRADE SYSTEMATIC GLOBAL FUTURES', 'ES0115957005', 'EUR', 2, '|f_es_BMF|', 79869, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115957005||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAPLEASE INC.', NULL, 'USD', 1, '', 79985, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#LSE||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAPSTEAD MORTGAGE CORP.', NULL, 'USD', 1, '', 79284, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CMO||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CARBO CERAMICS INC.', NULL, 'USD', 1, '', 78982, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CRR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CARDINAL HEALTH INC.', NULL, 'USD', 1, '|SP500|', 75322, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CAH||us||False', false, '{CAH,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAREFUSION CORPORATION', NULL, 'USD', 1, '|SP500|', 76691, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CFN||us||False', false, '{CFN,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CARL ZEISS MEDITEC AG', 'DE0005313704', 'EUR', 1, '|DEUTSCHEBOERSE|', 78828, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005313704||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CARLISLE COS.', NULL, 'USD', 1, '', 77306, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CSL||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CARMAX INC.', NULL, 'USD', 1, '|SP500|', 75758, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#KMX||us||False', false, '{KMX,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CARMIGNAC CAPITAL PLUS A EUR', 'LU0336084032', 'EUR', 2, '', 81480, NULL, NULL, NULL, NULL, 0, 'c', 1, 3, 'LU0336084032||fr||False', false, '{NULL,F000001V1S,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CARMIGNAC COMMODITIES (A)', 'LU0164455502', 'EUR', 2, '|f_fr_CARMIGNAC|', 81454, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'LU0164455502||fr||False', false, '{NULL,F0GBR04GUI,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CARMIGNAC COURT TERME', 'FR0010149161', 'EUR', 2, '|f_fr_CARMIGNAC|', 75236, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'FR0010149161||fr||False', false, '{NULL,F0GBR04F8H,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CARMIGNAC EMERGENTS (A)', 'FR0010149302', 'EUR', 2, '|f_fr_CARMIGNAC|', 81477, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'FR0010149302||fr||False', false, '{NULL,F0GBR04F8J,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CARMIGNAC EMERGING DISCOVERY', 'LU0336083810', 'EUR', 2, '|f_fr_CARMIGNAC|', 81452, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'LU0336083810||fr||False', false, '{NULL,F000001EWH,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CARMIGNAC EMERGING PATRIMOINE (A)', 'LU0592698954', 'EUR', 2, '|f_fr_CARMIGNAC|', 81460, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'LU0592698954||fr||False', false, '{NULL,F00000MK7J,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CARMIGNAC EMERGING PATRIMOINE (E)', 'LU0592699093', 'EUR', 2, '|f_fr_CARMIGNAC|', 81461, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'LU0592699093||fr||False', false, '{NULL,F00000MK7K,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CARMIGNAC EURO-ENTREPRENEURS', 'FR0010149112', 'EUR', 2, '|f_fr_CARMIGNAC|', 81476, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'FR0010149112||fr||False', false, '{NULL,F0GBR04F8U,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CARMIGNAC EURO-PATRIMOINE', 'FR0010149179', 'EUR', 2, '|f_fr_CARMIGNAC|', 81463, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'FR0010149179||fr||False', false, '{NULL,F0GBR04F8W,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CARMIGNAC GLOBAL BOND', 'LU0336083497', 'EUR', 2, '|f_fr_CARMIGNAC|', 81478, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'LU0336083497||fr||False', false, '{NULL,F000001EWI,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CARMIGNAC GRANDE EUROPE (A)', 'LU0099161993', 'EUR', 2, '|f_fr_CARMIGNAC|', 81474, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'LU0099161993||fr||False', false, '{NULL,F0GBR04NSH,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CARMIGNAC GRANDE EUROPE (E)', 'LU0294249692', 'EUR', 2, '|f_fr_CARMIGNAC|', 81475, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'LU0294249692||fr||False', false, '{NULL,F000000KBH,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CARMIGNAC INNOVATION', 'FR0010149096', 'EUR', 2, '|f_fr_CARMIGNAC|', 81453, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'FR0010149096||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CARMIGNAC INVESTISSEMENT (A)', 'FR0010148981', 'EUR', 2, '|f_fr_CARMIGNAC|', 81472, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'FR0010148981||fr||False', false, '{NULL,F0GBR04F8Y,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CARMIGNAC INVESTISSEMENT (E)', 'FR0010312660', 'EUR', 2, '|f_fr_CARMIGNAC|', 81473, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'FR0010312660||fr||False', false, '{NULL,FOGBR05K5G,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CARMIGNAC INVESTISSEMENT LATITUDE', 'FR0010147603', 'EUR', 2, '|f_fr_CARMIGNAC|', 75051, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'FR0010147603||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CARMIGNAC MARKET NEUTRAL', 'LU0413372060', 'EUR', 2, '|f_fr_CARMIGNAC|', 81464, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'LU0413372060||fr||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CARMIGNAC PATRIMOINE (A)', 'FR0010135103', 'EUR', 2, '|f_fr_CARMIGNAC|', 81458, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'FR0010135103||fr||False', false, '{NULL,F0GBR04F90,NULL,NULL,0P00000FB4}', false, 2);
INSERT INTO public.products VALUES ('CARMIGNAC PATRIMOINE (E)', 'FR0010306142', 'EUR', 2, '|f_fr_CARMIGNAC|', 81459, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'FR0010306142||fr||False', false, '{NULL,FOGBR05K5H,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CARMIGNAC PROFIL REACTIF 100', 'FR0010149211', 'EUR', 2, '|f_fr_CARMIGNAC|', 78066, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'FR0010149211||fr||False', false, '{NULL,F0GBR04IC2,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CARMIGNAC PROFIL RÉACTIF 50', 'FR0010149203', 'EUR', 2, '|f_fr_CARMIGNAC|', 78788, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'FR0010149203||fr||False', false, '{NULL,F0GBR04IC6,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CARMIGNAC PROFIL RÉACTIF 75', 'FR0010148999', 'EUR', 2, '|f_fr_CARMIGNAC|', 78036, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'FR0010148999||fr||False', false, '{NULL,F0GBR04F92,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CARMIGNAC SÉCURITÉ', 'FR0010149120', 'EUR', 2, '|f_fr_CARMIGNAC|', 81479, NULL, NULL, NULL, NULL, 0, 'c', 1, 3, 'FR0010149120||fr||False', false, '{NULL,F0GBR04F94,NULL,NULL,0P00000FB8}', false, 2);
INSERT INTO public.products VALUES ('CARNIVAL CORP.', NULL, 'USD', 1, '|SP500|', 79171, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CCL||us||False', false, '{CCL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CARPENTER TECHNOLOGY CORP.', NULL, 'USD', 1, '', 77875, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CRS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CARPINIENNE PART.', 'FR0000064156', 'EUR', 1, '|EURONEXT|', 77234, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000064156||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CARREFOUR', 'FR0000120172', 'EUR', 1, '|EURONEXT|', 77236, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000120172||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CARREFOUR S.A.', 'FR0010828137', 'EUR', 1, '|CAC|EURONEXT|EUROSTOXX|', 80252, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010828137||fr||False', false, '{CA.PA,NULL,EPA:CA,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CARRIAGE SERVICES INC.', NULL, 'USD', 1, '', 77625, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CSV||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CARTERA GESTION AUDAZ', 'ES0133664039', 'EUR', 2, '|f_es_BMF|', 79840, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133664039||es||False', false, '{NULL,F0GBR04OQ3,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CARTERA GESTION DEFENSIVA', 'ES0133578031', 'EUR', 2, '|f_es_BMF|', 79841, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133578031||es||False', false, '{NULL,F0GBR04OQ5,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CARTERA GESTION EQUILIBRADA', 'ES0133620031', 'EUR', 2, '|f_es_BMF|', 79858, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133620031||es||False', false, '{NULL,F0GBR04OQB,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CARTERA GESTION MODERADA', 'ES0133878035', 'EUR', 2, '|f_es_BMF|', 79860, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133878035||es||False', false, '{NULL,F0GBR04OQ9,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CARTERA SELECCION FLEXIBLE', 'ES0133613036', 'EUR', 2, '|f_es_BMF|', 79863, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133613036||es||False', false, '{NULL,F0GBR04KXK,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CARTERA UNIVERSAL', 'ES0112733037', 'EUR', 2, '|f_es_BMF|', 79870, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0112733037||es||False', false, '{NULL,F0GBR04O24,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CARTERA VARIABLE', 'ES0116565039', 'EUR', 2, '|f_es_BMF|', 79871, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0116565039||es||False', false, '{NULL,F0GBR04J64,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CARTERS INC.', NULL, 'USD', 1, '', 76568, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CRI||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CARTESIO X', 'ES0116567035', 'EUR', 2, '|f_es_BMF|', 77137, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0116567035||es||False', false, '{NULL,F0GBR04VSW,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CARTESIO Y', 'ES0182527038', 'EUR', 2, '|f_es_BMF|', 77139, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0182527038||es||False', false, '{NULL,F0GBR04VSJ,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CASCADE CORP.', NULL, 'USD', 1, '', 80914, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CASC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CASH AMERICA INTERNATIONAL INC.', NULL, 'USD', 1, '', 77970, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CSH||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CASH STORE FINANCIAL SERVICES INC.', NULL, 'USD', 1, '', 80209, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CSFS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CASINO GUICHARD', 'FR0000125585', 'EUR', 1, '|EURONEXT|', 76741, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000125585||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CAST', 'FR0000072894', 'EUR', 1, '|EURONEXT|', 75848, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000072894||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('C.A.T. OIL AG', 'AT0000A00Y78', 'EUR', 1, '|DEUTSCHEBOERSE|', 78822, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#AT0000A00Y78||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CATALANA OCCIDENTE BOLSA ESP.', 'ES0116901036', 'EUR', 2, '|f_es_BMF|', 77140, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0116901036||es||False', false, '{NULL,F0GBR04FD4,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CATALANA OCCIDENTE BOLSA MUNDIAL', 'ES0116881030', 'EUR', 2, '|f_es_BMF|', 77142, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0116881030||es||False', false, '{NULL,F00000064Z,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CATALANA OCCIDENTE PATRIMONIO', 'ES0116903032', 'EUR', 2, '|f_es_BMF|', 77212, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0116903032||es||False', false, '{NULL,F0GBR04FD6,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CATALANA OCCIDENTE RENTA FIJA CP', 'ES0116889033', 'EUR', 2, '|f_es_BMF|', 78941, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0116889033||es||False', false, '{NULL,F0GBR04FD8,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CATALUNYA FONS', 'ES0116945033', 'EUR', 2, '|f_es_BMF|', 79872, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0116945033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CATERING INTL SCES', 'FR0000064446', 'EUR', 1, '|EURONEXT|', 74887, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000064446||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CATERPILLAR CERT', 'BE0004402377', 'EUR', 1, '|EURONEXT|', 74891, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0004402377||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CATERPILLAR INC', 'US1491231015', 'EUR', 1, '|EURONEXT|', 76553, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#US1491231015||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CATERPILLAR INC.', 'US1491231015', 'USD', 1, '|SP500|', 75278, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CAT||us||False', false, '{CAT,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CATO CORP. CL A', NULL, 'USD', 1, '', 76732, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CATO||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CBIZ INC', NULL, 'USD', 1, '', 79802, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CBZ||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CBL & ASSOCIATES PROPERTIES INC.', NULL, 'USD', 1, '', 76521, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CBL||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CBO TERRITORIA', 'FR0010193979', 'EUR', 1, '|EURONEXT|', 79622, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010193979||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CBOISSAUVWE12(1P1)', 'BE0006462601', 'EUR', 1, '|EURONEXT|', 78347, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0006462601||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CBOISSAUVWE15(1P1)', 'BE0006463617', 'EUR', 1, '|EURONEXT|', 80253, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0006463617||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CBRE GROUP INC. CL A', NULL, 'USD', 1, '|SP500|', 76167, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CBG||us||False', false, '{CBG,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CBS CORP. CL B', NULL, 'USD', 1, '|SP500|', 74843, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CBS||us||False', false, '{CBS,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CCA INTERNATIONAL', 'FR0000078339', 'EUR', 1, '|EURONEXT|', 76561, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000078339||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CCM CONSOLIDACIÓN MÁXIMA FI', 'ES0116983034', 'EUR', 2, '|f_es_BMF|', 74865, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0116983034||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CCM CRECIMIENTO', 'ES0116967037', 'EUR', 2, '|f_es_BMF|', 78758, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0116967037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CCM FONDEPOSITO', 'ES0115942031', 'EUR', 2, '|f_es_BMF|', 78849, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115942031||es||False', false, '{NULL,F0GBR04VY1,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CCM RENTA 5', 'ES0116979008', 'EUR', 2, '|f_es_BMF|', 75887, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0116979008||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CCM RENTA FIJA', 'ES0147611034', 'EUR', 2, '|f_es_BMF|', 78850, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147611034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CCM RENTA GARANTIZADO', 'ES0119733006', 'EUR', 2, '|f_es_BMF|', 75208, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0119733006||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CCM RENTA PROGRESIVO', 'ES0119734004', 'EUR', 2, '|f_es_BMF|', 76422, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0119734004||es||False', false, '{NULL,F00000JZBD,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CCM TRIPLE 10', 'ES0115835003', 'EUR', 2, '|f_es_BMF|', 79877, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115835003||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CDI CORP.', NULL, 'USD', 2, '', 78373, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CDI||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CEC ENTERTAINMENT INC.', NULL, 'USD', 1, '', 79552, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CEC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CEDAR REALTY TRUST INC.', NULL, 'USD', 1, '', 79806, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CDR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CEGEDIM', 'FR0000053506', 'EUR', 1, '|EURONEXT|', 78352, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000053506||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CEGEREAL', 'FR0010309096', 'EUR', 1, '|EURONEXT|', 76563, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010309096||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CEGID GROUP', 'FR0000124703', 'EUR', 1, '|EURONEXT|', 78359, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000124703||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CELADON GROUP INC.', NULL, 'USD', 1, '', 80291, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CGI||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CELANESE CORP. SERIES A', NULL, 'USD', 1, '', 75544, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CE||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CELESIO AG', 'DE000CLS1001', 'EUR', 1, '|DEUTSCHEBOERSE|', 78829, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE000CLS1001||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CELESTICA INC.', NULL, 'USD', 1, '', 77777, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CLS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CELGENE CORPORATION', 'US1510201049', 'USD', 1, '|NASDAQ100|SP500|', 77456, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'CELG||us||False', false, '{CELG,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CELLCOM ISRAEL LTD.', NULL, 'USD', 1, '', 78449, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CEL||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CELLNEX TELECOMM', 'ES0105066007', 'EUR', 1, '|IBEX|MERCADOCONTINUO|', 81722, 'https://www.cellnextelecom.com/', NULL, NULL, NULL, 100, 'c', 1, 1, NULL, false, '{CLNX.MC,NULL,BME:CLNX,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CEMEX S.A.B. DE C.V.', NULL, 'USD', 1, '', 76286, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CX||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CEMIG P.', 'BRCMIGACNPR3', 'EUR', 1, '|LATIBEX|', 78447, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#BRCMIGACNPR3||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CEM.PORT.VAL', 'ES0117390411', 'EUR', 1, '|MERCADOCONTINUO|', 78446, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0117390411||es||False', false, '{CPL.MC,NULL,BME:CPL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CENIT AG', 'DE0005407100', 'EUR', 1, '|DEUTSCHEBOERSE|', 78896, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005407100||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CENOVUS ENERGY INC.', NULL, 'USD', 1, '', 74926, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CVE||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CENTENE CORP.', NULL, 'USD', 1, '', 78690, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CNC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CENTERPOINT ENERGY INC.', NULL, 'USD', 1, '|SP500|', 76280, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CNP||us||False', false, '{CNP,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CENTRAIS ELETRICAS BRASILEIRAS S/A', NULL, 'USD', 1, '', 78553, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#EBR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CENTRAL PACIFIC FINANCIAL CORP.', NULL, 'USD', 1, '', 78064, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CPF||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CENTRAL VERMONT PUBLIC SERVICE CORP.', NULL, 'USD', 1, '', 79726, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CV||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CENTROSOLAR GROUP AG', 'DE0005148506', 'EUR', 1, '|DEUTSCHEBOERSE|', 78897, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005148506||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CENTROTEC SUSTAINABLE AG', 'DE0005407506', 'EUR', 1, '|DEUTSCHEBOERSE|', 78898, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005407506||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CENTROTHERM PHOTOVOLTAICS AG', 'DE000A0JMMN2', 'EUR', 1, '|DEUTSCHEBOERSE|', 78900, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE000A0JMMN2||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CENTURYLINK INC.', NULL, 'USD', 1, '', 76648, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CTL||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CENVEO INC.', NULL, 'USD', 1, '', 80389, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CVO||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CEPHALON INC.', 'US1567081096', 'USD', 1, '|NASDAQ100|', 75353, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'CEPH||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CEPSA', 'ES0132580319', 'EUR', 1, '|MERCADOCONTINUO|', 77112, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0132580319||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CERNER CORPORATION', 'US1567821046', 'USD', 1, '|NASDAQ100|', 77457, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'CERN||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CESAR BSAR', 'FR0010876813', 'EUR', 1, '|EURONEXT|', 76564, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010876813||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CESAR', 'FR0010540997', 'EUR', 1, '|EURONEXT|', 75875, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010540997||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CEWE COLOR HOLDING AG', 'DE0005403901', 'EUR', 1, '|DEUTSCHEBOERSE|', 78901, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005403901||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CF INDUSTRIES HOLDINGS INC.', NULL, 'USD', 1, '', 78177, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CF||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CFAO', 'FR0000060501', 'EUR', 1, '|EURONEXT|', 78366, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000060501||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CFCAL BANQUE', 'FR0000064560', 'EUR', 1, '|EURONEXT|', 78375, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000064560||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CFD FUTURO IBEX35', NULL, 'EUR', 12, '', 81737, NULL, NULL, NULL, NULL, 100, 'p', 6, 1, NULL, false, '{NULL,NULL,NULL,NULL,ES35U9}', true, 2);
INSERT INTO public.products VALUES ('CFE (D)', 'BE0003883031', 'EUR', 1, '|EURONEXT|', 78430, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003883031||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CFI', 'FR0000037475', 'EUR', 1, '|EURONEXT|', 78431, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000037475||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CGG VERITAS', 'FR0000120164', 'EUR', 1, '|EURONEXT|', 78434, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000120164||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CGG VERITAS', NULL, 'USD', 1, '', 75962, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CGV||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CGI GROUP INC. CL A', NULL, 'USD', 1, '', 78779, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GIB||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CH ENERGY GROUP INC. (HOLDING CO.)', NULL, 'USD', 1, '', 79421, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CHG||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('C.H. ROBINSON WORLDWIDE, INC.', 'US12541W2098', 'USD', 1, '|NASDAQ100|SP500|', 77546, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'CHRW||us||False', false, '{CHRW,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CHARGEURS', 'FR0000130692', 'EUR', 1, '|EURONEXT|', 78436, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000130692||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CHARLES RIVER LABORATORIES INTERNATIONAL INC.', NULL, 'USD', 1, '', 79045, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CRL||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CHARLES SCHWAB CORP.', NULL, 'USD', 1, '', 78135, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#SCHW||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CHATHAM LODGING TRUST', NULL, 'USD', 1, '', 80063, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CLDT||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CHAUF.URB.', 'FR0000052896', 'EUR', 1, '|EURONEXT|', 78438, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000052896||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CHAUSSERIA', 'FR0000060907', 'EUR', 1, '|EURONEXT|', 78439, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000060907||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CHECKPOINT SOFTWARE TECHNOLOGIES', 'IL0010824113', 'USD', 1, '|NASDAQ100|', 75830, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'CHKP||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CHECKPOINT SYSTEMS INC.', NULL, 'USD', 1, '', 80940, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CKP||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CHEMED CORP.', NULL, 'USD', 1, '', 79182, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CHE||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CHEMSPEC INTERNATIONAL LTD.', NULL, 'USD', 1, '', 75926, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CPC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CHEMTURA CORP.', NULL, 'USD', 1, '', 78028, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CHMT||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CHESAPEAKE ENERGY CORP.', NULL, 'USD', 1, '', 76899, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CHK||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CHESAPEAKE UTILITIES CORP.', NULL, 'USD', 1, '', 79725, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CPK||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CHEVRON CORP.', NULL, 'USD', 1, '', 78166, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CVX||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CHEVRON', 'US1667641005', 'EUR', 1, '|EURONEXT|', 78441, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#US1667641005||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CHICAGO BRIDGE & IRON CO. N.V.', NULL, 'USD', 1, '', 75586, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CBI||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CHICO''S FAS INC.', NULL, 'USD', 1, '', 77591, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CHS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CHINA CORD BLOOD CORP.', NULL, 'USD', 1, '', 77674, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CO||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CHINA DIGITAL TV HOLDING CO. LTD.', NULL, 'USD', 1, '', 81655, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#STV||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CHINA DISTANCE EDUCATION HOLDINGS LTD.', NULL, 'USD', 1, '', 80599, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DL||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CHINA EASTERN AIRLINES CORP. LTD.', NULL, 'USD', 1, '', 79518, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CEA||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CHINA EDUCATION ALLIANCE INC.', NULL, 'USD', 1, '', 76382, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CEU||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CHINA GREEN AGRICULTURE INC.', NULL, 'USD', 1, '', 80523, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CGA||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CHINA HYDROELECTRIC CORP.', NULL, 'USD', 1, '', 77940, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CHC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CHINA KANGHUI HOLDINGS', NULL, 'USD', 1, '', 79882, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#KH||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CHINA LIFE INSURANCE CO. LTD.', NULL, 'USD', 1, '', 75869, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#LFC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CHINA MASS MEDIA CORP.', NULL, 'USD', 1, '', 81086, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CMM||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CHINA MING YANG WIND POWER GROUP LTD.', NULL, 'USD', 1, '', 80041, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#MY||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CHINA MOBILE LTD.', NULL, 'USD', 1, '', 74823, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CHL||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CHINA NEPSTAR CHAIN DRUGSTORE LTD.', NULL, 'USD', 1, '', 80528, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#NPD||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CHINA NEW BORUN CORP.', NULL, 'USD', 1, '', 77988, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BORN||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CHINA PETROLEUM & CHEMICAL CORP.', NULL, 'USD', 1, '', 78090, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#SNP||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CHINA SECURITY & SURVEILLANCE TECHNOLOGY INC.', NULL, 'USD', 1, '', 75593, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CSR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CHINA SOUTHERN AIRLINES CO. LTD.', NULL, 'USD', 1, '', 78244, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ZNH||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CHINA SPECIALTY GLASS AG', 'DE000A1EL8Y8', 'EUR', 1, '|DEUTSCHEBOERSE|', 78902, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE000A1EL8Y8||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CHINA TELECOM CORP. LTD.', NULL, 'USD', 1, '', 76036, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CHA||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CHINA UNICOM (HONG KONG) LTD.', NULL, 'USD', 1, '', 76748, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CHU||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CHINA XINIYA FASHION LTD.', NULL, 'USD', 1, '', 81060, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#XNY||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CHINA YUCHAI INTERNATIONAL LTD.', NULL, 'USD', 1, '', 79921, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CYD||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CHINA ZENIX AUTO INTERNATIONAL LTD.', NULL, 'USD', 1, '', 81028, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ZX||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CHIPOTLE MEXICAN GRILL INC.', NULL, 'USD', 1, '', 78230, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CMG||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CHIQUITA BRANDS INTERNATIONAL INC.', NULL, 'USD', 1, '', 77224, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CQB||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CHOICE HOTELS INTERNATIONAL INC.', NULL, 'USD', 1, '', 77167, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CHH||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CHRISTIAN DIOR', 'FR0000130403', 'EUR', 1, '|EURONEXT|', 78527, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000130403||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CHRISTOPHER & BANKS CORP.', NULL, 'USD', 1, '', 81025, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CBK||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CHUBB CORP.', NULL, 'USD', 1, '', 75974, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CB||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CHUNGHWA TELECOM CO. LTD.', NULL, 'USD', 1, '', 77109, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CHT||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CHURCH & DWIGHT CO.', NULL, 'USD', 1, '', 75576, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CHD||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CIBER INC.', NULL, 'USD', 1, '', 79803, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CBR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CIBOX INTER A CTIV', 'FR0000054322', 'EUR', 1, '|EURONEXT|', 78584, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000054322||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CIC', 'FR0005025004', 'EUR', 1, '|EURONEXT|', 78586, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0005025004||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CIE AUTOMOTIVE S.A.', 'ES0105630315', 'EUR', 1, '|IBEX|MERCADOCONTINUO|', 78451, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0105630315||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CIE BOIS SAUVAGE', 'BE0003592038', 'EUR', 1, '|EURONEXT|', 78599, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003592038||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CIE B.SAUVAG.STRIP', 'BE0005576476', 'EUR', 1, '|EURONEXT|', 78588, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0005576476||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CIE MAROCAINE', 'FR0000030611', 'EUR', 1, '|EURONEXT|', 78600, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000030611||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CIGNA CORP.', NULL, 'USD', 1, '', 74874, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CI||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CIMAREX ENERGY CO.', NULL, 'USD', 1, '', 77031, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#XEC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CIMENTS FRANCAIS', 'FR0000120982', 'EUR', 1, '|EURONEXT|', 77342, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000120982||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CIMESCAUT', 'BE0003304061', 'EUR', 1, '|EURONEXT|', 78602, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003304061||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CIMPOR,SGPS', 'PTCPR0AM0003', 'EUR', 1, '|EURONEXT|', 79372, NULL, NULL, NULL, NULL, 100, 'c', 1, 9, 'EURONEXT#PTCPR0AM0003||pt||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CINCINNATI BELL INC.', NULL, 'USD', 1, '', 79551, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CBB||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CINEMARK HOLDINGS INC.', NULL, 'USD', 1, '', 77655, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CNK||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CINTAS CORPORATION', 'US1729081059', 'USD', 1, '|NASDAQ100|', 75746, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'CTAS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CINTRA', NULL, 'EUR', 1, '', 75202, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'CIN.MC||None||False', true, '{CIN.MC,NULL,BME:CIN,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CISCO SYSTEM INC', 'US17275R1023', 'EUR', 1, '|EURONEXT|', 76742, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#US17275R1023||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CISCO SYSTEMS, INC.', 'US17275R1023', 'USD', 1, '|NASDAQ100|', 76169, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'CSCO||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CITIFONDO AGIL', 'ES0113722039', 'EUR', 2, '|f_es_BMF|', 76424, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113722039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CITIFONDO BOND', 'ES0113723037', 'EUR', 2, '|f_es_BMF|', 76425, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113723037||es||False', false, '{NULL,F0GBR04IX2,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CITIFONDO PREMIUM', 'ES0118912031', 'EUR', 2, '|f_es_BMF|', 78914, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0118912031||es||False', false, '{NULL,F0GBR04IX6,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CITIFONDO RENTA VARIABLE', 'ES0118927039', 'EUR', 2, '|f_es_BMF|', 78937, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0118927039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CITIGROUP INC.', NULL, 'USD', 1, '', 78723, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#C||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CITRIX SYSTEMS, INC', 'US1773761002', 'USD', 1, '|NASDAQ100|', 75739, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'CTXS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CITY NATIONAL CORP.', NULL, 'USD', 1, '', 77877, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CYN||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('C&J ENERGY SERVICES INC.', NULL, 'USD', 1, '', 80360, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CJES||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CLARCOR INC.', NULL, 'USD', 1, '', 77403, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CLC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CLASS CAJA MADRID 30 EURO', 'ES0113727004', 'EUR', 2, '|f_es_BMF|', 79878, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113727004||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CLASS CAJA MADRID BONOS', 'ES0118914003', 'EUR', 2, '|f_es_BMF|', 79880, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0118914003||es||False', false, '{NULL,F000000H6P,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CLASS CAJA MADRID PLATINIUM', 'ES0118841008', 'EUR', 2, '|f_es_BMF|', 79881, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0118841008||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CLEAN HARBORS INC.', NULL, 'USD', 1, '', 77302, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CLH||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CLEAR CHANNEL OUTDOOR HOLDINGS INC.', NULL, 'USD', 1, '', 79640, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CCO||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CLEARWATER PAPER CORP.', NULL, 'USD', 1, '', 78411, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CLW||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CLECO CORP.', NULL, 'USD', 1, '', 78681, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CNL||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CLIFFS NATURAL RESOURCES INC.', NULL, 'USD', 1, '', 77901, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CLF||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CLIFFS', 'US18683K1016', 'EUR', 1, '|EURONEXT|', 80256, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#US18683K1016||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CLÍNICA BAVIERA', 'ES0119037010', 'EUR', 1, '|MERCADOCONTINUO|', 81448, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0119037010||es||False', false, '{CBAV.MC,NULL,BME:CBAV,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CLOROX CO.', NULL, 'USD', 1, '', 75377, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CLX||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CLOUD PEAK ENERGY INC.', NULL, 'USD', 1, '', 79189, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CLD||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CLUB MEDITERRANEE', 'FR0000121568', 'EUR', 1, '|EURONEXT|', 80215, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000121568||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CMB', 'BE0003817344', 'EUR', 1, '|EURONEXT|', 78679, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003817344||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CMB CARTERA EURO', 'ES0119172007', 'EUR', 2, '|f_es_BMF|', 79903, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0119172007||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CMS ENERGY CORP.', NULL, 'USD', 1, '', 77082, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CMS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CNA FINANCIAL CORP.', NULL, 'USD', 1, '', 79434, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CNA||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CNA SURETY CORP.', NULL, 'USD', 1, '', 75837, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#SUR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CNH GLOBAL N.V.', NULL, 'USD', 1, '', 77177, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CNH||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CNIM CONSTR.FRF 10', 'FR0000053399', 'EUR', 1, '|EURONEXT|', 78282, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000053399||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CNO FINANCIAL GROUP INC.', NULL, 'USD', 1, '', 76778, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CNO||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CNOOC LTD.', NULL, 'USD', 1, '', 78487, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CEO||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CNP ASSURANCES', 'FR0000120222', 'EUR', 1, '|EURONEXT|', 80261, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000120222||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COACH INC.', NULL, 'USD', 1, '', 78222, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#COH||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COCA-COLA CO.', 'US1912161007', 'USD', 1, '|SP500|', 78717, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#KO||us||False', false, '{KO,NULL,NYSE:KO,NULL,KO}', false, 2);
INSERT INTO public.products VALUES ('COCA-COLA ENTER', 'US19122T1097', 'EUR', 1, '|EURONEXT|', 80263, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#US19122T1097||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COCA-COLA ENTERPRISES INC.', NULL, 'USD', 1, '', 79174, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CCE||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COCA-COLA FEMSA S.A.B. DE C.V.', NULL, 'USD', 1, '', 78929, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#KOF||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COCA-COLA HELLENIC BOTTLING CO. S.A.', NULL, 'USD', 1, '', 76151, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CCH||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CODERE', 'ES0119256115', 'EUR', 1, '|MERCADOCONTINUO|', 78455, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0119256115||es||False', false, '{CDR.MC,NULL,BME:CDR,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COEUR D''ALENE MINES CORP.', NULL, 'USD', 1, '', 76474, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CDE||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COFIDUR', 'FR0000054629', 'EUR', 1, '|EURONEXT|', 78234, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000054629||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COFIGEO', 'FR0000035008', 'EUR', 1, '|EURONEXT|', 77070, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000035008||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COFIGEO', 'FR0011037589', 'EUR', 1, '|EURONEXT|', 76025, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0011037589||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COFINA,SGPS', 'PTCFN0AE0003', 'EUR', 1, '|EURONEXT|', 80298, NULL, NULL, NULL, NULL, 100, 'c', 1, 9, 'EURONEXT#PTCFN0AE0003||pt||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COFINIMMO PRIV1', 'BE0003811289', 'EUR', 1, '|EURONEXT|', 78686, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003811289||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COFINIMMO PRIV2', 'BE0003813301', 'EUR', 1, '|EURONEXT|', 78688, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003813301||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COFINIMMO-SICAFI', 'BE0003593044', 'EUR', 1, '|EURONEXT|', 80387, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003593044||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COFITEM-COFIMUR', 'FR0000034431', 'EUR', 1, '|EURONEXT|', 80300, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000034431||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COGDELL SPENCER INC.', NULL, 'USD', 1, '', 80964, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CSA||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COGNIZANT TECHNOLOGY SOLUTIONS', 'US1924461023', 'USD', 1, '|NASDAQ100|', 77535, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'CTSH||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COHEN & STEERS INC.', NULL, 'USD', 1, '', 79440, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CNS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COHERIS', 'FR0004031763', 'EUR', 1, '|EURONEXT|', 78691, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0004031763||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COLAS', 'FR0000121634', 'EUR', 1, '|EURONEXT|', 80305, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000121634||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COLEXON ENERGY AG', 'DE0005250708', 'EUR', 1, '|DEUTSCHEBOERSE|', 75541, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005250708||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COLFAX CORP.', NULL, 'USD', 1, '', 79158, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CFX||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COLGATE-PALMOLIVE CO.', NULL, 'USD', 1, '', 74757, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CL||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COLLECTIVE BRANDS INC.', NULL, 'USD', 1, '', 79346, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#PSS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COLONIA REAL ESTATE AG ', 'DE0006338007', 'EUR', 1, '|DEUTSCHEBOERSE|', 74845, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0006338007||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COLONIAL PROPERTIES TRUST', NULL, 'USD', 1, '', 77411, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CLP||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COLONY FINANCIAL INC.', NULL, 'USD', 1, '', 77620, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CLNY||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COLRUYT (D)', 'BE0974256852', 'EUR', 1, '|EURONEXT|', 79063, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0974256852||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COLRUYT STRIP (D)', 'BE0005637112', 'EUR', 1, '|EURONEXT|', 80356, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0005637112||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COMARCH SOFTWARE UND BERATUNG AG', 'DE0007249104', 'EUR', 1, '|DEUTSCHEBOERSE|', 75097, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0007249104||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COMCAST CORPORATION', 'US20030N1019', 'USD', 1, '|NASDAQ100|', 77544, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'CMCSK||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COMDIRECT BANK AG', 'DE0005428007', 'EUR', 1, '|DEUTSCHEBOERSE|', 78905, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005428007||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COMERICA INC.', NULL, 'USD', 1, '', 76311, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CMA||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COMFORT SYSTEMS USA INC.', NULL, 'USD', 1, '', 78255, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FIX||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COMMERCIAL METALS CO.', NULL, 'USD', 1, '', 77879, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CMC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COMMERZ BANK', 'DE0008032004', 'EUR', 1, '|DAX|DEUTSCHEBOERSE|', 75041, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'CBK.DE||None||False', false, '{CBK.DE,NULL,ETR:CBK,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COMMONWEALTH REIT', NULL, 'USD', 1, '', 79078, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CWH||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COMMUNITY BANK SYSTEM INC.', NULL, 'USD', 1, '', 79325, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CBU||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COMMUNITY HEALTH SYSTEMS INC.', NULL, 'USD', 1, '', 78874, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CYH||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COMPANHIA DE SANEAMENTO BASICO DO ESTADO DE SAO PAUL', NULL, 'USD', 1, '', 78496, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#SBS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COMPANHIA PARANAENSE DE ENERGIA-COPEL', NULL, 'USD', 1, '', 75451, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ELP||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COMPANHIA SIDERURGICA NACIONAL', NULL, 'USD', 1, '', 75573, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#SID||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COMPANIA CERVECERIAS UNIDAS S.A.', NULL, 'USD', 1, '', 77933, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CCU||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COMPANIA DE MINAS BUENAVENTURA S.A.', NULL, 'USD', 1, '', 77067, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BVN||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COMPAÑÍA LEVANTINA. EDIFICACIÓN DE OBRAS PÚBLICAS. CLEOP', 'ES0158300410', 'EUR', 1, '|MERCADOCONTINUO|', 80846, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0158300410||es||False', false, '{CLEO.MC,NULL,BME:CLEO,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COMPASS DIVERSIFIED HOLDINGS', NULL, 'USD', 1, '', 77956, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CODI||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COMPASS MINERALS INTERNATIONAL INC.', NULL, 'USD', 1, '', 77437, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CMP||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COMPLETE PRODUCTION SERVICES INC.', NULL, 'USD', 1, '', 77392, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CPX||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COMPOSITUM GESTION', 'ES0121082038', 'EUR', 2, '|f_es_BMF|', 79904, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0121082038||es||False', false, '{NULL,F0GBR04IZK,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COMPROMISO FONDO ETICO', 'ES0121091039', 'EUR', 2, '|f_es_BMF|', 77214, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0121091039||es||False', false, '{NULL,F0GBR06UBE,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COMPTA', 'PTCOM0AE0007', 'EUR', 1, '|EURONEXT|', 78763, NULL, NULL, NULL, NULL, 100, 'c', 1, 9, 'EURONEXT#PTCOM0AE0007||pt||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COMPUGROUP MEDICAL AG', 'DE0005437305', 'EUR', 1, '|DEUTSCHEBOERSE|', 78971, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005437305||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COMPUTER SCIENCES CORP.', NULL, 'USD', 1, '', 78321, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CSC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COMSTOCK RESOURCES INC.', NULL, 'USD', 1, '', 77987, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CRK||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CONAGRA FOODS INC.', NULL, 'USD', 1, '', 76966, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CAG||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CONCHO RESOURCES INC.', NULL, 'USD', 1, '', 75921, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CXO||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CONCORD MEDICAL SERVICES HOLDINGS LTD.', NULL, 'USD', 1, '', 81023, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CCM||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CONERGY AG', 'DE0006040025', 'EUR', 1, '|DEUTSCHEBOERSE|', 75313, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0006040025||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CONERGY AG', 'DE000A1KRCK4', 'EUR', 1, '|DEUTSCHEBOERSE|', 78972, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE000A1KRCK4||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CONNECT GROUP', 'BE0003786036', 'EUR', 1, '|EURONEXT|', 78772, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003786036||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CONOCOPHILLIPS', NULL, 'USD', 1, '', 78167, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#COP||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CONSOL ENERGY INC.', NULL, 'USD', 1, '', 78647, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CNX||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CONSOLIDATED EDISON INC.', NULL, 'USD', 1, '', 75339, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ED||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CONSOLIDATED GRAPHICS INC.', NULL, 'USD', 1, '', 78248, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CGX||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CONSTANTFONS', 'ES0121776035', 'EUR', 2, '|f_es_BMF|', 77217, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0121776035||es||False', false, '{NULL,F0GBR04DNI,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CONSTANTIN MEDIEN AG', 'DE0009147207', 'EUR', 1, '|DEUTSCHEBOERSE|', 78991, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0009147207||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CONSTELLATION BRANDS INC. CL A', NULL, 'USD', 1, '', 75592, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#STZ||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CONSTELLATION ENERGY GROUP INC.', NULL, 'USD', 1, '', 76290, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CEG||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CONSULNOR AHORRO', 'ES0123541007', 'EUR', 2, '|f_es_BMF|', 78940, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0123541007||es||False', false, '{NULL,F000000KQ6,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CONSULNOR CONSERVADOR', 'ES0123546006', 'EUR', 2, '|f_es_BMF|', 78943, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0123546006||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CONSULNOR CRECIMIENTO', 'ES0123549000', 'EUR', 2, '|f_es_BMF|', 78944, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0123549000||es||False', false, '{NULL,F000000KS9,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CONSULNOR MULTIGESTION ALTENATIVA', 'ES0123550008', 'EUR', 2, '|f_es_BMF|', 74940, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0123550008||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CONSULNOR RENTA FIJA DOS AÑOS', 'ES0123547004', 'EUR', 2, '|f_es_BMF|', 77218, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0123547004||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CONSULNOR RENTA VARIABLE', 'ES0123562003', 'EUR', 2, '|f_es_BMF|', 79905, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0123562003||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CONSULNOR SELECCIÓN FI', 'ES0123563001', 'EUR', 2, '|f_es_BMF|', 74941, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0123563001||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CONSULNOR TESORERIA', 'ES0123615033', 'EUR', 2, '|f_es_BMF|', 79906, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0123615033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CONTINENTAL AG', 'DE0005439004', 'EUR', 1, '|DEUTSCHEBOERSE|', 79081, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005439004||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CONTINENTAL RESOURCES INC.', NULL, 'USD', 1, '', 75833, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CLR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CONTINUCARE CORP.', NULL, 'USD', 1, '', 78781, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CNU||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CONVERGYS CORP.', NULL, 'USD', 1, '', 77911, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CVG||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CONVERSUS CAP', 'GG00B1WR8K11', 'EUR', 1, '|EURONEXT|', 78776, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#GG00B1WR8K11||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CON-WAY INC.', NULL, 'USD', 1, '', 78526, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CNW||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COOPER COS.', NULL, 'USD', 1, '', 76245, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#COO||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COOPER INDUSTRIES PLC CL A', NULL, 'USD', 1, '', 77818, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CBE||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COOPER TIRE & RUBBER CO.', NULL, 'USD', 1, '', 79385, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CTB||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COPA HOLDINGS S.A. CL A', NULL, 'USD', 1, '', 76719, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CPA||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COPEL PR.B', 'BRCPLEACNPB9', 'EUR', 1, '|LATIBEX|', 78457, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#BRCPLEACNPB9||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COPERNICO IICIICIL', 'ES0112481009', 'EUR', 2, '|f_es_BMF|', 74942, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0112481009||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CORE LABORATORIES N.V.', NULL, 'USD', 1, '', 78313, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CLB||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CORELOGIC INC.', NULL, 'USD', 1, '', 75569, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CLGX||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CORESITE REALTY CORP.', NULL, 'USD', 1, '', 77233, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#COR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COR&FJA AG', 'DE0005130108', 'EUR', 1, '|DEUTSCHEBOERSE|', 79041, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005130108||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CORIO', 'NL0000288967', 'EUR', 1, '|EURONEXT|', 78798, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0000288967||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CORN PRODUCTS INTERNATIONAL INC.', NULL, 'USD', 1, '', 75961, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CPO||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CORNING INC.', NULL, 'USD', 1, '', 77291, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GLW||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CORP. ALBA', 'ES0117160111', 'EUR', 1, '|MERCADOCONTINUO|', 78461, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0117160111||es||False', false, '{ALB.MC,NULL,BME:ALB,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CORP. DERMO.', 'ES0124204019', 'EUR', 1, '|MERCADOCONTINUO|', 78471, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0124204019||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CORPBANCA S.A.', NULL, 'USD', 1, '', 75470, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BCA||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CORPORATE EQUITY PARTNERS AG', 'CH0108753523', 'EUR', 1, '|DEUTSCHEBOERSE|', 79047, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#CH0108753523||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CORPORATE EXECUTIVE BOARD CO.', NULL, 'USD', 1, '', 81610, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#EXBD||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CORPORATE OFFICE PROPERTIES TRUST', NULL, 'USD', 1, '', 77775, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#OFC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CORRECTIONS CORP. OF AMERICA', NULL, 'USD', 1, '', 77508, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CXW||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CORTICEIRA AMORIM', 'PTCOR0AE0006', 'EUR', 1, '|EURONEXT|', 76267, NULL, NULL, NULL, NULL, 100, 'c', 1, 9, 'EURONEXT#PTCOR0AE0006||pt||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COSAN  CL A', NULL, 'USD', 1, '', 78871, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CZZ||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COSTAMARE INC.', NULL, 'USD', 1, '', 80042, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CMRE||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COSTCO WHOLESALE CORPORATION', 'US22160K1051', 'USD', 1, '|NASDAQ100|', 75891, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'COST||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COTT CORP.', NULL, 'USD', 1, '', 79126, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#COT||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COTTIN FRERES', 'FR0000071854', 'EUR', 1, '|EURONEXT|', 80388, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000071854||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COUNTRY STYLE COOKING RESTAURANT CHAIN CO. LTD.', NULL, 'USD', 1, '', 80167, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CCSC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COURTOIS', 'FR0000065393', 'EUR', 1, '|EURONEXT|', 79544, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000065393||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COVANCE INC.', NULL, 'USD', 1, '', 78928, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CVD||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COVANTA HOLDING CORP.', NULL, 'USD', 1, '', 80890, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CVA||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COVENTRY HEALTH CARE INC.', NULL, 'USD', 1, '', 76174, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CVH||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('COVIDIEN PLC', NULL, 'USD', 1, '', 78170, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#COV||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CPFL ENERGIA S.A.', NULL, 'USD', 1, '', 79342, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CPL||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CPI CORP.', NULL, 'USD', 1, '', 78065, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CPY||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('C-QUADRAT INVESTMENT AG', 'AT0000613005', 'EUR', 1, '|DEUTSCHEBOERSE|', 79048, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#AT0000613005||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('C.R. BARD INC.', 'US0673831097', 'USD', 1, '|SP500|', 76990, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BCR||us||False', false, '{BCR,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CRANE CO.', NULL, 'USD', 1, '', 76454, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CRCAM ALP.PROV.CCI', 'FR0000044323', 'EUR', 1, '|EURONEXT|', 75598, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000044323||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CRCAM ATL.VEND.CCI', 'FR0000185506', 'EUR', 1, '|EURONEXT|', 79056, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000185506||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CRCAM BRIE PIC2CCI', 'FR0010483768', 'EUR', 1, '|EURONEXT|', 75601, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010483768||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CRCAM ILLE-VIL.CCI', 'FR0000045213', 'EUR', 1, '|EURONEXT|', 79939, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000045213||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CRCAM LANGUED CCI', 'FR0010461053', 'EUR', 1, '|EURONEXT|', 75987, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010461053||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CRCAM LOIRE HTE L.', 'FR0000045239', 'EUR', 1, '|EURONEXT|', 75016, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000045239||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CRCAM MORBIHAN CCI', 'FR0000045551', 'EUR', 1, '|EURONEXT|', 78836, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000045551||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CRCAM NORD CCI', 'FR0000185514', 'EUR', 1, '|EURONEXT|', 78839, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000185514||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CRCAM NORM.SEINE', 'FR0000044364', 'EUR', 1, '|EURONEXT|', 78812, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000044364||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CRCAM PARIS ET IDF', 'FR0000045528', 'EUR', 1, '|EURONEXT|', 78814, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000045528||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CRCAM SUD R.A.CCI', 'FR0000045346', 'EUR', 1, '|EURONEXT|', 80368, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000045346||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CRCAM TOURAINE CCI', 'FR0000045304', 'EUR', 1, '|EURONEXT|', 75989, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000045304||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CREACION DE CULTURA EN ESPAÑOL', 'ES0124512031', 'EUR', 2, '|f_es_BMF|', 79907, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0124512031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CREDICORP LTD.', NULL, 'USD', 1, '', 77081, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BAP||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CREDIT AGRICOLE', 'FR0000045072', 'EUR', 1, '|CAC|EURONEXT|', 76268, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000045072||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CREDIT AGRICOLE MERCADINERO', 'ES0124575038', 'EUR', 2, '|f_es_BMF|', 78960, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0124575038||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CREDIT AGRICOLE MERCAEUROPA SMALL CAP', 'ES0123743033', 'EUR', 2, '|f_es_BMF|', 75168, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0123743033||es||False', false, '{NULL,F0GBR06014,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CREDIT AGRICOLE MERCAPATRIMONI', 'ES0162230033', 'EUR', 2, '|f_es_BMF|', 79924, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0162230033||es||False', false, '{NULL,F0GBR04IXW,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CREDIT AGRICOLE MERCASELECCION', 'ES0162231031', 'EUR', 2, '|f_es_BMF|', 79930, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0162231031||es||False', false, '{NULL,F0GBR0557D,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CREDIT AGRICOLE MERCASELECCION PLUS', 'ES0115254031', 'EUR', 2, '|f_es_BMF|', 79938, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115254031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CREDIT AGRICOLE MERCATRADING', 'ES0162232005', 'EUR', 2, '|f_es_BMF|', 76227, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0162232005||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CREDIT SUISSE BOLSA', 'ES0113286035', 'EUR', 2, '|f_es_BMF|', 79942, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113286035||es||False', false, '{NULL,F0GBR04IY2,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CREDIT SUISSE EQUITY YIELD', 'ES0113288031', 'EUR', 2, '|f_es_BMF|', 79973, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113288031||es||False', false, '{NULL,F0GBR05KOR,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CREDIT SUISSE GOVER.EURO LIQUIDI', 'ES0124573033', 'EUR', 2, '|f_es_BMF|', 79965, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0124573033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CREDIT SUISSE GROUP', NULL, 'USD', 1, '', 74923, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CREDIT SUISSE INFRAESTRUCTURAS', 'ES0175449034', 'EUR', 2, '|f_es_BMF|', 79974, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0175449034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CREDIT SUISSE MONETARIO', 'ES0155598032', 'EUR', 2, '|f_es_BMF|', 79977, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0155598032||es||False', false, '{NULL,F0GBR04J6E,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CREDIT SUISSE RENTA FIJA 0-5', 'ES0124880032', 'EUR', 2, '|f_es_BMF|', 79978, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0124880032||es||False', false, '{NULL,F0GBR04IXY,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CREVAL CAPITAL', 'ES0124721038', 'EUR', 2, '|f_es_BMF|', 77647, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0124721038||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CREXUS INVESTMENT CORP.', NULL, 'USD', 1, '', 78341, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CXS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CRH PLC', 'IE0001827041', 'EUR', 1, '|EUROSTOXX|', 81085, NULL, NULL, NULL, NULL, 100, 'c', 1, 13, 'CRG.IR||ie||False', false, '{CRG.IR,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CRH PLC', NULL, 'USD', 1, '', 79674, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CRH||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CROPENERGIES AG', 'DE000A0LAUP1', 'EUR', 1, '|DEUTSCHEBOERSE|', 79082, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE000A0LAUP1||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CROSSWOOD', 'FR0000050395', 'EUR', 1, '|EURONEXT|', 79057, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000050395||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CROWN CASTLE INTERNATIONAL CORP.', NULL, 'USD', 1, '', 75197, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CCI||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CROWN HOLDINGS INC.', NULL, 'USD', 1, '', 79178, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CCK||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CROWN VAN GELDER', 'NL0000345452', 'EUR', 1, '|EURONEXT|', 76325, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0000345452||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CRUDE CARRIERS CORP.', NULL, 'USD', 1, '', 77338, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CRU||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CRV FONDBOLSA', 'ES0125162034', 'EUR', 2, '|f_es_BMF|', 79979, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0125162034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CRV FONRENTA', 'ES0125161036', 'EUR', 2, '|f_es_BMF|', 79983, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0125161036||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CRYO SAVE GROUP', 'NL0009272137', 'EUR', 1, '|EURONEXT|', 76269, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0009272137||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CRYOLIFE INC.', NULL, 'USD', 1, '', 81008, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CRY||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CS (COMM.SYSTEMES)', 'FR0007317813', 'EUR', 1, '|EURONEXT|', 78825, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0007317813||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CS DIRECTOR BALANCED', 'ES0125102030', 'EUR', 2, '|f_es_BMF|', 79986, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0125102030||es||False', false, '{NULL,F0GBR05WO7,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CS DIRECTOR BOND FOCUS', 'ES0165121031', 'EUR', 2, '|f_es_BMF|', 79989, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0165121031||es||False', false, '{NULL,F0GBR04IZE,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CS DIRECTOR GROWTH', 'ES0143673038', 'EUR', 2, '|f_es_BMF|', 79993, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0143673038||es||False', false, '{NULL,F0GBR04IZ4,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CS DIRECTOR INCOME', 'ES0125126039', 'EUR', 2, '|f_es_BMF|', 79994, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0125126039||es||False', false, '{NULL,F0GBR04LEW,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CS DURACION FLEXIBLE', 'ES0126547035', 'EUR', 2, '|f_es_BMF|', 78976, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0126547035||es||False', false, '{NULL,F0GBR04IZ6,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CS ESTRATEGIA GLOBAL', 'ES0127021030', 'EUR', 2, '|f_es_BMF|', 76570, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0127021030||es||False', false, '{NULL,F0GBR04IZO,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CS EUROPEAN SELECT DIVIDEND', 'ES0143674036', 'EUR', 2, '|f_es_BMF|', 78041, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0143674036||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CS GLOBAL FONDOS 0-30, FI', 'ES0184716035', 'EUR', 2, '|f_es_BMF|', 76574, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0184716035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CS GLOBAL LINK', 'ES0142537036', 'EUR', 2, '|f_es_BMF|', 76575, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0142537036||es||False', false, '{NULL,F0GBR04J6I,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CS RENTA VARIABLE INTER, CLASE B', 'ES0142538000', 'EUR', 2, '|f_es_BMF|', 79996, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0142538000||None||False', false, '{NULL,F00000MEVI,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CS RENTA VARIABLE INTERNACIONAL', 'ES0142538034', 'EUR', 2, '|f_es_BMF|', 78851, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0142538034||es||False', false, '{NULL,F0GBR04J6C,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CSCOM BS11A', 'FR0010325019', 'EUR', 1, '|EURONEXT|', 79175, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010325019||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CSCOM BS13B', 'FR0010325035', 'EUR', 1, '|EURONEXT|', 79064, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010325035||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CS.GLOBAL FONDOS GESTION ACTIVA', 'ES0132214034', 'EUR', 2, '|f_es_BMF|', 75439, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0132214034||es||False', false, '{NULL,F0GBR0601E,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CSM', 'NL0000852549', 'EUR', 1, '|EURONEXT|', 75182, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0000852549||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CSS INDUSTRIES INC.', NULL, 'USD', 1, '', 81653, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CSS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CSX CORP.', NULL, 'USD', 1, '', 78771, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CSX||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CTAC', 'NL0000345577', 'EUR', 1, '|EURONEXT|', 80344, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0000345577||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CTS CORP.', NULL, 'USD', 1, '', 77279, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CTS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CTS EVENTIM AG', 'DE0005470306', 'EUR', 1, '|DEUTSCHEBOERSE|', 79083, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005470306||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CUENTA FISCAL ORO', 'ES0114869037', 'EUR', 2, '|f_es_BMF|', 75458, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114869037||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CUENTA FISCAL ORO I', 'ES0114862032', 'EUR', 2, '|f_es_BMF|', 76576, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114862032||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CULLEN/FROST BANKERS INC.', NULL, 'USD', 1, '', 76262, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CFR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CULP INC.', NULL, 'USD', 1, '', 78256, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CFI||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CUMMINS INC.', NULL, 'USD', 1, '', 77353, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CMI||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CURANUM AG', 'DE0005240709', 'EUR', 1, '|DEUTSCHEBOERSE|', 79085, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005240709||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CURTISS-WRIGHT CORP.', NULL, 'USD', 1, '', 79050, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CW||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('C.V.N.E. COMPAÑÍA VINÍCULA DEL NORTE DE ESPAÑA', 'ES0184140210', 'EUR', 1, '|MERCADOCONTINUO|', 81428, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0184140210||es||False', false, '{CUN.MC,NULL,BME:CUN,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CVR ENERGY INC.', NULL, 'USD', 1, '', 78725, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CVI||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CVS CAREMARK CORP.', NULL, 'USD', 1, '', 77040, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CVS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CX CAT. EURIBOR + 0,50', 'ES0164373005', 'EUR', 2, '|f_es_BMF|', 78977, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0164373005||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CX CAT. FONDIPOSIT', 'ES0118558008', 'EUR', 2, '|f_es_BMF|', 78954, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0118558008||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CX CAT. GARANTIT 3', 'ES0114933007', 'EUR', 2, '|f_es_BMF|', 79229, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114933007||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CX CAT.PATRI.DINAMIC', 'ES0115007033', 'EUR', 2, '|f_es_BMF|', 75949, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115007033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CYBERDECK', 'FR0004154151', 'EUR', 1, '|EURONEXT|', 77723, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0004154151||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CYBERGUN DS', 'FR0011063544', 'EUR', 1, '|EURONEXT|', 75600, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0011063544||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CYBERGUN', 'FR0004031839', 'EUR', 1, '|EURONEXT|', 75188, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0004031839||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CYBERNETIX', 'FR0000036162', 'EUR', 1, '|EURONEXT|', 80342, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000036162||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CYBERNETIX', 'FR0011156306', 'EUR', 1, '|EURONEXT|', 74999, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0011156306||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CYS INVESTMENTS INC.', NULL, 'USD', 1, '', 76584, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CYS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('CYTEC INDUSTRIES INC.', NULL, 'USD', 1, '', 77860, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CYT||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DAB BANK AG', 'DE0005072300', 'EUR', 1, '|DEUTSCHEBOERSE|', 79138, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005072300||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DAEDALUS CONSERVADOR', 'ES0126048000', 'EUR', 2, '|f_es_BMF|', 76889, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0126048000||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DAEDALUS CRECIMIENTO', 'ES0125422008', 'EUR', 2, '|f_es_BMF|', 78955, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0125422008||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DAEDALUS MODERADO', 'ES0123033005', 'EUR', 2, '|f_es_BMF|', 75459, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0123033005||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DAEDALUS OPORTUNIDAD', 'ES0125321002', 'EUR', 2, '|f_es_BMF|', 78956, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0125321002||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DAEDALUS VARIABLE', 'ES0125302002', 'EUR', 2, '|f_es_BMF|', 77087, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0125302002||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DAIMLER AG', 'DE0007100000', 'EUR', 1, '|DAX|DEUTSCHEBOERSE|EUROSTOXX|', 79204, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0007100000||de||False', false, '{DAI.DE,NULL,ETR:DAI,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DALET', 'FR0011026749', 'EUR', 1, '|EURONEXT|', 75964, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0011026749||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DALMATIAN', 'ES0125651036', 'EUR', 2, '|f_es_BMF|', 78957, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0125651036||es||False', false, '{NULL,F0GBR04Y4K,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DAMARTEX', 'FR0000185423', 'EUR', 1, '|EURONEXT|', 77896, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000185423||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DANAHER CORP.', NULL, 'USD', 1, '', 78085, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DHR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DANE ELEC MEMORY', 'FR0000036774', 'EUR', 1, '|EURONEXT|', 79623, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000036774||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DANEELECBSAR13', 'FR0010329292', 'EUR', 1, '|EURONEXT|', 76941, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010329292||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DANONE', 'FR0000120644', 'EUR', 1, '|CAC|EURONEXT|EUROSTOXX|', 79374, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000120644||fr||False', false, '{BN.PA,NULL,EPA:BN,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DAQO NEW ENERGY CORP.', NULL, 'USD', 1, '', 77941, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DQ||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DARDEN RESTAURANTS INC.', NULL, 'USD', 1, '', 77078, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DRI||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DASSAULT AVIATION', 'FR0000121725', 'EUR', 1, '|EURONEXT|', 80178, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000121725||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DASSAULT SYST NV', 'FR0010986935', 'EUR', 1, '|EURONEXT|', 74962, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010986935||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DASSAULT SYSTEMES', 'FR0000130650', 'EUR', 1, '|EURONEXT|', 79375, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000130650||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DATA MODUL AG', 'DE0005498901', 'EUR', 1, '|DEUTSCHEBOERSE|', 79291, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005498901||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DAVITA INC.', NULL, 'USD', 1, '', 79833, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DVA||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DAX XETRA', 'DE0008469008', 'EUR', 3, '', 78094, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, '^GDAXI||de||False', false, '{^GDAXI,NULL,INDEXDB:DAX,NULL,DE30}', false, 2);
INSERT INTO public.products VALUES ('DB X-TRACKERS DAX UCITS ETF', 'LU0274211480', 'EUR', 4, '', 78524, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#LU0274211480||es||False', false, '{DXDAX.MC,NULL,BME:DXDAX,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DB X-TRACKERS FTSE 100 ETF | FTSE 100, INDEX', 'LU0292097234', 'EUR', 4, '|e_de_DBXTRACKERS|', 81687, 'http://www.etf.db.com/', NULL, NULL, NULL, 100, 'c', 1, 5, NULL, false, '{DBXX.DE,NULL,ETR:DBXX,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DBPG X-TRACKERS SP500 2X LEVERAGED DAILY', 'LU0411078552', 'EUR', 4, '', 81742, NULL, NULL, NULL, NULL, 100, 'c', 2, 5, NULL, false, '{DBPG.DE,NULL,NULL,NULL,DBPG.DE}', false, 2);
INSERT INTO public.products VALUES ('DBPK X-TRACKERS SP500 2X INVERSE DAILY SWAP', 'LU0411078636', 'EUR', 4, '', 81743, NULL, NULL, NULL, NULL, 100, 'p', 2, 5, NULL, false, '{DBPK.DE,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('D.B.VALENCIA', 'ES06139809C2', 'EUR', 1, '|MERCADOCONTINUO|', 74821, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES06139809C2||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DCT INDUSTRIAL TRUST INC.', NULL, 'USD', 1, '', 77931, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DCT||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DDR CORP.', NULL, 'USD', 1, '', 79044, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DDR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DEAG DEUTSCHE ENTERTAINMENT AG', 'DE000A0Z23G6', 'EUR', 1, '|DEUTSCHEBOERSE|', 79254, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE000A0Z23G6||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DEAN FOODS CO.', NULL, 'USD', 1, '', 77133, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DF||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DECEUNINCK', 'BE0003789063', 'EUR', 1, '|EURONEXT|', 75074, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003789063||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DECEUNINCK STVV(D)', 'BE0005632063', 'EUR', 1, '|EURONEXT|', 78475, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0005632063||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DEERE & CO.', NULL, 'USD', 1, '', 77997, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DE||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DEFICOM GROUP', 'BE0003624351', 'EUR', 1, '|EURONEXT|', 76369, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003624351||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DEFICOM STRIP', 'BE0005570412', 'EUR', 1, '|EURONEXT|', 76375, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0005570412||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DELACHAUX', 'FR0000032195', 'EUR', 1, '|EURONEXT|', 75608, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000032195||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DELEK US HOLDINGS INC.', NULL, 'USD', 1, '', 81654, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DK||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DELFINGEN', 'FR0000054132', 'EUR', 1, '|EURONEXT|', 78284, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000054132||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DELHAIZE GROUP', 'BE0003562700', 'EUR', 1, '|EURONEXT|', 75884, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003562700||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DELHAIZE GROUP', NULL, 'USD', 1, '', 79218, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DEG||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DELL', 'US24702R1014', 'USD', 1, '|NASDAQ100|', 75788, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'DELL||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DELPHI FINANCIAL GROUP INC. CL A', NULL, 'USD', 1, '', 78593, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DFG||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DELTA LLOYD', 'NL0009294552', 'EUR', 1, '|EURONEXT|', 76117, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0009294552||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DELTA PLUS GROUP', 'FR0004152502', 'EUR', 1, '|EURONEXT|', 78285, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0004152502||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DELTAPLU BSAR1211', 'FR0010202655', 'EUR', 1, '|EURONEXT|', 76590, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010202655||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DELTIC TIMBER CORP.', NULL, 'USD', 1, '', 78290, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DEL||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DELTICOM AG', 'DE0005146807', 'EUR', 1, '|DEUTSCHEBOERSE|', 79297, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005146807||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DELUXE CORP.', NULL, 'USD', 1, '', 75670, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DLX||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DEMAG CRANES AG', 'DE000DCAG010', 'EUR', 1, '|DEUTSCHEBOERSE|', 79419, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE000DCAG010||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DEMAND MEDIA INC.', NULL, 'USD', 1, '', 79902, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DMD||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DENBURY RESOURCES INC.', NULL, 'USD', 1, '', 77000, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DNR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DENTSPLY INTERNATIONAL INC.', 'US2490301072', 'USD', 1, '|NASDAQ100|', 77606, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'XRAY||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DEOLEO', 'ES0110047919', 'EUR', 1, '|MERCADOCONTINUO|', 78473, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0110047919||es||False', false, '{OLE.MC,NULL,BME:OLE,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DEPOSITO BANKINTER', NULL, 'EUR', 10, '', -3, '', '', '', '', 0, 'c', 1, 1, 'DEPOSITO BANKINTER||es||True', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DEPOSITO BARCLAYS', NULL, 'EUR', 2, NULL, -4, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'DEPOSITO BARCLAYS||es||True', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('Depósito Estructurado Bankinter', NULL, 'EUR', 10, '', -9, '', '', '', '', 100, 'i', 1, 1, '', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DEPOSITO IBERCAJA', NULL, 'EUR', 10, '', -5, '', '', '', '', 100, 'c', 1, 1, '', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DEPOSITO LACAIXA', NULL, 'EUR', 2, NULL, -6, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'DEPOSITO LACAIXA||es||True', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DERBY CYCLE AG', 'DE000A1H6HN1', 'EUR', 1, '|DEUTSCHEBOERSE|', 79508, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE000A1H6HN1||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DERECHOS BANCO SANTANDER', NULL, 'EUR', 2, NULL, -7, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'DERECHOS BANCO DE SANTANDER||es||True', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DERECHOS IBERDROLA', NULL, 'EUR', 1, '', -8, '', '', '', '', 100, 'c', 1, 1, 'DERECHOS IBERDROLA||None||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DERICHEBOURG', 'FR0000053381', 'EUR', 1, '|EURONEXT|', 79000, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000053381||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DESARROLLADORA HOMEX S.A.B. DE C.V.', NULL, 'USD', 1, '', 78199, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HXM||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DEUFOL AG', 'DE0005101505', 'EUR', 1, '|DEUTSCHEBOERSE|', 78762, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005101505||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DEUTSCHE BANK AG', 'DE0005140008', 'EUR', 1, '|DAX|DEUTSCHEBOERSE|', 79513, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005140008||de||False', false, '{DBK.DE,NULL,ETR:DBK,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DEUTSCHE BANK AG', NULL, 'USD', 1, '', 78037, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DB||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DEUTSCHE BETEILIGUNGS AG', 'DE0005508105', 'EUR', 1, '|DEUTSCHEBOERSE|', 79514, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005508105||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DEUTSCHE BÖRSE AG', 'DE0005810055', 'EUR', 1, '|DAX|DEUTSCHEBOERSE|', 79520, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005810055||de||False', false, '{DB1.DE,NULL,ETR:DB1,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DEUTSCHE BÖRSE TENDERED SHARES', 'DE000A1KRND6', 'EUR', 1, '|DEUTSCHEBOERSE|', 79572, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE000A1KRND6||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DEUTSCHE EUROSHOP AG', 'DE0007480204', 'EUR', 1, '|DEUTSCHEBOERSE|', 79573, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0007480204||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DEUTSCHE FLOATING RATE NOTES LC', 'LU0034353002 ', 'EUR', 2, '|f_cat_money|', 81715, NULL, NULL, NULL, NULL, 0, 'c', 1, 18, NULL, false, '{NULL,F0GBR04NQN,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DEUTSCHE LUFTHANSA AG', 'DE0008232125', 'EUR', 1, '|DAX|DEUTSCHEBOERSE|', 79574, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0008232125||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DEUTSCHE POST AG', 'DE0005552004', 'EUR', 1, '|DAX|DEUTSCHEBOERSE|EUROSTOXX|', 79588, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005552004||de||False', false, '{DPW.DE,NULL,ETR:DPW,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DEUTSCHE POSTBANK AG', 'DE0008001009', 'u', 1, '|DAX|DEUTSCHEBOERSE|', 75762, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0008001009||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DEUTSCHE TELEKOM AG', 'DE0005557508', 'EUR', 1, '|DAX|DEUTSCHEBOERSE|EUROSTOXX|', 79592, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005557508||de||False', false, '{DTE.DE,NULL,ETR:DTE,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DEUTSCHE WOHNEN AG', 'DE000A0HN5C6', 'EUR', 1, '|DEUTSCHEBOERSE|', 79625, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE000A0HN5C6||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DEUTSCHE WOHNEN AG NA', 'DE0006283302', 'EUR', 1, '|DEUTSCHEBOERSE|', 79667, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0006283302||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DEUTZ AG', 'DE0006305006', 'EUR', 1, '|DEUTSCHEBOERSE|', 79521, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0006305006||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DEVERNOIS', 'FR0000060840', 'EUR', 1, '|EURONEXT|', 76942, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000060840||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DEVGEN', 'BE0003821387', 'EUR', 1, '|EURONEXT|', 75890, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003821387||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DEVON ENERGY CORP.', NULL, 'USD', 1, '', 79469, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DVN||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DEVOTEAM BSAR1112', 'FR0010379529', 'EUR', 1, '|EURONEXT|', 79553, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010379529||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DEVOTEAM', 'FR0000073793', 'EUR', 1, '|EURONEXT|', 76943, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000073793||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DEVOTEAM NV', 'FR0010987271', 'EUR', 1, '|EURONEXT|', 75977, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010987271||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DEVRY INC.', NULL, 'USD', 1, '', 77878, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DV||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DEX ONE CORP.', NULL, 'USD', 1, '', 81024, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DEXO||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DEXIA', 'BE0003796134', 'EUR', 1, '', 74975, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'DEXB.BR||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DEXIA STRIP', 'BE0005587580', 'EUR', 1, '|EURONEXT|', 80179, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0005587580||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DF DEUTSCHE FORFAIT AG', 'DE0005488795', 'EUR', 1, '|DEUTSCHEBOERSE|', 79668, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005488795||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DHT HOLDINGS INC.', NULL, 'USD', 1, '', 80527, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DHT||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DIA', 'ES0126775032', 'EUR', 1, '|IBEX|MERCADOCONTINUO|', 81114, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0126775032||es||False', false, '{DIA.MC,NULL,BME:DIA,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DIAGEO', 'GB0002374006', 'EUR', 1, '|EURONEXT|', 75156, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#GB0002374006||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DIAGEO PLC', NULL, 'USD', 1, '', 79211, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DEO||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DIAGNOSTIC MEDICAL', 'FR0000063224', 'EUR', 1, '|EURONEXT|', 76276, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000063224||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DIALOG SEMICONDUCTOR PLC', 'GB0059822006', 'EUR', 1, '|DEUTSCHEBOERSE|', 79671, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#GB0059822006||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DIAMOND OFFSHORE DRILLING INC.', NULL, 'USD', 1, '', 77160, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DO||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DIAMONDROCK HOSPITALITY CO.', NULL, 'USD', 1, '', 79010, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DRH||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DIANA SHIPPING INC.', NULL, 'USD', 1, '', 77037, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DSX||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DIC ASSET AG', 'DE0005098404', 'EUR', 1, '|DEUTSCHEBOERSE|', 79755, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005098404||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DICE HOLDINGS INC.', NULL, 'USD', 1, '', 79685, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DHX||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DICK''S SPORTING GOODS INC.', NULL, 'USD', 1, '', 76516, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DKS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DICO INTERNATIONAL', 'NL0009733351', 'EUR', 1, '|EURONEXT|', 80390, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0009733351||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DIEBOLD INC.', NULL, 'USD', 1, '', 76986, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DBD||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('D''IETEREN (D)', 'BE0974259880', 'EUR', 1, '|EURONEXT|', 79373, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0974259880||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('D''IETEREN STR (D)', 'BE0005642161', 'EUR', 1, '|EURONEXT|', 75059, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0005642161||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DIFERENCIAL BONO ALEMÁN-ESPAÑOL A 10 AÑOS', NULL, 'u', 7, '', 74804, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'BUND_DIFERENCIALESPAÑOL||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DIGIGRAM', 'FR0000035784', 'EUR', 1, '|EURONEXT|', 80345, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000035784||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DIGITAL REALTY TRUST INC.', NULL, 'USD', 1, '', 75553, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DLR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DIGITALGLOBE INC.', NULL, 'USD', 1, '', 77597, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DGI||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DILLARD''S INC.', NULL, 'USD', 1, '', 75568, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DDS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DINAMIA', 'ES0126501131', 'EUR', 1, '|MERCADOCONTINUO|', 78474, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0126501131||es||False', false, '{DIN.MC,NULL,BME:DIN,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DINEEQUITY INC.', NULL, 'USD', 1, '', 78613, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DIN||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DINERCAM', 'ES0126551037', 'EUR', 2, '|f_es_BMF|', 78980, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0126551037||es||False', false, '{NULL,F0GBR04J5M,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DINERKOA', 'ES0126499039', 'EUR', 2, '|f_es_BMF|', 78978, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0126499039||es||False', false, '{NULL,F0GBR04CFD,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DINERMADRID FONDTESORO', 'ES0126525031', 'EUR', 2, '|f_es_BMF|', 78984, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0126525031||es||False', false, '{NULL,F0GBR04PVT,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DINERO ACTIVO I', 'ES0126516030', 'EUR', 2, '|f_es_BMF|', 80027, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0126516030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DINERO ACTIVO II', 'ES0126548033', 'EUR', 2, '|f_es_BMF|', 80028, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0126548033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DINERO ACTIVO III', 'ES0126506031', 'EUR', 2, '|f_es_BMF|', 80029, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0126506031||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DINERO ACTIVO IV', 'ES0126494030', 'EUR', 2, '|f_es_BMF|', 80030, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0126494030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DINFONDO', 'ES0126536038', 'EUR', 2, '|f_es_BMF|', 80031, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0126536038||es||False', false, '{NULL,F0GBR04J5O,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DINVALOR GLOBAL', 'ES0126553033', 'EUR', 2, '|f_es_BMF|', 80032, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0126553033||es||False', false, '{NULL,F0GBR04J60,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DIRECTV', 'US25490A1016', 'USD', 1, '|NASDAQ100|', 77583, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'DTV||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DISCOVER FINANCIAL SERVICES', NULL, 'USD', 1, '', 78644, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DFS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DISH NETWORK CORPORATION', 'US25470M1099', 'USD', 1, '|NASDAQ100|', 75734, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'DISH||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DMS BC', 'FR0010944876', 'EUR', 1, '|EURONEXT|', 77373, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010944876||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DMS BSA D', 'FR0010944884', 'EUR', 1, '|EURONEXT|', 80187, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010944884||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DNXCORP', 'FR0010436584', 'EUR', 1, '|EURONEXT|', 80357, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010436584||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DOC DATA', 'NL0000345627', 'EUR', 1, '|EURONEXT|', 75157, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0000345627||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DOCK.PETR.AMBES AM', 'FR0000065260', 'EUR', 1, '|EURONEXT|', 80396, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000065260||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DOCKS LYONNAIS', 'FR0000060204', 'EUR', 1, '|EURONEXT|', 76376, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000060204||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DOCKWISE', 'BMG2786A2052', 'EUR', 1, '|EURONEXT|', 76944, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#BMG2786A2052||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DOGI', 'ES0126962010', 'EUR', 1, '|MERCADOCONTINUO|', 78518, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0126962010||es||False', false, '{DGI.MC,NULL,BME:DGI,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DOLBY LABORATORIES INC. CL A', NULL, 'USD', 1, '', 77741, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DLB||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DOLE FOOD CO. INC.', NULL, 'USD', 1, '', 79852, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DOLE||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DOLLAR GENERAL CORP.', NULL, 'USD', 1, '', 77024, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DG||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DOLLAR THRIFTY AUTOMOTIVE GROUP INC.', NULL, 'USD', 1, '', 78804, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DTG||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DOMINION RESOURCES INC. (VIRGINIA)', NULL, 'USD', 1, '', 75795, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#D||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DOMINO''S PIZZA INC.', NULL, 'USD', 1, '', 79006, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DPZ||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DOMTAR CORP.', NULL, 'USD', 1, '', 77268, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#UFS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DONALDSON CO. INC.', NULL, 'USD', 1, '', 76127, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DCI||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DORAL FINANCIAL CORP.', NULL, 'USD', 1, '', 81000, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DRL||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DOUGLAS DYNAMICS INC.', NULL, 'USD', 1, '', 79992, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#PLOW||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DOUGLAS EMMETT INC.', NULL, 'USD', 1, '', 78923, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DEI||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DOUGLAS HOLDING AG', 'DE0006099005', 'EUR', 1, '|DEUTSCHEBOERSE|', 79756, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0006099005||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DOVER CORP.', NULL, 'USD', 1, '', 77375, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DOV||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DOVER DOWNS GAMING & ENTERTAINMENT INC.', NULL, 'USD', 1, '', 80250, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DDE||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DOVER MOTORSPORTS INC.', NULL, 'USD', 1, '', 78116, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DVD||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DOW CHEMICAL CERT', 'BE0004594355', 'EUR', 1, '|EURONEXT|', 76385, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0004594355||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DOW CHEMICAL CO.', NULL, 'USD', 1, '', 78468, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DOW||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DOW CHEMICAL', 'US2605431038', 'EUR', 1, '|EURONEXT|', 76963, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#US2605431038||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DOW JONES INDUSTRIAL AVERAGE', 'US2605661048', 'USD', 3, '', 78259, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, '^DJI||us||False', false, '{^DJI,NULL,INDEXDJX:.DJI,NULL,DJI}', false, 2);
INSERT INTO public.products VALUES ('DPA GROUP', 'NL0009197771', 'EUR', 1, '|EURONEXT|', 76386, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0009197771||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DPL INC.', NULL, 'USD', 1, '', 75070, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DPL||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DR. HÖNLE AG', 'DE0005157101', 'EUR', 1, '|DEUTSCHEBOERSE|', 79797, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005157101||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('D.R. HORTON INC.', NULL, 'USD', 1, '', 77833, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DHI||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DR PEPPER SNAPPLE GROUP INC.', NULL, 'USD', 1, '', 75402, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DPS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DR. REDDY''S LABORATORIES LTD.', NULL, 'USD', 1, '', 75953, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#RDY||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DRÄGERWERK AG & CO. KGAA ST ', 'DE0005550602', 'EUR', 1, '|DEUTSCHEBOERSE|', 79844, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005550602||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DRÄGERWERK AG & CO. KGAA VZ', 'DE0005550636', 'EUR', 1, '|DEUTSCHEBOERSE|', 79849, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005550636||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DRDGOLD CERT.BELG.', 'BE0004520582', 'EUR', 1, '|EURONEXT|', 80188, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0004520582||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DREAM TEAM FONDO', 'ES0127073031', 'EUR', 2, '|f_es_BMF|', 80033, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0127073031||es||False', false, '{NULL,F0GBR04JRV,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DRESSER-RAND GROUP INC.', NULL, 'USD', 1, '', 76461, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DRC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DREW INDUSTRIES INC.', NULL, 'USD', 1, '', 78206, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DW||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DRILLISCH AG', 'DE0005545503', 'EUR', 1, '|DEUTSCHEBOERSE|', 79918, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005545503||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DRIL-QUIP INC.', NULL, 'USD', 1, '', 77438, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DRQ||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DSM KON', 'NL0000009827', 'EUR', 1, '|EURONEXT|', 80190, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0000009827||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DST SYSTEMS INC.', NULL, 'USD', 1, '', 79007, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DST||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DSW INC. CL A', NULL, 'USD', 1, '', 76904, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DSW||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DTE ENERGY CO.', NULL, 'USD', 1, '', 79380, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DTE||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DU PONT DE NEMOURS', 'US2635341090', 'EUR', 1, '|EURONEXT|', 75196, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#US2635341090||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DUC', 'FR0000036287', 'EUR', 1, '|EURONEXT|', 79628, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000036287||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DUCOMMUN INC.', NULL, 'USD', 1, '', 80098, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DCO||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DUFF & PHELPS CORP. CL A', NULL, 'USD', 1, '', 79729, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DUF||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DUKE ENERGY CORP.', NULL, 'USD', 1, '', 78769, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DUK||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DUKE REALTY CORP.', NULL, 'USD', 1, '', 78502, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DRE||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DUN & BRADSTREET CORP.', NULL, 'USD', 1, '', 77823, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DNB||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DUOYUAN GLOBAL WATER INC.', NULL, 'USD', 1, '', 80149, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DGW||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DUPONT FABROS TECHNOLOGY INC.', NULL, 'USD', 1, '', 77887, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DFT||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DURAN', 'FR0010731414', 'EUR', 1, '|EURONEXT|', 80191, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010731414||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DURO FELGUERA', 'ES0162600417', 'EUR', 1, '|MERCADOCONTINUO|', 78472, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0162600417||es||False', false, '{MDF.MC,NULL,BME:MDF,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DÜRR AG', 'DE0005565204', 'EUR', 1, '|DEUTSCHEBOERSE|', 80082, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005565204||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DUVEL MOORTGAT', 'BE0003762763', 'EUR', 1, '|EURONEXT|', 77520, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003762763||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DUX INTERNATIONAL STRATEGY', 'ES0127062000', 'EUR', 2, '|f_es_BMF|', 80034, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0127062000||es||False', false, '{NULL,F00000HHOA,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DUX MIXTO VARIABLE', 'ES0128067008', 'EUR', 2, '|f_es_BMF|', 80036, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0128067008||es||False', false, '{NULL,F000001W2M,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DUX RENTA VARIABLE EUROPEA', 'ES0127107037', 'EUR', 2, '|f_es_BMF|', 80037, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0127107037||es||False', false, '{NULL,F0GBR0603X,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DUX RENTINVER RENTA FIJA', 'ES0127097030', 'EUR', 2, '|f_es_BMF|', 80061, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0127097030||es||False', false, '{NULL,F0GBR0603W,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DWS ACCIONES', 'ES0114085030', 'EUR', 2, '|f_es_BMF|', 80069, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114085030||es||False', false, '{NULL,F0GBR04PV0,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DWS AGRIX GARANTIZADO', 'ES0138686037', 'EUR', 2, '|f_es_BMF|', 80070, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138686037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DWS CANTABRIA CRECIMIENTO GAR.II', 'ES0115853030', 'EUR', 2, '|f_es_BMF|', 80089, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115853030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DWS CAPITAL I', 'ES0114086038', 'EUR', 2, '|f_es_BMF|', 78852, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114086038||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DWS CAPITAL II', 'ES0125774036', 'EUR', 2, '|f_es_BMF|', 75173, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0125774036||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DWS CAPITAL III', 'ES0125775033', 'EUR', 2, '|f_es_BMF|', 74972, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0125775033||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DWS CAPITAL IV', 'ES0125809030', 'EUR', 2, '|f_es_BMF|', 74973, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0125809030||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DWS COMPAEURO', 'ES0121051033', 'EUR', 2, '|f_es_BMF|', 78626, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0121051033||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DWS CRECIMIENTO', 'ES0125776031', 'EUR', 2, '|f_es_BMF|', 80076, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0125776031||es||False', false, '{NULL,F0GBR04K2N,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DWS DINER', 'ES0125783037', 'EUR', 2, '|f_es_BMF|', 80072, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0125783037||es||False', false, '{NULL,F0GBR04PUE,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DWS DINER II', 'ES0125788036', 'EUR', 2, '|f_es_BMF|', 74974, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0125788036||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DWS DINERPLUS', 'ES0125789034', 'EUR', 2, '|f_es_BMF|', 80073, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0125789034||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DWS EUROPA BOLSA', 'ES0114087036', 'EUR', 2, '|f_es_BMF|', 80078, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114087036||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DWS FONCREATIVO', 'ES0138535036', 'EUR', 2, '|f_es_BMF|', 80079, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138535036||es||False', false, '{NULL,F0GBR04K4O,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DWS FONPROCURADOR', 'ES0136787035', 'EUR', 2, '|f_es_BMF|', 80080, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0136787035||es||False', false, '{NULL,F0GBR04K4Q,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DWS GLOBALFLEX GARANTIZADO', 'ES0125803033', 'EUR', 2, '|f_es_BMF|', 76662, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0125803033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DWS INVEST', 'ES0125784035', 'EUR', 2, '|f_es_BMF|', 77313, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0125784035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DWS MIXTA', 'ES0125785032', 'EUR', 2, '|f_es_BMF|', 80081, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0125785032||es||False', false, '{NULL,F0GBR04PUW,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DWS MULTIGESTION ACTIVA GARANT.', 'ES0125793036', 'EUR', 2, '|f_es_BMF|', 75172, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0125793036||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DWS RENTA', 'ES0139012035', 'EUR', 2, '|f_es_BMF|', 78985, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0139012035||es||False', false, '{NULL,F0GBR04K2J,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DWS VALOR GLOBAL', 'ES0142392036', 'EUR', 2, '|f_es_BMF|', 74976, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0142392036||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DWS WINFONDO', 'ES0184717033', 'EUR', 2, '|f_es_BMF|', 77648, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0184717033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DXASIAC', 'LU0292107991', 'EUR', 4, '', 81430, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#LU0292107991||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DXBANKC', 'LU0292103651', 'EUR', 4, '', 81465, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#LU0292103651||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DXBANKSH', 'LU0322249037', 'EUR', 4, '', 81466, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#LU0322249037||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DXBRAZILC', 'LU0292109344', 'EUR', 4, '', 81467, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#LU0292109344||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DXCHINAC', 'LU0292109856', 'EUR', 4, '', 78522, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#LU0292109856||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DXDAXSH', 'LU0292106241', 'EUR', 4, '', 81468, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#LU0292106241||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DXDAXSHX2', 'LU0411075020', 'EUR', 4, '', 81469, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#LU0411075020||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DXEMERGC', 'LU0292107645', 'EUR', 4, '', 81470, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#LU0292107645||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DXESTSELD', 'LU0292095535', 'EUR', 4, '', 81471, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#LU0292095535||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DXESTX5C', 'LU0380865021', 'EUR', 4, '', 78209, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#LU0380865021||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DXESTX5D', 'LU0274211217', 'EUR', 4, '', 78219, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#LU0274211217||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DXESTX5SH', 'LU0292106753', 'EUR', 4, '', 81351, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#LU0292106753||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DXEURSTX50LE', 'LU0411077828', 'EUR', 4, '', 78227, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#LU0411077828||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DXIBX35TRN', 'LU0592216393', 'EUR', 4, '', 78236, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#LU0592216393||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DXJAPANC', 'LU0274209740', 'EUR', 4, '', 81353, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#LU0274209740||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DXLATAMC', 'LU0292108619', 'EUR', 4, '', 81354, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#LU0292108619||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DXLEVDAX', 'LU0411075376', 'EUR', 4, '', 78575, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#LU0411075376||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DXLPPRIVC', 'LU0322250712', 'EUR', 4, '', 81355, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#LU0322250712||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DXMEXC', 'LU0476289466', 'EUR', 4, '', 78578, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#LU0476289466||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DXRUSIAD', 'LU0322252502', 'EUR', 4, '', 78580, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#LU0322252502||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DXSP500C', 'LU0490618542', 'EUR', 4, '', 78581, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#LU0490618542||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DXSP500SH', 'LU0322251520', 'EUR', 4, '', 78582, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#LU0322251520||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DXSP5INV2', 'LU0411078636', 'EUR', 4, '', 78583, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#LU0411078636||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DXSP5LEV2', 'LU0411078552', 'EUR', 4, '', 78678, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#LU0411078552||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DXST600C', 'LU0328475792', 'EUR', 4, '', 78748, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#LU0328475792||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DXWORLDC', 'LU0274208692', 'EUR', 4, '', 78753, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#LU0274208692||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DYCKERHOFF AG ST', 'DE0005591002', 'EUR', 1, '|DEUTSCHEBOERSE|', 80096, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005591002||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DYCKERHOFF AG VZ', 'DE0005591036', 'EUR', 1, '|DEUTSCHEBOERSE|', 80097, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005591036||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DYCOM INDUSTRIES INC.', NULL, 'USD', 1, '', 80893, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DY||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DYNACTION', 'FR0000130353', 'EUR', 1, '|EURONEXT|', 80402, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000130353||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DYNEGY INC.', NULL, 'USD', 1, '', 79943, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DYN||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('DYNEX CAPITAL INC.', NULL, 'USD', 1, '', 80945, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DX||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EADS', 'NL0000235190', 'EUR', 1, '', 79008, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'EURONEXT#NL0000235190||fr||False', true, '{EAD.BE,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EAGLE MATERIALS INC.', NULL, 'USD', 1, '', 81614, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#EXP||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EASTGROUP PROPERTIES INC.', NULL, 'USD', 1, '', 77974, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#EGP||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EASTMAN CHEMICAL CO.', NULL, 'USD', 1, '', 75055, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#EMN||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EASTMAN KODAK CO.', NULL, 'USD', 1, '', 75912, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#EK||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EATON CORP.', NULL, 'USD', 1, '', 74847, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ETN||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EATON VANCE CORP.', NULL, 'USD', 1, '', 76391, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#EV||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EBAY, INC', 'US2786421030', 'USD', 1, '|NASDAQ100|', 75736, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'EBAY||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EBIZCUSS.COM', 'FR0000078859', 'EUR', 1, '|EURONEXT|', 77543, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000078859||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EBRO FOODS S.A.', 'ES0112501012', 'EUR', 1, '|MERCADOCONTINUO|', 81115, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0112501012||es||False', false, '{EBRO.MC,NULL,BME:EBRO,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ECA', 'FR0010099515', 'EUR', 1, '|EURONEXT|', 79011, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010099515||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ECKERT & ZIEGLER AG', 'DE0005659700', 'EUR', 1, '|DEUTSCHEBOERSE|', 80105, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005659700||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ECKERT-ZIEGLER BG', 'BE0003689032', 'EUR', 1, '|EURONEXT|', 79013, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003689032||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ECOLAB INC.', NULL, 'USD', 1, '', 76887, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ECL||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('E-COMMERCE CHINA DANGDANG INC.', NULL, 'USD', 1, '', 80942, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DANG||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ECONOCOM GROUP', 'BE0003563716', 'EUR', 1, '|EURONEXT|', 79018, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003563716||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ECOPETROL S.A.', NULL, 'USD', 1, '', 76976, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#EC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ECOTEL COMMUNICATION AG', 'DE0005854343', 'EUR', 1, '|DEUTSCHEBOERSE|', 80110, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005854343||de||Falsee4c.de', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EDENRED', 'FR0010908533', 'EUR', 1, '|EURONEXT|', 79019, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010908533||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EDF ENERGIES NOUV.', 'FR0010400143', 'EUR', 1, '|EURONEXT|', 76883, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010400143||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EDF ENERGIES NOUV.', 'FR0011056001', 'EUR', 1, '|EURONEXT|', 75744, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0011056001||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EDISON INTERNATIONAL', NULL, 'USD', 1, '', 79130, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#EIX||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EDM AHORRO', 'ES0168673038', 'EUR', 2, '|f_es_BMF|', 75174, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0168673038||es||False', false, '{NULL,F0GBR04DHM,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EDM CARTERA', 'ES0128331008', 'EUR', 2, '|f_es_BMF|', 78986, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0128331008||es||False', false, '{NULL,F000002115,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EDM INVERSION', 'ES0168674036', 'EUR', 2, '|f_es_BMF|', 75223, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0168674036||es||False', false, '{NULL,F0GBR04DHO,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EDM RENTA', 'ES0127795039', 'EUR', 2, '|f_es_BMF|', 75501, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0127795039||es||False', false, '{NULL,F0GBR04DHQ,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EDM VALORES UNO', 'ES0127796037', 'EUR', 2, '|f_es_BMF|', 75473, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0127796037||es||False', false, '{NULL,F0GBR04EPT,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EDP', 'PTEDP0AM0009', 'EUR', 1, '|EURONEXT|', 79022, NULL, NULL, NULL, NULL, 100, 'c', 1, 9, 'EURONEXT#PTEDP0AM0009||pt||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EDP RENOVAVEIS', 'ES0127797019', 'EUR', 1, '|EURONEXT|', 80403, NULL, NULL, NULL, NULL, 100, 'c', 1, 9, 'EURONEXT#ES0127797019||pt||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EDUCATION REALTY TRUST INC.', NULL, 'USD', 1, '', 79383, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#EDR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EDWARDS LIFESCIENCES CORP.', NULL, 'USD', 1, '', 75427, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#EW||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EGIDE DS', 'FR0011179993', 'EUR', 1, '|EURONEXT|', 78481, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0011179993||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EGIDE', 'FR0000072373', 'EUR', 1, '|EURONEXT|', 80405, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000072373||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EGO-LIFESTYLE', 'NL0009127547', 'EUR', 1, '|EURONEXT|', 80410, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0009127547||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('E-HOUSE (CHINA) HOLDINGS LTD.', NULL, 'USD', 1, '', 79801, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#EJ||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('E.I. DUPONT DE NEMOURS & CO.', NULL, 'USD', 1, '', 77993, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#DD||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EIFFAGE', 'FR0000130452', 'EUR', 1, '|EURONEXT|', 80411, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000130452||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EINHELL GERMANY AG', 'DE0005654933', 'EUR', 1, '|DEUTSCHEBOERSE|', 80162, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005654933||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EJECUTIVOS GLOBALFOND', 'ES0128496033', 'EUR', 2, '|f_es_BMF|', 78990, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0128496033||es||False', false, '{NULL,F0GBR04JSQ,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EL PASO CORP.', NULL, 'USD', 1, '', 77481, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#EP||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EL PASO ELECTRIC CO.', NULL, 'USD', 1, '', 75773, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#EE||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ELAN CORP. PLC', NULL, 'USD', 1, '', 76900, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ELN||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ELDORADO GOLD CORP.', NULL, 'USD', 1, '', 78589, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#EGO||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ELEC.MADAGASCAR', 'FR0000035719', 'EUR', 1, '|EURONEXT|', 80413, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000035719||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ELECNOR', 'ES0129743318', 'EUR', 1, '|MERCADOCONTINUO|', 78775, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0129743318||es||False', false, '{ENO.MC,NULL,BME:ENO,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ELEC.STRASBOURG', 'FR0000031023', 'EUR', 1, '|EURONEXT|', 75966, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000031023||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ELECTRICITÉ DE FRANCE', 'FR0010242511', 'EUR', 1, '|CAC|', 75212, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EDF.PA||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ELECTRONIC ARTS, INC', 'US2855121099', 'USD', 1, '|NASDAQ100|', 76087, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'ERTS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ELECTRONICS LINE 3000 LTD.', 'IL0010905052', 'EUR', 1, '|DEUTSCHEBOERSE|', 80163, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#IL0010905052||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ELETROBRAS B', 'BRELETACNPB7', 'EUR', 1, '|LATIBEX|', 81358, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#BRELETACNPB7||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ELETROBRAS O', 'BRELETACNOR6', 'EUR', 1, '|LATIBEX|', 81361, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#BRELETACNOR6||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ELEXIS AG', 'DE0005085005', 'EUR', 1, '|DEUTSCHEBOERSE|', 80173, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005085005||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ELI LILLY & CO.', NULL, 'USD', 1, '', 78425, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#LLY||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ELIA', 'BE0003822393', 'EUR', 1, '|EURONEXT|', 75980, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003822393||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ELIA STRIP', 'BE0005597688', 'EUR', 1, '|EURONEXT|', 77820, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0005597688||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ELIXENS', 'FR0000054611', 'EUR', 1, '|EURONEXT|', 79632, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000054611||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ELMOS SEMICONDUCTOR AG', 'DE0005677108', 'EUR', 1, '|DEUTSCHEBOERSE|', 80174, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005677108||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ELRINGKLINGER AG', 'DE0007856023', 'EUR', 1, '|DEUTSCHEBOERSE|', 80175, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0007856023||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ELSTER GROUP SE', NULL, 'USD', 1, '', 79453, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ELT||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EMBRAER S/A', NULL, 'USD', 1, '', 78392, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ERJ||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EMC CORP.', NULL, 'USD', 1, '', 76813, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#EMC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EMCOR GROUP INC.', NULL, 'USD', 1, '', 81593, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#EME||us||False', false, '{EME,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EMDEON INC. CL A', NULL, 'USD', 1, '', 77002, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#EM||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EMERGENCY MEDICAL SERVICES CORP. CL A', NULL, 'USD', 1, '', 75375, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#EMS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EMERGENT BIOSOLUTIONS INC.', NULL, 'USD', 1, '', 77231, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#EBS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EMERITUS CORP.', NULL, 'USD', 1, '', 77759, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ESC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EMERSON ELECTRIC CO.', NULL, 'USD', 1, '', 76859, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#EMR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EMME', 'FR0004155000', 'EUR', 1, '|EURONEXT|', 79633, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0004155000||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EMPIRE DISTRICT ELECTRIC CO.', NULL, 'USD', 1, '', 79422, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#EDE||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EMPLOYERS HOLDINGS INC.', NULL, 'USD', 1, '', 79555, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#EIG||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EMPRESA NACIONAL DE ELECTRICIDAD S.A.', NULL, 'USD', 1, '', 75508, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#EOC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EMPRESAS ICA S.A.B. DE C.V.', NULL, 'USD', 1, '', 81587, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ICA||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EMULEX CORP.', NULL, 'USD', 1, '', 78594, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ELX||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ENAGAS', 'ES0130960018', 'EUR', 1, '|IBEX|MERCADOCONTINUO|', 81117, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0130960018||es||False', false, '{ENG.MC,NULL,BME:ENG,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ENBRIDGE INC.', NULL, 'USD', 1, '', 77786, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ENB||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ENCANA CORP.', NULL, 'USD', 1, '', 76015, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ECA||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ENCRES DUBUIT', 'FR0004030708', 'EUR', 1, '|EURONEXT|', 79634, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0004030708||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ENDEAVOUR INTERNATIONAL CORP.', NULL, 'USD', 1, '', 79760, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#END||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ENDEAVOUR SILVER CORP.', NULL, 'USD', 1, '', 77447, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#EXK||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ENDESA CHILE', 'CLP3710M1090', 'EUR', 1, '|LATIBEX|', 81363, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#CLP3710M1090||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ENDESA S.A.', 'ES0130670112', 'EUR', 1, '|IBEX|MERCADOCONTINUO|', 78880, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0130670112||es||False', false, '{ELE.MC,NULL,BME:ELE,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ENDURANCE SPECIALTY HOLDINGS LTD.', NULL, 'USD', 1, '', 76777, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ENH||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ENEL G.P.', 'IT0004618465', 'EUR', 1, '|MERCADOCONTINUO|', 78881, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#IT0004618465||es||False', false, '{EGPW.MC,NULL,BME:EGPW,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ENEL', 'IT0003128367', 'EUR', 1, '|EUROSTOXX|', 75450, NULL, NULL, NULL, NULL, 100, 'c', 1, 6, 'ENEL.MI||it||False', false, '{ENEL.MI,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ENERGEN CORP.', NULL, 'USD', 1, '', 76058, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#EGN||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ENERGIZER HOLDINGS INC.', NULL, 'USD', 1, '', 75217, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ENR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ENERGY PARTNERS LTD.', NULL, 'USD', 1, '', 79696, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#EPL||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ENERGYSOLUTIONS INC.', NULL, 'USD', 1, '', 80319, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ES||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ENERSIS', 'CLP371861061', 'EUR', 1, '|LATIBEX|', 78885, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#CLP371861061||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ENERSIS S.A.', NULL, 'USD', 1, '', 76172, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ENI||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ENERSYS INC.', NULL, 'USD', 1, '', 79153, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ENS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ENGIE', 'FR0010208488', 'EUR', 1, '|CAC|EURONEXT|EUROSTOXX|', 79663, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010208488||fr||False. Antigua GDF Suez', false, '{ENGI.PA,NULL,EPA:ENGI,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ENI', 'IT0003132476', 'EUR', 1, '|EUROSTOXX|', 75715, NULL, NULL, NULL, NULL, 100, 'c', 1, 6, 'ENI.MI||it||False', false, '{ENI.MI,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ENI S.P.A.', NULL, 'USD', 1, '', 77784, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#E||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ENNIS INC.', NULL, 'USD', 1, '', 79707, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#EBF||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ENPRO INDUSTRIES INC.', NULL, 'USD', 1, '', 78628, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#NPO||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ENSCO PLC', NULL, 'USD', 1, '', 78358, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ESV||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ENTERCOM COMMUNICATIONS CORP. CL A', NULL, 'USD', 1, '', 80965, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ETM||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ENTERGY CORP.', NULL, 'USD', 1, '', 75358, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ETR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ENTERTAINMENT PROPERTIES TRUST', NULL, 'USD', 1, '', 78965, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#EPR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ENTRAVISION COMMUNICATIONS CORP.', NULL, 'USD', 1, '', 81016, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#EVC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ENTREP.CONTRACTING', 'FR0010204321', 'EUR', 1, '|EURONEXT|', 79554, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010204321||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ENVESTNET INC.', NULL, 'USD', 1, '', 79831, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ENV||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ENVIPCO (D)', 'NL0009901610', 'EUR', 1, '|EURONEXT|', 80416, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#NL0009901610||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ENVIPCO HOLD. CERT', 'NL0000349439', 'EUR', 1, '|EURONEXT|', 75556, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#NL0000349439||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ENVITEC BIOGAS AG', 'DE000A0MVLS8', 'EUR', 1, '|DEUTSCHEBOERSE|', 80181, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE000A0MVLS8||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ENZO BIOCHEM INC.', NULL, 'USD', 1, '', 77626, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ENZ||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EOG RESOURCES INC.', NULL, 'USD', 1, '', 77237, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#EOG||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('E.ON AG', 'DE000ENAG999', 'EUR', 1, '|DAX|DEUTSCHEBOERSE|EUROSTOXX|', 80103, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE000ENAG999||de||False', false, '{EOAN.DE,NULL,ETR:EOAN,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EPIGENOMICS AG', 'DE000A0BVT96', 'EUR', 1, '|DEUTSCHEBOERSE|', 78100, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE000A0BVT96||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EPIGENOMICS AG', 'DE000A1K0516', 'EUR', 1, '|DEUTSCHEBOERSE|', 80200, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE000A1K0516||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EQT CORP.', NULL, 'USD', 1, '', 75463, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#EQT||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EQUAL ENERGY LTD.', NULL, 'USD', 1, '', 80432, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#EQU||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EQUIFAX INC.', NULL, 'USD', 1, '', 77120, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#EFX||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EQUITY LIFESTYLE PROPERTIES INC.', NULL, 'USD', 1, '', 75276, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ELS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EQUITY ONE INC.', NULL, 'USD', 1, '', 76097, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#EQY||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EQUITY RESIDENTIAL', NULL, 'USD', 1, '', 75252, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#EQR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ERAMET', 'FR0000131757', 'EUR', 1, '|EURONEXT|', 80418, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000131757||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ERCROS', 'ES0125140A14', 'EUR', 1, '|MERCADOCONTINUO|', 78886, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0125140A14||es||False', false, '{ECR.MC,NULL,BME:ECR,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESAF 10', 'ES0138839032', 'EUR', 2, '|f_es_BMF|', 79026, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138839032||es||False', false, '{NULL,F0GBR04J4G,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESAF 25', 'ES0138604030', 'EUR', 2, '|f_es_BMF|', 79280, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138604030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESAF 50', 'ES0115047039', 'EUR', 2, '|f_es_BMF|', 79281, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115047039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESAF 70', 'ES0115073035', 'EUR', 2, '|f_es_BMF|', 79034, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115073035||es||False', false, '{NULL,F0GBR04J4I,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESAF ACCIONES EUROPEAS', 'ES0115048037', 'EUR', 2, '|f_es_BMF|', 79282, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115048037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESAF DEUDA PUBLICA', 'ES0168658039', 'EUR', 2, '|f_es_BMF|', 79275, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0168658039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESAF GARAN.BOLSA EUROPEA 2', 'ES0168566034', 'EUR', 2, '|f_es_BMF|', 75478, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0168566034||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESAF GARAN.BOLSA MUNDIAL 3', 'ES0168621037', 'EUR', 2, '|f_es_BMF|', 75480, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0168621037||es||False', false, '{NULL,F0GBR04J56,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESAF GARANT. BOLSA ESPANOLA 3', 'ES0168656033', 'EUR', 2, '|f_es_BMF|', 79042, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0168656033||es||False', false, '{NULL,F0GBR04J50,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESAF GARANT. BOLSA EUROPEA 3', 'ES0168397034', 'EUR', 2, '|f_es_BMF|', 75268, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0168397034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESAF GARANT.BOLSA ESPAÑOLA 4', 'ES0168564039', 'EUR', 2, '|f_es_BMF|', 75269, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0168564039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESAF GARANTIZADO 5 ESTRELLAS', 'ES0168657031', 'EUR', 2, '|f_es_BMF|', 75270, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0168657031||es||False', false, '{NULL,F0GBR04J54,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESAF GARANTIZADO BOLSA EUROPEA 4', 'ES0168667030', 'EUR', 2, '|f_es_BMF|', 75561, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0168667030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESAF GARANTTIZADO ORO', 'ES0168669036', 'EUR', 2, '|f_es_BMF|', 75273, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0168669036||es||False', false, '{NULL,F0GBR04J4Q,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESAF GAR.RENTABILIDAD SEGURA 2', 'ES0168568006', 'EUR', 2, '|f_es_BMF|', 75476, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0168568006||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESAF GAR.RENTABILIDAD SEGURA', 'ES0168624007', 'EUR', 2, '|f_es_BMF|', 77361, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0168624007||es||False', false, '{NULL,F000001LHE,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESAF GESTION FLEXIBLE', 'ES0138366002', 'EUR', 2, '|f_es_BMF|', 79054, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138366002||es||False', false, '{NULL,F00000HHOB,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESAF RENTA FIJA CORTO', 'ES0115049035', 'EUR', 2, '|f_es_BMF|', 76565, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115049035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESAF RENTA FIJA LARGO', 'ES0168662031', 'EUR', 2, '|f_es_BMF|', 79059, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0168662031||es||False', false, '{NULL,F0GBR04J4S,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESAF RENTA VARIABLE', 'ES0168668038', 'EUR', 2, '|f_es_BMF|', 79065, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0168668038||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('E.SANTO FINANCIAL', 'LU0011904405', 'EUR', 1, '|EURONEXT|', 79004, NULL, NULL, NULL, NULL, 100, 'c', 1, 9, 'EURONEXT#LU0011904405||pt||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('E.SANTO FIN.NOM', 'LU0202957089', 'EUR', 1, '|EURONEXT|', 79629, NULL, NULL, NULL, NULL, 100, 'c', 1, 9, 'EURONEXT#LU0202957089||pt||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESCO TECHNOLOGIES INC.', NULL, 'USD', 1, '', 79470, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ESE||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESI GROUP', 'FR0004110310', 'EUR', 1, '|EURONEXT|', 80419, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0004110310||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESPACE PROD BS', 'FR0010559641', 'EUR', 1, '|EURONEXT|', 80420, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010559641||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESPACE PRODUCTION', 'FR0004048072', 'EUR', 1, '|EURONEXT|', 79635, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0004048072||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESPACE PRODUCTION', 'FR0011067867', 'EUR', 1, '|EURONEXT|', 75332, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0011067867||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESP.DEL ZINC', 'ES0132970213', 'EUR', 1, '|MERCADOCONTINUO|', 78862, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0132970213||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESPINOSA PARTNERS INVERSIONES', 'ES0133091035', 'EUR', 2, '|f_es_BMF|', 77407, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133091035||es||False', false, '{NULL,F0GBR04DJ1,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESPIRITO SANTO BOLSA EUROPA SELECCION', 'ES0158761033', 'EUR', 2, '|f_es_BMF|', 80090, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0158761033||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESPIRITO SANTO BOLSA SELECCION', 'ES0138517034', 'EUR', 2, '|f_es_BMF|', 80107, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138517034||es||False', false, '{NULL,F0GBR04J94,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESPIRITO SANTO BOLSA USA', 'ES0133338030', 'EUR', 2, '|f_es_BMF|', 80108, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133338030||es||False', false, '{NULL,F0GBR04K40,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESPIRITO SANTO CAPITAL PLUS', 'ES0125240038', 'EUR', 2, '|f_es_BMF|', 77408, NULL, NULL, NULL, NULL, 0, 'c', 1, 1, 'ES0125240038||es||False', false, '{NULL,F0GBR04PRL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESPIRITO SANTO CARTERA ACTIVA, FI', 'ES0137942001', 'EUR', 2, '|f_es_BMF|', 79049, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137942001||es||False', false, '{NULL,F000000E7J,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESPIRITO SANTO DOBLE INDICE', 'ES0133092033', 'EUR', 2, '|f_es_BMF|', 80109, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133092033||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESPIRITO SANTO ESPAÑA 30', 'ES0158193039', 'EUR', 2, '|f_es_BMF|', 76371, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0158193039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESPIRITO SANTO EUROBONOS', 'ES0158791030', 'EUR', 2, '|f_es_BMF|', 78946, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0158791030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESPIRITO SANTO EUROFONDO II', 'ES0133591034', 'EUR', 2, '|f_es_BMF|', 80114, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133591034||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESPIRITO SANTO FONDEPOSITO II', 'ES0158792004', 'EUR', 2, '|f_es_BMF|', 80115, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0158792004||es||False', false, '{NULL,F00000LJSI,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESPIRITO SANTO FONDIBAS MIXTO', 'ES0170270039', 'EUR', 2, '|f_es_BMF|', 80039, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0170270039||es||False', false, '{NULL,F0GBR04PTY,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESPIRITO SANTO FONDTESORO', 'ES0114911037', 'EUR', 2, '|f_es_BMF|', 79074, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114911037||es||False', false, '{NULL,F0GBR04PRW,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESPIRITO SANTO GARANTIA BOLSA', 'ES0158773038', 'EUR', 2, '|f_es_BMF|', 80117, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0158773038||es||False', false, '{NULL,F0GBR04J8W,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESPIRITO SANTO GESTION DINAMICA', 'ES0133098030', 'EUR', 2, '|f_es_BMF|', 77645, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133098030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESPIRITO SANTO GLOBAL SOLIDARIO', 'ES0131422000', 'EUR', 2, '|f_es_BMF|', 80118, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0131422000||es||False', false, '{NULL,F00000410Q,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESPIRITO SANTO PATRIMONIO, FI', 'ES0137765030', 'EUR', 2, '|f_es_BMF|', 79075, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137765030||es||False', false, '{NULL,F0GBR04JJT,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESPIRITO SANTO PHARMAFUND', 'ES0169778034', 'EUR', 2, '|f_es_BMF|', 80120, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0169778034||es||False', false, '{NULL,F0GBR04PTZ,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESPIRITO SANTO PREMIUM BOLSA', 'ES0114916036', 'EUR', 2, '|f_es_BMF|', 75275, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114916036||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESPIRITO SANTO PROTECCION BOLSA', 'ES0112698008', 'EUR', 2, '|f_es_BMF|', 75319, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0112698008||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESPIRITO SANTO RENTA DINAMICA', 'ES0150036038', 'EUR', 2, '|f_es_BMF|', 78945, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0150036038||es||False', false, '{NULL,F0GBR04PRV,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESPIRITO SANTO VALOR EUROPA, FI', 'ES0114917034', 'EUR', 2, '|f_es_BMF|', 79068, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114917034||es||False', false, '{NULL,F0GBR04PRR,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESR', 'FR0000072969', 'EUR', 1, '|EURONEXT|', 79697, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000072969||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESSANELLE HAIR GROUP AG', 'DE0006610314', 'EUR', 1, '|DEUTSCHEBOERSE|', 80233, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0006610314||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESSEX PROPERTY TRUST INC.', NULL, 'USD', 1, '', 77113, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ESS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESSILOR INTERNATIONAL', 'FR0000121667', 'EUR', 1, '|CAC|EURONEXT|EUROSTOXX|', 79699, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000121667||fr||False', false, '{EI.PA,NULL,EPA:EI,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESSO', 'FR0000120669', 'EUR', 1, '|EURONEXT|', 76964, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000120669||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESTAVIS AG', 'DE000A0KFKB3', 'EUR', 1, '|DEUTSCHEBOERSE|', 78973, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE000A0KFKB3||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESTEE LAUDER COS. INC.', NULL, 'USD', 1, '', 77505, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#EL||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESTERLINE TECHNOLOGIES CORP.', NULL, 'USD', 1, '', 78734, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ESL||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESTORIL SOL P', 'PTESO0AE0000', 'EUR', 1, '|EURONEXT|', 79206, NULL, NULL, NULL, NULL, 100, 'c', 1, 9, 'EURONEXT#PTESO0AE0000||pt||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ESTUBROKER GAC I', 'ES0133461030', 'EUR', 2, '|f_es_BMF|', 75610, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133461030||es||False', false, '{NULL,F0GBR04GVS,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ETAM DEVELOPPEMENT', 'FR0000035743', 'EUR', 1, '|EURONEXT|', 79069, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000035743||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ETCHEVERRIA MIXTO', 'ES0133509036', 'EUR', 2, '|f_es_BMF|', 80130, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133509036||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ETHAN ALLEN INTERIORS INC.', NULL, 'USD', 1, '', 80899, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ETH||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ETU.REALI.MOULES', 'FR0000063950', 'EUR', 1, '|EURONEXT|', 79168, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000063950||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EULER HERMES', 'FR0004254035', 'EUR', 1, '|EURONEXT|', 77821, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0004254035||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EULER HERMES NV', 'FR0010978783', 'EUR', 1, '|EURONEXT|', 77708, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010978783||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EURAZEO DA ANF', 'FR0011044387', 'EUR', 1, '|EURONEXT|', 76100, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0011044387||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EURAZEO', 'FR0000121121', 'EUR', 1, '|EURONEXT|', 77827, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000121121||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EURO / USA$', NULL, 'u', 6, '', 74747, NULL, NULL, NULL, NULL, 100, 'c', 1, 10, 'EUR2USD||eu||True', false, '{EURUSD=X,NULL,NULL,NULL,"EUR/USD - Euro Dólar estadounidense"}', false, 6);
INSERT INTO public.products VALUES ('EURO DISNEY', 'FR0010540740', 'EUR', 1, '|EURONEXT|', 77828, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010540740||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EURO RESSOURCES', 'FR0000054678', 'EUR', 1, '|EURONEXT|', 79172, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000054678||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EURO STOXX 50', NULL, 'EUR', 3, '', 75540, NULL, NULL, NULL, NULL, 100, 'c', 1, 10, '^STOXX50E||eu||False', false, '{^STOXX50E,NULL,INDEXSTOXX:SX5E,NULL,STOXX50}', false, 2);
INSERT INTO public.products VALUES ('EUROAGENTES BOLSA', 'ES0133797037', 'EUR', 2, '|f_es_BMF|', 80131, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133797037||es||False', false, '{NULL,F0GBR04IYG,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROAGENTES PLUS', 'ES0133531030', 'EUR', 2, '|f_es_BMF|', 80132, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133531030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROAGENTES PREVISION', 'ES0133532038', 'EUR', 2, '|f_es_BMF|', 80133, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133532038||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROAGENTES RENTA', 'ES0133798035', 'EUR', 2, '|f_es_BMF|', 80134, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133798035||es||False', false, '{NULL,F0GBR04IYE,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROAGENTES UNIVERSAL', 'ES0133569030', 'EUR', 2, '|f_es_BMF|', 80135, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133569030||es||False', false, '{NULL,F0GBR04IYK,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROCASTLE INVEST.', 'GB00B01C5N27', 'EUR', 1, '|EURONEXT|', 75233, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#GB00B01C5N27||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROCOMMERCIAL', 'NL0000288876', 'EUR', 1, '|EURONEXT|', 80421, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0000288876||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROFINS BSAR 13', 'FR0010292755', 'EUR', 1, '|EURONEXT|', 79173, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010292755||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROFINS SCIENT.', 'FR0000038259', 'EUR', 1, '|EURONEXT|', 80429, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000038259||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROFINS SCIENT NV', 'FR0010989780', 'EUR', 1, '|EURONEXT|', 77709, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010989780||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROFINS SCIENT NV', 'FR0011159987', 'EUR', 1, '|EURONEXT|', 75441, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0011159987||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROFONDO', 'ES0133812034', 'EUR', 2, '|f_es_BMF|', 77431, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133812034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROMEDIS GROUPE', 'FR0000075343', 'EUR', 1, '|EURONEXT|', 80434, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000075343||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROMICRON AG', 'DE0005660005', 'EUR', 1, '|DEUTSCHEBOERSE|', 77194, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005660005||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROMICRON AG', 'DE000A1K0300', 'EUR', 1, '|DEUTSCHEBOERSE|', 81169, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE000A1K0300||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EURONAV', 'BE0003816338', 'EUR', 1, '|EURONEXT|', 80435, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003816338||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROPA INNOVACION', 'ES0114921036', 'EUR', 2, '|f_es_BMF|', 75612, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114921036||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROPA REESTRUCTURACION', 'ES0182643009', 'EUR', 2, '|f_es_BMF|', 77059, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0182643009||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROPAC', 'ES0168561019', 'EUR', 1, '|MERCADOCONTINUO|', 78867, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0168561019||es||False', false, '{PAC.MC,NULL,BME:PAC,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROPACORP', 'FR0010490920', 'EUR', 1, '|EURONEXT|', 75235, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010490920||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROPEAN CLEANTECH 1 SE', 'LU0538936351', 'EUR', 1, '|DEUTSCHEBOERSE|', 81170, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#LU0538936351||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROSIC BS', 'FR0011129048', 'EUR', 1, '|EURONEXT|', 77098, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0011129048||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROSIC', 'FR0000038200', 'EUR', 1, '|EURONEXT|', 75240, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000038200||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROSIC', 'FR0011080357', 'EUR', 1, '|EURONEXT|', 77918, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0011080357||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROSIC', 'FR0011110915', 'EUR', 1, '|EURONEXT|', 77108, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0011110915||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALENCIA AHORRO FI', 'ES0133573032', 'EUR', 2, '|f_es_BMF|', 74977, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133573032||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALENCIA', 'ES0133836033', 'EUR', 2, '|f_es_BMF|', 80136, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133836033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR AFRICA Y ORIENTE MEDIO', 'ES0133444002', 'EUR', 2, '|f_es_BMF|', 75594, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133444002||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR AHORRO ACTIVO', 'ES0133462004', 'EUR', 2, '|f_es_BMF|', 80137, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133462004||es||False', false, '{NULL,F000001LHC,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR AHORRO DOLAR', 'ES0133501033', 'EUR', 2, '|f_es_BMF|', 80138, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133501033||es||False', false, '{NULL,F0GBR05XMD,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR AHORRO EURO', 'ES0133867038', 'EUR', 2, '|f_es_BMF|', 80139, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133867038||es||False', false, '{NULL,F0GBR04Q7X,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR AHORRO GARAN.CLASE A', 'ES0133563009', 'EUR', 2, '|f_es_BMF|', 80182, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133563009||None||False', false, '{NULL,F00000M1EF,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR ASIA', 'ES0133539033', 'EUR', 2, '|f_es_BMF|', 80183, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133539033||es||False', false, '{NULL,F0GBR04FQM,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR BANCA SEGUROS', 'ES0133484008', 'EUR', 2, '|f_es_BMF|', 77436, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133484008||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR BOLSA', 'ES0133871030', 'EUR', 2, '|f_es_BMF|', 80184, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133871030||es||False', false, '{NULL,F0GBR04Q79,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR BOLSA ESPAÑOLA', 'ES0133524035', 'EUR', 2, '|f_es_BMF|', 80185, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133524035||es||False', false, '{NULL,F0GBR04MDA,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR BOLSA EUROPEA', 'ES0133661035', 'EUR', 2, '|f_es_BMF|', 80186, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133661035||es||False', false, '{NULL,F0GBR04Q77,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR BONOS ALTO RENDIMIENTO', 'ES0133478034', 'EUR', 2, '|f_es_BMF|', 80189, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133478034||es||False', false, '{NULL,F0GBR06HEF,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR BONOS CORPORATIVOS', 'ES0133485005', 'EUR', 2, '|f_es_BMF|', 80197, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133485005||es||False', false, '{NULL,F0000044OL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR BONOS EURO LARGO PLAZO', 'ES0133479032', 'EUR', 2, '|f_es_BMF|', 80198, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133479032||es||False', false, '{NULL,F0GBR06HEG,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR CONSERVACION DINAMICO', 'ES0133614034', 'EUR', 2, '|f_es_BMF|', 80199, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133614034||es||False', false, '{NULL,F0GBR04LHQ,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR CONSERVADOR DIN.PLUS', 'ES0133743031', 'EUR', 2, '|f_es_BMF|', 80201, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133743031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR CONSOLIDADO 5', 'ES0133742033', 'EUR', 2, '|f_es_BMF|', 75320, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133742033||es||False', false, '{NULL,F0GBR04Q7T,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR DEU.PUBLICA EUROPA AAA', 'ES0133528002', 'EUR', 2, '|f_es_BMF|', 79076, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133528002||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR DIVIDENDO EUROPA', 'ES0127025031', 'EUR', 2, '|f_es_BMF|', 79115, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0127025031||es||False', false, '{NULL,F0GBR06015,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR EMPRESAS VOLUMEN', 'ES0169533033', 'EUR', 2, '|f_es_BMF|', 79116, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0169533033||es||False', false, '{NULL,F0GBR04OCH,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR ESTADOS UNIDOS', 'ES0133525032', 'EUR', 2, '|f_es_BMF|', 79118, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133525032||es||False', false, '{NULL,F0GBR04OPX,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR EUROPA DEL ESTE', 'ES0133554032', 'EUR', 2, '|f_es_BMF|', 75613, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133554032||es||False', false, '{NULL,F0GBR04KX4,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR EUROPA', 'ES0133555039', 'EUR', 2, '|f_es_BMF|', 79119, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133555039||es||False', false, '{NULL,F0GBR04OPZ,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR EUROPA PROTECCION, FI', 'ES0133845034', 'EUR', 2, '|f_es_BMF|', 77468, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133845034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR FONDEPOSITO PLUS', 'ES0127026005', 'EUR', 2, '|f_es_BMF|', 75649, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0127026005||es||False', false, '{NULL,F000001WF5,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR GARAN. GLOBAL', 'ES0133563033', 'EUR', 2, '|f_es_BMF|', 80180, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133563033||es||False', false, '{NULL,F0GBR06UB2,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR GARAN.MAS PROTECCION', 'ES0133502031', 'EUR', 2, '|f_es_BMF|', 79103, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133502031||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR GARAN.RENTA FIJA', 'ES0133544009', 'EUR', 2, '|f_es_BMF|', 79106, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133544009||es||False', false, '{NULL,F000002T5C,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR GARANT.EXTRASELECCION', 'ES0133662033', 'EUR', 2, '|f_es_BMF|', 79120, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133662033||es||False', false, '{NULL,F0GBR04KX6,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR GARANTIZADO CESTA SELECCION', 'ES0127027003', 'EUR', 2, '|f_es_BMF|', 75659, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0127027003||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR GARANTIZADO CRECIMIENTO', 'ES0133527038', 'EUR', 2, '|f_es_BMF|', 79121, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133527038||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR GARANTIZADO DOLAR', 'ES0127024034', 'EUR', 2, '|f_es_BMF|', 79122, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0127024034||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR GARANTIZADO ELECCION USA', 'ES0133557035', 'EUR', 2, '|f_es_BMF|', 79092, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133557035||es||False', false, '{NULL,F0GBR04O1M,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR GARANTIZADO ELITE', 'ES0133504037', 'EUR', 2, '|f_es_BMF|', 75660, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133504037||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR GARANTIZADO EMERGENTES, FI', 'ES0133517005', 'EUR', 2, '|f_es_BMF|', 79094, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133517005||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR GARANTIZADO EUROCONSOLIDACION', 'ES0170260030', 'EUR', 2, '|f_es_BMF|', 75655, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0170260030||es||False', false, '{NULL,F0000001UD,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR GARANTIZADO MUNDIAL', 'ES0133543001', 'EUR', 2, '|f_es_BMF|', 75695, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133543001||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR GARANTIZADO ORO', 'ES0133580003', 'EUR', 2, '|f_es_BMF|', 75708, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133580003||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR GARANTIZADO ORO II', 'ES0133516007', 'EUR', 2, '|f_es_BMF|', 79123, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133516007||es||False', false, '{NULL,F000000KSB,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR GARANT.REC.NATURALES', 'ES0133542037', 'EUR', 2, '|f_es_BMF|', 77462, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133542037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR GAR.PROYEC.EUROPA', 'ES0133562035', 'EUR', 2, '|f_es_BMF|', 75656, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133562035||es||False', false, '{NULL,F0GBR06UAE,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR GLOBAL CONVERTIBLES', 'ES0133579005', 'EUR', 2, '|f_es_BMF|', 79124, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133579005||es||False', false, '{NULL,F000000R6V,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR IBEROAMERICA', 'ES0133576035', 'EUR', 2, '|f_es_BMF|', 75321, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133576035||es||False', false, '{NULL,F0GBR04KXA,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR JAPON', 'ES0133663031', 'EUR', 2, '|f_es_BMF|', 79147, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133663031||es||False', false, '{NULL,F0GBR04KXC,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR MIXTO-15', 'ES0138987039', 'EUR', 2, '|f_es_BMF|', 75710, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138987039||es||False', false, '{NULL,F0GBR04Q7N,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR MIXTO-30', 'ES0133745036', 'EUR', 2, '|f_es_BMF|', 79150, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133745036||es||False', false, '{NULL,F0GBR04Q7B,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR MIXTO-50', 'ES0133875031', 'EUR', 2, '|f_es_BMF|', 79151, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133875031||es||False', false, '{NULL,F0GBR04Q7G,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR MIXTO-70', 'ES0133865032', 'EUR', 2, '|f_es_BMF|', 79155, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133865032||es||False', false, '{NULL,F0GBR04Q7J,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR PARTICULARES VOLUMEN FI CL. I', 'ES0133877003', 'EUR', 2, '|f_es_BMF|', 77510, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133877003||es||False', false, '{NULL,F000005H38,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR PARTIC.VOLUMEN FI CLASE A', 'ES0133877037', 'EUR', 2, '|f_es_BMF|', 79156, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133877037||es||False', false, '{NULL,F0GBR04KXG,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR PATRIMONIO', 'ES0133617037', 'EUR', 2, '|f_es_BMF|', 75714, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133617037||es||False', false, '{NULL,F0GBR04Q7Q,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR RECURSOS NATURALES', 'ES0133623001', 'EUR', 2, '|f_es_BMF|', 75688, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133623001||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR RENTA FIJA CORTO', 'ES0138986031', 'EUR', 2, '|f_es_BMF|', 75767, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138986031||es||False', false, '{NULL,F0GBR04Q7Z,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR RENTA FIJA', 'ES0133864035', 'EUR', 2, '|f_es_BMF|', 75761, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133864035||es||False', false, '{NULL,F0GBR04Q7M,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR RENTA FIJA INTERNAC.', 'ES0138966033', 'EUR', 2, '|f_es_BMF|', 77511, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138966033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR RENTABILIDAD GLOBAL', 'ES0133560039', 'EUR', 2, '|f_es_BMF|', 79159, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133560039||es||False', false, '{NULL,F0GBR05XMS,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR RV EMERGENTES GLOBAL', 'ES0133561037', 'EUR', 2, '|f_es_BMF|', 77513, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133561037||es||False', false, '{NULL,F0GBR069VW,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR SECTOR INMOBILIARIO', 'ES0133612038', 'EUR', 2, '|f_es_BMF|', 75768, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0133612038||es||False', false, '{NULL,F0GBR04Q7O,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUROVALOR TESORERIA', 'ES0138985033', 'EUR', 2, '|f_es_BMF|', 75771, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138985033||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EUTELSAT COMMUNIC.', 'FR0010221234', 'EUR', 1, '|EURONEXT|', 77830, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010221234||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EVERCORE PARTNERS INC. CL A', NULL, 'USD', 1, '', 78693, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#EVR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EVEREST RE GROUP LTD.', NULL, 'USD', 1, '', 76462, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#RE||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EVOTEC AG', 'DE0005664809', 'EUR', 1, '|DEUTSCHEBOERSE|', 81171, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005664809||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EVS BROADC.EQUIPM.', 'BE0003820371', 'EUR', 1, '|EURONEXT|', 74896, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003820371||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('E.W. SCRIPPS CO. CL A', NULL, 'USD', 1, '', 80325, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#SSP||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EXACOMPTA CLAIREF.', 'FR0000064164', 'EUR', 1, '|EURONEXT|', 78421, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000064164||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EXACT HOLDING', 'NL0000350361', 'EUR', 1, '|EURONEXT|', 75251, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0000350361||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EXAMWORKS GROUP INC.', NULL, 'USD', 1, '', 79774, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#EXAM||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EXCEET GROUP SE', 'LU0472835155', 'EUR', 1, '|DEUTSCHEBOERSE|', 81172, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#LU0472835155||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EXCEL MARITIME CARRIERS LTD.', NULL, 'USD', 1, '', 81634, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#EXM||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EXCEL TRUST INC.', NULL, 'USD', 1, '', 79771, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#EXL||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EXCO RESOURCES INC.', NULL, 'USD', 1, '', 81622, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#XCO||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EXEL INDUSTRIES', 'FR0004527638', 'EUR', 1, '|EURONEXT|', 75935, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0004527638||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EXELIS INC.', NULL, 'USD', 1, '', 78998, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#XLS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EXELON CORP.', NULL, 'USD', 1, '', 78947, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#EXC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EXMAR', 'BE0003808251', 'EUR', 1, '|EURONEXT|', 75237, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003808251||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EXMAR STR VVPR (D)', 'BE0005633079', 'EUR', 1, '|EURONEXT|', 75239, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0005633079||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EXPEDIA, INC', 'US30212P1057', 'USD', 1, '|NASDAQ100|', 76281, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'EXPE||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EXPEDITORS INTERNATIONAL OF WASHINGTON INC. ', 'US3021301094', 'USD', 1, '|NASDAQ100|', 76275, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'EXPD||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EXPLOSIFS PROD.CHI', 'FR0000039026', 'EUR', 1, '|EURONEXT|', 78423, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000039026||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EXPLOS.PROD.CHI.PF', 'FR0000037343', 'EUR', 1, '|EURONEXT|', 78422, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000037343||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EXPRESS INC.', NULL, 'USD', 1, '', 75551, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#EXPR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EXPRESS SCRIPTS, INC', 'US3021821000', 'USD', 1, '|NASDAQ100|', 75277, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'ESRX||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EXTERRAN HOLDINGS INC.', NULL, 'USD', 1, '', 77986, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#EXH||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EXTRA SPACE STORAGE INC.', NULL, 'USD', 1, '', 77506, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#EXR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EXTRAFONDO BANESTO', 'ES0134676032', 'EUR', 2, '|f_es_BMF|', 75772, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0134676032||es||False', false, '{NULL,F0GBR04JYC,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EXXON MOBIL CORP.', NULL, 'USD', 1, '', 75085, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#XOM||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('EZENTIS', 'ES0172708317', 'EUR', 1, '|MERCADOCONTINUO|', 78869, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0172708317||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FABASOFT AG', 'AT0000785407', 'EUR', 1, '|DEUTSCHEBOERSE|', 81173, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#AT0000785407||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FABRINET', NULL, 'USD', 1, '', 80312, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FN||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FACTSET RESEARCH SYSTEMS INC.', NULL, 'USD', 1, '', 76188, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FDS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FAES FARMA', 'ES0134950F36', 'EUR', 1, '|MERCADOCONTINUO|', 78238, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0134950F36||es||False', false, '{FAE.MC,NULL,BME:FAE,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FAIR ISAAC CORP.', NULL, 'USD', 1, '', 79154, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FICO||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FAIR VALUE REIT-AG', 'DE000A0MW975', 'EUR', 1, '|DEUTSCHEBOERSE|', 81174, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE000A0MW975||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FAIRCHILD SEMICONDUCTOR INTERNATIONAL INC.', NULL, 'USD', 1, '', 77657, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FCS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FAIVELEY TRANSPORT', 'FR0000053142', 'EUR', 1, '|EURONEXT|', 79177, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000053142||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FALA', 'FR0000064222', 'EUR', 1, '|EURONEXT|', 74792, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000064222||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FAMILY DOLLAR STORES INC.', NULL, 'USD', 1, '', 75627, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FDO||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FASTENAL COMPANY', 'US3119001044', 'USD', 1, '|NASDAQ100|', 76499, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'FAST||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FAURECIA', 'FR0000121147', 'EUR', 1, '|EURONEXT|', 80438, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000121147||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FAUVET GIREL', 'FR0000063034', 'EUR', 1, '|EURONEXT|', 80439, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000063034||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FAYENC.SARREGUEMI.', 'FR0000031973', 'EUR', 1, '|EURONEXT|', 80440, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000031973||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FBL FINANCIAL GROUP INC.', NULL, 'USD', 1, '', 79686, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FFG||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FCC', 'ES0122060314', 'EUR', 1, '|MERCADOCONTINUO|', 78907, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0122060314||es||False', false, '{FCC.MC,NULL,BME:FCC,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FDL', 'FR0000030181', 'EUR', 1, '|EURONEXT|', 78388, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000030181||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FEDERAL AGRICULTURAL MORTGAGE CORP. CL C', NULL, 'USD', 1, '', 80046, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AGM||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FEDERAL REALTY INVESTMENT TRUST', NULL, 'USD', 1, '', 78310, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FRT||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FEDERAL SIGNAL CORP.', NULL, 'USD', 1, '', 79814, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FSS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FEDERATED INVESTORS INC.', NULL, 'USD', 1, '', 78738, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FII||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FEDEX CORP.', NULL, 'USD', 1, '', 78086, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FDX||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FEIHE INTERNATIONAL INC.', NULL, 'USD', 1, '', 81065, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ADY||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FELCOR LODGING TRUST INC.', NULL, 'USD', 1, '', 80916, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FCH||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FERM.CAS.MUN.CANNE', 'FR0000062101', 'EUR', 1, '|EURONEXT|', 80449, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000062101||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FERRO CORP.', NULL, 'USD', 1, '', 79602, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FOE||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FERROVIAL', 'ES0118900010', 'EUR', 1, '|IBEX|MERCADOCONTINUO|', 78908, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0118900010||es||False', false, '{FER.MC,NULL,BME:FER,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FERSA', 'ES0136463017', 'EUR', 1, '|MERCADOCONTINUO|', 78962, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0136463017||es||False', false, '{FRS.MC,NULL,BME:FRS,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FFP', 'FR0000064784', 'EUR', 1, '|EURONEXT|', 80485, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000064784||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('F.GARAN.CONFIANZA VI CAJA MURCIA', 'ES0139776035', 'EUR', 2, '|f_es_BMF|', 79161, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0139776035||es||False', false, '{NULL,F0000001T1,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('F.GAR.CONFIANZA XI CAJA MURCIA', 'ES0138082005', 'EUR', 2, '|f_es_BMF|', 79160, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138082005||es||False', false, '{NULL,F000000E7H,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FIAT SPA EPAR.RGP', 'IT0001976429', 'EUR', 1, '|EURONEXT|', 76131, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#IT0001976429||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FIAT SPA ORD.RGP', 'IT0001976403', 'EUR', 1, '|EURONEXT|', 80489, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#IT0001976403||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FIAT SPA PRIV.RGP', 'IT0001976411', 'EUR', 1, '|EURONEXT|', 76138, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#IT0001976411||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FIBRIA CELULOSE S.A.', NULL, 'USD', 1, '', 79125, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FBR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FIDEFONDO', 'ES0137631034', 'EUR', 2, '|f_es_BMF|', 77145, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137631034||es||False', false, '{NULL,F0GBR04JQP,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FIDELITY NATIONAL FINANCIAL INC.', NULL, 'USD', 1, '', 76504, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FNF||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FIDELITY NATIONAL INFORMATION SERVICES INC.', NULL, 'USD', 1, '', 76759, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FIS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FIDUCIAL OFF.SOL.', 'FR0000061418', 'EUR', 1, '|EURONEXT|', 75306, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000061418||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FIDUCIAL REAL EST.', 'FR0000060535', 'EUR', 1, '|EURONEXT|', 76513, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000060535||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FIELMANN AG', 'DE0005772206', 'EUR', 1, '|DEUTSCHEBOERSE|', 81175, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005772206||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FIMALAC', 'FR0000037947', 'EUR', 1, '|EURONEXT|', 75936, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000037947||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FIMAP', 'ES0137603009', 'EUR', 2, '|f_es_BMF|', 79162, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137603009||es||False', false, '{NULL,F00000HLGA,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FINANCIALFOND', 'ES0169009034', 'EUR', 2, '|f_es_BMF|', 79367, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0169009034||es||False', false, '{NULL,F0GBR04IZA,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FINANCIERE MARJOS', 'FR0000060824', 'EUR', 1, '|EURONEXT|', 75307, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000060824||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FINANCIERE ODET', 'FR0000062234', 'EUR', 1, '|EURONEXT|', 76326, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000062234||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FINATIS', 'FR0000035123', 'EUR', 1, '|EURONEXT|', 77207, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000035123||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FIN.ETANG BERRE', 'FR0000062341', 'EUR', 1, '|EURONEXT|', 75634, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000062341||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FIN.ETANG BERRE PF', 'FR0000062507', 'EUR', 1, '|EURONEXT|', 75635, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000062507||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FIN.OUEST AFRICAIN', 'SN0000033192', 'EUR', 1, '|EURONEXT|', 79941, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#SN0000033192||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FIPP', 'FR0000038184', 'EUR', 1, '|EURONEXT|', 79945, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000038184||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FIRST ACCEPTANCE CORP.', NULL, 'USD', 1, '', 81068, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FAC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FIRST AMERICAN FINANCIAL CORP.', NULL, 'USD', 1, '', 79109, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FAF||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FIRST BANCORP (PUERTO RICO)', NULL, 'USD', 1, '', 81018, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FBP||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FIRST COMMONWEALTH FINANCIAL CORP. (PENNSYLVANIA)', NULL, 'USD', 1, '', 79600, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FCF||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FIRST HORIZON NATIONAL CORP.', NULL, 'USD', 1, '', 77512, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FHN||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FIRST INDUSTRIAL REALTY TRUST INC.', NULL, 'USD', 1, '', 77463, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FIRST MAJESTIC SILVER CORP.', NULL, 'USD', 1, '', 77651, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#AG||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FIRST MARBLEHEAD CORP.', NULL, 'USD', 1, '', 81019, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FMD||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FIRST POTOMAC REALTY TRUST', NULL, 'USD', 1, '', 78674, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FPO||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FIRST REPUBLIC BANK', NULL, 'USD', 1, '', 75519, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FRC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FIRST SENSOR AG', 'DE0007201907', 'EUR', 1, '|DEUTSCHEBOERSE|', 81176, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0007201907||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FIRST SOLAR, INC.', 'US3364331070', 'USD', 1, '|NASDAQ100|', 75843, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'FSLR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FIRSTENERGY CORP.', NULL, 'USD', 1, '', 77810, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FE||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FISERV, INC.', 'US3377381088', 'USD', 1, '|NASDAQ100|', 76132, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'FISV||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FISIPE', 'PTFSP0AE0004', 'EUR', 1, '|EURONEXT|', 75647, NULL, NULL, NULL, NULL, 100, 'c', 1, 9, 'EURONEXT#PTFSP0AE0004||pt||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FIVE STAR QUALITY CARE INC.', NULL, 'USD', 1, '', 77419, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FVE||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FLAGSTAR BANCORP INC.', NULL, 'USD', 1, '', 81009, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FBC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FLAGSTONE REINSURANCE HOLDINGS LTD.', NULL, 'USD', 1, '', 79702, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FSR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FLEETCOR TECHNOLOGIES INC.', NULL, 'USD', 1, '', 78113, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FLT||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FLEURY MICHON', 'FR0000074759', 'EUR', 1, '|EURONEXT|', 75942, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000074759||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FLEXTRONICS INTERNATIONAL LTD.', 'SG9999000020', 'USD', 1, '|NASDAQ100|', 76019, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'FLEX||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FLIR SYSTEMS, INC.', 'US3024451011', 'USD', 1, '|NASDAQ100|', 75279, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'FLIR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FLORIDIENNE', 'BE0003215143', 'EUR', 1, '|EURONEXT|', 75299, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003215143||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FLOTEK INDUSTRIES INC.', NULL, 'USD', 1, '', 80906, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FTK||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FLOWERS FOODS INC.', NULL, 'USD', 1, '', 78925, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FLO||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FLOWSERVE CORP.', NULL, 'USD', 1, '', 75093, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FLS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FLUIDRA', 'ES0137650018', 'EUR', 1, '|MERCADOCONTINUO|', 78964, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0137650018||es||False', false, '{FDR.MC,NULL,BME:FDR,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FLUOR CORP.', NULL, 'USD', 1, '', 77792, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FLR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FLUXYS CAT.D', 'BE0003803203', 'EUR', 1, '|EURONEXT|', 79431, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003803203||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FLY LEASING LTD.', NULL, 'USD', 1, '', 79780, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FLY||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FMC CORP.', NULL, 'USD', 1, '', 74789, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FMC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FMC TECHNOLOGIES INC.', NULL, 'USD', 1, '', 75751, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FTI||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('F.N.B. CORP.', NULL, 'USD', 1, '', 78809, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FNB||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FOCAIXA EQUILIBRIO', 'ES0138188034', 'EUR', 2, '|f_es_BMF|', 75187, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138188034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FOMODI', 'ES0138782034', 'EUR', 2, '|f_es_BMF|', 75774, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138782034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FON FINECO AHORRO', 'ES0175605031', 'EUR', 2, '|f_es_BMF|', 79140, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0175605031||es||False', false, '{NULL,F0GBR04Q49,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FON FINECO BEST', 'ES0137881035', 'EUR', 2, '|f_es_BMF|', 79188, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137881035||es||False', false, '{NULL,F0GBR06UBQ,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FON FINECO DINERO', 'ES0107499032', 'EUR', 2, '|f_es_BMF|', 79191, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0107499032||es||False', false, '{NULL,F0GBR04Q48,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FON FINECO EURO LIDER', 'ES0138584034', 'EUR', 2, '|f_es_BMF|', 79193, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138584034||es||False', false, '{NULL,F0GBR04Q4B,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FON FINECO EXCEL', 'ES0137651008', 'EUR', 2, '|f_es_BMF|', 77524, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137651008||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FON FINECO GESTION', 'ES0138382033', 'EUR', 2, '|f_es_BMF|', 77559, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138382033||es||False', false, '{NULL,F0GBR04Q4E,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FON FINECO I', 'ES0138783032', 'EUR', 2, '|f_es_BMF|', 77561, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138783032||es||False', false, '{NULL,F0GBR04Q47,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FON FINECO INTERES A', 'ES0164814008', 'EUR', 2, '|f_es_BMF|', 75362, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0164814008||es||False', false, '{NULL,F000005K6I,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FON FINECO INTERES I', 'ES0164814016', 'EUR', 2, '|f_es_BMF|', 79682, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0164814016||es||False', false, '{NULL,F000005K6J,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FON FINECO OPTIMUM GARANTIZADO', 'ES0138391034', 'EUR', 2, '|f_es_BMF|', 75694, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138391034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FON FINECO TOP RENTA FIJA A', 'ES0137639003', 'EUR', 2, '|f_es_BMF|', 79194, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137639003||es||False', false, '{NULL,F00000J85F,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FON FINECO TOP RENTA FIJA I', 'ES0137639011', 'EUR', 2, '|f_es_BMF|', 79195, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137639011||es||False', false, '{NULL,F00000J85G,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FON FINECO VALOR', 'ES0176236034', 'EUR', 2, '|f_es_BMF|', 79196, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0176236034||es||False', false, '{NULL,F0GBR04Q4G,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONALAVA', 'ES0138591039', 'EUR', 2, '|f_es_BMF|', 79719, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138591039||es||False', false, '{NULL,F0GBR04JDU,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONALCALA', 'ES0138932035', 'EUR', 2, '|f_es_BMF|', 79731, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138932035||es||False', false, '{NULL,F0GBR04J08,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONBILBAO ACCIONES', 'ES0126906033', 'EUR', 2, '|f_es_BMF|', 79759, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0126906033||es||False', false, '{NULL,F0GBR04JCW,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONBILBAO DINERO', 'ES0138812039', 'EUR', 2, '|f_es_BMF|', 80220, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138812039||es||False', false, '{NULL,F0GBR04JD0,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONBILBAO EUROBOLSA', 'ES0138437035', 'EUR', 2, '|f_es_BMF|', 80221, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138437035||es||False', false, '{NULL,F0GBR04JD4,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONBILBAO GLOBAL 50', 'ES0138321031', 'EUR', 2, '|f_es_BMF|', 80222, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138321031||es||False', false, '{NULL,F0GBR04JDC,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONBILBAO INTERNACIONAL', 'ES0138701034', 'EUR', 2, '|f_es_BMF|', 80223, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138701034||es||False', false, '{NULL,F0GBR04JD2,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONBILBAO MIXTO', 'ES0138478039', 'EUR', 2, '|f_es_BMF|', 80224, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138478039||es||False', false, '{NULL,F0GBR04JD6,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONBILBAO RENTA FIJA', 'ES0138333036', 'EUR', 2, '|f_es_BMF|', 80225, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138333036||es||False', false, '{NULL,F0GBR04JD8,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONBUSA', 'ES0138784030', 'EUR', 2, '|f_es_BMF|', 80240, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138784030||es||False', false, '{NULL,F0GBR04J1O,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONBUSA FONDOS', 'ES0138438033', 'EUR', 2, '|f_es_BMF|', 80226, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138438033||es||False', false, '{NULL,F0GBR04J1S,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONBUSA MIXTO', 'ES0138592037', 'EUR', 2, '|f_es_BMF|', 80277, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138592037||es||False', false, '{NULL,F0GBR04J1Q,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONC EUR LOGISTIQ', 'FR0000064305', 'EUR', 1, '|EURONEXT|', 79437, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000064305||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAFIX', 'ES0138806031', 'EUR', 2, '|f_es_BMF|', 75474, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138806031||es||False', false, '{NULL,F0GBR04J1U,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA 1 R.F. CORTO DOLAR', 'ES0138807039', 'EUR', 2, '|f_es_BMF|', 79198, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138807039||es||False', false, '{NULL,F0GBR04Q3U,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA 102 CARTERA TESORERIA E', 'ES0137801033', 'EUR', 2, '|f_es_BMF|', 78075, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137801033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA 103 FONDANDALUCIA', 'ES0138062031', 'EUR', 2, '|f_es_BMF|', 75802, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138062031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA 113 CARTERA BOLSA EURO', 'ES0137973030', 'EUR', 2, '|f_es_BMF|', 79238, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137973030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA 114 CARTERA BOLSA USA', 'ES0137967032', 'EUR', 2, '|f_es_BMF|', 79251, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137967032||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA 117 CARTERA BOLSA ESP.', 'ES0137974038', 'EUR', 2, '|f_es_BMF|', 79252, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137974038||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA 125 R.F.HIGH YIELD', 'ES0184922039', 'EUR', 2, '|f_es_BMF|', 79522, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0184922039||es||False', false, '{NULL,F0GBR05V2B,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA 126 RENTA FIJA EMERGENT', 'ES0137916039', 'EUR', 2, '|f_es_BMF|', 79523, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137916039||es||False', false, '{NULL,F0GBR05V0T,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA 127 RENTA FIJA DOS AÑOS', 'ES0137979037', 'EUR', 2, '|f_es_BMF|', 79524, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137979037||es||False', false, '{NULL,F0GBR05TCE,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA 129 DIVID.BOLSA EUROPA', 'ES0184923037', 'EUR', 2, '|f_es_BMF|', 79525, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0184923037||es||False', false, '{NULL,F0GBR05U06,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA 134 GESTION DINAMICA V3', 'ES0138066032', 'EUR', 2, '|f_es_BMF|', 79528, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138066032||es||False', false, '{NULL,F0GBR06838,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA 137 GAR.CESTA 12 ACCS.', 'ES0184924035', 'EUR', 2, '|f_es_BMF|', 79330, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0184924035||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA 3 R.F. LARGO DOLAR', 'ES0138808037', 'EUR', 2, '|f_es_BMF|', 75809, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138808037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA 46 TESORERIA EURO', 'ES0138664034', 'EUR', 2, '|f_es_BMF|', 79800, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138664034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA 5 BOLSA EURO', 'ES0138792033', 'EUR', 2, '|f_es_BMF|', 79820, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138792033||es||False', false, '{NULL,F0GBR04Q0X,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA 52 BOLSA GESTION EURO', 'ES0138702032', 'EUR', 2, '|f_es_BMF|', 75952, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138702032||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA 53 BOLSA USA', 'ES0138615036', 'EUR', 2, '|f_es_BMF|', 79821, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138615036||es||False', false, '{NULL,F0GBR04Q0Y,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA 55 BOLSA JAPON', 'ES0122056031', 'EUR', 2, '|f_es_BMF|', 75861, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0122056031||es||False', false, '{NULL,F0GBR04Q10,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA 61 BOLSA TECNOLOGIA', 'ES0138322039', 'EUR', 2, '|f_es_BMF|', 76949, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138322039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA 65 BOLSA INDICE ESPAÑA', 'ES0138392032', 'EUR', 2, '|f_es_BMF|', 75862, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138392032||es||False', false, '{NULL,F0GBR04Q0T,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA 66 BOLSA INDICE SUIZA', 'ES0138383031', 'EUR', 2, '|f_es_BMF|', 77470, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138383031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA 67 RENTA FIJA LARGO EUR', 'ES0138384039', 'EUR', 2, '|f_es_BMF|', 75864, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138384039||es||False', false, '{NULL,F0GBR04DPB,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA 72 BOLSA PAISES EMERGEN', 'ES0138328036', 'EUR', 2, '|f_es_BMF|', 79255, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138328036||es||False', false, '{NULL,F0GBR04JUK,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA 75 GLOBAL', 'ES0138257037', 'EUR', 2, '|f_es_BMF|', 75865, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138257037||es||False', false, '{NULL,F0GBR04JUE,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA 86 GARANT.RENTA FIJA', 'ES0138219037', 'EUR', 2, '|f_es_BMF|', 79257, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138219037||es||False', false, '{NULL,F0GBR04JUA,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA 90 CESTA MIXTA 75 RV', 'ES0138171030', 'EUR', 2, '|f_es_BMF|', 75951, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138171030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA 92 GARANT. INDICES MUND', 'ES0138176039', 'EUR', 2, '|f_es_BMF|', 79260, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138176039||es||False', false, '{NULL,F0GBR04JUW,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA 93 FON.BOLSAS MUNDIALES', 'ES0138172038', 'EUR', 2, '|f_es_BMF|', 79266, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138172038||es||False', false, '{NULL,F0GBR04ONP,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA 94 FONDOS BOLSA EURO', 'ES0138181039', 'EUR', 2, '|f_es_BMF|', 79541, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138181039||es||False', false, '{NULL,F0GBR04ONR,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA 95 TESOR.EURO', 'ES0138086030', 'EUR', 2, '|f_es_BMF|', 79547, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138086030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA 96 FONDOS BOLSA USA', 'ES0138189032', 'EUR', 2, '|f_es_BMF|', 79559, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138189032||es||False', false, '{NULL,F0GBR04ONT,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA ALBUS', 'ES0107678007', 'EUR', 2, '|f_es_BMF|', 79560, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0107678007||es||False', false, '{NULL,F000002Q3S,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA ASEGURADO', 'ES0137640001', 'EUR', 2, '|f_es_BMF|', 79561, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137640001||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA BANCA PERS.BOLSA GLOBAL', 'ES0137652006', 'EUR', 2, '|f_es_BMF|', 77550, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137652006||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA BIENVENIDA', 'ES0137653004', 'EUR', 2, '|f_es_BMF|', 79562, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137653004||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA BOLSA 54', 'ES0182824039', 'EUR', 2, '|f_es_BMF|', 77380, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0182824039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA BOLSA ESPANA 150', 'ES0137878031', 'EUR', 2, '|f_es_BMF|', 79563, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137878031||es||False', false, '{NULL,F0GBR06HFU,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA BOLSA EURO', 'ES0138133030', 'EUR', 2, '|f_es_BMF|', 75903, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138133030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA BOLSA EUROPA OPORTUNIDA', 'ES0138068038', 'EUR', 2, '|f_es_BMF|', 75904, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138068038||es||False', false, '{NULL,FOGBR05KU9,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA BOLSA GESTION EURO', 'ES0137802031', 'EUR', 2, '|f_es_BMF|', 75312, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137802031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA BOLSA SECTOR SALUD', 'ES0137817005', 'EUR', 2, '|f_es_BMF|', 76016, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137817005||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA BOLSA SUDESTE ASIATICO', 'ES0138137031', 'EUR', 2, '|f_es_BMF|', 79423, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138137031||es||False', false, '{NULL,F0GBR06HG5,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA BOLSA USA', 'ES0138113032', 'EUR', 2, '|f_es_BMF|', 79424, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138113032||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA CAR.GEST.INTER.', 'ES0137696003', 'EUR', 2, '|f_es_BMF|', 75906, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137696003||es||False', false, '{NULL,F000000E7E,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA CARTERA DINAMICO V3', 'ES0137695039', 'EUR', 2, '|f_es_BMF|', 76961, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137695039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA CARTERA R.F.DURACION', 'ES0137806032', 'EUR', 2, '|f_es_BMF|', 75908, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137806032||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA CARTERA R.F.EMERGENTES', 'ES0138012036', 'EUR', 2, '|f_es_BMF|', 75909, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138012036||es||False', false, '{NULL,FOGBR05KUG,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA COOP. SOC. RESP. EUROPA FI', 'ES0138074036', 'EUR', 2, '|f_es_BMF|', 74978, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138074036||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA DINERO 6', 'ES0138793031', 'EUR', 2, '|f_es_BMF|', 79183, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138793031||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA ESTABILIDAD', 'ES0137655009', 'EUR', 2, '|f_es_BMF|', 79267, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137655009||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA ESTABILIDAD PLUS', 'ES0137641009', 'EUR', 2, '|f_es_BMF|', 79272, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137641009||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA FONSTRESOR CATALUNYA 59', 'ES0122057039', 'EUR', 2, '|f_es_BMF|', 79483, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0122057039||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA GARAN.EUROPA PROT.IX', 'ES0137697001', 'EUR', 2, '|f_es_BMF|', 77435, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137697001||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA GARAN.RENTA FIJA PLUS 7', 'ES0137785004', 'EUR', 2, '|f_es_BMF|', 79577, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137785004||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA GARANT.GESTIONADO 119', 'ES0137804037', 'EUR', 2, '|f_es_BMF|', 79583, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137804037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA GARANTIA ACTIVA', 'ES0137924033', 'EUR', 2, '|f_es_BMF|', 76970, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137924033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA GARANTIA DOBLE DIRECCIO', 'ES0137775005', 'EUR', 2, '|f_es_BMF|', 76862, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137775005||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA GARANTIA EMERGENTES', 'ES0138069036', 'EUR', 2, '|f_es_BMF|', 79611, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138069036||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA GARANTIA EMPRENDEDORES', 'ES0137685030', 'EUR', 2, '|f_es_BMF|', 79612, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137685030||es||False', false, '{NULL,F0000006PY,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA GARANTIA EURO DOLAR', 'ES0137784007', 'EUR', 2, '|f_es_BMF|', 79613, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137784007||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA GARANTIA EURO-DOLAR II', 'ES0137703007', 'EUR', 2, '|f_es_BMF|', 75920, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137703007||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA GARANTIA IBEX PROTECCIO', 'ES0106192034', 'EUR', 2, '|f_es_BMF|', 79614, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0106192034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA GARANTIA RENTA FIJA 11', 'ES0137677003', 'EUR', 2, '|f_es_BMF|', 79658, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137677003||es||False', false, '{NULL,F000000ASC,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA GARANTIA RENTA FIJA 15', 'ES0137787000', 'EUR', 2, '|f_es_BMF|', 79659, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137787000||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA GARANTIA RENTA FIJA 19', 'ES0137687002', 'EUR', 2, '|f_es_BMF|', 75327, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137687002||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA GARANTIA RENTA FIJA 23', 'ES0137786002', 'EUR', 2, '|f_es_BMF|', 75364, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137786002||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA GARANTIA RENTA FIJA 24', 'ES0137776003', 'EUR', 2, '|f_es_BMF|', 79908, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137776003||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA GARANTIA R.F. PLUS 2', 'ES0137689008', 'EUR', 2, '|f_es_BMF|', 79656, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137689008||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA GARANTIA R.F. PLUS 3', 'ES0137698009', 'EUR', 2, '|f_es_BMF|', 79657, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137698009||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA GAR.EUROPA PROT. VI', 'ES0137706034', 'EUR', 2, '|f_es_BMF|', 79485, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137706034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA GAR.EUROPA PROTECCION 7', 'ES0145455004', 'EUR', 2, '|f_es_BMF|', 79529, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0145455004||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA GAR.EUROPA PROTECCION 8', 'ES0137686004', 'EUR', 2, '|f_es_BMF|', 79530, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137686004||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA GAR.EUROPA PROTECCION V', 'ES0137727030', 'EUR', 2, '|f_es_BMF|', 79608, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137727030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA GAR.OPORT.EMERGENTE II', 'ES0137701001', 'EUR', 2, '|f_es_BMF|', 79609, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137701001||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA GAR.OPORT.EMERGENTE III', 'ES0137702009', 'EUR', 2, '|f_es_BMF|', 75687, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137702009||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA GAR.OPORTUNIDAD EMERGEN', 'ES0137783009', 'EUR', 2, '|f_es_BMF|', 79610, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137783009||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA GESTION ALTERNATIVA V6', 'ES0145456002', 'EUR', 2, '|f_es_BMF|', 77189, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0145456002||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA GESTION ESTRELLA E2', 'ES0137981033', 'EUR', 2, '|f_es_BMF|', 79909, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137981033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA GRANDES EMPRESAS', 'ES0145457000', 'EUR', 2, '|f_es_BMF|', 79660, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0145457000||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA MONETARIO EURO DEUDA II', 'ES0105167037', 'EUR', 2, '|f_es_BMF|', 79654, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0105167037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA OBJETIVO JUNIO 2012', 'ES0137681005', 'EUR', 2, '|f_es_BMF|', 79662, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137681005||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA OPORTUNIDAD CLASE ESTANDAR', 'ES0164948004', 'EUR', 2, '|f_es_BMF|', 79683, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0164948004||es||False', false, '{NULL,F00000LXRX,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA OPORTUNIDAD CLASE PLUS', 'ES0164948038', 'EUR', 2, '|f_es_BMF|', 79687, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0164948038||es||False', false, '{NULL,F0GBR04JO4,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA PATRIMONIO 16', 'ES0138653037', 'EUR', 2, '|f_es_BMF|', 75359, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138653037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA PATRIMONIO 35', 'ES0115421036', 'EUR', 2, '|f_es_BMF|', 75395, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115421036||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA PERSONAL TESORERIA EURO', 'ES0137879039', 'EUR', 2, '|f_es_BMF|', 79698, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137879039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA PRIVADA AHORRO', 'ES0105181038', 'EUR', 2, '|f_es_BMF|', 79677, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0105181038||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA PRIVADA BOLSA', 'ES0105182036', 'EUR', 2, '|f_es_BMF|', 79733, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0105182036||es||False', false, '{NULL,F0GBR04PXA,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA PRIVADA BOLSA INTERNAC.', 'ES0115062038', 'EUR', 2, '|f_es_BMF|', 76838, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115062038||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA PRIVADA BOLSAPLUS', 'ES0105188033', 'EUR', 2, '|f_es_BMF|', 75597, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0105188033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA PRIVADA ESTRATEGIA HEDG', 'ES0164463004', 'EUR', 2, '|f_es_BMF|', 77190, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0164463004||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA PRIVADA EURO ACCIONES', 'ES0105008033', 'EUR', 2, '|f_es_BMF|', 77528, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0105008033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA PRIVADA EURO DEUDA', 'ES0105003034', 'EUR', 2, '|f_es_BMF|', 79935, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0105003034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA PRIVADA EURO SELECCION', 'ES0106193032', 'EUR', 2, '|f_es_BMF|', 79946, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0106193032||es||False', false, '{NULL,F0GBR04PXN,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA PRIVADA FONDO 25', 'ES0147623039', 'EUR', 2, '|f_es_BMF|', 75258, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'FONCAIXA PRIVADA FONDO 25||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA PRIVADA FONDO ACT.ETICO', 'ES0138516036', 'EUR', 2, '|f_es_BMF|', 79951, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138516036||es||False', false, '{NULL,F0GBR04PXT,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA PRIVADA FONDO', 'ES0105002036', 'EUR', 2, '|f_es_BMF|', 79949, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0105002036||es||False', false, '{NULL,F0GBR04PX3,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA PRIVADA FONT.LAR.PLAZO', 'ES0105185039', 'EUR', 2, '|f_es_BMF|', 79952, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0105185039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA PRIVADA GRA.CIAS 2010 G', 'ES0109648032', 'EUR', 2, '|f_es_BMF|', 79917, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0109648032||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA PRIVADA IDEAS', 'ES0164492003', 'EUR', 2, '|f_es_BMF|', 79735, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0164492003||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA PRIVADA MULTIG.ACT.EQUI', 'ES0164540033', 'EUR', 2, '|f_es_BMF|', 79739, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0164540033||es||False', false, '{NULL,F0GBR06GYM,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA PRIVADA MULTIG.ACT.ESTA', 'ES0164539035', 'EUR', 2, '|f_es_BMF|', 79740, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0164539035||es||False', false, '{NULL,F0GBR04NXT,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA PRIVADA MULTIG.ACT.OPOR', 'ES0164583033', 'EUR', 2, '|f_es_BMF|', 79741, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0164583033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA PRIVADA MULTIG.ACT.VARI', 'ES0106194030', 'EUR', 2, '|f_es_BMF|', 77444, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0106194030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA PRIVADA OPTIMO', 'ES0164524037', 'EUR', 2, '|f_es_BMF|', 79723, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0164524037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA PRIVADA RENTA INTERNACI', 'ES0173407034', 'EUR', 2, '|f_es_BMF|', 79732, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0173407034||es||False', false, '{NULL,F0GBR04PX7,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA RENTA FIJA LARGO DOLAR', 'ES0138089034', 'EUR', 2, '|f_es_BMF|', 79744, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138089034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA R.F. CORTO COLAR', 'ES0137993038', 'EUR', 2, '|f_es_BMF|', 79742, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137993038||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA R.F.PRIVADA CORTO PLAZO', 'ES0137896033', 'EUR', 2, '|f_es_BMF|', 79743, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137896033||es||False', false, '{NULL,F0GBR06GH4,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA TESORERIA EURO', 'ES0138045036', 'EUR', 2, '|f_es_BMF|', 79745, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138045036||es||False', false, '{NULL,F0GBR052LJ,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAIXA TESORERIA EURO PLUS', 'ES0137897031', 'EUR', 2, '|f_es_BMF|', 79776, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137897031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCAM', 'ES0138712031', 'EUR', 2, '|f_es_BMF|', 79775, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138712031||es||False', false, '{NULL,F0GBR04J5U,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCANARIAS INTERNACIONAL', 'ES0138204039', 'EUR', 2, '|f_es_BMF|', 79781, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138204039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONC.DES REGIONS', 'FR0000064578', 'EUR', 1, '|EURONEXT|', 79438, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000064578||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCESS FLEXIBLE', 'ES0164949002', 'EUR', 2, '|f_es_BMF|', 79783, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0164949002||es||False', false, '{NULL,F000002IK8,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCESS PATRIMONIO', 'ES0164493001', 'EUR', 2, '|f_es_BMF|', 79786, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0164493001||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCIER PARIS BS', 'FR0010980045', 'EUR', 1, '|EURONEXT|', 79442, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010980045||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCIER PARIS FRAN', 'FR0010304329', 'EUR', 1, '|EURONEXT|', 75308, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010304329||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCIER PARIS FRAN', 'FR0011167477', 'EUR', 1, '|EURONEXT|', 75014, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0011167477||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCIERE 6 ET 7', 'FR0010436329', 'EUR', 1, '|EURONEXT|', 79376, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010436329||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCIERE 7 INVEST', 'FR0000065930', 'EUR', 1, '|EURONEXT|', 76974, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000065930||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCIERE ATLAND', 'FR0000064362', 'EUR', 1, '|EURONEXT|', 79455, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000064362||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCIERE DES MURS', 'FR0000060303', 'EUR', 1, '|EURONEXT|', 75428, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000060303||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCIERE EURIS', 'FR0000038499', 'EUR', 1, '|EURONEXT|', 79456, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000038499||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCIERE INEA', 'FR0010341032', 'EUR', 1, '|EURONEXT|', 79457, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010341032||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCIERE LYONNAISE', 'FR0000033409', 'EUR', 1, '|EURONEXT|', 75438, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000033409||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCIERE MASSENA', 'FR0000037210', 'EUR', 1, '|EURONEXT|', 74904, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000037210||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCIERE R-PARIS', 'FR0000063265', 'EUR', 1, '|EURONEXT|', 75444, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000063265||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCIERE SEPRIC', 'FR0004031292', 'EUR', 1, '|EURONEXT|', 79458, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0004031292||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCIERE VOLTA', 'FR0000053944', 'EUR', 1, '|EURONEXT|', 78606, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000053944||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCINEAABSASEP12', 'FR0010964247', 'EUR', 1, '|EURONEXT|', 79459, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010964247||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCONSUL', 'ES0138785037', 'EUR', 2, '|f_es_BMF|', 75365, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138785037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONCUENTA', 'ES0138799038', 'EUR', 2, '|f_es_BMF|', 79787, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138799038||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDACOFAR', 'ES0138944030', 'EUR', 2, '|f_es_BMF|', 79790, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138944030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDANETO', 'ES0138772035', 'EUR', 2, '|f_es_BMF|', 75366, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138772035||es||False', false, '{NULL,F0GBR04JYO,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDAVILA GARANTIA 3', 'ES0138713039', 'EUR', 2, '|f_es_BMF|', 80278, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138713039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDCIRCULO RENTA FIJA', 'ES0138961034', 'EUR', 2, '|f_es_BMF|', 80280, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138961034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDCOYUNTURA', 'ES0138969037', 'EUR', 2, '|f_es_BMF|', 75370, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138969037||es||False', false, '{NULL,F0GBR04J1W,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDEMAR DE INVERSIONES', 'ES0138053030', 'EUR', 2, '|f_es_BMF|', 75408, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138053030||es||False', false, '{NULL,F0GBR04VV7,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDESPAÑA ACT.MONETARIOS FONDTE', 'ES0138054038', 'EUR', 2, '|f_es_BMF|', 79950, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138054038||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDESPAÑA ACUMULATIVO', 'ES0138656030', 'EUR', 2, '|f_es_BMF|', 79955, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138656030||es||False', false, '{NULL,F0GBR04Q51,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDESPAÑA AHORRO', 'ES0122065032', 'EUR', 2, '|f_es_BMF|', 79956, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0122065032||es||False', false, '{NULL,F0GBR04Q50,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDESPAÑA AUDAZ', 'ES0138173036', 'EUR', 2, '|f_es_BMF|', 79511, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138173036||es||False', false, '{NULL,F0GBR04M4S,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDESPAÑA BOLSA', 'ES0138587037', 'EUR', 2, '|f_es_BMF|', 79957, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138587037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDESPAÑA CATEDRALES FI', 'ES0138442035', 'EUR', 2, '|f_es_BMF|', 74979, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138442035||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDESPAÑA CONSERVADOR', 'ES0138046034', 'EUR', 2, '|f_es_BMF|', 80257, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138046034||es||False', false, '{NULL,F0GBR04GX8,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDESPAÑA CONSOLIDA 1', 'ES0182037038', 'EUR', 2, '|f_es_BMF|', 80258, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0182037038||es||False', false, '{NULL,F0GBR04EPR,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDESPAÑA CONSOLIDA 2', 'ES0138386034', 'EUR', 2, '|f_es_BMF|', 80259, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138386034||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDESPAÑA CONSOLIDA 3', 'ES0122066030', 'EUR', 2, '|f_es_BMF|', 80269, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0122066030||es||False', false, '{NULL,F0GBR04Q5F,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDESPAÑA CONSOLIDA 4', 'ES0182036030', 'EUR', 2, '|f_es_BMF|', 77491, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0182036030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDESPAÑA CRECIMIENTO', 'ES0138538030', 'EUR', 2, '|f_es_BMF|', 74980, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138538030||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDESPAÑA DINAMICO', 'ES0138666039', 'EUR', 2, '|f_es_BMF|', 80260, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138666039||es||False', false, '{NULL,F0GBR04Q56,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDESPAÑA DOLAR GARANTIZADO', 'ES0137813004', 'EUR', 2, '|f_es_BMF|', 80262, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137813004||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDESPAÑA EMERGENTES', 'ES0138443033', 'EUR', 2, '|f_es_BMF|', 79245, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138443033||es||False', false, '{NULL,F0GBR04JTS,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDESPAÑA EMPRENDEDOR', 'ES0138337037', 'EUR', 2, '|f_es_BMF|', 80266, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138337037||es||False', false, '{NULL,F0GBR04M4U,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDESPAÑA EMPRENDEDOR PLUS', 'ES0138657038', 'EUR', 2, '|f_es_BMF|', 80289, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138657038||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDESPAÑA EVOLUCION EUROPA GRAN', 'ES0137876001', 'EUR', 2, '|f_es_BMF|', 80268, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137876001||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDESPAÑA FONDTESORO', 'ES0138588035', 'EUR', 2, '|f_es_BMF|', 80273, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138588035||es||False', false, '{NULL,F0GBR04Q54,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDESPAÑA GARANTIZ. RENTA FIJA', 'ES0182038036', 'EUR', 2, '|f_es_BMF|', 79212, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0182038036||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDESPAÑA GARANTIZADO RENT.FIJA', 'ES0164584007', 'EUR', 2, '|f_es_BMF|', 80292, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0164584007||es||False', false, '{NULL,F0000024NF,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDESPAÑA GARANT.RENTA FIJA 2', 'ES0182039034', 'EUR', 2, '|f_es_BMF|', 79249, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0182039034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDESPAÑA GESTION ACT.GARANT 3', 'ES0138598034', 'EUR', 2, '|f_es_BMF|', 80293, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138598034||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDESPAÑA GESTION ACT.GARANT 5', 'ES0138724036', 'EUR', 2, '|f_es_BMF|', 80295, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138724036||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDESPAÑA GESTION ACTIVA GAR.2', 'ES0138039039', 'EUR', 2, '|f_es_BMF|', 80297, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138039039||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDESPAÑA GESTION ACTIVA GAR.4', 'ES0137939031', 'EUR', 2, '|f_es_BMF|', 80299, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137939031||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDESPAÑA GESTION ACTIVA GARANT', 'ES0138078037', 'EUR', 2, '|f_es_BMF|', 80301, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138078037||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDESPAÑA GESTION INTERNAC.', 'ES0138481033', 'EUR', 2, '|f_es_BMF|', 80302, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138481033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDESPAÑA GLOBAL', 'ES0138714037', 'EUR', 2, '|f_es_BMF|', 80303, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138714037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDESPAÑA I', 'ES0138787033', 'EUR', 2, '|f_es_BMF|', 80306, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138787033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDESPAÑA II', 'ES0138881034', 'EUR', 2, '|f_es_BMF|', 77547, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138881034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDESPAÑA INTERNACIONAL 8', 'ES0138055035', 'EUR', 2, '|f_es_BMF|', 80314, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138055035||es||False', false, '{NULL,F0GBR05S6K,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDESPAÑA INTERNACIONAL II', 'ES0138514031', 'EUR', 2, '|f_es_BMF|', 80315, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138514031||es||False', false, '{NULL,F0GBR04Q5G,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDESPAÑA INTERNACIONAL III', 'ES0138539038', 'EUR', 2, '|f_es_BMF|', 79207, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138539038||es||False', false, '{NULL,F0GBR04Q5H,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDESPAÑA INTERNACIONAL V', 'ES0138297033', 'EUR', 2, '|f_es_BMF|', 79208, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138297033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDESPAÑA JAPON', 'ES0138183035', 'EUR', 2, '|f_es_BMF|', 80375, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138183035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDESPAÑA MODERADO', 'ES0182035032', 'EUR', 2, '|f_es_BMF|', 80378, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0182035032||es||False', false, '{NULL,F0GBR04M4Y,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDESPAÑA MODERADO PLUS', 'ES0137994036', 'EUR', 2, '|f_es_BMF|', 80380, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137994036||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDESPAÑA MONETARIO DINAMICO', 'ES0138079035', 'EUR', 2, '|f_es_BMF|', 80381, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138079035||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDESPAÑA PREMIER', 'ES0164525000', 'EUR', 2, '|f_es_BMF|', 80384, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0164525000||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDESPAÑA RENTA ACTIVA', 'ES0138715034', 'EUR', 2, '|f_es_BMF|', 80385, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138715034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDESPAÑA SECTORIAL CRECIMIENTO', 'ES0138351038', 'EUR', 2, '|f_es_BMF|', 79216, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138351038||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDESPAÑA SEMESTRAL GARANT.', 'ES0138716032', 'EUR', 2, '|f_es_BMF|', 80414, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138716032||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDESPAÑA TESORERIA', 'ES0138723038', 'EUR', 2, '|f_es_BMF|', 80415, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138723038||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDESPAÑA USA', 'ES0138221033', 'EUR', 2, '|f_es_BMF|', 75907, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138221033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDESPAÑA VALORES', 'ES0138492030', 'EUR', 2, '|f_es_BMF|', 79220, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138492030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDGESKOA', 'ES0138869039', 'EUR', 2, '|f_es_BMF|', 79293, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138869039||es||False', false, '{NULL,F0GBR04CFF,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDGUISSONA BOLSA', 'ES0115223036', 'EUR', 2, '|f_es_BMF|', 80023, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115223036||es||False', false, '{NULL,F0GBR04DNQ,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDGUISSONA', 'ES0147607032', 'EUR', 2, '|f_es_BMF|', 79426, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147607032||es||False', false, '{NULL,F0GBR04DNS,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDIBAS', 'ES0138936036', 'EUR', 2, '|f_es_BMF|', 80038, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138936036||es||False', false, '{NULL,F0GBR04PTU,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDIBAS MIXTO', 'ES0117625030', 'EUR', 2, '|f_es_BMF|', 75228, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0117625030||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDICAJA', 'ES0138819034', 'EUR', 2, '|f_es_BMF|', 80043, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138819034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDINAMICO', 'ES0164526008', 'EUR', 2, '|f_es_BMF|', 80044, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0164526008||es||False', false, '{NULL,F0000021KQ,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDITEL ALBATROS', 'ES0138184033', 'EUR', 2, '|f_es_BMF|', 75409, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138184033||es||False', false, '{NULL,F0GBR04EPD,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDITEL DINERO', 'ES0138338035', 'EUR', 2, '|f_es_BMF|', 75410, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138338035||es||False', false, '{NULL,F0GBR04EPV,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDITEL RENTA FIJA MIXTA INTER.', 'ES0138047032', 'EUR', 2, '|f_es_BMF|', 75413, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138047032||es||False', false, '{NULL,F0GBR04EPF,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDITEL VELOCIRAPTOR', 'ES0138145034', 'EUR', 2, '|f_es_BMF|', 79873, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138145034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDMADRID', 'ES0138801032', 'EUR', 2, '|f_es_BMF|', 75414, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138801032||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDMAPFRE BOLSA AMERICA', 'ES0138658036', 'EUR', 2, '|f_es_BMF|', 79564, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138658036||es||False', false, '{NULL,F0GBR04J9W,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDMAPFRE BOLSA ASIA', 'ES0138298031', 'EUR', 2, '|f_es_BMF|', 79565, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138298031||es||False', false, '{NULL,F0GBR04OPF,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDMAPFRE BOLSA', 'ES0138901030', 'EUR', 2, '|f_es_BMF|', 75415, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138901030||es||False', false, '{NULL,F0GBR04J98,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDMAPFRE BOLSA G IV', 'ES0138394038', 'EUR', 2, '|f_es_BMF|', 80436, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138394038||es||False', false, '{NULL,F0GBR04JA6,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDMAPFRE BOLSA GARANTIZADO', 'ES0138708039', 'EUR', 2, '|f_es_BMF|', 75416, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138708039||es||False', false, '{NULL,F0GBR04J9M,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDMAPFRE BOLSA GARANTIZADO II', 'ES0122067038', 'EUR', 2, '|f_es_BMF|', 80437, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0122067038||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDMAPFRE BOLSA GIX   L', 'ES0138956034', 'EUR', 2, '|f_es_BMF|', 80441, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138956034||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDMAPFRE BOLSA GV', 'ES0138395035', 'EUR', 2, '|f_es_BMF|', 80442, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138395035||es||False', false, '{NULL,F0GBR04JA8,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDMAPFRE BOLSA GVI', 'ES0138352036', 'EUR', 2, '|f_es_BMF|', 80443, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138352036||es||False', false, '{NULL,F0GBR04JAC,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDMAPFRE BOLSA GVII', 'ES0138353034', 'EUR', 2, '|f_es_BMF|', 80444, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138353034||es||False', false, '{NULL,F0GBR04JAE,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDMAPFRE BOLSA GVIII', 'ES0138444031', 'EUR', 2, '|f_es_BMF|', 80445, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138444031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDMAPFRE BOLSA GX', 'ES0138777034', 'EUR', 2, '|f_es_BMF|', 80446, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138777034||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDMAPFRE DINERO', 'ES0138902038', 'EUR', 2, '|f_es_BMF|', 79427, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138902038||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDMAPFRE DIVERSIFICACION', 'ES0147625034', 'EUR', 2, '|f_es_BMF|', 75464, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147625034||es||False', false, '{NULL,F0GBR04J9G,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDMAPFRE GARANTIZADO 607', 'ES0165196033', 'EUR', 2, '|f_es_BMF|', 75482, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0165196033||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDMAPFRE GARANTIZADO 611', 'ES0138599032', 'EUR', 2, '|f_es_BMF|', 79428, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138599032||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDMAPFRE INTER. GARANTIZADO', 'ES0138725033', 'EUR', 2, '|f_es_BMF|', 79435, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138725033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDMAPFRE MIXTO EUROPA FI', 'ES0122059035', 'EUR', 2, '|f_es_BMF|', 74981, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0122059035||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDMAPFRE MULTISELECCION', 'ES0138445038', 'EUR', 2, '|f_es_BMF|', 80140, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138445038||es||False', false, '{NULL,F0GBR04K1P,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDMAPFRE RENTA', 'ES0138903036', 'EUR', 2, '|f_es_BMF|', 80141, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138903036||es||False', false, '{NULL,F0GBR04J9A,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDMAPFRE RENTA LARGO', 'ES0138820032', 'EUR', 2, '|f_es_BMF|', 80151, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138820032||es||False', false, '{NULL,F0GBR04J9K,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDMAPFRE RENTA MIXTO', 'ES0138709037', 'EUR', 2, '|f_es_BMF|', 80159, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138709037||es||False', false, '{NULL,F0GBR04J9O,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDMAPFRE RENTADOLAR', 'ES0137814002', 'EUR', 2, '|f_es_BMF|', 80161, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137814002||es||False', false, '{NULL,F000001VX2,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDMAPFRE TECNOLOGIA', 'ES0138396033', 'EUR', 2, '|f_es_BMF|', 80164, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138396033||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDMUSINI II', 'ES0165197031', 'EUR', 2, '|f_es_BMF|', 80165, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0165197031||es||False', false, '{NULL,F0GBR04J4A,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDMUSINI III', 'ES0165198039', 'EUR', 2, '|f_es_BMF|', 79436, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0165198039||es||False', false, '{NULL,F0GBR04J4C,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDMUSINI UNIVERSAL', 'ES0178520039', 'EUR', 2, '|f_es_BMF|', 80633, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0178520039||es||False', false, '{NULL,F0GBR04J4E,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO 111', 'ES0138927035', 'EUR', 2, '|f_es_BMF|', 80648, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138927035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO AGE', 'ES0138339033', 'EUR', 2, '|f_es_BMF|', 80048, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138339033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO ANTICIPACION CONSERVADOR 2', 'ES0137899037', 'EUR', 2, '|f_es_BMF|', 79445, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137899037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO ANTICIPACION CONSERVADOR', 'ES0137940039', 'EUR', 2, '|f_es_BMF|', 77836, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137940039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO ANTICIPACION MODERADO 2', 'ES0137941037', 'EUR', 2, '|f_es_BMF|', 79451, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137941037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO ANTICIPACION MODERADO', 'ES0138399037', 'EUR', 2, '|f_es_BMF|', 79446, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138399037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO ARTAC', 'ES0138354032', 'EUR', 2, '|f_es_BMF|', 79452, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138354032||es||False', false, '{NULL,F0GBR04JYQ,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO BANKINTER CONSOLIDACION GARANTIZAD', 'ES0113815031', 'EUR', 2, '|f_es_BMF|', 79454, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113815031||es||False', false, '{NULL,F0GBR06PPR,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO BANKINTER EEUU NASDAQ 100', 'ES0114105036', 'EUR', 2, '|f_es_BMF|', 80635, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114105036||es||False', false, '{NULL,F0GBR04K3Q,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO BANKINTER EUROSTOXX 55 GARANTIZADO', 'ES0114880034', 'EUR', 2, '|f_es_BMF|', 75815, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114880034||es||False', false, '{NULL,F0GBR04Q6T,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO BANKINTER HONG KONG GARANTIZADO', 'ES0114795034', 'EUR', 2, '|f_es_BMF|', 75816, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114795034||es||False', false, '{NULL,F0GBR04Q8T,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO BANKINTER MULTIFONDO GARANTIZADO', 'ES0125632036', 'EUR', 2, '|f_es_BMF|', 79486, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0125632036||es||False', false, '{NULL,F0GBR04EG7,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO BANKINTER RENTA FIJA 6 GARANTIZADO', 'ES0164541007', 'EUR', 2, '|f_es_BMF|', 80637, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0164541007||es||False', false, '{NULL,F000002941,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO BK CESTA ESPAÑOLA GARANTIZADO', 'ES0114785035', 'EUR', 2, '|f_es_BMF|', 75817, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114785035||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO BK EMPRESAS CORTO PLAZO', 'ES0110053032', 'EUR', 2, '|f_es_BMF|', 79331, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0110053032||es||False', false, '{NULL,F0GBR04Q6V,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO BK EURO TELECOS GARANTIZADO', 'ES0164950000', 'EUR', 2, '|f_es_BMF|', 79332, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0164950000||es||False', false, '{NULL,F0000045OB,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO BK EUROPA GARANTIZADO', 'ES0113776035', 'EUR', 2, '|f_es_BMF|', 77853, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113776035||es||False', false, '{NULL,F0000000S8,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO BK EUROSTOXX 2012 GARANT.', 'ES0114839030', 'EUR', 2, '|f_es_BMF|', 80348, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114839030||es||False', false, '{NULL,F0GBR04Q6P,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO BK EUROSTOXX 2014 GARANTIZADO', 'ES0164951008', 'EUR', 2, '|f_es_BMF|', 80361, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0164951008||es||False', false, '{NULL,F000005IOJ,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO BK MATERIAS PRIMAS', 'ES0114103031', 'EUR', 2, '|f_es_BMF|', 80875, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114103031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO BK MONETARIO ACTIVOS EURO', 'ES0114821038', 'EUR', 2, '|f_es_BMF|', 80876, NULL, NULL, NULL, NULL, 0, 'c', 1, 1, 'ES0114821038||es||False', false, '{NULL,F0GBR04Q8E,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO BK MULTISECTOR GARANTIZADO', 'ES0114878038', 'EUR', 2, '|f_es_BMF|', 80879, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114878038||es||False', false, '{NULL,F0GBR04D4N,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO BK RENTA FIJA 2014 GARANTIZADO', 'ES0113983003', 'EUR', 2, '|f_es_BMF|', 80880, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113983003||es||False', false, '{NULL,F00000M0NC,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO BK RENTA FIJA GARANTIZADO 2012', 'ES0164542005', 'EUR', 2, '|f_es_BMF|', 77978, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0164542005||es||False', false, '{NULL,F00000H5PS,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO BK SECTORES GARANTIZADO', 'ES0114792031', 'EUR', 2, '|f_es_BMF|', 79690, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114792031||es||False', false, '{NULL,F0GBR04C9V,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO BK SUMA TRIMESTRAL GARANTIZADO', 'ES0113816039', 'EUR', 2, '|f_es_BMF|', 75866, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113816039||es||False', false, '{NULL,F00000021U,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO BK TRIPLE SUMA GARANTIZADO', 'ES0113777033', 'EUR', 2, '|f_es_BMF|', 75867, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113777033||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO CAJA MURCIA INTERES GARANTIZ. III', 'ES0139778031', 'EUR', 2, '|f_es_BMF|', 78022, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0139778031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO CAJA MURCIA INTERES GARANTIZADO', 'ES0138358033', 'EUR', 2, '|f_es_BMF|', 75937, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138358033||es||False', false, '{NULL,F0GBR04GRQ,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO CAJA MURCIA INTERES GAR.VI', 'ES0138121001', 'EUR', 2, '|f_es_BMF|', 75418, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138121001||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO CAJA MURCIA INT.GARANT. II', 'ES0138091030', 'EUR', 2, '|f_es_BMF|', 80882, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138091030||es||False', false, '{NULL,F0GBR06XIQ,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO COMMODITY TRIO', 'ES0140822034', 'EUR', 2, '|f_es_BMF|', 78027, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0140822034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO CONFIANZA GARANTIZADO', 'ES0138299039', 'EUR', 2, '|f_es_BMF|', 79822, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138299039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO DE PERMANENCIA', 'ES0147609038', 'EUR', 2, '|f_es_BMF|', 80491, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147609038||es||False', false, '{NULL,F0GBR051QM,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO DEPOSITOS PLUS', 'ES0118939034', 'EUR', 2, '|f_es_BMF|', 79823, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0118939034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO EXTREMADURA GARANTIZADO I', 'ES0138357035', 'EUR', 2, '|f_es_BMF|', 79824, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138357035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO EXTREMADURA GARANTIZADO II', 'ES0138301033', 'EUR', 2, '|f_es_BMF|', 79825, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138301033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO EXTREMADURA GARANTIZADO VI', 'ES0139775037', 'EUR', 2, '|f_es_BMF|', 79826, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0139775037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO EXTREMADURA GARANTIZADO VII', 'ES0115425037', 'EUR', 2, '|f_es_BMF|', 75956, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115425037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO GARAN.CONFIANZA V C.MURCIA', 'ES0138307030', 'EUR', 2, '|f_es_BMF|', 79910, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138307030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO GARANT.CONFIANZA III C.MUR', 'ES0138305034', 'EUR', 2, '|f_es_BMF|', 79911, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138305034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO GARANT.CONFIANZA IX C.MURC', 'ES0138148038', 'EUR', 2, '|f_es_BMF|', 79912, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138148038||es||False', false, '{NULL,F0GBR06UII,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO GAR.CONFIANZA X C.MURCIA', 'ES0182044034', 'EUR', 2, '|f_es_BMF|', 75957, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0182044034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO GTZDO. CONFIANZA XII CAJA MURCIA', 'ES0138080033', 'EUR', 2, '|f_es_BMF|', 75465, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138080033||es||False', false, '{NULL,FOGBR05KRY,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO IBEX GARANTIZADO 2010', 'ES0114833033', 'EUR', 2, '|f_es_BMF|', 79689, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114833033||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO JALON', 'ES0138223039', 'EUR', 2, '|f_es_BMF|', 79531, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138223039||es||False', false, '{NULL,F0GBR053VC,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO LIQUIDEZ', 'ES0137987006', 'EUR', 2, '|f_es_BMF|', 79913, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137987006||es||False', false, '{NULL,F000001VLR,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO MULTIMIX 2004', 'ES0138224037', 'EUR', 2, '|f_es_BMF|', 76444, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138224037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO MULTISELECCION 100', 'ES0147606034', 'EUR', 2, '|f_es_BMF|', 79532, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147606034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO MULTISELECCION 25', 'ES0180959035', 'EUR', 2, '|f_es_BMF|', 79533, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0180959035||es||False', false, '{NULL,F000000371,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO MULTISELECCION 50', 'ES0114762034', 'EUR', 2, '|f_es_BMF|', 79534, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0114762034||es||False', false, '{NULL,F0GBR04Q9J,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO RENTA FIJA CORPORATIVA 2', 'ES0140823032', 'EUR', 2, '|f_es_BMF|', 79566, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0140823032||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO RENTA FIJA CORPORATIVA', 'ES0140831035', 'EUR', 2, '|f_es_BMF|', 79535, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0140831035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO SANTADER GARANTIZADO ESPAÑA', 'ES0180960033', 'EUR', 2, '|f_es_BMF|', 79567, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0180960033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO SENIORS', 'ES0138623030', 'EUR', 2, '|f_es_BMF|', 79926, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138623030||es||False', false, '{NULL,F0GBR04OMR,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO SOLIDARIO PRO-UNICEF', 'ES0138518032', 'EUR', 2, '|f_es_BMF|', 79568, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138518032||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO SUPERSELECCION ACCIONES 2', 'ES0112738036', 'EUR', 2, '|f_es_BMF|', 79571, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0112738036||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO SUPERSELECCION ACCIONES', 'ES0138362035', 'EUR', 2, '|f_es_BMF|', 79570, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138362035||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO SUPERSELECCION DIVIDENDO 2', 'ES0138312030', 'EUR', 2, '|f_es_BMF|', 75958, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138312030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO SUPERSELECCION DIVIDENDO', 'ES0138311032', 'EUR', 2, '|f_es_BMF|', 75467, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138311032||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO SUPERSELECCION', 'ES0107774038', 'EUR', 2, '|f_es_BMF|', 79569, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0107774038||es||False', false, '{NULL,F0GBR04K6C,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO TELEFONICO CORTO PLAZO', 'ES0138953031', 'EUR', 2, '|f_es_BMF|', 75959, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138953031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO TRIPLE OPCION AGRICULTURA', 'ES0138227030', 'EUR', 2, '|f_es_BMF|', 77110, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138227030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO URBION', 'ES0138560034', 'EUR', 2, '|f_es_BMF|', 75468, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138560034||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO VALENCIA BRIC NUEVOS DESAF', 'ES0138561032', 'EUR', 2, '|f_es_BMF|', 75469, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138561032||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO VALENCIA ENERGIAS RENOVABL', 'ES0180961007', 'EUR', 2, '|f_es_BMF|', 79615, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0180961007||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO VALENCIA EUROPA', 'ES0138519030', 'EUR', 2, '|f_es_BMF|', 75471, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138519030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO VALENCIA FDO.DE FDO.90 GLO', 'ES0138678034', 'EUR', 2, '|f_es_BMF|', 75484, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138678034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO VALENCIA FONDO DE FONDOS30', 'ES0138236031', 'EUR', 2, '|f_es_BMF|', 75485, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138236031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO VALENCIA FONDO DE FONDOS60', 'ES0141223034', 'EUR', 2, '|f_es_BMF|', 80083, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0141223034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO VALENCIA GARAN.ELECCION OPTIMA 7', 'ES0138149036', 'EUR', 2, '|f_es_BMF|', 80085, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138149036||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO VALENCIA GARAN.EL.OPTIMA 8', 'ES0138626033', 'EUR', 2, '|f_es_BMF|', 80084, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138626033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO VALENCIA GARANTIZADO MIX.6', 'ES0138400033', 'EUR', 2, '|f_es_BMF|', 80086, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138400033||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO VALENCIA GARANTIZADO MIX.7', 'ES0138402039', 'EUR', 2, '|f_es_BMF|', 75486, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138402039||es||False', false, '{NULL,F0GBR056U1,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO VALENCIA GAR.ELEC.OPTIMA 4', 'ES0138401031', 'EUR', 2, '|f_es_BMF|', 80054, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138401031||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO VALENCIA GARN.ELECCION OPTIMA 5', 'ES0138363033', 'EUR', 2, '|f_es_BMF|', 75502, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138363033||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO VALENCIA GARN.ELECCION OPTIMA 6', 'ES0112739034', 'EUR', 2, '|f_es_BMF|', 75503, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0112739034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO VALENCIA INTERES I', 'ES0139003034', 'EUR', 2, '|f_es_BMF|', 79691, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0139003034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO VALENCIA INTERES II', 'ES0177862036', 'EUR', 2, '|f_es_BMF|', 79695, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0177862036||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO VALENCIA INTERES III', 'ES0115219034', 'EUR', 2, '|f_es_BMF|', 75504, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115219034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO VALENCIA INTERNACIONAL', 'ES0138601036', 'EUR', 2, '|f_es_BMF|', 75509, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138601036||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO VALENCIA LIQUIDEZ D.PUBLIC', 'ES0139780003', 'EUR', 2, '|f_es_BMF|', 76000, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0139780003||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO VALENCIA RENTA', 'ES0138726031', 'EUR', 2, '|f_es_BMF|', 75512, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138726031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO VALENCIA RENTA FIJA', 'ES0139004032', 'EUR', 2, '|f_es_BMF|', 80933, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0139004032||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO VALENCIA RENTA FIJA MIXTA', 'ES0139005039', 'EUR', 2, '|f_es_BMF|', 80934, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0139005039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDO VALENCIA RENTA VARIABLE', 'ES0138578036', 'EUR', 2, '|f_es_BMF|', 80935, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138578036||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDOCAJA DEPOSITO', 'ES0115846034', 'EUR', 2, '|f_es_BMF|', 75514, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115846034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDOCAJA GARANTIZADO ELECCION', 'ES0166022006', 'EUR', 2, '|f_es_BMF|', 75516, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0166022006||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDOCAJA GARANTIZADO FUTURO I FI', 'ES0138229036', 'EUR', 2, '|f_es_BMF|', 74982, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138229036||None||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDOCAJA GARANTIZADO PREMIER', 'ES0138364031', 'EUR', 2, '|f_es_BMF|', 75517, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138364031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDOGAESCO', 'ES0138233038', 'EUR', 2, '|f_es_BMF|', 75518, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138233038||es||False', false, '{NULL,F0GBR04DNW,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDONORTE DIVISAS', 'ES0122070032', 'EUR', 2, '|f_es_BMF|', 75562, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0122070032||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDONORTE', 'ES0138828035', 'EUR', 2, '|f_es_BMF|', 79746, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138828035||es||False', false, '{NULL,F0GBR04Q4P,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDONORTE EUROBOLSA', 'ES0138494036', 'EUR', 2, '|f_es_BMF|', 75564, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138494036||es||False', false, '{NULL,F0GBR04Q4R,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDONORTE EURO-RENTA', 'ES0138818036', 'EUR', 2, '|f_es_BMF|', 75563, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138818036||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDPUEYO', 'ES0115221030', 'EUR', 2, '|f_es_BMF|', 77926, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115221030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDTURIA', 'ES0158323032', 'EUR', 2, '|f_es_BMF|', 75565, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0158323032||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDUERO ACCIONES GARANTIZADO', 'ES0138522034', 'EUR', 2, '|f_es_BMF|', 75567, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138522034||es||False', false, '{NULL,F0GBR04M9Z,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDUERO CAPITAL GARANTIZADO 1', 'ES0138562030', 'EUR', 2, '|f_es_BMF|', 76342, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138562030||es||False', false, '{NULL,F0GBR04GVA,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDUERO CAPITAL GARANTIZADO 2', 'ES0138679032', 'EUR', 2, '|f_es_BMF|', 79536, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138679032||es||False', false, '{NULL,F0GBR04J2K,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDUERO CAPITAL GARANTIZADO 4', 'ES0138563038', 'EUR', 2, '|f_es_BMF|', 79537, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138563038||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDUERO CAPITAL GARANTIZADO 6', 'ES0138565033', 'EUR', 2, '|f_es_BMF|', 79538, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138565033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDUERO CAPITAL GARANTIZADO 7', 'ES0138566031', 'EUR', 2, '|f_es_BMF|', 75572, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138566031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDUERO CAPITAL GARANTIZADO 8', 'ES0165091036', 'EUR', 2, '|f_es_BMF|', 75570, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0165091036||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDUERO CAPITAL GARANTIZADO 9', 'ES0138567039', 'EUR', 2, '|f_es_BMF|', 76383, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138567039||es||False', false, '{NULL,F0GBR06156,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDUERO DINERO', 'ES0138891033', 'EUR', 2, '|f_es_BMF|', 76393, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138891033||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDUERO EMERGENTES', 'ES0138521036', 'EUR', 2, '|f_es_BMF|', 75615, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138521036||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDUERO EUROBOLSA  GARANTIZADO', 'ES0138568037', 'EUR', 2, '|f_es_BMF|', 75617, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138568037||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDUERO EUROPA', 'ES0147496030', 'EUR', 2, '|f_es_BMF|', 75618, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147496030||es||False', false, '{NULL,F0GBR04J2E,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDUERO EUROPEO GARANTIZADO', 'ES0141225039', 'EUR', 2, '|f_es_BMF|', 75619, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0141225039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDUERO GARANTIZADO', 'ES0177863034', 'EUR', 2, '|f_es_BMF|', 75620, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0177863034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDUERO INDICE', 'ES0147577037', 'EUR', 2, '|f_es_BMF|', 79496, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147577037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDUERO MIXTO', 'ES0138852035', 'EUR', 2, '|f_es_BMF|', 75621, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138852035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDUERO PLUS', 'ES0138495033', 'EUR', 2, '|f_es_BMF|', 75622, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138495033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDUERO R.V. ESPAÑOLA', 'ES0138628039', 'EUR', 2, '|f_es_BMF|', 75623, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138628039||es||False', false, '{NULL,F0GBR0557E,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDUERO SECTORIAL', 'ES0147142030', 'EUR', 2, '|f_es_BMF|', 75664, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147142030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONDUXO', 'ES0138893039', 'EUR', 2, '|f_es_BMF|', 75667, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138893039||es||False', false, '{NULL,F0GBR04JWO,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONEMPORIUM', 'ES0138907037', 'EUR', 2, '|f_es_BMF|', 75689, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138907037||es||False', false, '{NULL,F0GBR04J6S,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONENGIN', 'ES0138885035', 'EUR', 2, '|f_es_BMF|', 78274, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138885035||es||False', false, '{NULL,F0GBR04K14,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONGARANTIA EUROPA', 'ES0158772030', 'EUR', 2, '|f_es_BMF|', 75711, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0158772030||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONGAUDI', 'ES0147608030', 'EUR', 2, '|f_es_BMF|', 77695, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147608030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONGENERAL RENTA FIJA', 'ES0158317034', 'EUR', 2, '|f_es_BMF|', 79827, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0158317034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONGRUM', 'ES0138876034', 'EUR', 2, '|f_es_BMF|', 79828, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138876034||es||False', false, '{NULL,F0GBR04JSY,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONLAIETANA', 'ES0138908035', 'EUR', 2, '|f_es_BMF|', 79829, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138908035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONMANRESA', 'ES0138858032', 'EUR', 2, '|f_es_BMF|', 75716, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138858032||es||False', false, '{NULL,F0GBR04J3Q,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONMARCH', 'ES0138841038', 'EUR', 2, '|f_es_BMF|', 76427, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138841038||es||False', false, '{NULL,F0GBR04JAI,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONMASTER I', 'ES0138909033', 'EUR', 2, '|f_es_BMF|', 76429, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138909033||es||False', false, '{NULL,F0GBR04J5E,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONMIX LAIETANA 4', 'ES0141227035', 'EUR', 2, '|f_es_BMF|', 80346, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0141227035||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONMIX LAIETANA 5', 'ES0141228033', 'EUR', 2, '|f_es_BMF|', 80349, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0141228033||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONMIX LAIETANA DOS', 'ES0138524030', 'EUR', 2, '|f_es_BMF|', 80350, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138524030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONMIX LAIETANA', 'ES0158319030', 'EUR', 2, '|f_es_BMF|', 75717, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0158319030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONMIX LAIETANA TRES', 'ES0138525037', 'EUR', 2, '|f_es_BMF|', 80351, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138525037||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONPASTOR DEUDA PUBLICA LARGO', 'ES0168567008', 'EUR', 2, '|f_es_BMF|', 79035, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0168567008||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONPE.GARANT.INT.MES BORSA III', 'ES0115233035', 'EUR', 2, '|f_es_BMF|', 80363, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115233035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONPENECES ETIC I SOLIDARI', 'ES0138631009', 'EUR', 2, '|f_es_BMF|', 80365, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138631009||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONPENEDES BORSA EMERGENT', 'ES0168664037', 'EUR', 2, '|f_es_BMF|', 80369, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0168664037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONPENEDES BORSA', 'ES0158324030', 'EUR', 2, '|f_es_BMF|', 80367, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0158324030||es||False', false, '{NULL,F0GBR04IUY,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONPENEDES BORSA JAPON', 'ES0138605037', 'EUR', 2, '|f_es_BMF|', 75720, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138605037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONPENEDES BORSA USA', 'ES0138499035', 'EUR', 2, '|f_es_BMF|', 80417, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138499035||es||False', false, '{NULL,F0GBR04IV3,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONPENEDES DINAMIC VAR2', 'ES0141229031', 'EUR', 2, '|f_es_BMF|', 80447, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0141229031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONPENEDES DINAMIC VAR4', 'ES0138527033', 'EUR', 2, '|f_es_BMF|', 80448, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138527033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONPENEDES DIPOSIT', 'ES0138630001', 'EUR', 2, '|f_es_BMF|', 80450, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138630001||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONPENEDES DOLAR', 'ES0117014037', 'EUR', 2, '|f_es_BMF|', 80451, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0117014037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONPENEDES', 'ES0138887031', 'EUR', 2, '|f_es_BMF|', 75718, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138887031||es||False', false, '{NULL,F0GBR04KWW,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONPENEDES EUROBORSA 100', 'ES0138727039', 'EUR', 2, '|f_es_BMF|', 80452, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138727039||es||False', false, '{NULL,F0GBR04IV9,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONPENEDES G. INTERES MES BORSAI', 'ES0122074034', 'EUR', 2, '|f_es_BMF|', 80453, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0122074034||es||False', false, '{NULL,F0GBR04GDZ,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONPENEDES GARANTI', 'ES0136786037', 'EUR', 2, '|f_es_BMF|', 80992, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0136786037||es||False', false, '{NULL,F0GBR04IVB,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONPENEDES GARANTIT IX PETROLI', 'ES0122076039', 'EUR', 2, '|f_es_BMF|', 80993, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0122076039||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONPENEDES GARANTIT VII OR', 'ES0168671032', 'EUR', 2, '|f_es_BMF|', 80994, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0168671032||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONPENEDES GAR.INT.MES BORSA 8', 'ES0138608031', 'EUR', 2, '|f_es_BMF|', 75724, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138608031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONPENEDES GAR.INT.MES BORSA II', 'ES0122075031', 'EUR', 2, '|f_es_BMF|', 80456, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0122075031||es||False', false, '{NULL,F0GBR04HJS,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONPENEDES GAR.INT.MES BORSA IV', 'ES0115234033', 'EUR', 2, '|f_es_BMF|', 80460, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115234033||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONPENEDES GAR.INT.MES BORSA V', 'ES0138501038', 'EUR', 2, '|f_es_BMF|', 80462, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138501038||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONPENEDES GAR.INT.MES BORSA VI', 'ES0138607033', 'EUR', 2, '|f_es_BMF|', 80990, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138607033||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONPENEDES GAR.INT.MES BORSA X', 'ES0138609039', 'EUR', 2, '|f_es_BMF|', 80991, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138609039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONPENEDES INTERES GARANTIT 1', 'ES0117015034', 'EUR', 2, '|f_es_BMF|', 80995, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0117015034||es||False', false, '{NULL,F0GBR04IVD,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONPENEDES INTERES GARANTIT 2', 'ES0117016032', 'EUR', 2, '|f_es_BMF|', 75725, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0117016032||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONPENEDES INTERES GARANTIT 3', 'ES0115231039', 'EUR', 2, '|f_es_BMF|', 75775, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115231039||es||False', false, '{NULL,F0GBR04ONJ,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONPENEDES INVERSIO', 'ES0158320038', 'EUR', 2, '|f_es_BMF|', 76273, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0158320038||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONPENEDES MIXT EUROEMERGENT', 'ES0115230031', 'EUR', 2, '|f_es_BMF|', 76287, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115230031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONPENEDES MONETARI', 'ES0138610037', 'EUR', 2, '|f_es_BMF|', 80700, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138610037||es||False', false, '{NULL,F0GBR06XIK,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONPENEDES MULTIFONS 100', 'ES0168663039', 'EUR', 2, '|f_es_BMF|', 79351, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0168663039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONPENEDES MULTIFONS 25', 'ES0168670034', 'EUR', 2, '|f_es_BMF|', 80701, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0168670034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONPENEDES MULTIFONS 50', 'ES0138606035', 'EUR', 2, '|f_es_BMF|', 80702, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138606035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONPENEDES MULTIFONS 75', 'ES0138500030', 'EUR', 2, '|f_es_BMF|', 80706, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138500030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONPENEDES MULTIFONS FIX', 'ES0115232037', 'EUR', 2, '|f_es_BMF|', 79364, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0115232037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONPENEDES RENDES', 'ES0158321036', 'EUR', 2, '|f_es_BMF|', 80708, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0158321036||es||False', false, '{NULL,F0GBR04IVL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONPENEDES RF CURT TERMINI', 'ES0138980034', 'EUR', 2, '|f_es_BMF|', 80709, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138980034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONPREMIUM RF', 'ES0158326035', 'EUR', 2, '|f_es_BMF|', 80710, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0158326035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONPROFIT', 'ES0138929031', 'EUR', 2, '|f_es_BMF|', 80711, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138929031||es||False', false, '{NULL,F0GBR04Q2G,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONQUIVIR', 'ES0138912037', 'EUR', 2, '|f_es_BMF|', 80463, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138912037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONRADAR INTERNACIONAL', 'ES0139957031', 'EUR', 2, '|f_es_BMF|', 80713, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0139957031||es||False', false, '{NULL,F0GBR04DO9,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONSGLOBAL RENTA', 'ES0136788033', 'EUR', 2, '|f_es_BMF|', 80714, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0136788033||es||False', false, '{NULL,F0GBR04DNY,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONSMANLLEU BORSA', 'ES0139002036', 'EUR', 2, '|f_es_BMF|', 80717, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0139002036||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONSNOSTRO', 'ES0138859030', 'EUR', 2, '|f_es_BMF|', 80719, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138859030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONSNOSTRO II', 'ES0139010039', 'EUR', 2, '|f_es_BMF|', 80720, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0139010039||es||False', false, '{NULL,F0GBR04DYG,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONSNOSTRO TRIPLE A', 'ES0165204035', 'EUR', 2, '|f_es_BMF|', 80479, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0165204035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONSVILA-REAL', 'ES0165206006', 'EUR', 2, '|f_es_BMF|', 80464, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0165206006||es||False', false, '{NULL,F000000AS4,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONTALENTO', 'ES0139958039', 'EUR', 2, '|f_es_BMF|', 80465, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0139958039||es||False', false, '{NULL,F0GBR04Q1G,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONTELECO 5', 'ES0138059037', 'EUR', 2, '|f_es_BMF|', 80530, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138059037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONTESORERIA', 'ES0139011037', 'EUR', 2, '|f_es_BMF|', 80531, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0139011037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONTIBREFONDO', 'ES0138918034', 'EUR', 2, '|f_es_BMF|', 76032, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138918034||es||False', false, '{NULL,F0GBR04JZ0,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FONVALCEM', 'ES0138930039', 'EUR', 2, '|f_es_BMF|', 75819, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138930039||es||False', false, '{NULL,F0GBR04P65,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FOOT LOCKER INC.', NULL, 'USD', 1, '', 78320, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FL||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FORD MOTOR CERT', 'BE0004571122', 'EUR', 1, '|EURONEXT|', 77004, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0004571122||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FORD MOTOR CO.', NULL, 'USD', 1, '', 76497, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#F||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FORD MOTOR', 'US3453708600', 'EUR', 1, '|EURONEXT|', 78607, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#US3453708600||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FOREST LABORATORIES INC.', NULL, 'USD', 1, '', 77822, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FRX||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FOREST OIL CORP.', NULL, 'USD', 1, '', 75571, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FST||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FORESTAR GROUP INC.', NULL, 'USD', 1, '', 77570, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FOR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FORESTIERE EQUAT.', 'CI0000053161', 'EUR', 1, '|EURONEXT|', 77010, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#CI0000053161||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FORNIX BIOSCIENCES', 'NL0000439990', 'EUR', 1, '|EURONEXT|', 76989, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0000439990||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FORTEC ELEKTRONIK AG', 'DE0005774103', 'EUR', 1, '|DEUTSCHEBOERSE|', 81150, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005774103||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FORTEGRA FINANCIAL CORP.', NULL, 'USD', 1, '', 80498, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FRF||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FORTUNA SILVER MINES INC.', NULL, 'USD', 1, '', 79433, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FSM||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FORTUNE BRANDS HOME & SECURITY INC.', NULL, 'USD', 1, '', 77369, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FBHS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FORTUNE BRANDS INC.', NULL, 'USD', 1, '', 76809, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FO||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FOSTER WHEELER AG.', 'CH0018666781', 'USD', 1, '|NASDAQ100|', 77588, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'FWLT||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FOUNTAIN', 'BE0003752665', 'EUR', 1, '|EURONEXT|', 76993, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003752665||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FOYER', 'LU0112960504', 'EUR', 1, '|EURONEXT|', 75524, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#LU0112960504||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('F.P. FONDBARCLAYS SOLIDEZ II', NULL, 'EUR', 8, '', 75290, NULL, NULL, NULL, NULL, 0, 'c', 1, 1, 'F.P. FondBarclays Solidez II||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('F.RAMA', 'PTFRV0AE0004', 'EUR', 1, '|EURONEXT|', 79176, NULL, NULL, NULL, NULL, 100, 'c', 1, 9, 'EURONEXT#PTFRV0AE0004||pt||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FRANCE TELECOM', NULL, 'USD', 1, '', 77943, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FTE||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FRANCO-NEVADA CORP.', NULL, 'USD', 1, '', 75095, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FNV||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FRANCOTYP-POSTALIA HOLDING AG', 'DE000FPH9000', 'EUR', 1, '|DEUTSCHEBOERSE|', 81153, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE000FPH9000||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FRANKLIN COVEY CO.', NULL, 'USD', 1, '', 80126, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FRANKLIN RESOURCES INC.', NULL, 'USD', 1, '', 74933, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BEN||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FRAPORT AG', 'DE0005773303', 'EUR', 1, '|DEUTSCHEBOERSE|', 81154, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005773303||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FREENET AG', 'DE000A0Z2ZZ5', 'EUR', 1, '|DEUTSCHEBOERSE|', 81156, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE000A0Z2ZZ5||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FREEPORT-MCMORAN COPPER & GOLD INC.', NULL, 'USD', 1, '', 77048, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FCX||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FREESCALE SEMICONDUCTOR HOLDINGS I LTD.', NULL, 'USD', 1, '', 79546, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FSL||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FRESENIUS MEDICAL CARE AG & CO. KGAA', NULL, 'USD', 1, '', 75982, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FMS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FRESENIUS MEDICAL CARE AG & CO. KGAA ST', 'DE0005785802', 'EUR', 1, '|DAX|DEUTSCHEBOERSE|', 81158, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005785802||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FRESENIUS MEDICAL CARE AG & CO. KGAA VZ', 'DE0005785836', 'EUR', 1, '|DEUTSCHEBOERSE|', 81159, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005785836||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FRESENIUS SE & CO. KGAA ', 'DE0005785604', 'EUR', 1, '|DEUTSCHEBOERSE|', 80234, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005785604||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FRESH DEL MONTE PRODUCE INC.', NULL, 'USD', 1, '', 79386, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FDP||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FREY DS', 'FR0011065267', 'EUR', 1, '|EURONEXT|', 75811, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0011065267||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FREY', 'FR0010588079', 'EUR', 1, '|EURONEXT|', 76116, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010588079||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FROMAGERIES BEL', 'FR0000121857', 'EUR', 1, '|EURONEXT|', 75528, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000121857||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FRONTIER COMMUNICATIONS CORP.', NULL, 'USD', 1, '', 75493, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FTR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FRONTIER OIL CORP.', NULL, 'USD', 1, '', 75900, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FTO||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FRONTLINE LTD.', NULL, 'USD', 1, '', 79812, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FRO||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FTI CONSULTING INC.', NULL, 'USD', 1, '', 78737, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FCN||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FTSE 100', 'GB0001383545', 'GBP', 3, '', 75930, NULL, NULL, NULL, NULL, 100, 'c', 1, 4, '^FTSE||en||False', false, '{^FTSE,NULL,INDEXFTSE:UKX,NULL,UK100}', false, 2);
INSERT INTO public.products VALUES ('FTSE LATIBEX ALL SHARE', 'ES0SI0000617', 'EUR', 3, '', 81691, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, NULL, true, '{INDB.MC,NULL,BME:INDB,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FTSE MIB', NULL, 'EUR', 3, '', 81082, NULL, NULL, NULL, NULL, 100, 'c', 1, 6, 'FTSEMIB.MI||it||False', false, '{FTSEMIB.MI,NULL,INDEXFTSE:FTSEMIB,NULL,IT40}', false, 2);
INSERT INTO public.products VALUES ('FTSE4GOODIBX', 'ES0139761003', 'EUR', 4, '', 79015, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0139761003||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FUCHS PETROLUB AG ST', 'DE0005790406', 'EUR', 1, '|DEUTSCHEBOERSE|', 80235, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005790406||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FUCHS PETROLUB AG VZ', 'DE0005790430', 'EUR', 1, '|DEUTSCHEBOERSE|', 80236, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005790430||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FUGRO', 'NL0000352565', 'EUR', 1, '|EURONEXT|', 79700, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0000352565||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FUNESPAÑA', 'ES0140441017', 'EUR', 1, '|MERCADOCONTINUO|', 79016, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0140441017||es||False', false, '{FUN.MC,NULL,BME:FUN,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FUNKWERK AG', 'DE0005753149', 'EUR', 1, '|DEUTSCHEBOERSE|', 81184, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005753149||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FURMANITE CORP.', NULL, 'USD', 1, '', 79794, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FRM||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FURNITURE BRANDS INTERNATIONAL INC.', NULL, 'USD', 1, '', 77676, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FBN||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FUSION-IO INC.', NULL, 'USD', 1, '', 79450, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FIO||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FUT.CLUBE PORTO', 'PTFCP0AM0008', 'EUR', 1, '|EURONEXT|', 75536, NULL, NULL, NULL, NULL, 100, 'c', 1, 9, 'EURONEXT#PTFCP0AM0008||pt||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FUTURO EURO STOXX', NULL, 'EUR', 13, '', 81738, NULL, NULL, NULL, NULL, 100, 'p', 6, 1, NULL, false, '{NULL,NULL,NULL,NULL,STXEc1}', true, 2);
INSERT INTO public.products VALUES ('FUTURO EURO STOXX VOLATILITY', NULL, 'EUR', 13, '', 81740, 'https://www.stoxx.com/index-details?symbol=V2TX', NULL, NULL, NULL, 100, 'p', 100, 1, NULL, false, '{NULL,NULL,NULL,NULL,NULL}', true, 2);
INSERT INTO public.products VALUES ('FUTURO IBEX35 MINI', NULL, 'EUR', 13, '', 81739, NULL, NULL, NULL, NULL, 100, 'p', 1, 1, NULL, false, '{NULL,NULL,NULL,NULL,ES35U9}', true, 2);
INSERT INTO public.products VALUES ('FUTURO MINI SP500', NULL, 'USD', 13, '', 81744, NULL, NULL, NULL, NULL, 100, 'c', 50, 2, NULL, false, '{NULL,NULL,NULL,NULL,ESc1}', true, 2);
INSERT INTO public.products VALUES ('F.VALENCIA GAR.ELECCION OPT.2', 'ES0138228038', 'EUR', 2, '|f_es_BMF|', 77143, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138228038||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('FXCM INC.', NULL, 'USD', 1, '', 80065, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FXCM||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GAESCO EMERGENTFOND', 'ES0140628035', 'EUR', 2, '|f_es_BMF|', 79914, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0140628035||es||False', false, '{NULL,F0GBR04DOB,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GAESCO FONDO DE FONDOS', 'ES0140633035', 'EUR', 2, '|f_es_BMF|', 80534, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0140633035||es||False', false, '{NULL,F0GBR04DOD,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GAESCO FONDO FONDTESORO', 'ES0140642036', 'EUR', 2, '|f_es_BMF|', 80542, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0140642036||es||False', false, '{NULL,F0GBR04DOF,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GAESCO JAPON', 'ES0141113037', 'EUR', 2, '|f_es_BMF|', 80543, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0141113037||es||False', false, '{NULL,F0GBR06FL7,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GAESCO MULTINACIONAL', 'ES0140634033', 'EUR', 2, '|f_es_BMF|', 80545, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0140634033||es||False', false, '{NULL,F0GBR04DOH,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GAESCO PATRIMONIALISTA', 'ES0141114001', 'EUR', 2, '|f_es_BMF|', 80551, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0141114001||es||False', false, '{NULL,F000000K5X,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GAESCO SMALL CAPS', 'ES0113319034', 'EUR', 2, '|f_es_BMF|', 80552, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0113319034||es||False', false, '{NULL,F0GBR04DOJ,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GAESCO T.F.T.', 'ES0138984036', 'EUR', 2, '|f_es_BMF|', 80522, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138984036||es||False', false, '{NULL,F0GBR04Q39,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GAESCOQUANT', 'ES0140643034', 'EUR', 2, '|f_es_BMF|', 80525, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0140643034||es||False', false, '{NULL,F0GBR04Q38,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GAFISA S/A', NULL, 'USD', 1, '', 79231, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GFA||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GAGFAH S.A.', 'LU0269583422', 'EUR', 1, '|DEUTSCHEBOERSE|', 81185, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#LU0269583422||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GALAPAGOS', 'BE0003818359', 'EUR', 1, '|EURONEXT|', 76387, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003818359||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GALP ENERGIA-NOM', 'PTGAL0AM0009', 'EUR', 1, '|EURONEXT|', 80503, NULL, NULL, NULL, NULL, 100, 'c', 1, 9, 'EURONEXT#PTGAL0AM0009||pt||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('G.A.M.', 'ES0141571119', 'EUR', 1, '|MERCADOCONTINUO|', 79036, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0141571119||es||False', false, '{GALQ.MC,NULL,BME:GALQ,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GAMCO INVESTORS INC. CL A', NULL, 'USD', 1, '', 79931, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GBL||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GAMELOFT', 'FR0000079600', 'EUR', 1, '|EURONEXT|', 80508, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000079600||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GAMESTOP CORP. CL A', NULL, 'USD', 1, '', 77222, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GME||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GAMMA HOLDING', 'NL0000355824', 'EUR', 1, '|EURONEXT|', 77474, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0000355824||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GAMMA HOLDING', 'NL0000355865', 'EUR', 1, '|EURONEXT|', 77475, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0000355865||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GAMMON GOLD INC.', NULL, 'USD', 1, '', 75203, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GRS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GANNETT CO. INC.', NULL, 'USD', 1, '', 76554, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GCI||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GANTOIS', 'FR0000064214', 'EUR', 1, '|EURONEXT|', 79199, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000064214||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GAP INC.', NULL, 'USD', 1, '', 79839, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GPS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GARANTIA PLUS 4', 'ES0140896038', 'EUR', 2, '|f_es_BMF|', 76388, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0140896038||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GARDNER DENVER INC.', NULL, 'USD', 1, '', 79318, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GDI||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GARMIN LTD.', 'CH0114405324', 'USD', 1, '|NASDAQ100|', 77554, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'GRMN||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GARTNER INC.', NULL, 'USD', 1, '', 75719, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#IT||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GASCOGNE', 'FR0000124414', 'EUR', 1, '|EURONEXT|', 78605, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000124414||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GATX CORP.', NULL, 'USD', 1, '', 76985, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GMT||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GAUMONT', 'FR0000034894', 'EUR', 1, '|EURONEXT|', 78608, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000034894||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GAYLORD ENTERTAINMENT CO.', NULL, 'USD', 1, '', 76924, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GET||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GBL', 'BE0003797140', 'EUR', 1, '|EURONEXT|', 78491, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003797140||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GBL STRIP', 'BE0005588596', 'EUR', 1, '|EURONEXT|', 79226, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0005588596||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GDF SUEZ STRIP VV', 'BE0005628020', 'EUR', 1, '|EURONEXT|', 79227, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0005628020||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GDS MOULINS STRAS.', 'FR0000064180', 'EUR', 1, '|EURONEXT|', 79237, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000064180||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GDS (S) RUSAL', 'US9098832093', 'EUR', 1, '|EURONEXT|', 79236, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#US9098832093||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GEA GRENOBL.ELECT.', 'FR0000053035', 'EUR', 1, '|EURONEXT|', 78539, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000053035||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GEA GROUP AKTIENGESELLSCHAFT', 'DE0006602006', 'EUR', 1, '|DEUTSCHEBOERSE|', 81186, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0006602006||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GECI INTL', 'FR0000079634', 'EUR', 1, '|EURONEXT|', 77374, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000079634||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GECIMED', 'FR0000061566', 'EUR', 1, '|EURONEXT|', 76228, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000061566||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GECINA NOM.', 'FR0010040865', 'EUR', 1, '|EURONEXT|', 78289, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010040865||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GE.INVERSION', 'ES0141960635', 'EUR', 1, '|MERCADOCONTINUO|', 79051, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0141960635||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GEMALTO', 'NL0000400653', 'EUR', 1, '|EURONEXT|', 78291, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#NL0000400653||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GENCO SHIPPING & TRADING LTD.', NULL, 'USD', 1, '', 79893, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GNK||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GENCORP INC.', NULL, 'USD', 1, '', 79922, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GY||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GENERAC HOLDINGS INC.', NULL, 'USD', 1, '', 78448, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GNRC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GENERAL CABLE CORP.', NULL, 'USD', 1, '', 79080, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#BGC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GENERAL DYNAMICS CORP.', NULL, 'USD', 1, '', 75244, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GD||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GENERAL ELECT.CERT', 'BE0004399342', 'EUR', 1, '|EURONEXT|', 77522, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0004399342||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GENERAL ELECT.CERT', 'BE0004609500', 'EUR', 1, '|EURONEXT|', 77857, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0004609500||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GENERAL ELECTRIC CO.', NULL, 'USD', 1, '', 75728, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GE||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GENERAL ELECTRIC', 'US3696041033', 'EUR', 1, '|EURONEXT|', 79516, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#US3696041033||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GENERAL GROWTH PROPERTIES INC.', NULL, 'USD', 1, '', 77076, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GGP||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GENERAL MARITIME CORP.', NULL, 'USD', 1, '', 76433, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GMR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GENERAL MILLS INC.', NULL, 'USD', 1, '', 76869, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GIS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GENERAL MOTORS CO.', NULL, 'USD', 1, '', 77254, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GM||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GENERAL STEEL HOLDINGS INC.', NULL, 'USD', 1, '', 80598, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GSI||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GENERALE DE SANTE', 'FR0000044471', 'EUR', 1, '|EURONEXT|', 79517, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000044471||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GENERALI ASSICURAZIONI', 'IT0000062072', 'EUR', 1, '|EUROSTOXX|', 75302, NULL, NULL, NULL, NULL, 100, 'c', 1, 6, 'G.MI||it||False', false, '{G.MI,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GENERIX DS', 'FR0011120765', 'EUR', 1, '|EURONEXT|', 77540, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0011120765||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GENERIX', 'FR0010501692', 'EUR', 1, '|EURONEXT|', 77377, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010501692||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GENESCO INC.', NULL, 'USD', 1, '', 81607, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GCO||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GENESEE & WYOMING INC. CL A', NULL, 'USD', 1, '', 76451, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GWR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GENIE ENERGY LTD. CL B', NULL, 'USD', 1, '', 80998, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GNE||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GENON ENERGY INC.', NULL, 'USD', 1, '', 76683, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GEN||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GENPACT LTD.', NULL, 'USD', 1, '', 79112, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#G||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GENUINE PARTS CO.', NULL, 'USD', 1, '', 77383, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GPC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GENWORTH FINANCIAL INC. CL A', NULL, 'USD', 1, '', 76545, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GNW||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GENZYME CORPORATION', 'US3729171047', 'USD', 1, '|NASDAQ100|', 77587, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'GENZ||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GEO GROUP INC.', NULL, 'USD', 1, '', 79240, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GEO||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GEO ORD.B', 'MXP3142C1177', 'EUR', 1, '|MERCADOCONTINUO|', 79088, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#MXP3142C1177||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GEORGIA GULF CORP.', NULL, 'USD', 1, '', 78057, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GGC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GERATHERM MEDICAL AG', 'DE0005495626', 'EUR', 1, '|DEUTSCHEBOERSE|', 81187, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005495626||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GERBER SCIENTIFIC INC.', NULL, 'USD', 1, '', 77769, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GRB||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GERDAU PREF.', 'BRGGBRACNPR8', 'EUR', 1, '|MERCADOCONTINUO|', 79135, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#BRGGBRACNPR8||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GEROVA FINANCIAL GROUP LTD.', NULL, 'USD', 1, '', 75652, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GFC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GERRESHEIMER AG', 'DE000A0LD6E6', 'EUR', 1, '|DEUTSCHEBOERSE|', 81188, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE000A0LD6E6||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GERRY WEBER INTERNATIONAL AG', 'DE0003304101', 'EUR', 1, '|DEUTSCHEBOERSE|', 81189, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0003304101||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GESCAFONDO', 'ES0124506033', 'EUR', 2, '|f_es_BMF|', 80568, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0124506033||es||False', false, '{NULL,F0GBR04Q3S,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GESCO AG', 'DE0005875900', 'EUR', 1, '|DEUTSCHEBOERSE|', 75087, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005875900||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GESCO AG', 'DE000A1K0201', 'EUR', 1, '|DEUTSCHEBOERSE|', 81190, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE000A1K0201||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GESCONSULT CRECIMIENTO', 'ES0138911039', 'EUR', 2, '|f_es_BMF|', 80571, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138911039||es||False', false, '{NULL,F0GBR04JRT,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GESCONSULT INTERNACIONAL', 'ES0142097031', 'EUR', 2, '|f_es_BMF|', 80569, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0142097031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GESCONSULT RENTA FIJA FLEXIBLE', 'ES0138217031', 'EUR', 2, '|f_es_BMF|', 80572, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138217031||es||False', false, '{NULL,F0GBR04DSP,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GESCONSULT RENTA VARIABLE', 'ES0137381036', 'EUR', 2, '|f_es_BMF|', 80573, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137381036||es||False', false, '{NULL,F0GBR04DSL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GESCONSULT RENTA VARIABLE FLEXI.', 'ES0175604034', 'EUR', 2, '|f_es_BMF|', 80574, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0175604034||es||False', false, '{NULL,F0GBR04DSR,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GESCONSULT TESORERIA', 'ES0138922036', 'EUR', 2, '|f_es_BMF|', 80570, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138922036||es||False', false, '{NULL,F0GBR04DST,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GESCOOPERATIVO ALPH.MULTIGESTION', 'ES0142098005', 'EUR', 2, '|f_es_BMF|', 77661, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0142098005||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GESCOOPERATIVO DEUDA CORPORATIVA', 'ES0158603037', 'EUR', 2, '|f_es_BMF|', 75868, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0158603037||es||False', false, '{NULL,F0GBR05XQB,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GESCOOPERATIVO DEU.SOBERANA EURO', 'ES0174344038', 'EUR', 2, '|f_es_BMF|', 79915, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0174344038||es||False', false, '{NULL,F0000006PZ,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GESCOOPERATIVO DINAMICO', 'ES0142163031', 'EUR', 2, '|f_es_BMF|', 75910, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0142163031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GESCOOPERATIVO DIVIDENDO EURO', 'ES0174389033', 'EUR', 2, '|f_es_BMF|', 76403, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0174389033||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GESCOOPERATIVO FONDEPOSITO', 'ES0142099003', 'EUR', 2, '|f_es_BMF|', 75911, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0142099003||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GESCOOPERATIVO FONDEPOSITO PLUS', 'ES0142044009', 'EUR', 2, '|f_es_BMF|', 79953, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0142044009||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GESCOOPERATIVO MUL. ALTERNATIVAS', 'ES0158602039', 'EUR', 2, '|f_es_BMF|', 77756, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0158602039||es||False', false, '{NULL,F0GBR054QR,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GESCOOPERATIVO SMALL CAPS, FI', 'ES0141986002', 'EUR', 2, '|f_es_BMF|', 79958, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0141986002||es||False', false, '{NULL,F000001WF3,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GESDIVISA', 'ES0142437039', 'EUR', 2, '|f_es_BMF|', 80601, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0142437039||es||False', false, '{NULL,F0GBR04PTT,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GESIURIS CAPITAL 1', 'ES0116845035', 'EUR', 2, '|f_es_BMF|', 80602, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0116845035||es||False', false, '{NULL,F0GBR04FM0,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GESIURIS CAPITAL 2', 'ES0116829039', 'EUR', 2, '|f_es_BMF|', 80605, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0116829039||es||False', false, '{NULL,F0GBR04FM2,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GESIURIS CAPITAL 3', 'ES0109695033', 'EUR', 2, '|f_es_BMF|', 80606, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0109695033||es||False', false, '{NULL,F0000001Y0,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GESMADRID BOLSA EUROPEA 8', 'ES0109696007', 'EUR', 2, '|f_es_BMF|', 80608, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0109696007||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GESRIOJA', 'ES0142440033', 'EUR', 2, '|f_es_BMF|', 80609, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0142440033||es||False', false, '{NULL,F0GBR04PTX,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GESTIOHNA BOLSA DINAMICA', 'ES0116830003', 'EUR', 2, '|f_es_BMF|', 80610, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0116830003||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GESTIOHNA DINERO.', 'ES0152505006', 'EUR', 2, '|f_es_BMF|', 77228, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0152505006||es||False', false, '{NULL,F000000R6X,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GESTIOHNA MODERADO', 'ES0116846009', 'EUR', 2, '|f_es_BMF|', 80668, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0116846009||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GETTY REALTY CORP.', NULL, 'USD', 1, '', 77782, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GTY||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GEVELOT', 'FR0000033888', 'EUR', 1, '|EURONEXT|', 76744, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000033888||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GFI GROUP INC.', NULL, 'USD', 1, '', 79972, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GFIG||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GFI INFORMATIQUE', 'FR0004038099', 'EUR', 1, '|EURONEXT|', 76120, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0004038099||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GFK SE', 'DE0005875306', 'EUR', 1, '|DEUTSCHEBOERSE|', 81191, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005875306||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GFT TECHNOLOGIES AG', 'DE0005800601', 'EUR', 1, '|DEUTSCHEBOERSE|', 81192, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005800601||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GIANT INTERACTIVE GROUP INC.', NULL, 'USD', 1, '', 77801, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GA||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GIFI', 'FR0000075095', 'EUR', 1, '|EURONEXT|', 78304, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000075095||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GIFIBSAAR7 JUL15', 'FR0010753301', 'EUR', 1, '|EURONEXT|', 78292, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010753301||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GIGASET AG', 'DE0005156004', 'EUR', 1, '|DEUTSCHEBOERSE|', 81193, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005156004||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GILDAN ACTIVEWEAR INC.', NULL, 'USD', 1, '', 78800, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GIL||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GILDEMEISTER AG', 'DE0005878003', 'EUR', 1, '|DEUTSCHEBOERSE|', 81194, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005878003||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GILEAD SCIENCES, INC.', 'US3755581036', 'USD', 1, '|NASDAQ100|', 77426, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'GILD||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GIMV', 'BE0003699130', 'EUR', 1, '|EURONEXT|', 76164, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003699130||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GIORGIO FEDON', 'IT0001210050', 'EUR', 1, '|EURONEXT|', 78499, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#IT0001210050||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GK SOFTWARE AG', 'DE0007571424', 'EUR', 1, '|DEUTSCHEBOERSE|', 81195, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0007571424||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GL EVENTS', 'FR0000066672', 'EUR', 1, '|EURONEXT|', 80218, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000066672||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GLATFELTER', NULL, 'USD', 1, '', 79556, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GLT||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GLAXOSMITHKLINE PLC', NULL, 'USD', 1, '', 78995, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GSK||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GLIMCHER REALTY TRUST', NULL, 'USD', 1, '', 77835, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GRT||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GLINTT', 'PTPAD0AM0007', 'EUR', 1, '|EURONEXT|', 79526, NULL, NULL, NULL, NULL, 100, 'c', 1, 9, 'EURONEXT#PTPAD0AM0007||pt||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GLOBAL ASSETS FUND', 'ES0142536038', 'EUR', 2, '|f_es_BMF|', 80694, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0142536038||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GLOBAL BEST SELECTION', 'ES0142233032', 'EUR', 2, '|f_es_BMF|', 80669, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0142233032||es||False', false, '{NULL,F0000003WD,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GLOBAL CASH ACCESS HOLDINGS INC.', NULL, 'USD', 1, '', 79815, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GCA||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GLOBAL GEOPHYSICAL SERVICES INC.', NULL, 'USD', 1, '', 80035, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GGS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GLOBAL GRAPHICS', 'FR0004152221', 'EUR', 1, '|EURONEXT|', 79527, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#FR0004152221||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GLOBAL MANAGERS FUND', 'ES0131304034', 'EUR', 2, '|f_es_BMF|', 77758, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0131304034||es||False', false, '{NULL,F0GBR05SJI,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GLOBAL PAYMENTS INC.', NULL, 'USD', 1, '', 77162, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GPN||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GLOBAL SHIP LEASE INC. CL A', NULL, 'USD', 1, '', 78119, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GSL||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GMX RESOURCES INC.', NULL, 'USD', 1, '', 81031, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GMXR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GNC HOLDINGS INC. CL A', NULL, 'USD', 1, '', 77780, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GNC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GOACO MIXTO', 'ES0142551037', 'EUR', 2, '|f_es_BMF|', 80670, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0142551037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GOL LINHAS AEREAS INTELIGENTES S.A.', NULL, 'USD', 1, '', 75193, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GOL||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GOLD FIELDS LTD.', NULL, 'USD', 1, '', 76594, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GFI||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GOLDCORP INC.', NULL, 'USD', 1, '', 76850, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GG||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GOLDFIELDS(X.DRIEF', 'BE0004529674', 'EUR', 1, '|EURONEXT|', 77011, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0004529674||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GOLDMAN SACHS GROUP INC.', NULL, 'USD', 1, '', 76820, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GOODRICH CORP.', NULL, 'USD', 1, '', 75976, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GOODRICH PETROLEUM CORP.', NULL, 'USD', 1, '', 79647, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GDP||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GOODYEAR CERT', 'BE0004359916', 'EUR', 1, '|EURONEXT|', 77385, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0004359916||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GOODYEAR TIRE & RUBBER CO.', NULL, 'USD', 1, '', 75727, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GT||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GOOGLE INC.', 'US38259P5089', 'USD', 1, '|NASDAQ100|', 75644, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'GOOG||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('G.OPEN BSAAR1014', 'FR0010518654', 'EUR', 1, '|EURONEXT|', 77006, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010518654||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GOVERNMENT PROPERTIES INCOME TRUST', NULL, 'USD', 1, '', 78404, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GOV||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GOVERNOR & CO. OF THE BANK OF IRELAND', NULL, 'USD', 1, '', 76717, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#IRE||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GP STRATEGIES CORP.', NULL, 'USD', 1, '', 80953, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GPX||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GPE DIFFUSION PLUS', 'FR0000053449', 'EUR', 1, '|EURONEXT|', 78506, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000053449||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GPE EUROTUN.BS 07', 'FR0010452441', 'EUR', 1, '|EURONEXT|', 77391, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010452441||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GPE GROUP PIZZORNO', 'FR0010214064', 'EUR', 1, '|EURONEXT|', 79578, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010214064||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GRACO INC.', NULL, 'USD', 1, '', 78918, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GGG||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GRAFTECH INTERNATIONAL LTD.', NULL, 'USD', 1, '', 78952, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GTI||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GRAHAM PACKAGING CO. INC.', NULL, 'USD', 1, '', 75602, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GRM||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GRAINES VOLTZ', 'FR0000065971', 'EUR', 1, '|EURONEXT|', 79579, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000065971||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GRAMERCY CAPITAL CORP.', NULL, 'USD', 1, '', 80176, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GKK||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GRAMMER AG', 'DE0005895403', 'EUR', 1, '|DEUTSCHEBOERSE|', 81196, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005895403||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GRAND MARNIER', 'FR0000038036', 'EUR', 1, '|EURONEXT|', 79580, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000038036||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GRANDES CUENTAS BANESTO', 'ES0143068031', 'EUR', 2, '|f_es_BMF|', 80738, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0143068031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GRANITE CONSTRUCTION INC.', NULL, 'USD', 1, '', 77464, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GVA||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GRAPHIC PACKAGING HOLDING CO.', NULL, 'USD', 1, '', 80900, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GPK||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GRAPHIT KROPFMÜHL AKTIE', 'DE0005896005', 'EUR', 1, '|DEUTSCHEBOERSE|', 75066, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005896005||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GRAY TELEVISION INC.', NULL, 'USD', 1, '', 77621, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GTN||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GREAT PLAINS ENERGY INC.', NULL, 'USD', 1, '', 78866, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GXP||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GREATBATCH INC.', NULL, 'USD', 1, '', 79619, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GB||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GREEN DOT CORP. CL A', NULL, 'USD', 1, '', 79616, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GDOT||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GREENBRIER COS.', NULL, 'USD', 1, '', 79624, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GBX||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GREENHILL & CO. INC.', NULL, 'USD', 1, '', 78025, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GHL||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GREIF INC. CL A', NULL, 'USD', 1, '', 81621, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GEF||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GR.ELEKTRA', 'MX01EL000003', 'EUR', 1, '|MERCADOCONTINUO|', 81370, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#MX01EL000003||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GR.EMP.ENCE', 'ES0130625512', 'EUR', 1, '|MERCADOCONTINUO|', 79141, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0130625512||es||False', false, '{ENC.MC,NULL,BME:ENC,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GRENKELEASING AG', 'DE0005865901', 'EUR', 1, '|DEUTSCHEBOERSE|', 81197, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005865901||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GRIFFON CORP.', NULL, 'USD', 1, '', 77746, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GFF||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GRIFOLS CLASE A', 'ES0171996087 ', 'EUR', 1, '|IBEX|MERCADOCONTINUO|', 81734, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, NULL, false, '{GRF.MC,NULL,BME:GRF,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GRIFOLS S.A.', 'ES0171996012', 'EUR', 1, '', 79142, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0171996012||es||False', true, '{GRF.MC,NULL,BME:GRF,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GR.MODELO C', 'MXP4833F1044', 'EUR', 1, '|MERCADOCONTINUO|', 81371, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#MXP4833F1044||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GRONTMIJ', 'NL0000853034', 'EUR', 1, '|EURONEXT|', 79582, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0000853034||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GROOTHANDELSGEBOUW', 'NL0000440824', 'EUR', 1, '|EURONEXT|', 79584, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0000440824||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GROPEN BSAAR0914', 'FR0010518688', 'EUR', 1, '|EURONEXT|', 79585, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010518688||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GROUP 1 AUTOMOTIVE INC.', NULL, 'USD', 1, '', 81620, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GPI||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GROUPE ARES', 'FR0000072167', 'EUR', 1, '|EURONEXT|', 78302, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000072167||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GROUPE CRIT', 'FR0000036675', 'EUR', 1, '|EURONEXT|', 79590, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000036675||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GROUPE EUROTUNNEL', 'FR0010533075', 'EUR', 1, '|EURONEXT|', 79591, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010533075||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GROUPE FLO', 'FR0004076891', 'EUR', 1, '|EURONEXT|', 75943, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0004076891||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GROUPE GO SPORT', 'FR0000072456', 'EUR', 1, '|EURONEXT|', 77387, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000072456||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GROUPE GORGE', 'FR0000062671', 'EUR', 1, '|EURONEXT|', 79593, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000062671||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GROUPE GUILLIN', 'FR0000051831', 'EUR', 1, '|EURONEXT|', 77915, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000051831||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GROUPE JAJ', 'FR0004010338', 'EUR', 1, '|EURONEXT|', 79636, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0004010338||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GROUPE OPEN', 'FR0004050300', 'EUR', 1, '|EURONEXT|', 79944, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0004050300||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GROUPE PARTOUCHE', 'FR0000053548', 'EUR', 1, '|EURONEXT|', 76139, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000053548||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GROUPE STERIA', 'FR0000072910', 'EUR', 1, '|EURONEXT|', 79948, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000072910||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GROUPE VIAL', 'FR0010340406', 'EUR', 1, '|EURONEXT|', 80524, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010340406||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GRPE EUROTUNNEL NV', 'FR0010978825', 'EUR', 1, '|EURONEXT|', 75069, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010978825||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GRPE PARTOUCHE DS', 'FR0011040377', 'EUR', 1, '|EURONEXT|', 75043, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0011040377||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GRUBB & ELLIS CO.', NULL, 'USD', 1, '', 78853, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GBE||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GRUMA S.A.B. DE C.V.', NULL, 'USD', 1, '', 79970, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GMK||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GRUPO AEROPORTUARIO DEL PACIFICO S.A.B. DE C.V.', NULL, 'USD', 1, '', 78029, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#PAC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GRUPO AEROPORTUARIO DEL SURESTE S.A.B. DE C.V.', NULL, 'USD', 1, '', 77969, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ASR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GRUPO CASA SABA S.A.B. DE C.V.', NULL, 'USD', 1, '', 81067, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#SAB||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GRUPO CATALANA OCCIDENTE', 'ES0116920333', 'EUR', 1, '|MERCADOCONTINUO|', 79136, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0116920333||es||False', false, '{GCO.MC,NULL,BME:GCO,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GRUPO RADIO CENTRO S.A.B. DE C.V.', NULL, 'USD', 1, '', 78558, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#RC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GRUPO TAVEX', 'ES0108180219', 'EUR', 1, '|MERCADOCONTINUO|', 81513, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0108180219||es||False', false, '{TVX.MC,NULL,BME:TVX,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GRUPO TELEVISA S.A. DE C.V.', NULL, 'USD', 1, '', 79307, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#TV||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GRUPO TMM S.A.B.', NULL, 'USD', 1, '', 78117, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#TMM||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GRUPOSURA', 'COT13PA00011', 'EUR', 1, '|MERCADOCONTINUO|', 81372, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#COT13PA00011||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GSW IMMOBILIEN AG', 'DE000GSW1111', 'EUR', 1, '|DEUTSCHEBOERSE|', 81198, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE000GSW1111||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GUANGSHEN RAILWAY CO. LTD.', NULL, 'USD', 1, '', 80913, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GSH||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GUERBET', 'FR0000032526', 'EUR', 1, '|EURONEXT|', 80526, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000032526||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GUESS? INC.', NULL, 'USD', 1, '', 77223, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GES||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GUILLEMOT', 'FR0000066722', 'EUR', 1, '|EURONEXT|', 80532, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000066722||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GULFMARK OFFSHORE INC. (CL A)', NULL, 'USD', 1, '', 77976, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GLF||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GUSHAN ENVIRONMENTAL ENERGY LTD.', NULL, 'USD', 1, '', 81070, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#GU||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GUY DEGRENNE', 'FR0004035061', 'EUR', 1, '|EURONEXT|', 80535, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0004035061||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GUYENNE GASCOGNE', 'FR0000120289', 'EUR', 1, '|EURONEXT|', 79598, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000120289||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('GWB IMMOBILIEN AG', 'DE000A0JKHG0', 'EUR', 1, '|DEUTSCHEBOERSE|', 81199, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE000A0JKHG0||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HAEMONETICS CORP.', NULL, 'USD', 1, '', 78883, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HAE||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HAL TRUST', 'BMG455841020', 'EUR', 1, '|EURONEXT|', 76687, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#BMG455841020||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HALLIBURTON CO.', NULL, 'USD', 1, '', 75783, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HAL||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HAMBORNER REIT AG', 'DE0006013006', 'EUR', 1, '|DEUTSCHEBOERSE|', 80204, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0006013006||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HAMBURGER HAFEN UND LOGISTIK AG', 'DE000A0S8488', 'EUR', 1, '|DEUTSCHEBOERSE|', 80286, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE000A0S8488||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HAMON', 'BE0003700144', 'EUR', 1, '|EURONEXT|', 78540, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003700144||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HAMON STRIP', 'BE0005529970', 'EUR', 1, '|EURONEXT|', 77530, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0005529970||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HANESBRANDS INC.', NULL, 'USD', 1, '', 76477, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HBI||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HANG SENG', 'XC0009692762', 'CNY', 3, '', 81091, NULL, NULL, NULL, NULL, 100, 'c', 1, 8, '^HSI||cn||False', false, '{^HSI,NULL,INDEXHANGSENG:HSI,NULL,HK50}', false, 2);
INSERT INTO public.products VALUES ('HANGER ORTHOPEDIC GROUP INC.', NULL, 'USD', 1, '', 79447, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HGR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HANNOVER RÜCKVERSICHERUNG AG', 'DE0008402215', 'EUR', 1, '|DEUTSCHEBOERSE|', 80287, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0008402215||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HANOVER INSURANCE GROUP INC.', NULL, 'USD', 1, '', 75522, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#THG||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HANSA GROUP AG', 'DE0007608606', 'EUR', 1, '|DEUTSCHEBOERSE|', 81217, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0007608606||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HARBINGER GROUP INC.', NULL, 'USD', 1, '', 81064, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HRG||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HARBOURVEST HVGPE', 'GG00B28XHD63', 'EUR', 1, '|EURONEXT|', 77533, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#GG00B28XHD63||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HARLEY-DAVIDSON INC.', NULL, 'USD', 1, '', 75923, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HOG||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HARMAN INTERNATIONAL INDUSTRIES INC.', NULL, 'USD', 1, '', 75272, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HAR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HARMONY CERT', 'BE0004558962', 'EUR', 1, '|EURONEXT|', 78541, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0004558962||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HARMONY GOLD MINING CO. LTD.', NULL, 'USD', 1, '', 75165, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HMY||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HARRIS CORP.', NULL, 'USD', 1, '', 76333, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HRS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HARRY WINSTON DIAMOND CORP.', NULL, 'USD', 1, '', 78440, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HWD||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HARSCO CORP.', NULL, 'USD', 1, '', 77595, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HSC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HARTE-HANKS INC.', NULL, 'USD', 1, '', 77805, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HHS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HARTFORD FINANCIAL SERVICES GROUP INC.', NULL, 'USD', 1, '', 76995, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HIG||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HARVEST NATURAL RESOURCES INC.', NULL, 'USD', 1, '', 79886, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HNR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HATTERAS FINANCIAL CORP.', NULL, 'USD', 1, '', 78662, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HTS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HAULOTTE GROUP', 'FR0000066755', 'EUR', 1, '|EURONEXT|', 76140, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000066755||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HAVAS', 'FR0000121881', 'EUR', 1, '|EURONEXT|', 78542, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000121881||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HAVBSAAR2013', 'FR0010355644', 'EUR', 1, '|EURONEXT|', 78038, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010355644||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HAVERTY FURNITURE COS. INC.', NULL, 'USD', 1, '', 80954, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HVT||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HAWAIIAN ELECTRIC INDUSTRIES INC.', NULL, 'USD', 1, '', 75177, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HE||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HAWESKO HOLDING AG', 'DE0006042708', 'EUR', 1, '|DEUTSCHEBOERSE|', 81218, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0006042708||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('H.B. FULLER CO.', NULL, 'USD', 1, '', 76825, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#FUL||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HCA HOLDINGS INC.', NULL, 'USD', 1, '', 78846, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HCA||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HCC INSURANCE HOLDINGS INC.', NULL, 'USD', 1, '', 78859, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HCC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HCI CAPITAL AG', 'DE000A0D9Y97', 'EUR', 1, '|DEUTSCHEBOERSE|', 81219, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE000A0D9Y97||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HCP INC.', NULL, 'USD', 1, '', 78811, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HCP||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HDFC BANK LTD.', NULL, 'USD', 1, '', 75336, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HDB||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HEADWATERS INC.', NULL, 'USD', 1, '', 77518, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HW||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HEALTH CARE REIT INC.', NULL, 'USD', 1, '', 78815, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HCN||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HEALTH MANAGEMENT ASSOCIATES INC. CL A', NULL, 'USD', 1, '', 79100, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HMA||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HEALTH NET INC.', NULL, 'USD', 1, '', 75808, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HNT||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HEALTHCARE REALTY TRUST INC.', NULL, 'USD', 1, '', 79099, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HEALTHSOUTH CORP.', NULL, 'USD', 1, '', 80889, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HLS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HEALTHSPRING INC.', NULL, 'USD', 1, '', 78343, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HEARTLAND PAYMENT SYSTEMS INC.', NULL, 'USD', 1, '', 79429, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HPY||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HECLA MINING CO.', NULL, 'USD', 1, '', 75666, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HL||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HEICO CORP.', NULL, 'USD', 1, '', 78711, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HEI||us||False', false, '{NULL,NULL,NYSE:HEI,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HEIDELBERGCEMENT AG', 'DE0006047004', 'EUR', 1, '|DEUTSCHEBOERSE|', 81220, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0006047004||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HEIDELBERGER DRUCKMASCHINEN AG', 'DE0007314007', 'EUR', 1, '|DEUTSCHEBOERSE|', 81265, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0007314007||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HEIJMANS', 'NL0009269109', 'EUR', 1, '|EURONEXT|', 78609, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0009269109||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HEINEKEN HOLDING', 'NL0000008977', 'EUR', 1, '|EURONEXT|', 78294, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0000008977||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HEINEKEN', 'NL0000009165', 'EUR', 1, '|EURONEXT|', 79599, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0000009165||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HELIAD EQUITY PARTNERS GMBH & CO. KGAA', 'DE000A0L1NN5', 'EUR', 1, '|DEUTSCHEBOERSE|', 81266, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE000A0L1NN5||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HELIX ENERGY SOLUTIONS GROUP INC.', NULL, 'USD', 1, '', 78806, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HLX||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HELMERICH & PAYNE INC.', NULL, 'USD', 1, '', 77077, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HP||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HENEX', 'BE0003873909', 'EUR', 1, '|EURONEXT|', 80536, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003873909||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HENKEL AG & CO. KGAA ST', 'DE0006048408', 'EUR', 1, '|DAX|DEUTSCHEBOERSE|', 81267, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0006048408||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HENKEL AG & CO. KGAA VZ', 'DE0006048432', 'EUR', 1, '|DEUTSCHEBOERSE|', 81269, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0006048432||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HENRI MAIRE', 'FR0000061087', 'EUR', 1, '|EURONEXT|', 77039, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000061087||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HENRY SCHEIN, INC.', 'US8064071025', 'USD', 1, '|NASDAQ100|', 76319, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'HSIC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HERBALIFE LTD.', NULL, 'USD', 1, '', 77068, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HLF||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HERCULES MONETARIO PLUS', 'ES0144083039', 'EUR', 2, '|f_es_BMF|', 80740, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0144083039||es||False', false, '{NULL,F0GBR06U6N,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HERMES INTL', 'FR0000052292', 'EUR', 1, '|EURONEXT|', 75198, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000052292||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HERSHA HOSPITALITY TRUST CL A', NULL, 'USD', 1, '', 81589, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HT||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HERSHEY CO.', NULL, 'USD', 1, '', 75934, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HSY||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HERTZ GLOBAL HOLDINGS INC.', NULL, 'USD', 1, '', 78520, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HTZ||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HES BEHEER', 'NL0000358125', 'EUR', 1, '|EURONEXT|', 80538, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0000358125||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HESS CORP.', NULL, 'USD', 1, '', 79090, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HES||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HEWLETT-PACKARD CO.', NULL, 'USD', 1, '', 75298, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HPQ||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HEXCEL CORP.', NULL, 'USD', 1, '', 80886, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HXL||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HEXCEL', 'US4282911084', 'EUR', 1, '|EURONEXT|', 80539, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#US4282911084||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HF BSAAR 02AUG2014', 'FR0010492694', 'EUR', 1, '|EURONEXT|', 80544, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010492694||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HF', 'FR0000038531', 'EUR', 1, '|EURONEXT|', 79954, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000038531||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HFF INC. CL A', NULL, 'USD', 1, '', 79684, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HF||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HHGREGG INC.', NULL, 'USD', 1, '', 79901, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HGG||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HIGH CO', 'FR0000054231', 'EUR', 1, '|EURONEXT|', 76595, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000054231||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HIGH RATE', 'ES0144886035', 'EUR', 2, '|f_es_BMF|', 80741, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0144886035||es||False', false, '{NULL,F0GBR04CAJ,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HIGHER ONE HOLDINGS INC.', NULL, 'USD', 1, '', 77718, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ONE||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HIGHLIGHT COMMUNICATIONS AG', 'CH0006539198', 'EUR', 1, '|DEUTSCHEBOERSE|', 81270, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#CH0006539198||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HIGHWOODS PROPERTIES INC.', NULL, 'USD', 1, '', 76475, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HIW||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HILL INTERNATIONAL INC.', NULL, 'USD', 1, '', 81002, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HIL||us||False', false, '{NULL,NULL,NYSE:HIL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HILLENBRAND INC.', NULL, 'USD', 1, '', 79152, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HI||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HILL-ROM HOLDINGS INC.', NULL, 'USD', 1, '', 81591, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HRC||us||False', false, '{HRC,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HILLTOP HOLDINGS INC.', NULL, 'USD', 1, '', 79782, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HTH||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HI-MEDIA', 'FR0000075988', 'EUR', 1, '|EURONEXT|', 76588, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000075988||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HIOLLE INDUSTRIES', 'FR0000077562', 'EUR', 1, '|EURONEXT|', 80053, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000077562||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HITACHI LTD.', NULL, 'USD', 1, '', 76868, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HIT||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HITT', 'NL0000358158', 'EUR', 1, '|EURONEXT|', 76048, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0000358158||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('H.J. HEINZ CO.', NULL, 'USD', 1, '', 76886, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HNZ||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HNI CORP.', NULL, 'USD', 1, '', 79328, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HNI||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HOCHTIEF AG', 'DE0006070006', 'EUR', 1, '|DEUTSCHEBOERSE|', 80794, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0006070006||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HÖFT & WESSEL AG', 'DE0006011000', 'EUR', 1, '|DEUTSCHEBOERSE|', 80288, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0006011000||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HOLLAND COLOURS', 'NL0000440311', 'EUR', 1, '|EURONEXT|', 77715, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0000440311||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HOLLY CORP.', NULL, 'USD', 1, '', 77932, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HOC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HOLLYFRONTIER CORP.', NULL, 'USD', 1, '', 79271, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HFC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HOLOGIC, INC.', 'US4364401012', 'USD', 1, '|NASDAQ100|', 76070, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'HOLX||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HOLOGRAM IND.', 'FR0000062168', 'EUR', 1, '|EURONEXT|', 75200, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000062168||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HOMAG GROUP AG', 'DE0005297204', 'EUR', 1, '|DEUTSCHEBOERSE|', 80247, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005297204||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HOMBURG INVEST A', 'CA4368714040', 'EUR', 1, '|EURONEXT|', 79669, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#CA4368714040||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HOME DEPOT INC.', NULL, 'USD', 1, '', 76399, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HD||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HOME INV.BELG-SIFI', 'BE0003760742', 'EUR', 1, '|EURONEXT|', 80549, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003760742||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HOME PROPERTIES INC.', NULL, 'USD', 1, '', 77356, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HME||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HONDA MOTOR CO. LTD.', NULL, 'USD', 1, '', 76638, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HMC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HONEYWELL INTERNATIONAL INC.', NULL, 'USD', 1, '', 78465, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HON||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HORACE MANN EDUCATORS CORP.', NULL, 'USD', 1, '', 77894, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HMN||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HORIZON LINES INC.', NULL, 'USD', 1, '', 75311, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HRZ||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HORMEL FOODS CORP.', NULL, 'USD', 1, '', 78845, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HRL||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HORNBACH HOLDING AG', 'DE0006083439', 'EUR', 1, '|DEUTSCHEBOERSE|', 80251, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0006083439||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HORNBACH-BAUMARKT-AG', 'DE0006084403', 'EUR', 1, '|DEUTSCHEBOERSE|', 80255, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0006084403||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HORNBECK OFFSHORE SERVICES INC.', NULL, 'USD', 1, '', 76634, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HOS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HOSPIRA INC.', NULL, 'USD', 1, '', 76297, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HSP||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HOSPITALITY PROPERTIES TRUST', NULL, 'USD', 1, '', 78863, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HPT||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HOST HOTELS & RESORTS INC.', NULL, 'USD', 1, '', 78225, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HST||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HOTELS DE PARIS', 'FR0004165801', 'EUR', 1, '|EURONEXT|', 80563, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0004165801||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HOVNANIAN ENTERPRISES INC. CL A', NULL, 'USD', 1, '', 81003, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HOV||us||False', false, '{NULL,NULL,NYSE:HOV,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HOWARD HUGHES CORP.', NULL, 'USD', 1, '', 79345, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HHC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('H&R AG', 'DE0007757007', 'EUR', 1, '|DEUTSCHEBOERSE|', 80203, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0007757007||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('H&R BLOCK INC.', NULL, 'USD', 1, '|SP500|', 75420, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HRB||us||False', false, '{HRB,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HSBC HOLDINGS', 'GB0005405286', 'EUR', 1, '|EURONEXT|', 75201, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#GB0005405286||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HSBC HOLDINGS PLC', NULL, 'USD', 1, '', 78260, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HBC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HUANENG POWER INTERNATIONAL INC.', NULL, 'USD', 1, '', 76569, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HNP||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HUBWOO', 'FR0004052561', 'EUR', 1, '|EURONEXT|', 80565, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0004052561||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HUDBAY MINERALS INC.', NULL, 'USD', 1, '', 77652, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HBM||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HUDSON PACIFIC PROPERTIES INC.', NULL, 'USD', 1, '', 78760, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HPP||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HUDSON VALLEY HOLDING CORP.', NULL, 'USD', 1, '', 79763, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HVB||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HUGO BOSS AG ST', 'DE0005245500', 'EUR', 1, '|DEUTSCHEBOERSE|', 81271, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005245500||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HUGO BOSS AG VZ', 'DE0005245534', 'EUR', 1, '|DEUTSCHEBOERSE|', 80264, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005245534||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HUIS CLOS', 'FR0000072357', 'EUR', 1, '|EURONEXT|', 80566, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000072357||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HUMANA INC.', NULL, 'USD', 1, '', 75357, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HUM||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HUNTER DOUGLAS', 'ANN4327C1220', 'EUR', 1, '|EURONEXT|', 75213, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#ANN4327C1220||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HUNTER DOUGLAS', 'ANN4327C1303', 'EUR', 1, '|EURONEXT|', 80567, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#ANN4327C1303||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HUNTINGTON INGALLS INDUSTRIES INC.', NULL, 'USD', 1, '', 79052, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HII||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HUNTSMAN CORP.', NULL, 'USD', 1, '', 76520, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HUN||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HYATT HOTELS CORP.', NULL, 'USD', 1, '', 79071, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#H||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HYDRATEC', 'NL0009391242', 'EUR', 1, '|EURONEXT|', 80589, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0009391242||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HYPERCOM CORP.', NULL, 'USD', 1, '', 76973, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HYC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HYPERDYNAMICS CORP.', NULL, 'USD', 1, '', 80943, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#HDY||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('HYPOPORT AG', 'DE0005493365', 'EUR', 1, '|DEUTSCHEBOERSE|', 80265, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005493365||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IAG', 'ES0177542018', 'EUR', 1, '|IBEX|MERCADOCONTINUO|', 81346, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0177542018||es||False', false, '{IAG.MC,NULL,BME:IAG,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IAMGOLD CORP.', NULL, 'USD', 1, '', 75065, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#IAG||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBA (D)', 'BE0003766806', 'EUR', 1, '|EURONEXT|', 79708, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003766806||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBA STRIP (D)', 'BE0005563342', 'EUR', 1, '|EURONEXT|', 80590, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0005563342||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA 3', 'ES0106948039', 'EUR', 2, '|f_es_BMF|', 80742, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0106948039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA ACTIVO GARANTIZADO', 'ES0147103032', 'EUR', 2, '|f_es_BMF|', 77490, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147103032||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA AHORRO DINAMICO, CLASE B', 'ES0184002006', 'EUR', 2, '|f_es_BMF|', 81040, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0184002006||es||False', false, '{NULL,F00000LP94,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA AHORRO DINAMICO', 'ES0184002030', 'EUR', 2, '|f_es_BMF|', 80752, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0184002030||es||False', false, '{NULL,F0GBR054FN,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA AHORRO', 'ES0147173035', 'EUR', 2, '|f_es_BMF|', 80743, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147173035||es||False', false, '{NULL,F0GBR04E3E,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA ALPHA, CLASE B', 'ES0146756012', 'EUR', 2, '|f_es_BMF|', 81042, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0146756012||es||False', false, '{NULL,F00000JTUE,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA ALPHA', 'ES0146756004', 'EUR', 2, '|f_es_BMF|', 81041, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0146756004||es||False', false, '{NULL,F000001VX1,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA BOLSA, CLASE B', 'ES0147186003', 'EUR', 2, '|f_es_BMF|', 80773, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147186003||es||False', false, '{NULL,F00000JTUD,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA BOLSA', 'ES0147186037', 'EUR', 2, '|f_es_BMF|', 81043, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147186037||es||False', false, '{NULL,F0GBR04E3K,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA BOLSA EUROPA, CLASE B', 'ES0130705009', 'EUR', 2, '|f_es_BMF|', 81045, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0130705009||es||False', false, '{NULL,F00000JYXY,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA BOLSA EUROPA', 'ES0130705033', 'EUR', 2, '|f_es_BMF|', 81044, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0130705033||es||False', false, '{NULL,F0GBR04E3G,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA BOLSA GARANTIZADO', 'ES0146842036', 'EUR', 2, '|f_es_BMF|', 80754, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0146842036||es||False', false, '{NULL,F0GBR06UAD,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA BOLSA INTERNACIONAL', 'ES0147641031', 'EUR', 2, '|f_es_BMF|', 80770, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147641031||es||False', false, '{NULL,F0GBR04E3I,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA BOLSA USA, CLASE B', 'ES0147034005', 'EUR', 2, '|f_es_BMF|', 80772, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147034005||es||False', false, '{NULL,F00000LIAM,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA BOLSA USA', 'ES0147034039', 'EUR', 2, '|f_es_BMF|', 80771, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147034039||es||False', false, '{NULL,F0GBR04OTB,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA BP ACCIONES EUROPA, FI', 'ES0146757002', 'EUR', 2, '|f_es_BMF|', 80774, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0146757002||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA BP DIGITAL 2', 'ES0146921004', 'EUR', 2, '|f_es_BMF|', 77400, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0146921004||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA BP GLOBAL BONDS, CLASE B', 'ES0146822012', 'EUR', 2, '|f_es_BMF|', 80775, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0146822012||es||False', false, '{NULL,F00000JYY3,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA BP RENTA FIJA, CLASE B', 'ES0146791019', 'EUR', 2, '|f_es_BMF|', 80863, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0146791019||es||False', false, '{NULL,F00000JZCS,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA BP RENTA FIJA', 'ES0146791001', 'EUR', 2, '|f_es_BMF|', 80807, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0146791001||es||False', false, '{NULL,F000000OT1,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA BP SELECCION GLOBAL', 'ES0146758000', 'EUR', 2, '|f_es_BMF|', 80836, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0146758000||es||False', false, '{NULL,F00000MABF,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA CAPITAL', 'ES0147165031', 'EUR', 2, '|f_es_BMF|', 80837, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147165031||es||False', false, '{NULL,F0GBR04E3M,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA CAPITAL EUROPA', 'ES0102563030', 'EUR', 2, '|f_es_BMF|', 80838, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0102563030||es||False', false, '{NULL,F0GBR04E3W,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA CASH 2', 'ES0147042032', 'EUR', 2, '|f_es_BMF|', 76514, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147042032||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA CASH 3', 'ES0147035036', 'EUR', 2, '|f_es_BMF|', 76515, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147035036||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA CASH', 'ES0147102034', 'EUR', 2, '|f_es_BMF|', 76578, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147102034||es||False', false, '{NULL,F0GBR04K2H,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA CONSERVADOR 1', 'ES0146792009', 'EUR', 2, '|f_es_BMF|', 79959, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0146792009||es||False', false, '{NULL,F000001VLP,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA CONSERVADOR 2', 'ES0146922002', 'EUR', 2, '|f_es_BMF|', 76804, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0146922002||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA CONSERVADOR, CLASE C', 'ES0146792025', 'EUR', 2, '|f_es_BMF|', 79961, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0146792025||None||False', false, '{NULL,F00000MIA1,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA CRECIMIENTO DINAMICO, CLASE B', 'ES0146843000', 'EUR', 2, '|f_es_BMF|', 79999, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0146843000||es||False', false, '{NULL,F00000LP95,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA CRECIMIENTO DINAMICO', 'ES0146843034', 'EUR', 2, '|f_es_BMF|', 80000, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0146843034||es||False', false, '{NULL,F0GBR06XIS,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA DINERO', 'ES0147174033', 'EUR', 2, '|f_es_BMF|', 80001, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147174033||es||False', false, '{NULL,F0GBR04E3Q,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA DIVIDENDO, CLASE B', 'ES0146824018', 'EUR', 2, '|f_es_BMF|', 80003, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0146824018||es||False', false, '{NULL,F00000JZCT,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA DIVIDENDO', 'ES0146824000', 'EUR', 2, '|f_es_BMF|', 80002, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0146824000||es||False', false, '{NULL,F000001VWZ,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA DOBLE OPORTUNIDAD', 'ES0146844032', 'EUR', 2, '|f_es_BMF|', 77729, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0146844032||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA DOLAR, CLASE B', 'ES0146942000', 'EUR', 2, '|f_es_BMF|', 80049, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0146942000||es||False', false, '{NULL,F00000LP97,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA DOLAR', 'ES0146942034', 'EUR', 2, '|f_es_BMF|', 80004, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0146942034||es||False', false, '{NULL,F0GBR06XIU,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA EMERGENTES', 'ES0102562032', 'EUR', 2, '|f_es_BMF|', 80087, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0102562032||es||False', false, '{NULL,F0GBR04E4D,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA EUROPA GARANTIZADO', 'ES0147154035', 'EUR', 2, '|f_es_BMF|', 77766, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147154035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA FINANCIERO', 'ES0147104030', 'EUR', 2, '|f_es_BMF|', 80088, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147104030||es||False', false, '{NULL,F0GBR04K2F,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA FONDTESORO CORTO PLAZO', 'ES0147177036', 'EUR', 2, '|f_es_BMF|', 75960, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147177036||es||False', false, '{NULL,F0GBR04E3O,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA FUTURO, CLASE B', 'ES0147185005', 'EUR', 2, '|f_es_BMF|', 76002, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147185005||es||False', false, '{NULL,F00000JTUF,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA FUTURO', 'ES0147185039', 'EUR', 2, '|f_es_BMF|', 76001, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147185039||es||False', false, '{NULL,F0GBR04E3Y,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA GESTION BP GLOBAL BONDS', 'ES0146822004', 'EUR', 2, '|f_es_BMF|', 76003, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0146822004||es||False', false, '{NULL,F0000006QB,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA GESTION GARANTIZADO 2', 'ES0147193033', 'EUR', 2, '|f_es_BMF|', 76432, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147193033||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA GESTION GARANTIZADO 3', 'ES0146845005', 'EUR', 2, '|f_es_BMF|', 76476, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0146845005||es||False', false, '{NULL,F000002T5A,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA GESTION GARANTIZADO 4', 'ES0146846003', 'EUR', 2, '|f_es_BMF|', 76482, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0146846003||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA GESTION GARANTIZADO 5', 'ES0147106035', 'EUR', 2, '|f_es_BMF|', 76005, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147106035||es||False', false, '{NULL,F0GBR04GUG,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA GESTION GARANTIZADO 6', 'ES0147107009', 'EUR', 2, '|f_es_BMF|', 76483, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147107009||es||False', false, '{NULL,F00000H16W,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA GESTION GARANTIZADO 8', 'ES0147108007', 'EUR', 2, '|f_es_BMF|', 76007, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147108007||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA GESTION GARANTIZADO', 'ES0147036034', 'EUR', 2, '|f_es_BMF|', 76004, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147036034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA H20&ENERGIAS RENOVABLES', 'ES0184004002', 'EUR', 2, '|f_es_BMF|', 76485, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0184004002||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA HIGH YIELD, CLASE B', 'ES0147105003', 'EUR', 2, '|f_es_BMF|', 76038, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147105003||es||False', false, '{NULL,F00000LP96,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA HIGH YIELD', 'ES0147105037', 'EUR', 2, '|f_es_BMF|', 76034, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147105037||es||False', false, '{NULL,F0GBR04K2D,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA HORIZONTE', 'ES0147642039', 'EUR', 2, '|f_es_BMF|', 76051, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147642039||es||False', false, '{NULL,F0GBR04E40,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA INDEX 4', 'ES0147155032', 'EUR', 2, '|f_es_BMF|', 76052, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147155032||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA INTERNACIONAL, CLASE B', 'ES0147184008', 'EUR', 2, '|f_es_BMF|', 76054, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147184008||es||False', false, '{NULL,F00000JYXX,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA INTERNACIONAL', 'ES0147184032', 'EUR', 2, '|f_es_BMF|', 76053, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147184032||es||False', false, '{NULL,F0GBR04E49,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA JAPON, CLASE B', 'ES0147129003', 'EUR', 2, '|f_es_BMF|', 76055, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147129003||es||False', false, '{NULL,F00000JYXW,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA JAPON', 'ES0147129037', 'EUR', 2, '|f_es_BMF|', 76522, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147129037||es||False', false, '{NULL,F0GBR04E4F,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA LATINOAMERICA', 'ES0147075032', 'EUR', 2, '|f_es_BMF|', 76056, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147075032||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA MIXTO FLEXIBLE 15', 'ES0146944006', 'EUR', 2, '|f_es_BMF|', 76057, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0146944006||es||False', false, '{NULL,F00000GVAT,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA NUEVAS OPORTUNIDADES', 'ES0147076030', 'EUR', 2, '|f_es_BMF|', 76524, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147076030||es||False', false, '{NULL,F0GBR04K29,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA OPORTUNIDAD RENTA FIJA, CLASE B', 'ES0184007013', 'EUR', 2, '|f_es_BMF|', 76531, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0184007013||es||False', false, '{NULL,F00000JTVJ,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA OPORTUNIDAD RENTA FIJA', 'ES0184007005', 'EUR', 2, '|f_es_BMF|', 76075, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0184007005||es||False', false, '{NULL,F000002KOK,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA PATRIMONIO DINAMICO', 'ES0147038030', 'EUR', 2, '|f_es_BMF|', 76076, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147038030||es||False', false, '{NULL,F0GBR05UYO,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA PATRIMONIO', 'ES0147187035', 'EUR', 2, '|f_es_BMF|', 76532, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147187035||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA PETROQUIMICO', 'ES0130706031', 'EUR', 2, '|f_es_BMF|', 76077, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0130706031||es||False', false, '{NULL,F0GBR04K2A,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA PREMIER', 'ES0147022034', 'EUR', 2, '|f_es_BMF|', 76083, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147022034||es||False', false, '{NULL,F0GBR04G3L,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA RENTA', 'ES0147166039', 'EUR', 2, '|f_es_BMF|', 76102, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147166039||es||False', false, '{NULL,F0GBR04E4R,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA RENTA EUROPA', 'ES0147146031', 'EUR', 2, '|f_es_BMF|', 76103, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147146031||es||False', false, '{NULL,F0GBR04E3U,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA RENTA FIJA 1 AÑO 1', 'ES0147045001', 'EUR', 2, '|f_es_BMF|', 76104, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147045001||es||False', false, '{NULL,F000000RX7,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA RENTA FIJA 1 AÑO 2', 'ES0147046009', 'EUR', 2, '|f_es_BMF|', 76106, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147046009||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA RENTA FIJA 1 AÑO 3', 'ES0147047007', 'EUR', 2, '|f_es_BMF|', 76579, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147047007||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA RENTA FIJA 1 AÑO 4', 'ES0184005009', 'EUR', 2, '|f_es_BMF|', 81116, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0184005009||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA RENTA FIJA 1 AÑO 5', 'ES0184006007', 'EUR', 2, '|f_es_BMF|', 81118, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0184006007||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA RENTA FIJA 2012', 'ES0147023008', 'EUR', 2, '|f_es_BMF|', 81119, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147023008||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA RENTA FIJA 2013', 'ES0147024006', 'EUR', 2, '|f_es_BMF|', 81120, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147024006||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA RENTA FIJA 2014', 'ES0147025003', 'EUR', 2, '|f_es_BMF|', 76107, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147025003||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA RENTA INTERNACIONAL', 'ES0102564038', 'EUR', 2, '|f_es_BMF|', 76110, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0102564038||es||False', false, '{NULL,F0GBR04E4N,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA RENTA PLUS', 'ES0147194031', 'EUR', 2, '|f_es_BMF|', 76155, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147194031||es||False', false, '{NULL,F0GBR04E4P,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA SANIDAD', 'ES0147195038', 'EUR', 2, '|f_es_BMF|', 76156, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147195038||es||False', false, '{NULL,F0GBR04E4T,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA SECTOR INMOBILIARIO', 'ES0147196036', 'EUR', 2, '|f_es_BMF|', 76158, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147196036||es||False', false, '{NULL,F0GBR04K26,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA SELECCION BOLSA', 'ES0147077038', 'EUR', 2, '|f_es_BMF|', 81047, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147077038||es||False', false, '{NULL,F0GBR04ONX,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA SELECCION CAPITAL', 'ES0147197034', 'EUR', 2, '|f_es_BMF|', 81048, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147197034||es||False', false, '{NULL,F0GBR04OO1,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA SELECCION RENTA FIJA', 'ES0147192035', 'EUR', 2, '|f_es_BMF|', 76159, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147192035||es||False', false, '{NULL,F0GBR04E4H,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA SELECCION RENTA INTERNA', 'ES0147149035', 'EUR', 2, '|f_es_BMF|', 81049, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147149035||es||False', false, '{NULL,F0GBR04E47,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA SELECTIVO GARANTIZADO', 'ES0147198032', 'EUR', 2, '|f_es_BMF|', 77090, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147198032||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA SMALL CAPS', 'ES0130708037', 'EUR', 2, '|f_es_BMF|', 76160, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0130708037||es||False', false, '{NULL,F0GBR04VS8,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA TECNOLOGICO', 'ES0147644035', 'EUR', 2, '|f_es_BMF|', 76161, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147644035||es||False', false, '{NULL,F0GBR04E4V,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERCAJA UTILITIES', 'ES0147189031', 'EUR', 2, '|f_es_BMF|', 81094, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147189031||es||False', false, '{NULL,F0GBR04K24,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERDROLA', 'ES0144580Y14', 'EUR', 1, '|EUROSTOXX|IBEX|MERCADOCONTINUO|', 81347, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0144580Y14||es||True', false, '{IBE.MC,NULL,BME:IBE,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERDROLA RENOVABLES', 'ES0147645016', 'EUR', 1, '|MERCADOCONTINUO|', 78175, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, NULL, true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERIA', 'ES0147200036', 'EUR', 1, '', 76914, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'IBLA.MC||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERPAPEL', 'ES0147561015', 'EUR', 1, '|MERCADOCONTINUO|', 79163, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0147561015||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBERSOL,SGPS', 'PTIBS0AM0008', 'EUR', 1, '|EURONEXT|', 79709, NULL, NULL, NULL, NULL, 100, 'c', 1, 9, 'EURONEXT#PTIBS0AM0008||pt||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBEX 35', 'ES0SI0000005', 'EUR', 3, '', 79329, 'www.bolsamadrid.es', NULL, NULL, NULL, 100, 'c', 1, 1, '^IBEX||es||False', false, '{^IBEX,NULL,INDEXBME:IB,NULL,ES35}', false, 2);
INSERT INTO public.products VALUES ('IBM CERT', 'BE0004607488', 'EUR', 1, '|EURONEXT|', 79070, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0004607488||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBM', 'US4592001014', 'EUR', 1, '|EURONEXT|', 79711, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#US4592001014||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IBS AG', 'DE0006228406', 'EUR', 1, '|DEUTSCHEBOERSE|', 81272, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0006228406||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ICADE', 'FR0000035081', 'EUR', 1, '|EURONEXT|', 79712, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000035081||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ICICI BANK LTD.', NULL, 'USD', 1, '', 75348, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#IBN||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ICT AUTOMATISERING', 'NL0000359537', 'EUR', 1, '|EURONEXT|', 79713, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0000359537||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ID FUTURE', 'FR0000060410', 'EUR', 1, '|EURONEXT|', 79716, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000060410||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IDACORP INC.', NULL, 'USD', 1, '', 76776, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#IDA||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IDEX CORP.', NULL, 'USD', 1, '', 76257, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#IEX||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IDI', 'FR0000051393', 'EUR', 1, '|EURONEXT|', 79720, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000051393||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IDT CORP. CL B', NULL, 'USD', 1, '', 80100, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#IDT||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IEC PROFES.MEDIA', 'FR0000066680', 'EUR', 1, '|EURONEXT|', 77717, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000066680||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IFCO SYSTEMS N.V.', 'NL0000268456', 'EUR', 1, '|DEUTSCHEBOERSE|', 77454, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#NL0000268456||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IFM IMMOBILIEN AG', 'DE000A0JDU97', 'EUR', 1, '|DEUTSCHEBOERSE|', 80267, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE000A0JDU97||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IFM INVESTMENTS LTD.', NULL, 'USD', 1, '', 81072, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#CTC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IGE + XAO', 'FR0000030827', 'EUR', 1, '|EURONEXT|', 74806, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000030827||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IHS INC. CL A', NULL, 'USD', 1, '', 76406, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#IHS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IK AHORRO', 'ES0125163032', 'EUR', 2, '|f_es_BMF|', 81096, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0125163032||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IK FONDO MULTIPLE', 'ES0125168031', 'EUR', 2, '|f_es_BMF|', 81097, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0125168031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IK MULTIPROTECCION 5 GARANTIZADO', 'ES0125112039', 'EUR', 2, '|f_es_BMF|', 81098, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0125112039||es||False', false, '{NULL,F0GBR04M5Y,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IK MULTIVALOR 3 PLUS GARANTIZADO', 'ES0125164030', 'EUR', 2, '|f_es_BMF|', 81099, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0125164030||es||False', false, '{NULL,F0GBR04Q2K,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IK MULTIVALOR 9 GARANTIZADO', 'ES0149043038', 'EUR', 2, '|f_es_BMF|', 81100, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0149043038||es||False', false, '{NULL,F0GBR06XIG,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IK PREMIUM GESTION ACTIVA', 'ES0147457008', 'EUR', 2, '|f_es_BMF|', 81074, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147457008||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IK TRIPLE 5 PLUS GARANTIZADO', 'ES0125166035', 'EUR', 2, '|f_es_BMF|', 81076, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0125166035||es||False', false, '{NULL,F0GBR04Q2L,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ILIAD', 'FR0004035913', 'EUR', 1, '|EURONEXT|', 79721, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0004035913||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ILLINOIS TOOL WORKS INC.', NULL, 'USD', 1, '', 76871, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ITW||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ILLUMINA INC.', 'US4523271090', 'USD', 1, '|NASDAQ100|', 77442, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'ILMN||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IM 93 RENTA', 'ES0130588033', 'EUR', 2, '|f_es_BMF|', 81077, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0130588033||es||False', false, '{NULL,F0GBR04J7I,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IMATION CORP.', NULL, 'USD', 1, '', 80974, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#IMN||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IMAX CORP.', NULL, 'USD', 1, '', 78030, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#IMAX||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IMERYS', 'FR0000120859', 'EUR', 1, '|EURONEXT|', 79789, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000120859||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IMMO MOURY (D)', 'BE0003893139', 'EUR', 1, '|EURONEXT|', 79747, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003893139||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IMMOB.DASSAULT', 'FR0000033243', 'EUR', 1, '|EURONEXT|', 79749, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000033243||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IMMOBEL', 'BE0003599108', 'EUR', 1, '|EURONEXT|', 75226, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003599108||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IMMOBETELGEUSE', 'FR0000036725', 'EUR', 1, '|EURONEXT|', 79750, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000036725||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IMMOB.HOTELIERE', 'FR0000036980', 'EUR', 1, '|EURONEXT|', 80591, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000036980||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IMOB.C GRAO PARA', 'PTGPA0AP0007', 'EUR', 1, '|EURONEXT|', 79751, NULL, NULL, NULL, NULL, 100, 'c', 1, 9, 'EURONEXT#PTGPA0AP0007||pt||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IMPERIAL HOLDINGS INC.', NULL, 'USD', 1, '', 80154, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#IFT||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IMPERIAL OIL', 'BE0004602430', 'EUR', 1, '|EURONEXT|', 79758, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0004602430||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IMPERVA INC.', NULL, 'USD', 1, '', 77519, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#IMPV||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IMPRESA,SGPS', 'PTIPR0AM0000', 'EUR', 1, '|EURONEXT|', 77041, NULL, NULL, NULL, NULL, 100, 'c', 1, 9, 'EURONEXT#PTIPR0AM0000||pt||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IMTECH', 'NL0006055329', 'EUR', 1, '|EURONEXT|', 75309, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0006055329||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INAPA-INV.P.GESTAO', 'PTINA0AP0008', 'EUR', 1, '|EURONEXT|', 79761, NULL, NULL, NULL, NULL, 100, 'c', 1, 9, 'EURONEXT#PTINA0AP0008||pt||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INAPA-PREF S/ VOTO', 'PTINA2VP0019', 'EUR', 1, '|EURONEXT|', 79762, NULL, NULL, NULL, NULL, 100, 'c', 1, 9, 'EURONEXT#PTINA2VP0019||pt||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INAS (2.7777777P1)', 'PTINA0APS030', 'EUR', 1, '|EURONEXT|', 76711, NULL, NULL, NULL, NULL, 100, 'c', 1, 9, 'EURONEXT#PTINA0APS030||pt||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INDEPENDENCE HOLDING CO.', NULL, 'USD', 1, '', 81020, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#IHC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INDEX MULTIMEDIA', 'FR0004061513', 'EUR', 1, '|EURONEXT|', 79348, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0004061513||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ÍNDICE DE VOLATILIDAD', NULL, 'USD', 3, '', 81090, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, '^VIX||us||False', false, '{^VIX,NULL,INDEXCBOE:VIX,NULL,VIX}', false, 2);
INSERT INTO public.products VALUES ('INDITEX', 'ES0148396015', 'EUR', 1, '|EUROSTOXX|IBEX|MERCADOCONTINUO|', 79192, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0148396015||es||False', false, '{ITX.MC,NULL,BME:ITX,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INDLE FIN.ENTREPR.', 'FR0000066219', 'EUR', 1, '|EURONEXT|', 79960, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000066219||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INDO INTERNA', 'ES0148224118', 'EUR', 1, '|MERCADOCONTINUO|', 81348, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0148224118||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INDOSAT', NULL, 'USD', 1, '', 78715, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#IIT||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INDOSUEZ BOLSA', 'ES0126527037', 'EUR', 2, '|f_es_BMF|', 81078, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0126527037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INDOSUEZ FONDTESORO', 'ES0126531039', 'EUR', 2, '|f_es_BMF|', 81079, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0126531039||es||False', false, '{NULL,F0GBR04Q4I,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INDRA A', 'ES0118594417', 'EUR', 1, '|IBEX|MERCADOCONTINUO|', 79197, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0118594417||es||False', false, '{IDR.MC,NULL,BME:IDR,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INDUS HOLDING AG', 'DE0006200108', 'EUR', 1, '|DEUTSCHEBOERSE|', 80270, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0006200108||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INDUSTRIAS BACHOCO S.A.B. DE C.V.', NULL, 'USD', 1, '', 80996, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#IBA||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INFINEON TECHNOLOGIES AG', 'DE0006231004', 'EUR', 1, '|DAX|DEUTSCHEBOERSE|', 80271, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0006231004||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INFO VISTA', 'FR0004031649', 'EUR', 1, '|EURONEXT|', 76467, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0004031649||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INFOSYS TECHNOLOGIES LIMITED', 'US4567881085', 'USD', 1, '|NASDAQ100|', 76571, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'INFY||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INFOTEL', 'FR0000071797', 'EUR', 1, '|EURONEXT|', 81625, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000071797||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ING DIRECT F.NAR.EURO STOXX 50', 'ES0152771038', 'EUR', 2, '|f_es_BMF|', 76205, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0152771038||es||False', false, '{NULL,F0GBR0604J,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ING DIRECT FONDO NARANJA CONSERV', 'ES0152747004', 'EUR', 2, '|f_es_BMF|', 81080, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0152747004||es||False', false, '{NULL,F000000R6Y,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ING DIRECT FONDO NARANJA DINAMIC', 'ES0152743003', 'EUR', 2, '|f_es_BMF|', 81081, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0152743003||es||False', false, '{NULL,F000000R6U,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ING DIRECT FONDO NARANJA IBEX 35', 'ES0152741031', 'EUR', 2, '|f_es_BMF|', 76206, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0152741031||es||False', false, '{NULL,F0GBR04MYG,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ING DIRECT FONDO NARANJA M.EUROP', 'ES0152777035', 'EUR', 2, '|f_es_BMF|', 76308, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0152777035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ING DIRECT FONDO NARANJA MODERAD', 'ES0152739001', 'EUR', 2, '|f_es_BMF|', 76394, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0152739001||es||False', false, '{NULL,F000000R6T,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ING DIRECT FONDO NARANJA R.F', 'ES0152772036', 'EUR', 2, '|f_es_BMF|', 76398, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0152772036||es||False', false, '{NULL,F0GBR06Q1R,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ING DIR.F.NARANJ.STAN.&POOR''S500', 'ES0152769032', 'EUR', 2, '|f_es_BMF|', 76204, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0152769032||es||False', false, '{NULL,F0GBR04JO2,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ING GROEP CERT', 'BE0004523610', 'EUR', 1, '|EURONEXT|', 77052, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0004523610||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ING GROEP', 'NL0000303600', 'EUR', 1, '|EURONEXT|EUROSTOXX|', 77046, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0000303600||nl||False', false, '{INGA.AS,NULL,AMS:INGA,NULL,INGA.AS}', false, 2);
INSERT INTO public.products VALUES ('ING GROEP N.V.', NULL, 'USD', 1, '', 78480, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ING||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INGENICO', 'FR0000125346', 'EUR', 1, '|EURONEXT|', 76472, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000125346||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INGERSOLL-RAND CO. LTD.', NULL, 'USD', 1, '', 78267, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#IR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INGRAM MICRO INC. CL A', NULL, 'USD', 1, '', 77307, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#IM||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INIT INNOVATION IN TRAFFIC SYSTEMS AG', 'DE0005759807', 'EUR', 1, '|DEUTSCHEBOERSE|', 80274, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005759807||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INLAND REAL ESTATE CORP.', NULL, 'USD', 1, '', 80897, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#IRC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INM.COLONIAL', 'ES0139140018', 'EUR', 1, '|MERCADOCONTINUO|', 77072, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0139140018||es||False', true, '{COL.MC,NULL,BME:COL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INM.COLONIAL', 'ES0139140042', 'EUR', 1, '|MERCADOCONTINUO|', 79200, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0139140042||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INM.DEL SUR', 'ES0154653911', 'EUR', 1, '|MERCADOCONTINUO|', 81350, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0154653911||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INMOBILIARIA COLONIAL', 'ES0139140174', 'EUR', 1, '|IBEX|MERCADOCONTINUO|', 81723, 'https://www.inmocolonial.com/', NULL, NULL, NULL, 100, 'c', 1, 1, NULL, false, '{COL.MC,NULL,BME:COL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INNATE PHARMA', 'FR0010331421', 'EUR', 1, '|EURONEXT|', 77064, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010331421||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INNELEC MULTIMEDIA', 'FR0000064297', 'EUR', 1, '|EURONEXT|', 76165, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000064297||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INNOCONCEPTS', 'NL0000361145', 'EUR', 1, '|EURONEXT|', 76761, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0000361145||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INPHI CORP.', NULL, 'USD', 1, '', 80339, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#IPHI||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INSPERITY INC.', NULL, 'USD', 1, '', 77888, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#NSP||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INSTALLUX', 'FR0000060451', 'EUR', 1, '|EURONEXT|', 76194, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000060451||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INT FLAVORS', 'US4595061015', 'EUR', 1, '|EURONEXT|', 77091, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#US4595061015||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INTEGRALIS AG', 'DE0005155030', 'EUR', 1, '|DEUTSCHEBOERSE|', 74758, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005155030||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INTEGRYS ENERGY GROUP INC.', NULL, 'USD', 1, '', 78854, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#TEG||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INTEL CORP', 'US4581401001', 'EUR', 1, '|EURONEXT|', 80592, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#US4581401001||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INTEL CORPORATION', 'US4581401001', 'USD', 1, '|NASDAQ100|', 76113, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'INTC||us||False', false, '{INTC,NULL,NASDAQ:INTC,NULL,INTC.O}', false, 2);
INSERT INTO public.products VALUES ('INTERCALL REDUCT.', 'FR0000044901', 'EUR', 1, '|EURONEXT|', 76560, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000044901||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INTERCONTINENTAL HOTELS GROUP PLC', NULL, 'USD', 1, '', 76666, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#IHG||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INTERCONTINENTALEXCHANGE INC.', NULL, 'USD', 1, '', 75397, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ICE||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INTERDIN GLOBAL FONDOS', 'ES0155527031', 'EUR', 2, '|f_es_BMF|', 76381, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0155527031||es||False', false, '{NULL,F0GBR04Q7D,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INTERDIN PENTATHLON', 'ES0162858031', 'EUR', 2, '|f_es_BMF|', 76627, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0162858031||es||False', false, '{NULL,F0GBR04J6A,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INTERDIN TESORERIA', 'ES0154957031', 'EUR', 2, '|f_es_BMF|', 76712, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0154957031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INTERDIN VALOR DINAMICO', 'ES0154974036', 'EUR', 2, '|f_es_BMF|', 76774, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0154974036||es||False', false, '{NULL,F0GBR05POO,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INTERHYP AG', 'DE0005121701', 'EUR', 1, '|DEUTSCHEBOERSE|', 75282, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005121701||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INTERLINE BRANDS INC.', NULL, 'USD', 1, '', 79603, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#IBI||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INTERMEC INC.', NULL, 'USD', 1, '', 79722, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#IN||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INTERMONEY RENTA FIJA CORTO PLAZ', 'ES0155171038', 'EUR', 2, '|f_es_BMF|', 76805, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0155171038||es||False', false, '{NULL,F0GBR04J7M,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INTERMONEY VARIABLE EURO', 'ES0155142039', 'EUR', 2, '|f_es_BMF|', 76816, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0155142039||es||False', false, '{NULL,F0GBR04KFB,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INTERNATIONAL BUSINESS MACHINES CORP.', NULL, 'USD', 1, '', 77196, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#IBM||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INTERNATIONAL COAL GROUP INC.', NULL, 'USD', 1, '', 75453, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ICO||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INTERNATIONAL FLAVORS & FRAGRANCES INC.', NULL, 'USD', 1, '', 76350, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#IFF||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INTERNATIONAL GAME TECHNOLOGY', NULL, 'USD', 1, '', 77032, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#IGT||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INTERNATIONAL PAPER CO.', NULL, 'USD', 1, '', 78266, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#IP||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INTERNATIONAL RECTIFIER CORP.', NULL, 'USD', 1, '', 79104, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#IRF||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INTERNATIONAL SHIPHOLDING CORP.', NULL, 'USD', 1, '', 80101, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ISH||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INTERPARFUMS', 'FR0004024222', 'EUR', 1, '|EURONEXT|', 76184, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0004024222||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INTERPUBLIC GROUP OF COS.', NULL, 'USD', 1, '', 76170, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#IPG||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INTERSHOP COMMUNICATIONS AG', 'DE000A0EPUH1', 'EUR', 1, '|DEUTSCHEBOERSE|', 80327, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE000A0EPUH1||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INTERVALOR ACCS. INTERNACIONAL', 'ES0155715032', 'EUR', 2, '|f_es_BMF|', 80241, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0155715032||es||False', false, '{NULL,F0GBR04PRH,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INTERVALOR BOLSA', 'ES0155853031', 'EUR', 2, '|f_es_BMF|', 80242, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0155853031||es||False', false, '{NULL,F0GBR04PRF,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INTERVALOR FONDOS', 'ES0155817036', 'EUR', 2, '|f_es_BMF|', 80243, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0155817036||es||False', false, '{NULL,F0GBR04PRG,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INTERVALOR RENTA', 'ES0155852033', 'EUR', 2, '|f_es_BMF|', 76866, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0155852033||es||False', false, '{NULL,F0GBR04PSF,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INTERVEST OFF-WARE', 'BE0003746600', 'EUR', 1, '|EURONEXT|', 77837, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003746600||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INTERV.RETAIL-SIFI', 'BE0003754687', 'EUR', 1, '|EURONEXT|', 78138, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003754687||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INTERXION HOLDING N.V.', NULL, 'USD', 1, '', 80941, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#INXN||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INTESA SAN PAOLO', 'IT0000072618', 'EUR', 1, '|EUROSTOXX|', 75295, NULL, NULL, NULL, NULL, 100, 'c', 1, 6, 'ISP.MI||it||False', false, '{ISP.MI,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INTEXA', 'FR0000064958', 'EUR', 1, '|EURONEXT|', 77093, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000064958||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INTICA SYSTEMS AG', 'DE0005874846', 'EUR', 1, '|DEUTSCHEBOERSE|', 80328, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005874846||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INTLE PLANT.HEVEAS', 'FR0000036857', 'EUR', 1, '|EURONEXT|', 74906, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000036857||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INTRALINKS HOLDINGS INC.', NULL, 'USD', 1, '', 79885, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#IL||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INTREPID POTASH INC.', NULL, 'USD', 1, '', 75672, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#IPI||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INTUIT INC.', 'US4612021034', 'USD', 1, '|NASDAQ100|', 77527, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'INTU||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INTUITIVE SURGICAL INC.', 'US46120E6023', 'USD', 1, '|NASDAQ100|', 75747, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'ISRG||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INVACARE CORP.', NULL, 'USD', 1, '', 79626, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#IVC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INVERACTIVO CONFIANZA', 'ES0147131033', 'EUR', 2, '|f_es_BMF|', 80244, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0147131033||es||False', false, '{NULL,F0GBR04Q2D,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INVERBAN DINERO', 'ES0155823034', 'EUR', 2, '|f_es_BMF|', 80370, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0155823034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INVERBANSER', 'ES0155844030', 'EUR', 2, '|f_es_BMF|', 80371, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0155844030||es||False', false, '{NULL,F0GBR04Q06,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INVERBONOS', 'ES0175858036', 'EUR', 2, '|f_es_BMF|', 76678, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0175858036||es||False', false, '{NULL,F0GBR04J2W,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INVERCLASIC', 'ES0155028030', 'EUR', 2, '|f_es_BMF|', 81122, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0155028030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INVERDEUDA FONDTESORO', 'ES0155849039', 'EUR', 2, '|f_es_BMF|', 76679, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0155849039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INVERKOA', 'ES0155848031', 'EUR', 2, '|f_es_BMF|', 80377, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0155848031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INVERMANRESA 2', 'ES0173447030', 'EUR', 2, '|f_es_BMF|', 81124, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0173447030||es||False', false, '{NULL,F0GBR04J3U,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INVERMANRESA', 'ES0155827035', 'EUR', 2, '|f_es_BMF|', 81123, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0155827035||es||False', false, '{NULL,F0GBR04J3S,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INVERSABADELL 10', 'ES0184984039', 'EUR', 2, '|f_es_BMF|', 81125, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0184984039||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INVERSABADELL 10 PREMIER', 'ES0155008032', 'EUR', 2, '|f_es_BMF|', 81126, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0155008032||es||False', false, '{NULL,F0000001TT,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INVERSABADELL 25', 'ES0174417032', 'EUR', 2, '|f_es_BMF|', 81127, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0174417032||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INVERSABADELL 25 PREMIER', 'ES0177124031', 'EUR', 2, '|f_es_BMF|', 81128, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0177124031||es||False', false, '{NULL,F0000001TU,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INVERSABADELL 50', 'ES0155571039', 'EUR', 2, '|f_es_BMF|', 81129, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0155571039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INVERSABADELL 50 PREMIE', 'ES0144213032', 'EUR', 2, '|f_es_BMF|', 80245, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0144213032||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INVERSABADELL 70', 'ES0138957032', 'EUR', 2, '|f_es_BMF|', 80246, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0138957032||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INVERSABADELL 70 PREMIER', 'ES0155043039', 'EUR', 2, '|f_es_BMF|', 80392, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0155043039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INVERSIO ACTIVA', 'ES0152176006', 'EUR', 2, '|f_es_BMF|', 81130, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0152176006||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INVERTRES FONDO 1', 'ES0156038038', 'EUR', 2, '|f_es_BMF|', 80393, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0156038038||es||False', false, '{NULL,F0GBR04JLH,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INVESCO LTD.', NULL, 'USD', 1, '', 79269, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#IVZ||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INVESCO MORTGAGE CAPITAL INC.', NULL, 'USD', 1, '', 79009, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#IVR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INVESTMENT TECHNOLOGY GROUP INC.', NULL, 'USD', 1, '', 79701, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ITG||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INVISION SOFTWARE AG', 'DE0005859698', 'EUR', 1, '|DEUTSCHEBOERSE|', 80329, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005859698||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('INYPSA', 'ES0152768612', 'EUR', 1, '|MERCADOCONTINUO|', 81352, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0152768612||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ION GEOPHYSICAL CORP.', NULL, 'USD', 1, '', 79430, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#IO||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IPARFONDO', 'ES0184921031', 'EUR', 2, '|f_es_BMF|', 81131, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0184921031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IPSEN', 'FR0010259150', 'EUR', 1, '|EURONEXT|', 76214, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010259150||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IPSOS DS', 'FR0011104942', 'EUR', 1, '|EURONEXT|', 75429, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0011104942||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IPSOS', 'FR0000073298', 'EUR', 1, '|EURONEXT|', 76327, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000073298||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IRDNORDPASDECALAIS', 'FR0000124232', 'EUR', 1, '|EURONEXT|', 76478, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000124232||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('I.R.I.S  GROUP', 'BE0003756708', 'EUR', 1, '|EURONEXT|', 77716, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003756708||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('I.R.I.S STRIP (D)', 'BE0005555264', 'EUR', 1, '|EURONEXT|', 75225, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0005555264||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IRON MOUNTAIN INC.', NULL, 'USD', 1, '', 76323, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#IRM||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IRSA-INVERSIONES Y REPRESENTACIONES S.A. GDS', NULL, 'USD', 1, '', 80975, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#IRS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ISHARES MSCI BRAZIL INDEX', NULL, 'USD', 4, '', 76643, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'EWZ||br||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ISHARES S&P 500 INDEX', 'US4642872000', 'USD', 4, '', 75704, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'IVV||us||False', false, '{IVV,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ISOFTSTONE HOLDINGS LTD.', NULL, 'USD', 1, '', 79706, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ISS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ISRA VISION AG', 'DE0005488100', 'EUR', 1, '|DEUTSCHEBOERSE|', 80330, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005488100||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ISTAR FINANCIAL INC.', NULL, 'USD', 1, '', 80912, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#SFI||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IT LINK', 'FR0000072597', 'EUR', 1, '|EURONEXT|', 79842, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000072597||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ITC HOLDINGS CORP.', NULL, 'USD', 1, '', 80884, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ITC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ITELLIGENCE AG', 'DE0007300402', 'EUR', 1, '|DEUTSCHEBOERSE|', 80320, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0007300402||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ITESOFT', 'FR0004026151', 'EUR', 1, '|EURONEXT|', 78376, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0004026151||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ITS GROUP BSAR', 'FR0010718379', 'EUR', 1, '|EURONEXT|', 79353, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010718379||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ITS GROUP', 'FR0000073843', 'EUR', 1, '|EURONEXT|', 78377, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000073843||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ITT CORP NEW', 'US4509112011', 'EUR', 1, '|EURONEXT|', 76219, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#US4509112011||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ITT CORP.', NULL, 'USD', 1, '', 77129, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ITT||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ITT CORPORATION', 'US4509111021', 'EUR', 1, '|EURONEXT|', 75643, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#US4509111021||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('ITT EDUCATIONAL SERVICES INC.', NULL, 'USD', 1, '', 79012, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ESI||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IURISFOND', 'ES0156322036', 'EUR', 2, '|f_es_BMF|', 81132, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0156322036||es||False', false, '{NULL,F0GBR04J3O,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IVANHOE MINES LTD.', NULL, 'USD', 1, '', 77033, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#IVN||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IVG IMMOBILIEN AG', 'DE0006205701', 'EUR', 1, '|DEUTSCHEBOERSE|', 80321, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0006205701||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('IVU TRAFFIC TECHNOLOGIES AG', 'DE0007448508', 'EUR', 1, '|DEUTSCHEBOERSE|', 80322, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0007448508||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('JABIL CIRCUIT INC.', NULL, 'USD', 1, '', 76411, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#JBL||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('JACKSON HEWITT TAX SERVICE INC.', NULL, 'USD', 1, '', 75905, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#JTX||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('JACOBS ENGINEERING GROUP INC.', NULL, 'USD', 1, '', 78052, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#JEC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('JACQUES BOGART', 'FR0000032633', 'EUR', 1, '|EURONEXT|', 76220, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000032633||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('JACQUET METAL SCE', 'FR0000033904', 'EUR', 1, '|EURONEXT|', 79845, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000033904||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('JAGUAR MINING INC.', NULL, 'USD', 1, '', 80905, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#JAG||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('JANUS CAPITAL GROUP INC.', NULL, 'USD', 1, '', 76781, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#JNS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('JARDEN CORP.', NULL, 'USD', 1, '', 76698, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#JAH||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('JAXX SE', 'DE000A0JRU67', 'EUR', 1, '|DEUTSCHEBOERSE|', 80323, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE000A0JRU67||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('JAZZTEL', 'GB00B5TMSP21', 'EUR', 1, '|MERCADOCONTINUO|', 79201, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#GB00B5TMSP21||es||False', true, '{JAZ.MC,NULL,BME:JAZ,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('J.B. HUNT TRANSPORT SERVICES, I', NULL, 'USD', 1, '|NASDAQ100|', 76437, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'JBHT||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('JC DECAUX SA.', 'FR0000077919', 'EUR', 1, '|EURONEXT|', 79846, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000077919||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('J.C. PENNEY CO. INC.', NULL, 'USD', 1, '', 78650, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#JCP||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('JCDECAUX NV', 'FR0010987289', 'EUR', 1, '|EURONEXT|', 76009, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010987289||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('JEFFERIES GROUP INC.', NULL, 'USD', 1, '', 78658, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#JEF||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('JENOPTIK AG', 'DE0006229107', 'EUR', 1, '|DEUTSCHEBOERSE|', 80324, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0006229107||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('JENSEN-GROUP', 'BE0003858751', 'EUR', 1, '|EURONEXT|', 80597, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003858751||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('JETTER AG', 'DE0006264005', 'EUR', 1, '|DEUTSCHEBOERSE|', 80331, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0006264005||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('JINKOSOLAR HOLDING CO. LTD.', NULL, 'USD', 1, '', 80486, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#JKS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('JK WOHNBAU AG', 'DE000A1E8H38', 'EUR', 1, '|DEUTSCHEBOERSE|', 74769, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE000A1E8H38||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('J.M. SMUCKER CO.', NULL, 'USD', 1, '', 79270, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#SJM||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('J.MARTINS,SGPS', 'PTJMT0AE0001', 'EUR', 1, '|EURONEXT|', 77908, NULL, NULL, NULL, NULL, 100, 'c', 1, 9, 'EURONEXT#PTJMT0AE0001||pt||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('JMP GROUP CORP.', NULL, 'USD', 1, '', 80148, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#JMP||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('JOHN BEAN TECHNOLOGIES CORP.', NULL, 'USD', 1, '', 77802, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#JBT||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('JOHNSON & JOHNSON', NULL, 'USD', 1, '', 75331, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#JNJ||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('JOHNSON CONTROLS INC.', NULL, 'USD', 1, '', 79581, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#JCI||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('JONES GROUP INC.', NULL, 'USD', 1, '', 79491, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#JNY||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('JONES LANG LASALLE INC.', NULL, 'USD', 1, '', 77261, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#JLL||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('JOURNAL COMMUNICATIONS INC. CL A', NULL, 'USD', 1, '', 79932, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#JRN||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('JOY GLOBAL, INC.', NULL, 'USD', 1, '|NASDAQ100|', 77635, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'JOYG||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('JOYOU AG', 'DE000A0WMLD8', 'EUR', 1, '|DEUTSCHEBOERSE|', 74808, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE000A0WMLD8||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('JP MORGAN GLOBAL ALTERNATIVE FUN', 'ES0156581003', 'EUR', 2, '|f_es_BMF|', 77401, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0156581003||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('JPMORGAN CHASE & CO.', NULL, 'USD', 1, '', 74899, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#JPM||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('JUNGHEINRICH AG', 'DE0006219934', 'EUR', 1, '|DEUTSCHEBOERSE|', 74809, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0006219934||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('JUNIPER NETWORKS INC.', NULL, 'USD', 1, '', 78240, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#JNPR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('K12 INC.', NULL, 'USD', 1, '', 76684, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#LRN||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KABEL DEUTSCHLAND HOLDING AG', 'DE000KD88880', 'EUR', 1, '|DEUTSCHEBOERSE|', 80621, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE000KD88880||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KADANT INC.', NULL, 'USD', 1, '', 79980, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#KAI||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KALAHARI ALPHA', 'ES0160623007', 'EUR', 2, '|f_es_BMF|', 81133, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0160623007||es||False', false, '{NULL,F000005GXC,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KANSAS CITY SOUTHERN', NULL, 'USD', 1, '', 76618, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#KSU||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KAPSTONE PAPER & PACKAGING CORP.', NULL, 'USD', 1, '', 79539, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#KS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KAR AUCTION SERVICES INC.', NULL, 'USD', 1, '', 77842, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#KAR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KARDAN', 'NL0000113652', 'EUR', 1, '|EURONEXT|', 79850, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0000113652||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KAS BANK', 'NL0000362648', 'EUR', 1, '|EURONEXT|', 79856, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0000362648||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KAUFMAN ET BROAD', 'FR0004007813', 'EUR', 1, '|EURONEXT|', 79859, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0004007813||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KAYDON CORP.', NULL, 'USD', 1, '', 79247, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#KDN||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KB FINANCIAL GROUP INC.', NULL, 'USD', 1, '', 76014, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#KB||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KB HOME', NULL, 'USD', 1, '', 79595, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#KBH||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KBC ANCORA', 'BE0003867844', 'EUR', 1, '|EURONEXT|', 79862, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003867844||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KBC', 'BE0003565737', 'EUR', 1, '|EURONEXT|', 79861, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003565737||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KBC STRIP', 'BE0005538096', 'EUR', 1, '|EURONEXT|', 79294, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0005538096||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KBR INC.', NULL, 'USD', 1, '', 77707, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#KBR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KBW INC.', NULL, 'USD', 1, '', 78207, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#KBW||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KELLOGG CO.', NULL, 'USD', 1, '', 78813, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#K||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KEMET CORP.', NULL, 'USD', 1, '', 79843, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#KEM||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KEMPER CORP.', NULL, 'USD', 1, '', 76908, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#KMPR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KENDRION', 'NL0000852531', 'EUR', 1, '|EURONEXT|', 79865, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0000852531||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KENEXA CORP.', NULL, 'USD', 1, '', 80908, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#KNXA||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KENNAMETAL INC.', NULL, 'USD', 1, '', 78500, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#KMT||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KENNEDY-WILSON HOLDINGS INC.', NULL, 'USD', 1, '', 77843, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#KW||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KENNETH COLE PRODUCTIONS INC. CL A', NULL, 'USD', 1, '', 80143, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#KCP||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KESA ELECTRICALS', 'GB0033040113', 'EUR', 1, '|EURONEXT|', 79253, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#GB0033040113||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KEY ENERGY SERVICES INC.', NULL, 'USD', 1, '', 76681, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#KEG||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KEYCORP', NULL, 'USD', 1, '', 75557, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#KEY||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KEYRUS BSAAR 2014', 'FR0010645200', 'EUR', 1, '|EURONEXT|', 79264, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010645200||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KEYRUS', 'FR0004029411', 'EUR', 1, '|EURONEXT|', 79258, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0004029411||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KEYWARE TECH. (D)', 'BE0003880979', 'EUR', 1, '|EURONEXT|', 76213, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003880979||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KID BRANDS INC.', NULL, 'USD', 1, '', 80547, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#KID||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KILROY REALTY CORP.', NULL, 'USD', 1, '', 79143, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#KRC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KIMBERLY-CLARK CORP.', NULL, 'USD', 1, '', 75232, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#KMB||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KIMCO REALTY CORP.', NULL, 'USD', 1, '', 79836, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#KIM||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KINDER MORGAN INC.', NULL, 'USD', 1, '', 76047, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#KMI||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KINDRED HEALTHCARE INC.', NULL, 'USD', 1, '', 80901, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#KND||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KINDY', 'FR0000052904', 'EUR', 1, '|EURONEXT|', 76224, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000052904||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KINEPOLIS GROUP', 'BE0003722361', 'EUR', 1, '|EURONEXT|', 79887, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003722361||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KINETIC CONCEPTS INC.', NULL, 'USD', 1, '', 76894, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#KCI||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KINGSWAY FINANCIAL SERVICES INC.', NULL, 'USD', 1, '', 80157, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#KFS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KINROSS GOLD CORP.', NULL, 'USD', 1, '', 79340, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#KGC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KIRBY CORP.', NULL, 'USD', 1, '', 76150, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#KEX||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KITE REALTY GROUP TRUST', NULL, 'USD', 1, '', 79976, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#KRG||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KLA-TENCOR CORPORATION', NULL, 'USD', 1, '|NASDAQ100|', 75898, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'KLAC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KLEMURS', 'FR0010404780', 'EUR', 1, '|EURONEXT|', 76479, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010404780||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KLEPIERRE', 'FR0000121964', 'EUR', 1, '|EURONEXT|', 76597, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000121964||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KLÖCKNER & CO SE', 'DE000KC01000', 'EUR', 1, '|DEUTSCHEBOERSE|', 80623, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE000KC01000||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KNIGHT CAPITAL GROUP INC. CL A', NULL, 'USD', 1, '', 76062, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#KCG||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KNIGHT TRANSPORTATION INC.', NULL, 'USD', 1, '', 79350, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#KNX||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KNOLL INC.', NULL, 'USD', 1, '', 80892, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#KNL||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KODIAK OIL & GAS CORP.', NULL, 'USD', 1, '', 76496, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#KOG||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KOENIG & BAUER AG', 'DE0007193500', 'EUR', 1, '|DEUTSCHEBOERSE|', 81274, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0007193500||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KOHL''S CORP.', NULL, 'USD', 1, '', 78136, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#KSS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KONAMI CORP.', NULL, 'USD', 1, '', 78933, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#KNM||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KONINKLIJKE PHILIPS ELECTRONICS N.V.', NULL, 'USD', 1, '', 77284, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#PHG||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KONTRON AG', 'DE0006053952', 'EUR', 1, '|DEUTSCHEBOERSE|', 81278, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0006053952||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KOPPERS HOLDINGS INC.', NULL, 'USD', 1, '', 78339, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#KOP||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KOREA ELECTRIC POWER CORP.', NULL, 'USD', 1, '', 76292, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#KEP||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KORIAN', 'FR0010386334', 'EUR', 1, '|EURONEXT|', 79888, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010386334||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KORN/FERRY INTERNATIONAL', NULL, 'USD', 1, '', 79497, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#KFY||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KOSMOS ENERGY LTD.', NULL, 'USD', 1, '', 81609, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#KOS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KPN KON', 'NL0000009082', 'EUR', 1, '|EURONEXT|', 74924, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0000009082||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KRAFT FOODS INC. CL A', NULL, 'USD', 1, '', 76803, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#KFT||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KRATON PERFORMANCE POLYMERS INC.', NULL, 'USD', 1, '', 78443, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#KRA||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KRISPY KREME DOUGHNUTS INC.', NULL, 'USD', 1, '', 80938, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#KKD||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KROGER CO.', NULL, 'USD', 1, '', 77104, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#KR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KROMI LOGISTIK AG', 'DE000A0KFUJ5', 'EUR', 1, '|DEUTSCHEBOERSE|', 81279, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE000A0KFUJ5||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KRONES AG', 'DE0006335003', 'EUR', 1, '|DEUTSCHEBOERSE|', 81280, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0006335003||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KRONOS WORLDWIDE INC.', NULL, 'USD', 1, '', 79704, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#KRO||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('K+S AKTIENGESELLSCHAFT', 'DE000KSAG888', 'EUR', 1, '|DAX|DEUTSCHEBOERSE|', 74844, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE000KSAG888||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KT CORP.', NULL, 'USD', 1, '', 77216, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#KT||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KUBOTA CORP.', NULL, 'USD', 1, '', 79263, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#KUB||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KUKA AKTIENGESELLSCHAFT', 'DE0006204407', 'EUR', 1, '|DEUTSCHEBOERSE|', 81281, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0006204407||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KUTXAAHORRO', 'ES0157025034', 'EUR', 2, '|f_es_BMF|', 81134, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0157025034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KUTXACRECIMIENTO', 'ES0156999031', 'EUR', 2, '|f_es_BMF|', 81135, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0156999031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KUTXAEMERGENTE', 'ES0156923031', 'EUR', 2, '|f_es_BMF|', 81136, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0156923031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KUTXAESTABILIDAD', 'ES0157019037', 'EUR', 2, '|f_es_BMF|', 81141, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0157019037||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KUTXAESTRUCTURADO 2', 'ES0157011034', 'EUR', 2, '|f_es_BMF|', 81137, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0157011034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KUTXAESTRUCTURADO 3', 'ES0156891006', 'EUR', 2, '|f_es_BMF|', 81138, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0156891006||es||False', false, '{NULL,F0000024PU,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KUTXAFOND', 'ES0142520032', 'EUR', 2, '|f_es_BMF|', 81139, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0142520032||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KUTXAGARANTIZADO JUNIO 2014', 'ES0156645006', 'EUR', 2, '|f_es_BMF|', 81140, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0156645006||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KUTXAGARANTIZADO MARZO 2015', 'ES0157016033', 'EUR', 2, '|f_es_BMF|', 80395, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0157016033||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KUTXAINDEX 12', 'ES0156729032', 'EUR', 2, '|f_es_BMF|', 81142, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0156729032||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KUTXAINDEX 15', 'ES0156730006', 'EUR', 2, '|f_es_BMF|', 81143, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0156730006||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KUTXAINDEX', 'ES0157026032', 'EUR', 2, '|f_es_BMF|', 80398, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0157026032||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KUTXAINDEX10', 'ES0156727036', 'EUR', 2, '|f_es_BMF|', 81144, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0156727036||es||False', false, '{NULL,F0GBR06XH2,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KUTXAINDEX16', 'ES0142523002', 'EUR', 2, '|f_es_BMF|', 81145, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0142523002||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KUTXAINDEX2', 'ES0157017031', 'EUR', 2, '|f_es_BMF|', 76193, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0157017031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KUTXAINDEX3', 'ES0157018039', 'EUR', 2, '|f_es_BMF|', 81146, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0157018039||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KUTXAINDEX6', 'ES0157012032', 'EUR', 2, '|f_es_BMF|', 81147, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0157012032||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KUTXAINDEX8', 'ES0157000037', 'EUR', 2, '|f_es_BMF|', 81148, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0157000037||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KUTXAINVER', 'ES0157030034', 'EUR', 2, '|f_es_BMF|', 80281, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0157030034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KUTXAINVER2', 'ES0157023039', 'EUR', 2, '|f_es_BMF|', 80282, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0157023039||es||False', false, '{NULL,F0GBR04JS3,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KUTXAMIXTO 85/15', 'ES0156892004', 'EUR', 2, '|f_es_BMF|', 76969, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0156892004||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KUTXAMONETARIO', 'ES0157002033', 'EUR', 2, '|f_es_BMF|', 76979, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0157002033||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KUTXAMONETARIO2', 'ES0157354038', 'EUR', 2, '|f_es_BMF|', 76980, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0157354038||es||False', false, '{NULL,F0GBR04E6M,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KUTXAMONETARIO3', 'ES0156977037', 'EUR', 2, '|f_es_BMF|', 77124, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0156977037||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KUTXAOPPORTUNITIES', 'ES0157003031', 'EUR', 2, '|f_es_BMF|', 77125, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0157003031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KUTXAPLUS', 'ES0157027030', 'EUR', 2, '|f_es_BMF|', 77130, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0157027030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KUTXARENDIMIENTO', 'ES0157013030', 'EUR', 2, '|f_es_BMF|', 81163, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0157013030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KUTXARENT', 'ES0142521030', 'EUR', 2, '|f_es_BMF|', 81164, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0142521030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KUTXASEG1', 'ES0157028038', 'EUR', 2, '|f_es_BMF|', 75425, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0157028038||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KUTXAVALOR', 'ES0157029036', 'EUR', 2, '|f_es_BMF|', 81165, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0157029036||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KUTXAVALOR EUROPA', 'ES0157032030', 'EUR', 2, '|f_es_BMF|', 81166, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0157032030||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KUTXAVALOREEUU', 'ES0157014038', 'EUR', 2, '|f_es_BMF|', 81167, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0157014038||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KUTXAVALORINTER', 'ES0157033038', 'EUR', 2, '|f_es_BMF|', 81168, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0157033038||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KUTXAVALORJAPON', 'ES0157034036', 'EUR', 2, '|f_es_BMF|', 81149, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0157034036||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KWS SAAT AG', 'DE0007074007', 'EUR', 1, '|DEUTSCHEBOERSE|', 81282, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0007074007||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('KYOCERA CORP.', NULL, 'USD', 1, '', 76939, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#KYO||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('L-1 IDENTITY SOLUTIONS INC.', NULL, 'USD', 1, '', 75706, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#ID||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('L-3 COMMUNICATIONS HOLDINGS INC.', NULL, 'USD', 1, '', 75549, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#LLL||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LA FONCIERE VERTE', 'FR0000039638', 'EUR', 1, '|EURONEXT|', 79890, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000039638||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LA PERLA WORLD', 'FR0000064917', 'EUR', 1, '|EURONEXT|', 80600, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000064917||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LA SEDA BAR.', 'ES0175290115', 'EUR', 1, '|MERCADOCONTINUO|', 79202, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0175290115||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LABORATORY CORP. OF AMERICA HOLDINGS', NULL, 'USD', 1, '', 75376, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#LH||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LABRANCHE & CO. INC.', NULL, 'USD', 1, '', 77058, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#LAB||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LACIE S.A.', 'FR0000054314', 'EUR', 1, '|EURONEXT|', 76331, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000054314||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LACLEDE GROUP INC.', NULL, 'USD', 1, '', 76636, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#LG||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LACROIX SA', 'FR0000066607', 'EUR', 1, '|EURONEXT|', 76481, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000066607||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LAFARGE', 'FR0000120537', 'EUR', 1, '|CAC|', 75018, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'LG.PA||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LAFARGE NV', 'FR0010982207', 'EUR', 1, '|EURONEXT|', 77585, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010982207||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LAFUMA', 'FR0000035263', 'EUR', 1, '|EURONEXT|', 80603, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000035263||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LAGARDERE ACT.BRO.', 'MC0000120790', 'EUR', 1, '|EURONEXT|', 78968, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#MC0000120790||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LAGARDERE GROUPE SCA', NULL, 'EUR', 1, '', 75497, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'MMB.PA||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LAGARDERE S.C.A.', 'FR0000130213', 'EUR', 1, '|EURONEXT|', 76395, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000130213||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LAIDINER', 'ES0157657034', 'EUR', 2, '|f_es_BMF|', 81200, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0157657034||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LAIETANA GESTIO ACTIVA', 'ES0157656036', 'EUR', 2, '|f_es_BMF|', 81209, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0157656036||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LAM RESEARCH CORPORATION', NULL, 'USD', 1, '|NASDAQ100|', 75257, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'LRCX||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LAN AIRLINES S.A.', NULL, 'USD', 1, '', 76431, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#LFL||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LANDAUER INC.', NULL, 'USD', 1, '', 79627, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#LDR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LANSON-BCC', 'FR0004027068', 'EUR', 1, '|EURONEXT|', 75345, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0004027068||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LANXESS AG', 'DE0005470405', 'EUR', 1, '|DEUTSCHEBOERSE|', 81283, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005470405||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LAPERWOBR30DEC11', 'FR0010670406', 'EUR', 1, '|EURONEXT|', 78019, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010670406||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LAREDO INVERSION LIBRE', 'ES0158644007', 'EUR', 2, '|f_es_BMF|', 76246, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0158644007||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LAREDOFONDO', 'ES0157940034', 'EUR', 2, '|f_es_BMF|', 81201, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0157940034||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LAS VEGAS SANDS CORP.', NULL, 'USD', 1, '', 77680, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#LVS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LASALLE HOTEL PROPERTIES', NULL, 'USD', 1, '', 76539, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#LHO||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LATONIA INVEST.', 'PA5183021045', 'EUR', 1, '|EURONEXT|', 80604, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#PA5183021045||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LAURENT-PERRIER', 'FR0006864484', 'EUR', 1, '|EURONEXT|', 76599, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0006864484||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LAZARD LTD.', NULL, 'USD', 1, '', 75813, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#LAZ||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LA-Z-BOY INC.', NULL, 'USD', 1, '', 78712, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#LZB||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LBI INTERNATIONAL', 'NL0009508720', 'EUR', 1, '|EURONEXT|', 79358, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#NL0009508720||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LDC', 'FR0000053829', 'EUR', 1, '|EURONEXT|', 80219, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000053829||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LDK SOLAR CO. LTD.', NULL, 'USD', 1, '', 80944, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#LDK||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LDLC.COM', 'FR0000075442', 'EUR', 1, '|EURONEXT|', 80055, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000075442||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LE NOBLE AGE', 'FR0004170017', 'EUR', 1, '|EURONEXT|', 77861, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0004170017||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LE TANNEUR', 'FR0000075673', 'EUR', 1, '|EURONEXT|', 77065, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000075673||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LEALTAD MUNDIAL', 'ES0158012031', 'EUR', 2, '|f_es_BMF|', 81202, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0158012031||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LEAPFROG ENTERPRISES INC. CL A', NULL, 'USD', 1, '', 79984, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#LF||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LEAR CORP.', NULL, 'USD', 1, '', 77710, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#LEA||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LEASETEN III', 'ES0158021032', 'EUR', 2, '|f_es_BMF|', 81203, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0158021032||es||False', false, '{NULL,F0GBR04JZ8,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LEASETEN RENTA FIJA CORTO', 'ES0158022030', 'EUR', 2, '|f_es_BMF|', 81204, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0158022030||es||False', false, '{NULL,F0GBR04LF4,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LEASINVEST-SICAFI', 'BE0003770840', 'EUR', 1, '|EURONEXT|', 77066, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003770840||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LEBON', 'FR0000121295', 'EUR', 1, '|EURONEXT|', 77862, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000121295||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LECTRA', 'FR0000065484', 'EUR', 1, '|EURONEXT|', 78920, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000065484||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LEE ENTERPRISES INC.', NULL, 'USD', 1, '', 79765, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#LEE||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LEGG MASON INC.', NULL, 'USD', 1, '', 76367, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#LM||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LEGGETT & PLATT INC.', NULL, 'USD', 1, '', 78437, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#LEG||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LEGRAND', 'FR0010307819', 'EUR', 1, '|CAC|EURONEXT|', 78924, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010307819||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LEIFHEIT AG', 'DE0006464506', 'EUR', 1, '|DEUTSCHEBOERSE|', 81285, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0006464506||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LENDER PROCESSING SERVICES INC.', NULL, 'USD', 1, '', 78024, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#LPS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LENNAR CORP. CL A', NULL, 'USD', 1, '', 75721, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#LEN||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LENNOX INTERNATIONAL INC.', NULL, 'USD', 1, '', 77659, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#LII||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LENTUO INTERNATIONAL INC.', NULL, 'USD', 1, '', 78034, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#LAS||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LEO CAPITAL GROWTH', 'KYG545791009', 'EUR', 1, '|EURONEXT|', 78040, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#KYG545791009||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LEONI AG', 'DE0005408884', 'EUR', 1, '|DEUTSCHEBOERSE|', 81287, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005408884||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LESNXCONSTRUCTEURS', 'FR0004023208', 'EUR', 1, '|EURONEXT|', 80231, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0004023208||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LEUCADIA NATIONAL CORP.', NULL, 'USD', 1, '', 77694, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#LUK||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LEVEL 3 COMMUNICATIONS INC.', NULL, 'USD', 1, '', 78531, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#LVLT||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LEXIBOOK LINGUIST.', 'FR0000033599', 'EUR', 1, '|EURONEXT|', 80205, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000033599||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LEXINGTON REALTY TRUST', NULL, 'USD', 1, '', 76923, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#LXP||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LEXMARK INTERNATIONAL INC.', NULL, 'USD', 1, '', 78556, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#LXK||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LG DISPLAY CO. LTD.', NULL, 'USD', 1, '', 77697, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#LPL||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LIBERTY EURO RENTA', 'ES0179171030', 'EUR', 2, '|f_es_BMF|', 81205, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0179171030||es||False', false, '{NULL,F0GBR04CB3,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LIBERTY EUROPEAN STOCK MARKET', 'ES0179172038', 'EUR', 2, '|f_es_BMF|', 81206, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0179172038||es||False', false, '{NULL,F0GBR04K1T,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LIBERTY MEDIA CORPORATION', NULL, 'USD', 1, '|NASDAQ100|', 76060, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'LIFE||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LIBERTY MEDIA INTERACTIVE', NULL, 'USD', 1, '|NASDAQ100|', 77399, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'LINTA||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LIBERTY PROPERTY TRUST', NULL, 'USD', 1, '', 75641, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#LRY||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LIBERTY SPANISH STOCK MARKET IND', 'ES0137999035', 'EUR', 2, '|f_es_BMF|', 81207, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0137999035||es||False', false, '{NULL,F0GBR04K1V,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LIFE TIME FITNESS INC.', NULL, 'USD', 1, '', 77653, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#LTM||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LIMITED BRANDS INC.', NULL, 'USD', 1, '', 76975, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#LTD||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LIN TV CORP.', NULL, 'USD', 1, '', 80147, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#TVL||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LINCOLN NATIONAL CORP.', NULL, 'USD', 1, '', 74996, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#LNC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LINDE AG', 'DE0006483001', 'EUR', 1, '|DAX|DEUTSCHEBOERSE|', 81288, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0006483001||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LINDSAY CORP.', NULL, 'USD', 1, '', 78620, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#LNN||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LINEAR TECHNOLOGY CORPORATION', NULL, 'USD', 1, '|NASDAQ100|', 76339, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'LLTC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LINEDATA SERVICES', 'FR0004156297', 'EUR', 1, '|EURONEXT|', 77864, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0004156297||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LINGOTES ESP', 'ES0158480311', 'EUR', 1, '|MERCADOCONTINUO|', 81356, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#ES0158480311||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LINKEDIN CORP. CL A', NULL, 'USD', 1, '', 75671, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#LNKD||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LIONS GATE ENTERTAINMENT CORP.', NULL, 'USD', 1, '', 76734, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#LGF||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LISGRAFICA', 'PTLIG0AE0002', 'EUR', 1, '|EURONEXT|', 80206, NULL, NULL, NULL, NULL, 100, 'c', 1, 9, 'EURONEXT#PTLIG0AE0002||pt||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LISI', 'FR0000050353', 'EUR', 1, '|EURONEXT|', 78988, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000050353||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LITHIA MOTORS INC. CL A', NULL, 'USD', 1, '', 78208, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#LAD||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LIVE NATION ENTERTAINMENT INC.', NULL, 'USD', 1, '', 79101, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#LYV||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LIZ CLAIBORNE INC.', NULL, 'USD', 1, '', 79403, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#LIZ||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LLOYD FONDS AKTIENGESELLSCHAFT', 'DE0006174873', 'EUR', 1, '|DEUTSCHEBOERSE|', 81289, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0006174873||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LLOYDS BANKING GROUP PLC', NULL, 'USD', 1, '', 78345, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#LYG||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LLOYDS BOLSA', 'ES0158865032', 'EUR', 2, '|f_es_BMF|', 81208, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0158865032||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LLOYDS FONDO 1', 'ES0158862039', 'EUR', 2, '|f_es_BMF|', 81215, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0158862039||es||False', false, '{NULL,F0GBR04J8I,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LLOYDS PREMIUM C.P.', 'ES0158866030', 'EUR', 2, '|f_es_BMF|', 81216, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0158866030||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LLOYDS RENTA FIJA C.P.', 'ES0158864035', 'EUR', 2, '|f_es_BMF|', 81221, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'ES0158864035||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LOCINDUS', 'FR0000121352', 'EUR', 1, '|EURONEXT|', 80607, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000121352||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LOCKHEED MARTIN CORP.', NULL, 'USD', 1, '', 76876, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#LMT||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LOEWE AG', 'DE0006494107', 'EUR', 1, '|DEUTSCHEBOERSE|', 81290, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0006494107||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LOEWS CORP.', NULL, 'USD', 1, '', 76587, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#L||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LOGICA', 'GB0005227086', 'EUR', 1, '|EURONEXT|', 80207, NULL, NULL, NULL, NULL, 100, 'c', 1, 12, 'EURONEXT#GB0005227086||nl||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LOGISTA HOLDINGS', 'ES0105027009 ', 'EUR', 1, '|MERCADOCONTINUO|', 81705, 'http://www.logista.es', NULL, NULL, NULL, 100, 'c', 1, 1, NULL, false, '{LOG.MC,NULL,BME:LOG,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LOGITECH INTERNATIONAL S.A.', NULL, 'USD', 1, '|NASDAQ100|', 76329, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'LOGI||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LOGWIN AG', 'LU0106198319', 'EUR', 1, '|DEUTSCHEBOERSE|', 80624, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#LU0106198319||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LONE PINE RESOURCES INC.', NULL, 'USD', 1, '', 79617, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#LPR||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LONGTOP FINANCIAL TECHNOLOGIES LTD.', NULL, 'USD', 1, '', 76197, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#LFT||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('L''OREAL', 'FR0000120321', 'EUR', 1, '|CAC|EURONEXT|EUROSTOXX|', 76330, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000120321||fr||False', false, '{OR.PA,NULL,EPA:OR,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LORILLARD INC.', NULL, 'USD', 1, '', 75985, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#LO||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LOTUS BAKERIES', 'BE0003604155', 'EUR', 1, '|EURONEXT|', 80227, NULL, NULL, NULL, NULL, 100, 'c', 1, 11, 'EURONEXT#BE0003604155||be||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LOUISIANA-PACIFIC CORP.', NULL, 'USD', 1, '', 76926, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#LPX||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LOWE''S COS.', NULL, 'USD', 1, '', 77092, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#LOW||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LPKF LASER & ELECTRONICS AG', 'DE0006450000', 'EUR', 1, '|DEUTSCHEBOERSE|', 80625, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0006450000||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('L.S. STARRETT CO. CL A', NULL, 'USD', 1, '', 81027, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#SCX||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LSB INDUSTRIES INC.', NULL, 'USD', 1, '', 79500, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#LXU||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LSI CORP.', NULL, 'USD', 1, '', 75585, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#LSI||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LTC PROPERTIES INC.', NULL, 'USD', 1, '', 79381, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#LTC||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LUBRIZOL CORP.', NULL, 'USD', 1, '', 75405, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#LZ||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LUBY''S INC.', NULL, 'USD', 1, '', 81017, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#LUB||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LUDWIG BECK AG', 'DE0005199905', 'EUR', 1, '|DEUTSCHEBOERSE|', 81292, NULL, NULL, NULL, NULL, 100, 'c', 1, 5, 'DEUTSCHEBOERSE#DE0005199905||de||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LUMBER LIQUIDATORS HOLDINGS INC.', NULL, 'USD', 1, '', 77781, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#LL||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LUXOTTICA GROUP S.P.A.', NULL, 'USD', 1, '', 77706, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#LUX||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LVL MEDICAL GROUPE', 'FR0000054686', 'EUR', 1, '|EURONEXT|', 80228, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000054686||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LVL MEDICAL GROUPE', 'FR0011034651', 'EUR', 1, '|EURONEXT|', 76994, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0011034651||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LVLBSAAR2015', 'FR0010617027', 'EUR', 1, '|EURONEXT|', 78042, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0010617027||fr||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LVMH', 'FR0000121014', 'EUR', 1, '|CAC|EURONEXT|EUROSTOXX|', 80229, NULL, NULL, NULL, NULL, 100, 'c', 1, 3, 'EURONEXT#FR0000121014||fr||False', false, '{MC.PA,NULL,EPA:MC,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LYDALL INC.', NULL, 'USD', 1, '', 81004, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#LDL||us||False', false, '{NULL,NULL,NYSE:LDL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LYONDELLBASELL INDUSTRIES N.V. CL A', NULL, 'USD', 1, '', 78348, NULL, NULL, NULL, NULL, 100, 'c', 1, 2, 'NYSE#LYB||us||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LYXDOWJIAETF', 'FR0007056841', 'EUR', 4, '', 81359, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#FR0007056841||es||False', true, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LYXEASTETF', 'FR0010204073', 'EUR', 4, '', 81360, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#FR0010204073||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LYXESTX5 ETF', 'FR0007054358', 'EUR', 4, '', 81362, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#FR0007054358||es||False', false, '{NULL,NULL,NULL,NULL,NULL}', false, 2);
INSERT INTO public.products VALUES ('LYXETFAAAGB', 'FR0010820258', 'EUR', 4, '', 81364, NULL, NULL, NULL, NULL, 100, 'c', 1, 1, 'MC#FR0010820258||es||False', false, '{NULL,NULL,NULL,NULL,NULL}