#define _CFFI_

/* We try to define Py_LIMITED_API before including Python.h.

   Mess: we can only define it if Py_DEBUG, Py_TRACE_REFS and
   Py_REF_DEBUG are not defined.  This is a best-effort approximation:
   we can learn about Py_DEBUG from pyconfig.h, but it is unclear if
   the same works for the other two macros.  Py_DEBUG implies them,
   but not the other way around.

   Issue #350 is still open: on Windows, the code here causes it to link
   with PYTHON36.DLL (for example) instead of PYTHON3.DLL.  A fix was
   attempted in 164e526a5515 and 14ce6985e1c3, but reverted: virtualenv
   does not make PYTHON3.DLL available, and so the "correctly" compiled
   version would not run inside a virtualenv.  We will re-apply the fix
   after virtualenv has been fixed for some time.  For explanation, see
   issue #355.  For a workaround if you want PYTHON3.DLL and don't worry
   about virtualenv, see issue #350.  See also 'py_limited_api' in
   setuptools_ext.py.
*/
#if !defined(_CFFI_USE_EMBEDDING) && !defined(Py_LIMITED_API)
#  include <pyconfig.h>
#  if !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG)
#    define Py_LIMITED_API
#  endif
#endif

#include <Python.h>
#ifdef __cplusplus
extern "C" {
#endif
#include <stddef.h>

/* This part is from file 'cffi/parse_c_type.h'.  It is copied at the
   beginning of C sources generated by CFFI's ffi.set_source(). */

typedef void *_cffi_opcode_t;

#define _CFFI_OP(opcode, arg)   (_cffi_opcode_t)(opcode | (((uintptr_t)(arg)) << 8))
#define _CFFI_GETOP(cffi_opcode)    ((unsigned char)(uintptr_t)cffi_opcode)
#define _CFFI_GETARG(cffi_opcode)   (((intptr_t)cffi_opcode) >> 8)

#define _CFFI_OP_PRIMITIVE       1
#define _CFFI_OP_POINTER         3
#define _CFFI_OP_ARRAY           5
#define _CFFI_OP_OPEN_ARRAY      7
#define _CFFI_OP_STRUCT_UNION    9
#define _CFFI_OP_ENUM           11
#define _CFFI_OP_FUNCTION       13
#define _CFFI_OP_FUNCTION_END   15
#define _CFFI_OP_NOOP           17
#define _CFFI_OP_BITFIELD       19
#define _CFFI_OP_TYPENAME       21
#define _CFFI_OP_CPYTHON_BLTN_V 23   // varargs
#define _CFFI_OP_CPYTHON_BLTN_N 25   // noargs
#define _CFFI_OP_CPYTHON_BLTN_O 27   // O  (i.e. a single arg)
#define _CFFI_OP_CONSTANT       29
#define _CFFI_OP_CONSTANT_INT   31
#define _CFFI_OP_GLOBAL_VAR     33
#define _CFFI_OP_DLOPEN_FUNC    35
#define _CFFI_OP_DLOPEN_CONST   37
#define _CFFI_OP_GLOBAL_VAR_F   39
#define _CFFI_OP_EXTERN_PYTHON  41

#define _CFFI_PRIM_VOID          0
#define _CFFI_PRIM_BOOL          1
#define _CFFI_PRIM_CHAR          2
#define _CFFI_PRIM_SCHAR         3
#define _CFFI_PRIM_UCHAR         4
#define _CFFI_PRIM_SHORT         5
#define _CFFI_PRIM_USHORT        6
#define _CFFI_PRIM_INT           7
#define _CFFI_PRIM_UINT          8
#define _CFFI_PRIM_LONG          9
#define _CFFI_PRIM_ULONG        10
#define _CFFI_PRIM_LONGLONG     11
#define _CFFI_PRIM_ULONGLONG    12
#define _CFFI_PRIM_FLOAT        13
#define _CFFI_PRIM_DOUBLE       14
#define _CFFI_PRIM_LONGDOUBLE   15

#define _CFFI_PRIM_WCHAR        16
#define _CFFI_PRIM_INT8         17
#define _CFFI_PRIM_UINT8        18
#define _CFFI_PRIM_INT16        19
#define _CFFI_PRIM_UINT16       20
#define _CFFI_PRIM_INT32        21
#define _CFFI_PRIM_UINT32       22
#define _CFFI_PRIM_INT64        23
#define _CFFI_PRIM_UINT64       24
#define _CFFI_PRIM_INTPTR       25
#define _CFFI_PRIM_UINTPTR      26
#define _CFFI_PRIM_PTRDIFF      27
#define _CFFI_PRIM_SIZE         28
#define _CFFI_PRIM_SSIZE        29
#define _CFFI_PRIM_INT_LEAST8   30
#define _CFFI_PRIM_UINT_LEAST8  31
#define _CFFI_PRIM_INT_LEAST16  32
#define _CFFI_PRIM_UINT_LEAST16 33
#define _CFFI_PRIM_INT_LEAST32  34
#define _CFFI_PRIM_UINT_LEAST32 35
#define _CFFI_PRIM_INT_LEAST64  36
#define _CFFI_PRIM_UINT_LEAST64 37
#define _CFFI_PRIM_INT_FAST8    38
#define _CFFI_PRIM_UINT_FAST8   39
#define _CFFI_PRIM_INT_FAST16   40
#define _CFFI_PRIM_UINT_FAST16  41
#define _CFFI_PRIM_INT_FAST32   42
#define _CFFI_PRIM_UINT_FAST32  43
#define _CFFI_PRIM_INT_FAST64   44
#define _CFFI_PRIM_UINT_FAST64  45
#define _CFFI_PRIM_INTMAX       46
#define _CFFI_PRIM_UINTMAX      47
#define _CFFI_PRIM_FLOATCOMPLEX 48
#define _CFFI_PRIM_DOUBLECOMPLEX 49
#define _CFFI_PRIM_CHAR16       50
#define _CFFI_PRIM_CHAR32       51

#define _CFFI__NUM_PRIM         52
#define _CFFI__UNKNOWN_PRIM           (-1)
#define _CFFI__UNKNOWN_FLOAT_PRIM     (-2)
#define _CFFI__UNKNOWN_LONG_DOUBLE    (-3)

#define _CFFI__IO_FILE_STRUCT         (-1)


struct _cffi_global_s {
    const char *name;
    void *address;
    _cffi_opcode_t type_op;
    void *size_or_direct_fn;  // OP_GLOBAL_VAR: size, or 0 if unknown
                              // OP_CPYTHON_BLTN_*: addr of direct function
};

struct _cffi_getconst_s {
    unsigned long long value;
    const struct _cffi_type_context_s *ctx;
    int gindex;
};

struct _cffi_struct_union_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_STRUCT_UNION
    int flags;               // _CFFI_F_* flags below
    size_t size;
    int alignment;
    int first_field_index;   // -> _cffi_fields array
    int num_fields;
};
#define _CFFI_F_UNION         0x01   // is a union, not a struct
#define _CFFI_F_CHECK_FIELDS  0x02   // complain if fields are not in the
                                     // "standard layout" or if some are missing
#define _CFFI_F_PACKED        0x04   // for CHECK_FIELDS, assume a packed struct
#define _CFFI_F_EXTERNAL      0x08   // in some other ffi.include()
#define _CFFI_F_OPAQUE        0x10   // opaque

struct _cffi_field_s {
    const char *name;
    size_t field_offset;
    size_t field_size;
    _cffi_opcode_t field_type_op;
};

struct _cffi_enum_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_ENUM
    int type_prim;           // _CFFI_PRIM_xxx
    const char *enumerators; // comma-delimited string
};

struct _cffi_typename_s {
    const char *name;
    int type_index;   /* if opaque, points to a possibly artificial
                         OP_STRUCT which is itself opaque */
};

struct _cffi_type_context_s {
    _cffi_opcode_t *types;
    const struct _cffi_global_s *globals;
    const struct _cffi_field_s *fields;
    const struct _cffi_struct_union_s *struct_unions;
    const struct _cffi_enum_s *enums;
    const struct _cffi_typename_s *typenames;
    int num_globals;
    int num_struct_unions;
    int num_enums;
    int num_typenames;
    const char *const *includes;
    int num_types;
    int flags;      /* future extension */
};

struct _cffi_parse_info_s {
    const struct _cffi_type_context_s *ctx;
    _cffi_opcode_t *output;
    unsigned int output_size;
    size_t error_location;
    const char *error_message;
};

struct _cffi_externpy_s {
    const char *name;
    size_t size_of_result;
    void *reserved1, *reserved2;
};

#ifdef _CFFI_INTERNAL
static int parse_c_type(struct _cffi_parse_info_s *info, const char *input);
static int search_in_globals(const struct _cffi_type_context_s *ctx,
                             const char *search, size_t search_len);
static int search_in_struct_unions(const struct _cffi_type_context_s *ctx,
                                   const char *search, size_t search_len);
#endif

/* this block of #ifs should be kept exactly identical between
   c/_cffi_backend.c, cffi/vengine_cpy.py, cffi/vengine_gen.py
   and cffi/_cffi_include.h */
#if defined(_MSC_VER)
# include <malloc.h>   /* for alloca() */
# if _MSC_VER < 1600   /* MSVC < 2010 */
   typedef __int8 int8_t;
   typedef __int16 int16_t;
   typedef __int32 int32_t;
   typedef __int64 int64_t;
   typedef unsigned __int8 uint8_t;
   typedef unsigned __int16 uint16_t;
   typedef unsigned __int32 uint32_t;
   typedef unsigned __int64 uint64_t;
   typedef __int8 int_least8_t;
   typedef __int16 int_least16_t;
   typedef __int32 int_least32_t;
   typedef __int64 int_least64_t;
   typedef unsigned __int8 uint_least8_t;
   typedef unsigned __int16 uint_least16_t;
   typedef unsigned __int32 uint_least32_t;
   typedef unsigned __int64 uint_least64_t;
   typedef __int8 int_fast8_t;
   typedef __int16 int_fast16_t;
   typedef __int32 int_fast32_t;
   typedef __int64 int_fast64_t;
   typedef unsigned __int8 uint_fast8_t;
   typedef unsigned __int16 uint_fast16_t;
   typedef unsigned __int32 uint_fast32_t;
   typedef unsigned __int64 uint_fast64_t;
   typedef __int64 intmax_t;
   typedef unsigned __int64 uintmax_t;
# else
#  include <stdint.h>
# endif
# if _MSC_VER < 1800   /* MSVC < 2013 */
#  ifndef __cplusplus
    typedef unsigned char _Bool;
#  endif
# endif
#else
# include <stdint.h>
# if (defined (__SVR4) && defined (__sun)) || defined(_AIX) || defined(__hpux)
#  include <alloca.h>
# endif
#endif

#ifdef __GNUC__
# define _CFFI_UNUSED_FN  __attribute__((unused))
#else
# define _CFFI_UNUSED_FN  /* nothing */
#endif

#ifdef __cplusplus
# ifndef _Bool
   typedef bool _Bool;   /* semi-hackish: C++ has no _Bool; bool is builtin */
# endif
#endif

/**********  CPython-specific section  **********/
#ifndef PYPY_VERSION


#if PY_MAJOR_VERSION >= 3
# define PyInt_FromLong PyLong_FromLong
#endif

#define _cffi_from_c_double PyFloat_FromDouble
#define _cffi_from_c_float PyFloat_FromDouble
#define _cffi_from_c_long PyInt_FromLong
#define _cffi_from_c_ulong PyLong_FromUnsignedLong
#define _cffi_from_c_longlong PyLong_FromLongLong
#define _cffi_from_c_ulonglong PyLong_FromUnsignedLongLong
#define _cffi_from_c__Bool PyBool_FromLong

#define _cffi_to_c_double PyFloat_AsDouble
#define _cffi_to_c_float PyFloat_AsDouble

#define _cffi_from_c_int(x, type)                                        \
    (((type)-1) > 0 ? /* unsigned */                                     \
        (sizeof(type) < sizeof(long) ?                                   \
            PyInt_FromLong((long)x) :                                    \
         sizeof(type) == sizeof(long) ?                                  \
            PyLong_FromUnsignedLong((unsigned long)x) :                  \
            PyLong_FromUnsignedLongLong((unsigned long long)x)) :        \
        (sizeof(type) <= sizeof(long) ?                                  \
            PyInt_FromLong((long)x) :                                    \
            PyLong_FromLongLong((long long)x)))

#define _cffi_to_c_int(o, type)                                          \
    ((type)(                                                             \
     sizeof(type) == 1 ? (((type)-1) > 0 ? (type)_cffi_to_c_u8(o)        \
                                         : (type)_cffi_to_c_i8(o)) :     \
     sizeof(type) == 2 ? (((type)-1) > 0 ? (type)_cffi_to_c_u16(o)       \
                                         : (type)_cffi_to_c_i16(o)) :    \
     sizeof(type) == 4 ? (((type)-1) > 0 ? (type)_cffi_to_c_u32(o)       \
                                         : (type)_cffi_to_c_i32(o)) :    \
     sizeof(type) == 8 ? (((type)-1) > 0 ? (type)_cffi_to_c_u64(o)       \
                                         : (type)_cffi_to_c_i64(o)) :    \
     (Py_FatalError("unsupported size for type " #type), (type)0)))

#define _cffi_to_c_i8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[1])
#define _cffi_to_c_u8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[2])
#define _cffi_to_c_i16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[3])
#define _cffi_to_c_u16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[4])
#define _cffi_to_c_i32                                                   \
                 ((int(*)(PyObject *))_cffi_exports[5])
#define _cffi_to_c_u32                                                   \
                 ((unsigned int(*)(PyObject *))_cffi_exports[6])
#define _cffi_to_c_i64                                                   \
                 ((long long(*)(PyObject *))_cffi_exports[7])
#define _cffi_to_c_u64                                                   \
                 ((unsigned long long(*)(PyObject *))_cffi_exports[8])
#define _cffi_to_c_char                                                  \
                 ((int(*)(PyObject *))_cffi_exports[9])
#define _cffi_from_c_pointer                                             \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[10])
#define _cffi_to_c_pointer                                               \
    ((char *(*)(PyObject *, struct _cffi_ctypedescr *))_cffi_exports[11])
#define _cffi_get_struct_layout                                          \
    not used any more
#define _cffi_restore_errno                                              \
    ((void(*)(void))_cffi_exports[13])
#define _cffi_save_errno                                                 \
    ((void(*)(void))_cffi_exports[14])
#define _cffi_from_c_char                                                \
    ((PyObject *(*)(char))_cffi_exports[15])
#define _cffi_from_c_deref                                               \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[16])
#define _cffi_to_c                                                       \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[17])
#define _cffi_from_c_struct                                              \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[18])
#define _cffi_to_c_wchar_t                                               \
    ((_cffi_wchar_t(*)(PyObject *))_cffi_exports[19])
#define _cffi_from_c_wchar_t                                             \
    ((PyObject *(*)(_cffi_wchar_t))_cffi_exports[20])
#define _cffi_to_c_long_double                                           \
    ((long double(*)(PyObject *))_cffi_exports[21])
#define _cffi_to_c__Bool                                                 \
    ((_Bool(*)(PyObject *))_cffi_exports[22])
#define _cffi_prepare_pointer_call_argument                              \
    ((Py_ssize_t(*)(struct _cffi_ctypedescr *,                           \
                    PyObject *, char **))_cffi_exports[23])
#define _cffi_convert_array_from_object                                  \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[24])
#define _CFFI_CPIDX  25
#define _cffi_call_python                                                \
    ((void(*)(struct _cffi_externpy_s *, char *))_cffi_exports[_CFFI_CPIDX])
#define _cffi_to_c_wchar3216_t                                           \
    ((int(*)(PyObject *))_cffi_exports[26])
#define _cffi_from_c_wchar3216_t                                         \
    ((PyObject *(*)(int))_cffi_exports[27])
#define _CFFI_NUM_EXPORTS 28

struct _cffi_ctypedescr;

static void *_cffi_exports[_CFFI_NUM_EXPORTS];

#define _cffi_type(index)   (                           \
    assert((((uintptr_t)_cffi_types[index]) & 1) == 0), \
    (struct _cffi_ctypedescr *)_cffi_types[index])

static PyObject *_cffi_init(const char *module_name, Py_ssize_t version,
                            const struct _cffi_type_context_s *ctx)
{
    PyObject *module, *o_arg, *new_module;
    void *raw[] = {
        (void *)module_name,
        (void *)version,
        (void *)_cffi_exports,
        (void *)ctx,
    };

    module = PyImport_ImportModule("_cffi_backend");
    if (module == NULL)
        goto failure;

    o_arg = PyLong_FromVoidPtr((void *)raw);
    if (o_arg == NULL)
        goto failure;

    new_module = PyObject_CallMethod(
        module, (char *)"_init_cffi_1_0_external_module", (char *)"O", o_arg);

    Py_DECREF(o_arg);
    Py_DECREF(module);
    return new_module;

  failure:
    Py_XDECREF(module);
    return NULL;
}


#ifdef HAVE_WCHAR_H
typedef wchar_t _cffi_wchar_t;
#else
typedef uint16_t _cffi_wchar_t;   /* same random pick as _cffi_backend.c */
#endif

_CFFI_UNUSED_FN static uint16_t _cffi_to_c_char16_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return (uint16_t)_cffi_to_c_wchar_t(o);
    else
        return (uint16_t)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char16_t(uint16_t x)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

_CFFI_UNUSED_FN static int _cffi_to_c_char32_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return (int)_cffi_to_c_wchar_t(o);
    else
        return (int)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char32_t(unsigned int x)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

union _cffi_union_alignment_u {
    unsigned char m_char;
    unsigned short m_short;
    unsigned int m_int;
    unsigned long m_long;
    unsigned long long m_longlong;
    float m_float;
    double m_double;
    long double m_longdouble;
};

struct _cffi_freeme_s {
    struct _cffi_freeme_s *next;
    union _cffi_union_alignment_u alignment;
};

_CFFI_UNUSED_FN static int
_cffi_convert_array_argument(struct _cffi_ctypedescr *ctptr, PyObject *arg,
                             char **output_data, Py_ssize_t datasize,
                             struct _cffi_freeme_s **freeme)
{
    char *p;
    if (datasize < 0)
        return -1;

    p = *output_data;
    if (p == NULL) {
        struct _cffi_freeme_s *fp = (struct _cffi_freeme_s *)PyObject_Malloc(
            offsetof(struct _cffi_freeme_s, alignment) + (size_t)datasize);
        if (fp == NULL)
            return -1;
        fp->next = *freeme;
        *freeme = fp;
        p = *output_data = (char *)&fp->alignment;
    }
    memset((void *)p, 0, (size_t)datasize);
    return _cffi_convert_array_from_object(p, ctptr, arg);
}

_CFFI_UNUSED_FN static void
_cffi_free_array_arguments(struct _cffi_freeme_s *freeme)
{
    do {
        void *p = (void *)freeme;
        freeme = freeme->next;
        PyObject_Free(p);
    } while (freeme != NULL);
}

/**********  end CPython-specific section  **********/
#else
_CFFI_UNUSED_FN
static void (*_cffi_call_python_org)(struct _cffi_externpy_s *, char *);
# define _cffi_call_python  _cffi_call_python_org
#endif


#define _cffi_array_len(array)   (sizeof(array) / sizeof((array)[0]))

#define _cffi_prim_int(size, sign)                                      \
    ((size) == 1 ? ((sign) ? _CFFI_PRIM_INT8  : _CFFI_PRIM_UINT8)  :    \
     (size) == 2 ? ((sign) ? _CFFI_PRIM_INT16 : _CFFI_PRIM_UINT16) :    \
     (size) == 4 ? ((sign) ? _CFFI_PRIM_INT32 : _CFFI_PRIM_UINT32) :    \
     (size) == 8 ? ((sign) ? _CFFI_PRIM_INT64 : _CFFI_PRIM_UINT64) :    \
     _CFFI__UNKNOWN_PRIM)

#define _cffi_prim_float(size)                                          \
    ((size) == sizeof(float) ? _CFFI_PRIM_FLOAT :                       \
     (size) == sizeof(double) ? _CFFI_PRIM_DOUBLE :                     \
     (size) == sizeof(long double) ? _CFFI__UNKNOWN_LONG_DOUBLE :       \
     _CFFI__UNKNOWN_FLOAT_PRIM)

#define _cffi_check_int(got, got_nonpos, expected)      \
    ((got_nonpos) == (expected <= 0) &&                 \
     (got) == (unsigned long long)expected)

#ifdef MS_WIN32
# define _cffi_stdcall  __stdcall
#else
# define _cffi_stdcall  /* nothing */
#endif

#ifdef __cplusplus
}
#endif

/************************************************************/


            #include <QuEST.h>
        

/************************************************************/

static void *_cffi_types[] = {
/*  0 */ _CFFI_OP(_CFFI_OP_FUNCTION, 101), // Complex()(Qureg, DiagonalOp)
/*  1 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 9), // Qureg
/*  2 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 6), // DiagonalOp
/*  3 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  4 */ _CFFI_OP(_CFFI_OP_FUNCTION, 101), // Complex()(Qureg, Qureg)
/*  5 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/*  6 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/*  7 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  8 */ _CFFI_OP(_CFFI_OP_FUNCTION, 101), // Complex()(Qureg, long long)
/*  9 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 10 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 11), // long long
/* 11 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 12 */ _CFFI_OP(_CFFI_OP_FUNCTION, 101), // Complex()(Qureg, long long, long long)
/* 13 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 14 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 11),
/* 15 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 11),
/* 16 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 17 */ _CFFI_OP(_CFFI_OP_FUNCTION, 109), // ComplexMatrixN()(int)
/* 18 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7), // int
/* 19 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 20 */ _CFFI_OP(_CFFI_OP_FUNCTION, 2), // DiagonalOp()(int, QuESTEnv)
/* 21 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 22 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 8), // QuESTEnv
/* 23 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 24 */ _CFFI_OP(_CFFI_OP_FUNCTION, 46), // PauliHamil()(char *)
/* 25 */ _CFFI_OP(_CFFI_OP_POINTER, 377), // char *
/* 26 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 27 */ _CFFI_OP(_CFFI_OP_FUNCTION, 46), // PauliHamil()(int, int)
/* 28 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 29 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 30 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 31 */ _CFFI_OP(_CFFI_OP_FUNCTION, 22), // QuESTEnv()(void)
/* 32 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 33 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // Qureg()(Qureg, QuESTEnv)
/* 34 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 35 */ _CFFI_OP(_CFFI_OP_NOOP, 22),
/* 36 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 37 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // Qureg()(int, QuESTEnv)
/* 38 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 39 */ _CFFI_OP(_CFFI_OP_NOOP, 22),
/* 40 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 41 */ _CFFI_OP(_CFFI_OP_FUNCTION, 89), // double()(Qureg)
/* 42 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 43 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 44 */ _CFFI_OP(_CFFI_OP_FUNCTION, 89), // double()(Qureg, PauliHamil, Qureg)
/* 45 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 46 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 7), // PauliHamil
/* 47 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 48 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 49 */ _CFFI_OP(_CFFI_OP_FUNCTION, 89), // double()(Qureg, Qureg)
/* 50 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 51 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 52 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 53 */ _CFFI_OP(_CFFI_OP_FUNCTION, 89), // double()(Qureg, enum pauliOpType *, double *, int, Qureg)
/* 54 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 55 */ _CFFI_OP(_CFFI_OP_POINTER, 387), // enum pauliOpType *
/* 56 */ _CFFI_OP(_CFFI_OP_POINTER, 89), // double *
/* 57 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 58 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 59 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 60 */ _CFFI_OP(_CFFI_OP_FUNCTION, 89), // double()(Qureg, int *, enum pauliOpType *, int, Qureg)
/* 61 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 62 */ _CFFI_OP(_CFFI_OP_POINTER, 18), // int *
/* 63 */ _CFFI_OP(_CFFI_OP_NOOP, 55),
/* 64 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 65 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 66 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 67 */ _CFFI_OP(_CFFI_OP_FUNCTION, 89), // double()(Qureg, int, int)
/* 68 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 69 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 70 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 71 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 72 */ _CFFI_OP(_CFFI_OP_FUNCTION, 89), // double()(Qureg, long long)
/* 73 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 74 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 11),
/* 75 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 76 */ _CFFI_OP(_CFFI_OP_FUNCTION, 18), // int()(Qureg)
/* 77 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 78 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 79 */ _CFFI_OP(_CFFI_OP_FUNCTION, 18), // int()(Qureg, int)
/* 80 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 81 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 82 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 83 */ _CFFI_OP(_CFFI_OP_FUNCTION, 18), // int()(Qureg, int, double *)
/* 84 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 85 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 86 */ _CFFI_OP(_CFFI_OP_NOOP, 56),
/* 87 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 88 */ _CFFI_OP(_CFFI_OP_FUNCTION, 18), // int()(double, double *)
/* 89 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14), // double
/* 90 */ _CFFI_OP(_CFFI_OP_NOOP, 56),
/* 91 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 92 */ _CFFI_OP(_CFFI_OP_FUNCTION, 18), // int()(int)
/* 93 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 94 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 95 */ _CFFI_OP(_CFFI_OP_FUNCTION, 18), // int()(void)
/* 96 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 97 */ _CFFI_OP(_CFFI_OP_FUNCTION, 10), // long long()(Qureg)
/* 98 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 99 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 100 */ _CFFI_OP(_CFFI_OP_FUNCTION, 390), // void()(Complex, Qureg, Complex, Qureg, Complex, Qureg)
/* 101 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 1), // Complex
/* 102 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 103 */ _CFFI_OP(_CFFI_OP_NOOP, 101),
/* 104 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 105 */ _CFFI_OP(_CFFI_OP_NOOP, 101),
/* 106 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 107 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 108 */ _CFFI_OP(_CFFI_OP_FUNCTION, 390), // void()(ComplexMatrixN)
/* 109 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 5), // ComplexMatrixN
/* 110 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 111 */ _CFFI_OP(_CFFI_OP_FUNCTION, 390), // void()(DiagonalOp)
/* 112 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 113 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 114 */ _CFFI_OP(_CFFI_OP_FUNCTION, 390), // void()(DiagonalOp, QuESTEnv)
/* 115 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 116 */ _CFFI_OP(_CFFI_OP_NOOP, 22),
/* 117 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 118 */ _CFFI_OP(_CFFI_OP_FUNCTION, 390), // void()(DiagonalOp, double *, double *)
/* 119 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 120 */ _CFFI_OP(_CFFI_OP_NOOP, 56),
/* 121 */ _CFFI_OP(_CFFI_OP_NOOP, 56),
/* 122 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 123 */ _CFFI_OP(_CFFI_OP_FUNCTION, 390), // void()(DiagonalOp, long long, double *, double *, long long)
/* 124 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 125 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 11),
/* 126 */ _CFFI_OP(_CFFI_OP_NOOP, 56),
/* 127 */ _CFFI_OP(_CFFI_OP_NOOP, 56),
/* 128 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 11),
/* 129 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 130 */ _CFFI_OP(_CFFI_OP_FUNCTION, 390), // void()(PauliHamil)
/* 131 */ _CFFI_OP(_CFFI_OP_NOOP, 46),
/* 132 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 133 */ _CFFI_OP(_CFFI_OP_FUNCTION, 390), // void()(PauliHamil, double *, enum pauliOpType *)
/* 134 */ _CFFI_OP(_CFFI_OP_NOOP, 46),
/* 135 */ _CFFI_OP(_CFFI_OP_NOOP, 56),
/* 136 */ _CFFI_OP(_CFFI_OP_NOOP, 55),
/* 137 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 138 */ _CFFI_OP(_CFFI_OP_FUNCTION, 390), // void()(QuESTEnv)
/* 139 */ _CFFI_OP(_CFFI_OP_NOOP, 22),
/* 140 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 141 */ _CFFI_OP(_CFFI_OP_FUNCTION, 390), // void()(Qureg)
/* 142 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 143 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 144 */ _CFFI_OP(_CFFI_OP_FUNCTION, 390), // void()(Qureg, DiagonalOp)
/* 145 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 146 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 147 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 148 */ _CFFI_OP(_CFFI_OP_FUNCTION, 390), // void()(Qureg, PauliHamil, Qureg)
/* 149 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 150 */ _CFFI_OP(_CFFI_OP_NOOP, 46),
/* 151 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 152 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 153 */ _CFFI_OP(_CFFI_OP_FUNCTION, 390), // void()(Qureg, PauliHamil, double, int, int)
/* 154 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 155 */ _CFFI_OP(_CFFI_OP_NOOP, 46),
/* 156 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 157 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 158 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 159 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 160 */ _CFFI_OP(_CFFI_OP_FUNCTION, 390), // void()(Qureg, QuESTEnv)
/* 161 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 162 */ _CFFI_OP(_CFFI_OP_NOOP, 22),
/* 163 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 164 */ _CFFI_OP(_CFFI_OP_FUNCTION, 390), // void()(Qureg, QuESTEnv, int)
/* 165 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 166 */ _CFFI_OP(_CFFI_OP_NOOP, 22),
/* 167 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 168 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 169 */ _CFFI_OP(_CFFI_OP_FUNCTION, 390), // void()(Qureg, Qureg)
/* 170 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 171 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 172 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 173 */ _CFFI_OP(_CFFI_OP_FUNCTION, 390), // void()(Qureg, char *)
/* 174 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 175 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 176 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 177 */ _CFFI_OP(_CFFI_OP_FUNCTION, 390), // void()(Qureg, double *, double *)
/* 178 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 179 */ _CFFI_OP(_CFFI_OP_NOOP, 56),
/* 180 */ _CFFI_OP(_CFFI_OP_NOOP, 56),
/* 181 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 182 */ _CFFI_OP(_CFFI_OP_FUNCTION, 390), // void()(Qureg, double, Qureg)
/* 183 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 184 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 185 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 186 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 187 */ _CFFI_OP(_CFFI_OP_FUNCTION, 390), // void()(Qureg, enum pauliOpType *, double *, int, Qureg)
/* 188 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 189 */ _CFFI_OP(_CFFI_OP_NOOP, 55),
/* 190 */ _CFFI_OP(_CFFI_OP_NOOP, 56),
/* 191 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 192 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 193 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 194 */ _CFFI_OP(_CFFI_OP_FUNCTION, 390), // void()(Qureg, int *, enum pauliOpType *, int, double)
/* 195 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 196 */ _CFFI_OP(_CFFI_OP_NOOP, 62),
/* 197 */ _CFFI_OP(_CFFI_OP_NOOP, 55),
/* 198 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 199 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 200 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 201 */ _CFFI_OP(_CFFI_OP_FUNCTION, 390), // void()(Qureg, int *, int *, int, int, ComplexMatrix2)
/* 202 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 203 */ _CFFI_OP(_CFFI_OP_NOOP, 62),
/* 204 */ _CFFI_OP(_CFFI_OP_NOOP, 62),
/* 205 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 206 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 207 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 3), // ComplexMatrix2
/* 208 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 209 */ _CFFI_OP(_CFFI_OP_FUNCTION, 390), // void()(Qureg, int *, int)
/* 210 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 211 */ _CFFI_OP(_CFFI_OP_NOOP, 62),
/* 212 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 213 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 214 */ _CFFI_OP(_CFFI_OP_FUNCTION, 390), // void()(Qureg, int *, int, ComplexMatrixN *, int)
/* 215 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 216 */ _CFFI_OP(_CFFI_OP_NOOP, 62),
/* 217 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 218 */ _CFFI_OP(_CFFI_OP_POINTER, 109), // ComplexMatrixN *
/* 219 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 220 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 221 */ _CFFI_OP(_CFFI_OP_FUNCTION, 390), // void()(Qureg, int *, int, ComplexMatrixN)
/* 222 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 223 */ _CFFI_OP(_CFFI_OP_NOOP, 62),
/* 224 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 225 */ _CFFI_OP(_CFFI_OP_NOOP, 109),
/* 226 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 227 */ _CFFI_OP(_CFFI_OP_FUNCTION, 390), // void()(Qureg, int *, int, double)
/* 228 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 229 */ _CFFI_OP(_CFFI_OP_NOOP, 62),
/* 230 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 231 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 232 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 233 */ _CFFI_OP(_CFFI_OP_FUNCTION, 390), // void()(Qureg, int *, int, int *, int, ComplexMatrixN)
/* 234 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 235 */ _CFFI_OP(_CFFI_OP_NOOP, 62),
/* 236 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 237 */ _CFFI_OP(_CFFI_OP_NOOP, 62),
/* 238 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 239 */ _CFFI_OP(_CFFI_OP_NOOP, 109),
/* 240 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 241 */ _CFFI_OP(_CFFI_OP_FUNCTION, 390), // void()(Qureg, int *, int, int, ComplexMatrix2)
/* 242 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 243 */ _CFFI_OP(_CFFI_OP_NOOP, 62),
/* 244 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 245 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 246 */ _CFFI_OP(_CFFI_OP_NOOP, 207),
/* 247 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 248 */ _CFFI_OP(_CFFI_OP_FUNCTION, 390), // void()(Qureg, int *, int, int, int, ComplexMatrix4)
/* 249 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 250 */ _CFFI_OP(_CFFI_OP_NOOP, 62),
/* 251 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 252 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 253 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 254 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 4), // ComplexMatrix4
/* 255 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 256 */ _CFFI_OP(_CFFI_OP_FUNCTION, 390), // void()(Qureg, int)
/* 257 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 258 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 259 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 260 */ _CFFI_OP(_CFFI_OP_FUNCTION, 390), // void()(Qureg, int, Complex, Complex)
/* 261 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 262 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 263 */ _CFFI_OP(_CFFI_OP_NOOP, 101),
/* 264 */ _CFFI_OP(_CFFI_OP_NOOP, 101),
/* 265 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 266 */ _CFFI_OP(_CFFI_OP_FUNCTION, 390), // void()(Qureg, int, ComplexMatrix2 *, int)
/* 267 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 268 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 269 */ _CFFI_OP(_CFFI_OP_POINTER, 207), // ComplexMatrix2 *
/* 270 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 271 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 272 */ _CFFI_OP(_CFFI_OP_FUNCTION, 390), // void()(Qureg, int, ComplexMatrix2)
/* 273 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 274 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 275 */ _CFFI_OP(_CFFI_OP_NOOP, 207),
/* 276 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 277 */ _CFFI_OP(_CFFI_OP_FUNCTION, 390), // void()(Qureg, int, double)
/* 278 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 279 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 280 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 281 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 282 */ _CFFI_OP(_CFFI_OP_FUNCTION, 390), // void()(Qureg, int, double, Vector)
/* 283 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 284 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 285 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 286 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 10), // Vector
/* 287 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 288 */ _CFFI_OP(_CFFI_OP_FUNCTION, 390), // void()(Qureg, int, double, double, double)
/* 289 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 290 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 291 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 292 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 293 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 294 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 295 */ _CFFI_OP(_CFFI_OP_FUNCTION, 390), // void()(Qureg, int, int *, int, ComplexMatrixN)
/* 296 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 297 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 298 */ _CFFI_OP(_CFFI_OP_NOOP, 62),
/* 299 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 300 */ _CFFI_OP(_CFFI_OP_NOOP, 109),
/* 301 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 302 */ _CFFI_OP(_CFFI_OP_FUNCTION, 390), // void()(Qureg, int, int)
/* 303 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 304 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 305 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 306 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 307 */ _CFFI_OP(_CFFI_OP_FUNCTION, 390), // void()(Qureg, int, int, Complex, Complex)
/* 308 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 309 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 310 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 311 */ _CFFI_OP(_CFFI_OP_NOOP, 101),
/* 312 */ _CFFI_OP(_CFFI_OP_NOOP, 101),
/* 313 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 314 */ _CFFI_OP(_CFFI_OP_FUNCTION, 390), // void()(Qureg, int, int, ComplexMatrix2)
/* 315 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 316 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 317 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 318 */ _CFFI_OP(_CFFI_OP_NOOP, 207),
/* 319 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 320 */ _CFFI_OP(_CFFI_OP_FUNCTION, 390), // void()(Qureg, int, int, ComplexMatrix4 *, int)
/* 321 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 322 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 323 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 324 */ _CFFI_OP(_CFFI_OP_POINTER, 254), // ComplexMatrix4 *
/* 325 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 326 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 327 */ _CFFI_OP(_CFFI_OP_FUNCTION, 390), // void()(Qureg, int, int, ComplexMatrix4)
/* 328 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 329 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 330 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 331 */ _CFFI_OP(_CFFI_OP_NOOP, 254),
/* 332 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 333 */ _CFFI_OP(_CFFI_OP_FUNCTION, 390), // void()(Qureg, int, int, double)
/* 334 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 335 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 336 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 337 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 338 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 339 */ _CFFI_OP(_CFFI_OP_FUNCTION, 390), // void()(Qureg, int, int, double, Vector)
/* 340 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 341 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 342 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 343 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 344 */ _CFFI_OP(_CFFI_OP_NOOP, 286),
/* 345 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 346 */ _CFFI_OP(_CFFI_OP_FUNCTION, 390), // void()(Qureg, int, int, int, ComplexMatrix4)
/* 347 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 348 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 349 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 350 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 351 */ _CFFI_OP(_CFFI_OP_NOOP, 254),
/* 352 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 353 */ _CFFI_OP(_CFFI_OP_FUNCTION, 390), // void()(Qureg, long long)
/* 354 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 355 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 11),
/* 356 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 357 */ _CFFI_OP(_CFFI_OP_FUNCTION, 390), // void()(Qureg, long long, double *, double *, long long)
/* 358 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 359 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 11),
/* 360 */ _CFFI_OP(_CFFI_OP_NOOP, 56),
/* 361 */ _CFFI_OP(_CFFI_OP_NOOP, 56),
/* 362 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 11),
/* 363 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 364 */ _CFFI_OP(_CFFI_OP_FUNCTION, 390), // void()(char const *, char const *)
/* 365 */ _CFFI_OP(_CFFI_OP_POINTER, 377), // char const *
/* 366 */ _CFFI_OP(_CFFI_OP_NOOP, 365),
/* 367 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 368 */ _CFFI_OP(_CFFI_OP_FUNCTION, 390), // void()(unsigned long *, int)
/* 369 */ _CFFI_OP(_CFFI_OP_POINTER, 389), // unsigned long *
/* 370 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 371 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 372 */ _CFFI_OP(_CFFI_OP_FUNCTION, 390), // void()(void)
/* 373 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 374 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 2), // ComplexArray
/* 375 */ _CFFI_OP(_CFFI_OP_POINTER, 376), // QASMLogger *
/* 376 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 0), // QASMLogger
/* 377 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 2), // char
/* 378 */ _CFFI_OP(_CFFI_OP_POINTER, 56), // double * *
/* 379 */ _CFFI_OP(_CFFI_OP_ARRAY, 89), // double[2]
/* 380 */ (_cffi_opcode_t)(2),
/* 381 */ _CFFI_OP(_CFFI_OP_ARRAY, 379), // double[2][2]
/* 382 */ (_cffi_opcode_t)(2),
/* 383 */ _CFFI_OP(_CFFI_OP_ARRAY, 89), // double[4]
/* 384 */ (_cffi_opcode_t)(4),
/* 385 */ _CFFI_OP(_CFFI_OP_ARRAY, 383), // double[4][4]
/* 386 */ (_cffi_opcode_t)(4),
/* 387 */ _CFFI_OP(_CFFI_OP_ENUM, 0), // enum pauliOpType
/* 388 */ _CFFI_OP(_CFFI_OP_ENUM, 1), // enum phaseGateType
/* 389 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 10), // unsigned long
/* 390 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 0), // void
};

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_QASMLogger(QASMLogger *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { char * *tmp = &p->buffer; (void)tmp; }
  (void)((p->bufferSize) | 0);  /* check that 'QASMLogger.bufferSize' is an integer */
  (void)((p->bufferFill) | 0);  /* check that 'QASMLogger.bufferFill' is an integer */
  (void)((p->isLogging) | 0);  /* check that 'QASMLogger.isLogging' is an integer */
}
struct _cffi_align_typedef_QASMLogger { char x; QASMLogger y; };

static int _cffi_const_PAULI_I(unsigned long long *o)
{
  int n = (PAULI_I) <= 0;
  *o = (unsigned long long)((PAULI_I) | 0);  /* check that PAULI_I is an integer */
  return n;
}

static int _cffi_const_PAULI_X(unsigned long long *o)
{
  int n = (PAULI_X) <= 0;
  *o = (unsigned long long)((PAULI_X) | 0);  /* check that PAULI_X is an integer */
  return n;
}

static int _cffi_const_PAULI_Y(unsigned long long *o)
{
  int n = (PAULI_Y) <= 0;
  *o = (unsigned long long)((PAULI_Y) | 0);  /* check that PAULI_Y is an integer */
  return n;
}

static int _cffi_const_PAULI_Z(unsigned long long *o)
{
  int n = (PAULI_Z) <= 0;
  *o = (unsigned long long)((PAULI_Z) | 0);  /* check that PAULI_Z is an integer */
  return n;
}

static int _cffi_const_SIGMA_Z(unsigned long long *o)
{
  int n = (SIGMA_Z) <= 0;
  *o = (unsigned long long)((SIGMA_Z) | 0);  /* check that SIGMA_Z is an integer */
  return n;
}

static int _cffi_const_S_GATE(unsigned long long *o)
{
  int n = (S_GATE) <= 0;
  *o = (unsigned long long)((S_GATE) | 0);  /* check that S_GATE is an integer */
  return n;
}

static int _cffi_const_T_GATE(unsigned long long *o)
{
  int n = (T_GATE) <= 0;
  *o = (unsigned long long)((T_GATE) | 0);  /* check that T_GATE is an integer */
  return n;
}

static void _cffi_d_applyDiagonalOp(Qureg x0, DiagonalOp x1)
{
  applyDiagonalOp(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_applyDiagonalOp(PyObject *self, PyObject *args)
{
  Qureg x0;
  DiagonalOp x1;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "applyDiagonalOp", 2, 2, &arg0, &arg1))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x1, _cffi_type(2), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { applyDiagonalOp(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_applyDiagonalOp(Qureg *x0, DiagonalOp *x1)
{
  { applyDiagonalOp(*x0, *x1); }
}
#endif

static void _cffi_d_applyMatrix2(Qureg x0, int x1, ComplexMatrix2 x2)
{
  applyMatrix2(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_applyMatrix2(PyObject *self, PyObject *args)
{
  Qureg x0;
  int x1;
  ComplexMatrix2 x2;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "applyMatrix2", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x2, _cffi_type(207), arg2) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { applyMatrix2(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_applyMatrix2(Qureg *x0, int x1, ComplexMatrix2 *x2)
{
  { applyMatrix2(*x0, x1, *x2); }
}
#endif

static void _cffi_d_applyMatrix4(Qureg x0, int x1, int x2, ComplexMatrix4 x3)
{
  applyMatrix4(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_applyMatrix4(PyObject *self, PyObject *args)
{
  Qureg x0;
  int x1;
  int x2;
  ComplexMatrix4 x3;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "applyMatrix4", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x3, _cffi_type(254), arg3) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { applyMatrix4(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_applyMatrix4(Qureg *x0, int x1, int x2, ComplexMatrix4 *x3)
{
  { applyMatrix4(*x0, x1, x2, *x3); }
}
#endif

static void _cffi_d_applyMatrixN(Qureg x0, int * x1, int x2, ComplexMatrixN x3)
{
  applyMatrixN(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_applyMatrixN(PyObject *self, PyObject *args)
{
  Qureg x0;
  int * x1;
  int x2;
  ComplexMatrixN x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "applyMatrixN", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(62), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(62), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x3, _cffi_type(109), arg3) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { applyMatrixN(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_applyMatrixN(Qureg *x0, int * x1, int x2, ComplexMatrixN *x3)
{
  { applyMatrixN(*x0, x1, x2, *x3); }
}
#endif

static void _cffi_d_applyMultiControlledMatrixN(Qureg x0, int * x1, int x2, int * x3, int x4, ComplexMatrixN x5)
{
  applyMultiControlledMatrixN(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_applyMultiControlledMatrixN(PyObject *self, PyObject *args)
{
  Qureg x0;
  int * x1;
  int x2;
  int * x3;
  int x4;
  ComplexMatrixN x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "applyMultiControlledMatrixN", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(62), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(62), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(62), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(62), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x5, _cffi_type(109), arg5) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { applyMultiControlledMatrixN(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_applyMultiControlledMatrixN(Qureg *x0, int * x1, int x2, int * x3, int x4, ComplexMatrixN *x5)
{
  { applyMultiControlledMatrixN(*x0, x1, x2, x3, x4, *x5); }
}
#endif

static void _cffi_d_applyPauliHamil(Qureg x0, PauliHamil x1, Qureg x2)
{
  applyPauliHamil(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_applyPauliHamil(PyObject *self, PyObject *args)
{
  Qureg x0;
  PauliHamil x1;
  Qureg x2;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "applyPauliHamil", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x1, _cffi_type(46), arg1) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x2, _cffi_type(1), arg2) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { applyPauliHamil(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_applyPauliHamil(Qureg *x0, PauliHamil *x1, Qureg *x2)
{
  { applyPauliHamil(*x0, *x1, *x2); }
}
#endif

static void _cffi_d_applyPauliSum(Qureg x0, enum pauliOpType * x1, double * x2, int x3, Qureg x4)
{
  applyPauliSum(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_applyPauliSum(PyObject *self, PyObject *args)
{
  Qureg x0;
  enum pauliOpType * x1;
  double * x2;
  int x3;
  Qureg x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "applyPauliSum", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(55), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (enum pauliOpType *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(55), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(56), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(56), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x4, _cffi_type(1), arg4) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { applyPauliSum(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_applyPauliSum(Qureg *x0, enum pauliOpType * x1, double * x2, int x3, Qureg *x4)
{
  { applyPauliSum(*x0, x1, x2, x3, *x4); }
}
#endif

static void _cffi_d_applyTrotterCircuit(Qureg x0, PauliHamil x1, double x2, int x3, int x4)
{
  applyTrotterCircuit(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_applyTrotterCircuit(PyObject *self, PyObject *args)
{
  Qureg x0;
  PauliHamil x1;
  double x2;
  int x3;
  int x4;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "applyTrotterCircuit", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x1, _cffi_type(46), arg1) < 0)
    return NULL;

  x2 = (double)_cffi_to_c_double(arg2);
  if (x2 == (double)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { applyTrotterCircuit(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_applyTrotterCircuit(Qureg *x0, PauliHamil *x1, double x2, int x3, int x4)
{
  { applyTrotterCircuit(*x0, *x1, x2, x3, x4); }
}
#endif

static double _cffi_d_calcDensityInnerProduct(Qureg x0, Qureg x1)
{
  return calcDensityInnerProduct(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_calcDensityInnerProduct(PyObject *self, PyObject *args)
{
  Qureg x0;
  Qureg x1;
  double result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "calcDensityInnerProduct", 2, 2, &arg0, &arg1))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x1, _cffi_type(1), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = calcDensityInnerProduct(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_double(result);
  return pyresult;
}
#else
static double _cffi_f_calcDensityInnerProduct(Qureg *x0, Qureg *x1)
{
  double result;
  { result = calcDensityInnerProduct(*x0, *x1); }
  return result;
}
#endif

static Complex _cffi_d_calcExpecDiagonalOp(Qureg x0, DiagonalOp x1)
{
  return calcExpecDiagonalOp(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_calcExpecDiagonalOp(PyObject *self, PyObject *args)
{
  Qureg x0;
  DiagonalOp x1;
  Complex result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "calcExpecDiagonalOp", 2, 2, &arg0, &arg1))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x1, _cffi_type(2), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = calcExpecDiagonalOp(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_struct((char *)&result, _cffi_type(101));
  return pyresult;
}
#else
static void _cffi_f_calcExpecDiagonalOp(Complex *result, Qureg *x0, DiagonalOp *x1)
{
  { *result = calcExpecDiagonalOp(*x0, *x1); }
}
#endif

static double _cffi_d_calcExpecPauliHamil(Qureg x0, PauliHamil x1, Qureg x2)
{
  return calcExpecPauliHamil(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_calcExpecPauliHamil(PyObject *self, PyObject *args)
{
  Qureg x0;
  PauliHamil x1;
  Qureg x2;
  double result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "calcExpecPauliHamil", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x1, _cffi_type(46), arg1) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x2, _cffi_type(1), arg2) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = calcExpecPauliHamil(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_double(result);
  return pyresult;
}
#else
static double _cffi_f_calcExpecPauliHamil(Qureg *x0, PauliHamil *x1, Qureg *x2)
{
  double result;
  { result = calcExpecPauliHamil(*x0, *x1, *x2); }
  return result;
}
#endif

static double _cffi_d_calcExpecPauliProd(Qureg x0, int * x1, enum pauliOpType * x2, int x3, Qureg x4)
{
  return calcExpecPauliProd(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_calcExpecPauliProd(PyObject *self, PyObject *args)
{
  Qureg x0;
  int * x1;
  enum pauliOpType * x2;
  int x3;
  Qureg x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  double result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "calcExpecPauliProd", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(62), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(62), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(55), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (enum pauliOpType *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(55), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x4, _cffi_type(1), arg4) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = calcExpecPauliProd(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_double(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
static double _cffi_f_calcExpecPauliProd(Qureg *x0, int * x1, enum pauliOpType * x2, int x3, Qureg *x4)
{
  double result;
  { result = calcExpecPauliProd(*x0, x1, x2, x3, *x4); }
  return result;
}
#endif

static double _cffi_d_calcExpecPauliSum(Qureg x0, enum pauliOpType * x1, double * x2, int x3, Qureg x4)
{
  return calcExpecPauliSum(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_calcExpecPauliSum(PyObject *self, PyObject *args)
{
  Qureg x0;
  enum pauliOpType * x1;
  double * x2;
  int x3;
  Qureg x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  double result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "calcExpecPauliSum", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(55), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (enum pauliOpType *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(55), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(56), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(56), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x4, _cffi_type(1), arg4) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = calcExpecPauliSum(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_double(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
static double _cffi_f_calcExpecPauliSum(Qureg *x0, enum pauliOpType * x1, double * x2, int x3, Qureg *x4)
{
  double result;
  { result = calcExpecPauliSum(*x0, x1, x2, x3, *x4); }
  return result;
}
#endif

static double _cffi_d_calcFidelity(Qureg x0, Qureg x1)
{
  return calcFidelity(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_calcFidelity(PyObject *self, PyObject *args)
{
  Qureg x0;
  Qureg x1;
  double result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "calcFidelity", 2, 2, &arg0, &arg1))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x1, _cffi_type(1), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = calcFidelity(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_double(result);
  return pyresult;
}
#else
static double _cffi_f_calcFidelity(Qureg *x0, Qureg *x1)
{
  double result;
  { result = calcFidelity(*x0, *x1); }
  return result;
}
#endif

static double _cffi_d_calcHilbertSchmidtDistance(Qureg x0, Qureg x1)
{
  return calcHilbertSchmidtDistance(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_calcHilbertSchmidtDistance(PyObject *self, PyObject *args)
{
  Qureg x0;
  Qureg x1;
  double result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "calcHilbertSchmidtDistance", 2, 2, &arg0, &arg1))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x1, _cffi_type(1), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = calcHilbertSchmidtDistance(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_double(result);
  return pyresult;
}
#else
static double _cffi_f_calcHilbertSchmidtDistance(Qureg *x0, Qureg *x1)
{
  double result;
  { result = calcHilbertSchmidtDistance(*x0, *x1); }
  return result;
}
#endif

static Complex _cffi_d_calcInnerProduct(Qureg x0, Qureg x1)
{
  return calcInnerProduct(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_calcInnerProduct(PyObject *self, PyObject *args)
{
  Qureg x0;
  Qureg x1;
  Complex result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "calcInnerProduct", 2, 2, &arg0, &arg1))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x1, _cffi_type(1), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = calcInnerProduct(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_struct((char *)&result, _cffi_type(101));
  return pyresult;
}
#else
static void _cffi_f_calcInnerProduct(Complex *result, Qureg *x0, Qureg *x1)
{
  { *result = calcInnerProduct(*x0, *x1); }
}
#endif

static double _cffi_d_calcProbOfOutcome(Qureg x0, int x1, int x2)
{
  return calcProbOfOutcome(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_calcProbOfOutcome(PyObject *self, PyObject *args)
{
  Qureg x0;
  int x1;
  int x2;
  double result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "calcProbOfOutcome", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = calcProbOfOutcome(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_double(result);
  return pyresult;
}
#else
static double _cffi_f_calcProbOfOutcome(Qureg *x0, int x1, int x2)
{
  double result;
  { result = calcProbOfOutcome(*x0, x1, x2); }
  return result;
}
#endif

static double _cffi_d_calcPurity(Qureg x0)
{
  return calcPurity(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_calcPurity(PyObject *self, PyObject *arg0)
{
  Qureg x0;
  double result;
  PyObject *pyresult;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = calcPurity(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_double(result);
  return pyresult;
}
#else
static double _cffi_f_calcPurity(Qureg *x0)
{
  double result;
  { result = calcPurity(*x0); }
  return result;
}
#endif

static double _cffi_d_calcTotalProb(Qureg x0)
{
  return calcTotalProb(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_calcTotalProb(PyObject *self, PyObject *arg0)
{
  Qureg x0;
  double result;
  PyObject *pyresult;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = calcTotalProb(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_double(result);
  return pyresult;
}
#else
static double _cffi_f_calcTotalProb(Qureg *x0)
{
  double result;
  { result = calcTotalProb(*x0); }
  return result;
}
#endif

static void _cffi_d_clearRecordedQASM(Qureg x0)
{
  clearRecordedQASM(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clearRecordedQASM(PyObject *self, PyObject *arg0)
{
  Qureg x0;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { clearRecordedQASM(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_clearRecordedQASM(Qureg *x0)
{
  { clearRecordedQASM(*x0); }
}
#endif

static void _cffi_d_cloneQureg(Qureg x0, Qureg x1)
{
  cloneQureg(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_cloneQureg(PyObject *self, PyObject *args)
{
  Qureg x0;
  Qureg x1;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "cloneQureg", 2, 2, &arg0, &arg1))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x1, _cffi_type(1), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { cloneQureg(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_cloneQureg(Qureg *x0, Qureg *x1)
{
  { cloneQureg(*x0, *x1); }
}
#endif

static double _cffi_d_collapseToOutcome(Qureg x0, int x1, int x2)
{
  return collapseToOutcome(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_collapseToOutcome(PyObject *self, PyObject *args)
{
  Qureg x0;
  int x1;
  int x2;
  double result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "collapseToOutcome", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = collapseToOutcome(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_double(result);
  return pyresult;
}
#else
static double _cffi_f_collapseToOutcome(Qureg *x0, int x1, int x2)
{
  double result;
  { result = collapseToOutcome(*x0, x1, x2); }
  return result;
}
#endif

static void _cffi_d_compactUnitary(Qureg x0, int x1, Complex x2, Complex x3)
{
  compactUnitary(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_compactUnitary(PyObject *self, PyObject *args)
{
  Qureg x0;
  int x1;
  Complex x2;
  Complex x3;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "compactUnitary", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x2, _cffi_type(101), arg2) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x3, _cffi_type(101), arg3) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { compactUnitary(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_compactUnitary(Qureg *x0, int x1, Complex *x2, Complex *x3)
{
  { compactUnitary(*x0, x1, *x2, *x3); }
}
#endif

static void _cffi_d_controlledCompactUnitary(Qureg x0, int x1, int x2, Complex x3, Complex x4)
{
  controlledCompactUnitary(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_controlledCompactUnitary(PyObject *self, PyObject *args)
{
  Qureg x0;
  int x1;
  int x2;
  Complex x3;
  Complex x4;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "controlledCompactUnitary", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x3, _cffi_type(101), arg3) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x4, _cffi_type(101), arg4) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { controlledCompactUnitary(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_controlledCompactUnitary(Qureg *x0, int x1, int x2, Complex *x3, Complex *x4)
{
  { controlledCompactUnitary(*x0, x1, x2, *x3, *x4); }
}
#endif

static void _cffi_d_controlledMultiQubitUnitary(Qureg x0, int x1, int * x2, int x3, ComplexMatrixN x4)
{
  controlledMultiQubitUnitary(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_controlledMultiQubitUnitary(PyObject *self, PyObject *args)
{
  Qureg x0;
  int x1;
  int * x2;
  int x3;
  ComplexMatrixN x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "controlledMultiQubitUnitary", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(62), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(62), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x4, _cffi_type(109), arg4) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { controlledMultiQubitUnitary(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_controlledMultiQubitUnitary(Qureg *x0, int x1, int * x2, int x3, ComplexMatrixN *x4)
{
  { controlledMultiQubitUnitary(*x0, x1, x2, x3, *x4); }
}
#endif

static void _cffi_d_controlledNot(Qureg x0, int x1, int x2)
{
  controlledNot(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_controlledNot(PyObject *self, PyObject *args)
{
  Qureg x0;
  int x1;
  int x2;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "controlledNot", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { controlledNot(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_controlledNot(Qureg *x0, int x1, int x2)
{
  { controlledNot(*x0, x1, x2); }
}
#endif

static void _cffi_d_controlledPauliY(Qureg x0, int x1, int x2)
{
  controlledPauliY(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_controlledPauliY(PyObject *self, PyObject *args)
{
  Qureg x0;
  int x1;
  int x2;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "controlledPauliY", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { controlledPauliY(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_controlledPauliY(Qureg *x0, int x1, int x2)
{
  { controlledPauliY(*x0, x1, x2); }
}
#endif

static void _cffi_d_controlledPhaseFlip(Qureg x0, int x1, int x2)
{
  controlledPhaseFlip(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_controlledPhaseFlip(PyObject *self, PyObject *args)
{
  Qureg x0;
  int x1;
  int x2;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "controlledPhaseFlip", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { controlledPhaseFlip(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_controlledPhaseFlip(Qureg *x0, int x1, int x2)
{
  { controlledPhaseFlip(*x0, x1, x2); }
}
#endif

static void _cffi_d_controlledPhaseShift(Qureg x0, int x1, int x2, double x3)
{
  controlledPhaseShift(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_controlledPhaseShift(PyObject *self, PyObject *args)
{
  Qureg x0;
  int x1;
  int x2;
  double x3;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "controlledPhaseShift", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = (double)_cffi_to_c_double(arg3);
  if (x3 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { controlledPhaseShift(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_controlledPhaseShift(Qureg *x0, int x1, int x2, double x3)
{
  { controlledPhaseShift(*x0, x1, x2, x3); }
}
#endif

static void _cffi_d_controlledRotateAroundAxis(Qureg x0, int x1, int x2, double x3, Vector x4)
{
  controlledRotateAroundAxis(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_controlledRotateAroundAxis(PyObject *self, PyObject *args)
{
  Qureg x0;
  int x1;
  int x2;
  double x3;
  Vector x4;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "controlledRotateAroundAxis", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = (double)_cffi_to_c_double(arg3);
  if (x3 == (double)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x4, _cffi_type(286), arg4) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { controlledRotateAroundAxis(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_controlledRotateAroundAxis(Qureg *x0, int x1, int x2, double x3, Vector *x4)
{
  { controlledRotateAroundAxis(*x0, x1, x2, x3, *x4); }
}
#endif

static void _cffi_d_controlledRotateX(Qureg x0, int x1, int x2, double x3)
{
  controlledRotateX(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_controlledRotateX(PyObject *self, PyObject *args)
{
  Qureg x0;
  int x1;
  int x2;
  double x3;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "controlledRotateX", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = (double)_cffi_to_c_double(arg3);
  if (x3 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { controlledRotateX(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_controlledRotateX(Qureg *x0, int x1, int x2, double x3)
{
  { controlledRotateX(*x0, x1, x2, x3); }
}
#endif

static void _cffi_d_controlledRotateY(Qureg x0, int x1, int x2, double x3)
{
  controlledRotateY(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_controlledRotateY(PyObject *self, PyObject *args)
{
  Qureg x0;
  int x1;
  int x2;
  double x3;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "controlledRotateY", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = (double)_cffi_to_c_double(arg3);
  if (x3 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { controlledRotateY(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_controlledRotateY(Qureg *x0, int x1, int x2, double x3)
{
  { controlledRotateY(*x0, x1, x2, x3); }
}
#endif

static void _cffi_d_controlledRotateZ(Qureg x0, int x1, int x2, double x3)
{
  controlledRotateZ(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_controlledRotateZ(PyObject *self, PyObject *args)
{
  Qureg x0;
  int x1;
  int x2;
  double x3;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "controlledRotateZ", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = (double)_cffi_to_c_double(arg3);
  if (x3 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { controlledRotateZ(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_controlledRotateZ(Qureg *x0, int x1, int x2, double x3)
{
  { controlledRotateZ(*x0, x1, x2, x3); }
}
#endif

static void _cffi_d_controlledTwoQubitUnitary(Qureg x0, int x1, int x2, int x3, ComplexMatrix4 x4)
{
  controlledTwoQubitUnitary(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_controlledTwoQubitUnitary(PyObject *self, PyObject *args)
{
  Qureg x0;
  int x1;
  int x2;
  int x3;
  ComplexMatrix4 x4;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "controlledTwoQubitUnitary", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x4, _cffi_type(254), arg4) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { controlledTwoQubitUnitary(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_controlledTwoQubitUnitary(Qureg *x0, int x1, int x2, int x3, ComplexMatrix4 *x4)
{
  { controlledTwoQubitUnitary(*x0, x1, x2, x3, *x4); }
}
#endif

static void _cffi_d_controlledUnitary(Qureg x0, int x1, int x2, ComplexMatrix2 x3)
{
  controlledUnitary(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_controlledUnitary(PyObject *self, PyObject *args)
{
  Qureg x0;
  int x1;
  int x2;
  ComplexMatrix2 x3;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "controlledUnitary", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x3, _cffi_type(207), arg3) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { controlledUnitary(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_controlledUnitary(Qureg *x0, int x1, int x2, ComplexMatrix2 *x3)
{
  { controlledUnitary(*x0, x1, x2, *x3); }
}
#endif

static void _cffi_d_copyStateFromGPU(Qureg x0)
{
  copyStateFromGPU(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_copyStateFromGPU(PyObject *self, PyObject *arg0)
{
  Qureg x0;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { copyStateFromGPU(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_copyStateFromGPU(Qureg *x0)
{
  { copyStateFromGPU(*x0); }
}
#endif

static void _cffi_d_copyStateToGPU(Qureg x0)
{
  copyStateToGPU(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_copyStateToGPU(PyObject *self, PyObject *arg0)
{
  Qureg x0;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { copyStateToGPU(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_copyStateToGPU(Qureg *x0)
{
  { copyStateToGPU(*x0); }
}
#endif

static Qureg _cffi_d_createCloneQureg(Qureg x0, QuESTEnv x1)
{
  return createCloneQureg(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_createCloneQureg(PyObject *self, PyObject *args)
{
  Qureg x0;
  QuESTEnv x1;
  Qureg result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "createCloneQureg", 2, 2, &arg0, &arg1))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x1, _cffi_type(22), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = createCloneQureg(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_struct((char *)&result, _cffi_type(1));
  return pyresult;
}
#else
static void _cffi_f_createCloneQureg(Qureg *result, Qureg *x0, QuESTEnv *x1)
{
  { *result = createCloneQureg(*x0, *x1); }
}
#endif

static ComplexMatrixN _cffi_d_createComplexMatrixN(int x0)
{
  return createComplexMatrixN(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_createComplexMatrixN(PyObject *self, PyObject *arg0)
{
  int x0;
  ComplexMatrixN result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = createComplexMatrixN(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_struct((char *)&result, _cffi_type(109));
  return pyresult;
}
#else
static void _cffi_f_createComplexMatrixN(ComplexMatrixN *result, int x0)
{
  { *result = createComplexMatrixN(x0); }
}
#endif

static Qureg _cffi_d_createDensityQureg(int x0, QuESTEnv x1)
{
  return createDensityQureg(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_createDensityQureg(PyObject *self, PyObject *args)
{
  int x0;
  QuESTEnv x1;
  Qureg result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "createDensityQureg", 2, 2, &arg0, &arg1))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x1, _cffi_type(22), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = createDensityQureg(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_struct((char *)&result, _cffi_type(1));
  return pyresult;
}
#else
static void _cffi_f_createDensityQureg(Qureg *result, int x0, QuESTEnv *x1)
{
  { *result = createDensityQureg(x0, *x1); }
}
#endif

static DiagonalOp _cffi_d_createDiagonalOp(int x0, QuESTEnv x1)
{
  return createDiagonalOp(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_createDiagonalOp(PyObject *self, PyObject *args)
{
  int x0;
  QuESTEnv x1;
  DiagonalOp result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "createDiagonalOp", 2, 2, &arg0, &arg1))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x1, _cffi_type(22), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = createDiagonalOp(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_struct((char *)&result, _cffi_type(2));
  return pyresult;
}
#else
static void _cffi_f_createDiagonalOp(DiagonalOp *result, int x0, QuESTEnv *x1)
{
  { *result = createDiagonalOp(x0, *x1); }
}
#endif

static PauliHamil _cffi_d_createPauliHamil(int x0, int x1)
{
  return createPauliHamil(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_createPauliHamil(PyObject *self, PyObject *args)
{
  int x0;
  int x1;
  PauliHamil result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "createPauliHamil", 2, 2, &arg0, &arg1))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = createPauliHamil(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_struct((char *)&result, _cffi_type(46));
  return pyresult;
}
#else
static void _cffi_f_createPauliHamil(PauliHamil *result, int x0, int x1)
{
  { *result = createPauliHamil(x0, x1); }
}
#endif

static PauliHamil _cffi_d_createPauliHamilFromFile(char * x0)
{
  return createPauliHamilFromFile(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_createPauliHamilFromFile(PyObject *self, PyObject *arg0)
{
  char * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PauliHamil result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = createPauliHamilFromFile(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_struct((char *)&result, _cffi_type(46));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
static void _cffi_f_createPauliHamilFromFile(PauliHamil *result, char * x0)
{
  { *result = createPauliHamilFromFile(x0); }
}
#endif

static QuESTEnv _cffi_d_createQuESTEnv(void)
{
  return createQuESTEnv();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_createQuESTEnv(PyObject *self, PyObject *noarg)
{
  QuESTEnv result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = createQuESTEnv(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_struct((char *)&result, _cffi_type(22));
  return pyresult;
}
#else
static void _cffi_f_createQuESTEnv(QuESTEnv *result)
{
  { *result = createQuESTEnv(); }
}
#endif

static Qureg _cffi_d_createQureg(int x0, QuESTEnv x1)
{
  return createQureg(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_createQureg(PyObject *self, PyObject *args)
{
  int x0;
  QuESTEnv x1;
  Qureg result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "createQureg", 2, 2, &arg0, &arg1))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x1, _cffi_type(22), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = createQureg(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_struct((char *)&result, _cffi_type(1));
  return pyresult;
}
#else
static void _cffi_f_createQureg(Qureg *result, int x0, QuESTEnv *x1)
{
  { *result = createQureg(x0, *x1); }
}
#endif

static double _cffi_d_densmatr_calcProbOfOutcome(Qureg x0, int x1, int x2)
{
  return densmatr_calcProbOfOutcome(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_densmatr_calcProbOfOutcome(PyObject *self, PyObject *args)
{
  Qureg x0;
  int x1;
  int x2;
  double result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "densmatr_calcProbOfOutcome", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = densmatr_calcProbOfOutcome(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_double(result);
  return pyresult;
}
#else
static double _cffi_f_densmatr_calcProbOfOutcome(Qureg *x0, int x1, int x2)
{
  double result;
  { result = densmatr_calcProbOfOutcome(*x0, x1, x2); }
  return result;
}
#endif

static void _cffi_d_destroyComplexMatrixN(ComplexMatrixN x0)
{
  destroyComplexMatrixN(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_destroyComplexMatrixN(PyObject *self, PyObject *arg0)
{
  ComplexMatrixN x0;

  if (_cffi_to_c((char *)&x0, _cffi_type(109), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { destroyComplexMatrixN(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_destroyComplexMatrixN(ComplexMatrixN *x0)
{
  { destroyComplexMatrixN(*x0); }
}
#endif

static void _cffi_d_destroyDiagonalOp(DiagonalOp x0, QuESTEnv x1)
{
  destroyDiagonalOp(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_destroyDiagonalOp(PyObject *self, PyObject *args)
{
  DiagonalOp x0;
  QuESTEnv x1;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "destroyDiagonalOp", 2, 2, &arg0, &arg1))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(2), arg0) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x1, _cffi_type(22), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { destroyDiagonalOp(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_destroyDiagonalOp(DiagonalOp *x0, QuESTEnv *x1)
{
  { destroyDiagonalOp(*x0, *x1); }
}
#endif

static void _cffi_d_destroyPauliHamil(PauliHamil x0)
{
  destroyPauliHamil(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_destroyPauliHamil(PyObject *self, PyObject *arg0)
{
  PauliHamil x0;

  if (_cffi_to_c((char *)&x0, _cffi_type(46), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { destroyPauliHamil(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_destroyPauliHamil(PauliHamil *x0)
{
  { destroyPauliHamil(*x0); }
}
#endif

static void _cffi_d_destroyQuESTEnv(QuESTEnv x0)
{
  destroyQuESTEnv(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_destroyQuESTEnv(PyObject *self, PyObject *arg0)
{
  QuESTEnv x0;

  if (_cffi_to_c((char *)&x0, _cffi_type(22), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { destroyQuESTEnv(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_destroyQuESTEnv(QuESTEnv *x0)
{
  { destroyQuESTEnv(*x0); }
}
#endif

static void _cffi_d_destroyQureg(Qureg x0, QuESTEnv x1)
{
  destroyQureg(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_destroyQureg(PyObject *self, PyObject *args)
{
  Qureg x0;
  QuESTEnv x1;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "destroyQureg", 2, 2, &arg0, &arg1))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x1, _cffi_type(22), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { destroyQureg(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_destroyQureg(Qureg *x0, QuESTEnv *x1)
{
  { destroyQureg(*x0, *x1); }
}
#endif

static int _cffi_d_generateMeasurementOutcome(double x0, double * x1)
{
  return generateMeasurementOutcome(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_generateMeasurementOutcome(PyObject *self, PyObject *args)
{
  double x0;
  double * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "generateMeasurementOutcome", 2, 2, &arg0, &arg1))
    return NULL;

  x0 = (double)_cffi_to_c_double(arg0);
  if (x0 == (double)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(56), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(56), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = generateMeasurementOutcome(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_generateMeasurementOutcome _cffi_d_generateMeasurementOutcome
#endif

static Complex _cffi_d_getAmp(Qureg x0, long long x1)
{
  return getAmp(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_getAmp(PyObject *self, PyObject *args)
{
  Qureg x0;
  long long x1;
  Complex result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "getAmp", 2, 2, &arg0, &arg1))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  x1 = _cffi_to_c_int(arg1, long long);
  if (x1 == (long long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = getAmp(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_struct((char *)&result, _cffi_type(101));
  return pyresult;
}
#else
static void _cffi_f_getAmp(Complex *result, Qureg *x0, long long x1)
{
  { *result = getAmp(*x0, x1); }
}
#endif

static Complex _cffi_d_getDensityAmp(Qureg x0, long long x1, long long x2)
{
  return getDensityAmp(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_getDensityAmp(PyObject *self, PyObject *args)
{
  Qureg x0;
  long long x1;
  long long x2;
  Complex result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "getDensityAmp", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  x1 = _cffi_to_c_int(arg1, long long);
  if (x1 == (long long)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, long long);
  if (x2 == (long long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = getDensityAmp(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_struct((char *)&result, _cffi_type(101));
  return pyresult;
}
#else
static void _cffi_f_getDensityAmp(Complex *result, Qureg *x0, long long x1, long long x2)
{
  { *result = getDensityAmp(*x0, x1, x2); }
}
#endif

static double _cffi_d_getImagAmp(Qureg x0, long long x1)
{
  return getImagAmp(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_getImagAmp(PyObject *self, PyObject *args)
{
  Qureg x0;
  long long x1;
  double result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "getImagAmp", 2, 2, &arg0, &arg1))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  x1 = _cffi_to_c_int(arg1, long long);
  if (x1 == (long long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = getImagAmp(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_double(result);
  return pyresult;
}
#else
static double _cffi_f_getImagAmp(Qureg *x0, long long x1)
{
  double result;
  { result = getImagAmp(*x0, x1); }
  return result;
}
#endif

static long long _cffi_d_getNumAmps(Qureg x0)
{
  return getNumAmps(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_getNumAmps(PyObject *self, PyObject *arg0)
{
  Qureg x0;
  long long result;
  PyObject *pyresult;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = getNumAmps(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, long long);
  return pyresult;
}
#else
static long long _cffi_f_getNumAmps(Qureg *x0)
{
  long long result;
  { result = getNumAmps(*x0); }
  return result;
}
#endif

static int _cffi_d_getNumQubits(Qureg x0)
{
  return getNumQubits(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_getNumQubits(PyObject *self, PyObject *arg0)
{
  Qureg x0;
  int result;
  PyObject *pyresult;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = getNumQubits(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
static int _cffi_f_getNumQubits(Qureg *x0)
{
  int result;
  { result = getNumQubits(*x0); }
  return result;
}
#endif

static double _cffi_d_getProbAmp(Qureg x0, long long x1)
{
  return getProbAmp(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_getProbAmp(PyObject *self, PyObject *args)
{
  Qureg x0;
  long long x1;
  double result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "getProbAmp", 2, 2, &arg0, &arg1))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  x1 = _cffi_to_c_int(arg1, long long);
  if (x1 == (long long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = getProbAmp(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_double(result);
  return pyresult;
}
#else
static double _cffi_f_getProbAmp(Qureg *x0, long long x1)
{
  double result;
  { result = getProbAmp(*x0, x1); }
  return result;
}
#endif

static int _cffi_d_getQuEST_PREC(void)
{
  return getQuEST_PREC();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_getQuEST_PREC(PyObject *self, PyObject *noarg)
{
  int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = getQuEST_PREC(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_getQuEST_PREC _cffi_d_getQuEST_PREC
#endif

static double _cffi_d_getRealAmp(Qureg x0, long long x1)
{
  return getRealAmp(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_getRealAmp(PyObject *self, PyObject *args)
{
  Qureg x0;
  long long x1;
  double result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "getRealAmp", 2, 2, &arg0, &arg1))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  x1 = _cffi_to_c_int(arg1, long long);
  if (x1 == (long long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = getRealAmp(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_double(result);
  return pyresult;
}
#else
static double _cffi_f_getRealAmp(Qureg *x0, long long x1)
{
  double result;
  { result = getRealAmp(*x0, x1); }
  return result;
}
#endif

static void _cffi_d_hadamard(Qureg x0, int x1)
{
  hadamard(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_hadamard(PyObject *self, PyObject *args)
{
  Qureg x0;
  int x1;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "hadamard", 2, 2, &arg0, &arg1))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { hadamard(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_hadamard(Qureg *x0, int x1)
{
  { hadamard(*x0, x1); }
}
#endif

static void _cffi_d_initBlankState(Qureg x0)
{
  initBlankState(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_initBlankState(PyObject *self, PyObject *arg0)
{
  Qureg x0;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { initBlankState(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_initBlankState(Qureg *x0)
{
  { initBlankState(*x0); }
}
#endif

static void _cffi_d_initClassicalState(Qureg x0, long long x1)
{
  initClassicalState(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_initClassicalState(PyObject *self, PyObject *args)
{
  Qureg x0;
  long long x1;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "initClassicalState", 2, 2, &arg0, &arg1))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  x1 = _cffi_to_c_int(arg1, long long);
  if (x1 == (long long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { initClassicalState(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_initClassicalState(Qureg *x0, long long x1)
{
  { initClassicalState(*x0, x1); }
}
#endif

static void _cffi_d_initDebugState(Qureg x0)
{
  initDebugState(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_initDebugState(PyObject *self, PyObject *arg0)
{
  Qureg x0;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { initDebugState(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_initDebugState(Qureg *x0)
{
  { initDebugState(*x0); }
}
#endif

static void _cffi_d_initDiagonalOp(DiagonalOp x0, double * x1, double * x2)
{
  initDiagonalOp(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_initDiagonalOp(PyObject *self, PyObject *args)
{
  DiagonalOp x0;
  double * x1;
  double * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "initDiagonalOp", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(2), arg0) < 0)
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(56), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(56), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(56), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(56), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { initDiagonalOp(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_initDiagonalOp(DiagonalOp *x0, double * x1, double * x2)
{
  { initDiagonalOp(*x0, x1, x2); }
}
#endif

static void _cffi_d_initPauliHamil(PauliHamil x0, double * x1, enum pauliOpType * x2)
{
  initPauliHamil(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_initPauliHamil(PyObject *self, PyObject *args)
{
  PauliHamil x0;
  double * x1;
  enum pauliOpType * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "initPauliHamil", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(46), arg0) < 0)
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(56), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(56), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(55), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (enum pauliOpType *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(55), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { initPauliHamil(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_initPauliHamil(PauliHamil *x0, double * x1, enum pauliOpType * x2)
{
  { initPauliHamil(*x0, x1, x2); }
}
#endif

static void _cffi_d_initPlusState(Qureg x0)
{
  initPlusState(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_initPlusState(PyObject *self, PyObject *arg0)
{
  Qureg x0;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { initPlusState(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_initPlusState(Qureg *x0)
{
  { initPlusState(*x0); }
}
#endif

static void _cffi_d_initPureState(Qureg x0, Qureg x1)
{
  initPureState(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_initPureState(PyObject *self, PyObject *args)
{
  Qureg x0;
  Qureg x1;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "initPureState", 2, 2, &arg0, &arg1))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x1, _cffi_type(1), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { initPureState(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_initPureState(Qureg *x0, Qureg *x1)
{
  { initPureState(*x0, *x1); }
}
#endif

static void _cffi_d_initStateFromAmps(Qureg x0, double * x1, double * x2)
{
  initStateFromAmps(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_initStateFromAmps(PyObject *self, PyObject *args)
{
  Qureg x0;
  double * x1;
  double * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "initStateFromAmps", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(56), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(56), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(56), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(56), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { initStateFromAmps(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_initStateFromAmps(Qureg *x0, double * x1, double * x2)
{
  { initStateFromAmps(*x0, x1, x2); }
}
#endif

static void _cffi_d_initZeroState(Qureg x0)
{
  initZeroState(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_initZeroState(PyObject *self, PyObject *arg0)
{
  Qureg x0;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { initZeroState(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_initZeroState(Qureg *x0)
{
  { initZeroState(*x0); }
}
#endif

static void _cffi_d_invalidQuESTInputError(char const * x0, char const * x1)
{
  invalidQuESTInputError(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_invalidQuESTInputError(PyObject *self, PyObject *args)
{
  char const * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "invalidQuESTInputError", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(365), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(365), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(365), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(365), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { invalidQuESTInputError(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_invalidQuESTInputError _cffi_d_invalidQuESTInputError
#endif

static int _cffi_d_measure(Qureg x0, int x1)
{
  return measure(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_measure(PyObject *self, PyObject *args)
{
  Qureg x0;
  int x1;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "measure", 2, 2, &arg0, &arg1))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = measure(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
static int _cffi_f_measure(Qureg *x0, int x1)
{
  int result;
  { result = measure(*x0, x1); }
  return result;
}
#endif

static int _cffi_d_measureWithStats(Qureg x0, int x1, double * x2)
{
  return measureWithStats(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_measureWithStats(PyObject *self, PyObject *args)
{
  Qureg x0;
  int x1;
  double * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "measureWithStats", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(56), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(56), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = measureWithStats(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
static int _cffi_f_measureWithStats(Qureg *x0, int x1, double * x2)
{
  int result;
  { result = measureWithStats(*x0, x1, x2); }
  return result;
}
#endif

static void _cffi_d_mixDamping(Qureg x0, int x1, double x2)
{
  mixDamping(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mixDamping(PyObject *self, PyObject *args)
{
  Qureg x0;
  int x1;
  double x2;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "mixDamping", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = (double)_cffi_to_c_double(arg2);
  if (x2 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { mixDamping(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_mixDamping(Qureg *x0, int x1, double x2)
{
  { mixDamping(*x0, x1, x2); }
}
#endif

static void _cffi_d_mixDensityMatrix(Qureg x0, double x1, Qureg x2)
{
  mixDensityMatrix(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mixDensityMatrix(PyObject *self, PyObject *args)
{
  Qureg x0;
  double x1;
  Qureg x2;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "mixDensityMatrix", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  x1 = (double)_cffi_to_c_double(arg1);
  if (x1 == (double)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x2, _cffi_type(1), arg2) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { mixDensityMatrix(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_mixDensityMatrix(Qureg *x0, double x1, Qureg *x2)
{
  { mixDensityMatrix(*x0, x1, *x2); }
}
#endif

static void _cffi_d_mixDephasing(Qureg x0, int x1, double x2)
{
  mixDephasing(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mixDephasing(PyObject *self, PyObject *args)
{
  Qureg x0;
  int x1;
  double x2;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "mixDephasing", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = (double)_cffi_to_c_double(arg2);
  if (x2 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { mixDephasing(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_mixDephasing(Qureg *x0, int x1, double x2)
{
  { mixDephasing(*x0, x1, x2); }
}
#endif

static void _cffi_d_mixDepolarising(Qureg x0, int x1, double x2)
{
  mixDepolarising(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mixDepolarising(PyObject *self, PyObject *args)
{
  Qureg x0;
  int x1;
  double x2;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "mixDepolarising", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = (double)_cffi_to_c_double(arg2);
  if (x2 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { mixDepolarising(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_mixDepolarising(Qureg *x0, int x1, double x2)
{
  { mixDepolarising(*x0, x1, x2); }
}
#endif

static void _cffi_d_mixKrausMap(Qureg x0, int x1, ComplexMatrix2 * x2, int x3)
{
  mixKrausMap(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mixKrausMap(PyObject *self, PyObject *args)
{
  Qureg x0;
  int x1;
  ComplexMatrix2 * x2;
  int x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "mixKrausMap", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(269), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (ComplexMatrix2 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(269), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { mixKrausMap(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_mixKrausMap(Qureg *x0, int x1, ComplexMatrix2 * x2, int x3)
{
  { mixKrausMap(*x0, x1, x2, x3); }
}
#endif

static void _cffi_d_mixMultiQubitKrausMap(Qureg x0, int * x1, int x2, ComplexMatrixN * x3, int x4)
{
  mixMultiQubitKrausMap(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mixMultiQubitKrausMap(PyObject *self, PyObject *args)
{
  Qureg x0;
  int * x1;
  int x2;
  ComplexMatrixN * x3;
  int x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "mixMultiQubitKrausMap", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(62), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(62), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(218), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (ComplexMatrixN *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(218), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { mixMultiQubitKrausMap(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_mixMultiQubitKrausMap(Qureg *x0, int * x1, int x2, ComplexMatrixN * x3, int x4)
{
  { mixMultiQubitKrausMap(*x0, x1, x2, x3, x4); }
}
#endif

static void _cffi_d_mixPauli(Qureg x0, int x1, double x2, double x3, double x4)
{
  mixPauli(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mixPauli(PyObject *self, PyObject *args)
{
  Qureg x0;
  int x1;
  double x2;
  double x3;
  double x4;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "mixPauli", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = (double)_cffi_to_c_double(arg2);
  if (x2 == (double)-1 && PyErr_Occurred())
    return NULL;

  x3 = (double)_cffi_to_c_double(arg3);
  if (x3 == (double)-1 && PyErr_Occurred())
    return NULL;

  x4 = (double)_cffi_to_c_double(arg4);
  if (x4 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { mixPauli(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_mixPauli(Qureg *x0, int x1, double x2, double x3, double x4)
{
  { mixPauli(*x0, x1, x2, x3, x4); }
}
#endif

static void _cffi_d_mixTwoQubitDephasing(Qureg x0, int x1, int x2, double x3)
{
  mixTwoQubitDephasing(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mixTwoQubitDephasing(PyObject *self, PyObject *args)
{
  Qureg x0;
  int x1;
  int x2;
  double x3;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "mixTwoQubitDephasing", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = (double)_cffi_to_c_double(arg3);
  if (x3 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { mixTwoQubitDephasing(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_mixTwoQubitDephasing(Qureg *x0, int x1, int x2, double x3)
{
  { mixTwoQubitDephasing(*x0, x1, x2, x3); }
}
#endif

static void _cffi_d_mixTwoQubitDepolarising(Qureg x0, int x1, int x2, double x3)
{
  mixTwoQubitDepolarising(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mixTwoQubitDepolarising(PyObject *self, PyObject *args)
{
  Qureg x0;
  int x1;
  int x2;
  double x3;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "mixTwoQubitDepolarising", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = (double)_cffi_to_c_double(arg3);
  if (x3 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { mixTwoQubitDepolarising(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_mixTwoQubitDepolarising(Qureg *x0, int x1, int x2, double x3)
{
  { mixTwoQubitDepolarising(*x0, x1, x2, x3); }
}
#endif

static void _cffi_d_mixTwoQubitKrausMap(Qureg x0, int x1, int x2, ComplexMatrix4 * x3, int x4)
{
  mixTwoQubitKrausMap(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mixTwoQubitKrausMap(PyObject *self, PyObject *args)
{
  Qureg x0;
  int x1;
  int x2;
  ComplexMatrix4 * x3;
  int x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "mixTwoQubitKrausMap", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(324), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (ComplexMatrix4 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(324), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { mixTwoQubitKrausMap(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_mixTwoQubitKrausMap(Qureg *x0, int x1, int x2, ComplexMatrix4 * x3, int x4)
{
  { mixTwoQubitKrausMap(*x0, x1, x2, x3, x4); }
}
#endif

static void _cffi_d_multiControlledMultiQubitUnitary(Qureg x0, int * x1, int x2, int * x3, int x4, ComplexMatrixN x5)
{
  multiControlledMultiQubitUnitary(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_multiControlledMultiQubitUnitary(PyObject *self, PyObject *args)
{
  Qureg x0;
  int * x1;
  int x2;
  int * x3;
  int x4;
  ComplexMatrixN x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "multiControlledMultiQubitUnitary", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(62), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(62), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(62), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(62), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x5, _cffi_type(109), arg5) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { multiControlledMultiQubitUnitary(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_multiControlledMultiQubitUnitary(Qureg *x0, int * x1, int x2, int * x3, int x4, ComplexMatrixN *x5)
{
  { multiControlledMultiQubitUnitary(*x0, x1, x2, x3, x4, *x5); }
}
#endif

static void _cffi_d_multiControlledPhaseFlip(Qureg x0, int * x1, int x2)
{
  multiControlledPhaseFlip(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_multiControlledPhaseFlip(PyObject *self, PyObject *args)
{
  Qureg x0;
  int * x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "multiControlledPhaseFlip", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(62), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(62), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { multiControlledPhaseFlip(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_multiControlledPhaseFlip(Qureg *x0, int * x1, int x2)
{
  { multiControlledPhaseFlip(*x0, x1, x2); }
}
#endif

static void _cffi_d_multiControlledPhaseShift(Qureg x0, int * x1, int x2, double x3)
{
  multiControlledPhaseShift(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_multiControlledPhaseShift(PyObject *self, PyObject *args)
{
  Qureg x0;
  int * x1;
  int x2;
  double x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "multiControlledPhaseShift", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(62), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(62), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = (double)_cffi_to_c_double(arg3);
  if (x3 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { multiControlledPhaseShift(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_multiControlledPhaseShift(Qureg *x0, int * x1, int x2, double x3)
{
  { multiControlledPhaseShift(*x0, x1, x2, x3); }
}
#endif

static void _cffi_d_multiControlledTwoQubitUnitary(Qureg x0, int * x1, int x2, int x3, int x4, ComplexMatrix4 x5)
{
  multiControlledTwoQubitUnitary(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_multiControlledTwoQubitUnitary(PyObject *self, PyObject *args)
{
  Qureg x0;
  int * x1;
  int x2;
  int x3;
  int x4;
  ComplexMatrix4 x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "multiControlledTwoQubitUnitary", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(62), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(62), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x5, _cffi_type(254), arg5) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { multiControlledTwoQubitUnitary(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_multiControlledTwoQubitUnitary(Qureg *x0, int * x1, int x2, int x3, int x4, ComplexMatrix4 *x5)
{
  { multiControlledTwoQubitUnitary(*x0, x1, x2, x3, x4, *x5); }
}
#endif

static void _cffi_d_multiControlledUnitary(Qureg x0, int * x1, int x2, int x3, ComplexMatrix2 x4)
{
  multiControlledUnitary(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_multiControlledUnitary(PyObject *self, PyObject *args)
{
  Qureg x0;
  int * x1;
  int x2;
  int x3;
  ComplexMatrix2 x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "multiControlledUnitary", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(62), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(62), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x4, _cffi_type(207), arg4) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { multiControlledUnitary(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_multiControlledUnitary(Qureg *x0, int * x1, int x2, int x3, ComplexMatrix2 *x4)
{
  { multiControlledUnitary(*x0, x1, x2, x3, *x4); }
}
#endif

static void _cffi_d_multiQubitUnitary(Qureg x0, int * x1, int x2, ComplexMatrixN x3)
{
  multiQubitUnitary(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_multiQubitUnitary(PyObject *self, PyObject *args)
{
  Qureg x0;
  int * x1;
  int x2;
  ComplexMatrixN x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "multiQubitUnitary", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(62), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(62), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x3, _cffi_type(109), arg3) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { multiQubitUnitary(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_multiQubitUnitary(Qureg *x0, int * x1, int x2, ComplexMatrixN *x3)
{
  { multiQubitUnitary(*x0, x1, x2, *x3); }
}
#endif

static void _cffi_d_multiRotatePauli(Qureg x0, int * x1, enum pauliOpType * x2, int x3, double x4)
{
  multiRotatePauli(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_multiRotatePauli(PyObject *self, PyObject *args)
{
  Qureg x0;
  int * x1;
  enum pauliOpType * x2;
  int x3;
  double x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "multiRotatePauli", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(62), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(62), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(55), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (enum pauliOpType *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(55), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  x4 = (double)_cffi_to_c_double(arg4);
  if (x4 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { multiRotatePauli(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_multiRotatePauli(Qureg *x0, int * x1, enum pauliOpType * x2, int x3, double x4)
{
  { multiRotatePauli(*x0, x1, x2, x3, x4); }
}
#endif

static void _cffi_d_multiRotateZ(Qureg x0, int * x1, int x2, double x3)
{
  multiRotateZ(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_multiRotateZ(PyObject *self, PyObject *args)
{
  Qureg x0;
  int * x1;
  int x2;
  double x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "multiRotateZ", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(62), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(62), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = (double)_cffi_to_c_double(arg3);
  if (x3 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { multiRotateZ(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_multiRotateZ(Qureg *x0, int * x1, int x2, double x3)
{
  { multiRotateZ(*x0, x1, x2, x3); }
}
#endif

static void _cffi_d_multiStateControlledUnitary(Qureg x0, int * x1, int * x2, int x3, int x4, ComplexMatrix2 x5)
{
  multiStateControlledUnitary(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_multiStateControlledUnitary(PyObject *self, PyObject *args)
{
  Qureg x0;
  int * x1;
  int * x2;
  int x3;
  int x4;
  ComplexMatrix2 x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "multiStateControlledUnitary", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(62), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(62), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(62), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(62), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x5, _cffi_type(207), arg5) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { multiStateControlledUnitary(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_multiStateControlledUnitary(Qureg *x0, int * x1, int * x2, int x3, int x4, ComplexMatrix2 *x5)
{
  { multiStateControlledUnitary(*x0, x1, x2, x3, x4, *x5); }
}
#endif

static void _cffi_d_pauliX(Qureg x0, int x1)
{
  pauliX(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_pauliX(PyObject *self, PyObject *args)
{
  Qureg x0;
  int x1;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "pauliX", 2, 2, &arg0, &arg1))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { pauliX(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_pauliX(Qureg *x0, int x1)
{
  { pauliX(*x0, x1); }
}
#endif

static void _cffi_d_pauliY(Qureg x0, int x1)
{
  pauliY(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_pauliY(PyObject *self, PyObject *args)
{
  Qureg x0;
  int x1;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "pauliY", 2, 2, &arg0, &arg1))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { pauliY(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_pauliY(Qureg *x0, int x1)
{
  { pauliY(*x0, x1); }
}
#endif

static void _cffi_d_pauliZ(Qureg x0, int x1)
{
  pauliZ(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_pauliZ(PyObject *self, PyObject *args)
{
  Qureg x0;
  int x1;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "pauliZ", 2, 2, &arg0, &arg1))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { pauliZ(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_pauliZ(Qureg *x0, int x1)
{
  { pauliZ(*x0, x1); }
}
#endif

static void _cffi_d_phaseShift(Qureg x0, int x1, double x2)
{
  phaseShift(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_phaseShift(PyObject *self, PyObject *args)
{
  Qureg x0;
  int x1;
  double x2;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "phaseShift", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = (double)_cffi_to_c_double(arg2);
  if (x2 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { phaseShift(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_phaseShift(Qureg *x0, int x1, double x2)
{
  { phaseShift(*x0, x1, x2); }
}
#endif

static void _cffi_d_printRecordedQASM(Qureg x0)
{
  printRecordedQASM(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_printRecordedQASM(PyObject *self, PyObject *arg0)
{
  Qureg x0;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { printRecordedQASM(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_printRecordedQASM(Qureg *x0)
{
  { printRecordedQASM(*x0); }
}
#endif

static void _cffi_d_reportPauliHamil(PauliHamil x0)
{
  reportPauliHamil(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_reportPauliHamil(PyObject *self, PyObject *arg0)
{
  PauliHamil x0;

  if (_cffi_to_c((char *)&x0, _cffi_type(46), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { reportPauliHamil(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_reportPauliHamil(PauliHamil *x0)
{
  { reportPauliHamil(*x0); }
}
#endif

static void _cffi_d_reportQuESTEnv(QuESTEnv x0)
{
  reportQuESTEnv(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_reportQuESTEnv(PyObject *self, PyObject *arg0)
{
  QuESTEnv x0;

  if (_cffi_to_c((char *)&x0, _cffi_type(22), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { reportQuESTEnv(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_reportQuESTEnv(QuESTEnv *x0)
{
  { reportQuESTEnv(*x0); }
}
#endif

static void _cffi_d_reportQuregParams(Qureg x0)
{
  reportQuregParams(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_reportQuregParams(PyObject *self, PyObject *arg0)
{
  Qureg x0;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { reportQuregParams(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_reportQuregParams(Qureg *x0)
{
  { reportQuregParams(*x0); }
}
#endif

static void _cffi_d_reportState(Qureg x0)
{
  reportState(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_reportState(PyObject *self, PyObject *arg0)
{
  Qureg x0;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { reportState(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_reportState(Qureg *x0)
{
  { reportState(*x0); }
}
#endif

static void _cffi_d_reportStateToScreen(Qureg x0, QuESTEnv x1, int x2)
{
  reportStateToScreen(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_reportStateToScreen(PyObject *self, PyObject *args)
{
  Qureg x0;
  QuESTEnv x1;
  int x2;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "reportStateToScreen", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x1, _cffi_type(22), arg1) < 0)
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { reportStateToScreen(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_reportStateToScreen(Qureg *x0, QuESTEnv *x1, int x2)
{
  { reportStateToScreen(*x0, *x1, x2); }
}
#endif

static void _cffi_d_rotateAroundAxis(Qureg x0, int x1, double x2, Vector x3)
{
  rotateAroundAxis(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_rotateAroundAxis(PyObject *self, PyObject *args)
{
  Qureg x0;
  int x1;
  double x2;
  Vector x3;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "rotateAroundAxis", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = (double)_cffi_to_c_double(arg2);
  if (x2 == (double)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x3, _cffi_type(286), arg3) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { rotateAroundAxis(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_rotateAroundAxis(Qureg *x0, int x1, double x2, Vector *x3)
{
  { rotateAroundAxis(*x0, x1, x2, *x3); }
}
#endif

static void _cffi_d_rotateX(Qureg x0, int x1, double x2)
{
  rotateX(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_rotateX(PyObject *self, PyObject *args)
{
  Qureg x0;
  int x1;
  double x2;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "rotateX", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = (double)_cffi_to_c_double(arg2);
  if (x2 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { rotateX(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_rotateX(Qureg *x0, int x1, double x2)
{
  { rotateX(*x0, x1, x2); }
}
#endif

static void _cffi_d_rotateY(Qureg x0, int x1, double x2)
{
  rotateY(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_rotateY(PyObject *self, PyObject *args)
{
  Qureg x0;
  int x1;
  double x2;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "rotateY", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = (double)_cffi_to_c_double(arg2);
  if (x2 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { rotateY(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_rotateY(Qureg *x0, int x1, double x2)
{
  { rotateY(*x0, x1, x2); }
}
#endif

static void _cffi_d_rotateZ(Qureg x0, int x1, double x2)
{
  rotateZ(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_rotateZ(PyObject *self, PyObject *args)
{
  Qureg x0;
  int x1;
  double x2;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "rotateZ", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = (double)_cffi_to_c_double(arg2);
  if (x2 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { rotateZ(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_rotateZ(Qureg *x0, int x1, double x2)
{
  { rotateZ(*x0, x1, x2); }
}
#endif

static void _cffi_d_sGate(Qureg x0, int x1)
{
  sGate(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sGate(PyObject *self, PyObject *args)
{
  Qureg x0;
  int x1;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "sGate", 2, 2, &arg0, &arg1))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { sGate(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_sGate(Qureg *x0, int x1)
{
  { sGate(*x0, x1); }
}
#endif

static void _cffi_d_seedQuEST(unsigned long * x0, int x1)
{
  seedQuEST(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_seedQuEST(PyObject *self, PyObject *args)
{
  unsigned long * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "seedQuEST", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(369), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned long *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(369), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { seedQuEST(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_seedQuEST _cffi_d_seedQuEST
#endif

static void _cffi_d_seedQuESTDefault(void)
{
  seedQuESTDefault();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_seedQuESTDefault(PyObject *self, PyObject *noarg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { seedQuESTDefault(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_seedQuESTDefault _cffi_d_seedQuESTDefault
#endif

static void _cffi_d_setAmps(Qureg x0, long long x1, double * x2, double * x3, long long x4)
{
  setAmps(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_setAmps(PyObject *self, PyObject *args)
{
  Qureg x0;
  long long x1;
  double * x2;
  double * x3;
  long long x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "setAmps", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  x1 = _cffi_to_c_int(arg1, long long);
  if (x1 == (long long)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(56), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(56), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(56), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(56), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, long long);
  if (x4 == (long long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { setAmps(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_setAmps(Qureg *x0, long long x1, double * x2, double * x3, long long x4)
{
  { setAmps(*x0, x1, x2, x3, x4); }
}
#endif

static void _cffi_d_setDiagonalOpElems(DiagonalOp x0, long long x1, double * x2, double * x3, long long x4)
{
  setDiagonalOpElems(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_setDiagonalOpElems(PyObject *self, PyObject *args)
{
  DiagonalOp x0;
  long long x1;
  double * x2;
  double * x3;
  long long x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "setDiagonalOpElems", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(2), arg0) < 0)
    return NULL;

  x1 = _cffi_to_c_int(arg1, long long);
  if (x1 == (long long)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(56), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(56), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(56), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(56), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, long long);
  if (x4 == (long long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { setDiagonalOpElems(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_setDiagonalOpElems(DiagonalOp *x0, long long x1, double * x2, double * x3, long long x4)
{
  { setDiagonalOpElems(*x0, x1, x2, x3, x4); }
}
#endif

static void _cffi_d_setWeightedQureg(Complex x0, Qureg x1, Complex x2, Qureg x3, Complex x4, Qureg x5)
{
  setWeightedQureg(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_setWeightedQureg(PyObject *self, PyObject *args)
{
  Complex x0;
  Qureg x1;
  Complex x2;
  Qureg x3;
  Complex x4;
  Qureg x5;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "setWeightedQureg", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(101), arg0) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x1, _cffi_type(1), arg1) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x2, _cffi_type(101), arg2) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x3, _cffi_type(1), arg3) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x4, _cffi_type(101), arg4) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x5, _cffi_type(1), arg5) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { setWeightedQureg(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_setWeightedQureg(Complex *x0, Qureg *x1, Complex *x2, Qureg *x3, Complex *x4, Qureg *x5)
{
  { setWeightedQureg(*x0, *x1, *x2, *x3, *x4, *x5); }
}
#endif

static void _cffi_d_sqrtSwapGate(Qureg x0, int x1, int x2)
{
  sqrtSwapGate(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sqrtSwapGate(PyObject *self, PyObject *args)
{
  Qureg x0;
  int x1;
  int x2;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "sqrtSwapGate", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { sqrtSwapGate(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_sqrtSwapGate(Qureg *x0, int x1, int x2)
{
  { sqrtSwapGate(*x0, x1, x2); }
}
#endif

static void _cffi_d_startRecordingQASM(Qureg x0)
{
  startRecordingQASM(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_startRecordingQASM(PyObject *self, PyObject *arg0)
{
  Qureg x0;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { startRecordingQASM(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_startRecordingQASM(Qureg *x0)
{
  { startRecordingQASM(*x0); }
}
#endif

static double _cffi_d_statevec_calcProbOfOutcome(Qureg x0, int x1, int x2)
{
  return statevec_calcProbOfOutcome(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_statevec_calcProbOfOutcome(PyObject *self, PyObject *args)
{
  Qureg x0;
  int x1;
  int x2;
  double result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "statevec_calcProbOfOutcome", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = statevec_calcProbOfOutcome(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_double(result);
  return pyresult;
}
#else
static double _cffi_f_statevec_calcProbOfOutcome(Qureg *x0, int x1, int x2)
{
  double result;
  { result = statevec_calcProbOfOutcome(*x0, x1, x2); }
  return result;
}
#endif

static void _cffi_d_statevec_setAmps(Qureg x0, long long x1, double * x2, double * x3, long long x4)
{
  statevec_setAmps(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_statevec_setAmps(PyObject *self, PyObject *args)
{
  Qureg x0;
  long long x1;
  double * x2;
  double * x3;
  long long x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "statevec_setAmps", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  x1 = _cffi_to_c_int(arg1, long long);
  if (x1 == (long long)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(56), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(56), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(56), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(56), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, long long);
  if (x4 == (long long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { statevec_setAmps(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_statevec_setAmps(Qureg *x0, long long x1, double * x2, double * x3, long long x4)
{
  { statevec_setAmps(*x0, x1, x2, x3, x4); }
}
#endif

static void _cffi_d_stopRecordingQASM(Qureg x0)
{
  stopRecordingQASM(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_stopRecordingQASM(PyObject *self, PyObject *arg0)
{
  Qureg x0;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { stopRecordingQASM(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_stopRecordingQASM(Qureg *x0)
{
  { stopRecordingQASM(*x0); }
}
#endif

static void _cffi_d_swapGate(Qureg x0, int x1, int x2)
{
  swapGate(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_swapGate(PyObject *self, PyObject *args)
{
  Qureg x0;
  int x1;
  int x2;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "swapGate", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { swapGate(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_swapGate(Qureg *x0, int x1, int x2)
{
  { swapGate(*x0, x1, x2); }
}
#endif

static void _cffi_d_syncDiagonalOp(DiagonalOp x0)
{
  syncDiagonalOp(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_syncDiagonalOp(PyObject *self, PyObject *arg0)
{
  DiagonalOp x0;

  if (_cffi_to_c((char *)&x0, _cffi_type(2), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { syncDiagonalOp(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_syncDiagonalOp(DiagonalOp *x0)
{
  { syncDiagonalOp(*x0); }
}
#endif

static void _cffi_d_syncQuESTEnv(QuESTEnv x0)
{
  syncQuESTEnv(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_syncQuESTEnv(PyObject *self, PyObject *arg0)
{
  QuESTEnv x0;

  if (_cffi_to_c((char *)&x0, _cffi_type(22), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { syncQuESTEnv(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_syncQuESTEnv(QuESTEnv *x0)
{
  { syncQuESTEnv(*x0); }
}
#endif

static int _cffi_d_syncQuESTSuccess(int x0)
{
  return syncQuESTSuccess(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_syncQuESTSuccess(PyObject *self, PyObject *arg0)
{
  int x0;
  int result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = syncQuESTSuccess(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_syncQuESTSuccess _cffi_d_syncQuESTSuccess
#endif

static void _cffi_d_tGate(Qureg x0, int x1)
{
  tGate(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_tGate(PyObject *self, PyObject *args)
{
  Qureg x0;
  int x1;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "tGate", 2, 2, &arg0, &arg1))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { tGate(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_tGate(Qureg *x0, int x1)
{
  { tGate(*x0, x1); }
}
#endif

static void _cffi_d_twoQubitUnitary(Qureg x0, int x1, int x2, ComplexMatrix4 x3)
{
  twoQubitUnitary(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_twoQubitUnitary(PyObject *self, PyObject *args)
{
  Qureg x0;
  int x1;
  int x2;
  ComplexMatrix4 x3;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "twoQubitUnitary", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x3, _cffi_type(254), arg3) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { twoQubitUnitary(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_twoQubitUnitary(Qureg *x0, int x1, int x2, ComplexMatrix4 *x3)
{
  { twoQubitUnitary(*x0, x1, x2, *x3); }
}
#endif

static void _cffi_d_unitary(Qureg x0, int x1, ComplexMatrix2 x2)
{
  unitary(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_unitary(PyObject *self, PyObject *args)
{
  Qureg x0;
  int x1;
  ComplexMatrix2 x2;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "unitary", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x2, _cffi_type(207), arg2) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { unitary(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_unitary(Qureg *x0, int x1, ComplexMatrix2 *x2)
{
  { unitary(*x0, x1, *x2); }
}
#endif

static void _cffi_d_writeRecordedQASMToFile(Qureg x0, char * x1)
{
  writeRecordedQASMToFile(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_writeRecordedQASMToFile(PyObject *self, PyObject *args)
{
  Qureg x0;
  char * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "writeRecordedQASMToFile", 2, 2, &arg0, &arg1))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { writeRecordedQASMToFile(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
static void _cffi_f_writeRecordedQASMToFile(Qureg *x0, char * x1)
{
  { writeRecordedQASMToFile(*x0, x1); }
}
#endif

_CFFI_UNUSED_FN
static void _cffi_checkfld__Complex(Complex *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { double *tmp = &p->real; (void)tmp; }
  { double *tmp = &p->imag; (void)tmp; }
}
struct _cffi_align__Complex { char x; Complex y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__ComplexArray(ComplexArray *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { double * *tmp = &p->real; (void)tmp; }
  { double * *tmp = &p->imag; (void)tmp; }
}
struct _cffi_align__ComplexArray { char x; ComplexArray y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__ComplexMatrix2(ComplexMatrix2 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { double(*tmp)[2][2] = &p->real; (void)tmp; }
  { double(*tmp)[2][2] = &p->imag; (void)tmp; }
}
struct _cffi_align__ComplexMatrix2 { char x; ComplexMatrix2 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__ComplexMatrix4(ComplexMatrix4 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { double(*tmp)[4][4] = &p->real; (void)tmp; }
  { double(*tmp)[4][4] = &p->imag; (void)tmp; }
}
struct _cffi_align__ComplexMatrix4 { char x; ComplexMatrix4 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__ComplexMatrixN(ComplexMatrixN *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->numQubits) | 0);  /* check that 'ComplexMatrixN.numQubits' is an integer */
  { double * * *tmp = &p->real; (void)tmp; }
  { double * * *tmp = &p->imag; (void)tmp; }
}
struct _cffi_align__ComplexMatrixN { char x; ComplexMatrixN y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__DiagonalOp(DiagonalOp *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->numQubits) | 0);  /* check that 'DiagonalOp.numQubits' is an integer */
  (void)((p->numElemsPerChunk) | 0);  /* check that 'DiagonalOp.numElemsPerChunk' is an integer */
  (void)((p->numChunks) | 0);  /* check that 'DiagonalOp.numChunks' is an integer */
  (void)((p->chunkId) | 0);  /* check that 'DiagonalOp.chunkId' is an integer */
  { double * *tmp = &p->real; (void)tmp; }
  { double * *tmp = &p->imag; (void)tmp; }
  { ComplexArray *tmp = &p->deviceOperator; (void)tmp; }
}
struct _cffi_align__DiagonalOp { char x; DiagonalOp y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__PauliHamil(PauliHamil *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { enum pauliOpType * *tmp = &p->pauliCodes; (void)tmp; }
  { double * *tmp = &p->termCoeffs; (void)tmp; }
  (void)((p->numSumTerms) | 0);  /* check that 'PauliHamil.numSumTerms' is an integer */
  (void)((p->numQubits) | 0);  /* check that 'PauliHamil.numQubits' is an integer */
}
struct _cffi_align__PauliHamil { char x; PauliHamil y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__QuESTEnv(QuESTEnv *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->rank) | 0);  /* check that 'QuESTEnv.rank' is an integer */
  (void)((p->numRanks) | 0);  /* check that 'QuESTEnv.numRanks' is an integer */
}
struct _cffi_align__QuESTEnv { char x; QuESTEnv y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__Qureg(Qureg *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->isDensityMatrix) | 0);  /* check that 'Qureg.isDensityMatrix' is an integer */
  (void)((p->numQubitsRepresented) | 0);  /* check that 'Qureg.numQubitsRepresented' is an integer */
  (void)((p->numQubitsInStateVec) | 0);  /* check that 'Qureg.numQubitsInStateVec' is an integer */
  (void)((p->numAmpsPerChunk) | 0);  /* check that 'Qureg.numAmpsPerChunk' is an integer */
  (void)((p->numAmpsTotal) | 0);  /* check that 'Qureg.numAmpsTotal' is an integer */
  (void)((p->chunkId) | 0);  /* check that 'Qureg.chunkId' is an integer */
  (void)((p->numChunks) | 0);  /* check that 'Qureg.numChunks' is an integer */
  { ComplexArray *tmp = &p->stateVec; (void)tmp; }
  { ComplexArray *tmp = &p->pairStateVec; (void)tmp; }
  { ComplexArray *tmp = &p->deviceStateVec; (void)tmp; }
  { double * *tmp = &p->firstLevelReduction; (void)tmp; }
  { double * *tmp = &p->secondLevelReduction; (void)tmp; }
  { QASMLogger * *tmp = &p->qasmLog; (void)tmp; }
}
struct _cffi_align__Qureg { char x; Qureg y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__Vector(Vector *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { double *tmp = &p->x; (void)tmp; }
  { double *tmp = &p->y; (void)tmp; }
  { double *tmp = &p->z; (void)tmp; }
}
struct _cffi_align__Vector { char x; Vector y; };

static const struct _cffi_global_s _cffi_globals[] = {
  { "PAULI_I", (void *)_cffi_const_PAULI_I, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PAULI_X", (void *)_cffi_const_PAULI_X, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PAULI_Y", (void *)_cffi_const_PAULI_Y, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PAULI_Z", (void *)_cffi_const_PAULI_Z, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "SIGMA_Z", (void *)_cffi_const_SIGMA_Z, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "S_GATE", (void *)_cffi_const_S_GATE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "T_GATE", (void *)_cffi_const_T_GATE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "applyDiagonalOp", (void *)_cffi_f_applyDiagonalOp, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 144), (void *)_cffi_d_applyDiagonalOp },
  { "applyMatrix2", (void *)_cffi_f_applyMatrix2, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 272), (void *)_cffi_d_applyMatrix2 },
  { "applyMatrix4", (void *)_cffi_f_applyMatrix4, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 327), (void *)_cffi_d_applyMatrix4 },
  { "applyMatrixN", (void *)_cffi_f_applyMatrixN, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 221), (void *)_cffi_d_applyMatrixN },
  { "applyMultiControlledMatrixN", (void *)_cffi_f_applyMultiControlledMatrixN, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 233), (void *)_cffi_d_applyMultiControlledMatrixN },
  { "applyPauliHamil", (void *)_cffi_f_applyPauliHamil, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 148), (void *)_cffi_d_applyPauliHamil },
  { "applyPauliSum", (void *)_cffi_f_applyPauliSum, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 187), (void *)_cffi_d_applyPauliSum },
  { "applyTrotterCircuit", (void *)_cffi_f_applyTrotterCircuit, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 153), (void *)_cffi_d_applyTrotterCircuit },
  { "calcDensityInnerProduct", (void *)_cffi_f_calcDensityInnerProduct, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 49), (void *)_cffi_d_calcDensityInnerProduct },
  { "calcExpecDiagonalOp", (void *)_cffi_f_calcExpecDiagonalOp, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_calcExpecDiagonalOp },
  { "calcExpecPauliHamil", (void *)_cffi_f_calcExpecPauliHamil, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 44), (void *)_cffi_d_calcExpecPauliHamil },
  { "calcExpecPauliProd", (void *)_cffi_f_calcExpecPauliProd, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 60), (void *)_cffi_d_calcExpecPauliProd },
  { "calcExpecPauliSum", (void *)_cffi_f_calcExpecPauliSum, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 53), (void *)_cffi_d_calcExpecPauliSum },
  { "calcFidelity", (void *)_cffi_f_calcFidelity, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 49), (void *)_cffi_d_calcFidelity },
  { "calcHilbertSchmidtDistance", (void *)_cffi_f_calcHilbertSchmidtDistance, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 49), (void *)_cffi_d_calcHilbertSchmidtDistance },
  { "calcInnerProduct", (void *)_cffi_f_calcInnerProduct, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 4), (void *)_cffi_d_calcInnerProduct },
  { "calcProbOfOutcome", (void *)_cffi_f_calcProbOfOutcome, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 67), (void *)_cffi_d_calcProbOfOutcome },
  { "calcPurity", (void *)_cffi_f_calcPurity, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 41), (void *)_cffi_d_calcPurity },
  { "calcTotalProb", (void *)_cffi_f_calcTotalProb, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 41), (void *)_cffi_d_calcTotalProb },
  { "clearRecordedQASM", (void *)_cffi_f_clearRecordedQASM, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 141), (void *)_cffi_d_clearRecordedQASM },
  { "cloneQureg", (void *)_cffi_f_cloneQureg, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 169), (void *)_cffi_d_cloneQureg },
  { "collapseToOutcome", (void *)_cffi_f_collapseToOutcome, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 67), (void *)_cffi_d_collapseToOutcome },
  { "compactUnitary", (void *)_cffi_f_compactUnitary, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 260), (void *)_cffi_d_compactUnitary },
  { "controlledCompactUnitary", (void *)_cffi_f_controlledCompactUnitary, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 307), (void *)_cffi_d_controlledCompactUnitary },
  { "controlledMultiQubitUnitary", (void *)_cffi_f_controlledMultiQubitUnitary, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 295), (void *)_cffi_d_controlledMultiQubitUnitary },
  { "controlledNot", (void *)_cffi_f_controlledNot, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 302), (void *)_cffi_d_controlledNot },
  { "controlledPauliY", (void *)_cffi_f_controlledPauliY, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 302), (void *)_cffi_d_controlledPauliY },
  { "controlledPhaseFlip", (void *)_cffi_f_controlledPhaseFlip, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 302), (void *)_cffi_d_controlledPhaseFlip },
  { "controlledPhaseShift", (void *)_cffi_f_controlledPhaseShift, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 333), (void *)_cffi_d_controlledPhaseShift },
  { "controlledRotateAroundAxis", (void *)_cffi_f_controlledRotateAroundAxis, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 339), (void *)_cffi_d_controlledRotateAroundAxis },
  { "controlledRotateX", (void *)_cffi_f_controlledRotateX, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 333), (void *)_cffi_d_controlledRotateX },
  { "controlledRotateY", (void *)_cffi_f_controlledRotateY, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 333), (void *)_cffi_d_controlledRotateY },
  { "controlledRotateZ", (void *)_cffi_f_controlledRotateZ, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 333), (void *)_cffi_d_controlledRotateZ },
  { "controlledTwoQubitUnitary", (void *)_cffi_f_controlledTwoQubitUnitary, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 346), (void *)_cffi_d_controlledTwoQubitUnitary },
  { "controlledUnitary", (void *)_cffi_f_controlledUnitary, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 314), (void *)_cffi_d_controlledUnitary },
  { "copyStateFromGPU", (void *)_cffi_f_copyStateFromGPU, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 141), (void *)_cffi_d_copyStateFromGPU },
  { "copyStateToGPU", (void *)_cffi_f_copyStateToGPU, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 141), (void *)_cffi_d_copyStateToGPU },
  { "createCloneQureg", (void *)_cffi_f_createCloneQureg, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 33), (void *)_cffi_d_createCloneQureg },
  { "createComplexMatrixN", (void *)_cffi_f_createComplexMatrixN, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 17), (void *)_cffi_d_createComplexMatrixN },
  { "createDensityQureg", (void *)_cffi_f_createDensityQureg, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 37), (void *)_cffi_d_createDensityQureg },
  { "createDiagonalOp", (void *)_cffi_f_createDiagonalOp, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 20), (void *)_cffi_d_createDiagonalOp },
  { "createPauliHamil", (void *)_cffi_f_createPauliHamil, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 27), (void *)_cffi_d_createPauliHamil },
  { "createPauliHamilFromFile", (void *)_cffi_f_createPauliHamilFromFile, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 24), (void *)_cffi_d_createPauliHamilFromFile },
  { "createQuESTEnv", (void *)_cffi_f_createQuESTEnv, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 31), (void *)_cffi_d_createQuESTEnv },
  { "createQureg", (void *)_cffi_f_createQureg, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 37), (void *)_cffi_d_createQureg },
  { "densmatr_calcProbOfOutcome", (void *)_cffi_f_densmatr_calcProbOfOutcome, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 67), (void *)_cffi_d_densmatr_calcProbOfOutcome },
  { "destroyComplexMatrixN", (void *)_cffi_f_destroyComplexMatrixN, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 108), (void *)_cffi_d_destroyComplexMatrixN },
  { "destroyDiagonalOp", (void *)_cffi_f_destroyDiagonalOp, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 114), (void *)_cffi_d_destroyDiagonalOp },
  { "destroyPauliHamil", (void *)_cffi_f_destroyPauliHamil, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 130), (void *)_cffi_d_destroyPauliHamil },
  { "destroyQuESTEnv", (void *)_cffi_f_destroyQuESTEnv, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 138), (void *)_cffi_d_destroyQuESTEnv },
  { "destroyQureg", (void *)_cffi_f_destroyQureg, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 160), (void *)_cffi_d_destroyQureg },
  { "generateMeasurementOutcome", (void *)_cffi_f_generateMeasurementOutcome, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 88), (void *)_cffi_d_generateMeasurementOutcome },
  { "getAmp", (void *)_cffi_f_getAmp, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 8), (void *)_cffi_d_getAmp },
  { "getDensityAmp", (void *)_cffi_f_getDensityAmp, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 12), (void *)_cffi_d_getDensityAmp },
  { "getImagAmp", (void *)_cffi_f_getImagAmp, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 72), (void *)_cffi_d_getImagAmp },
  { "getNumAmps", (void *)_cffi_f_getNumAmps, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 97), (void *)_cffi_d_getNumAmps },
  { "getNumQubits", (void *)_cffi_f_getNumQubits, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 76), (void *)_cffi_d_getNumQubits },
  { "getProbAmp", (void *)_cffi_f_getProbAmp, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 72), (void *)_cffi_d_getProbAmp },
  { "getQuEST_PREC", (void *)_cffi_f_getQuEST_PREC, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 95), (void *)_cffi_d_getQuEST_PREC },
  { "getRealAmp", (void *)_cffi_f_getRealAmp, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 72), (void *)_cffi_d_getRealAmp },
  { "hadamard", (void *)_cffi_f_hadamard, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 256), (void *)_cffi_d_hadamard },
  { "initBlankState", (void *)_cffi_f_initBlankState, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 141), (void *)_cffi_d_initBlankState },
  { "initClassicalState", (void *)_cffi_f_initClassicalState, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 353), (void *)_cffi_d_initClassicalState },
  { "initDebugState", (void *)_cffi_f_initDebugState, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 141), (void *)_cffi_d_initDebugState },
  { "initDiagonalOp", (void *)_cffi_f_initDiagonalOp, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 118), (void *)_cffi_d_initDiagonalOp },
  { "initPauliHamil", (void *)_cffi_f_initPauliHamil, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 133), (void *)_cffi_d_initPauliHamil },
  { "initPlusState", (void *)_cffi_f_initPlusState, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 141), (void *)_cffi_d_initPlusState },
  { "initPureState", (void *)_cffi_f_initPureState, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 169), (void *)_cffi_d_initPureState },
  { "initStateFromAmps", (void *)_cffi_f_initStateFromAmps, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 177), (void *)_cffi_d_initStateFromAmps },
  { "initZeroState", (void *)_cffi_f_initZeroState, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 141), (void *)_cffi_d_initZeroState },
  { "invalidQuESTInputError", (void *)_cffi_f_invalidQuESTInputError, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 364), (void *)_cffi_d_invalidQuESTInputError },
  { "measure", (void *)_cffi_f_measure, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 79), (void *)_cffi_d_measure },
  { "measureWithStats", (void *)_cffi_f_measureWithStats, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 83), (void *)_cffi_d_measureWithStats },
  { "mixDamping", (void *)_cffi_f_mixDamping, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 277), (void *)_cffi_d_mixDamping },
  { "mixDensityMatrix", (void *)_cffi_f_mixDensityMatrix, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 182), (void *)_cffi_d_mixDensityMatrix },
  { "mixDephasing", (void *)_cffi_f_mixDephasing, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 277), (void *)_cffi_d_mixDephasing },
  { "mixDepolarising", (void *)_cffi_f_mixDepolarising, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 277), (void *)_cffi_d_mixDepolarising },
  { "mixKrausMap", (void *)_cffi_f_mixKrausMap, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 266), (void *)_cffi_d_mixKrausMap },
  { "mixMultiQubitKrausMap", (void *)_cffi_f_mixMultiQubitKrausMap, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 214), (void *)_cffi_d_mixMultiQubitKrausMap },
  { "mixPauli", (void *)_cffi_f_mixPauli, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 288), (void *)_cffi_d_mixPauli },
  { "mixTwoQubitDephasing", (void *)_cffi_f_mixTwoQubitDephasing, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 333), (void *)_cffi_d_mixTwoQubitDephasing },
  { "mixTwoQubitDepolarising", (void *)_cffi_f_mixTwoQubitDepolarising, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 333), (void *)_cffi_d_mixTwoQubitDepolarising },
  { "mixTwoQubitKrausMap", (void *)_cffi_f_mixTwoQubitKrausMap, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 320), (void *)_cffi_d_mixTwoQubitKrausMap },
  { "multiControlledMultiQubitUnitary", (void *)_cffi_f_multiControlledMultiQubitUnitary, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 233), (void *)_cffi_d_multiControlledMultiQubitUnitary },
  { "multiControlledPhaseFlip", (void *)_cffi_f_multiControlledPhaseFlip, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 209), (void *)_cffi_d_multiControlledPhaseFlip },
  { "multiControlledPhaseShift", (void *)_cffi_f_multiControlledPhaseShift, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 227), (void *)_cffi_d_multiControlledPhaseShift },
  { "multiControlledTwoQubitUnitary", (void *)_cffi_f_multiControlledTwoQubitUnitary, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 248), (void *)_cffi_d_multiControlledTwoQubitUnitary },
  { "multiControlledUnitary", (void *)_cffi_f_multiControlledUnitary, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 241), (void *)_cffi_d_multiControlledUnitary },
  { "multiQubitUnitary", (void *)_cffi_f_multiQubitUnitary, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 221), (void *)_cffi_d_multiQubitUnitary },
  { "multiRotatePauli", (void *)_cffi_f_multiRotatePauli, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 194), (void *)_cffi_d_multiRotatePauli },
  { "multiRotateZ", (void *)_cffi_f_multiRotateZ, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 227), (void *)_cffi_d_multiRotateZ },
  { "multiStateControlledUnitary", (void *)_cffi_f_multiStateControlledUnitary, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 201), (void *)_cffi_d_multiStateControlledUnitary },
  { "pauliX", (void *)_cffi_f_pauliX, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 256), (void *)_cffi_d_pauliX },
  { "pauliY", (void *)_cffi_f_pauliY, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 256), (void *)_cffi_d_pauliY },
  { "pauliZ", (void *)_cffi_f_pauliZ, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 256), (void *)_cffi_d_pauliZ },
  { "phaseShift", (void *)_cffi_f_phaseShift, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 277), (void *)_cffi_d_phaseShift },
  { "printRecordedQASM", (void *)_cffi_f_printRecordedQASM, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 141), (void *)_cffi_d_printRecordedQASM },
  { "reportPauliHamil", (void *)_cffi_f_reportPauliHamil, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 130), (void *)_cffi_d_reportPauliHamil },
  { "reportQuESTEnv", (void *)_cffi_f_reportQuESTEnv, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 138), (void *)_cffi_d_reportQuESTEnv },
  { "reportQuregParams", (void *)_cffi_f_reportQuregParams, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 141), (void *)_cffi_d_reportQuregParams },
  { "reportState", (void *)_cffi_f_reportState, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 141), (void *)_cffi_d_reportState },
  { "reportStateToScreen", (void *)_cffi_f_reportStateToScreen, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 164), (void *)_cffi_d_reportStateToScreen },
  { "rotateAroundAxis", (void *)_cffi_f_rotateAroundAxis, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 282), (void *)_cffi_d_rotateAroundAxis },
  { "rotateX", (void *)_cffi_f_rotateX, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 277), (void *)_cffi_d_rotateX },
  { "rotateY", (void *)_cffi_f_rotateY, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 277), (void *)_cffi_d_rotateY },
  { "rotateZ", (void *)_cffi_f_rotateZ, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 277), (void *)_cffi_d_rotateZ },
  { "sGate", (void *)_cffi_f_sGate, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 256), (void *)_cffi_d_sGate },
  { "seedQuEST", (void *)_cffi_f_seedQuEST, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 368), (void *)_cffi_d_seedQuEST },
  { "seedQuESTDefault", (void *)_cffi_f_seedQuESTDefault, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 372), (void *)_cffi_d_seedQuESTDefault },
  { "setAmps", (void *)_cffi_f_setAmps, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 357), (void *)_cffi_d_setAmps },
  { "setDiagonalOpElems", (void *)_cffi_f_setDiagonalOpElems, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 123), (void *)_cffi_d_setDiagonalOpElems },
  { "setWeightedQureg", (void *)_cffi_f_setWeightedQureg, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 100), (void *)_cffi_d_setWeightedQureg },
  { "sqrtSwapGate", (void *)_cffi_f_sqrtSwapGate, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 302), (void *)_cffi_d_sqrtSwapGate },
  { "startRecordingQASM", (void *)_cffi_f_startRecordingQASM, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 141), (void *)_cffi_d_startRecordingQASM },
  { "statevec_calcProbOfOutcome", (void *)_cffi_f_statevec_calcProbOfOutcome, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 67), (void *)_cffi_d_statevec_calcProbOfOutcome },
  { "statevec_setAmps", (void *)_cffi_f_statevec_setAmps, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 357), (void *)_cffi_d_statevec_setAmps },
  { "stopRecordingQASM", (void *)_cffi_f_stopRecordingQASM, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 141), (void *)_cffi_d_stopRecordingQASM },
  { "swapGate", (void *)_cffi_f_swapGate, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 302), (void *)_cffi_d_swapGate },
  { "syncDiagonalOp", (void *)_cffi_f_syncDiagonalOp, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 111), (void *)_cffi_d_syncDiagonalOp },
  { "syncQuESTEnv", (void *)_cffi_f_syncQuESTEnv, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 138), (void *)_cffi_d_syncQuESTEnv },
  { "syncQuESTSuccess", (void *)_cffi_f_syncQuESTSuccess, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 92), (void *)_cffi_d_syncQuESTSuccess },
  { "tGate", (void *)_cffi_f_tGate, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 256), (void *)_cffi_d_tGate },
  { "twoQubitUnitary", (void *)_cffi_f_twoQubitUnitary, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 327), (void *)_cffi_d_twoQubitUnitary },
  { "unitary", (void *)_cffi_f_unitary, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 272), (void *)_cffi_d_unitary },
  { "writeRecordedQASMToFile", (void *)_cffi_f_writeRecordedQASMToFile, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 173), (void *)_cffi_d_writeRecordedQASMToFile },
};

static const struct _cffi_field_s _cffi_fields[] = {
  { "buffer", offsetof(QASMLogger, buffer),
              sizeof(((QASMLogger *)0)->buffer),
              _CFFI_OP(_CFFI_OP_NOOP, 25) },
  { "bufferSize", offsetof(QASMLogger, bufferSize),
                  sizeof(((QASMLogger *)0)->bufferSize),
                  _CFFI_OP(_CFFI_OP_NOOP, 18) },
  { "bufferFill", offsetof(QASMLogger, bufferFill),
                  sizeof(((QASMLogger *)0)->bufferFill),
                  _CFFI_OP(_CFFI_OP_NOOP, 18) },
  { "isLogging", offsetof(QASMLogger, isLogging),
                 sizeof(((QASMLogger *)0)->isLogging),
                 _CFFI_OP(_CFFI_OP_NOOP, 18) },
  { "real", offsetof(Complex, real),
            sizeof(((Complex *)0)->real),
            _CFFI_OP(_CFFI_OP_NOOP, 89) },
  { "imag", offsetof(Complex, imag),
            sizeof(((Complex *)0)->imag),
            _CFFI_OP(_CFFI_OP_NOOP, 89) },
  { "real", offsetof(ComplexArray, real),
            sizeof(((ComplexArray *)0)->real),
            _CFFI_OP(_CFFI_OP_NOOP, 56) },
  { "imag", offsetof(ComplexArray, imag),
            sizeof(((ComplexArray *)0)->imag),
            _CFFI_OP(_CFFI_OP_NOOP, 56) },
  { "real", offsetof(ComplexMatrix2, real),
            sizeof(((ComplexMatrix2 *)0)->real),
            _CFFI_OP(_CFFI_OP_NOOP, 381) },
  { "imag", offsetof(ComplexMatrix2, imag),
            sizeof(((ComplexMatrix2 *)0)->imag),
            _CFFI_OP(_CFFI_OP_NOOP, 381) },
  { "real", offsetof(ComplexMatrix4, real),
            sizeof(((ComplexMatrix4 *)0)->real),
            _CFFI_OP(_CFFI_OP_NOOP, 385) },
  { "imag", offsetof(ComplexMatrix4, imag),
            sizeof(((ComplexMatrix4 *)0)->imag),
            _CFFI_OP(_CFFI_OP_NOOP, 385) },
  { "numQubits", offsetof(ComplexMatrixN, numQubits),
                 sizeof(((ComplexMatrixN *)0)->numQubits),
                 _CFFI_OP(_CFFI_OP_NOOP, 18) },
  { "real", offsetof(ComplexMatrixN, real),
            sizeof(((ComplexMatrixN *)0)->real),
            _CFFI_OP(_CFFI_OP_NOOP, 378) },
  { "imag", offsetof(ComplexMatrixN, imag),
            sizeof(((ComplexMatrixN *)0)->imag),
            _CFFI_OP(_CFFI_OP_NOOP, 378) },
  { "numQubits", offsetof(DiagonalOp, numQubits),
                 sizeof(((DiagonalOp *)0)->numQubits),
                 _CFFI_OP(_CFFI_OP_NOOP, 18) },
  { "numElemsPerChunk", offsetof(DiagonalOp, numElemsPerChunk),
                        sizeof(((DiagonalOp *)0)->numElemsPerChunk),
                        _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "numChunks", offsetof(DiagonalOp, numChunks),
                 sizeof(((DiagonalOp *)0)->numChunks),
                 _CFFI_OP(_CFFI_OP_NOOP, 18) },
  { "chunkId", offsetof(DiagonalOp, chunkId),
               sizeof(((DiagonalOp *)0)->chunkId),
               _CFFI_OP(_CFFI_OP_NOOP, 18) },
  { "real", offsetof(DiagonalOp, real),
            sizeof(((DiagonalOp *)0)->real),
            _CFFI_OP(_CFFI_OP_NOOP, 56) },
  { "imag", offsetof(DiagonalOp, imag),
            sizeof(((DiagonalOp *)0)->imag),
            _CFFI_OP(_CFFI_OP_NOOP, 56) },
  { "deviceOperator", offsetof(DiagonalOp, deviceOperator),
                      sizeof(((DiagonalOp *)0)->deviceOperator),
                      _CFFI_OP(_CFFI_OP_NOOP, 374) },
  { "pauliCodes", offsetof(PauliHamil, pauliCodes),
                  sizeof(((PauliHamil *)0)->pauliCodes),
                  _CFFI_OP(_CFFI_OP_NOOP, 55) },
  { "termCoeffs", offsetof(PauliHamil, termCoeffs),
                  sizeof(((PauliHamil *)0)->termCoeffs),
                  _CFFI_OP(_CFFI_OP_NOOP, 56) },
  { "numSumTerms", offsetof(PauliHamil, numSumTerms),
                   sizeof(((PauliHamil *)0)->numSumTerms),
                   _CFFI_OP(_CFFI_OP_NOOP, 18) },
  { "numQubits", offsetof(PauliHamil, numQubits),
                 sizeof(((PauliHamil *)0)->numQubits),
                 _CFFI_OP(_CFFI_OP_NOOP, 18) },
  { "rank", offsetof(QuESTEnv, rank),
            sizeof(((QuESTEnv *)0)->rank),
            _CFFI_OP(_CFFI_OP_NOOP, 18) },
  { "numRanks", offsetof(QuESTEnv, numRanks),
                sizeof(((QuESTEnv *)0)->numRanks),
                _CFFI_OP(_CFFI_OP_NOOP, 18) },
  { "isDensityMatrix", offsetof(Qureg, isDensityMatrix),
                       sizeof(((Qureg *)0)->isDensityMatrix),
                       _CFFI_OP(_CFFI_OP_NOOP, 18) },
  { "numQubitsRepresented", offsetof(Qureg, numQubitsRepresented),
                            sizeof(((Qureg *)0)->numQubitsRepresented),
                            _CFFI_OP(_CFFI_OP_NOOP, 18) },
  { "numQubitsInStateVec", offsetof(Qureg, numQubitsInStateVec),
                           sizeof(((Qureg *)0)->numQubitsInStateVec),
                           _CFFI_OP(_CFFI_OP_NOOP, 18) },
  { "numAmpsPerChunk", offsetof(Qureg, numAmpsPerChunk),
                       sizeof(((Qureg *)0)->numAmpsPerChunk),
                       _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "numAmpsTotal", offsetof(Qureg, numAmpsTotal),
                    sizeof(((Qureg *)0)->numAmpsTotal),
                    _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "chunkId", offsetof(Qureg, chunkId),
               sizeof(((Qureg *)0)->chunkId),
               _CFFI_OP(_CFFI_OP_NOOP, 18) },
  { "numChunks", offsetof(Qureg, numChunks),
                 sizeof(((Qureg *)0)->numChunks),
                 _CFFI_OP(_CFFI_OP_NOOP, 18) },
  { "stateVec", offsetof(Qureg, stateVec),
                sizeof(((Qureg *)0)->stateVec),
                _CFFI_OP(_CFFI_OP_NOOP, 374) },
  { "pairStateVec", offsetof(Qureg, pairStateVec),
                    sizeof(((Qureg *)0)->pairStateVec),
                    _CFFI_OP(_CFFI_OP_NOOP, 374) },
  { "deviceStateVec", offsetof(Qureg, deviceStateVec),
                      sizeof(((Qureg *)0)->deviceStateVec),
                      _CFFI_OP(_CFFI_OP_NOOP, 374) },
  { "firstLevelReduction", offsetof(Qureg, firstLevelReduction),
                           sizeof(((Qureg *)0)->firstLevelReduction),
                           _CFFI_OP(_CFFI_OP_NOOP, 56) },
  { "secondLevelReduction", offsetof(Qureg, secondLevelReduction),
                            sizeof(((Qureg *)0)->secondLevelReduction),
                            _CFFI_OP(_CFFI_OP_NOOP, 56) },
  { "qasmLog", offsetof(Qureg, qasmLog),
               sizeof(((Qureg *)0)->qasmLog),
               _CFFI_OP(_CFFI_OP_NOOP, 375) },
  { "x", offsetof(Vector, x),
         sizeof(((Vector *)0)->x),
         _CFFI_OP(_CFFI_OP_NOOP, 89) },
  { "y", offsetof(Vector, y),
         sizeof(((Vector *)0)->y),
         _CFFI_OP(_CFFI_OP_NOOP, 89) },
  { "z", offsetof(Vector, z),
         sizeof(((Vector *)0)->z),
         _CFFI_OP(_CFFI_OP_NOOP, 89) },
};

static const struct _cffi_struct_union_s _cffi_struct_unions[] = {
  { "$QASMLogger", 376, _CFFI_F_CHECK_FIELDS,
    sizeof(QASMLogger), offsetof(struct _cffi_align_typedef_QASMLogger, y), 0, 4 },
  { "Complex", 101, _CFFI_F_CHECK_FIELDS,
    sizeof(Complex), offsetof(struct _cffi_align__Complex, y), 4, 2 },
  { "ComplexArray", 374, _CFFI_F_CHECK_FIELDS,
    sizeof(ComplexArray), offsetof(struct _cffi_align__ComplexArray, y), 6, 2 },
  { "ComplexMatrix2", 207, _CFFI_F_CHECK_FIELDS,
    sizeof(ComplexMatrix2), offsetof(struct _cffi_align__ComplexMatrix2, y), 8, 2 },
  { "ComplexMatrix4", 254, _CFFI_F_CHECK_FIELDS,
    sizeof(ComplexMatrix4), offsetof(struct _cffi_align__ComplexMatrix4, y), 10, 2 },
  { "ComplexMatrixN", 109, _CFFI_F_CHECK_FIELDS,
    sizeof(ComplexMatrixN), offsetof(struct _cffi_align__ComplexMatrixN, y), 12, 3 },
  { "DiagonalOp", 2, _CFFI_F_CHECK_FIELDS,
    sizeof(DiagonalOp), offsetof(struct _cffi_align__DiagonalOp, y), 15, 7 },
  { "PauliHamil", 46, _CFFI_F_CHECK_FIELDS,
    sizeof(PauliHamil), offsetof(struct _cffi_align__PauliHamil, y), 22, 4 },
  { "QuESTEnv", 22, _CFFI_F_CHECK_FIELDS,
    sizeof(QuESTEnv), offsetof(struct _cffi_align__QuESTEnv, y), 26, 2 },
  { "Qureg", 1, _CFFI_F_CHECK_FIELDS,
    sizeof(Qureg), offsetof(struct _cffi_align__Qureg, y), 28, 13 },
  { "Vector", 286, _CFFI_F_CHECK_FIELDS,
    sizeof(Vector), offsetof(struct _cffi_align__Vector, y), 41, 3 },
};

static const struct _cffi_enum_s _cffi_enums[] = {
  { "pauliOpType", 387, _cffi_prim_int(sizeof(enum pauliOpType), ((enum pauliOpType)-1) <= 0),
    "PAULI_I,PAULI_X,PAULI_Y,PAULI_Z" },
  { "phaseGateType", 388, _cffi_prim_int(sizeof(enum phaseGateType), ((enum phaseGateType)-1) <= 0),
    "SIGMA_Z,S_GATE,T_GATE" },
};

static const struct _cffi_typename_s _cffi_typenames[] = {
  { "Complex", 101 },
  { "ComplexArray", 374 },
  { "ComplexMatrix2", 207 },
  { "ComplexMatrix4", 254 },
  { "ComplexMatrixN", 109 },
  { "DiagonalOp", 2 },
  { "PauliHamil", 46 },
  { "QASMLogger", 376 },
  { "QuESTEnv", 22 },
  { "Qureg", 1 },
  { "Vector", 286 },
};

static const struct _cffi_type_context_s _cffi_type_context = {
  _cffi_types,
  _cffi_globals,
  _cffi_fields,
  _cffi_struct_unions,
  _cffi_enums,
  _cffi_typenames,
  132,  /* num_globals */
  11,  /* num_struct_unions */
  2,  /* num_enums */
  11,  /* num_typenames */
  NULL,  /* no includes */
  391,  /* num_types */
  0,  /* flags */
};

#ifdef __GNUC__
#  pragma GCC visibility push(default)  /* for -fvisibility= */
#endif

#ifdef PYPY_VERSION
PyMODINIT_FUNC
_cffi_pypyinit__quest(const void *p[])
{
    p[0] = (const void *)0x2601;
    p[1] = &_cffi_type_context;
#if PY_MAJOR_VERSION >= 3
    return NULL;
#endif
}
#  ifdef _MSC_VER
     PyMODINIT_FUNC
#  if PY_MAJOR_VERSION >= 3
     PyInit__quest(void) { return NULL; }
#  else
     init_quest(void) { }
#  endif
#  endif
#elif PY_MAJOR_VERSION >= 3
PyMODINIT_FUNC
PyInit__quest(void)
{
  return _cffi_init("_quest", 0x2601, &_cffi_type_context);
}
#else
PyMODINIT_FUNC
init_quest(void)
{
  _cffi_init("_quest", 0x2601, &_cffi_type_context);
}
#endif

#ifdef __GNUC__
#  pragma GCC visibility pop
#endif
