# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class SegmentAssignment(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        SegmentAssignment - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'state': 'str',
            'date_assigned': 'datetime',
            'date_unassigned': 'datetime',
            'date_modified': 'datetime',
            'segment': 'SegmentAssignmentSegment',
            'customer_id': 'str',
            'customer_id_type': 'str',
            'session': 'SegmentAssignmentSession',
            'external_contact': 'AddressableEntityRef'
        }

        self.attribute_map = {
            'id': 'id',
            'state': 'state',
            'date_assigned': 'dateAssigned',
            'date_unassigned': 'dateUnassigned',
            'date_modified': 'dateModified',
            'segment': 'segment',
            'customer_id': 'customerId',
            'customer_id_type': 'customerIdType',
            'session': 'session',
            'external_contact': 'externalContact'
        }

        self._id = None
        self._state = None
        self._date_assigned = None
        self._date_unassigned = None
        self._date_modified = None
        self._segment = None
        self._customer_id = None
        self._customer_id_type = None
        self._session = None
        self._external_contact = None

    @property
    def id(self):
        """
        Gets the id of this SegmentAssignment.
        Unique identifier for the segment assignment.

        :return: The id of this SegmentAssignment.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this SegmentAssignment.
        Unique identifier for the segment assignment.

        :param id: The id of this SegmentAssignment.
        :type: str
        """
        
        self._id = id

    @property
    def state(self):
        """
        Gets the state of this SegmentAssignment.
        State of the segment assignment.

        :return: The state of this SegmentAssignment.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """
        Sets the state of this SegmentAssignment.
        State of the segment assignment.

        :param state: The state of this SegmentAssignment.
        :type: str
        """
        allowed_values = ["Assigned", "Unassigned"]
        if state.lower() not in map(str.lower, allowed_values):
            # print "Invalid value for state -> " + state
            self._state = "outdated_sdk_version"
        else:
            self._state = state

    @property
    def date_assigned(self):
        """
        Gets the date_assigned of this SegmentAssignment.
        Date when the segment was assigned. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_assigned of this SegmentAssignment.
        :rtype: datetime
        """
        return self._date_assigned

    @date_assigned.setter
    def date_assigned(self, date_assigned):
        """
        Sets the date_assigned of this SegmentAssignment.
        Date when the segment was assigned. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_assigned: The date_assigned of this SegmentAssignment.
        :type: datetime
        """
        
        self._date_assigned = date_assigned

    @property
    def date_unassigned(self):
        """
        Gets the date_unassigned of this SegmentAssignment.
        Date when the segment was unassigned. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_unassigned of this SegmentAssignment.
        :rtype: datetime
        """
        return self._date_unassigned

    @date_unassigned.setter
    def date_unassigned(self, date_unassigned):
        """
        Sets the date_unassigned of this SegmentAssignment.
        Date when the segment was unassigned. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_unassigned: The date_unassigned of this SegmentAssignment.
        :type: datetime
        """
        
        self._date_unassigned = date_unassigned

    @property
    def date_modified(self):
        """
        Gets the date_modified of this SegmentAssignment.
        Date when the segment assignment was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_modified of this SegmentAssignment.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified):
        """
        Sets the date_modified of this SegmentAssignment.
        Date when the segment assignment was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_modified: The date_modified of this SegmentAssignment.
        :type: datetime
        """
        
        self._date_modified = date_modified

    @property
    def segment(self):
        """
        Gets the segment of this SegmentAssignment.
        The segment the assignment is for.

        :return: The segment of this SegmentAssignment.
        :rtype: SegmentAssignmentSegment
        """
        return self._segment

    @segment.setter
    def segment(self, segment):
        """
        Sets the segment of this SegmentAssignment.
        The segment the assignment is for.

        :param segment: The segment of this SegmentAssignment.
        :type: SegmentAssignmentSegment
        """
        
        self._segment = segment

    @property
    def customer_id(self):
        """
        Gets the customer_id of this SegmentAssignment.
        ID of the customer to which the segment is assigned.

        :return: The customer_id of this SegmentAssignment.
        :rtype: str
        """
        return self._customer_id

    @customer_id.setter
    def customer_id(self, customer_id):
        """
        Sets the customer_id of this SegmentAssignment.
        ID of the customer to which the segment is assigned.

        :param customer_id: The customer_id of this SegmentAssignment.
        :type: str
        """
        
        self._customer_id = customer_id

    @property
    def customer_id_type(self):
        """
        Gets the customer_id_type of this SegmentAssignment.
        Type of customer ID (e.g. cookie, email, phone).

        :return: The customer_id_type of this SegmentAssignment.
        :rtype: str
        """
        return self._customer_id_type

    @customer_id_type.setter
    def customer_id_type(self, customer_id_type):
        """
        Sets the customer_id_type of this SegmentAssignment.
        Type of customer ID (e.g. cookie, email, phone).

        :param customer_id_type: The customer_id_type of this SegmentAssignment.
        :type: str
        """
        
        self._customer_id_type = customer_id_type

    @property
    def session(self):
        """
        Gets the session of this SegmentAssignment.
        For session-scoped segments, the session for which the segment was assigned.

        :return: The session of this SegmentAssignment.
        :rtype: SegmentAssignmentSession
        """
        return self._session

    @session.setter
    def session(self, session):
        """
        Sets the session of this SegmentAssignment.
        For session-scoped segments, the session for which the segment was assigned.

        :param session: The session of this SegmentAssignment.
        :type: SegmentAssignmentSession
        """
        
        self._session = session

    @property
    def external_contact(self):
        """
        Gets the external_contact of this SegmentAssignment.
        External contact of the customer to which the segment is assigned.

        :return: The external_contact of this SegmentAssignment.
        :rtype: AddressableEntityRef
        """
        return self._external_contact

    @external_contact.setter
    def external_contact(self, external_contact):
        """
        Sets the external_contact of this SegmentAssignment.
        External contact of the customer to which the segment is assigned.

        :param external_contact: The external_contact of this SegmentAssignment.
        :type: AddressableEntityRef
        """
        
        self._external_contact = external_contact

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

