# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class MediaTranscription(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        MediaTranscription - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'display_name': 'str',
            'transcription_provider': 'str',
            'integration_id': 'str'
        }

        self.attribute_map = {
            'display_name': 'displayName',
            'transcription_provider': 'transcriptionProvider',
            'integration_id': 'integrationId'
        }

        self._display_name = None
        self._transcription_provider = None
        self._integration_id = None

    @property
    def display_name(self):
        """
        Gets the display_name of this MediaTranscription.


        :return: The display_name of this MediaTranscription.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this MediaTranscription.


        :param display_name: The display_name of this MediaTranscription.
        :type: str
        """
        
        self._display_name = display_name

    @property
    def transcription_provider(self):
        """
        Gets the transcription_provider of this MediaTranscription.


        :return: The transcription_provider of this MediaTranscription.
        :rtype: str
        """
        return self._transcription_provider

    @transcription_provider.setter
    def transcription_provider(self, transcription_provider):
        """
        Sets the transcription_provider of this MediaTranscription.


        :param transcription_provider: The transcription_provider of this MediaTranscription.
        :type: str
        """
        allowed_values = ["VOCI", "CALLJOURNEY"]
        if transcription_provider.lower() not in map(str.lower, allowed_values):
            # print "Invalid value for transcription_provider -> " + transcription_provider
            self._transcription_provider = "outdated_sdk_version"
        else:
            self._transcription_provider = transcription_provider

    @property
    def integration_id(self):
        """
        Gets the integration_id of this MediaTranscription.


        :return: The integration_id of this MediaTranscription.
        :rtype: str
        """
        return self._integration_id

    @integration_id.setter
    def integration_id(self, integration_id):
        """
        Sets the integration_id of this MediaTranscription.


        :param integration_id: The integration_id of this MediaTranscription.
        :type: str
        """
        
        self._integration_id = integration_id

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

