# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['gnmi',
 'gnmi.proto',
 'gnmi.proto._internal',
 'gnmi.proto._internal.gnmi',
 'gnmi.proto._internal.gnmi_ext',
 'gnmi.proto._internal.target',
 'gnmi.proto._legacy.collector',
 'gnmi.proto._legacy.gnmi',
 'gnmi.proto._legacy.gnmi_ext',
 'gnmi.proto._legacy.target']

package_data = \
{'': ['*'], 'gnmi.proto': ['_legacy/*']}

install_requires = \
['betterproto>=2.0.0b1,<3.0.0', 'grpcio>=1.30,<2.0', 'protobuf>=3.12,<4.0']

setup_kwargs = {
    'name': 'gnmi-proto',
    'version': '0.1.0a2',
    'description': 'A python package containing gnmi proto specification and generated python code.',
    'long_description': '# gNMI Protobuf\n[![PyPI version](https://badge.fury.io/py/gnmi-proto.svg)](https://badge.fury.io/py/gnmi-proto)\n[![Python Versions](https://img.shields.io/pypi/pyversions/gnmi-proto)](https://pypi.org/project/gnmi-proto/)\n[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)\n[![](https://github.com/python-gnxi/python-gnmi-proto/workflows/Test%20Suite/badge.svg)](https://github.com/python-gnxi/python-gnmi-proto/actions?query=workflow%3A%22Test+Suite%22)\n\n\nThis project aims to be a base building block for [gNMI](https://github.com/openconfig/gnmi) projects written in Python.\n\nThe process of building pythonic libraries and applications using [gRPC](https://grpc.io/) and [Protocol Buffers](https://developers.google.com/protocol-buffers)\nhave been fragmented. This often means that a developer needs to copy over `proto` files, generate Python source from\nthese using `protoc` and use them in-tree for their project. There already exists several projects built in this fashion.\nWhile functional, these can be hard to reuse or maintain, often times resulting stale code and no versioning.\n\n`gnmi-proto` builds on top of the improvement already done by [betterproto](https://pypi.org/project/betterproto/) and\nin turn by the [grpclib](https://pypi.org/project/grpclib/) library. Here, we make available, as versioned packages,\ncode generated from [gNMI protocol buffers](https://github.com/openconfig/gnmi/tree/master/proto).\n\nThe default implementation makes use of the [betterproto](https://pypi.org/project/betterproto/) `protoc` plugin to\ngenerate clean modern code. In addition, this also provides a `gnmi.proto.legacy` module exposing code generated by\n`protoc` using the the in-built Python generator.\n\n## Example Usage\n### Client\nThe following code expects a server at `127.0.0.1:9339` with the [test configuration](https://github.com/python-gnxi/python-gnmi-proto/blob/master/tests/integration/fixtures/config.json). Refer to [gNMI Target Server](https://github.com/python-gnxi/python-gnmi-proto/blob/master/CONTRIBUTING.md#gnmi-target-server) section in [CONTRIBUTING.md](https://github.com/python-gnxi/python-gnmi-proto/blob/master/CONTRIBUTING.md) for information on how to set it up.\n\n#### Using betterproto and grpclib\n```py\nimport gnmi.proto\nimport grpclib.client\n\n\nasync def main():\n    channel = grpclib.client.Channel(host="127.0.0.1", port=9339, ssl=None)\n    service = gnmi.proto.gNMIStub(\n        channel, metadata={"username": "admin", "password": "secret"}\n    )\n\n    response = await service.capabilities()\n    print(response.to_json(indent=2))\n\n    response = await service.get(\n        path=[gnmi.proto.Path(elem=[gnmi.proto.PathElem(name="interfaces")])],\n    )\n    print(response.to_json(indent=2))\n\n\nif __name__ == "__main__":\n    import asyncio\n    asyncio.run(main())\n\n```\n\n#### Using vanilla grpc\n```py\nimport gnmi.proto.legacy\nimport grpc\n\n\ndef main():\n    channel = grpc.insecure_channel("127.0.0.1:9339")\n    metadata = [("username", "admin"), ("password", "secret")]\n    service = gnmi.proto.legacy.gNMIStub(channel)\n\n    response = service.Capabilities(gnmi.proto.legacy.CapabilityRequest())\n    print(response)\n\n    response = service.Get(\n        gnmi.proto.legacy.GetRequest(\n            path=[\n                gnmi.proto.legacy.Path(\n                    elem=[gnmi.proto.legacy.PathElem(name="interfaces")]\n                )\n            ],\n        ),\n        metadata=metadata,\n    )\n    print(response)\n\n\nif __name__ == "__main__":\n    main()\n\n```\n',
    'author': 'Arun Babu Neelicattu',
    'author_email': 'arun.neelicattu@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/python-gnxi',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
