# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['dwload_server',
 'dwload_server.hooks',
 'dwload_server.pyscripts',
 'dwload_server.utils']

package_data = \
{'': ['*']}

install_requires = \
['dragonlib', 'pyserial']

entry_points = \
{'console_scripts': ['DragonPy = '
                     'dragodwload_servernpy.core.gui_starter:gui_mainloop',
                     'devshell = dwload_server.dev_shell:devshell_cmdloop']}

setup_kwargs = {
    'name': 'dwload-server',
    'version': '0.5.0',
    'description': 'DWLOAD server implemented in Python',
    'long_description': '# DWLOAD Server\n\nDWLOAD server implemented in Python (OpenSource, GPL v3 or above).\n\nConnect your Dragon 32 into your PC and LOAD/SAVE basic listings.\n\n![Dragon32DriveWire1small.jpeg](https://raw.githubusercontent.com/jedie/jedie.github.io/master/screenshots/DwLoadServer/Dragon32DriveWire1small.jpeg "Dragon32DriveWire1small.jpeg")\n\n\n## Quickstart\n\n```bash\n~$ git clone https://github.com/6809/DwLoadServer.git\n~$ cd DwLoadServer\n~/DwLoadServer$ ./devshell.py run serial\n```\n\n\n## features\n\n* load/save files via DWLOAD\n* on-the-fly converting ASCII BASIC listing (see below)\n* dynamic "AUTOLOAD.DWL" (see below)\n* backup all files on save\n* Support [USB Adapter](http://archive.worldofdragon.org/index.php?title=Dragon_32/64_Drivewire_Adapter) and [Becker TCP/IP Interface](http://www.6809.org.uk/xroar/doc/xroar.shtml#Becker-port).\n\n### current state\n\nTested DWEEBS:\n\n| DWEEB      | example                     | Description                                  |\n| ---------- | --------------------------- | -------------------------------------------- |\n| **DLOAD**  | `DLOAD`                     | Load `AUTOLOAD.DWL` (Used on Dragon startup) |\n| **SAVE**   | `DLOAD"SAVE""MYFILE.BAS"`   | Save BASIC listing                           |\n| **RESAVE** | `DLOAD"RESAVE""MYFILE.BAS"` | Save BASIC listing                           |\n\nImplemented DriveWire Transactions:\n\n| hex | dez | DW name           | Description                                                              |\n|-----| --- | ----------------- | ------------------------------------------------------------------------ |\n| $00 | 0   | OP_NOP            | NOP Transaction -> ignored                                               |\n| $01 | 1   | OP_NAMEOBJ_MOUNT  | Mount a file to a virtual drive number                                   |\n| $02 | 2   | OP_NAMEOBJ_CREATE | (Does in this implementation the same as OP_NAMEOBJ_MOUNT)               |\n| $d2 | 210 | OP_READEX         | Send 256 bytes sector from the DWLOAD server to the client               |\n| $57 | 87  | OP_WRITE          | Write 256 bytes sector of data from the client into a file on the server |\n\n### TODO\n\n* enhance `AUTOLOAD.DWL.py`, see: [http://archive.worldofdragon.org/phpBB3/viewtopic.php?f=5&t=4977](http://archive.worldofdragon.org/phpBB3/viewtopic.php?f=5&t=4977)\n* compare checksum\n* write unittests\n\n### pyscripts\n\nThere is a general machanism to generate DLOAD responses via Python:\n\n* Store in server root a python script, e.g.: "FOO.BAR.py"\n* DLOAD the file (without .py extension) on client, e.g.: `DLOAD"FOO.BAR"`\n\nThe script will be called via subprocess and it must write the Dragon DOS binary data back to stdout.\n\nCurrently, there is only one _pyscript_ file: `AUTOLOAD.DWL.py` (see below)\n\n#### dynamic "AUTOLOAD.DWL"\n\nThere exist a way to generate a dynamic DWLOAD menu.\nJust copy the file [/dwload-demo-files/AUTOLOAD.DWL.py](https://github.com/6809/DwLoadServer/blob/master/dwload-demo-files/AUTOLOAD.DWL.py) into your server root.\n\nThe _pyscript_ reads the server root directory and list all files into the DLOAD menu.\ne.g. the server root looks like this:\n```\n/HOME/FOO/DWLOAD-FILES\n  +--- AUTOLOAD.DWL.py\n  +--- HEXVIEW.BAS\n  +--- TEST.BAS\n  \\--- SAVE\n```\n\nThe generated listing looks like this:\n```\n10 CLS\n20 PRINT" *** DYNAMIC MENU ***  14:11:18"\n30 PRINT"/HOME/FOO/DWLOAD-FILES"\n40 PRINT" 0 - HEXVIEW.BAS"\n50 PRINT" 1 - TEST.BAS"\n60 PRINT" 2 - SAVE"\n70 PRINT"PLEASE SELECT (X FOR RELOAD) !"\n80 A$=INKEY$:IF A$="" GOTO 80\n90 IF A$="X" THEN DLOAD\n100 IF A$="0" THEN DLOAD"HEXVIEW.BAS"\n110 IF A$="1" THEN DLOAD"TEST.BAS"\n120 IF A$="2" THEN DLOAD"SAVE"\n130 GOTO 10\n```\n\ns.: [http://archive.worldofdragon.org/phpBB3/viewtopic.php?f=5&t=4977](http://archive.worldofdragon.org/phpBB3/viewtopic.php?f=5&t=4977)\n\nYou must only call **DLOAD** on you Dragon to get this menu. Because a **DLOAD** will request **AUTOLOAD.DWL** and the Python server will all **.py** and call **AUTOLOAD.DWL.py** if exist.\n\nThis feature make the following file:\n\n| [/dwload_server/hooks/dynamic_dwl.py](https://github.com/6809/DwLoadServer/blob/master/dwload_server/hooks/dynamic_dwl.py)           | general API to \'pyscript\' files |\n| [/dwload_server/pyscripts/autoload_dwl.py](https://github.com/6809/DwLoadServer/blob/master/dwload_server/pyscripts/autoload_dwl.py) | generates the DWLOAD menu       |\n\n### on-the-fly converting ASCII BASIC listing\n\nThe server read/save ASCII BASIC listing and send/store them to the DWLOAD client on-the-fly.\nSo you can edit listings on your PC and try them on your Dragon without any external conventions!\n\ne.g.: save\n```\n10 PRINT"HELLO WORLD!"\nDLOAD"SAVE""HELLO.BAS"\nDWLOAD\n!\nOK\n```\n\nThe server will create two files:\n\n| filename  | format               | description                                                      |\n| --------- | -------------------- | ---------------------------------------------------------------- |\n| HELLO.DWL | raw tokenized binary | Dragon DOS Binary Format data from the Dragon (256 Bytes padded) |\n| HELLO.BAS | ASCII listing        | on-the-fly converted ASCII BASIC listing                         |\n\ne.g. load (and execute):\n```\nDLOAD"HELLO.BAS"\n!HELLO WORLD!\nOK\n```\n\n(Note: the first `!` is from DWLOAD ROM routine)\n\nThe server will read the `HELLO.BAS` ASCII listing and convert is on-the-fly to the needed Dragon DOS Binary Format\nand send this back to the Dragon.\n\nThis feature make the following files:\n\n| [/dwload_server/hooks/read_ascii.py](https://github.com/6809/DwLoadServer/blob/master/dwload_server/hooks/read_ascii.py) | read ASCII listing and send as binary to client |\n| [/dwload_server/hooks/save_ascii.py](https://github.com/6809/DwLoadServer/blob/master/dwload_server/hooks/save_ascii.py) | save binary from client as ASCII on server      |\n\n## installation\n\nClone sources and bootstrap via [dev-shell](https://github.com/jedie/dev-shell), e.g.:\n\n```bash\n~$ git clone https://github.com/6809/DwLoadServer.git\n~$ cd DwLoadServer\n~/DwLoadServer$ ./devshell.py\n\n...\n\nDeveloper shell - DWLOAD Server - v0.4.0\n\n\nDocumented commands (use \'help -v\' for verbose/\'help <topic>\' for details):\n\ndev-shell commands\n==================\nfix_code_style      poetry   pytest     tox\nlist_venv_packages  publish  pyupgrade  update\n\nDWLOAD Server Commands\n======================\nrun\n\nUncategorized\n=============\nalias  help  history  macro  quit  set  shortcuts\n\n\n(dwload_server) run --help\nUsage: run [-h] [--root-dir ROOT_DIR] [--log-level {0, 10, 20, 30, 30, 40, 50, 50, 99, 100}] {becker, serial} ...\n\noptional arguments:\n  -h, --help            show this help message and exit\n  --root-dir ROOT_DIR\n  --log-level {0, 10, 20, 30, 30, 40, 50, 50, 99, 100}\n                        Logging level: 10=DEBUG, 20=INFO, 30=WARNING, 40=ERROR, 50=CRITICAL/FATAL (default: 20)\n\nInterface:\n  {becker, serial}\n    becker              Use the Becker interface\n    serial              Use the serial interface\n\n(dwload_server) run serial\n```\n\nYou can also run as cli, e.g.: Start serial DWLOAD server:\n```bash\n~/DwLoadServer$ ./devshell.py run serial\n```\n\n\n## History\n\n* [**dev**](https://github.com/6809/DwLoadServer/compare/v0.5.0...main)\n  * ...tbc...\n* [11.09.2022 - v0.5.0](https://github.com/6809/DwLoadServer/compare/v0.4.0...v0.5.0)\n  * Modernize project\n  * Easier bootstrap via dev-shell\n* [20.11.2014 - v0.4.0](https://github.com/6809/DwLoadServer/compare/v0.3.0...v0.4.0)\n  * dynamic `AUTOLOAD.DWL` via Python script\n* [19.11.2014 - v0.3.0](https://github.com/6809/DwLoadServer/compare/v0.2.0...v0.3.0)\n  * Convert "ASCII BASIC listing" <-> "Dragon DOS Binary" on-the-fly while read/write\n* [17.11.2014 - v0.2.0](https://github.com/6809/DwLoadServer/compare/v0.1.1...v0.2.0)\n  * Support Becker and Serial interface.\n* 14.11.2014 - v0.1.0 - Create bootstrap file that work under linux and windows.\n* 12.11.2014 - v0.0.1 - send a file works rudimentary\n* 30.09.2014 - Idea was born: [Forum post 11893](http://archive.worldofdragon.org/phpBB3/viewtopic.php?f=8&t=4946#p11893)\n\n## Links\n\n|                   |                                                                                                                                                                                   |\n|-------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|\n| Forum Thread (en) | [worldofdragon.org](https://archive.worldofdragon.org/phpBB3/viewtopic.php?f=8&t=4946)                                                                                            |\n| Forum Thread (de) | [forum.classic-computing.de](https://forum.classic-computing.de/forum/index.php?thread/20839-dwload-drivewire-for-everybody-daten%C3%BCbertragung-pc-dragon-32-64/&postID=245227) |\n| PyPi              | [https://pypi.python.org/pypi/dwload_server/](https://pypi.python.org/pypi/dwload_server/)                                                                                        |\n| Github            | [https://github.com/6809/DwLoadServer](https://github.com/6809/DwLoadServer)                                                                                                      |\n\nsome project related links:\n\n* About DWLOAD: [http://archive.worldofdragon.org/phpBB3/viewtopic.php?f=5&t=4964](http://archive.worldofdragon.org/phpBB3/viewtopic.php?f=5&t=4964)\n* DWEEBS application Thread: [http://archive.worldofdragon.org/phpBB3/viewtopic.php?f=5&t=4968](http://archive.worldofdragon.org/phpBB3/viewtopic.php?f=5&t=4968)\n* Dragon 32/64 DriveWire Adapter: [http://archive.worldofdragon.org/index.php?title=Dragon_32/64_Drivewire_Adapter](http://archive.worldofdragon.org/index.php?title=Dragon_32/64_Drivewire_Adapter)\n* Drivewire for dummies: [http://archive.worldofdragon.org/index.php?title=Drivewire_for_dummies](http://archive.worldofdragon.org/index.php?title=Drivewire_for_dummies)\n* [http://sourceforge.net/p/drivewireserver/wiki/DriveWire_Specification/](http://sourceforge.net/p/drivewireserver/wiki/DriveWire_Specification/)\n* [http://sourceforge.net/p/drivewireserver/wiki/](http://sourceforge.net/p/drivewireserver/wiki/)\n',
    'author': 'JensDiemer',
    'author_email': 'dwload_server@jensdiemer.de',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/6809/DwLoadServer',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
