"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z, _0;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TypedTrafficPermission = exports.TypedKumaExternalService = exports.Kuma = exports.toJson_ZoneInsightProps = exports.ZoneInsight = exports.toJson_ZoneIngressInsightProps = exports.ZoneIngressInsight = exports.toJson_ZoneIngressProps = exports.ZoneIngress = exports.toJson_ZoneProps = exports.Zone = exports.toJson_VirtualOutboundProps = exports.VirtualOutbound = exports.toJson_TrafficTraceProps = exports.TrafficTrace = exports.toJson_TrafficRouteProps = exports.TrafficRoute = exports.toJson_TrafficPermissionProps = exports.TrafficPermission = exports.toJson_TrafficLogProps = exports.TrafficLog = exports.toJson_TimeoutProps = exports.Timeout = exports.toJson_ServiceInsightProps = exports.ServiceInsight = exports.toJson_RetryProps = exports.Retry = exports.toJson_RateLimitProps = exports.RateLimit = exports.toJson_ProxyTemplateProps = exports.ProxyTemplate = exports.toJson_MeshInsightProps = exports.MeshInsight = exports.toJson_MeshProps = exports.Mesh = exports.toJson_HealthCheckProps = exports.HealthCheck = exports.toJson_FaultInjectionProps = exports.FaultInjection = exports.toJson_ExternalServiceProps = exports.ExternalService = exports.toJson_DataplaneInsightProps = exports.DataplaneInsight = exports.toJson_DataplaneProps = exports.Dataplane = exports.toJson_CircuitBreakerProps = exports.CircuitBreaker = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// generated by cdk8s
const cdk8s_1 = require("cdk8s");
const constructs_1 = require("constructs");
/**
 * CircuitBreaker is the Schema for the circuitbreaker API.
 *
 * @stability stable
 * @schema CircuitBreaker
 */
class CircuitBreaker extends cdk8s_1.ApiObject {
    /**
     * Defines a "CircuitBreaker" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        super(scope, id, CircuitBreaker.manifest(props));
    }
    /**
     * Renders a Kubernetes manifest for "CircuitBreaker".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @stability stable
     */
    static manifest(props = {}) {
        return {
            ...CircuitBreaker.GVK,
            ...toJson_CircuitBreakerProps(props),
        };
    }
}
exports.CircuitBreaker = CircuitBreaker;
_a = JSII_RTTI_SYMBOL_1;
CircuitBreaker[_a] = { fqn: "@opencdk8s/cdk8s-kuma-types.CircuitBreaker", version: "0.0.12" };
/**
 * Returns the apiVersion and kind for "CircuitBreaker".
 *
 * @stability stable
 */
CircuitBreaker.GVK = {
    apiVersion: 'kuma.io/v1alpha1',
    kind: 'CircuitBreaker',
};
/**
 * Converts an object of type 'CircuitBreakerProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CircuitBreakerProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'mesh': obj.mesh,
        'spec': obj.spec,
        'metadata': obj.metadata,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CircuitBreakerProps = toJson_CircuitBreakerProps;
/**
 * Dataplane is the Schema for the dataplanes API.
 *
 * @stability stable
 * @schema Dataplane
 */
class Dataplane extends cdk8s_1.ApiObject {
    /**
     * Defines a "Dataplane" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        super(scope, id, Dataplane.manifest(props));
    }
    /**
     * Renders a Kubernetes manifest for "Dataplane".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @stability stable
     */
    static manifest(props = {}) {
        return {
            ...Dataplane.GVK,
            ...toJson_DataplaneProps(props),
        };
    }
}
exports.Dataplane = Dataplane;
_b = JSII_RTTI_SYMBOL_1;
Dataplane[_b] = { fqn: "@opencdk8s/cdk8s-kuma-types.Dataplane", version: "0.0.12" };
/**
 * Returns the apiVersion and kind for "Dataplane".
 *
 * @stability stable
 */
Dataplane.GVK = {
    apiVersion: 'kuma.io/v1alpha1',
    kind: 'Dataplane',
};
/**
 * Converts an object of type 'DataplaneProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_DataplaneProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'mesh': obj.mesh,
        'spec': obj.spec,
        'metadata': obj.metadata,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_DataplaneProps = toJson_DataplaneProps;
/**
 * DataplaneInsight is the Schema for the dataplane insights API.
 *
 * @stability stable
 * @schema DataplaneInsight
 */
class DataplaneInsight extends cdk8s_1.ApiObject {
    /**
     * Defines a "DataplaneInsight" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        super(scope, id, DataplaneInsight.manifest(props));
    }
    /**
     * Renders a Kubernetes manifest for "DataplaneInsight".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @stability stable
     */
    static manifest(props = {}) {
        return {
            ...DataplaneInsight.GVK,
            ...toJson_DataplaneInsightProps(props),
        };
    }
}
exports.DataplaneInsight = DataplaneInsight;
_c = JSII_RTTI_SYMBOL_1;
DataplaneInsight[_c] = { fqn: "@opencdk8s/cdk8s-kuma-types.DataplaneInsight", version: "0.0.12" };
/**
 * Returns the apiVersion and kind for "DataplaneInsight".
 *
 * @stability stable
 */
DataplaneInsight.GVK = {
    apiVersion: 'kuma.io/v1alpha1',
    kind: 'DataplaneInsight',
};
/**
 * Converts an object of type 'DataplaneInsightProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_DataplaneInsightProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'mesh': obj.mesh,
        'metadata': obj.metadata,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_DataplaneInsightProps = toJson_DataplaneInsightProps;
/**
 * @stability stable
 * @schema ExternalService
 */
class ExternalService extends cdk8s_1.ApiObject {
    /**
     * Defines a "ExternalService" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        super(scope, id, ExternalService.manifest(props));
    }
    /**
     * Renders a Kubernetes manifest for "ExternalService".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @stability stable
     */
    static manifest(props = {}) {
        return {
            ...ExternalService.GVK,
            ...toJson_ExternalServiceProps(props),
        };
    }
}
exports.ExternalService = ExternalService;
_d = JSII_RTTI_SYMBOL_1;
ExternalService[_d] = { fqn: "@opencdk8s/cdk8s-kuma-types.ExternalService", version: "0.0.12" };
/**
 * Returns the apiVersion and kind for "ExternalService".
 *
 * @stability stable
 */
ExternalService.GVK = {
    apiVersion: 'kuma.io/v1alpha1',
    kind: 'ExternalService',
};
/**
 * Converts an object of type 'ExternalServiceProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_ExternalServiceProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'mesh': obj.mesh,
        'spec': obj.spec,
        'metadata': obj.metadata,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_ExternalServiceProps = toJson_ExternalServiceProps;
/**
 * FaultInjection is the Schema for the faultinjections API.
 *
 * @stability stable
 * @schema FaultInjection
 */
class FaultInjection extends cdk8s_1.ApiObject {
    /**
     * Defines a "FaultInjection" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        super(scope, id, FaultInjection.manifest(props));
    }
    /**
     * Renders a Kubernetes manifest for "FaultInjection".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @stability stable
     */
    static manifest(props = {}) {
        return {
            ...FaultInjection.GVK,
            ...toJson_FaultInjectionProps(props),
        };
    }
}
exports.FaultInjection = FaultInjection;
_e = JSII_RTTI_SYMBOL_1;
FaultInjection[_e] = { fqn: "@opencdk8s/cdk8s-kuma-types.FaultInjection", version: "0.0.12" };
/**
 * Returns the apiVersion and kind for "FaultInjection".
 *
 * @stability stable
 */
FaultInjection.GVK = {
    apiVersion: 'kuma.io/v1alpha1',
    kind: 'FaultInjection',
};
/**
 * Converts an object of type 'FaultInjectionProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_FaultInjectionProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'mesh': obj.mesh,
        'spec': obj.spec,
        'metadata': obj.metadata,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_FaultInjectionProps = toJson_FaultInjectionProps;
/**
 * HealthCheck is the Schema for the healthchecks API.
 *
 * @stability stable
 * @schema HealthCheck
 */
class HealthCheck extends cdk8s_1.ApiObject {
    /**
     * Defines a "HealthCheck" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        super(scope, id, HealthCheck.manifest(props));
    }
    /**
     * Renders a Kubernetes manifest for "HealthCheck".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @stability stable
     */
    static manifest(props = {}) {
        return {
            ...HealthCheck.GVK,
            ...toJson_HealthCheckProps(props),
        };
    }
}
exports.HealthCheck = HealthCheck;
_f = JSII_RTTI_SYMBOL_1;
HealthCheck[_f] = { fqn: "@opencdk8s/cdk8s-kuma-types.HealthCheck", version: "0.0.12" };
/**
 * Returns the apiVersion and kind for "HealthCheck".
 *
 * @stability stable
 */
HealthCheck.GVK = {
    apiVersion: 'kuma.io/v1alpha1',
    kind: 'HealthCheck',
};
/**
 * Converts an object of type 'HealthCheckProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_HealthCheckProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'mesh': obj.mesh,
        'spec': obj.spec,
        'metadata': obj.metadata,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_HealthCheckProps = toJson_HealthCheckProps;
/**
 * Mesh is the Schema for the meshes API.
 *
 * @stability stable
 * @schema Mesh
 */
class Mesh extends cdk8s_1.ApiObject {
    /**
     * Defines a "Mesh" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        super(scope, id, Mesh.manifest(props));
    }
    /**
     * Renders a Kubernetes manifest for "Mesh".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @stability stable
     */
    static manifest(props = {}) {
        return {
            ...Mesh.GVK,
            ...toJson_MeshProps(props),
        };
    }
}
exports.Mesh = Mesh;
_g = JSII_RTTI_SYMBOL_1;
Mesh[_g] = { fqn: "@opencdk8s/cdk8s-kuma-types.Mesh", version: "0.0.12" };
/**
 * Returns the apiVersion and kind for "Mesh".
 *
 * @stability stable
 */
Mesh.GVK = {
    apiVersion: 'kuma.io/v1alpha1',
    kind: 'Mesh',
};
/**
 * Converts an object of type 'MeshProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_MeshProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'spec': obj.spec,
        'metadata': obj.metadata,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_MeshProps = toJson_MeshProps;
/**
 * MeshInsight is the Schema for the meshes insights API.
 *
 * @stability stable
 * @schema MeshInsight
 */
class MeshInsight extends cdk8s_1.ApiObject {
    /**
     * Defines a "MeshInsight" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        super(scope, id, MeshInsight.manifest(props));
    }
    /**
     * Renders a Kubernetes manifest for "MeshInsight".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @stability stable
     */
    static manifest(props = {}) {
        return {
            ...MeshInsight.GVK,
            ...toJson_MeshInsightProps(props),
        };
    }
}
exports.MeshInsight = MeshInsight;
_h = JSII_RTTI_SYMBOL_1;
MeshInsight[_h] = { fqn: "@opencdk8s/cdk8s-kuma-types.MeshInsight", version: "0.0.12" };
/**
 * Returns the apiVersion and kind for "MeshInsight".
 *
 * @stability stable
 */
MeshInsight.GVK = {
    apiVersion: 'kuma.io/v1alpha1',
    kind: 'MeshInsight',
};
/**
 * Converts an object of type 'MeshInsightProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_MeshInsightProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'mesh': obj.mesh,
        'spec': obj.spec,
        'metadata': obj.metadata,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_MeshInsightProps = toJson_MeshInsightProps;
/**
 * ProxyTemplate is the Schema for the proxytemplates API.
 *
 * @stability stable
 * @schema ProxyTemplate
 */
class ProxyTemplate extends cdk8s_1.ApiObject {
    /**
     * Defines a "ProxyTemplate" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        super(scope, id, ProxyTemplate.manifest(props));
    }
    /**
     * Renders a Kubernetes manifest for "ProxyTemplate".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @stability stable
     */
    static manifest(props = {}) {
        return {
            ...ProxyTemplate.GVK,
            ...toJson_ProxyTemplateProps(props),
        };
    }
}
exports.ProxyTemplate = ProxyTemplate;
_j = JSII_RTTI_SYMBOL_1;
ProxyTemplate[_j] = { fqn: "@opencdk8s/cdk8s-kuma-types.ProxyTemplate", version: "0.0.12" };
/**
 * Returns the apiVersion and kind for "ProxyTemplate".
 *
 * @stability stable
 */
ProxyTemplate.GVK = {
    apiVersion: 'kuma.io/v1alpha1',
    kind: 'ProxyTemplate',
};
/**
 * Converts an object of type 'ProxyTemplateProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_ProxyTemplateProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'mesh': obj.mesh,
        'spec': obj.spec,
        'metadata': obj.metadata,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_ProxyTemplateProps = toJson_ProxyTemplateProps;
/**
 * RateLimit is the Schema for the ratelimits API.
 *
 * @stability stable
 * @schema RateLimit
 */
class RateLimit extends cdk8s_1.ApiObject {
    /**
     * Defines a "RateLimit" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        super(scope, id, RateLimit.manifest(props));
    }
    /**
     * Renders a Kubernetes manifest for "RateLimit".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @stability stable
     */
    static manifest(props = {}) {
        return {
            ...RateLimit.GVK,
            ...toJson_RateLimitProps(props),
        };
    }
}
exports.RateLimit = RateLimit;
_k = JSII_RTTI_SYMBOL_1;
RateLimit[_k] = { fqn: "@opencdk8s/cdk8s-kuma-types.RateLimit", version: "0.0.12" };
/**
 * Returns the apiVersion and kind for "RateLimit".
 *
 * @stability stable
 */
RateLimit.GVK = {
    apiVersion: 'kuma.io/v1alpha1',
    kind: 'RateLimit',
};
/**
 * Converts an object of type 'RateLimitProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_RateLimitProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'mesh': obj.mesh,
        'spec': obj.spec,
        'metadata': obj.metadata,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_RateLimitProps = toJson_RateLimitProps;
/**
 * Retry is the Schema for the retries API.
 *
 * @stability stable
 * @schema Retry
 */
class Retry extends cdk8s_1.ApiObject {
    /**
     * Defines a "Retry" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        super(scope, id, Retry.manifest(props));
    }
    /**
     * Renders a Kubernetes manifest for "Retry".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @stability stable
     */
    static manifest(props = {}) {
        return {
            ...Retry.GVK,
            ...toJson_RetryProps(props),
        };
    }
}
exports.Retry = Retry;
_l = JSII_RTTI_SYMBOL_1;
Retry[_l] = { fqn: "@opencdk8s/cdk8s-kuma-types.Retry", version: "0.0.12" };
/**
 * Returns the apiVersion and kind for "Retry".
 *
 * @stability stable
 */
Retry.GVK = {
    apiVersion: 'kuma.io/v1alpha1',
    kind: 'Retry',
};
/**
 * Converts an object of type 'RetryProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_RetryProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'mesh': obj.mesh,
        'spec': obj.spec,
        'metadata': obj.metadata,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_RetryProps = toJson_RetryProps;
/**
 * ServiceInsight is the Schema for the services insights API.
 *
 * @stability stable
 * @schema ServiceInsight
 */
class ServiceInsight extends cdk8s_1.ApiObject {
    /**
     * Defines a "ServiceInsight" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        super(scope, id, ServiceInsight.manifest(props));
    }
    /**
     * Renders a Kubernetes manifest for "ServiceInsight".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @stability stable
     */
    static manifest(props = {}) {
        return {
            ...ServiceInsight.GVK,
            ...toJson_ServiceInsightProps(props),
        };
    }
}
exports.ServiceInsight = ServiceInsight;
_m = JSII_RTTI_SYMBOL_1;
ServiceInsight[_m] = { fqn: "@opencdk8s/cdk8s-kuma-types.ServiceInsight", version: "0.0.12" };
/**
 * Returns the apiVersion and kind for "ServiceInsight".
 *
 * @stability stable
 */
ServiceInsight.GVK = {
    apiVersion: 'kuma.io/v1alpha1',
    kind: 'ServiceInsight',
};
/**
 * Converts an object of type 'ServiceInsightProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_ServiceInsightProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'mesh': obj.mesh,
        'spec': obj.spec,
        'metadata': obj.metadata,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_ServiceInsightProps = toJson_ServiceInsightProps;
/**
 * Timeout is the Schema for the timeout API.
 *
 * @stability stable
 * @schema Timeout
 */
class Timeout extends cdk8s_1.ApiObject {
    /**
     * Defines a "Timeout" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        super(scope, id, Timeout.manifest(props));
    }
    /**
     * Renders a Kubernetes manifest for "Timeout".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @stability stable
     */
    static manifest(props = {}) {
        return {
            ...Timeout.GVK,
            ...toJson_TimeoutProps(props),
        };
    }
}
exports.Timeout = Timeout;
_o = JSII_RTTI_SYMBOL_1;
Timeout[_o] = { fqn: "@opencdk8s/cdk8s-kuma-types.Timeout", version: "0.0.12" };
/**
 * Returns the apiVersion and kind for "Timeout".
 *
 * @stability stable
 */
Timeout.GVK = {
    apiVersion: 'kuma.io/v1alpha1',
    kind: 'Timeout',
};
/**
 * Converts an object of type 'TimeoutProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_TimeoutProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'mesh': obj.mesh,
        'spec': obj.spec,
        'metadata': obj.metadata,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_TimeoutProps = toJson_TimeoutProps;
/**
 * TrafficLog is the Schema for the trafficlogs API.
 *
 * @stability stable
 * @schema TrafficLog
 */
class TrafficLog extends cdk8s_1.ApiObject {
    /**
     * Defines a "TrafficLog" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        super(scope, id, TrafficLog.manifest(props));
    }
    /**
     * Renders a Kubernetes manifest for "TrafficLog".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @stability stable
     */
    static manifest(props = {}) {
        return {
            ...TrafficLog.GVK,
            ...toJson_TrafficLogProps(props),
        };
    }
}
exports.TrafficLog = TrafficLog;
_p = JSII_RTTI_SYMBOL_1;
TrafficLog[_p] = { fqn: "@opencdk8s/cdk8s-kuma-types.TrafficLog", version: "0.0.12" };
/**
 * Returns the apiVersion and kind for "TrafficLog".
 *
 * @stability stable
 */
TrafficLog.GVK = {
    apiVersion: 'kuma.io/v1alpha1',
    kind: 'TrafficLog',
};
/**
 * Converts an object of type 'TrafficLogProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_TrafficLogProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'mesh': obj.mesh,
        'spec': obj.spec,
        'metadata': obj.metadata,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_TrafficLogProps = toJson_TrafficLogProps;
/**
 * TrafficPermission is the Schema for the trafficpermissions API.
 *
 * @stability stable
 * @schema TrafficPermission
 */
class TrafficPermission extends cdk8s_1.ApiObject {
    /**
     * Defines a "TrafficPermission" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        super(scope, id, TrafficPermission.manifest(props));
    }
    /**
     * Renders a Kubernetes manifest for "TrafficPermission".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @stability stable
     */
    static manifest(props = {}) {
        return {
            ...TrafficPermission.GVK,
            ...toJson_TrafficPermissionProps(props),
        };
    }
}
exports.TrafficPermission = TrafficPermission;
_q = JSII_RTTI_SYMBOL_1;
TrafficPermission[_q] = { fqn: "@opencdk8s/cdk8s-kuma-types.TrafficPermission", version: "0.0.12" };
/**
 * Returns the apiVersion and kind for "TrafficPermission".
 *
 * @stability stable
 */
TrafficPermission.GVK = {
    apiVersion: 'kuma.io/v1alpha1',
    kind: 'TrafficPermission',
};
/**
 * Converts an object of type 'TrafficPermissionProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_TrafficPermissionProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'mesh': obj.mesh,
        'spec': obj.spec,
        'metadata': obj.metadata,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_TrafficPermissionProps = toJson_TrafficPermissionProps;
/**
 * TrafficRoute is the Schema for the trafficroutes API.
 *
 * @stability stable
 * @schema TrafficRoute
 */
class TrafficRoute extends cdk8s_1.ApiObject {
    /**
     * Defines a "TrafficRoute" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        super(scope, id, TrafficRoute.manifest(props));
    }
    /**
     * Renders a Kubernetes manifest for "TrafficRoute".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @stability stable
     */
    static manifest(props = {}) {
        return {
            ...TrafficRoute.GVK,
            ...toJson_TrafficRouteProps(props),
        };
    }
}
exports.TrafficRoute = TrafficRoute;
_r = JSII_RTTI_SYMBOL_1;
TrafficRoute[_r] = { fqn: "@opencdk8s/cdk8s-kuma-types.TrafficRoute", version: "0.0.12" };
/**
 * Returns the apiVersion and kind for "TrafficRoute".
 *
 * @stability stable
 */
TrafficRoute.GVK = {
    apiVersion: 'kuma.io/v1alpha1',
    kind: 'TrafficRoute',
};
/**
 * Converts an object of type 'TrafficRouteProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_TrafficRouteProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'mesh': obj.mesh,
        'spec': obj.spec,
        'metadata': obj.metadata,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_TrafficRouteProps = toJson_TrafficRouteProps;
/**
 * TrafficTrace is the Schema for the traffictraces API.
 *
 * @stability stable
 * @schema TrafficTrace
 */
class TrafficTrace extends cdk8s_1.ApiObject {
    /**
     * Defines a "TrafficTrace" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        super(scope, id, TrafficTrace.manifest(props));
    }
    /**
     * Renders a Kubernetes manifest for "TrafficTrace".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @stability stable
     */
    static manifest(props = {}) {
        return {
            ...TrafficTrace.GVK,
            ...toJson_TrafficTraceProps(props),
        };
    }
}
exports.TrafficTrace = TrafficTrace;
_s = JSII_RTTI_SYMBOL_1;
TrafficTrace[_s] = { fqn: "@opencdk8s/cdk8s-kuma-types.TrafficTrace", version: "0.0.12" };
/**
 * Returns the apiVersion and kind for "TrafficTrace".
 *
 * @stability stable
 */
TrafficTrace.GVK = {
    apiVersion: 'kuma.io/v1alpha1',
    kind: 'TrafficTrace',
};
/**
 * Converts an object of type 'TrafficTraceProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_TrafficTraceProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'mesh': obj.mesh,
        'spec': obj.spec,
        'metadata': obj.metadata,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_TrafficTraceProps = toJson_TrafficTraceProps;
/**
 * VirtualOutbound is the Schema for the virtualoutbounds API.
 *
 * @stability stable
 * @schema VirtualOutbound
 */
class VirtualOutbound extends cdk8s_1.ApiObject {
    /**
     * Defines a "VirtualOutbound" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        super(scope, id, VirtualOutbound.manifest(props));
    }
    /**
     * Renders a Kubernetes manifest for "VirtualOutbound".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @stability stable
     */
    static manifest(props = {}) {
        return {
            ...VirtualOutbound.GVK,
            ...toJson_VirtualOutboundProps(props),
        };
    }
}
exports.VirtualOutbound = VirtualOutbound;
_t = JSII_RTTI_SYMBOL_1;
VirtualOutbound[_t] = { fqn: "@opencdk8s/cdk8s-kuma-types.VirtualOutbound", version: "0.0.12" };
/**
 * Returns the apiVersion and kind for "VirtualOutbound".
 *
 * @stability stable
 */
VirtualOutbound.GVK = {
    apiVersion: 'kuma.io/v1alpha1',
    kind: 'VirtualOutbound',
};
/**
 * Converts an object of type 'VirtualOutboundProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_VirtualOutboundProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'mesh': obj.mesh,
        'spec': obj.spec,
        'metadata': obj.metadata,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_VirtualOutboundProps = toJson_VirtualOutboundProps;
/**
 * Zone is the Schema for the zone API.
 *
 * @stability stable
 * @schema Zone
 */
class Zone extends cdk8s_1.ApiObject {
    /**
     * Defines a "Zone" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        super(scope, id, Zone.manifest(props));
    }
    /**
     * Renders a Kubernetes manifest for "Zone".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @stability stable
     */
    static manifest(props = {}) {
        return {
            ...Zone.GVK,
            ...toJson_ZoneProps(props),
        };
    }
}
exports.Zone = Zone;
_u = JSII_RTTI_SYMBOL_1;
Zone[_u] = { fqn: "@opencdk8s/cdk8s-kuma-types.Zone", version: "0.0.12" };
/**
 * Returns the apiVersion and kind for "Zone".
 *
 * @stability stable
 */
Zone.GVK = {
    apiVersion: 'kuma.io/v1alpha1',
    kind: 'Zone',
};
/**
 * Converts an object of type 'ZoneProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_ZoneProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'mesh': obj.mesh,
        'spec': obj.spec,
        'metadata': obj.metadata,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_ZoneProps = toJson_ZoneProps;
/**
 * ZoneIngress is the Schema for the zone ingress API.
 *
 * @stability stable
 * @schema ZoneIngress
 */
class ZoneIngress extends cdk8s_1.ApiObject {
    /**
     * Defines a "ZoneIngress" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        super(scope, id, ZoneIngress.manifest(props));
    }
    /**
     * Renders a Kubernetes manifest for "ZoneIngress".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @stability stable
     */
    static manifest(props = {}) {
        return {
            ...ZoneIngress.GVK,
            ...toJson_ZoneIngressProps(props),
        };
    }
}
exports.ZoneIngress = ZoneIngress;
_v = JSII_RTTI_SYMBOL_1;
ZoneIngress[_v] = { fqn: "@opencdk8s/cdk8s-kuma-types.ZoneIngress", version: "0.0.12" };
/**
 * Returns the apiVersion and kind for "ZoneIngress".
 *
 * @stability stable
 */
ZoneIngress.GVK = {
    apiVersion: 'kuma.io/v1alpha1',
    kind: 'ZoneIngress',
};
/**
 * Converts an object of type 'ZoneIngressProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_ZoneIngressProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'mesh': obj.mesh,
        'spec': obj.spec,
        'metadata': obj.metadata,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_ZoneIngressProps = toJson_ZoneIngressProps;
/**
 * ZoneIngressInsight is the Schema for the zone ingress insight API.
 *
 * @stability stable
 * @schema ZoneIngressInsight
 */
class ZoneIngressInsight extends cdk8s_1.ApiObject {
    /**
     * Defines a "ZoneIngressInsight" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        super(scope, id, ZoneIngressInsight.manifest(props));
    }
    /**
     * Renders a Kubernetes manifest for "ZoneIngressInsight".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @stability stable
     */
    static manifest(props = {}) {
        return {
            ...ZoneIngressInsight.GVK,
            ...toJson_ZoneIngressInsightProps(props),
        };
    }
}
exports.ZoneIngressInsight = ZoneIngressInsight;
_w = JSII_RTTI_SYMBOL_1;
ZoneIngressInsight[_w] = { fqn: "@opencdk8s/cdk8s-kuma-types.ZoneIngressInsight", version: "0.0.12" };
/**
 * Returns the apiVersion and kind for "ZoneIngressInsight".
 *
 * @stability stable
 */
ZoneIngressInsight.GVK = {
    apiVersion: 'kuma.io/v1alpha1',
    kind: 'ZoneIngressInsight',
};
/**
 * Converts an object of type 'ZoneIngressInsightProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_ZoneIngressInsightProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'mesh': obj.mesh,
        'spec': obj.spec,
        'metadata': obj.metadata,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_ZoneIngressInsightProps = toJson_ZoneIngressInsightProps;
/**
 * ZoneInsight is the Schema for the zone insight API.
 *
 * @stability stable
 * @schema ZoneInsight
 */
class ZoneInsight extends cdk8s_1.ApiObject {
    /**
     * Defines a "ZoneInsight" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        super(scope, id, ZoneInsight.manifest(props));
    }
    /**
     * Renders a Kubernetes manifest for "ZoneInsight".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @stability stable
     */
    static manifest(props = {}) {
        return {
            ...ZoneInsight.GVK,
            ...toJson_ZoneInsightProps(props),
        };
    }
}
exports.ZoneInsight = ZoneInsight;
_x = JSII_RTTI_SYMBOL_1;
ZoneInsight[_x] = { fqn: "@opencdk8s/cdk8s-kuma-types.ZoneInsight", version: "0.0.12" };
/**
 * Returns the apiVersion and kind for "ZoneInsight".
 *
 * @stability stable
 */
ZoneInsight.GVK = {
    apiVersion: 'kuma.io/v1alpha1',
    kind: 'ZoneInsight',
};
/**
 * Converts an object of type 'ZoneInsightProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_ZoneInsightProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'mesh': obj.mesh,
        'spec': obj.spec,
        'metadata': obj.metadata,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_ZoneInsightProps = toJson_ZoneInsightProps;
/**
 * @stability stable
 */
class Kuma extends constructs_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, name, opts) {
        var _1, _2;
        super(scope, name);
        const source = [];
        (_1 = opts === null || opts === void 0 ? void 0 : opts.serviceWhitelist) === null || _1 === void 0 ? void 0 : _1.forEach(src => {
            source.push({
                match: {
                    app: src,
                },
            });
        });
        (_2 = opts === null || opts === void 0 ? void 0 : opts.gatewayWhitelist) === null || _2 === void 0 ? void 0 : _2.forEach(src => {
            source.push({
                match: {
                    app: src,
                },
            });
        });
        if (source.length > 0) {
            new TrafficPermission(this, `${name}-inbound`, {
                mesh: opts.mesh,
                metadata: {
                    name: `${name}-inbound`,
                },
                spec: {
                    destinations: [{
                            match: {
                                app: name,
                            },
                        }],
                    sources: source,
                },
            });
        }
    }
}
exports.Kuma = Kuma;
_y = JSII_RTTI_SYMBOL_1;
Kuma[_y] = { fqn: "@opencdk8s/cdk8s-kuma-types.Kuma", version: "0.0.12" };
/**
 * @stability stable
 */
class TypedKumaExternalService extends constructs_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, name, opts) {
        super(scope, name);
        new ExternalService(this, name, {
            mesh: opts.mesh,
            metadata: {
                name: opts.serviceName,
            },
            spec: {
                tags: {
                    'kuma.io/service': opts.serviceName,
                    'kuma.io/protocol': opts.serviceProtocol,
                },
                networking: {
                    address: opts.serviceAddress,
                    tls: {
                        enabled: false,
                    },
                },
            },
        });
    }
}
exports.TypedKumaExternalService = TypedKumaExternalService;
_z = JSII_RTTI_SYMBOL_1;
TypedKumaExternalService[_z] = { fqn: "@opencdk8s/cdk8s-kuma-types.TypedKumaExternalService", version: "0.0.12" };
/**
 * @stability stable
 */
class TypedTrafficPermission extends constructs_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, name, opts) {
        var _1;
        super(scope, name);
        const sources = [];
        (_1 = opts.sources) === null || _1 === void 0 ? void 0 : _1.forEach(v => {
            sources.push({
                match: {
                    app: v,
                },
            });
        });
        const destinationLabel = opts.destinationLabel ? opts.destinationLabel : 'kuma.io/service';
        new TrafficPermission(this, name, {
            mesh: opts.mesh,
            metadata: {
                name: name,
            },
            spec: {
                destinations: [{
                        match: {
                            [destinationLabel]: opts.destination,
                        },
                    }],
                sources: sources,
            },
        });
    }
}
exports.TypedTrafficPermission = TypedTrafficPermission;
_0 = JSII_RTTI_SYMBOL_1;
TypedTrafficPermission[_0] = { fqn: "@opencdk8s/cdk8s-kuma-types.TypedTrafficPermission", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvaW5kZXgudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSxxQkFBcUI7QUFDckIsaUNBQXVFO0FBQ3ZFLDJDQUF1Qzs7Ozs7OztBQUl2QyxNQUFhLGNBQWUsU0FBUSxpQkFBUzs7Ozs7Ozs7O0lBZ0IzQyxZQUFtQixLQUFnQixFQUFFLEVBQVUsRUFBRSxRQUE2QixFQUFFO1FBQzlFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLGNBQWMsQ0FBQyxRQUFRLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQztJQUNuRCxDQUFDOzs7Ozs7Ozs7SUFWTSxNQUFNLENBQUMsUUFBUSxDQUFDLFFBQTZCLEVBQUU7UUFDcEQsT0FBTztZQUNMLEdBQUcsY0FBYyxDQUFDLEdBQUc7WUFDckIsR0FBRywwQkFBMEIsQ0FBQyxLQUFLLENBQUM7U0FDckMsQ0FBQztJQUNKLENBQUM7O0FBYkgsd0NBbUJDOzs7Ozs7OztBQWpCd0Isa0JBQUcsR0FBcUI7SUFDN0MsVUFBVSxFQUFFLGtCQUFrQjtJQUM5QixJQUFJLEVBQUUsZ0JBQWdCO0NBQ3ZCLENBQUE7QUE2Qkg7O0dBRUc7QUFDSCx5Q0FBeUM7QUFDekMsU0FBZ0IsMEJBQTBCLENBQUMsR0FBb0M7SUFDN0UsSUFBSSxHQUFHLEtBQUssU0FBUyxFQUFFO1FBQUUsT0FBTyxTQUFTLENBQUM7S0FBRTtJQUM1QyxNQUFNLE1BQU0sR0FBRztRQUNiLE1BQU0sRUFBRSxHQUFHLENBQUMsSUFBSTtRQUNoQixNQUFNLEVBQUUsR0FBRyxDQUFDLElBQUk7UUFDaEIsVUFBVSxFQUFFLEdBQUcsQ0FBQyxRQUFRO0tBQ3pCLENBQUM7SUFDRiwwQkFBMEI7SUFDMUIsT0FBTyxNQUFNLENBQUMsT0FBTyxDQUFDLE1BQU0sQ0FBQyxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxLQUFLLFNBQVMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxHQUFHLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUM7QUFDMUcsQ0FBQztBQVRELGdFQVNDOzs7Ozs7O0FBS0QsTUFBYSxTQUFVLFNBQVEsaUJBQVM7Ozs7Ozs7OztJQWdCdEMsWUFBbUIsS0FBZ0IsRUFBRSxFQUFVLEVBQUUsUUFBd0IsRUFBRTtRQUN6RSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxTQUFTLENBQUMsUUFBUSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUM7SUFDOUMsQ0FBQzs7Ozs7Ozs7O0lBVk0sTUFBTSxDQUFDLFFBQVEsQ0FBQyxRQUF3QixFQUFFO1FBQy9DLE9BQU87WUFDTCxHQUFHLFNBQVMsQ0FBQyxHQUFHO1lBQ2hCLEdBQUcscUJBQXFCLENBQUMsS0FBSyxDQUFDO1NBQ2hDLENBQUM7SUFDSixDQUFDOztBQWJILDhCQW1CQzs7Ozs7Ozs7QUFqQndCLGFBQUcsR0FBcUI7SUFDN0MsVUFBVSxFQUFFLGtCQUFrQjtJQUM5QixJQUFJLEVBQUUsV0FBVztDQUNsQixDQUFBO0FBNkJIOztHQUVHO0FBQ0gseUNBQXlDO0FBQ3pDLFNBQWdCLHFCQUFxQixDQUFDLEdBQStCO0lBQ25FLElBQUksR0FBRyxLQUFLLFNBQVMsRUFBRTtRQUFFLE9BQU8sU0FBUyxDQUFDO0tBQUU7SUFDNUMsTUFBTSxNQUFNLEdBQUc7UUFDYixNQUFNLEVBQUUsR0FBRyxDQUFDLElBQUk7UUFDaEIsTUFBTSxFQUFFLEdBQUcsQ0FBQyxJQUFJO1FBQ2hCLFVBQVUsRUFBRSxHQUFHLENBQUMsUUFBUTtLQUN6QixDQUFDO0lBQ0YsMEJBQTBCO0lBQzFCLE9BQU8sTUFBTSxDQUFDLE9BQU8sQ0FBQyxNQUFNLENBQUMsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsS0FBSyxTQUFTLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsR0FBRyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDO0FBQzFHLENBQUM7QUFURCxzREFTQzs7Ozs7OztBQUtELE1BQWEsZ0JBQWlCLFNBQVEsaUJBQVM7Ozs7Ozs7OztJQWdCN0MsWUFBbUIsS0FBZ0IsRUFBRSxFQUFVLEVBQUUsUUFBK0IsRUFBRTtRQUNoRixLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxnQkFBZ0IsQ0FBQyxRQUFRLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQztJQUNyRCxDQUFDOzs7Ozs7Ozs7SUFWTSxNQUFNLENBQUMsUUFBUSxDQUFDLFFBQStCLEVBQUU7UUFDdEQsT0FBTztZQUNMLEdBQUcsZ0JBQWdCLENBQUMsR0FBRztZQUN2QixHQUFHLDRCQUE0QixDQUFDLEtBQUssQ0FBQztTQUN2QyxDQUFDO0lBQ0osQ0FBQzs7QUFiSCw0Q0FtQkM7Ozs7Ozs7O0FBakJ3QixvQkFBRyxHQUFxQjtJQUM3QyxVQUFVLEVBQUUsa0JBQWtCO0lBQzlCLElBQUksRUFBRSxrQkFBa0I7Q0FDekIsQ0FBQTtBQTBCSDs7R0FFRztBQUNILHlDQUF5QztBQUN6QyxTQUFnQiw0QkFBNEIsQ0FBQyxHQUFzQztJQUNqRixJQUFJLEdBQUcsS0FBSyxTQUFTLEVBQUU7UUFBRSxPQUFPLFNBQVMsQ0FBQztLQUFFO0lBQzVDLE1BQU0sTUFBTSxHQUFHO1FBQ2IsTUFBTSxFQUFFLEdBQUcsQ0FBQyxJQUFJO1FBQ2hCLFVBQVUsRUFBRSxHQUFHLENBQUMsUUFBUTtLQUN6QixDQUFDO0lBQ0YsMEJBQTBCO0lBQzFCLE9BQU8sTUFBTSxDQUFDLE9BQU8sQ0FBQyxNQUFNLENBQUMsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsS0FBSyxTQUFTLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsR0FBRyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDO0FBQzFHLENBQUM7QUFSRCxvRUFRQzs7Ozs7QUFLRCxNQUFhLGVBQWdCLFNBQVEsaUJBQVM7Ozs7Ozs7OztJQWdCNUMsWUFBbUIsS0FBZ0IsRUFBRSxFQUFVLEVBQUUsUUFBOEIsRUFBRTtRQUMvRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxlQUFlLENBQUMsUUFBUSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUM7SUFDcEQsQ0FBQzs7Ozs7Ozs7O0lBVk0sTUFBTSxDQUFDLFFBQVEsQ0FBQyxRQUE4QixFQUFFO1FBQ3JELE9BQU87WUFDTCxHQUFHLGVBQWUsQ0FBQyxHQUFHO1lBQ3RCLEdBQUcsMkJBQTJCLENBQUMsS0FBSyxDQUFDO1NBQ3RDLENBQUM7SUFDSixDQUFDOztBQWJILDBDQW1CQzs7Ozs7Ozs7QUFqQndCLG1CQUFHLEdBQXFCO0lBQzdDLFVBQVUsRUFBRSxrQkFBa0I7SUFDOUIsSUFBSSxFQUFFLGlCQUFpQjtDQUN4QixDQUFBO0FBNkJIOztHQUVHO0FBQ0gseUNBQXlDO0FBQ3pDLFNBQWdCLDJCQUEyQixDQUFDLEdBQXFDO0lBQy9FLElBQUksR0FBRyxLQUFLLFNBQVMsRUFBRTtRQUFFLE9BQU8sU0FBUyxDQUFDO0tBQUU7SUFDNUMsTUFBTSxNQUFNLEdBQUc7UUFDYixNQUFNLEVBQUUsR0FBRyxDQUFDLElBQUk7UUFDaEIsTUFBTSxFQUFFLEdBQUcsQ0FBQyxJQUFJO1FBQ2hCLFVBQVUsRUFBRSxHQUFHLENBQUMsUUFBUTtLQUN6QixDQUFDO0lBQ0YsMEJBQTBCO0lBQzFCLE9BQU8sTUFBTSxDQUFDLE9BQU8sQ0FBQyxNQUFNLENBQUMsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsS0FBSyxTQUFTLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsR0FBRyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDO0FBQzFHLENBQUM7QUFURCxrRUFTQzs7Ozs7OztBQUtELE1BQWEsY0FBZSxTQUFRLGlCQUFTOzs7Ozs7Ozs7SUFnQjNDLFlBQW1CLEtBQWdCLEVBQUUsRUFBVSxFQUFFLFFBQTZCLEVBQUU7UUFDOUUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsY0FBYyxDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDO0lBQ25ELENBQUM7Ozs7Ozs7OztJQVZNLE1BQU0sQ0FBQyxRQUFRLENBQUMsUUFBNkIsRUFBRTtRQUNwRCxPQUFPO1lBQ0wsR0FBRyxjQUFjLENBQUMsR0FBRztZQUNyQixHQUFHLDBCQUEwQixDQUFDLEtBQUssQ0FBQztTQUNyQyxDQUFDO0lBQ0osQ0FBQzs7QUFiSCx3Q0FtQkM7Ozs7Ozs7O0FBakJ3QixrQkFBRyxHQUFxQjtJQUM3QyxVQUFVLEVBQUUsa0JBQWtCO0lBQzlCLElBQUksRUFBRSxnQkFBZ0I7Q0FDdkIsQ0FBQTtBQTZCSDs7R0FFRztBQUNILHlDQUF5QztBQUN6QyxTQUFnQiwwQkFBMEIsQ0FBQyxHQUFvQztJQUM3RSxJQUFJLEdBQUcsS0FBSyxTQUFTLEVBQUU7UUFBRSxPQUFPLFNBQVMsQ0FBQztLQUFFO0lBQzVDLE1BQU0sTUFBTSxHQUFHO1FBQ2IsTUFBTSxFQUFFLEdBQUcsQ0FBQyxJQUFJO1FBQ2hCLE1BQU0sRUFBRSxHQUFHLENBQUMsSUFBSTtRQUNoQixVQUFVLEVBQUUsR0FBRyxDQUFDLFFBQVE7S0FDekIsQ0FBQztJQUNGLDBCQUEwQjtJQUMxQixPQUFPLE1BQU0sQ0FBQyxPQUFPLENBQUMsTUFBTSxDQUFDLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEtBQUssU0FBUyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLEdBQUcsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQztBQUMxRyxDQUFDO0FBVEQsZ0VBU0M7Ozs7Ozs7QUFLRCxNQUFhLFdBQVksU0FBUSxpQkFBUzs7Ozs7Ozs7O0lBZ0J4QyxZQUFtQixLQUFnQixFQUFFLEVBQVUsRUFBRSxRQUEwQixFQUFFO1FBQzNFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLFdBQVcsQ0FBQyxRQUFRLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQztJQUNoRCxDQUFDOzs7Ozs7Ozs7SUFWTSxNQUFNLENBQUMsUUFBUSxDQUFDLFFBQTBCLEVBQUU7UUFDakQsT0FBTztZQUNMLEdBQUcsV0FBVyxDQUFDLEdBQUc7WUFDbEIsR0FBRyx1QkFBdUIsQ0FBQyxLQUFLLENBQUM7U0FDbEMsQ0FBQztJQUNKLENBQUM7O0FBYkgsa0NBbUJDOzs7Ozs7OztBQWpCd0IsZUFBRyxHQUFxQjtJQUM3QyxVQUFVLEVBQUUsa0JBQWtCO0lBQzlCLElBQUksRUFBRSxhQUFhO0NBQ3BCLENBQUE7QUE2Qkg7O0dBRUc7QUFDSCx5Q0FBeUM7QUFDekMsU0FBZ0IsdUJBQXVCLENBQUMsR0FBaUM7SUFDdkUsSUFBSSxHQUFHLEtBQUssU0FBUyxFQUFFO1FBQUUsT0FBTyxTQUFTLENBQUM7S0FBRTtJQUM1QyxNQUFNLE1BQU0sR0FBRztRQUNiLE1BQU0sRUFBRSxHQUFHLENBQUMsSUFBSTtRQUNoQixNQUFNLEVBQUUsR0FBRyxDQUFDLElBQUk7UUFDaEIsVUFBVSxFQUFFLEdBQUcsQ0FBQyxRQUFRO0tBQ3pCLENBQUM7SUFDRiwwQkFBMEI7SUFDMUIsT0FBTyxNQUFNLENBQUMsT0FBTyxDQUFDLE1BQU0sQ0FBQyxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxLQUFLLFNBQVMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxHQUFHLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUM7QUFDMUcsQ0FBQztBQVRELDBEQVNDOzs7Ozs7O0FBS0QsTUFBYSxJQUFLLFNBQVEsaUJBQVM7Ozs7Ozs7OztJQWdCakMsWUFBbUIsS0FBZ0IsRUFBRSxFQUFVLEVBQUUsUUFBbUIsRUFBRTtRQUNwRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxJQUFJLENBQUMsUUFBUSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUM7SUFDekMsQ0FBQzs7Ozs7Ozs7O0lBVk0sTUFBTSxDQUFDLFFBQVEsQ0FBQyxRQUFtQixFQUFFO1FBQzFDLE9BQU87WUFDTCxHQUFHLElBQUksQ0FBQyxHQUFHO1lBQ1gsR0FBRyxnQkFBZ0IsQ0FBQyxLQUFLLENBQUM7U0FDM0IsQ0FBQztJQUNKLENBQUM7O0FBYkgsb0JBbUJDOzs7Ozs7OztBQWpCd0IsUUFBRyxHQUFxQjtJQUM3QyxVQUFVLEVBQUUsa0JBQWtCO0lBQzlCLElBQUksRUFBRSxNQUFNO0NBQ2IsQ0FBQTtBQTBCSDs7R0FFRztBQUNILHlDQUF5QztBQUN6QyxTQUFnQixnQkFBZ0IsQ0FBQyxHQUEwQjtJQUN6RCxJQUFJLEdBQUcsS0FBSyxTQUFTLEVBQUU7UUFBRSxPQUFPLFNBQVMsQ0FBQztLQUFFO0lBQzVDLE1BQU0sTUFBTSxHQUFHO1FBQ2IsTUFBTSxFQUFFLEdBQUcsQ0FBQyxJQUFJO1FBQ2hCLFVBQVUsRUFBRSxHQUFHLENBQUMsUUFBUTtLQUN6QixDQUFDO0lBQ0YsMEJBQTBCO0lBQzFCLE9BQU8sTUFBTSxDQUFDLE9BQU8sQ0FBQyxNQUFNLENBQUMsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsS0FBSyxTQUFTLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsR0FBRyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDO0FBQzFHLENBQUM7QUFSRCw0Q0FRQzs7Ozs7OztBQUtELE1BQWEsV0FBWSxTQUFRLGlCQUFTOzs7Ozs7Ozs7SUFnQnhDLFlBQW1CLEtBQWdCLEVBQUUsRUFBVSxFQUFFLFFBQTBCLEVBQUU7UUFDM0UsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsV0FBVyxDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDO0lBQ2hELENBQUM7Ozs7Ozs7OztJQVZNLE1BQU0sQ0FBQyxRQUFRLENBQUMsUUFBMEIsRUFBRTtRQUNqRCxPQUFPO1lBQ0wsR0FBRyxXQUFXLENBQUMsR0FBRztZQUNsQixHQUFHLHVCQUF1QixDQUFDLEtBQUssQ0FBQztTQUNsQyxDQUFDO0lBQ0osQ0FBQzs7QUFiSCxrQ0FtQkM7Ozs7Ozs7O0FBakJ3QixlQUFHLEdBQXFCO0lBQzdDLFVBQVUsRUFBRSxrQkFBa0I7SUFDOUIsSUFBSSxFQUFFLGFBQWE7Q0FDcEIsQ0FBQTtBQTZCSDs7R0FFRztBQUNILHlDQUF5QztBQUN6QyxTQUFnQix1QkFBdUIsQ0FBQyxHQUFpQztJQUN2RSxJQUFJLEdBQUcsS0FBSyxTQUFTLEVBQUU7UUFBRSxPQUFPLFNBQVMsQ0FBQztLQUFFO0lBQzVDLE1BQU0sTUFBTSxHQUFHO1FBQ2IsTUFBTSxFQUFFLEdBQUcsQ0FBQyxJQUFJO1FBQ2hCLE1BQU0sRUFBRSxHQUFHLENBQUMsSUFBSTtRQUNoQixVQUFVLEVBQUUsR0FBRyxDQUFDLFFBQVE7S0FDekIsQ0FBQztJQUNGLDBCQUEwQjtJQUMxQixPQUFPLE1BQU0sQ0FBQyxPQUFPLENBQUMsTUFBTSxDQUFDLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEtBQUssU0FBUyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLEdBQUcsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQztBQUMxRyxDQUFDO0FBVEQsMERBU0M7Ozs7Ozs7QUFLRCxNQUFhLGFBQWMsU0FBUSxpQkFBUzs7Ozs7Ozs7O0lBZ0IxQyxZQUFtQixLQUFnQixFQUFFLEVBQVUsRUFBRSxRQUE0QixFQUFFO1FBQzdFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLGFBQWEsQ0FBQyxRQUFRLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQztJQUNsRCxDQUFDOzs7Ozs7Ozs7SUFWTSxNQUFNLENBQUMsUUFBUSxDQUFDLFFBQTRCLEVBQUU7UUFDbkQsT0FBTztZQUNMLEdBQUcsYUFBYSxDQUFDLEdBQUc7WUFDcEIsR0FBRyx5QkFBeUIsQ0FBQyxLQUFLLENBQUM7U0FDcEMsQ0FBQztJQUNKLENBQUM7O0FBYkgsc0NBbUJDOzs7Ozs7OztBQWpCd0IsaUJBQUcsR0FBcUI7SUFDN0MsVUFBVSxFQUFFLGtCQUFrQjtJQUM5QixJQUFJLEVBQUUsZUFBZTtDQUN0QixDQUFBO0FBNkJIOztHQUVHO0FBQ0gseUNBQXlDO0FBQ3pDLFNBQWdCLHlCQUF5QixDQUFDLEdBQW1DO0lBQzNFLElBQUksR0FBRyxLQUFLLFNBQVMsRUFBRTtRQUFFLE9BQU8sU0FBUyxDQUFDO0tBQUU7SUFDNUMsTUFBTSxNQUFNLEdBQUc7UUFDYixNQUFNLEVBQUUsR0FBRyxDQUFDLElBQUk7UUFDaEIsTUFBTSxFQUFFLEdBQUcsQ0FBQyxJQUFJO1FBQ2hCLFVBQVUsRUFBRSxHQUFHLENBQUMsUUFBUTtLQUN6QixDQUFDO0lBQ0YsMEJBQTBCO0lBQzFCLE9BQU8sTUFBTSxDQUFDLE9BQU8sQ0FBQyxNQUFNLENBQUMsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsS0FBSyxTQUFTLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsR0FBRyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDO0FBQzFHLENBQUM7QUFURCw4REFTQzs7Ozs7OztBQUtELE1BQWEsU0FBVSxTQUFRLGlCQUFTOzs7Ozs7Ozs7SUFnQnRDLFlBQW1CLEtBQWdCLEVBQUUsRUFBVSxFQUFFLFFBQXdCLEVBQUU7UUFDekUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsU0FBUyxDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDO0lBQzlDLENBQUM7Ozs7Ozs7OztJQVZNLE1BQU0sQ0FBQyxRQUFRLENBQUMsUUFBd0IsRUFBRTtRQUMvQyxPQUFPO1lBQ0wsR0FBRyxTQUFTLENBQUMsR0FBRztZQUNoQixHQUFHLHFCQUFxQixDQUFDLEtBQUssQ0FBQztTQUNoQyxDQUFDO0lBQ0osQ0FBQzs7QUFiSCw4QkFtQkM7Ozs7Ozs7O0FBakJ3QixhQUFHLEdBQXFCO0lBQzdDLFVBQVUsRUFBRSxrQkFBa0I7SUFDOUIsSUFBSSxFQUFFLFdBQVc7Q0FDbEIsQ0FBQTtBQTZCSDs7R0FFRztBQUNILHlDQUF5QztBQUN6QyxTQUFnQixxQkFBcUIsQ0FBQyxHQUErQjtJQUNuRSxJQUFJLEdBQUcsS0FBSyxTQUFTLEVBQUU7UUFBRSxPQUFPLFNBQVMsQ0FBQztLQUFFO0lBQzVDLE1BQU0sTUFBTSxHQUFHO1FBQ2IsTUFBTSxFQUFFLEdBQUcsQ0FBQyxJQUFJO1FBQ2hCLE1BQU0sRUFBRSxHQUFHLENBQUMsSUFBSTtRQUNoQixVQUFVLEVBQUUsR0FBRyxDQUFDLFFBQVE7S0FDekIsQ0FBQztJQUNGLDBCQUEwQjtJQUMxQixPQUFPLE1BQU0sQ0FBQyxPQUFPLENBQUMsTUFBTSxDQUFDLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEtBQUssU0FBUyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLEdBQUcsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQztBQUMxRyxDQUFDO0FBVEQsc0RBU0M7Ozs7Ozs7QUFLRCxNQUFhLEtBQU0sU0FBUSxpQkFBUzs7Ozs7Ozs7O0lBZ0JsQyxZQUFtQixLQUFnQixFQUFFLEVBQVUsRUFBRSxRQUFvQixFQUFFO1FBQ3JFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEtBQUssQ0FBQyxRQUFRLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQztJQUMxQyxDQUFDOzs7Ozs7Ozs7SUFWTSxNQUFNLENBQUMsUUFBUSxDQUFDLFFBQW9CLEVBQUU7UUFDM0MsT0FBTztZQUNMLEdBQUcsS0FBSyxDQUFDLEdBQUc7WUFDWixHQUFHLGlCQUFpQixDQUFDLEtBQUssQ0FBQztTQUM1QixDQUFDO0lBQ0osQ0FBQzs7QUFiSCxzQkFtQkM7Ozs7Ozs7O0FBakJ3QixTQUFHLEdBQXFCO0lBQzdDLFVBQVUsRUFBRSxrQkFBa0I7SUFDOUIsSUFBSSxFQUFFLE9BQU87Q0FDZCxDQUFBO0FBNkJIOztHQUVHO0FBQ0gseUNBQXlDO0FBQ3pDLFNBQWdCLGlCQUFpQixDQUFDLEdBQTJCO0lBQzNELElBQUksR0FBRyxLQUFLLFNBQVMsRUFBRTtRQUFFLE9BQU8sU0FBUyxDQUFDO0tBQUU7SUFDNUMsTUFBTSxNQUFNLEdBQUc7UUFDYixNQUFNLEVBQUUsR0FBRyxDQUFDLElBQUk7UUFDaEIsTUFBTSxFQUFFLEdBQUcsQ0FBQyxJQUFJO1FBQ2hCLFVBQVUsRUFBRSxHQUFHLENBQUMsUUFBUTtLQUN6QixDQUFDO0lBQ0YsMEJBQTBCO0lBQzFCLE9BQU8sTUFBTSxDQUFDLE9BQU8sQ0FBQyxNQUFNLENBQUMsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsS0FBSyxTQUFTLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsR0FBRyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDO0FBQzFHLENBQUM7QUFURCw4Q0FTQzs7Ozs7OztBQUtELE1BQWEsY0FBZSxTQUFRLGlCQUFTOzs7Ozs7Ozs7SUFnQjNDLFlBQW1CLEtBQWdCLEVBQUUsRUFBVSxFQUFFLFFBQTZCLEVBQUU7UUFDOUUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsY0FBYyxDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDO0lBQ25ELENBQUM7Ozs7Ozs7OztJQVZNLE1BQU0sQ0FBQyxRQUFRLENBQUMsUUFBNkIsRUFBRTtRQUNwRCxPQUFPO1lBQ0wsR0FBRyxjQUFjLENBQUMsR0FBRztZQUNyQixHQUFHLDBCQUEwQixDQUFDLEtBQUssQ0FBQztTQUNyQyxDQUFDO0lBQ0osQ0FBQzs7QUFiSCx3Q0FtQkM7Ozs7Ozs7O0FBakJ3QixrQkFBRyxHQUFxQjtJQUM3QyxVQUFVLEVBQUUsa0JBQWtCO0lBQzlCLElBQUksRUFBRSxnQkFBZ0I7Q0FDdkIsQ0FBQTtBQTZCSDs7R0FFRztBQUNILHlDQUF5QztBQUN6QyxTQUFnQiwwQkFBMEIsQ0FBQyxHQUFvQztJQUM3RSxJQUFJLEdBQUcsS0FBSyxTQUFTLEVBQUU7UUFBRSxPQUFPLFNBQVMsQ0FBQztLQUFFO0lBQzVDLE1BQU0sTUFBTSxHQUFHO1FBQ2IsTUFBTSxFQUFFLEdBQUcsQ0FBQyxJQUFJO1FBQ2hCLE1BQU0sRUFBRSxHQUFHLENBQUMsSUFBSTtRQUNoQixVQUFVLEVBQUUsR0FBRyxDQUFDLFFBQVE7S0FDekIsQ0FBQztJQUNGLDBCQUEwQjtJQUMxQixPQUFPLE1BQU0sQ0FBQyxPQUFPLENBQUMsTUFBTSxDQUFDLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEtBQUssU0FBUyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLEdBQUcsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQztBQUMxRyxDQUFDO0FBVEQsZ0VBU0M7Ozs7Ozs7QUFLRCxNQUFhLE9BQVEsU0FBUSxpQkFBUzs7Ozs7Ozs7O0lBZ0JwQyxZQUFtQixLQUFnQixFQUFFLEVBQVUsRUFBRSxRQUFzQixFQUFFO1FBQ3ZFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLE9BQU8sQ0FBQyxRQUFRLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQztJQUM1QyxDQUFDOzs7Ozs7Ozs7SUFWTSxNQUFNLENBQUMsUUFBUSxDQUFDLFFBQXNCLEVBQUU7UUFDN0MsT0FBTztZQUNMLEdBQUcsT0FBTyxDQUFDLEdBQUc7WUFDZCxHQUFHLG1CQUFtQixDQUFDLEtBQUssQ0FBQztTQUM5QixDQUFDO0lBQ0osQ0FBQzs7QUFiSCwwQkFtQkM7Ozs7Ozs7O0FBakJ3QixXQUFHLEdBQXFCO0lBQzdDLFVBQVUsRUFBRSxrQkFBa0I7SUFDOUIsSUFBSSxFQUFFLFNBQVM7Q0FDaEIsQ0FBQTtBQTZCSDs7R0FFRztBQUNILHlDQUF5QztBQUN6QyxTQUFnQixtQkFBbUIsQ0FBQyxHQUE2QjtJQUMvRCxJQUFJLEdBQUcsS0FBSyxTQUFTLEVBQUU7UUFBRSxPQUFPLFNBQVMsQ0FBQztLQUFFO0lBQzVDLE1BQU0sTUFBTSxHQUFHO1FBQ2IsTUFBTSxFQUFFLEdBQUcsQ0FBQyxJQUFJO1FBQ2hCLE1BQU0sRUFBRSxHQUFHLENBQUMsSUFBSTtRQUNoQixVQUFVLEVBQUUsR0FBRyxDQUFDLFFBQVE7S0FDekIsQ0FBQztJQUNGLDBCQUEwQjtJQUMxQixPQUFPLE1BQU0sQ0FBQyxPQUFPLENBQUMsTUFBTSxDQUFDLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEtBQUssU0FBUyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLEdBQUcsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQztBQUMxRyxDQUFDO0FBVEQsa0RBU0M7Ozs7Ozs7QUFLRCxNQUFhLFVBQVcsU0FBUSxpQkFBUzs7Ozs7Ozs7O0lBZ0J2QyxZQUFtQixLQUFnQixFQUFFLEVBQVUsRUFBRSxRQUF5QixFQUFFO1FBQzFFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLFVBQVUsQ0FBQyxRQUFRLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQztJQUMvQyxDQUFDOzs7Ozs7Ozs7SUFWTSxNQUFNLENBQUMsUUFBUSxDQUFDLFFBQXlCLEVBQUU7UUFDaEQsT0FBTztZQUNMLEdBQUcsVUFBVSxDQUFDLEdBQUc7WUFDakIsR0FBRyxzQkFBc0IsQ0FBQyxLQUFLLENBQUM7U0FDakMsQ0FBQztJQUNKLENBQUM7O0FBYkgsZ0NBbUJDOzs7Ozs7OztBQWpCd0IsY0FBRyxHQUFxQjtJQUM3QyxVQUFVLEVBQUUsa0JBQWtCO0lBQzlCLElBQUksRUFBRSxZQUFZO0NBQ25CLENBQUE7QUE2Qkg7O0dBRUc7QUFDSCx5Q0FBeUM7QUFDekMsU0FBZ0Isc0JBQXNCLENBQUMsR0FBZ0M7SUFDckUsSUFBSSxHQUFHLEtBQUssU0FBUyxFQUFFO1FBQUUsT0FBTyxTQUFTLENBQUM7S0FBRTtJQUM1QyxNQUFNLE1BQU0sR0FBRztRQUNiLE1BQU0sRUFBRSxHQUFHLENBQUMsSUFBSTtRQUNoQixNQUFNLEVBQUUsR0FBRyxDQUFDLElBQUk7UUFDaEIsVUFBVSxFQUFFLEdBQUcsQ0FBQyxRQUFRO0tBQ3pCLENBQUM7SUFDRiwwQkFBMEI7SUFDMUIsT0FBTyxNQUFNLENBQUMsT0FBTyxDQUFDLE1BQU0sQ0FBQyxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxLQUFLLFNBQVMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxHQUFHLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUM7QUFDMUcsQ0FBQztBQVRELHdEQVNDOzs7Ozs7O0FBS0QsTUFBYSxpQkFBa0IsU0FBUSxpQkFBUzs7Ozs7Ozs7O0lBZ0I5QyxZQUFtQixLQUFnQixFQUFFLEVBQVUsRUFBRSxRQUFnQyxFQUFFO1FBQ2pGLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLGlCQUFpQixDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDO0lBQ3RELENBQUM7Ozs7Ozs7OztJQVZNLE1BQU0sQ0FBQyxRQUFRLENBQUMsUUFBZ0MsRUFBRTtRQUN2RCxPQUFPO1lBQ0wsR0FBRyxpQkFBaUIsQ0FBQyxHQUFHO1lBQ3hCLEdBQUcsNkJBQTZCLENBQUMsS0FBSyxDQUFDO1NBQ3hDLENBQUM7SUFDSixDQUFDOztBQWJILDhDQW1CQzs7Ozs7Ozs7QUFqQndCLHFCQUFHLEdBQXFCO0lBQzdDLFVBQVUsRUFBRSxrQkFBa0I7SUFDOUIsSUFBSSxFQUFFLG1CQUFtQjtDQUMxQixDQUFBO0FBNkJIOztHQUVHO0FBQ0gseUNBQXlDO0FBQ3pDLFNBQWdCLDZCQUE2QixDQUFDLEdBQXVDO0lBQ25GLElBQUksR0FBRyxLQUFLLFNBQVMsRUFBRTtRQUFFLE9BQU8sU0FBUyxDQUFDO0tBQUU7SUFDNUMsTUFBTSxNQUFNLEdBQUc7UUFDYixNQUFNLEVBQUUsR0FBRyxDQUFDLElBQUk7UUFDaEIsTUFBTSxFQUFFLEdBQUcsQ0FBQyxJQUFJO1FBQ2hCLFVBQVUsRUFBRSxHQUFHLENBQUMsUUFBUTtLQUN6QixDQUFDO0lBQ0YsMEJBQTBCO0lBQzFCLE9BQU8sTUFBTSxDQUFDLE9BQU8sQ0FBQyxNQUFNLENBQUMsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsS0FBSyxTQUFTLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsR0FBRyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDO0FBQzFHLENBQUM7QUFURCxzRUFTQzs7Ozs7OztBQUtELE1BQWEsWUFBYSxTQUFRLGlCQUFTOzs7Ozs7Ozs7SUFnQnpDLFlBQW1CLEtBQWdCLEVBQUUsRUFBVSxFQUFFLFFBQTJCLEVBQUU7UUFDNUUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsWUFBWSxDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDO0lBQ2pELENBQUM7Ozs7Ozs7OztJQVZNLE1BQU0sQ0FBQyxRQUFRLENBQUMsUUFBMkIsRUFBRTtRQUNsRCxPQUFPO1lBQ0wsR0FBRyxZQUFZLENBQUMsR0FBRztZQUNuQixHQUFHLHdCQUF3QixDQUFDLEtBQUssQ0FBQztTQUNuQyxDQUFDO0lBQ0osQ0FBQzs7QUFiSCxvQ0FtQkM7Ozs7Ozs7O0FBakJ3QixnQkFBRyxHQUFxQjtJQUM3QyxVQUFVLEVBQUUsa0JBQWtCO0lBQzlCLElBQUksRUFBRSxjQUFjO0NBQ3JCLENBQUE7QUE2Qkg7O0dBRUc7QUFDSCx5Q0FBeUM7QUFDekMsU0FBZ0Isd0JBQXdCLENBQUMsR0FBa0M7SUFDekUsSUFBSSxHQUFHLEtBQUssU0FBUyxFQUFFO1FBQUUsT0FBTyxTQUFTLENBQUM7S0FBRTtJQUM1QyxNQUFNLE1BQU0sR0FBRztRQUNiLE1BQU0sRUFBRSxHQUFHLENBQUMsSUFBSTtRQUNoQixNQUFNLEVBQUUsR0FBRyxDQUFDLElBQUk7UUFDaEIsVUFBVSxFQUFFLEdBQUcsQ0FBQyxRQUFRO0tBQ3pCLENBQUM7SUFDRiwwQkFBMEI7SUFDMUIsT0FBTyxNQUFNLENBQUMsT0FBTyxDQUFDLE1BQU0sQ0FBQyxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxLQUFLLFNBQVMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxHQUFHLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUM7QUFDMUcsQ0FBQztBQVRELDREQVNDOzs7Ozs7O0FBS0QsTUFBYSxZQUFhLFNBQVEsaUJBQVM7Ozs7Ozs7OztJQWdCekMsWUFBbUIsS0FBZ0IsRUFBRSxFQUFVLEVBQUUsUUFBMkIsRUFBRTtRQUM1RSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxZQUFZLENBQUMsUUFBUSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUM7SUFDakQsQ0FBQzs7Ozs7Ozs7O0lBVk0sTUFBTSxDQUFDLFFBQVEsQ0FBQyxRQUEyQixFQUFFO1FBQ2xELE9BQU87WUFDTCxHQUFHLFlBQVksQ0FBQyxHQUFHO1lBQ25CLEdBQUcsd0JBQXdCLENBQUMsS0FBSyxDQUFDO1NBQ25DLENBQUM7SUFDSixDQUFDOztBQWJILG9DQW1CQzs7Ozs7Ozs7QUFqQndCLGdCQUFHLEdBQXFCO0lBQzdDLFVBQVUsRUFBRSxrQkFBa0I7SUFDOUIsSUFBSSxFQUFFLGNBQWM7Q0FDckIsQ0FBQTtBQTZCSDs7R0FFRztBQUNILHlDQUF5QztBQUN6QyxTQUFnQix3QkFBd0IsQ0FBQyxHQUFrQztJQUN6RSxJQUFJLEdBQUcsS0FBSyxTQUFTLEVBQUU7UUFBRSxPQUFPLFNBQVMsQ0FBQztLQUFFO0lBQzVDLE1BQU0sTUFBTSxHQUFHO1FBQ2IsTUFBTSxFQUFFLEdBQUcsQ0FBQyxJQUFJO1FBQ2hCLE1BQU0sRUFBRSxHQUFHLENBQUMsSUFBSTtRQUNoQixVQUFVLEVBQUUsR0FBRyxDQUFDLFFBQVE7S0FDekIsQ0FBQztJQUNGLDBCQUEwQjtJQUMxQixPQUFPLE1BQU0sQ0FBQyxPQUFPLENBQUMsTUFBTSxDQUFDLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEtBQUssU0FBUyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLEdBQUcsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQztBQUMxRyxDQUFDO0FBVEQsNERBU0M7Ozs7Ozs7QUFLRCxNQUFhLGVBQWdCLFNBQVEsaUJBQVM7Ozs7Ozs7OztJQWdCNUMsWUFBbUIsS0FBZ0IsRUFBRSxFQUFVLEVBQUUsUUFBOEIsRUFBRTtRQUMvRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxlQUFlLENBQUMsUUFBUSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUM7SUFDcEQsQ0FBQzs7Ozs7Ozs7O0lBVk0sTUFBTSxDQUFDLFFBQVEsQ0FBQyxRQUE4QixFQUFFO1FBQ3JELE9BQU87WUFDTCxHQUFHLGVBQWUsQ0FBQyxHQUFHO1lBQ3RCLEdBQUcsMkJBQTJCLENBQUMsS0FBSyxDQUFDO1NBQ3RDLENBQUM7SUFDSixDQUFDOztBQWJILDBDQW1CQzs7Ozs7Ozs7QUFqQndCLG1CQUFHLEdBQXFCO0lBQzdDLFVBQVUsRUFBRSxrQkFBa0I7SUFDOUIsSUFBSSxFQUFFLGlCQUFpQjtDQUN4QixDQUFBO0FBNkJIOztHQUVHO0FBQ0gseUNBQXlDO0FBQ3pDLFNBQWdCLDJCQUEyQixDQUFDLEdBQXFDO0lBQy9FLElBQUksR0FBRyxLQUFLLFNBQVMsRUFBRTtRQUFFLE9BQU8sU0FBUyxDQUFDO0tBQUU7SUFDNUMsTUFBTSxNQUFNLEdBQUc7UUFDYixNQUFNLEVBQUUsR0FBRyxDQUFDLElBQUk7UUFDaEIsTUFBTSxFQUFFLEdBQUcsQ0FBQyxJQUFJO1FBQ2hCLFVBQVUsRUFBRSxHQUFHLENBQUMsUUFBUTtLQUN6QixDQUFDO0lBQ0YsMEJBQTBCO0lBQzFCLE9BQU8sTUFBTSxDQUFDLE9BQU8sQ0FBQyxNQUFNLENBQUMsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsS0FBSyxTQUFTLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsR0FBRyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDO0FBQzFHLENBQUM7QUFURCxrRUFTQzs7Ozs7OztBQUtELE1BQWEsSUFBSyxTQUFRLGlCQUFTOzs7Ozs7Ozs7SUFnQmpDLFlBQW1CLEtBQWdCLEVBQUUsRUFBVSxFQUFFLFFBQW1CLEVBQUU7UUFDcEUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsSUFBSSxDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDO0lBQ3pDLENBQUM7Ozs7Ozs7OztJQVZNLE1BQU0sQ0FBQyxRQUFRLENBQUMsUUFBbUIsRUFBRTtRQUMxQyxPQUFPO1lBQ0wsR0FBRyxJQUFJLENBQUMsR0FBRztZQUNYLEdBQUcsZ0JBQWdCLENBQUMsS0FBSyxDQUFDO1NBQzNCLENBQUM7SUFDSixDQUFDOztBQWJILG9CQW1CQzs7Ozs7Ozs7QUFqQndCLFFBQUcsR0FBcUI7SUFDN0MsVUFBVSxFQUFFLGtCQUFrQjtJQUM5QixJQUFJLEVBQUUsTUFBTTtDQUNiLENBQUE7QUE2Qkg7O0dBRUc7QUFDSCx5Q0FBeUM7QUFDekMsU0FBZ0IsZ0JBQWdCLENBQUMsR0FBMEI7SUFDekQsSUFBSSxHQUFHLEtBQUssU0FBUyxFQUFFO1FBQUUsT0FBTyxTQUFTLENBQUM7S0FBRTtJQUM1QyxNQUFNLE1BQU0sR0FBRztRQUNiLE1BQU0sRUFBRSxHQUFHLENBQUMsSUFBSTtRQUNoQixNQUFNLEVBQUUsR0FBRyxDQUFDLElBQUk7UUFDaEIsVUFBVSxFQUFFLEdBQUcsQ0FBQyxRQUFRO0tBQ3pCLENBQUM7SUFDRiwwQkFBMEI7SUFDMUIsT0FBTyxNQUFNLENBQUMsT0FBTyxDQUFDLE1BQU0sQ0FBQyxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxLQUFLLFNBQVMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxHQUFHLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUM7QUFDMUcsQ0FBQztBQVRELDRDQVNDOzs7Ozs7O0FBS0QsTUFBYSxXQUFZLFNBQVEsaUJBQVM7Ozs7Ozs7OztJQWdCeEMsWUFBbUIsS0FBZ0IsRUFBRSxFQUFVLEVBQUUsUUFBMEIsRUFBRTtRQUMzRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxXQUFXLENBQUMsUUFBUSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUM7SUFDaEQsQ0FBQzs7Ozs7Ozs7O0lBVk0sTUFBTSxDQUFDLFFBQVEsQ0FBQyxRQUEwQixFQUFFO1FBQ2pELE9BQU87WUFDTCxHQUFHLFdBQVcsQ0FBQyxHQUFHO1lBQ2xCLEdBQUcsdUJBQXVCLENBQUMsS0FBSyxDQUFDO1NBQ2xDLENBQUM7SUFDSixDQUFDOztBQWJILGtDQW1CQzs7Ozs7Ozs7QUFqQndCLGVBQUcsR0FBcUI7SUFDN0MsVUFBVSxFQUFFLGtCQUFrQjtJQUM5QixJQUFJLEVBQUUsYUFBYTtDQUNwQixDQUFBO0FBNkJIOztHQUVHO0FBQ0gseUNBQXlDO0FBQ3pDLFNBQWdCLHVCQUF1QixDQUFDLEdBQWlDO0lBQ3ZFLElBQUksR0FBRyxLQUFLLFNBQVMsRUFBRTtRQUFFLE9BQU8sU0FBUyxDQUFDO0tBQUU7SUFDNUMsTUFBTSxNQUFNLEdBQUc7UUFDYixNQUFNLEVBQUUsR0FBRyxDQUFDLElBQUk7UUFDaEIsTUFBTSxFQUFFLEdBQUcsQ0FBQyxJQUFJO1FBQ2hCLFVBQVUsRUFBRSxHQUFHLENBQUMsUUFBUTtLQUN6QixDQUFDO0lBQ0YsMEJBQTBCO0lBQzFCLE9BQU8sTUFBTSxDQUFDLE9BQU8sQ0FBQyxNQUFNLENBQUMsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsS0FBSyxTQUFTLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsR0FBRyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDO0FBQzFHLENBQUM7QUFURCwwREFTQzs7Ozs7OztBQUtELE1BQWEsa0JBQW1CLFNBQVEsaUJBQVM7Ozs7Ozs7OztJQWdCL0MsWUFBbUIsS0FBZ0IsRUFBRSxFQUFVLEVBQUUsUUFBaUMsRUFBRTtRQUNsRixLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxrQkFBa0IsQ0FBQyxRQUFRLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQztJQUN2RCxDQUFDOzs7Ozs7Ozs7SUFWTSxNQUFNLENBQUMsUUFBUSxDQUFDLFFBQWlDLEVBQUU7UUFDeEQsT0FBTztZQUNMLEdBQUcsa0JBQWtCLENBQUMsR0FBRztZQUN6QixHQUFHLDhCQUE4QixDQUFDLEtBQUssQ0FBQztTQUN6QyxDQUFDO0lBQ0osQ0FBQzs7QUFiSCxnREFtQkM7Ozs7Ozs7O0FBakJ3QixzQkFBRyxHQUFxQjtJQUM3QyxVQUFVLEVBQUUsa0JBQWtCO0lBQzlCLElBQUksRUFBRSxvQkFBb0I7Q0FDM0IsQ0FBQTtBQTZCSDs7R0FFRztBQUNILHlDQUF5QztBQUN6QyxTQUFnQiw4QkFBOEIsQ0FBQyxHQUF3QztJQUNyRixJQUFJLEdBQUcsS0FBSyxTQUFTLEVBQUU7UUFBRSxPQUFPLFNBQVMsQ0FBQztLQUFFO0lBQzVDLE1BQU0sTUFBTSxHQUFHO1FBQ2IsTUFBTSxFQUFFLEdBQUcsQ0FBQyxJQUFJO1FBQ2hCLE1BQU0sRUFBRSxHQUFHLENBQUMsSUFBSTtRQUNoQixVQUFVLEVBQUUsR0FBRyxDQUFDLFFBQVE7S0FDekIsQ0FBQztJQUNGLDBCQUEwQjtJQUMxQixPQUFPLE1BQU0sQ0FBQyxPQUFPLENBQUMsTUFBTSxDQUFDLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEtBQUssU0FBUyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLEdBQUcsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQztBQUMxRyxDQUFDO0FBVEQsd0VBU0M7Ozs7Ozs7QUFLRCxNQUFhLFdBQVksU0FBUSxpQkFBUzs7Ozs7Ozs7O0lBZ0J4QyxZQUFtQixLQUFnQixFQUFFLEVBQVUsRUFBRSxRQUEwQixFQUFFO1FBQzNFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLFdBQVcsQ0FBQyxRQUFRLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQztJQUNoRCxDQUFDOzs7Ozs7Ozs7SUFWTSxNQUFNLENBQUMsUUFBUSxDQUFDLFFBQTBCLEVBQUU7UUFDakQsT0FBTztZQUNMLEdBQUcsV0FBVyxDQUFDLEdBQUc7WUFDbEIsR0FBRyx1QkFBdUIsQ0FBQyxLQUFLLENBQUM7U0FDbEMsQ0FBQztJQUNKLENBQUM7O0FBYkgsa0NBbUJDOzs7Ozs7OztBQWpCd0IsZUFBRyxHQUFxQjtJQUM3QyxVQUFVLEVBQUUsa0JBQWtCO0lBQzlCLElBQUksRUFBRSxhQUFhO0NBQ3BCLENBQUE7QUE2Qkg7O0dBRUc7QUFDSCx5Q0FBeUM7QUFDekMsU0FBZ0IsdUJBQXVCLENBQUMsR0FBaUM7SUFDdkUsSUFBSSxHQUFHLEtBQUssU0FBUyxFQUFFO1FBQUUsT0FBTyxTQUFTLENBQUM7S0FBRTtJQUM1QyxNQUFNLE1BQU0sR0FBRztRQUNiLE1BQU0sRUFBRSxHQUFHLENBQUMsSUFBSTtRQUNoQixNQUFNLEVBQUUsR0FBRyxDQUFDLElBQUk7UUFDaEIsVUFBVSxFQUFFLEdBQUcsQ0FBQyxRQUFRO0tBQ3pCLENBQUM7SUFDRiwwQkFBMEI7SUFDMUIsT0FBTyxNQUFNLENBQUMsT0FBTyxDQUFDLE1BQU0sQ0FBQyxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxLQUFLLFNBQVMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxHQUFHLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUM7QUFDMUcsQ0FBQztBQVRELDBEQVNDOzs7O0FBeUJELE1BQWEsSUFBSyxTQUFRLHNCQUFTOzs7O0lBQ2pDLFlBQVksS0FBZ0IsRUFBRSxJQUFZLEVBQUUsSUFBaUI7O1FBQzNELEtBQUssQ0FBQyxLQUFLLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFFbkIsTUFBTSxNQUFNLEdBQVUsRUFBRSxDQUFDO1FBRXpCLE1BQUEsSUFBSSxhQUFKLElBQUksdUJBQUosSUFBSSxDQUFFLGdCQUFnQiwwQ0FBRSxPQUFPLENBQUMsR0FBRyxDQUFDLEVBQUU7WUFDcEMsTUFBTSxDQUFDLElBQUksQ0FBQztnQkFDVixLQUFLLEVBQUU7b0JBQ0wsR0FBRyxFQUFFLEdBQUc7aUJBQ1Q7YUFDRixDQUFDLENBQUM7UUFDTCxDQUFDLEVBQUU7UUFFSCxNQUFBLElBQUksYUFBSixJQUFJLHVCQUFKLElBQUksQ0FBRSxnQkFBZ0IsMENBQUUsT0FBTyxDQUFDLEdBQUcsQ0FBQyxFQUFFO1lBQ3BDLE1BQU0sQ0FBQyxJQUFJLENBQUM7Z0JBQ1YsS0FBSyxFQUFFO29CQUNMLEdBQUcsRUFBRSxHQUFHO2lCQUNUO2FBQ0YsQ0FBQyxDQUFDO1FBQ0wsQ0FBQyxFQUFFO1FBRUgsSUFBSSxNQUFNLENBQUMsTUFBTSxHQUFHLENBQUMsRUFBRTtZQUNyQixJQUFJLGlCQUFpQixDQUFDLElBQUksRUFBRSxHQUFHLElBQUksVUFBVSxFQUFFO2dCQUM3QyxJQUFJLEVBQUUsSUFBSSxDQUFDLElBQUk7Z0JBQ2YsUUFBUSxFQUFFO29CQUNSLElBQUksRUFBRSxHQUFHLElBQUksVUFBVTtpQkFDeEI7Z0JBQ0QsSUFBSSxFQUFFO29CQUNKLFlBQVksRUFBRSxDQUFDOzRCQUNiLEtBQUssRUFBRTtnQ0FDTCxHQUFHLEVBQUUsSUFBSTs2QkFDVjt5QkFDRixDQUFDO29CQUNGLE9BQU8sRUFBRSxNQUFNO2lCQUNoQjthQUNGLENBQUMsQ0FBQztTQUNKO0lBQ0gsQ0FBQzs7QUF0Q0gsb0JBdUNDOzs7Ozs7QUFFRCxNQUFhLHdCQUF5QixTQUFRLHNCQUFTOzs7O0lBQ3JELFlBQVksS0FBZ0IsRUFBRSxJQUFZLEVBQUUsSUFBcUM7UUFDL0UsS0FBSyxDQUFDLEtBQUssRUFBRSxJQUFJLENBQUMsQ0FBQztRQUVuQixJQUFJLGVBQWUsQ0FBQyxJQUFJLEVBQUUsSUFBSSxFQUFFO1lBQzlCLElBQUksRUFBRSxJQUFJLENBQUMsSUFBSTtZQUNmLFFBQVEsRUFBRTtnQkFDUixJQUFJLEVBQUUsSUFBSSxDQUFDLFdBQVc7YUFDdkI7WUFDRCxJQUFJLEVBQUU7Z0JBQ0osSUFBSSxFQUFFO29CQUNKLGlCQUFpQixFQUFFLElBQUksQ0FBQyxXQUFXO29CQUNuQyxrQkFBa0IsRUFBRSxJQUFJLENBQUMsZUFBZTtpQkFDekM7Z0JBQ0QsVUFBVSxFQUFFO29CQUNWLE9BQU8sRUFBRSxJQUFJLENBQUMsY0FBYztvQkFDNUIsR0FBRyxFQUFFO3dCQUNILE9BQU8sRUFBRSxLQUFLO3FCQUNmO2lCQUNGO2FBQ0Y7U0FDRixDQUFDLENBQUM7SUFFTCxDQUFDOztBQXZCSCw0REF3QkM7Ozs7OztBQUVELE1BQWEsc0JBQXVCLFNBQVEsc0JBQVM7Ozs7SUFDbkQsWUFBWSxLQUFnQixFQUFFLElBQVksRUFBRSxJQUFnQzs7UUFDMUUsS0FBSyxDQUFDLEtBQUssRUFBRSxJQUFJLENBQUMsQ0FBQztRQUNuQixNQUFNLE9BQU8sR0FBVSxFQUFFLENBQUM7UUFFMUIsTUFBQSxJQUFJLENBQUMsT0FBTywwQ0FBRSxPQUFPLENBQUMsQ0FBQyxDQUFDLEVBQUU7WUFDeEIsT0FBTyxDQUFDLElBQUksQ0FBQztnQkFDWCxLQUFLLEVBQUU7b0JBQ0wsR0FBRyxFQUFFLENBQUM7aUJBQ1A7YUFDRixDQUFDLENBQUM7UUFDTCxDQUFDLEVBQUU7UUFFSCxNQUFNLGdCQUFnQixHQUFHLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLENBQUMsQ0FBQyxpQkFBaUIsQ0FBQztRQUUzRixJQUFJLGlCQUFpQixDQUFDLElBQUksRUFBRSxJQUFJLEVBQUU7WUFDaEMsSUFBSSxFQUFFLElBQUksQ0FBQyxJQUFJO1lBQ2YsUUFBUSxFQUFFO2dCQUNSLElBQUksRUFBRSxJQUFJO2FBQ1g7WUFDRCxJQUFJLEVBQUU7Z0JBQ0osWUFBWSxFQUFFLENBQUM7d0JBQ2IsS0FBSyxFQUFFOzRCQUNMLENBQUMsZ0JBQWdCLENBQUMsRUFBRSxJQUFJLENBQUMsV0FBVzt5QkFDckM7cUJBQ0YsQ0FBQztnQkFDRixPQUFPLEVBQUUsT0FBTzthQUNqQjtTQUNGLENBQUMsQ0FBQztJQUVMLENBQUM7O0FBOUJILHdEQStCQyIsInNvdXJjZXNDb250ZW50IjpbIi8vIGdlbmVyYXRlZCBieSBjZGs4c1xuaW1wb3J0IHsgQXBpT2JqZWN0LCBBcGlPYmplY3RNZXRhZGF0YSwgR3JvdXBWZXJzaW9uS2luZCB9IGZyb20gJ2NkazhzJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuXG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgQ2lyY3VpdEJyZWFrZXIgZXh0ZW5kcyBBcGlPYmplY3Qge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgR1ZLOiBHcm91cFZlcnNpb25LaW5kID0ge1xuICAgIGFwaVZlcnNpb246ICdrdW1hLmlvL3YxYWxwaGExJyxcbiAgICBraW5kOiAnQ2lyY3VpdEJyZWFrZXInLFxuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgc3RhdGljIG1hbmlmZXN0KHByb3BzOiBDaXJjdWl0QnJlYWtlclByb3BzID0ge30pOiBhbnkge1xuICAgIHJldHVybiB7XG4gICAgICAuLi5DaXJjdWl0QnJlYWtlci5HVkssXG4gICAgICAuLi50b0pzb25fQ2lyY3VpdEJyZWFrZXJQcm9wcyhwcm9wcyksXG4gICAgfTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBDaXJjdWl0QnJlYWtlclByb3BzID0ge30pIHtcbiAgICBzdXBlcihzY29wZSwgaWQsIENpcmN1aXRCcmVha2VyLm1hbmlmZXN0KHByb3BzKSk7XG4gIH1cbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgQ2lyY3VpdEJyZWFrZXJQcm9wcyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBtZXNoPzogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBzcGVjPzogYW55O1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgbWV0YWRhdGE/OiBBcGlPYmplY3RNZXRhZGF0YTtcblxufVxuXG4vKipcbiAqIENvbnZlcnRzIGFuIG9iamVjdCBvZiB0eXBlICdDaXJjdWl0QnJlYWtlclByb3BzJyB0byBKU09OIHJlcHJlc2VudGF0aW9uLlxuICovXG4vKiBlc2xpbnQtZGlzYWJsZSBtYXgtbGVuLCBxdW90ZS1wcm9wcyAqL1xuZXhwb3J0IGZ1bmN0aW9uIHRvSnNvbl9DaXJjdWl0QnJlYWtlclByb3BzKG9iajogQ2lyY3VpdEJyZWFrZXJQcm9wcyB8IHVuZGVmaW5lZCk6IFJlY29yZDxzdHJpbmcsIGFueT4gfCB1bmRlZmluZWQge1xuICBpZiAob2JqID09PSB1bmRlZmluZWQpIHsgcmV0dXJuIHVuZGVmaW5lZDsgfVxuICBjb25zdCByZXN1bHQgPSB7XG4gICAgJ21lc2gnOiBvYmoubWVzaCxcbiAgICAnc3BlYyc6IG9iai5zcGVjLFxuICAgICdtZXRhZGF0YSc6IG9iai5tZXRhZGF0YSxcbiAgfTtcbiAgLy8gZmlsdGVyIHVuZGVmaW5lZCB2YWx1ZXNcbiAgcmV0dXJuIE9iamVjdC5lbnRyaWVzKHJlc3VsdCkucmVkdWNlKChyLCBpKSA9PiAoaVsxXSA9PT0gdW5kZWZpbmVkKSA/IHIgOiAoeyAuLi5yLCBbaVswXV06IGlbMV0gfSksIHt9KTtcbn1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcblxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBEYXRhcGxhbmUgZXh0ZW5kcyBBcGlPYmplY3Qge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEdWSzogR3JvdXBWZXJzaW9uS2luZCA9IHtcbiAgICBhcGlWZXJzaW9uOiAna3VtYS5pby92MWFscGhhMScsXG4gICAga2luZDogJ0RhdGFwbGFuZScsXG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgc3RhdGljIG1hbmlmZXN0KHByb3BzOiBEYXRhcGxhbmVQcm9wcyA9IHt9KTogYW55IHtcbiAgICByZXR1cm4ge1xuICAgICAgLi4uRGF0YXBsYW5lLkdWSyxcbiAgICAgIC4uLnRvSnNvbl9EYXRhcGxhbmVQcm9wcyhwcm9wcyksXG4gICAgfTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogRGF0YXBsYW5lUHJvcHMgPSB7fSkge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwgRGF0YXBsYW5lLm1hbmlmZXN0KHByb3BzKSk7XG4gIH1cbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIERhdGFwbGFuZVByb3BzIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBtZXNoPzogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgc3BlYz86IGFueTtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBtZXRhZGF0YT86IEFwaU9iamVjdE1ldGFkYXRhO1xuXG59XG5cbi8qKlxuICogQ29udmVydHMgYW4gb2JqZWN0IG9mIHR5cGUgJ0RhdGFwbGFuZVByb3BzJyB0byBKU09OIHJlcHJlc2VudGF0aW9uLlxuICovXG4vKiBlc2xpbnQtZGlzYWJsZSBtYXgtbGVuLCBxdW90ZS1wcm9wcyAqL1xuZXhwb3J0IGZ1bmN0aW9uIHRvSnNvbl9EYXRhcGxhbmVQcm9wcyhvYmo6IERhdGFwbGFuZVByb3BzIHwgdW5kZWZpbmVkKTogUmVjb3JkPHN0cmluZywgYW55PiB8IHVuZGVmaW5lZCB7XG4gIGlmIChvYmogPT09IHVuZGVmaW5lZCkgeyByZXR1cm4gdW5kZWZpbmVkOyB9XG4gIGNvbnN0IHJlc3VsdCA9IHtcbiAgICAnbWVzaCc6IG9iai5tZXNoLFxuICAgICdzcGVjJzogb2JqLnNwZWMsXG4gICAgJ21ldGFkYXRhJzogb2JqLm1ldGFkYXRhLFxuICB9O1xuICAvLyBmaWx0ZXIgdW5kZWZpbmVkIHZhbHVlc1xuICByZXR1cm4gT2JqZWN0LmVudHJpZXMocmVzdWx0KS5yZWR1Y2UoKHIsIGkpID0+IChpWzFdID09PSB1bmRlZmluZWQpID8gciA6ICh7IC4uLnIsIFtpWzBdXTogaVsxXSB9KSwge30pO1xufVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuXG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBEYXRhcGxhbmVJbnNpZ2h0IGV4dGVuZHMgQXBpT2JqZWN0IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgR1ZLOiBHcm91cFZlcnNpb25LaW5kID0ge1xuICAgIGFwaVZlcnNpb246ICdrdW1hLmlvL3YxYWxwaGExJyxcbiAgICBraW5kOiAnRGF0YXBsYW5lSW5zaWdodCcsXG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0YXRpYyBtYW5pZmVzdChwcm9wczogRGF0YXBsYW5lSW5zaWdodFByb3BzID0ge30pOiBhbnkge1xuICAgIHJldHVybiB7XG4gICAgICAuLi5EYXRhcGxhbmVJbnNpZ2h0LkdWSyxcbiAgICAgIC4uLnRvSnNvbl9EYXRhcGxhbmVJbnNpZ2h0UHJvcHMocHJvcHMpLFxuICAgIH07XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBEYXRhcGxhbmVJbnNpZ2h0UHJvcHMgPSB7fSkge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwgRGF0YXBsYW5lSW5zaWdodC5tYW5pZmVzdChwcm9wcykpO1xuICB9XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgRGF0YXBsYW5lSW5zaWdodFByb3BzIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgbWVzaD86IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgbWV0YWRhdGE/OiBBcGlPYmplY3RNZXRhZGF0YTtcblxufVxuXG4vKipcbiAqIENvbnZlcnRzIGFuIG9iamVjdCBvZiB0eXBlICdEYXRhcGxhbmVJbnNpZ2h0UHJvcHMnIHRvIEpTT04gcmVwcmVzZW50YXRpb24uXG4gKi9cbi8qIGVzbGludC1kaXNhYmxlIG1heC1sZW4sIHF1b3RlLXByb3BzICovXG5leHBvcnQgZnVuY3Rpb24gdG9Kc29uX0RhdGFwbGFuZUluc2lnaHRQcm9wcyhvYmo6IERhdGFwbGFuZUluc2lnaHRQcm9wcyB8IHVuZGVmaW5lZCk6IFJlY29yZDxzdHJpbmcsIGFueT4gfCB1bmRlZmluZWQge1xuICBpZiAob2JqID09PSB1bmRlZmluZWQpIHsgcmV0dXJuIHVuZGVmaW5lZDsgfVxuICBjb25zdCByZXN1bHQgPSB7XG4gICAgJ21lc2gnOiBvYmoubWVzaCxcbiAgICAnbWV0YWRhdGEnOiBvYmoubWV0YWRhdGEsXG4gIH07XG4gIC8vIGZpbHRlciB1bmRlZmluZWQgdmFsdWVzXG4gIHJldHVybiBPYmplY3QuZW50cmllcyhyZXN1bHQpLnJlZHVjZSgociwgaSkgPT4gKGlbMV0gPT09IHVuZGVmaW5lZCkgPyByIDogKHsgLi4uciwgW2lbMF1dOiBpWzFdIH0pLCB7fSk7XG59XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIEV4dGVybmFsU2VydmljZSBleHRlbmRzIEFwaU9iamVjdCB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgR1ZLOiBHcm91cFZlcnNpb25LaW5kID0ge1xuICAgIGFwaVZlcnNpb246ICdrdW1hLmlvL3YxYWxwaGExJyxcbiAgICBraW5kOiAnRXh0ZXJuYWxTZXJ2aWNlJyxcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBzdGF0aWMgbWFuaWZlc3QocHJvcHM6IEV4dGVybmFsU2VydmljZVByb3BzID0ge30pOiBhbnkge1xuICAgIHJldHVybiB7XG4gICAgICAuLi5FeHRlcm5hbFNlcnZpY2UuR1ZLLFxuICAgICAgLi4udG9Kc29uX0V4dGVybmFsU2VydmljZVByb3BzKHByb3BzKSxcbiAgICB9O1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBFeHRlcm5hbFNlcnZpY2VQcm9wcyA9IHt9KSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCBFeHRlcm5hbFNlcnZpY2UubWFuaWZlc3QocHJvcHMpKTtcbiAgfVxufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIEV4dGVybmFsU2VydmljZVByb3BzIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBtZXNoPzogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgc3BlYz86IGFueTtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBtZXRhZGF0YT86IEFwaU9iamVjdE1ldGFkYXRhO1xuXG59XG5cbi8qKlxuICogQ29udmVydHMgYW4gb2JqZWN0IG9mIHR5cGUgJ0V4dGVybmFsU2VydmljZVByb3BzJyB0byBKU09OIHJlcHJlc2VudGF0aW9uLlxuICovXG4vKiBlc2xpbnQtZGlzYWJsZSBtYXgtbGVuLCBxdW90ZS1wcm9wcyAqL1xuZXhwb3J0IGZ1bmN0aW9uIHRvSnNvbl9FeHRlcm5hbFNlcnZpY2VQcm9wcyhvYmo6IEV4dGVybmFsU2VydmljZVByb3BzIHwgdW5kZWZpbmVkKTogUmVjb3JkPHN0cmluZywgYW55PiB8IHVuZGVmaW5lZCB7XG4gIGlmIChvYmogPT09IHVuZGVmaW5lZCkgeyByZXR1cm4gdW5kZWZpbmVkOyB9XG4gIGNvbnN0IHJlc3VsdCA9IHtcbiAgICAnbWVzaCc6IG9iai5tZXNoLFxuICAgICdzcGVjJzogb2JqLnNwZWMsXG4gICAgJ21ldGFkYXRhJzogb2JqLm1ldGFkYXRhLFxuICB9O1xuICAvLyBmaWx0ZXIgdW5kZWZpbmVkIHZhbHVlc1xuICByZXR1cm4gT2JqZWN0LmVudHJpZXMocmVzdWx0KS5yZWR1Y2UoKHIsIGkpID0+IChpWzFdID09PSB1bmRlZmluZWQpID8gciA6ICh7IC4uLnIsIFtpWzBdXTogaVsxXSB9KSwge30pO1xufVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuXG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIEZhdWx0SW5qZWN0aW9uIGV4dGVuZHMgQXBpT2JqZWN0IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEdWSzogR3JvdXBWZXJzaW9uS2luZCA9IHtcbiAgICBhcGlWZXJzaW9uOiAna3VtYS5pby92MWFscGhhMScsXG4gICAga2luZDogJ0ZhdWx0SW5qZWN0aW9uJyxcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0YXRpYyBtYW5pZmVzdChwcm9wczogRmF1bHRJbmplY3Rpb25Qcm9wcyA9IHt9KTogYW55IHtcbiAgICByZXR1cm4ge1xuICAgICAgLi4uRmF1bHRJbmplY3Rpb24uR1ZLLFxuICAgICAgLi4udG9Kc29uX0ZhdWx0SW5qZWN0aW9uUHJvcHMocHJvcHMpLFxuICAgIH07XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogRmF1bHRJbmplY3Rpb25Qcm9wcyA9IHt9KSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCBGYXVsdEluamVjdGlvbi5tYW5pZmVzdChwcm9wcykpO1xuICB9XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBGYXVsdEluamVjdGlvblByb3BzIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IG1lc2g/OiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHNwZWM/OiBhbnk7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBtZXRhZGF0YT86IEFwaU9iamVjdE1ldGFkYXRhO1xuXG59XG5cbi8qKlxuICogQ29udmVydHMgYW4gb2JqZWN0IG9mIHR5cGUgJ0ZhdWx0SW5qZWN0aW9uUHJvcHMnIHRvIEpTT04gcmVwcmVzZW50YXRpb24uXG4gKi9cbi8qIGVzbGludC1kaXNhYmxlIG1heC1sZW4sIHF1b3RlLXByb3BzICovXG5leHBvcnQgZnVuY3Rpb24gdG9Kc29uX0ZhdWx0SW5qZWN0aW9uUHJvcHMob2JqOiBGYXVsdEluamVjdGlvblByb3BzIHwgdW5kZWZpbmVkKTogUmVjb3JkPHN0cmluZywgYW55PiB8IHVuZGVmaW5lZCB7XG4gIGlmIChvYmogPT09IHVuZGVmaW5lZCkgeyByZXR1cm4gdW5kZWZpbmVkOyB9XG4gIGNvbnN0IHJlc3VsdCA9IHtcbiAgICAnbWVzaCc6IG9iai5tZXNoLFxuICAgICdzcGVjJzogb2JqLnNwZWMsXG4gICAgJ21ldGFkYXRhJzogb2JqLm1ldGFkYXRhLFxuICB9O1xuICAvLyBmaWx0ZXIgdW5kZWZpbmVkIHZhbHVlc1xuICByZXR1cm4gT2JqZWN0LmVudHJpZXMocmVzdWx0KS5yZWR1Y2UoKHIsIGkpID0+IChpWzFdID09PSB1bmRlZmluZWQpID8gciA6ICh7IC4uLnIsIFtpWzBdXTogaVsxXSB9KSwge30pO1xufVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuXG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIEhlYWx0aENoZWNrIGV4dGVuZHMgQXBpT2JqZWN0IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEdWSzogR3JvdXBWZXJzaW9uS2luZCA9IHtcbiAgICBhcGlWZXJzaW9uOiAna3VtYS5pby92MWFscGhhMScsXG4gICAga2luZDogJ0hlYWx0aENoZWNrJyxcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0YXRpYyBtYW5pZmVzdChwcm9wczogSGVhbHRoQ2hlY2tQcm9wcyA9IHt9KTogYW55IHtcbiAgICByZXR1cm4ge1xuICAgICAgLi4uSGVhbHRoQ2hlY2suR1ZLLFxuICAgICAgLi4udG9Kc29uX0hlYWx0aENoZWNrUHJvcHMocHJvcHMpLFxuICAgIH07XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogSGVhbHRoQ2hlY2tQcm9wcyA9IHt9KSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCBIZWFsdGhDaGVjay5tYW5pZmVzdChwcm9wcykpO1xuICB9XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBIZWFsdGhDaGVja1Byb3BzIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IG1lc2g/OiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHNwZWM/OiBhbnk7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBtZXRhZGF0YT86IEFwaU9iamVjdE1ldGFkYXRhO1xuXG59XG5cbi8qKlxuICogQ29udmVydHMgYW4gb2JqZWN0IG9mIHR5cGUgJ0hlYWx0aENoZWNrUHJvcHMnIHRvIEpTT04gcmVwcmVzZW50YXRpb24uXG4gKi9cbi8qIGVzbGludC1kaXNhYmxlIG1heC1sZW4sIHF1b3RlLXByb3BzICovXG5leHBvcnQgZnVuY3Rpb24gdG9Kc29uX0hlYWx0aENoZWNrUHJvcHMob2JqOiBIZWFsdGhDaGVja1Byb3BzIHwgdW5kZWZpbmVkKTogUmVjb3JkPHN0cmluZywgYW55PiB8IHVuZGVmaW5lZCB7XG4gIGlmIChvYmogPT09IHVuZGVmaW5lZCkgeyByZXR1cm4gdW5kZWZpbmVkOyB9XG4gIGNvbnN0IHJlc3VsdCA9IHtcbiAgICAnbWVzaCc6IG9iai5tZXNoLFxuICAgICdzcGVjJzogb2JqLnNwZWMsXG4gICAgJ21ldGFkYXRhJzogb2JqLm1ldGFkYXRhLFxuICB9O1xuICAvLyBmaWx0ZXIgdW5kZWZpbmVkIHZhbHVlc1xuICByZXR1cm4gT2JqZWN0LmVudHJpZXMocmVzdWx0KS5yZWR1Y2UoKHIsIGkpID0+IChpWzFdID09PSB1bmRlZmluZWQpID8gciA6ICh7IC4uLnIsIFtpWzBdXTogaVsxXSB9KSwge30pO1xufVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuXG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBNZXNoIGV4dGVuZHMgQXBpT2JqZWN0IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgR1ZLOiBHcm91cFZlcnNpb25LaW5kID0ge1xuICAgIGFwaVZlcnNpb246ICdrdW1hLmlvL3YxYWxwaGExJyxcbiAgICBraW5kOiAnTWVzaCcsXG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0YXRpYyBtYW5pZmVzdChwcm9wczogTWVzaFByb3BzID0ge30pOiBhbnkge1xuICAgIHJldHVybiB7XG4gICAgICAuLi5NZXNoLkdWSyxcbiAgICAgIC4uLnRvSnNvbl9NZXNoUHJvcHMocHJvcHMpLFxuICAgIH07XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBNZXNoUHJvcHMgPSB7fSkge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwgTWVzaC5tYW5pZmVzdChwcm9wcykpO1xuICB9XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgTWVzaFByb3BzIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgc3BlYz86IGFueTtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgbWV0YWRhdGE/OiBBcGlPYmplY3RNZXRhZGF0YTtcblxufVxuXG4vKipcbiAqIENvbnZlcnRzIGFuIG9iamVjdCBvZiB0eXBlICdNZXNoUHJvcHMnIHRvIEpTT04gcmVwcmVzZW50YXRpb24uXG4gKi9cbi8qIGVzbGludC1kaXNhYmxlIG1heC1sZW4sIHF1b3RlLXByb3BzICovXG5leHBvcnQgZnVuY3Rpb24gdG9Kc29uX01lc2hQcm9wcyhvYmo6IE1lc2hQcm9wcyB8IHVuZGVmaW5lZCk6IFJlY29yZDxzdHJpbmcsIGFueT4gfCB1bmRlZmluZWQge1xuICBpZiAob2JqID09PSB1bmRlZmluZWQpIHsgcmV0dXJuIHVuZGVmaW5lZDsgfVxuICBjb25zdCByZXN1bHQgPSB7XG4gICAgJ3NwZWMnOiBvYmouc3BlYyxcbiAgICAnbWV0YWRhdGEnOiBvYmoubWV0YWRhdGEsXG4gIH07XG4gIC8vIGZpbHRlciB1bmRlZmluZWQgdmFsdWVzXG4gIHJldHVybiBPYmplY3QuZW50cmllcyhyZXN1bHQpLnJlZHVjZSgociwgaSkgPT4gKGlbMV0gPT09IHVuZGVmaW5lZCkgPyByIDogKHsgLi4uciwgW2lbMF1dOiBpWzFdIH0pLCB7fSk7XG59XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgTWVzaEluc2lnaHQgZXh0ZW5kcyBBcGlPYmplY3Qge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgR1ZLOiBHcm91cFZlcnNpb25LaW5kID0ge1xuICAgIGFwaVZlcnNpb246ICdrdW1hLmlvL3YxYWxwaGExJyxcbiAgICBraW5kOiAnTWVzaEluc2lnaHQnLFxuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgc3RhdGljIG1hbmlmZXN0KHByb3BzOiBNZXNoSW5zaWdodFByb3BzID0ge30pOiBhbnkge1xuICAgIHJldHVybiB7XG4gICAgICAuLi5NZXNoSW5zaWdodC5HVkssXG4gICAgICAuLi50b0pzb25fTWVzaEluc2lnaHRQcm9wcyhwcm9wcyksXG4gICAgfTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBNZXNoSW5zaWdodFByb3BzID0ge30pIHtcbiAgICBzdXBlcihzY29wZSwgaWQsIE1lc2hJbnNpZ2h0Lm1hbmlmZXN0KHByb3BzKSk7XG4gIH1cbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIE1lc2hJbnNpZ2h0UHJvcHMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgbWVzaD86IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgc3BlYz86IGFueTtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IG1ldGFkYXRhPzogQXBpT2JqZWN0TWV0YWRhdGE7XG5cbn1cblxuLyoqXG4gKiBDb252ZXJ0cyBhbiBvYmplY3Qgb2YgdHlwZSAnTWVzaEluc2lnaHRQcm9wcycgdG8gSlNPTiByZXByZXNlbnRhdGlvbi5cbiAqL1xuLyogZXNsaW50LWRpc2FibGUgbWF4LWxlbiwgcXVvdGUtcHJvcHMgKi9cbmV4cG9ydCBmdW5jdGlvbiB0b0pzb25fTWVzaEluc2lnaHRQcm9wcyhvYmo6IE1lc2hJbnNpZ2h0UHJvcHMgfCB1bmRlZmluZWQpOiBSZWNvcmQ8c3RyaW5nLCBhbnk+IHwgdW5kZWZpbmVkIHtcbiAgaWYgKG9iaiA9PT0gdW5kZWZpbmVkKSB7IHJldHVybiB1bmRlZmluZWQ7IH1cbiAgY29uc3QgcmVzdWx0ID0ge1xuICAgICdtZXNoJzogb2JqLm1lc2gsXG4gICAgJ3NwZWMnOiBvYmouc3BlYyxcbiAgICAnbWV0YWRhdGEnOiBvYmoubWV0YWRhdGEsXG4gIH07XG4gIC8vIGZpbHRlciB1bmRlZmluZWQgdmFsdWVzXG4gIHJldHVybiBPYmplY3QuZW50cmllcyhyZXN1bHQpLnJlZHVjZSgociwgaSkgPT4gKGlbMV0gPT09IHVuZGVmaW5lZCkgPyByIDogKHsgLi4uciwgW2lbMF1dOiBpWzFdIH0pLCB7fSk7XG59XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgUHJveHlUZW1wbGF0ZSBleHRlbmRzIEFwaU9iamVjdCB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEdWSzogR3JvdXBWZXJzaW9uS2luZCA9IHtcbiAgICBhcGlWZXJzaW9uOiAna3VtYS5pby92MWFscGhhMScsXG4gICAga2luZDogJ1Byb3h5VGVtcGxhdGUnLFxuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBzdGF0aWMgbWFuaWZlc3QocHJvcHM6IFByb3h5VGVtcGxhdGVQcm9wcyA9IHt9KTogYW55IHtcbiAgICByZXR1cm4ge1xuICAgICAgLi4uUHJveHlUZW1wbGF0ZS5HVkssXG4gICAgICAuLi50b0pzb25fUHJveHlUZW1wbGF0ZVByb3BzKHByb3BzKSxcbiAgICB9O1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogUHJveHlUZW1wbGF0ZVByb3BzID0ge30pIHtcbiAgICBzdXBlcihzY29wZSwgaWQsIFByb3h5VGVtcGxhdGUubWFuaWZlc3QocHJvcHMpKTtcbiAgfVxufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgUHJveHlUZW1wbGF0ZVByb3BzIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgbWVzaD86IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBzcGVjPzogYW55O1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBtZXRhZGF0YT86IEFwaU9iamVjdE1ldGFkYXRhO1xuXG59XG5cbi8qKlxuICogQ29udmVydHMgYW4gb2JqZWN0IG9mIHR5cGUgJ1Byb3h5VGVtcGxhdGVQcm9wcycgdG8gSlNPTiByZXByZXNlbnRhdGlvbi5cbiAqL1xuLyogZXNsaW50LWRpc2FibGUgbWF4LWxlbiwgcXVvdGUtcHJvcHMgKi9cbmV4cG9ydCBmdW5jdGlvbiB0b0pzb25fUHJveHlUZW1wbGF0ZVByb3BzKG9iajogUHJveHlUZW1wbGF0ZVByb3BzIHwgdW5kZWZpbmVkKTogUmVjb3JkPHN0cmluZywgYW55PiB8IHVuZGVmaW5lZCB7XG4gIGlmIChvYmogPT09IHVuZGVmaW5lZCkgeyByZXR1cm4gdW5kZWZpbmVkOyB9XG4gIGNvbnN0IHJlc3VsdCA9IHtcbiAgICAnbWVzaCc6IG9iai5tZXNoLFxuICAgICdzcGVjJzogb2JqLnNwZWMsXG4gICAgJ21ldGFkYXRhJzogb2JqLm1ldGFkYXRhLFxuICB9O1xuICAvLyBmaWx0ZXIgdW5kZWZpbmVkIHZhbHVlc1xuICByZXR1cm4gT2JqZWN0LmVudHJpZXMocmVzdWx0KS5yZWR1Y2UoKHIsIGkpID0+IChpWzFdID09PSB1bmRlZmluZWQpID8gciA6ICh7IC4uLnIsIFtpWzBdXTogaVsxXSB9KSwge30pO1xufVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuXG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIFJhdGVMaW1pdCBleHRlbmRzIEFwaU9iamVjdCB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgR1ZLOiBHcm91cFZlcnNpb25LaW5kID0ge1xuICAgIGFwaVZlcnNpb246ICdrdW1hLmlvL3YxYWxwaGExJyxcbiAgICBraW5kOiAnUmF0ZUxpbWl0JyxcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBzdGF0aWMgbWFuaWZlc3QocHJvcHM6IFJhdGVMaW1pdFByb3BzID0ge30pOiBhbnkge1xuICAgIHJldHVybiB7XG4gICAgICAuLi5SYXRlTGltaXQuR1ZLLFxuICAgICAgLi4udG9Kc29uX1JhdGVMaW1pdFByb3BzKHByb3BzKSxcbiAgICB9O1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBSYXRlTGltaXRQcm9wcyA9IHt9KSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCBSYXRlTGltaXQubWFuaWZlc3QocHJvcHMpKTtcbiAgfVxufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgUmF0ZUxpbWl0UHJvcHMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IG1lc2g/OiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBzcGVjPzogYW55O1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IG1ldGFkYXRhPzogQXBpT2JqZWN0TWV0YWRhdGE7XG5cbn1cblxuLyoqXG4gKiBDb252ZXJ0cyBhbiBvYmplY3Qgb2YgdHlwZSAnUmF0ZUxpbWl0UHJvcHMnIHRvIEpTT04gcmVwcmVzZW50YXRpb24uXG4gKi9cbi8qIGVzbGludC1kaXNhYmxlIG1heC1sZW4sIHF1b3RlLXByb3BzICovXG5leHBvcnQgZnVuY3Rpb24gdG9Kc29uX1JhdGVMaW1pdFByb3BzKG9iajogUmF0ZUxpbWl0UHJvcHMgfCB1bmRlZmluZWQpOiBSZWNvcmQ8c3RyaW5nLCBhbnk+IHwgdW5kZWZpbmVkIHtcbiAgaWYgKG9iaiA9PT0gdW5kZWZpbmVkKSB7IHJldHVybiB1bmRlZmluZWQ7IH1cbiAgY29uc3QgcmVzdWx0ID0ge1xuICAgICdtZXNoJzogb2JqLm1lc2gsXG4gICAgJ3NwZWMnOiBvYmouc3BlYyxcbiAgICAnbWV0YWRhdGEnOiBvYmoubWV0YWRhdGEsXG4gIH07XG4gIC8vIGZpbHRlciB1bmRlZmluZWQgdmFsdWVzXG4gIHJldHVybiBPYmplY3QuZW50cmllcyhyZXN1bHQpLnJlZHVjZSgociwgaSkgPT4gKGlbMV0gPT09IHVuZGVmaW5lZCkgPyByIDogKHsgLi4uciwgW2lbMF1dOiBpWzFdIH0pLCB7fSk7XG59XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIFJldHJ5IGV4dGVuZHMgQXBpT2JqZWN0IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEdWSzogR3JvdXBWZXJzaW9uS2luZCA9IHtcbiAgICBhcGlWZXJzaW9uOiAna3VtYS5pby92MWFscGhhMScsXG4gICAga2luZDogJ1JldHJ5JyxcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0YXRpYyBtYW5pZmVzdChwcm9wczogUmV0cnlQcm9wcyA9IHt9KTogYW55IHtcbiAgICByZXR1cm4ge1xuICAgICAgLi4uUmV0cnkuR1ZLLFxuICAgICAgLi4udG9Kc29uX1JldHJ5UHJvcHMocHJvcHMpLFxuICAgIH07XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogUmV0cnlQcm9wcyA9IHt9KSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCBSZXRyeS5tYW5pZmVzdChwcm9wcykpO1xuICB9XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgUmV0cnlQcm9wcyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBtZXNoPzogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBzcGVjPzogYW55O1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgbWV0YWRhdGE/OiBBcGlPYmplY3RNZXRhZGF0YTtcblxufVxuXG4vKipcbiAqIENvbnZlcnRzIGFuIG9iamVjdCBvZiB0eXBlICdSZXRyeVByb3BzJyB0byBKU09OIHJlcHJlc2VudGF0aW9uLlxuICovXG4vKiBlc2xpbnQtZGlzYWJsZSBtYXgtbGVuLCBxdW90ZS1wcm9wcyAqL1xuZXhwb3J0IGZ1bmN0aW9uIHRvSnNvbl9SZXRyeVByb3BzKG9iajogUmV0cnlQcm9wcyB8IHVuZGVmaW5lZCk6IFJlY29yZDxzdHJpbmcsIGFueT4gfCB1bmRlZmluZWQge1xuICBpZiAob2JqID09PSB1bmRlZmluZWQpIHsgcmV0dXJuIHVuZGVmaW5lZDsgfVxuICBjb25zdCByZXN1bHQgPSB7XG4gICAgJ21lc2gnOiBvYmoubWVzaCxcbiAgICAnc3BlYyc6IG9iai5zcGVjLFxuICAgICdtZXRhZGF0YSc6IG9iai5tZXRhZGF0YSxcbiAgfTtcbiAgLy8gZmlsdGVyIHVuZGVmaW5lZCB2YWx1ZXNcbiAgcmV0dXJuIE9iamVjdC5lbnRyaWVzKHJlc3VsdCkucmVkdWNlKChyLCBpKSA9PiAoaVsxXSA9PT0gdW5kZWZpbmVkKSA/IHIgOiAoeyAuLi5yLCBbaVswXV06IGlbMV0gfSksIHt9KTtcbn1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcblxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIFNlcnZpY2VJbnNpZ2h0IGV4dGVuZHMgQXBpT2JqZWN0IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEdWSzogR3JvdXBWZXJzaW9uS2luZCA9IHtcbiAgICBhcGlWZXJzaW9uOiAna3VtYS5pby92MWFscGhhMScsXG4gICAga2luZDogJ1NlcnZpY2VJbnNpZ2h0JyxcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0YXRpYyBtYW5pZmVzdChwcm9wczogU2VydmljZUluc2lnaHRQcm9wcyA9IHt9KTogYW55IHtcbiAgICByZXR1cm4ge1xuICAgICAgLi4uU2VydmljZUluc2lnaHQuR1ZLLFxuICAgICAgLi4udG9Kc29uX1NlcnZpY2VJbnNpZ2h0UHJvcHMocHJvcHMpLFxuICAgIH07XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogU2VydmljZUluc2lnaHRQcm9wcyA9IHt9KSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCBTZXJ2aWNlSW5zaWdodC5tYW5pZmVzdChwcm9wcykpO1xuICB9XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIFNlcnZpY2VJbnNpZ2h0UHJvcHMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgbWVzaD86IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgc3BlYz86IGFueTtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IG1ldGFkYXRhPzogQXBpT2JqZWN0TWV0YWRhdGE7XG5cbn1cblxuLyoqXG4gKiBDb252ZXJ0cyBhbiBvYmplY3Qgb2YgdHlwZSAnU2VydmljZUluc2lnaHRQcm9wcycgdG8gSlNPTiByZXByZXNlbnRhdGlvbi5cbiAqL1xuLyogZXNsaW50LWRpc2FibGUgbWF4LWxlbiwgcXVvdGUtcHJvcHMgKi9cbmV4cG9ydCBmdW5jdGlvbiB0b0pzb25fU2VydmljZUluc2lnaHRQcm9wcyhvYmo6IFNlcnZpY2VJbnNpZ2h0UHJvcHMgfCB1bmRlZmluZWQpOiBSZWNvcmQ8c3RyaW5nLCBhbnk+IHwgdW5kZWZpbmVkIHtcbiAgaWYgKG9iaiA9PT0gdW5kZWZpbmVkKSB7IHJldHVybiB1bmRlZmluZWQ7IH1cbiAgY29uc3QgcmVzdWx0ID0ge1xuICAgICdtZXNoJzogb2JqLm1lc2gsXG4gICAgJ3NwZWMnOiBvYmouc3BlYyxcbiAgICAnbWV0YWRhdGEnOiBvYmoubWV0YWRhdGEsXG4gIH07XG4gIC8vIGZpbHRlciB1bmRlZmluZWQgdmFsdWVzXG4gIHJldHVybiBPYmplY3QuZW50cmllcyhyZXN1bHQpLnJlZHVjZSgociwgaSkgPT4gKGlbMV0gPT09IHVuZGVmaW5lZCkgPyByIDogKHsgLi4uciwgW2lbMF1dOiBpWzFdIH0pLCB7fSk7XG59XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBUaW1lb3V0IGV4dGVuZHMgQXBpT2JqZWN0IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgR1ZLOiBHcm91cFZlcnNpb25LaW5kID0ge1xuICAgIGFwaVZlcnNpb246ICdrdW1hLmlvL3YxYWxwaGExJyxcbiAgICBraW5kOiAnVGltZW91dCcsXG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0YXRpYyBtYW5pZmVzdChwcm9wczogVGltZW91dFByb3BzID0ge30pOiBhbnkge1xuICAgIHJldHVybiB7XG4gICAgICAuLi5UaW1lb3V0LkdWSyxcbiAgICAgIC4uLnRvSnNvbl9UaW1lb3V0UHJvcHMocHJvcHMpLFxuICAgIH07XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBUaW1lb3V0UHJvcHMgPSB7fSkge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwgVGltZW91dC5tYW5pZmVzdChwcm9wcykpO1xuICB9XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIFRpbWVvdXRQcm9wcyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IG1lc2g/OiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgc3BlYz86IGFueTtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgbWV0YWRhdGE/OiBBcGlPYmplY3RNZXRhZGF0YTtcblxufVxuXG4vKipcbiAqIENvbnZlcnRzIGFuIG9iamVjdCBvZiB0eXBlICdUaW1lb3V0UHJvcHMnIHRvIEpTT04gcmVwcmVzZW50YXRpb24uXG4gKi9cbi8qIGVzbGludC1kaXNhYmxlIG1heC1sZW4sIHF1b3RlLXByb3BzICovXG5leHBvcnQgZnVuY3Rpb24gdG9Kc29uX1RpbWVvdXRQcm9wcyhvYmo6IFRpbWVvdXRQcm9wcyB8IHVuZGVmaW5lZCk6IFJlY29yZDxzdHJpbmcsIGFueT4gfCB1bmRlZmluZWQge1xuICBpZiAob2JqID09PSB1bmRlZmluZWQpIHsgcmV0dXJuIHVuZGVmaW5lZDsgfVxuICBjb25zdCByZXN1bHQgPSB7XG4gICAgJ21lc2gnOiBvYmoubWVzaCxcbiAgICAnc3BlYyc6IG9iai5zcGVjLFxuICAgICdtZXRhZGF0YSc6IG9iai5tZXRhZGF0YSxcbiAgfTtcbiAgLy8gZmlsdGVyIHVuZGVmaW5lZCB2YWx1ZXNcbiAgcmV0dXJuIE9iamVjdC5lbnRyaWVzKHJlc3VsdCkucmVkdWNlKChyLCBpKSA9PiAoaVsxXSA9PT0gdW5kZWZpbmVkKSA/IHIgOiAoeyAuLi5yLCBbaVswXV06IGlbMV0gfSksIHt9KTtcbn1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcblxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBUcmFmZmljTG9nIGV4dGVuZHMgQXBpT2JqZWN0IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgR1ZLOiBHcm91cFZlcnNpb25LaW5kID0ge1xuICAgIGFwaVZlcnNpb246ICdrdW1hLmlvL3YxYWxwaGExJyxcbiAgICBraW5kOiAnVHJhZmZpY0xvZycsXG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0YXRpYyBtYW5pZmVzdChwcm9wczogVHJhZmZpY0xvZ1Byb3BzID0ge30pOiBhbnkge1xuICAgIHJldHVybiB7XG4gICAgICAuLi5UcmFmZmljTG9nLkdWSyxcbiAgICAgIC4uLnRvSnNvbl9UcmFmZmljTG9nUHJvcHMocHJvcHMpLFxuICAgIH07XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBUcmFmZmljTG9nUHJvcHMgPSB7fSkge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwgVHJhZmZpY0xvZy5tYW5pZmVzdChwcm9wcykpO1xuICB9XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBUcmFmZmljTG9nUHJvcHMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBtZXNoPzogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHNwZWM/OiBhbnk7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IG1ldGFkYXRhPzogQXBpT2JqZWN0TWV0YWRhdGE7XG5cbn1cblxuLyoqXG4gKiBDb252ZXJ0cyBhbiBvYmplY3Qgb2YgdHlwZSAnVHJhZmZpY0xvZ1Byb3BzJyB0byBKU09OIHJlcHJlc2VudGF0aW9uLlxuICovXG4vKiBlc2xpbnQtZGlzYWJsZSBtYXgtbGVuLCBxdW90ZS1wcm9wcyAqL1xuZXhwb3J0IGZ1bmN0aW9uIHRvSnNvbl9UcmFmZmljTG9nUHJvcHMob2JqOiBUcmFmZmljTG9nUHJvcHMgfCB1bmRlZmluZWQpOiBSZWNvcmQ8c3RyaW5nLCBhbnk+IHwgdW5kZWZpbmVkIHtcbiAgaWYgKG9iaiA9PT0gdW5kZWZpbmVkKSB7IHJldHVybiB1bmRlZmluZWQ7IH1cbiAgY29uc3QgcmVzdWx0ID0ge1xuICAgICdtZXNoJzogb2JqLm1lc2gsXG4gICAgJ3NwZWMnOiBvYmouc3BlYyxcbiAgICAnbWV0YWRhdGEnOiBvYmoubWV0YWRhdGEsXG4gIH07XG4gIC8vIGZpbHRlciB1bmRlZmluZWQgdmFsdWVzXG4gIHJldHVybiBPYmplY3QuZW50cmllcyhyZXN1bHQpLnJlZHVjZSgociwgaSkgPT4gKGlbMV0gPT09IHVuZGVmaW5lZCkgPyByIDogKHsgLi4uciwgW2lbMF1dOiBpWzFdIH0pLCB7fSk7XG59XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgVHJhZmZpY1Blcm1pc3Npb24gZXh0ZW5kcyBBcGlPYmplY3Qge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgR1ZLOiBHcm91cFZlcnNpb25LaW5kID0ge1xuICAgIGFwaVZlcnNpb246ICdrdW1hLmlvL3YxYWxwaGExJyxcbiAgICBraW5kOiAnVHJhZmZpY1Blcm1pc3Npb24nLFxuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgc3RhdGljIG1hbmlmZXN0KHByb3BzOiBUcmFmZmljUGVybWlzc2lvblByb3BzID0ge30pOiBhbnkge1xuICAgIHJldHVybiB7XG4gICAgICAuLi5UcmFmZmljUGVybWlzc2lvbi5HVkssXG4gICAgICAuLi50b0pzb25fVHJhZmZpY1Blcm1pc3Npb25Qcm9wcyhwcm9wcyksXG4gICAgfTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBUcmFmZmljUGVybWlzc2lvblByb3BzID0ge30pIHtcbiAgICBzdXBlcihzY29wZSwgaWQsIFRyYWZmaWNQZXJtaXNzaW9uLm1hbmlmZXN0KHByb3BzKSk7XG4gIH1cbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIFRyYWZmaWNQZXJtaXNzaW9uUHJvcHMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgbWVzaD86IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgc3BlYz86IGFueTtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IG1ldGFkYXRhPzogQXBpT2JqZWN0TWV0YWRhdGE7XG5cbn1cblxuLyoqXG4gKiBDb252ZXJ0cyBhbiBvYmplY3Qgb2YgdHlwZSAnVHJhZmZpY1Blcm1pc3Npb25Qcm9wcycgdG8gSlNPTiByZXByZXNlbnRhdGlvbi5cbiAqL1xuLyogZXNsaW50LWRpc2FibGUgbWF4LWxlbiwgcXVvdGUtcHJvcHMgKi9cbmV4cG9ydCBmdW5jdGlvbiB0b0pzb25fVHJhZmZpY1Blcm1pc3Npb25Qcm9wcyhvYmo6IFRyYWZmaWNQZXJtaXNzaW9uUHJvcHMgfCB1bmRlZmluZWQpOiBSZWNvcmQ8c3RyaW5nLCBhbnk+IHwgdW5kZWZpbmVkIHtcbiAgaWYgKG9iaiA9PT0gdW5kZWZpbmVkKSB7IHJldHVybiB1bmRlZmluZWQ7IH1cbiAgY29uc3QgcmVzdWx0ID0ge1xuICAgICdtZXNoJzogb2JqLm1lc2gsXG4gICAgJ3NwZWMnOiBvYmouc3BlYyxcbiAgICAnbWV0YWRhdGEnOiBvYmoubWV0YWRhdGEsXG4gIH07XG4gIC8vIGZpbHRlciB1bmRlZmluZWQgdmFsdWVzXG4gIHJldHVybiBPYmplY3QuZW50cmllcyhyZXN1bHQpLnJlZHVjZSgociwgaSkgPT4gKGlbMV0gPT09IHVuZGVmaW5lZCkgPyByIDogKHsgLi4uciwgW2lbMF1dOiBpWzFdIH0pLCB7fSk7XG59XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgVHJhZmZpY1JvdXRlIGV4dGVuZHMgQXBpT2JqZWN0IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBHVks6IEdyb3VwVmVyc2lvbktpbmQgPSB7XG4gICAgYXBpVmVyc2lvbjogJ2t1bWEuaW8vdjFhbHBoYTEnLFxuICAgIGtpbmQ6ICdUcmFmZmljUm91dGUnLFxuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0YXRpYyBtYW5pZmVzdChwcm9wczogVHJhZmZpY1JvdXRlUHJvcHMgPSB7fSk6IGFueSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIC4uLlRyYWZmaWNSb3V0ZS5HVkssXG4gICAgICAuLi50b0pzb25fVHJhZmZpY1JvdXRlUHJvcHMocHJvcHMpLFxuICAgIH07XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IFRyYWZmaWNSb3V0ZVByb3BzID0ge30pIHtcbiAgICBzdXBlcihzY29wZSwgaWQsIFRyYWZmaWNSb3V0ZS5tYW5pZmVzdChwcm9wcykpO1xuICB9XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBUcmFmZmljUm91dGVQcm9wcyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgbWVzaD86IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHNwZWM/OiBhbnk7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgbWV0YWRhdGE/OiBBcGlPYmplY3RNZXRhZGF0YTtcblxufVxuXG4vKipcbiAqIENvbnZlcnRzIGFuIG9iamVjdCBvZiB0eXBlICdUcmFmZmljUm91dGVQcm9wcycgdG8gSlNPTiByZXByZXNlbnRhdGlvbi5cbiAqL1xuLyogZXNsaW50LWRpc2FibGUgbWF4LWxlbiwgcXVvdGUtcHJvcHMgKi9cbmV4cG9ydCBmdW5jdGlvbiB0b0pzb25fVHJhZmZpY1JvdXRlUHJvcHMob2JqOiBUcmFmZmljUm91dGVQcm9wcyB8IHVuZGVmaW5lZCk6IFJlY29yZDxzdHJpbmcsIGFueT4gfCB1bmRlZmluZWQge1xuICBpZiAob2JqID09PSB1bmRlZmluZWQpIHsgcmV0dXJuIHVuZGVmaW5lZDsgfVxuICBjb25zdCByZXN1bHQgPSB7XG4gICAgJ21lc2gnOiBvYmoubWVzaCxcbiAgICAnc3BlYyc6IG9iai5zcGVjLFxuICAgICdtZXRhZGF0YSc6IG9iai5tZXRhZGF0YSxcbiAgfTtcbiAgLy8gZmlsdGVyIHVuZGVmaW5lZCB2YWx1ZXNcbiAgcmV0dXJuIE9iamVjdC5lbnRyaWVzKHJlc3VsdCkucmVkdWNlKChyLCBpKSA9PiAoaVsxXSA9PT0gdW5kZWZpbmVkKSA/IHIgOiAoeyAuLi5yLCBbaVswXV06IGlbMV0gfSksIHt9KTtcbn1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcblxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBUcmFmZmljVHJhY2UgZXh0ZW5kcyBBcGlPYmplY3Qge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEdWSzogR3JvdXBWZXJzaW9uS2luZCA9IHtcbiAgICBhcGlWZXJzaW9uOiAna3VtYS5pby92MWFscGhhMScsXG4gICAga2luZDogJ1RyYWZmaWNUcmFjZScsXG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgc3RhdGljIG1hbmlmZXN0KHByb3BzOiBUcmFmZmljVHJhY2VQcm9wcyA9IHt9KTogYW55IHtcbiAgICByZXR1cm4ge1xuICAgICAgLi4uVHJhZmZpY1RyYWNlLkdWSyxcbiAgICAgIC4uLnRvSnNvbl9UcmFmZmljVHJhY2VQcm9wcyhwcm9wcyksXG4gICAgfTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogVHJhZmZpY1RyYWNlUHJvcHMgPSB7fSkge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwgVHJhZmZpY1RyYWNlLm1hbmlmZXN0KHByb3BzKSk7XG4gIH1cbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIFRyYWZmaWNUcmFjZVByb3BzIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBtZXNoPzogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgc3BlYz86IGFueTtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBtZXRhZGF0YT86IEFwaU9iamVjdE1ldGFkYXRhO1xuXG59XG5cbi8qKlxuICogQ29udmVydHMgYW4gb2JqZWN0IG9mIHR5cGUgJ1RyYWZmaWNUcmFjZVByb3BzJyB0byBKU09OIHJlcHJlc2VudGF0aW9uLlxuICovXG4vKiBlc2xpbnQtZGlzYWJsZSBtYXgtbGVuLCBxdW90ZS1wcm9wcyAqL1xuZXhwb3J0IGZ1bmN0aW9uIHRvSnNvbl9UcmFmZmljVHJhY2VQcm9wcyhvYmo6IFRyYWZmaWNUcmFjZVByb3BzIHwgdW5kZWZpbmVkKTogUmVjb3JkPHN0cmluZywgYW55PiB8IHVuZGVmaW5lZCB7XG4gIGlmIChvYmogPT09IHVuZGVmaW5lZCkgeyByZXR1cm4gdW5kZWZpbmVkOyB9XG4gIGNvbnN0IHJlc3VsdCA9IHtcbiAgICAnbWVzaCc6IG9iai5tZXNoLFxuICAgICdzcGVjJzogb2JqLnNwZWMsXG4gICAgJ21ldGFkYXRhJzogb2JqLm1ldGFkYXRhLFxuICB9O1xuICAvLyBmaWx0ZXIgdW5kZWZpbmVkIHZhbHVlc1xuICByZXR1cm4gT2JqZWN0LmVudHJpZXMocmVzdWx0KS5yZWR1Y2UoKHIsIGkpID0+IChpWzFdID09PSB1bmRlZmluZWQpID8gciA6ICh7IC4uLnIsIFtpWzBdXTogaVsxXSB9KSwge30pO1xufVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuXG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIFZpcnR1YWxPdXRib3VuZCBleHRlbmRzIEFwaU9iamVjdCB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgR1ZLOiBHcm91cFZlcnNpb25LaW5kID0ge1xuICAgIGFwaVZlcnNpb246ICdrdW1hLmlvL3YxYWxwaGExJyxcbiAgICBraW5kOiAnVmlydHVhbE91dGJvdW5kJyxcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBzdGF0aWMgbWFuaWZlc3QocHJvcHM6IFZpcnR1YWxPdXRib3VuZFByb3BzID0ge30pOiBhbnkge1xuICAgIHJldHVybiB7XG4gICAgICAuLi5WaXJ0dWFsT3V0Ym91bmQuR1ZLLFxuICAgICAgLi4udG9Kc29uX1ZpcnR1YWxPdXRib3VuZFByb3BzKHByb3BzKSxcbiAgICB9O1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBWaXJ0dWFsT3V0Ym91bmRQcm9wcyA9IHt9KSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCBWaXJ0dWFsT3V0Ym91bmQubWFuaWZlc3QocHJvcHMpKTtcbiAgfVxufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgVmlydHVhbE91dGJvdW5kUHJvcHMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IG1lc2g/OiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBzcGVjPzogYW55O1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IG1ldGFkYXRhPzogQXBpT2JqZWN0TWV0YWRhdGE7XG5cbn1cblxuLyoqXG4gKiBDb252ZXJ0cyBhbiBvYmplY3Qgb2YgdHlwZSAnVmlydHVhbE91dGJvdW5kUHJvcHMnIHRvIEpTT04gcmVwcmVzZW50YXRpb24uXG4gKi9cbi8qIGVzbGludC1kaXNhYmxlIG1heC1sZW4sIHF1b3RlLXByb3BzICovXG5leHBvcnQgZnVuY3Rpb24gdG9Kc29uX1ZpcnR1YWxPdXRib3VuZFByb3BzKG9iajogVmlydHVhbE91dGJvdW5kUHJvcHMgfCB1bmRlZmluZWQpOiBSZWNvcmQ8c3RyaW5nLCBhbnk+IHwgdW5kZWZpbmVkIHtcbiAgaWYgKG9iaiA9PT0gdW5kZWZpbmVkKSB7IHJldHVybiB1bmRlZmluZWQ7IH1cbiAgY29uc3QgcmVzdWx0ID0ge1xuICAgICdtZXNoJzogb2JqLm1lc2gsXG4gICAgJ3NwZWMnOiBvYmouc3BlYyxcbiAgICAnbWV0YWRhdGEnOiBvYmoubWV0YWRhdGEsXG4gIH07XG4gIC8vIGZpbHRlciB1bmRlZmluZWQgdmFsdWVzXG4gIHJldHVybiBPYmplY3QuZW50cmllcyhyZXN1bHQpLnJlZHVjZSgociwgaSkgPT4gKGlbMV0gPT09IHVuZGVmaW5lZCkgPyByIDogKHsgLi4uciwgW2lbMF1dOiBpWzFdIH0pLCB7fSk7XG59XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBab25lIGV4dGVuZHMgQXBpT2JqZWN0IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgR1ZLOiBHcm91cFZlcnNpb25LaW5kID0ge1xuICAgIGFwaVZlcnNpb246ICdrdW1hLmlvL3YxYWxwaGExJyxcbiAgICBraW5kOiAnWm9uZScsXG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0YXRpYyBtYW5pZmVzdChwcm9wczogWm9uZVByb3BzID0ge30pOiBhbnkge1xuICAgIHJldHVybiB7XG4gICAgICAuLi5ab25lLkdWSyxcbiAgICAgIC4uLnRvSnNvbl9ab25lUHJvcHMocHJvcHMpLFxuICAgIH07XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBab25lUHJvcHMgPSB7fSkge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwgWm9uZS5tYW5pZmVzdChwcm9wcykpO1xuICB9XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIFpvbmVQcm9wcyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IG1lc2g/OiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgc3BlYz86IGFueTtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgbWV0YWRhdGE/OiBBcGlPYmplY3RNZXRhZGF0YTtcblxufVxuXG4vKipcbiAqIENvbnZlcnRzIGFuIG9iamVjdCBvZiB0eXBlICdab25lUHJvcHMnIHRvIEpTT04gcmVwcmVzZW50YXRpb24uXG4gKi9cbi8qIGVzbGludC1kaXNhYmxlIG1heC1sZW4sIHF1b3RlLXByb3BzICovXG5leHBvcnQgZnVuY3Rpb24gdG9Kc29uX1pvbmVQcm9wcyhvYmo6IFpvbmVQcm9wcyB8IHVuZGVmaW5lZCk6IFJlY29yZDxzdHJpbmcsIGFueT4gfCB1bmRlZmluZWQge1xuICBpZiAob2JqID09PSB1bmRlZmluZWQpIHsgcmV0dXJuIHVuZGVmaW5lZDsgfVxuICBjb25zdCByZXN1bHQgPSB7XG4gICAgJ21lc2gnOiBvYmoubWVzaCxcbiAgICAnc3BlYyc6IG9iai5zcGVjLFxuICAgICdtZXRhZGF0YSc6IG9iai5tZXRhZGF0YSxcbiAgfTtcbiAgLy8gZmlsdGVyIHVuZGVmaW5lZCB2YWx1ZXNcbiAgcmV0dXJuIE9iamVjdC5lbnRyaWVzKHJlc3VsdCkucmVkdWNlKChyLCBpKSA9PiAoaVsxXSA9PT0gdW5kZWZpbmVkKSA/IHIgOiAoeyAuLi5yLCBbaVswXV06IGlbMV0gfSksIHt9KTtcbn1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcblxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBab25lSW5ncmVzcyBleHRlbmRzIEFwaU9iamVjdCB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBHVks6IEdyb3VwVmVyc2lvbktpbmQgPSB7XG4gICAgYXBpVmVyc2lvbjogJ2t1bWEuaW8vdjFhbHBoYTEnLFxuICAgIGtpbmQ6ICdab25lSW5ncmVzcycsXG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBzdGF0aWMgbWFuaWZlc3QocHJvcHM6IFpvbmVJbmdyZXNzUHJvcHMgPSB7fSk6IGFueSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIC4uLlpvbmVJbmdyZXNzLkdWSyxcbiAgICAgIC4uLnRvSnNvbl9ab25lSW5ncmVzc1Byb3BzKHByb3BzKSxcbiAgICB9O1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IFpvbmVJbmdyZXNzUHJvcHMgPSB7fSkge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwgWm9uZUluZ3Jlc3MubWFuaWZlc3QocHJvcHMpKTtcbiAgfVxufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgWm9uZUluZ3Jlc3NQcm9wcyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBtZXNoPzogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBzcGVjPzogYW55O1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgbWV0YWRhdGE/OiBBcGlPYmplY3RNZXRhZGF0YTtcblxufVxuXG4vKipcbiAqIENvbnZlcnRzIGFuIG9iamVjdCBvZiB0eXBlICdab25lSW5ncmVzc1Byb3BzJyB0byBKU09OIHJlcHJlc2VudGF0aW9uLlxuICovXG4vKiBlc2xpbnQtZGlzYWJsZSBtYXgtbGVuLCBxdW90ZS1wcm9wcyAqL1xuZXhwb3J0IGZ1bmN0aW9uIHRvSnNvbl9ab25lSW5ncmVzc1Byb3BzKG9iajogWm9uZUluZ3Jlc3NQcm9wcyB8IHVuZGVmaW5lZCk6IFJlY29yZDxzdHJpbmcsIGFueT4gfCB1bmRlZmluZWQge1xuICBpZiAob2JqID09PSB1bmRlZmluZWQpIHsgcmV0dXJuIHVuZGVmaW5lZDsgfVxuICBjb25zdCByZXN1bHQgPSB7XG4gICAgJ21lc2gnOiBvYmoubWVzaCxcbiAgICAnc3BlYyc6IG9iai5zcGVjLFxuICAgICdtZXRhZGF0YSc6IG9iai5tZXRhZGF0YSxcbiAgfTtcbiAgLy8gZmlsdGVyIHVuZGVmaW5lZCB2YWx1ZXNcbiAgcmV0dXJuIE9iamVjdC5lbnRyaWVzKHJlc3VsdCkucmVkdWNlKChyLCBpKSA9PiAoaVsxXSA9PT0gdW5kZWZpbmVkKSA/IHIgOiAoeyAuLi5yLCBbaVswXV06IGlbMV0gfSksIHt9KTtcbn1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcblxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgWm9uZUluZ3Jlc3NJbnNpZ2h0IGV4dGVuZHMgQXBpT2JqZWN0IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBHVks6IEdyb3VwVmVyc2lvbktpbmQgPSB7XG4gICAgYXBpVmVyc2lvbjogJ2t1bWEuaW8vdjFhbHBoYTEnLFxuICAgIGtpbmQ6ICdab25lSW5ncmVzc0luc2lnaHQnLFxuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0YXRpYyBtYW5pZmVzdChwcm9wczogWm9uZUluZ3Jlc3NJbnNpZ2h0UHJvcHMgPSB7fSk6IGFueSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIC4uLlpvbmVJbmdyZXNzSW5zaWdodC5HVkssXG4gICAgICAuLi50b0pzb25fWm9uZUluZ3Jlc3NJbnNpZ2h0UHJvcHMocHJvcHMpLFxuICAgIH07XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IFpvbmVJbmdyZXNzSW5zaWdodFByb3BzID0ge30pIHtcbiAgICBzdXBlcihzY29wZSwgaWQsIFpvbmVJbmdyZXNzSW5zaWdodC5tYW5pZmVzdChwcm9wcykpO1xuICB9XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgWm9uZUluZ3Jlc3NJbnNpZ2h0UHJvcHMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IG1lc2g/OiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBzcGVjPzogYW55O1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IG1ldGFkYXRhPzogQXBpT2JqZWN0TWV0YWRhdGE7XG5cbn1cblxuLyoqXG4gKiBDb252ZXJ0cyBhbiBvYmplY3Qgb2YgdHlwZSAnWm9uZUluZ3Jlc3NJbnNpZ2h0UHJvcHMnIHRvIEpTT04gcmVwcmVzZW50YXRpb24uXG4gKi9cbi8qIGVzbGludC1kaXNhYmxlIG1heC1sZW4sIHF1b3RlLXByb3BzICovXG5leHBvcnQgZnVuY3Rpb24gdG9Kc29uX1pvbmVJbmdyZXNzSW5zaWdodFByb3BzKG9iajogWm9uZUluZ3Jlc3NJbnNpZ2h0UHJvcHMgfCB1bmRlZmluZWQpOiBSZWNvcmQ8c3RyaW5nLCBhbnk+IHwgdW5kZWZpbmVkIHtcbiAgaWYgKG9iaiA9PT0gdW5kZWZpbmVkKSB7IHJldHVybiB1bmRlZmluZWQ7IH1cbiAgY29uc3QgcmVzdWx0ID0ge1xuICAgICdtZXNoJzogb2JqLm1lc2gsXG4gICAgJ3NwZWMnOiBvYmouc3BlYyxcbiAgICAnbWV0YWRhdGEnOiBvYmoubWV0YWRhdGEsXG4gIH07XG4gIC8vIGZpbHRlciB1bmRlZmluZWQgdmFsdWVzXG4gIHJldHVybiBPYmplY3QuZW50cmllcyhyZXN1bHQpLnJlZHVjZSgociwgaSkgPT4gKGlbMV0gPT09IHVuZGVmaW5lZCkgPyByIDogKHsgLi4uciwgW2lbMF1dOiBpWzFdIH0pLCB7fSk7XG59XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgWm9uZUluc2lnaHQgZXh0ZW5kcyBBcGlPYmplY3Qge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgR1ZLOiBHcm91cFZlcnNpb25LaW5kID0ge1xuICAgIGFwaVZlcnNpb246ICdrdW1hLmlvL3YxYWxwaGExJyxcbiAgICBraW5kOiAnWm9uZUluc2lnaHQnLFxuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgc3RhdGljIG1hbmlmZXN0KHByb3BzOiBab25lSW5zaWdodFByb3BzID0ge30pOiBhbnkge1xuICAgIHJldHVybiB7XG4gICAgICAuLi5ab25lSW5zaWdodC5HVkssXG4gICAgICAuLi50b0pzb25fWm9uZUluc2lnaHRQcm9wcyhwcm9wcyksXG4gICAgfTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBab25lSW5zaWdodFByb3BzID0ge30pIHtcbiAgICBzdXBlcihzY29wZSwgaWQsIFpvbmVJbnNpZ2h0Lm1hbmlmZXN0KHByb3BzKSk7XG4gIH1cbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIFpvbmVJbnNpZ2h0UHJvcHMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgbWVzaD86IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgc3BlYz86IGFueTtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IG1ldGFkYXRhPzogQXBpT2JqZWN0TWV0YWRhdGE7XG5cbn1cblxuLyoqXG4gKiBDb252ZXJ0cyBhbiBvYmplY3Qgb2YgdHlwZSAnWm9uZUluc2lnaHRQcm9wcycgdG8gSlNPTiByZXByZXNlbnRhdGlvbi5cbiAqL1xuLyogZXNsaW50LWRpc2FibGUgbWF4LWxlbiwgcXVvdGUtcHJvcHMgKi9cbmV4cG9ydCBmdW5jdGlvbiB0b0pzb25fWm9uZUluc2lnaHRQcm9wcyhvYmo6IFpvbmVJbnNpZ2h0UHJvcHMgfCB1bmRlZmluZWQpOiBSZWNvcmQ8c3RyaW5nLCBhbnk+IHwgdW5kZWZpbmVkIHtcbiAgaWYgKG9iaiA9PT0gdW5kZWZpbmVkKSB7IHJldHVybiB1bmRlZmluZWQ7IH1cbiAgY29uc3QgcmVzdWx0ID0ge1xuICAgICdtZXNoJzogb2JqLm1lc2gsXG4gICAgJ3NwZWMnOiBvYmouc3BlYyxcbiAgICAnbWV0YWRhdGEnOiBvYmoubWV0YWRhdGEsXG4gIH07XG4gIC8vIGZpbHRlciB1bmRlZmluZWQgdmFsdWVzXG4gIHJldHVybiBPYmplY3QuZW50cmllcyhyZXN1bHQpLnJlZHVjZSgociwgaSkgPT4gKGlbMV0gPT09IHVuZGVmaW5lZCkgPyByIDogKHsgLi4uciwgW2lbMF1dOiBpWzFdIH0pLCB7fSk7XG59XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5cblxuZXhwb3J0IGludGVyZmFjZSBLdW1hT3B0aW9ucyB7XG4gIHJlYWRvbmx5IG1lc2g/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IHNlcnZpY2VXaGl0ZWxpc3Q/OiBzdHJpbmdbXTtcbiAgcmVhZG9ubHkgZ2F0ZXdheVdoaXRlbGlzdD86IHN0cmluZ1tdO1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIFR5cGVkS3VtYUV4dGVybmFsU2VydmljZU9wdGlvbnMge1xuICByZWFkb25seSBtZXNoOiBzdHJpbmc7XG4gIHJlYWRvbmx5IHNlcnZpY2VOYW1lOiBzdHJpbmc7XG4gIHJlYWRvbmx5IHNlcnZpY2VQcm90b2NvbDogc3RyaW5nO1xuICByZWFkb25seSBzZXJ2aWNlQWRkcmVzczogc3RyaW5nO1xuXG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgVHlwZWRLdW1hVHJhZmZpY1Blcm1pc3Npb24ge1xuICByZWFkb25seSBtZXNoOiBzdHJpbmc7XG4gIHJlYWRvbmx5IGRlc3RpbmF0aW9uOiBzdHJpbmc7XG4gIHJlYWRvbmx5IGRlc3RpbmF0aW9uTGFiZWw/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IHNvdXJjZXM6IHN0cmluZ1tdO1xufVxuXG5leHBvcnQgY2xhc3MgS3VtYSBleHRlbmRzIENvbnN0cnVjdCB7XG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIG5hbWU6IHN0cmluZywgb3B0czogS3VtYU9wdGlvbnMpIHtcbiAgICBzdXBlcihzY29wZSwgbmFtZSk7XG5cbiAgICBjb25zdCBzb3VyY2U6IGFueVtdID0gW107XG5cbiAgICBvcHRzPy5zZXJ2aWNlV2hpdGVsaXN0Py5mb3JFYWNoKHNyYyA9PiB7XG4gICAgICBzb3VyY2UucHVzaCh7XG4gICAgICAgIG1hdGNoOiB7XG4gICAgICAgICAgYXBwOiBzcmMsXG4gICAgICAgIH0sXG4gICAgICB9KTtcbiAgICB9KTtcblxuICAgIG9wdHM/LmdhdGV3YXlXaGl0ZWxpc3Q/LmZvckVhY2goc3JjID0+IHtcbiAgICAgIHNvdXJjZS5wdXNoKHtcbiAgICAgICAgbWF0Y2g6IHtcbiAgICAgICAgICBhcHA6IHNyYyxcbiAgICAgICAgfSxcbiAgICAgIH0pO1xuICAgIH0pO1xuXG4gICAgaWYgKHNvdXJjZS5sZW5ndGggPiAwKSB7XG4gICAgICBuZXcgVHJhZmZpY1Blcm1pc3Npb24odGhpcywgYCR7bmFtZX0taW5ib3VuZGAsIHtcbiAgICAgICAgbWVzaDogb3B0cy5tZXNoLFxuICAgICAgICBtZXRhZGF0YToge1xuICAgICAgICAgIG5hbWU6IGAke25hbWV9LWluYm91bmRgLFxuICAgICAgICB9LFxuICAgICAgICBzcGVjOiB7XG4gICAgICAgICAgZGVzdGluYXRpb25zOiBbe1xuICAgICAgICAgICAgbWF0Y2g6IHtcbiAgICAgICAgICAgICAgYXBwOiBuYW1lLFxuICAgICAgICAgICAgfSxcbiAgICAgICAgICB9XSxcbiAgICAgICAgICBzb3VyY2VzOiBzb3VyY2UsXG4gICAgICAgIH0sXG4gICAgICB9KTtcbiAgICB9XG4gIH1cbn1cblxuZXhwb3J0IGNsYXNzIFR5cGVkS3VtYUV4dGVybmFsU2VydmljZSBleHRlbmRzIENvbnN0cnVjdCB7XG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIG5hbWU6IHN0cmluZywgb3B0czogVHlwZWRLdW1hRXh0ZXJuYWxTZXJ2aWNlT3B0aW9ucykge1xuICAgIHN1cGVyKHNjb3BlLCBuYW1lKTtcblxuICAgIG5ldyBFeHRlcm5hbFNlcnZpY2UodGhpcywgbmFtZSwge1xuICAgICAgbWVzaDogb3B0cy5tZXNoLFxuICAgICAgbWV0YWRhdGE6IHtcbiAgICAgICAgbmFtZTogb3B0cy5zZXJ2aWNlTmFtZSxcbiAgICAgIH0sXG4gICAgICBzcGVjOiB7XG4gICAgICAgIHRhZ3M6IHtcbiAgICAgICAgICAna3VtYS5pby9zZXJ2aWNlJzogb3B0cy5zZXJ2aWNlTmFtZSxcbiAgICAgICAgICAna3VtYS5pby9wcm90b2NvbCc6IG9wdHMuc2VydmljZVByb3RvY29sLFxuICAgICAgICB9LFxuICAgICAgICBuZXR3b3JraW5nOiB7XG4gICAgICAgICAgYWRkcmVzczogb3B0cy5zZXJ2aWNlQWRkcmVzcyxcbiAgICAgICAgICB0bHM6IHtcbiAgICAgICAgICAgIGVuYWJsZWQ6IGZhbHNlLFxuICAgICAgICAgIH0sXG4gICAgICAgIH0sXG4gICAgICB9LFxuICAgIH0pO1xuXG4gIH1cbn1cblxuZXhwb3J0IGNsYXNzIFR5cGVkVHJhZmZpY1Blcm1pc3Npb24gZXh0ZW5kcyBDb25zdHJ1Y3Qge1xuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBuYW1lOiBzdHJpbmcsIG9wdHM6IFR5cGVkS3VtYVRyYWZmaWNQZXJtaXNzaW9uKSB7XG4gICAgc3VwZXIoc2NvcGUsIG5hbWUpO1xuICAgIGNvbnN0IHNvdXJjZXM6IGFueVtdID0gW107XG5cbiAgICBvcHRzLnNvdXJjZXM/LmZvckVhY2godiA9PiB7XG4gICAgICBzb3VyY2VzLnB1c2goe1xuICAgICAgICBtYXRjaDoge1xuICAgICAgICAgIGFwcDogdixcbiAgICAgICAgfSxcbiAgICAgIH0pO1xuICAgIH0pO1xuXG4gICAgY29uc3QgZGVzdGluYXRpb25MYWJlbCA9IG9wdHMuZGVzdGluYXRpb25MYWJlbCA/IG9wdHMuZGVzdGluYXRpb25MYWJlbCA6ICdrdW1hLmlvL3NlcnZpY2UnO1xuXG4gICAgbmV3IFRyYWZmaWNQZXJtaXNzaW9uKHRoaXMsIG5hbWUsIHtcbiAgICAgIG1lc2g6IG9wdHMubWVzaCxcbiAgICAgIG1ldGFkYXRhOiB7XG4gICAgICAgIG5hbWU6IG5hbWUsXG4gICAgICB9LFxuICAgICAgc3BlYzoge1xuICAgICAgICBkZXN0aW5hdGlvbnM6IFt7XG4gICAgICAgICAgbWF0Y2g6IHtcbiAgICAgICAgICAgIFtkZXN0aW5hdGlvbkxhYmVsXTogb3B0cy5kZXN0aW5hdGlvbixcbiAgICAgICAgICB9LFxuICAgICAgICB9XSxcbiAgICAgICAgc291cmNlczogc291cmNlcyxcbiAgICAgIH0sXG4gICAgfSk7XG5cbiAgfVxufVxuXG4iXX0=