import { ApiObject, ApiObjectMetadata, GroupVersionKind } from 'cdk8s';
import { Construct } from 'constructs';
/**
 * CircuitBreaker is the Schema for the circuitbreaker API.
 *
 * @stability stable
 * @schema CircuitBreaker
 */
export declare class CircuitBreaker extends ApiObject {
    /**
     * Returns the apiVersion and kind for "CircuitBreaker".
     *
     * @stability stable
     */
    static readonly GVK: GroupVersionKind;
    /**
     * Renders a Kubernetes manifest for "CircuitBreaker".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @stability stable
     */
    static manifest(props?: CircuitBreakerProps): any;
    /**
     * Defines a "CircuitBreaker" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @stability stable
     */
    constructor(scope: Construct, id: string, props?: CircuitBreakerProps);
}
/**
 * CircuitBreaker is the Schema for the circuitbreaker API.
 *
 * @stability stable
 * @schema CircuitBreaker
 */
export interface CircuitBreakerProps {
    /**
     * @stability stable
     * @schema CircuitBreaker#mesh
     */
    readonly mesh?: string;
    /**
     * @stability stable
     * @schema CircuitBreaker#spec
     */
    readonly spec?: any;
    /**
     * @stability stable
     * @schema CircuitBreaker#metadata
     */
    readonly metadata?: ApiObjectMetadata;
}
/**
 * Converts an object of type 'CircuitBreakerProps' to JSON representation.
 */
export declare function toJson_CircuitBreakerProps(obj: CircuitBreakerProps | undefined): Record<string, any> | undefined;
/**
 * Dataplane is the Schema for the dataplanes API.
 *
 * @stability stable
 * @schema Dataplane
 */
export declare class Dataplane extends ApiObject {
    /**
     * Returns the apiVersion and kind for "Dataplane".
     *
     * @stability stable
     */
    static readonly GVK: GroupVersionKind;
    /**
     * Renders a Kubernetes manifest for "Dataplane".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @stability stable
     */
    static manifest(props?: DataplaneProps): any;
    /**
     * Defines a "Dataplane" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @stability stable
     */
    constructor(scope: Construct, id: string, props?: DataplaneProps);
}
/**
 * Dataplane is the Schema for the dataplanes API.
 *
 * @stability stable
 * @schema Dataplane
 */
export interface DataplaneProps {
    /**
     * @stability stable
     * @schema Dataplane#mesh
     */
    readonly mesh?: string;
    /**
     * @stability stable
     * @schema Dataplane#spec
     */
    readonly spec?: any;
    /**
     * @stability stable
     * @schema Dataplane#metadata
     */
    readonly metadata?: ApiObjectMetadata;
}
/**
 * Converts an object of type 'DataplaneProps' to JSON representation.
 */
export declare function toJson_DataplaneProps(obj: DataplaneProps | undefined): Record<string, any> | undefined;
/**
 * DataplaneInsight is the Schema for the dataplane insights API.
 *
 * @stability stable
 * @schema DataplaneInsight
 */
export declare class DataplaneInsight extends ApiObject {
    /**
     * Returns the apiVersion and kind for "DataplaneInsight".
     *
     * @stability stable
     */
    static readonly GVK: GroupVersionKind;
    /**
     * Renders a Kubernetes manifest for "DataplaneInsight".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @stability stable
     */
    static manifest(props?: DataplaneInsightProps): any;
    /**
     * Defines a "DataplaneInsight" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @stability stable
     */
    constructor(scope: Construct, id: string, props?: DataplaneInsightProps);
}
/**
 * DataplaneInsight is the Schema for the dataplane insights API.
 *
 * @stability stable
 * @schema DataplaneInsight
 */
export interface DataplaneInsightProps {
    /**
     * @stability stable
     * @schema DataplaneInsight#mesh
     */
    readonly mesh?: string;
    /**
     * @stability stable
     * @schema DataplaneInsight#metadata
     */
    readonly metadata?: ApiObjectMetadata;
}
/**
 * Converts an object of type 'DataplaneInsightProps' to JSON representation.
 */
export declare function toJson_DataplaneInsightProps(obj: DataplaneInsightProps | undefined): Record<string, any> | undefined;
/**
 * @stability stable
 * @schema ExternalService
 */
export declare class ExternalService extends ApiObject {
    /**
     * Returns the apiVersion and kind for "ExternalService".
     *
     * @stability stable
     */
    static readonly GVK: GroupVersionKind;
    /**
     * Renders a Kubernetes manifest for "ExternalService".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @stability stable
     */
    static manifest(props?: ExternalServiceProps): any;
    /**
     * Defines a "ExternalService" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @stability stable
     */
    constructor(scope: Construct, id: string, props?: ExternalServiceProps);
}
/**
 * @stability stable
 * @schema ExternalService
 */
export interface ExternalServiceProps {
    /**
     * @stability stable
     * @schema ExternalService#mesh
     */
    readonly mesh?: string;
    /**
     * @stability stable
     * @schema ExternalService#spec
     */
    readonly spec?: any;
    /**
     * @stability stable
     * @schema ExternalService#metadata
     */
    readonly metadata?: ApiObjectMetadata;
}
/**
 * Converts an object of type 'ExternalServiceProps' to JSON representation.
 */
export declare function toJson_ExternalServiceProps(obj: ExternalServiceProps | undefined): Record<string, any> | undefined;
/**
 * FaultInjection is the Schema for the faultinjections API.
 *
 * @stability stable
 * @schema FaultInjection
 */
export declare class FaultInjection extends ApiObject {
    /**
     * Returns the apiVersion and kind for "FaultInjection".
     *
     * @stability stable
     */
    static readonly GVK: GroupVersionKind;
    /**
     * Renders a Kubernetes manifest for "FaultInjection".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @stability stable
     */
    static manifest(props?: FaultInjectionProps): any;
    /**
     * Defines a "FaultInjection" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @stability stable
     */
    constructor(scope: Construct, id: string, props?: FaultInjectionProps);
}
/**
 * FaultInjection is the Schema for the faultinjections API.
 *
 * @stability stable
 * @schema FaultInjection
 */
export interface FaultInjectionProps {
    /**
     * @stability stable
     * @schema FaultInjection#mesh
     */
    readonly mesh?: string;
    /**
     * @stability stable
     * @schema FaultInjection#spec
     */
    readonly spec?: any;
    /**
     * @stability stable
     * @schema FaultInjection#metadata
     */
    readonly metadata?: ApiObjectMetadata;
}
/**
 * Converts an object of type 'FaultInjectionProps' to JSON representation.
 */
export declare function toJson_FaultInjectionProps(obj: FaultInjectionProps | undefined): Record<string, any> | undefined;
/**
 * HealthCheck is the Schema for the healthchecks API.
 *
 * @stability stable
 * @schema HealthCheck
 */
export declare class HealthCheck extends ApiObject {
    /**
     * Returns the apiVersion and kind for "HealthCheck".
     *
     * @stability stable
     */
    static readonly GVK: GroupVersionKind;
    /**
     * Renders a Kubernetes manifest for "HealthCheck".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @stability stable
     */
    static manifest(props?: HealthCheckProps): any;
    /**
     * Defines a "HealthCheck" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @stability stable
     */
    constructor(scope: Construct, id: string, props?: HealthCheckProps);
}
/**
 * HealthCheck is the Schema for the healthchecks API.
 *
 * @stability stable
 * @schema HealthCheck
 */
export interface HealthCheckProps {
    /**
     * @stability stable
     * @schema HealthCheck#mesh
     */
    readonly mesh?: string;
    /**
     * @stability stable
     * @schema HealthCheck#spec
     */
    readonly spec?: any;
    /**
     * @stability stable
     * @schema HealthCheck#metadata
     */
    readonly metadata?: ApiObjectMetadata;
}
/**
 * Converts an object of type 'HealthCheckProps' to JSON representation.
 */
export declare function toJson_HealthCheckProps(obj: HealthCheckProps | undefined): Record<string, any> | undefined;
/**
 * Mesh is the Schema for the meshes API.
 *
 * @stability stable
 * @schema Mesh
 */
export declare class Mesh extends ApiObject {
    /**
     * Returns the apiVersion and kind for "Mesh".
     *
     * @stability stable
     */
    static readonly GVK: GroupVersionKind;
    /**
     * Renders a Kubernetes manifest for "Mesh".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @stability stable
     */
    static manifest(props?: MeshProps): any;
    /**
     * Defines a "Mesh" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @stability stable
     */
    constructor(scope: Construct, id: string, props?: MeshProps);
}
/**
 * Mesh is the Schema for the meshes API.
 *
 * @stability stable
 * @schema Mesh
 */
export interface MeshProps {
    /**
     * @stability stable
     * @schema Mesh#spec
     */
    readonly spec?: any;
    /**
     * @stability stable
     * @schema Mesh#metadata
     */
    readonly metadata?: ApiObjectMetadata;
}
/**
 * Converts an object of type 'MeshProps' to JSON representation.
 */
export declare function toJson_MeshProps(obj: MeshProps | undefined): Record<string, any> | undefined;
/**
 * MeshInsight is the Schema for the meshes insights API.
 *
 * @stability stable
 * @schema MeshInsight
 */
export declare class MeshInsight extends ApiObject {
    /**
     * Returns the apiVersion and kind for "MeshInsight".
     *
     * @stability stable
     */
    static readonly GVK: GroupVersionKind;
    /**
     * Renders a Kubernetes manifest for "MeshInsight".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @stability stable
     */
    static manifest(props?: MeshInsightProps): any;
    /**
     * Defines a "MeshInsight" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @stability stable
     */
    constructor(scope: Construct, id: string, props?: MeshInsightProps);
}
/**
 * MeshInsight is the Schema for the meshes insights API.
 *
 * @stability stable
 * @schema MeshInsight
 */
export interface MeshInsightProps {
    /**
     * @stability stable
     * @schema MeshInsight#mesh
     */
    readonly mesh?: string;
    /**
     * @stability stable
     * @schema MeshInsight#spec
     */
    readonly spec?: any;
    /**
     * @stability stable
     * @schema MeshInsight#metadata
     */
    readonly metadata?: ApiObjectMetadata;
}
/**
 * Converts an object of type 'MeshInsightProps' to JSON representation.
 */
export declare function toJson_MeshInsightProps(obj: MeshInsightProps | undefined): Record<string, any> | undefined;
/**
 * ProxyTemplate is the Schema for the proxytemplates API.
 *
 * @stability stable
 * @schema ProxyTemplate
 */
export declare class ProxyTemplate extends ApiObject {
    /**
     * Returns the apiVersion and kind for "ProxyTemplate".
     *
     * @stability stable
     */
    static readonly GVK: GroupVersionKind;
    /**
     * Renders a Kubernetes manifest for "ProxyTemplate".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @stability stable
     */
    static manifest(props?: ProxyTemplateProps): any;
    /**
     * Defines a "ProxyTemplate" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @stability stable
     */
    constructor(scope: Construct, id: string, props?: ProxyTemplateProps);
}
/**
 * ProxyTemplate is the Schema for the proxytemplates API.
 *
 * @stability stable
 * @schema ProxyTemplate
 */
export interface ProxyTemplateProps {
    /**
     * @stability stable
     * @schema ProxyTemplate#mesh
     */
    readonly mesh?: string;
    /**
     * @stability stable
     * @schema ProxyTemplate#spec
     */
    readonly spec?: any;
    /**
     * @stability stable
     * @schema ProxyTemplate#metadata
     */
    readonly metadata?: ApiObjectMetadata;
}
/**
 * Converts an object of type 'ProxyTemplateProps' to JSON representation.
 */
export declare function toJson_ProxyTemplateProps(obj: ProxyTemplateProps | undefined): Record<string, any> | undefined;
/**
 * RateLimit is the Schema for the ratelimits API.
 *
 * @stability stable
 * @schema RateLimit
 */
export declare class RateLimit extends ApiObject {
    /**
     * Returns the apiVersion and kind for "RateLimit".
     *
     * @stability stable
     */
    static readonly GVK: GroupVersionKind;
    /**
     * Renders a Kubernetes manifest for "RateLimit".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @stability stable
     */
    static manifest(props?: RateLimitProps): any;
    /**
     * Defines a "RateLimit" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @stability stable
     */
    constructor(scope: Construct, id: string, props?: RateLimitProps);
}
/**
 * RateLimit is the Schema for the ratelimits API.
 *
 * @stability stable
 * @schema RateLimit
 */
export interface RateLimitProps {
    /**
     * @stability stable
     * @schema RateLimit#mesh
     */
    readonly mesh?: string;
    /**
     * @stability stable
     * @schema RateLimit#spec
     */
    readonly spec?: any;
    /**
     * @stability stable
     * @schema RateLimit#metadata
     */
    readonly metadata?: ApiObjectMetadata;
}
/**
 * Converts an object of type 'RateLimitProps' to JSON representation.
 */
export declare function toJson_RateLimitProps(obj: RateLimitProps | undefined): Record<string, any> | undefined;
/**
 * Retry is the Schema for the retries API.
 *
 * @stability stable
 * @schema Retry
 */
export declare class Retry extends ApiObject {
    /**
     * Returns the apiVersion and kind for "Retry".
     *
     * @stability stable
     */
    static readonly GVK: GroupVersionKind;
    /**
     * Renders a Kubernetes manifest for "Retry".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @stability stable
     */
    static manifest(props?: RetryProps): any;
    /**
     * Defines a "Retry" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @stability stable
     */
    constructor(scope: Construct, id: string, props?: RetryProps);
}
/**
 * Retry is the Schema for the retries API.
 *
 * @stability stable
 * @schema Retry
 */
export interface RetryProps {
    /**
     * @stability stable
     * @schema Retry#mesh
     */
    readonly mesh?: string;
    /**
     * @stability stable
     * @schema Retry#spec
     */
    readonly spec?: any;
    /**
     * @stability stable
     * @schema Retry#metadata
     */
    readonly metadata?: ApiObjectMetadata;
}
/**
 * Converts an object of type 'RetryProps' to JSON representation.
 */
export declare function toJson_RetryProps(obj: RetryProps | undefined): Record<string, any> | undefined;
/**
 * ServiceInsight is the Schema for the services insights API.
 *
 * @stability stable
 * @schema ServiceInsight
 */
export declare class ServiceInsight extends ApiObject {
    /**
     * Returns the apiVersion and kind for "ServiceInsight".
     *
     * @stability stable
     */
    static readonly GVK: GroupVersionKind;
    /**
     * Renders a Kubernetes manifest for "ServiceInsight".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @stability stable
     */
    static manifest(props?: ServiceInsightProps): any;
    /**
     * Defines a "ServiceInsight" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @stability stable
     */
    constructor(scope: Construct, id: string, props?: ServiceInsightProps);
}
/**
 * ServiceInsight is the Schema for the services insights API.
 *
 * @stability stable
 * @schema ServiceInsight
 */
export interface ServiceInsightProps {
    /**
     * @stability stable
     * @schema ServiceInsight#mesh
     */
    readonly mesh?: string;
    /**
     * @stability stable
     * @schema ServiceInsight#spec
     */
    readonly spec?: any;
    /**
     * @stability stable
     * @schema ServiceInsight#metadata
     */
    readonly metadata?: ApiObjectMetadata;
}
/**
 * Converts an object of type 'ServiceInsightProps' to JSON representation.
 */
export declare function toJson_ServiceInsightProps(obj: ServiceInsightProps | undefined): Record<string, any> | undefined;
/**
 * Timeout is the Schema for the timeout API.
 *
 * @stability stable
 * @schema Timeout
 */
export declare class Timeout extends ApiObject {
    /**
     * Returns the apiVersion and kind for "Timeout".
     *
     * @stability stable
     */
    static readonly GVK: GroupVersionKind;
    /**
     * Renders a Kubernetes manifest for "Timeout".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @stability stable
     */
    static manifest(props?: TimeoutProps): any;
    /**
     * Defines a "Timeout" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @stability stable
     */
    constructor(scope: Construct, id: string, props?: TimeoutProps);
}
/**
 * Timeout is the Schema for the timeout API.
 *
 * @stability stable
 * @schema Timeout
 */
export interface TimeoutProps {
    /**
     * @stability stable
     * @schema Timeout#mesh
     */
    readonly mesh?: string;
    /**
     * @stability stable
     * @schema Timeout#spec
     */
    readonly spec?: any;
    /**
     * @stability stable
     * @schema Timeout#metadata
     */
    readonly metadata?: ApiObjectMetadata;
}
/**
 * Converts an object of type 'TimeoutProps' to JSON representation.
 */
export declare function toJson_TimeoutProps(obj: TimeoutProps | undefined): Record<string, any> | undefined;
/**
 * TrafficLog is the Schema for the trafficlogs API.
 *
 * @stability stable
 * @schema TrafficLog
 */
export declare class TrafficLog extends ApiObject {
    /**
     * Returns the apiVersion and kind for "TrafficLog".
     *
     * @stability stable
     */
    static readonly GVK: GroupVersionKind;
    /**
     * Renders a Kubernetes manifest for "TrafficLog".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @stability stable
     */
    static manifest(props?: TrafficLogProps): any;
    /**
     * Defines a "TrafficLog" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @stability stable
     */
    constructor(scope: Construct, id: string, props?: TrafficLogProps);
}
/**
 * TrafficLog is the Schema for the trafficlogs API.
 *
 * @stability stable
 * @schema TrafficLog
 */
export interface TrafficLogProps {
    /**
     * @stability stable
     * @schema TrafficLog#mesh
     */
    readonly mesh?: string;
    /**
     * @stability stable
     * @schema TrafficLog#spec
     */
    readonly spec?: any;
    /**
     * @stability stable
     * @schema TrafficLog#metadata
     */
    readonly metadata?: ApiObjectMetadata;
}
/**
 * Converts an object of type 'TrafficLogProps' to JSON representation.
 */
export declare function toJson_TrafficLogProps(obj: TrafficLogProps | undefined): Record<string, any> | undefined;
/**
 * TrafficPermission is the Schema for the trafficpermissions API.
 *
 * @stability stable
 * @schema TrafficPermission
 */
export declare class TrafficPermission extends ApiObject {
    /**
     * Returns the apiVersion and kind for "TrafficPermission".
     *
     * @stability stable
     */
    static readonly GVK: GroupVersionKind;
    /**
     * Renders a Kubernetes manifest for "TrafficPermission".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @stability stable
     */
    static manifest(props?: TrafficPermissionProps): any;
    /**
     * Defines a "TrafficPermission" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @stability stable
     */
    constructor(scope: Construct, id: string, props?: TrafficPermissionProps);
}
/**
 * TrafficPermission is the Schema for the trafficpermissions API.
 *
 * @stability stable
 * @schema TrafficPermission
 */
export interface TrafficPermissionProps {
    /**
     * @stability stable
     * @schema TrafficPermission#mesh
     */
    readonly mesh?: string;
    /**
     * @stability stable
     * @schema TrafficPermission#spec
     */
    readonly spec?: any;
    /**
     * @stability stable
     * @schema TrafficPermission#metadata
     */
    readonly metadata?: ApiObjectMetadata;
}
/**
 * Converts an object of type 'TrafficPermissionProps' to JSON representation.
 */
export declare function toJson_TrafficPermissionProps(obj: TrafficPermissionProps | undefined): Record<string, any> | undefined;
/**
 * TrafficRoute is the Schema for the trafficroutes API.
 *
 * @stability stable
 * @schema TrafficRoute
 */
export declare class TrafficRoute extends ApiObject {
    /**
     * Returns the apiVersion and kind for "TrafficRoute".
     *
     * @stability stable
     */
    static readonly GVK: GroupVersionKind;
    /**
     * Renders a Kubernetes manifest for "TrafficRoute".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @stability stable
     */
    static manifest(props?: TrafficRouteProps): any;
    /**
     * Defines a "TrafficRoute" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @stability stable
     */
    constructor(scope: Construct, id: string, props?: TrafficRouteProps);
}
/**
 * TrafficRoute is the Schema for the trafficroutes API.
 *
 * @stability stable
 * @schema TrafficRoute
 */
export interface TrafficRouteProps {
    /**
     * @stability stable
     * @schema TrafficRoute#mesh
     */
    readonly mesh?: string;
    /**
     * @stability stable
     * @schema TrafficRoute#spec
     */
    readonly spec?: any;
    /**
     * @stability stable
     * @schema TrafficRoute#metadata
     */
    readonly metadata?: ApiObjectMetadata;
}
/**
 * Converts an object of type 'TrafficRouteProps' to JSON representation.
 */
export declare function toJson_TrafficRouteProps(obj: TrafficRouteProps | undefined): Record<string, any> | undefined;
/**
 * TrafficTrace is the Schema for the traffictraces API.
 *
 * @stability stable
 * @schema TrafficTrace
 */
export declare class TrafficTrace extends ApiObject {
    /**
     * Returns the apiVersion and kind for "TrafficTrace".
     *
     * @stability stable
     */
    static readonly GVK: GroupVersionKind;
    /**
     * Renders a Kubernetes manifest for "TrafficTrace".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @stability stable
     */
    static manifest(props?: TrafficTraceProps): any;
    /**
     * Defines a "TrafficTrace" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @stability stable
     */
    constructor(scope: Construct, id: string, props?: TrafficTraceProps);
}
/**
 * TrafficTrace is the Schema for the traffictraces API.
 *
 * @stability stable
 * @schema TrafficTrace
 */
export interface TrafficTraceProps {
    /**
     * @stability stable
     * @schema TrafficTrace#mesh
     */
    readonly mesh?: string;
    /**
     * @stability stable
     * @schema TrafficTrace#spec
     */
    readonly spec?: any;
    /**
     * @stability stable
     * @schema TrafficTrace#metadata
     */
    readonly metadata?: ApiObjectMetadata;
}
/**
 * Converts an object of type 'TrafficTraceProps' to JSON representation.
 */
export declare function toJson_TrafficTraceProps(obj: TrafficTraceProps | undefined): Record<string, any> | undefined;
/**
 * VirtualOutbound is the Schema for the virtualoutbounds API.
 *
 * @stability stable
 * @schema VirtualOutbound
 */
export declare class VirtualOutbound extends ApiObject {
    /**
     * Returns the apiVersion and kind for "VirtualOutbound".
     *
     * @stability stable
     */
    static readonly GVK: GroupVersionKind;
    /**
     * Renders a Kubernetes manifest for "VirtualOutbound".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @stability stable
     */
    static manifest(props?: VirtualOutboundProps): any;
    /**
     * Defines a "VirtualOutbound" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @stability stable
     */
    constructor(scope: Construct, id: string, props?: VirtualOutboundProps);
}
/**
 * VirtualOutbound is the Schema for the virtualoutbounds API.
 *
 * @stability stable
 * @schema VirtualOutbound
 */
export interface VirtualOutboundProps {
    /**
     * @stability stable
     * @schema VirtualOutbound#mesh
     */
    readonly mesh?: string;
    /**
     * @stability stable
     * @schema VirtualOutbound#spec
     */
    readonly spec?: any;
    /**
     * @stability stable
     * @schema VirtualOutbound#metadata
     */
    readonly metadata?: ApiObjectMetadata;
}
/**
 * Converts an object of type 'VirtualOutboundProps' to JSON representation.
 */
export declare function toJson_VirtualOutboundProps(obj: VirtualOutboundProps | undefined): Record<string, any> | undefined;
/**
 * Zone is the Schema for the zone API.
 *
 * @stability stable
 * @schema Zone
 */
export declare class Zone extends ApiObject {
    /**
     * Returns the apiVersion and kind for "Zone".
     *
     * @stability stable
     */
    static readonly GVK: GroupVersionKind;
    /**
     * Renders a Kubernetes manifest for "Zone".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @stability stable
     */
    static manifest(props?: ZoneProps): any;
    /**
     * Defines a "Zone" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @stability stable
     */
    constructor(scope: Construct, id: string, props?: ZoneProps);
}
/**
 * Zone is the Schema for the zone API.
 *
 * @stability stable
 * @schema Zone
 */
export interface ZoneProps {
    /**
     * @stability stable
     * @schema Zone#mesh
     */
    readonly mesh?: string;
    /**
     * @stability stable
     * @schema Zone#spec
     */
    readonly spec?: any;
    /**
     * @stability stable
     * @schema Zone#metadata
     */
    readonly metadata?: ApiObjectMetadata;
}
/**
 * Converts an object of type 'ZoneProps' to JSON representation.
 */
export declare function toJson_ZoneProps(obj: ZoneProps | undefined): Record<string, any> | undefined;
/**
 * ZoneIngress is the Schema for the zone ingress API.
 *
 * @stability stable
 * @schema ZoneIngress
 */
export declare class ZoneIngress extends ApiObject {
    /**
     * Returns the apiVersion and kind for "ZoneIngress".
     *
     * @stability stable
     */
    static readonly GVK: GroupVersionKind;
    /**
     * Renders a Kubernetes manifest for "ZoneIngress".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @stability stable
     */
    static manifest(props?: ZoneIngressProps): any;
    /**
     * Defines a "ZoneIngress" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @stability stable
     */
    constructor(scope: Construct, id: string, props?: ZoneIngressProps);
}
/**
 * ZoneIngress is the Schema for the zone ingress API.
 *
 * @stability stable
 * @schema ZoneIngress
 */
export interface ZoneIngressProps {
    /**
     * @stability stable
     * @schema ZoneIngress#mesh
     */
    readonly mesh?: string;
    /**
     * @stability stable
     * @schema ZoneIngress#spec
     */
    readonly spec?: any;
    /**
     * @stability stable
     * @schema ZoneIngress#metadata
     */
    readonly metadata?: ApiObjectMetadata;
}
/**
 * Converts an object of type 'ZoneIngressProps' to JSON representation.
 */
export declare function toJson_ZoneIngressProps(obj: ZoneIngressProps | undefined): Record<string, any> | undefined;
/**
 * ZoneIngressInsight is the Schema for the zone ingress insight API.
 *
 * @stability stable
 * @schema ZoneIngressInsight
 */
export declare class ZoneIngressInsight extends ApiObject {
    /**
     * Returns the apiVersion and kind for "ZoneIngressInsight".
     *
     * @stability stable
     */
    static readonly GVK: GroupVersionKind;
    /**
     * Renders a Kubernetes manifest for "ZoneIngressInsight".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @stability stable
     */
    static manifest(props?: ZoneIngressInsightProps): any;
    /**
     * Defines a "ZoneIngressInsight" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @stability stable
     */
    constructor(scope: Construct, id: string, props?: ZoneIngressInsightProps);
}
/**
 * ZoneIngressInsight is the Schema for the zone ingress insight API.
 *
 * @stability stable
 * @schema ZoneIngressInsight
 */
export interface ZoneIngressInsightProps {
    /**
     * @stability stable
     * @schema ZoneIngressInsight#mesh
     */
    readonly mesh?: string;
    /**
     * @stability stable
     * @schema ZoneIngressInsight#spec
     */
    readonly spec?: any;
    /**
     * @stability stable
     * @schema ZoneIngressInsight#metadata
     */
    readonly metadata?: ApiObjectMetadata;
}
/**
 * Converts an object of type 'ZoneIngressInsightProps' to JSON representation.
 */
export declare function toJson_ZoneIngressInsightProps(obj: ZoneIngressInsightProps | undefined): Record<string, any> | undefined;
/**
 * ZoneInsight is the Schema for the zone insight API.
 *
 * @stability stable
 * @schema ZoneInsight
 */
export declare class ZoneInsight extends ApiObject {
    /**
     * Returns the apiVersion and kind for "ZoneInsight".
     *
     * @stability stable
     */
    static readonly GVK: GroupVersionKind;
    /**
     * Renders a Kubernetes manifest for "ZoneInsight".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @stability stable
     */
    static manifest(props?: ZoneInsightProps): any;
    /**
     * Defines a "ZoneInsight" API object.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @stability stable
     */
    constructor(scope: Construct, id: string, props?: ZoneInsightProps);
}
/**
 * ZoneInsight is the Schema for the zone insight API.
 *
 * @stability stable
 * @schema ZoneInsight
 */
export interface ZoneInsightProps {
    /**
     * @stability stable
     * @schema ZoneInsight#mesh
     */
    readonly mesh?: string;
    /**
     * @stability stable
     * @schema ZoneInsight#spec
     */
    readonly spec?: any;
    /**
     * @stability stable
     * @schema ZoneInsight#metadata
     */
    readonly metadata?: ApiObjectMetadata;
}
/**
 * Converts an object of type 'ZoneInsightProps' to JSON representation.
 */
export declare function toJson_ZoneInsightProps(obj: ZoneInsightProps | undefined): Record<string, any> | undefined;
/**
 * @stability stable
 */
export interface KumaOptions {
    /**
     * @stability stable
     */
    readonly mesh?: string;
    /**
     * @stability stable
     */
    readonly serviceWhitelist?: string[];
    /**
     * @stability stable
     */
    readonly gatewayWhitelist?: string[];
}
/**
 * @stability stable
 */
export interface TypedKumaExternalServiceOptions {
    /**
     * @stability stable
     */
    readonly mesh: string;
    /**
     * @stability stable
     */
    readonly serviceName: string;
    /**
     * @stability stable
     */
    readonly serviceProtocol: string;
    /**
     * @stability stable
     */
    readonly serviceAddress: string;
}
/**
 * @stability stable
 */
export interface TypedKumaTrafficPermission {
    /**
     * @stability stable
     */
    readonly mesh: string;
    /**
     * @stability stable
     */
    readonly destination: string;
    /**
     * @stability stable
     */
    readonly destinationLabel?: string;
    /**
     * @stability stable
     */
    readonly sources: string[];
}
/**
 * @stability stable
 */
export declare class Kuma extends Construct {
    /**
     * @stability stable
     */
    constructor(scope: Construct, name: string, opts: KumaOptions);
}
/**
 * @stability stable
 */
export declare class TypedKumaExternalService extends Construct {
    /**
     * @stability stable
     */
    constructor(scope: Construct, name: string, opts: TypedKumaExternalServiceOptions);
}
/**
 * @stability stable
 */
export declare class TypedTrafficPermission extends Construct {
    /**
     * @stability stable
     */
    constructor(scope: Construct, name: string, opts: TypedKumaTrafficPermission);
}
