"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LogQueryWidget = exports.LogQueryVisualizationType = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const widget_1 = require("./widget");
/**
 * Types of view
 */
var LogQueryVisualizationType;
(function (LogQueryVisualizationType) {
    /**
     * Table view
     */
    LogQueryVisualizationType["TABLE"] = "table";
    /**
     * Line view
     */
    LogQueryVisualizationType["LINE"] = "line";
    /**
     * Stacked area view
     */
    LogQueryVisualizationType["STACKEDAREA"] = "stackedarea";
    /**
     * Bar view
     */
    LogQueryVisualizationType["BAR"] = "bar";
    /**
     * Pie view
     */
    LogQueryVisualizationType["PIE"] = "pie";
})(LogQueryVisualizationType = exports.LogQueryVisualizationType || (exports.LogQueryVisualizationType = {}));
/**
 * Display query results from Logs Insights
 */
class LogQueryWidget extends widget_1.ConcreteWidget {
    constructor(props) {
        super(props.width || 6, props.height || 6);
        jsiiDeprecationWarnings._aws_cdk_aws_cloudwatch_LogQueryWidgetProps(props);
        this.props = props;
        if (props.logGroupNames.length === 0) {
            throw new Error('Specify at least one log group name.');
        }
        if (!!props.queryString === !!props.queryLines) {
            throw new Error('Specify exactly one of \'queryString\' and \'queryLines\'');
        }
    }
    toJson() {
        const sources = this.props.logGroupNames.map(l => `SOURCE '${l}'`).join(' | ');
        const query = this.props.queryLines
            ? this.props.queryLines.join('\n| ')
            : this.props.queryString;
        const properties = {
            view: this.props.view ? this.props.view : LogQueryVisualizationType.TABLE,
            title: this.props.title,
            region: this.props.region || cdk.Aws.REGION,
            query: `${sources} | ${query}`,
        };
        // adding stacked property in case of LINE or STACKEDAREA
        if (this.props.view === LogQueryVisualizationType.LINE || this.props.view === LogQueryVisualizationType.STACKEDAREA) {
            // assign the right native view value. both types share the same value
            properties.view = 'timeSeries',
                properties.stacked = this.props.view === LogQueryVisualizationType.STACKEDAREA ? true : false;
        }
        return [{
                type: 'log',
                width: this.width,
                height: this.height,
                x: this.x,
                y: this.y,
                properties: properties,
            }];
    }
}
exports.LogQueryWidget = LogQueryWidget;
_a = JSII_RTTI_SYMBOL_1;
LogQueryWidget[_a] = { fqn: "@aws-cdk/aws-cloudwatch.LogQueryWidget", version: "1.147.0" };
//# sourceMappingURL=data:application/json;base64,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